// BIXOLON_SampleProgramDlg.cpp : implementation file
//

#include "stdafx.h"
#include "BIXOLON_SampleProgram.h"
#include "BIXOLON_SampleProgramDlg.h"

#include "BXLLIB.H"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBIXOLON_SampleProgramDlg dialog

CBIXOLON_SampleProgramDlg::CBIXOLON_SampleProgramDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBIXOLON_SampleProgramDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBIXOLON_SampleProgramDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CBIXOLON_SampleProgramDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBIXOLON_SampleProgramDlg)
	DDX_Control(pDX, IDC_COMBO_DENSITY, m_cmbDensity);
	DDX_Control(pDX, IDC_COMBO_SPEED, m_cmbSpeed);
	DDX_Control(pDX, IDC_COMBO_PRTLIST, m_cmbPrtList);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBIXOLON_SampleProgramDlg, CDialog)
	//{{AFX_MSG_MAP(CBIXOLON_SampleProgramDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_PRTSEARCH, OnPrtsearch)
	ON_BN_CLICKED(IDC_BUTTON_PRINT, OnPrintLable)
	ON_EN_KILLFOCUS(IDC_EDIT_P_WIDTH, OnKillfocusEditPWidth)
	ON_EN_KILLFOCUS(IDC_EDIT_P_HEIGHT, OnKillfocusEditPHeight)
	ON_EN_KILLFOCUS(IDC_EDIT_MARGIN_X, OnKillfocusEditMarginX)
	ON_EN_KILLFOCUS(IDC_EDIT_MARGIN_Y, OnKillfocusEditMarginY)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBIXOLON_SampleProgramDlg message handlers

BOOL CBIXOLON_SampleProgramDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	InitControls();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CBIXOLON_SampleProgramDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CBIXOLON_SampleProgramDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CBIXOLON_SampleProgramDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CBIXOLON_SampleProgramDlg::InitControls()
{
	// Get the BXLLIB Dll version 
	TCHAR szDllVersion[256] = {NULL, };
	CString strValue = _T("");
	if( GetDllVersion(szDllVersion) == TRUE ){
		strValue.Format(_T("Version %s"), szDllVersion);
		//SetDlgItemText(IDC_STATIC_DLLVERSION, _T("Version ") + (LPSTR)(LPCTSTR)szDllVersion);
		SetDlgItemText(IDC_STATIC_DLLVERSION, strValue);
	}
	else
		SetDlgItemText(IDC_STATIC_DLLVERSION, _T("Unknown"));

	// Get the BIXOLON Printer List (Driver is Installed)
	BOOL bGetPrinters = GetInstalledPrinter();
	GetDlgItem(IDC_BUTTON_PRINT)->EnableWindow(bGetPrinters);
	
	// Speed 
	m_cmbSpeed.SetCurSel(SPEED_50);
	// Density
	m_cmbDensity.SetCurSel(14 - 1);

	// Paper size
	// Default 4x6 inch -> (4*25.4) x (6*25.4) mm
	DOUBLE dbValue;
	
	dbValue = 4 * 25.4;
	strValue.Format(_T("%3.3f"), dbValue);
	// paper width
	SetDlgItemText(IDC_EDIT_P_WIDTH, strValue);

	dbValue = 6 * 25.4;
	strValue.Format(_T("%3.3f"), dbValue);
	// paper height
	SetDlgItemText(IDC_EDIT_P_HEIGHT, strValue);

	// x margin 
	SetDlgItemText(IDC_EDIT_MARGIN_X, _T("0"));
	//  y margin
	SetDlgItemText(IDC_EDIT_MARGIN_Y, _T("0"));

	// Media type
	((CButton*)GetDlgItem(IDC_RADIO_MT_DT))->SetCheck(TRUE);
	// Sensor type
	((CButton*)GetDlgItem(IDC_RADIO_ST_GAP))->SetCheck(TRUE);
	// Cutter
	((CButton*)GetDlgItem(IDC_CHECK_CUTTER))->SetCheck(FALSE);
	// Reverse-feeding
	((CButton*)GetDlgItem(IDC_CHECK_BACKFEED))->SetCheck(TRUE);

	UpdateData(FALSE);
}

// Get the BIXOLON Printer List (Driver is Installed)
BOOL CBIXOLON_SampleProgramDlg::GetInstalledPrinter()
{
	TCHAR szPrinterList[4096] = {NULL, };
		
	m_cmbPrtList.ResetContent();
	
	if( GetBIXOLON_PrinterList(szPrinterList) <=0 ) return FALSE;

	CString strValue = _T("");
	TCHAR Seps[] = "^";
	TCHAR *szToken = NULL;

	szToken = _tcstok(szPrinterList, Seps);

	while( szToken != NULL )
	{
		strValue = _T("");

		strValue = ((CString)szToken);
		strValue.TrimLeft(); strValue.TrimRight();

		if( strValue.IsEmpty() ){
			szToken = _tcstok(NULL, Seps);
			continue;
		}

		m_cmbPrtList.AddString(strValue);

		szToken = _tcstok(NULL, Seps);
	}

	m_cmbPrtList.SetCurSel(0);
	
	UpdateData(FALSE);

	return TRUE;
}

void CBIXOLON_SampleProgramDlg::OnPrtsearch() 
{
	// Get the BIXOLON Printer List (Driver is Installed)
	BOOL bGetPrinters = GetInstalledPrinter();
	GetDlgItem(IDC_BUTTON_PRINT)->EnableWindow(bGetPrinters);	
}

void CBIXOLON_SampleProgramDlg::OnKillfocusEditPWidth() 
{
	// TODO: Add your control notification handler code here

	UpdateData(TRUE);

	DOUBLE dbValue;
	CString strValue = _T("");

	GetDlgItemText(IDC_EDIT_P_WIDTH, strValue);
	dbValue = atof(strValue);
	
	strValue.Format(_T("%3.3f"), dbValue);
	SetDlgItemText(IDC_EDIT_P_WIDTH, strValue);

	UpdateData(FALSE);
}

void CBIXOLON_SampleProgramDlg::OnKillfocusEditPHeight() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	
	DOUBLE dbValue;
	CString strValue = _T("");
	
	GetDlgItemText(IDC_EDIT_P_HEIGHT, strValue);
	dbValue = atof(strValue);
	
	strValue.Format(_T("%3.3f"), dbValue);
	SetDlgItemText(IDC_EDIT_P_HEIGHT, strValue);
	
	UpdateData(FALSE);
	
}

void CBIXOLON_SampleProgramDlg::OnKillfocusEditMarginX() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	
	DOUBLE dbValue;
	CString strValue = _T("");
	
	GetDlgItemText(IDC_EDIT_MARGIN_X, strValue);
	dbValue = atof(strValue);
	
	strValue.Format(_T("%3.3f"), dbValue);
	SetDlgItemText(IDC_EDIT_MARGIN_X, strValue);
	
	UpdateData(FALSE);
	
}

void CBIXOLON_SampleProgramDlg::OnKillfocusEditMarginY() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	
	DOUBLE dbValue;
	CString strValue = _T("");
	
	GetDlgItemText(IDC_EDIT_MARGIN_Y, strValue);
	dbValue = atof(strValue);
	
	strValue.Format(_T("%3.3f"), dbValue);
	SetDlgItemText(IDC_EDIT_MARGIN_Y, strValue);
	
	UpdateData(FALSE);
	
}

// Print sample label
void CBIXOLON_SampleProgramDlg::OnPrintLable() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);

	TCHAR szValue[256] = {NULL, };
	CString strValue = _T("");
	
	int nPaper_Width = 0, nPaper_Height = 0, nMarginX = 0, nMarginY = 0;
	int nSpeed = SPEED_50, nDensity = 14;
	BOOL bAutoCut = FALSE, bReverseFeeding = TRUE;
	int nSensorType = GAP; 

	TCHAR szPrinterName[256] = {NULL, };
	CString strPrinterName = _T("");

	GetDlgItemText(IDC_COMBO_PRTLIST, strPrinterName);
	wsprintf(szPrinterName, _T("%s"), strPrinterName);

	// BIXOLON SLP-770II, BIXOLON SLP-770III
	// BIXOLON SLP-D420, BIXOLON SLP-D423, BIXOLON SLP-T400, BIXOLON SLP-T403, 
    // BIXOLON SLP-TX400, BIXOLON SLP-TX403 ...
	if( ConnectPrinter(szPrinterName) == FALSE )
		return ;

	int MM2D = 8;	// mm to dot
	// 203 DPI : 1mm = 8 dots
    // 300 DPI : 1mm = 12 dots
	MM2D = GetPrinterResolution() < 300 ? 8 : 12;

	GetDlgItemText(IDC_EDIT_P_WIDTH, strValue);
	nPaper_Width = (int)((atof(strValue)) * MM2D);

	GetDlgItemText(IDC_EDIT_P_HEIGHT, strValue);
	nPaper_Height = (int)((atof(strValue)) * MM2D);

	GetDlgItemText(IDC_EDIT_MARGIN_X, strValue);
	nMarginX = (int)((atof(strValue)) * MM2D);

	GetDlgItemText(IDC_EDIT_MARGIN_Y, strValue);
	nMarginY = (int)((atof(strValue)) * MM2D);

	nSpeed = m_cmbSpeed.GetCurSel();
	nDensity = GetDlgItemInt(IDC_COMBO_DENSITY);

	bAutoCut = ((CButton*)GetDlgItem(IDC_CHECK_CUTTER))->GetCheck();
	bReverseFeeding = ((CButton*)GetDlgItem(IDC_CHECK_BACKFEED))->GetCheck();

	if( ((CButton*)GetDlgItem(IDC_RADIO_ST_GAP))->GetCheck() ) nSensorType = GAP;
	else if( ((CButton*)GetDlgItem(IDC_RADIO_ST_BM))->GetCheck() ) nSensorType = BLACKMARK;
	else nSensorType = CONTINUOUS;

	//	Set the label start
    StartLabel();

    //	Set Label and Printer
    //SetConfigOfPrinter(SPEED_50, 17, TOP, FALSE, 0, TRUE);
    SetConfigOfPrinter(nSpeed, nDensity, TOP, bAutoCut, 0, bReverseFeeding);

    /* 
       1 Inch : 25.4mm
       1 mm   :  8 Dot in 203 DPI such as TX400, T400, D420, D220, SRP-770, SRP-770II
       1 mm   : 12 Dot in 300 DPI such as TX403, T403, D423, D223
       4 Inch : 25.4  * 4 * 8 = 812.8
       6 Inch : 25.4  * 4 * 8 = 1219.2
    */

    //SetPaper(16, 16, 813, 1220, GAP, 0, 16); // 4 inch (Width) * 6 inch (Hiehgt)
    SetPaper(nMarginX, nMarginY, nPaper_Width, nPaper_Height, nSensorType, 0, 16); // 4 inch (Width) * 6 inch (Hiehgt)            

    if( ((CButton*)GetDlgItem(IDC_RADIO_MT_DT))->GetCheck() ) // Direct thermal
        PrintDirect("STd");
    else // Thermal transfer
        PrintDirect("STt");

    //	Clear Buffer of Printer
    ClearBuffer();

	// Draw BOX (Fill color is black)
    PrintBlock(370, 40, 760, 150, LINE_OVER_WRITING, 0);

    //	Draw Lines
    PrintBlock(18, 164, 798, 170, LINE_OVER_WRITING, 0);
    PrintBlock(18, 410, 784, 415, LINE_OVER_WRITING, 0);
    //PrintBlock(553, 170, 558, 413, LINE_OVER_WRITING, 0);
    PrintBlock(548, 170, 553, 413, LINE_OVER_WRITING, 0);
    PrintBlock(18, 616, 784, 621, LINE_OVER_WRITING, 0);
    PrintBlock(20, 781, 786, 786, LINE_OVER_WRITING, 0);
    PrintBlock(18, 928, 784, 933, LINE_OVER_WRITING, 0);
    PrintBlock(241, 783, 246, 932, LINE_OVER_WRITING, 0);
    PrintBlock(486, 784, 491, 933, LINE_OVER_WRITING, 0);


    // Prints string using TrueFont
    //  P1 : Horizontal position (X) [dot]
    //  P2 : Vertical position (Y) [dot]
    //  P3 : Font Name
    //  P4 : Font Size
    //  P5 : Rotation : (0 : 0 degree , 1 : 90 degree, 2 : 180 degree, 3 : 270 degree)
    //  P6 : Italic
    //  P7 : Bold
    //  P8 : Underline
    PrintTrueFontLib(22, 100, "Arial", 16, 0, true, true, false, "Sample Label-1");

    //Print string using Vector Font
    //  P1 : Horizontal position (X) [dot]
    //  P2 : Vertical position (Y) [dot]
    //  P3 : Font selection
    //                  U: ASCII (1Byte code)
    //                  K: KS5601 (2Byte code)
    //                  B: BIG5 (2Byte code)
    //                  G: GB2312 (2Byte code)
    //                  J: Shift-JIS (2Byte code)
    // P4  : Font width (W)[dot]
    // P5  : Font height (H)[dot]
    // P6  : Right-side character spacing [dot], Plus (+)/Minus (-) option can be used. Ex) 5, +3, -10	
    // P7  : Bold
    // P8  : Reverse printing
    // P9  : Text style  (N : Normal, I : Italic)
    // P10 : Rotation (0 ~ 3)
    // P11 : Text Alignment (Optional)
    // P12 : Text string write direction
    // P13 : data to print
    // ※ : Third parameter, 'ASCII' must be set if Bixolon printer is SLP-T400, SLP-T403, SRP-770 and SRP-770II.
    //PrintVectorFont(22, 65, ASCII, 34, 34, "0", false, false, false, ROTATE_0, LEFTALIGN, LEFTTORIGHT, "Sample Label-2");

    PrintDeviceFont(400, 55, ENG_48X76, 1, 1, ROTATE_0, false, "BIXOLON");

    PrintDeviceFont(20, 174, ENG_24X38, 1, 1, ROTATE_0, false, "SHIP TO:");
    PrintDeviceFont(20, 234, ENG_19X30, 1, 1, ROTATE_0, true, "BIXOLON");
    PrintDeviceFont(20, 280, ENG_16X25, 1, 1, ROTATE_0, false, "7th FL, MiraeAsset Venture Tower,");
    PrintDeviceFont(20, 310, ENG_16X25, 1, 1, ROTATE_0, false, "685, Sampyeong-dong, Bundang-gu,");
    PrintDeviceFont(20, 340, ENG_16X25, 1, 1, ROTATE_0, false, "Seongnam-si, Gyeonggi-do,");
    PrintDeviceFont(20, 370, ENG_16X25, 1, 1, ROTATE_0, false, "463-400, KOREA");
    
    PrintDeviceFont(26, 421, ENG_12X20, 1, 1, ROTATE_0, false, "POSTAL CODE");
    PrintDeviceFont(503, 798, ENG_12X20, 1, 1, ROTATE_0, false, "DESTINATION");
    PrintDeviceFont(42, 841, ENG_32X50, 1, 1, ROTATE_0, true, "30 Kg");
    PrintDeviceFont(25, 798, ENG_12X20, 1, 1, ROTATE_0, false, "WEIGHT:");
    PrintDeviceFont(259, 798, ENG_12X20, 1, 1, ROTATE_0, false, "DELIVERY NO:");
    PrintDeviceFont(23, 630, ENG_12X20, 1, 1, ROTATE_0, false, "AWB:");
    PrintDeviceFont(274, 841, ENG_32X50, 1, 1, ROTATE_0, true, "425518");
    PrintDeviceFont(104, 627, ENG_19X30, 1, 1, ROTATE_0, false, "8741493121");
    PrintDeviceFont(565, 841, ENG_32X50, 1, 1, ROTATE_0, true, "ICN");



    //	Prints 1D Bar-codes
    Print1DBarcode(69, 458, CODE39, 4, 8, 137, ROTATE_0, true, "1234567890");
    Print1DBarcode(127, 662, CODE93, 4, 8, 90, ROTATE_0, true, "8741493121");

    //	Prints a MAXICODE 
    TCHAR Direct_MaxiCode_2DBarcode_Cmd[256] = "B2555,180,M,0,'999,840,06810,7317,BIXOLON LABEL PRINTER'";
    PrintDirect(Direct_MaxiCode_2DBarcode_Cmd);

    //	Prints a PDF417 
    TCHAR Direct_PDF_2DBarcocde_Cmd[256] = "B2200,945,P,8,8,0,0,0,1,2,14,0,'BIXOLON Label Printer, This is for test.'";
    PrintDirect(Direct_PDF_2DBarcocde_Cmd);

    PrintCircle(10, 1055, 3, 2);


    // Prints a QRCode
    //  P1 : Horizontal position (X) [dot]
    //  P2 : Vertical position (Y) [dot]
    //  P3 : MODEL selection (1, 2)
    //  P4 : ECC Level (1 ~ 4)
    //  P5 : Size of QRCode (1 ~ 4)
    //  P6 : Rotation (0 ~ 3)
    //  P7 : data to print
    TCHAR QRCode_data[256] = {"QRCode sample test 123"};//"家裸多羅馬바 123";//가나다라마바사아자차카타파하";// "QRCode with UTF-8 Encoding";
    PrintQRCode(22, 940, QRMODEL_2, QRECCLEVEL_M, QRSIZE_4, ROTATE_0, QRCode_data);


    // Print Image
    PrintImageLib(200, 1035, "free.bmp", DITHER_1, false);
    PrintImageLib(450, 1035, "BIXOLON.bmp", DITHER_2, false);

    //	Print Command
    Prints(1, 1);

    //	Set the Label End
    EndLabel();

    //	Disconnect Printer Driver
    DisconnectPrinter();
	
}