﻿Imports System
Imports System.IO
Imports System.Text

Public Class frmMain


    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        InitControls()

    End Sub


    Private Sub InitControls()

        Try
            Dim sbDllVersion As New System.Text.StringBuilder(256)
            If GetDllVersion(sbDllVersion) = True Then
                lblDllVersion.Text = "Version " + sbDllVersion.ToString()
            Else
                lblDllVersion.Text = "Unknown"
            End If
            sbDllVersion = Nothing

            btnPrint.Enabled = GetInstalledPrinter()

            ' Paper size 
            ' Default 4x6 inch -> (4*25.4) x (6*25.4) mm
            Dim dValue As Double = 4 * 25.4
            txtP_Width.Text = dValue.ToString("###0.###")
            dValue = 6 * 25.4
            txtP_Height.Text = dValue.ToString("###0.###")

            txtMargin_X.Text = "0"
            txtMargin_Y.Text = "0"

            cmbSpeed.SelectedIndex = SPEED_50
            cmbDensity.SelectedIndex = (14 - 1)

        Catch ex As Exception
            MsgBox(ex.ToString)
        End Try

    End Sub

    ' 
    Private Function GetInstalledPrinter() As Boolean

        Try
            Cursor.Current = Cursors.WaitCursor

            cmbPrtList.Items.Clear()


            Dim sbPrinters As New StringBuilder(4096)
            If GetBIXOLON_PrinterList(sbPrinters) <= 0 Then Return False

            Dim seps As String = "^"
            Dim strPrtList() As String = sbPrinters.ToString().Split(seps)
            cmbPrtList.Items.AddRange(strPrtList)


            If cmbPrtList.Items.Count > 0 Then
                cmbPrtList.SelectedIndex = 0
                Return True
            End If

        Catch ex As Exception
            MsgBox(ex.ToString())
        Finally
            Cursor.Current = Cursors.Default
        End Try
        

        Return False

    End Function

    Private Sub btnResearch_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnResearch.Click
        btnPrint.Enabled = GetInstalledPrinter()
    End Sub

    Private Sub btnPrint_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPrint.Click
        Try
            If txtP_Width.Text.Equals("") OrElse txtP_Width.Text.Equals(".") Then txtP_Width.Text = "0"
            If txtP_Height.Text.Equals("") OrElse txtP_Height.Text.Equals(".") Then txtP_Height.Text = "0"

            If txtMargin_X.Text.Equals("") OrElse txtMargin_X.Text.Equals(".") Then txtMargin_X.Text = "0"
            If txtMargin_Y.Text.Equals("") OrElse txtMargin_Y.Text.Equals(".") Then txtMargin_Y.Text = "0"
        Catch ex As Exception
            MsgBox(ex.ToString)
            Exit Sub
        End Try


        Dim strPrinterName As String = cmbPrtList.Text

        ' BIXOLON SLP-770II, BIXOLON SLP-770III
        ' BIXOLON SLP-D420, BIXOLON SLP-D423, BIXOLON SLP-T400, BIXOLON SLP-T403, 
        ' BIXOLON SLP-TX400, BIXOLON SLP-TX403 ...
        ' ...
        If ConnectPrinter(strPrinterName) = False Then Exit Sub

        Dim MM2D As Integer = 8 ' mm to dot
        ' 203 DPI : 1mm = 8 dots
        ' 300 DPI : 1mm = 12 dots
        MM2D = IIf(GetPrinterResolution() < 300, 8, 12)

        Dim nPaper_Width As Integer = Convert.ToInt32(Double.Parse(txtP_Width.Text) * MM2D)
        Dim nPaper_Height As Integer = Convert.ToInt32(Double.Parse(txtP_Height.Text) * MM2D)
        Dim nMarginX As Integer = Convert.ToInt32(Double.Parse(txtMargin_X.Text) * MM2D)
        Dim nMarginY As Integer = Convert.ToInt32(Double.Parse(txtMargin_Y.Text) * MM2D)

        Dim nSpeed As Integer = cmbSpeed.SelectedIndex
        Dim nDensity As Integer = Convert.ToInt32(cmbDensity.Text)

        Dim bAutoCut As Boolean = chkCutter.Checked
        Dim bReverseFeeding As Boolean = chkRevFeeding.Checked

        Dim nSensorType As Integer = GAP
        If rdoBmark.Checked Then
            nSensorType = BLACKMARK
        ElseIf rdoContinuous.Checked Then
            nSensorType = CONTINUOUS
        End If

        '	Set the label start
        StartLabel()

        '	Set Label and Printer
        'SetConfigOfPrinter(SPEED_50, 17, TOP, false, 0, true);
        SetConfigOfPrinter(nSpeed, nDensity, ORIENTATION_TOP, bAutoCut, 0, bReverseFeeding)

        '1 Inch : 25.4mm
        '1 mm   :  8 Dot in 203 DPI such as TX400, T400, D420, D220, SRP-770, SRP-770II
        '1 mm   : 12 Dot in 300 DPI such as TX403, T403, D423, D223
        '4 Inch : 25.4  * 4 * 8 = 812.8
        '6 Inch : 25.4  * 4 * 8 = 1219.2

        'SetPaper(16, 16, 813, 1220, GAP, 0, 16); ' 4 inch (Width) * 6 inch (Hiehgt)
        SetPaper(nMarginX, nMarginY, nPaper_Width, nPaper_Height, nSensorType, 0, 16) ' 4 inch (Width) * 6 inch (Hiehgt)            

        If rdoDt.Checked Then ' Direct thermal
            PrintDirect("STd")
        Else ' Thermal transfer
            PrintDirect("STt")
        End If

        '	Clear Buffer of Printer
        ClearBuffer()

        ' Draw BOX (Fill color is black)
        PrintBlock(370, 40, 760, 150, LINE_OVER_WRITING, 0)

        ' Draw Lines
        PrintBlock(18, 164, 798, 170, LINE_OVER_WRITING, 0)
        PrintBlock(18, 410, 784, 415, LINE_OVER_WRITING, 0)
        ' PrintBlock(553, 170, 558, 413, LINE_OVER_WRITING, 0)
        PrintBlock(548, 170, 553, 413, LINE_OVER_WRITING, 0)
        PrintBlock(18, 616, 784, 621, LINE_OVER_WRITING, 0)
        PrintBlock(20, 781, 786, 786, LINE_OVER_WRITING, 0)
        PrintBlock(18, 928, 784, 933, LINE_OVER_WRITING, 0)
        PrintBlock(241, 783, 246, 932, LINE_OVER_WRITING, 0)
        PrintBlock(486, 784, 491, 933, LINE_OVER_WRITING, 0)


        ' Prints string using TrueFont
        '  P1 : Horizontal position (X) [dot]
        '  P2 : Vertical position (Y) [dot]
        '  P3 : Font Name
        '  P4 : Font Size
        '  P5 : Rotation : (0 : 0 degree , 1 : 90 degree, 2 : 180 degree, 3 : 270 degree)
        '  P6 : Italic
        '  P7 : Bold
        '  P8 : Underline
        PrintTrueFontLib(22, 100, "Arial", 16, 0, True, True, False, "Sample Label-1")

        'Print string using Vector Font
        '  P1 : Horizontal position (X) [dot]
        '  P2 : Vertical position (Y) [dot]
        '  P3 : Font selection
        '                  U: ASCII (1Byte code)
        '                  K: KS5601 (2Byte code)
        '                  B: BIG5 (2Byte code)
        '                  G: GB2312 (2Byte code)
        '                  J: Shift-JIS (2Byte code)
        ' P4  : Font width (W)[dot]
        ' P5  : Font height (H)[dot]
        ' P6  : Right-side character spacing [dot], Plus (+)/Minus (-) option can be used. Ex) 5, +3, -10	
        ' P7  : Bold
        ' P8  : Reverse printing
        ' P9  : Text style  (N : Normal, I : Italic)
        ' P10 : Rotation (0 ~ 3)
        ' P11 : Text Alignment (Optional)
        ' P12 : Text string write direction
        ' P13 : data to print
        ' ※ : Third parameter, 'ASCII' must be set if Bixolon printer is SLP-T400, SLP-T403, SRP-770 and SRP-770II.
        'PrintVectorFont(22, 65, ASCII, 34, 34, "0", false, false, false, ROTATE_0, LEFTALIGN, LEFTTORIGHT, "Sample Label-2")

        PrintDeviceFont(400, 55, ENG_48X76, 1, 1, ROTATE_0, False, "BIXOLON")

        PrintDeviceFont(20, 174, ENG_24X38, 1, 1, ROTATE_0, False, "SHIP TO:")
        PrintDeviceFont(20, 234, ENG_19X30, 1, 1, ROTATE_0, True, "BIXOLON")
        PrintDeviceFont(20, 280, ENG_16X25, 1, 1, ROTATE_0, False, "7th FL, MiraeAsset Venture Tower,")
        PrintDeviceFont(20, 310, ENG_16X25, 1, 1, ROTATE_0, False, "685, Sampyeong-dong, Bundang-gu,")
        PrintDeviceFont(20, 340, ENG_16X25, 1, 1, ROTATE_0, False, "Seongnam-si, Gyeonggi-do,")
        PrintDeviceFont(20, 370, ENG_16X25, 1, 1, ROTATE_0, False, "463-400, KOREA")

        PrintDeviceFont(26, 421, ENG_12X20, 1, 1, ROTATE_0, False, "POSTAL CODE")
        PrintDeviceFont(503, 798, ENG_12X20, 1, 1, ROTATE_0, False, "DESTINATION")
        PrintDeviceFont(42, 841, ENG_32X50, 1, 1, ROTATE_0, True, "30 Kg")
        PrintDeviceFont(25, 798, ENG_12X20, 1, 1, ROTATE_0, False, "WEIGHT:")
        PrintDeviceFont(259, 798, ENG_12X20, 1, 1, ROTATE_0, False, "DELIVERY NO:")
        PrintDeviceFont(23, 630, ENG_12X20, 1, 1, ROTATE_0, False, "AWB:")
        PrintDeviceFont(274, 841, ENG_32X50, 1, 1, ROTATE_0, True, "425518")
        PrintDeviceFont(104, 627, ENG_19X30, 1, 1, ROTATE_0, False, "8741493121")
        PrintDeviceFont(565, 841, ENG_32X50, 1, 1, ROTATE_0, True, "ICN")



        '	Prints 1D Barcodes
        Print1DBarcode(69, 458, CODE39, 4, 8, 137, ROTATE_0, True, "1234567890")
        Print1DBarcode(127, 662, CODE93, 4, 8, 90, ROTATE_0, True, "8741493121")

        '	Prints a MAXICODE 
        Dim Direct_MaxiCode_2DBarcode_Cmd As String = "B2555,180,M,0,'999,840,06810,7317,BIXOLON LABEL PRINTER'"
        PrintDirect(Direct_MaxiCode_2DBarcode_Cmd)

        '	Prints a PDF417 
        Dim Direct_PDF_2DBarcocde_Cmd As String = "B2200,945,P,8,8,0,0,0,1,2,14,0,'BIXOLON Label Printer, This is for test.'"
        PrintDirect(Direct_PDF_2DBarcocde_Cmd)

        PrintCircle(10, 1055, 3, 2)


        ' Prints a QRCode
        '  P1 : Horizontal position (X) [dot]
        '  P2 : Vertical position (Y) [dot]
        '  P3 : MODEL selection (1, 2)
        '  P4 : ECC Level (1 ~ 4)
        '  P5 : Size of QRCode (1 ~ 4)
        '  P6 : Rotation (0 ~ 3)
        '  P7 : data to print
        Dim QRCode_data As String = "QRCode sample test 123" '"家裸多羅馬바 123"'가나다라마바사아자차카타파하"' "QRCode with UTF-8 Encoding"
        PrintQRCode(22, 940, QRMODEL_2, QRECCLEVEL_M, QRSIZE_4, ROTATE_0, QRCode_data)


        ' Print Image
        PrintImageLib(200, 1035, "free.bmp", DITHER_1, False)
        PrintImageLib(450, 1035, "BIXOLON.bmp", DITHER_2, False)

        '	Print Command
        Prints(1, 1)

        '	Set the Label End
        EndLabel()

        '	Disconnect Printer Driver
        DisconnectPrinter()
    End Sub

    Private Sub txtP_Width_KeyPress(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtP_Width.KeyPress
        ' 숫자만 입력 가능하도록...
        pInputValidateFloat(e, sender)
    End Sub

    Private Sub txtP_Height_KeyPress(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtP_Height.KeyPress
        ' 숫자만 입력 가능하도록...
        pInputValidateFloat(e, sender)
    End Sub

    Private Sub txtMargin_X_KeyPress(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtMargin_X.KeyPress
        ' 숫자만 입력 가능하도록...
        pInputValidateFloat(e, sender)
    End Sub

    Private Sub txtMargin_Y_KeyPress(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtMargin_Y.KeyPress
        ' 숫자만 입력 가능하도록...
        pInputValidateFloat(e, sender)
    End Sub

   
End Class
