#define BXLLIB_API __declspec(dllimport)

//	Rotation
#define ROTATE_0	0
#define ROTATE_90	1
#define ROTATE_180	2
#define ROTATE_270	3

//	Bar-code Type
#define CODE39		0
#define CODE128		1
#define I2OF5		2
#define CODEBAR		3
#define CODE93		4
#define UPC_A		5
#define UPC_E		6
#define EAN13		7
#define EAN8		8
#define UCC_EAN128	9

//	Device Fonts
#define ENG_9X15	0	//	9 x 15
#define ENG_12X20	1	//	12 x 20
#define ENG_16X25	2	//	16 x 25
#define ENG_19X30	3	//	19 x 30
#define ENG_24X38	4	//	24 x 38
#define ENG_32X50	5	//	32 x 50
#define ENG_48X76	6	//	48 x 76
#define ENG_22X34	7
#define ENG_28X44	8
#define ENG_37X58	9

#define KOR_16X16	0x61	//	16 x 16
#define KOR_24X24	0x62	//	24 x 24	
#define KOR_20X20	0x63
#define KOR_26X26	0x64
#define KOR_20X26	0x65
#define KOR_38X38	0x66

#define CHN_GB2312	0x6D
#define CHN_BIG5	0x6E

//	Speed
#define SPEED_25	0
#define SPEED_30	1
#define SPEED_40	2
#define SPEED_50	3
#define SPEED_60	4
#define SPEED_70	5

//	Orientation
#define TOP			0
#define BOTTOM		1

//	Media Type
#define GAP			0
#define CONTINUOUS	1
#define BLACKMARK	2

//	Block Option
#define LINE_OVER_WRITING	0
#define LINE_EXCLUSIVE_OR	1
#define LINE_DELETE			2
#define SLOPE				3
#define BOX					4

#define ASCII        "U"
#define KS5601       "K"
#define BIG5         "B"
#define GB2312       "G"
#define ShiftJIS     "J"

#define LEFTALIGN    "L"
#define RIGHTALIGN   "R"
#define CENTERALIGN  "C"

// Font Direction
#define LEFTTORIGHT     0
#define RIGHTTOLEFT     1

//	Alignment
#define ALIGN_LEFT			0
#define ALIGN_CENTER		1
#define ALIGN_RIGHT			2
#define ALIGN_BOTH_SIDE		3

// QRCode
#define QRECCLEVEL_L     1	// 7%
#define QRECCLEVEL_M     2	// 15%
#define QRECCLEVEL_Q     3	// 25%
#define QRECCLEVEL_H     4	// 30%

#define QRMODEL_1     1
#define QRMODEL_2     2

#define QRSIZE_1     1
#define QRSIZE_2     2
#define QRSIZE_3     3
#define QRSIZE_4     4

// Dither option
// Floyd-Steinberg, Ordered dither, Stevenson-Arce, Bayer matrix[16x16 ordered dither]
enum {
	DITHER_NONE = -1,
		DITHER_1 = 0,
		DITHER_2 = 1,
		DITHER_3 = 6,
		DITHER_4 = 7
};


//	Import Functions
BXLLIB_API BOOL __stdcall GetDllVersion(LPTSTR pszVersion);
BXLLIB_API int  __stdcall GetBIXOLON_PrinterList(LPTSTR pszInstalled);
BXLLIB_API int  __stdcall GetPrinterResolution();

BXLLIB_API BOOL __stdcall ConnectPrinter(LPCSTR szPrinterName);
BXLLIB_API BOOL __stdcall DisconnectPrinter();

BXLLIB_API BOOL __stdcall StartLabel();
BXLLIB_API void __stdcall EndLabel();

BXLLIB_API BOOL __stdcall Prints(int nLabelSet, int nCopiesOfEachLabel);

BXLLIB_API BOOL __stdcall SetConfigOfPrinter(
						int nSpeed,
						int nDensity,
						int nOrientation,
						BOOL bAutoCut,
						int nCuttingPeriod,
						BOOL bBackFeeding);

BXLLIB_API BOOL __stdcall SetPaper(
			  int nHorizontalMagin,
			  int nVerticalMargin,
			  int nPaperWidth,
			  int nPaperLength,
			  int nMediaType,
			  int nOffSet,
			  int nGapLengthORThicknessOfBlackLine = 16);

BXLLIB_API BOOL __stdcall ClearBuffer();

BXLLIB_API int __stdcall PrintDirect(LPCSTR pDirectData);//, int nDataSize);

BXLLIB_API BOOL __stdcall PrintDeviceFont(
					 int nHorizontalPos,
					 int nVerticalPos,
					 int nFontName,
					 int nHorizontalMulti,
					 int nVerticalMulti,
					 int nRotation,
					 BOOL bBold,
					 LPCSTR szText);

BXLLIB_API BOOL __stdcall PrintVectorFont(
					 int nXPos, 
					 int nYPos, 
					 LPCSTR FontSelection,
					 int FontWidth,
					 int FontHeight,
					 LPCSTR RightSideCharSpacing,
					 BOOL bBold,
					 BOOL ReversePrinting,
					 BOOL TextStyle,
					 int  Rotation,
					 LPCSTR  TextAlignment,
					 int  TextDirection,
					 LPCSTR pData);

BXLLIB_API BOOL __stdcall PrintBlock(
				int nHorizontalStartPos,
				int nVerticalStartPos,
				int nHorizontalEndPos,
				int nVerticalEndPos,
				int nOption,
				int nThickness);

BXLLIB_API BOOL __stdcall PrintCircle(
				 int nHorizontalStartPos,
				 int nVerticalStartPos,
				 int nDiameter,
				 int nMulti);

BXLLIB_API BOOL __stdcall Print1DBarcode(
					int nHorizontalPos,
					int nVerticalPos,
					int nBarcodeType,
					int nNarrowBarWidth,
					int nWideBarWidth,
					int nBarcodeHeight,
					int nRotation,
					BOOL bHRI,
					LPCSTR pData);


BXLLIB_API BOOL __stdcall PrintImageLib(
										int nHorizontalStartPos, 
										int nVerticalStartPos, 
										LPCSTR pImageFilename, 
										int nDither, 
										BOOL bWithRLE
										);
BXLLIB_API BOOL __stdcall PrintImageLibWithSize(
												int nHorizontalStartPos, 
												int nVerticalStartPos, 
												int nNewWidth,
												int nNewHeight,
												LPCSTR pImageFilename, 
												int nDither, 
												BOOL bWithRLE
												);

BXLLIB_API BOOL __stdcall PrintQRCode(int nXPos, int nYPos, int nModel, int nECCLevel, int nQRCodeSize, int nRotation, LPCTSTR pData);

BXLLIB_API BOOL __stdcall SetShowMsgBox(BOOL bShowMsgBox);

BXLLIB_API int __stdcall GetProperFontSize(LPCSTR strFontName, int nFontSize, BOOL bBold, LPCSTR strText, int nWidth );

BXLLIB_API BOOL __stdcall PrintTrueFontLib(int nXPos, int nYPos, 
					  LPCSTR strFontName, int nFontSize, int nRotaion, BOOL bItalic, BOOL bBold, BOOL bUnderline, 
					  LPCSTR strText);

					  
BXLLIB_API BOOL __stdcall PrintTrueFontLibWithAlign(int nXPos, int nYPos, 
							   LPCSTR strFontName, int nFontSize, int nRotaion, BOOL bItalic, BOOL bBold, BOOL bUnderline, 
							   LPCSTR strText, int nPrintWidth, int nAlignment);

