VERSION 5.00
Begin VB.Form frmMain 
   Caption         =   "BIXOLON_Sample Program (VB)"
   ClientHeight    =   6945
   ClientLeft      =   120
   ClientTop       =   450
   ClientWidth     =   9690
   BeginProperty Font 
      Name            =   "Verdana"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   ScaleHeight     =   6945
   ScaleWidth      =   9690
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton btnPrint 
      Caption         =   "Print sample label"
      Height          =   855
      Left            =   3000
      TabIndex        =   20
      Top             =   5760
      Width           =   3735
   End
   Begin VB.ComboBox cmbDensity 
      Height          =   360
      Left            =   8040
      Style           =   2  'Dropdown List
      TabIndex        =   19
      Top             =   2640
      Width           =   1095
   End
   Begin VB.Frame Frame3 
      Caption         =   "Speed / Density"
      Height          =   1575
      Left            =   6480
      TabIndex        =   15
      Top             =   1680
      Width           =   3015
      Begin VB.ComboBox cmbSpeed 
         Height          =   360
         ItemData        =   "frmMain.frx":0000
         Left            =   1560
         List            =   "frmMain.frx":000A
         Style           =   2  'Dropdown List
         TabIndex        =   18
         Top             =   480
         Width           =   1095
      End
      Begin VB.Label Label8 
         Caption         =   "Density"
         Height          =   375
         Left            =   240
         TabIndex        =   17
         Top             =   960
         Width           =   975
      End
      Begin VB.Label Label7 
         Caption         =   "Speed"
         Height          =   375
         Left            =   240
         TabIndex        =   16
         Top             =   480
         Width           =   975
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Margins (Unit : mm)"
      Height          =   1575
      Left            =   3360
      TabIndex        =   10
      Top             =   1680
      Width           =   3015
      Begin VB.TextBox txtMargin_X 
         Height          =   375
         Left            =   1320
         TabIndex        =   12
         Top             =   480
         Width           =   1455
      End
      Begin VB.TextBox txtMargin_Y 
         Height          =   375
         Left            =   1320
         TabIndex        =   11
         Top             =   960
         Width           =   1455
      End
      Begin VB.Label Label6 
         Caption         =   "X margin"
         Height          =   375
         Left            =   240
         TabIndex        =   14
         Top             =   480
         Width           =   975
      End
      Begin VB.Label Label5 
         Caption         =   "Y margin"
         Height          =   375
         Left            =   240
         TabIndex        =   13
         Top             =   960
         Width           =   975
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Paper Size (Unit : mm)"
      Height          =   1575
      Left            =   240
      TabIndex        =   5
      Top             =   1680
      Width           =   3015
      Begin VB.TextBox txtP_Height 
         Height          =   375
         Left            =   1320
         TabIndex        =   9
         Top             =   960
         Width           =   1455
      End
      Begin VB.TextBox txtP_Width 
         Height          =   375
         Left            =   1320
         TabIndex        =   8
         Top             =   480
         Width           =   1455
      End
      Begin VB.Label Label4 
         Caption         =   "Height"
         Height          =   375
         Left            =   240
         TabIndex        =   7
         Top             =   960
         Width           =   975
      End
      Begin VB.Label Label3 
         Caption         =   "Width"
         Height          =   375
         Left            =   240
         TabIndex        =   6
         Top             =   480
         Width           =   975
      End
   End
   Begin VB.CommandButton btnSearchPrinter 
      Caption         =   "Search-Installed Printer"
      Height          =   495
      Left            =   6480
      TabIndex        =   4
      Top             =   840
      Width           =   2895
   End
   Begin VB.ComboBox cmbPrtList 
      Height          =   360
      Left            =   2520
      Style           =   2  'Dropdown List
      TabIndex        =   3
      Top             =   960
      Width           =   3855
   End
   Begin VB.Frame Frame4 
      Caption         =   "Media type"
      Height          =   1815
      Left            =   240
      TabIndex        =   21
      Top             =   3600
      Width           =   3015
      Begin VB.OptionButton rdoTt 
         Caption         =   "Thermal transfer"
         Height          =   375
         Left            =   240
         TabIndex        =   27
         Top             =   1080
         Width           =   2535
      End
      Begin VB.OptionButton rdoDt 
         Caption         =   "Direct thermal"
         Height          =   375
         Left            =   240
         TabIndex        =   22
         Top             =   480
         Value           =   -1  'True
         Width           =   2535
      End
   End
   Begin VB.Frame Frame5 
      Caption         =   "Sensor type"
      Height          =   1815
      Left            =   3360
      TabIndex        =   23
      Top             =   3600
      Width           =   3015
      Begin VB.OptionButton rdoContinuous 
         Caption         =   "Continuous"
         Height          =   375
         Left            =   240
         TabIndex        =   29
         Top             =   1320
         Width           =   2535
      End
      Begin VB.OptionButton rdoBmark 
         Caption         =   "Black mark"
         Height          =   375
         Left            =   240
         TabIndex        =   28
         Top             =   840
         Width           =   2535
      End
      Begin VB.OptionButton rdoGap 
         Caption         =   "Gap"
         Height          =   375
         Left            =   240
         TabIndex        =   24
         Top             =   360
         Value           =   -1  'True
         Width           =   2535
      End
   End
   Begin VB.Frame Frame6 
      Caption         =   "Etc"
      Height          =   1815
      Left            =   6480
      TabIndex        =   25
      Top             =   3600
      Width           =   3015
      Begin VB.CheckBox chkRevFeeding 
         Caption         =   "Reverse-feeding"
         Height          =   375
         Left            =   240
         TabIndex        =   30
         Top             =   1080
         Value           =   1  'Checked
         Width           =   2535
      End
      Begin VB.CheckBox chkCutter 
         Caption         =   "Cutter"
         Height          =   375
         Left            =   240
         TabIndex        =   26
         Top             =   480
         Width           =   2535
      End
   End
   Begin VB.Label Label2 
      Caption         =   "BIXOLON Printer list"
      Height          =   375
      Left            =   240
      TabIndex        =   2
      Top             =   960
      Width           =   2295
   End
   Begin VB.Label lblDllVersion 
      Caption         =   "Version"
      Height          =   375
      Left            =   2160
      TabIndex        =   1
      Top             =   360
      Width           =   2295
   End
   Begin VB.Label Label1 
      Caption         =   "DLL Version :"
      Height          =   375
      Left            =   240
      TabIndex        =   0
      Top             =   360
      Width           =   1695
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False




Private Sub Form_Load()

    InitControls
    
End Sub

Private Sub InitControls()

    Dim i As Long
    Dim bResult As Boolean
    Dim sDllVersion As String * 256
    Dim dValue As Double
        
    If GetDllVersion(sDllVersion) Then
        lblDllVersion.Caption = "Version " + CStr(sDllVersion)
    Else
        lblDllVersion.Caption = "Unknown"
    End If
    
    btnPrint.Enabled = GetInstalledPrinter()
        
    cmbDensity.Clear
    For i = 0 To 20 - 1
        cmbDensity.AddItem CStr(i + 1)
    Next
    cmbDensity.ListIndex = (14 - 1)
    
    cmbSpeed.Clear
    cmbSpeed.AddItem CStr(2.5)
    cmbSpeed.AddItem CStr(3)
    cmbSpeed.AddItem CStr(4)
    cmbSpeed.AddItem CStr(5)
    cmbSpeed.AddItem CStr(6)
    cmbSpeed.AddItem CStr(7)
    cmbSpeed.ListIndex = SPEED_50
    
    '--------------------------------------------------------
    ' Paper Size
    ' Default 4x6 inch -> (4*25.4) x (6*25.4) mm
    dValue = 4 * 25.4
    txtP_Width.Text = CStr(dValue)
    dValue = 6 * 25.4
    txtP_Height.Text = CStr(dValue)
    
    txtMargin_X.Text = "0"
    txtMargin_Y.Text = "0"

End Sub

Private Function GetInstalledPrinter() As Boolean
    
    Dim ssPrinters As String * 4096
    Dim sPrinterList() As String
    Dim iIndex As Long
    Dim sTemp As String
    
    
    cmbPrtList.Clear
    If GetBIXOLON_PrinterList(ssPrinters) <= 0 Then
        GetInstalledPrinter = False
    Else
        sTemp = CStr(ssPrinters)
        sPrinterList() = Split(sTemp, "^")
        
        If UBound(sPrinterList) >= 0 Then
                        
            For iIndex = 0 To UBound(sPrinterList)
                cmbPrtList.AddItem sPrinterList(iIndex)
            Next
            
            cmbPrtList.ListIndex = 0
            GetInstalledPrinter = True
        Else
            GetInstalledPrinter = False
        End If
        
    End If
    
End Function

' Search - Installed BIXOLON Printers
Private Sub btnSearchPrinter_Click()
    btnPrint.Enabled = GetInstalledPrinter()
End Sub

' Print sample label
Private Sub btnPrint_Click()

    Dim bResult As Boolean

    Dim strPrinterName As String
    
    Dim MM2D As Long
    
    Dim nPaper_Width As Long
    Dim nPaper_Height As Long
    Dim nMarginX As Long
    Dim nMarginY As Long

    Dim nSpeed As Long
    Dim nDensity As Long

    Dim bAutoCut As Boolean
    Dim bReverseFeeding As Boolean

    Dim nSensorType As Long
    
    Dim Direct_MaxiCode_2DBarcode_Cmd As String
    Dim Direct_PDF_2DBarcocde_Cmd As String
    Dim QRCode_data As String
    
    If txtP_Width.Text = "" Or txtP_Width.Text = "." Then txtP_Width.Text = "0"
    If txtP_Height.Text = "" Or txtP_Height.Text = "." Then txtP_Height.Text = "0"

    If txtMargin_X.Text = "" Or txtMargin_X.Text = "." Then txtMargin_X.Text = "0"
    If txtMargin_Y.Text = "" Or txtMargin_Y.Text = "." Then txtMargin_Y.Text = "0"
        
    ' BIXOLON SLP-770II, BIXOLON SLP-770III
    ' BIXOLON SLP-D420, BIXOLON SLP-D423, BIXOLON SLP-T400, BIXOLON SLP-T403,
    ' BIXOLON SLP-TX400, BIXOLON SLP-TX403 ...
    ' ...
    strPrinterName = cmbPrtList.Text
    If ConnectPrinter(strPrinterName) = False Then
        Exit Sub
    End If
    
    ' 203 DPI : 1mm = 8 dots
    ' 300 DPI : 1mm = 12 dots
    MM2D = IIf(GetPrinterResolution() < 300, 8, 12)
    
    nPaper_Width = CInt(CDbl(txtP_Width.Text) * MM2D)
    nPaper_Height = CInt(CDbl(txtP_Height.Text) * MM2D)
    nMarginX = CInt(CDbl(txtMargin_X.Text) * MM2D)
    nMarginY = CInt(CDbl(txtMargin_Y.Text) * MM2D)

    nSpeed = cmbSpeed.ListIndex
    nDensity = CInt(cmbDensity.Text)

    bAutoCut = chkCutter.Value
    bReverseFeeding = chkRevFeeding.Value

    nSensorType = GAP
    If rdoBmark.Value Then
        nSensorType = BLACKMARK
    ElseIf rdoContinuous.Value Then
        nSensorType = CONTINUOUS
    End If
        
    '   Set the label start
    bResult = StartLabel()

    '   Set Label and Printer
    'SetConfigOfPrinter(SPEED_50, 17, TOP, false, 0, true);
    bResult = SetConfigOfPrinter(nSpeed, nDensity, TOP, bAutoCut, 0, bReverseFeeding)

    '1 Inch : 25.4mm
    '1 mm   :  8 Dot in 203 DPI such as TX400, T400, D420, D220, SRP-770, SRP-770II
    '1 mm   : 12 Dot in 300 DPI such as TX403, T403, D423, D223
    '4 Inch : 25.4  * 4 * 8 = 812.8
    '6 Inch : 25.4  * 4 * 8 = 1219.2

    'SetPaper(16, 16, 813, 1220, GAP, 0, 16); ' 4 inch (Width) * 6 inch (Hiehgt)
    bResult = SetPaper(nMarginX, nMarginY, nPaper_Width, nPaper_Height, nSensorType, 0, 16) ' 4 inch (Width) * 6 inch (Hiehgt)

    If rdoDt.Value Then ' Direct thermal
        PrintDirect ("STd")
    Else ' Thermal transfer
        PrintDirect ("STt")
    End If

    '   Clear Buffer of Printer
    bResult = ClearBuffer()
    
    ' Draw BOX (Fill color is black)
    bResult = PrintBlock(370, 40, 760, 150, LINE_OVER_WRITING, 0)

    '   Draw Lines
    bResult = PrintBlock(18, 164, 798, 170, LINE_OVER_WRITING, 0)
    bResult = PrintBlock(18, 410, 784, 415, LINE_OVER_WRITING, 0)
    'bResult = PrintBlock(553, 170, 558, 413, LINE_OVER_WRITING, 0)
    bResult = PrintBlock(548, 170, 553, 413, LINE_OVER_WRITING, 0)
    bResult = PrintBlock(18, 616, 784, 621, LINE_OVER_WRITING, 0)
    bResult = PrintBlock(20, 781, 786, 786, LINE_OVER_WRITING, 0)
    bResult = PrintBlock(18, 928, 784, 933, LINE_OVER_WRITING, 0)
    bResult = PrintBlock(241, 783, 246, 932, LINE_OVER_WRITING, 0)
    bResult = PrintBlock(486, 784, 491, 933, LINE_OVER_WRITING, 0)


    ' Prints string using TrueFont
    '  P1 : Horizontal position (X) [dot]
    '  P2 : Vertical position (Y) [dot]
    '  P3 : Font Name
    '  P4 : Font Size
    '  P5 : Rotation : (0 : 0 degree , 1 : 90 degree, 2 : 180 degree, 3 : 270 degree)
    '  P6 : Italic
    '  P7 : Bold
    '  P8 : Underline
    bResult = PrintTrueFontLib(22, 100, "Arial", 16, 0, True, True, False, "Sample Label-1")

    'Print string using Vector Font
    '  P1 : Horizontal position (X) [dot]
    '  P2 : Vertical position (Y) [dot]
    '  P3 : Font selection
    '                  U: ASCII (1Byte code)
    '                  K: KS5601 (2Byte code)
    '                  B: BIG5 (2Byte code)
    '                  G: GB2312 (2Byte code)
    '                  J: Shift-JIS (2Byte code)
    ' P4  : Font width (W)[dot]
    ' P5  : Font height (H)[dot]
    ' P6  : Right-side character spacing [dot], Plus (+)/Minus (-) option can be used. Ex) 5, +3, -10
    ' P7  : Bold
    ' P8  : Reverse printing
    ' P9  : Text style  (N : Normal, I : Italic)
    ' P10 : Rotation (0 ~ 3)
    ' P11 : Text Alignment (Optional)
    ' P12 : Text string write direction
    ' P13 : data to print
    ' ※ : Third parameter, 'ASCII' must be set if Bixolon printer is SLP-T400, SLP-T403, SRP-770 and SRP-770II.
    'bResult = PrintVectorFont(22, 65, ASCII, 34, 34, "0", false, false, false, ROTATE_0, LEFTALIGN, LEFTTORIGHT, "Sample Label-2")

    bResult = PrintDeviceFont(400, 55, ENG_48X76, 1, 1, ROTATE_0, False, "BIXOLON")

    bResult = PrintDeviceFont(20, 174, ENG_24X38, 1, 1, ROTATE_0, False, "SHIP TO:")
    bResult = PrintDeviceFont(20, 234, ENG_19X30, 1, 1, ROTATE_0, True, "BIXOLON")
    bResult = PrintDeviceFont(20, 280, ENG_16X25, 1, 1, ROTATE_0, False, "7th FL, MiraeAsset Venture Tower,")
    bResult = PrintDeviceFont(20, 310, ENG_16X25, 1, 1, ROTATE_0, False, "685, Sampyeong-dong, Bundang-gu,")
    bResult = PrintDeviceFont(20, 340, ENG_16X25, 1, 1, ROTATE_0, False, "Seongnam-si, Gyeonggi-do,")
    bResult = PrintDeviceFont(20, 370, ENG_16X25, 1, 1, ROTATE_0, False, "463-400, KOREA")

    bResult = PrintDeviceFont(26, 421, ENG_12X20, 1, 1, ROTATE_0, False, "POSTAL CODE")
    bResult = PrintDeviceFont(503, 798, ENG_12X20, 1, 1, ROTATE_0, False, "DESTINATION")
    bResult = PrintDeviceFont(42, 841, ENG_32X50, 1, 1, ROTATE_0, True, "30 Kg")
    bResult = PrintDeviceFont(25, 798, ENG_12X20, 1, 1, ROTATE_0, False, "WEIGHT:")
    bResult = PrintDeviceFont(259, 798, ENG_12X20, 1, 1, ROTATE_0, False, "DELIVERY NO:")
    bResult = PrintDeviceFont(23, 630, ENG_12X20, 1, 1, ROTATE_0, False, "AWB:")
    bResult = PrintDeviceFont(274, 841, ENG_32X50, 1, 1, ROTATE_0, True, "425518")
    bResult = PrintDeviceFont(104, 627, ENG_19X30, 1, 1, ROTATE_0, False, "8741493121")
    bResult = PrintDeviceFont(565, 841, ENG_32X50, 1, 1, ROTATE_0, True, "ICN")


    '   Prints 1D Barcodes
    bResult = Print1DBarcode(69, 458, CODE39, 4, 8, 137, ROTATE_0, True, "1234567890")
    bResult = Print1DBarcode(127, 662, CODE93, 4, 8, 90, ROTATE_0, True, "8741493121")

    '   Prints a MAXICODE
    Direct_MaxiCode_2DBarcode_Cmd = "B2555,180,M,0,'999,840,06810,7317,BIXOLON LABEL PRINTER'"
    bResult = PrintDirect(Direct_MaxiCode_2DBarcode_Cmd)

    '   Prints a PDF417
    Direct_PDF_2DBarcocde_Cmd = "B2200,945,P,8,8,0,0,0,1,2,14,0,'BIXOLON Label Printer, This is for test.'"
    bResult = PrintDirect(Direct_PDF_2DBarcocde_Cmd)

    bResult = PrintCircle(10, 1055, 3, 2)


    ' Prints a QRCode
    '  P1 : Horizontal position (X) [dot]
    '  P2 : Vertical position (Y) [dot]
    '  P3 : MODEL selection (1, 2)
    '  P4 : ECC Level (1 ~ 4)
    '  P5 : Size of QRCode (1 ~ 4)
    '  P6 : Rotation (0 ~ 3)
    '  P7 : data to print
    QRCode_data = "QRCode sample test 123" '"家裸多羅馬바 123"'가나다라마바사아자차카타파하"' "QRCode with UTF-8 Encoding"
    bResult = PrintQRCode(22, 940, QRMODEL_2, QRECCLEVEL_M, QRSIZE_4, ROTATE_0, QRCode_data)


    ' Print Image
    bResult = PrintImageLib(200, 1035, "free.bmp", DITHER_1, False)
    bResult = PrintImageLib(450, 1035, "BIXOLON.bmp", DITHER_2, False)

    '   Print Command
    bResult = Prints(1, 1)

    '   Set the Label End
    EndLabel
        
    '   Disconnect Printer Driver
    bResult = DisconnectPrinter()
            
End Sub

