﻿Public Module mdlBXLLIB

#Region " Constant variables "

    '  Constant List

    '	Rotation
    Public Const ROTATE_0 As Integer = 0
    Public Const ROTATE_90 As Integer = 1
    Public Const ROTATE_180 As Integer = 2
    Public Const ROTATE_270 As Integer = 3

    '	Bar-code Type
    Public Const CODE39 As Integer = 0
    Public Const CODE128 As Integer = 1
    Public Const I2OF5 As Integer = 2
    Public Const CODEBAR As Integer = 3
    Public Const CODE93 As Integer = 4
    Public Const UPC_A As Integer = 5
    Public Const UPC_E As Integer = 6
    Public Const EAN13 As Integer = 7
    Public Const EAN8 As Integer = 8
    Public Const UCC_EAN128 As Integer = 9

    '	Device Fonts
    Public Const ENG_9X15 As Integer = 0   '	9 x 15
    Public Const ENG_12X20 As Integer = 1  '	12 x 20
    Public Const ENG_16X25 As Integer = 2  '	16 x 25
    Public Const ENG_19X30 As Integer = 3  '	19 x 30
    Public Const ENG_24X38 As Integer = 4  '	24 x 38
    Public Const ENG_32X50 As Integer = 5  '	32 x 50
    Public Const ENG_48X76 As Integer = 6  '	48 x 76
    Public Const ENG_22X34 As Integer = 7    '  22 x 34
    Public Const ENG_28X44 As Integer = 8    '  28 x 44
    Public Const ENG_37X58 As Integer = 9    '  37 x 58

    Public Const KOR_16X16 As Integer = 97  '0x61	'	16 x 16
    Public Const KOR_24X24 As Integer = 98  '0x62	'	24 x 24	
    Public Const KOR_20X20 As Integer = 99  '0x63 '  20 x 20
    Public Const KOR_26X26 As Integer = 100    '0x64 '  26 x 26
    Public Const KOR_20X26 As Integer = 101    '0x65 '  20 x 26
    Public Const KOR_38X38 As Integer = 102    '0x66 '  38 x 38

    Public Const CHN_GB2312 As Integer = 96 '0x6D
    Public Const CHN_BIG5 As Integer = 110  '0x6E

    '	Speed
    Public Const SPEED_25 As Integer = 0
    Public Const SPEED_30 As Integer = 1
    Public Const SPEED_40 As Integer = 2
    Public Const SPEED_50 As Integer = 3
    Public Const SPEED_60 As Integer = 4
    Public Const SPEED_70 As Integer = 5

    '	Orientation
    Public Const ORIENTATION_TOP As Integer = 0
    Public Const ORIENTATION_BOTTOM As Integer = 1

    '	Media Type
    Public Const GAP = 0
    Public Const CONTINUOUS = 1
    Public Const BLACKMARK = 2

    '	Block Option
    Public Const LINE_OVER_WRITING = 0
    Public Const LINE_EXCLUSIVE_OR = 1
    Public Const LINE_DELETE = 2
    Public Const SLOPE = 3
    Public Const BOX = 4

    ' Font Selection
    Public Const ASCII As String = "U"
    Public Const KS5601 As String = "K"
    Public Const BIG5 As String = "B"
    Public Const GB2312 As String = "G"
    Public Const ShiftJIS As String = "J"


    ' Font Alignment
    Public Const LEFTALIGN As String = "L"
    Public Const RIGHTALIGN As String = "R"
    Public Const CENTERALIGN As String = "C"

    ' Font Direction
    Public Const LEFTTORIGHT As Integer = 0
    Public Const RIGHTTOLEFT As Integer = 1

    ' QRCode MODEL
    Public Const QRMODEL_1 As Integer = 1
    Public Const QRMODEL_2 As Integer = 2

    ' QRCode ECC Level
    Public Const QRECCLEVEL_L As Integer = 1   ' 7%
    Public Const QRECCLEVEL_M As Integer = 2   ' 15%
    Public Const QRECCLEVEL_Q As Integer = 3   ' 25%
    Public Const QRECCLEVEL_H As Integer = 4   ' 30%

    ' QRCode size
    Public Const QRSIZE_1 As Integer = 1
    Public Const QRSIZE_2 As Integer = 2
    Public Const QRSIZE_3 As Integer = 3
    Public Const QRSIZE_4 As Integer = 4

    ' Dither option 
    Public Const DITHER_NONE As Integer = -1
    Public Const DITHER_1 As Integer = 0
    Public Const DITHER_2 As Integer = 1
    Public Const DITHER_3 As Integer = 6
    Public Const DITHER_4 As Integer = 7

    '	Alignment
    Public Const ALIGN_LEFT = 0
    Public Const ALIGN_CENTER = 1
    Public Const ALIGN_RIGHT = 2
    Public Const ALIGN_BOTH_SIDE = 3

#End Region


#Region " DLL API Function "

    Public Declare Function ConnectPrinter Lib "BXLLIB.dll" (ByVal szPrinterName As String) As Boolean

    Public Declare Function DisconnectPrinter Lib "BXLLIB.dll" () As Boolean


    Public Declare Function GetBIXOLON_PrinterList Lib "BXLLIB.dll" (ByVal strInstalledPrinter As System.Text.StringBuilder) As Integer

    Public Declare Function GetDllVersion Lib "BXLLIB.dll" (ByVal strBxlPrtList As System.Text.StringBuilder) As Boolean
    '


    Public Declare Function GetPrinterResolution Lib "BXLLIB.dll" () As Integer


    Public Declare Function Print1DBarcode Lib "BXLLIB.dll" (ByVal nHorizontalPos As Integer, _
                                                 ByVal nVerticalPos As Integer, _
                                                 ByVal nBarcodeType As Integer, _
                                                 ByVal nNarrowBarWidth As Integer, _
                                                 ByVal nWideBarWidth As Integer, _
                                                 ByVal nBarcodeHeight As Integer, _
                                                 ByVal nRotation As Integer, _
                                                 ByVal bHRI As Boolean, _
                                                 ByVal pData As String) _
                                                 As Boolean


    Public Declare Function PrintDeviceFont Lib "BXLLIB.dll" (ByVal nHorizontalPos As Integer, _
                                                  ByVal nVerticalPos As Integer, _
                                                  ByVal nFontName As Integer, _
                                                  ByVal nHorizontalMulti As Integer, _
                                                  ByVal nVerticalMulti As Integer, _
                                                  ByVal nRotation As Integer, _
                                                  ByVal bBold As Boolean, _
                                                  ByVal szText As String) _
                                                  As Boolean


    Public Declare Function SetConfigOfPrinter Lib "BXLLIB.dll" (ByVal nSpeed As Integer, _
                                                     ByVal nDensity As Integer, _
                                                     ByVal nOrientation As Integer, _
                                                     ByVal bAutoCut As Integer, _
                                                     ByVal nCuttingPeriod As Integer, _
                                                     ByVal bBackFeeding As Boolean) _
                                                     As Boolean


    Public Declare Function Prints Lib "BXLLIB.dll" (ByVal nLabelSet As Integer, _
                                         ByVal nCopiesOfEachLabel As Integer) _
                                         As Boolean


    Public Declare Function SetPaper Lib "BXLLIB.dll" (ByVal nHorizontalMagin As Integer, _
                                           ByVal nVerticalMargin As Integer, _
                                           ByVal nPaperWidth As Integer, _
                                           ByVal nPaperLength As Integer, _
                                           ByVal nMediaType As Integer, _
                                           ByVal nOffSet As Integer, _
                                           ByVal nGapLengthORThicknessOfBlackLine As Integer) _
                                           As Boolean


    Public Declare Function ClearBuffer Lib "BXLLIB.dll" () As Boolean


    Public Declare Function PrintBlock Lib "BXLLIB.dll" (ByVal nHorizontalStartPos As Integer, _
                                             ByVal nVerticalStartPos As Integer, _
                                             ByVal nHorizontalEndPos As Integer, _
                                             ByVal nVerticalEndPos As Integer, _
                                             ByVal nOption As Integer, _
                                             ByVal nThickness As Integer) _
                                             As Boolean

    '/******************************************************************************/
    ' Circle draw 
    ' int nHorizontalStartPos	: X position
    ' int nVerticalStartPos	    : Y position
    ' int nDiameter			    : 원 Size Lib "BXLLIB.dll" (반지름) 1~6
    ' int nMulti				: 확대 Lib "BXLLIB.dll" (1~4)
    '/******************************************************************************/

    Public Declare Function PrintCircle Lib "BXLLIB.dll" (ByVal nHorizontalStartPos As Integer, _
                                             ByVal nVerticalStartPos As Integer, _
                                             ByVal nDiameter As Integer, _
                                             ByVal nMulti As Integer) _
                                             As Boolean


    Public Declare Function PrintDirect Lib "BXLLIB.dll" (ByVal pDirectData As String) As Integer


    Public Declare Function StartLabel Lib "BXLLIB.dll" () As Boolean


    Public Declare Sub EndLabel Lib "BXLLIB.dll" ()


    Public Declare Function PrintTrueFontLib Lib "BXLLIB.dll" (ByVal nXPos As Integer, _
                                    ByVal nYPos As Integer, _
                                    ByVal strFontName As String, _
                                    ByVal nFontSize As Integer, _
                                    ByVal nRotaion As Integer, _
                                    ByVal bItalic As Boolean, _
                                    ByVal bBold As Boolean, _
                                    ByVal bUnderline As Boolean, _
                                    ByVal strText As String) _
                                    As Boolean

    Public Declare Function PrintTrueFontLibWithAlign Lib "BXLLIB.dll" (ByVal nXPos As Integer, _
                                    ByVal nYPos As Integer, _
                                    ByVal strFontName As String, _
                                    ByVal nFontSize As Integer, _
                                    ByVal nRotaion As Integer, _
                                    ByVal bItalic As Boolean, _
                                    ByVal bBold As Boolean, _
                                    ByVal bUnderline As Boolean, _
                                    ByVal strText As String, _
                                    ByVal nPrintWidth As String, _
                                    ByVal nAlignment As Integer) _
                                    As Boolean


    Public Declare Function PrintVectorFont Lib "BXLLIB.dll" ( _
                                            ByVal nXPos As Integer, _
                                            ByVal nYPos As Integer, _
                                            ByVal strFontSelection As String, _
                                            ByVal nFontWidth As Integer, _
                                            ByVal nFontHeight As Integer, _
                                            ByVal strRightSideCharSpacing As String, _
                                            ByVal bBold As Boolean, _
                                            ByVal bReversePrinting As Boolean, _
                                            ByVal bTextStyle As Boolean, _
                                            ByVal nRotation As Integer, _
                                            ByVal strTextAlignment As String, _
                                            ByVal nTextDirection As Integer, _
                                            ByVal pData As String) _
                                            As Boolean


    Public Declare Function PrintQRCode Lib "BXLLIB.dll" (ByVal nXPos As Integer, _
                                                          ByVal nYPos As Integer, _
                                                          ByVal nModel As Integer, _
                                                          ByVal nECCLevel As Integer, _
                                                          ByVal nSize As Integer, _
                                                          ByVal nRotation As Integer, _
                                                          ByVal pData As String) _
                                                          As Boolean

    Public Declare Function SetShowMsgBox Lib "BXLLIB.dll" (ByVal bShowMsgBox As Boolean) As Boolean



    Public Declare Function PrintImageLib Lib "BXLLIB.dll" (ByVal nHorizontalStartPos As Integer, _
                                                            ByVal nVerticalStartPos As Integer, _
                                                            ByVal pBitmapFilename As String, _
                                                            ByVal nDither As Integer, _
                                                            ByVal bDataCompression As Boolean) _
                                                            As Boolean

    Public Declare Function PrintImageLibWithSize Lib "BXLLIB.dll" (ByVal nHorizontalStartPos As Integer, _
                                                            ByVal nVerticalStartPos As Integer, _
                                                            ByVal nNewWidth As Integer, _
                                                            ByVal nNewHeight As Integer, _
                                                            ByVal pBitmapFilename As String, _
                                                            ByVal nDither As Integer, _
                                                            ByVal bDataCompression As Boolean) _
                                                            As Boolean

#End Region


#Region " ETC "

    ' 숫자 입력 처리
    Public Sub pInputValidateDigit(ByRef e As System.Windows.Forms.KeyPressEventArgs)
        If e.KeyChar = "." Then
            e.Handled = True
        ElseIf e.KeyChar = Convert.ToChar(System.Windows.Forms.Keys.Back) OrElse e.KeyChar = Convert.ToChar(System.Windows.Forms.Keys.Delete) Then
            e.Handled = False
        ElseIf Char.IsDigit(e.KeyChar) = True Then
            e.Handled = False
        Else
            e.Handled = True
        End If
    End Sub

    ' 숫자 입력 처리(핸들, 소숫점 포함여부) 
    Public Sub pInputValidateFloat(ByRef e As System.Windows.Forms.KeyPressEventArgs, ByVal sender As Object)
        Dim nPreLen As Integer = 4    ' 정수부 길이
        Dim nPostLen As Integer = 3   ' 소수부 길이 

        '백스페이스는 그냥 허용
        If e.KeyChar = Convert.ToChar(System.Windows.Forms.Keys.Back) Then Exit Sub

        'sender 로부터 텍스트 박스 구함
        Dim editor As TextBox = sender

        '소숫점의 점(dot)이 포함되어 있는지 여부.
        '단, 현재 selection 상태인 텍스트에 점이 포함되어 있으면 비포함으로 간주
        Dim bDotContains As Boolean = editor.Text.Contains(".") AndAlso Not editor.SelectedText.Contains(".")

        '전체 길이 체크를 위한 변수(selection 길이는 뺀다)
        Dim nTextLen As Integer = editor.Text.Length - editor.SelectedText.Length
        '현재 커서 위치
        Dim nCursor As Integer = editor.SelectionStart

        '점과 숫자 이외의 값은 받아들이지 않음.
        If Not e.KeyChar = "." AndAlso Not Char.IsDigit(e.KeyChar) Then
            e.Handled = True
            '소숫점 이하 값이 없는 경우 - 2010.12.29 추가
        ElseIf e.KeyChar = "." AndAlso nPostLen < 1 Then
            e.Handled = True
            '점이 포함되어 있을 경우
        ElseIf bDotContains Then

            '전체 길이 체크 정수부와 소수부의 길이 더하기 점의 길이보다 같거나 크면 받아들이지 않음.
            '또한, 이미 점이 포함되어 있으므로, 점이 들어오면 받아들이지 않음.
            If nTextLen >= nPreLen + nPostLen + 1 OrElse e.KeyChar = "." Then
                e.Handled = True
            Else
                '점의 위치를 구한다.
                Dim nDotPos As Integer = editor.Text.IndexOf(".")
                '텍스트를 정수부와 소수부로 나눈다.
                Dim sSep() As String = editor.Text.Split(".")

                '현재 커서가 점 앞에 있고, 정수부의 길이가 지정된 길이보다 길어지면 받아들이지 않음.
                If nDotPos > nCursor AndAlso sSep(0).Length >= nPreLen Then
                    e.Handled = True
                    '현재 커서가 점 뒤에 있고, 소수부의 길이가 지정된 길이보다 길어지면 받아들이지 않음.
                ElseIf nDotPos < nCursor AndAlso sSep(1).Length >= nPostLen Then
                    e.Handled = True
                End If
            End If
            '들어온 값이 점이 아니고, 현재 텍스트가 점을 포함하지 않으면
            '현재 값은 정수인데, 정수부의 길이가 지정된 길이보다 길어지면 받아들이지 않음.
        ElseIf Not e.KeyChar = "." AndAlso Not bDotContains AndAlso nTextLen >= nPreLen Then
            e.Handled = True
        End If

    End Sub
#End Region


End Module
