unit bxllib;

interface

uses
Windows;

const
//	Roataion
ROTATE_0    : Integer	= 0;
ROTATE_90	  : Integer	= 1;
ROTATE_180	: Integer	= 2;
ROTATE_270	: Integer	= 3;

//	Barcode Type
CODE39		  : Integer	= 0;
CODE128		  : Integer	= 1;
I2OF5		    : Integer	= 2;
CODEBAR		  : Integer	= 3;
CODE93		  : Integer	= 4;
UPC_A		    : Integer	= 5;
UPC_E		    : Integer	= 6;
EAN13		    : Integer	= 7;
EAN8		    : Integer	= 8;
UCC_EAN128	: Integer	= 9;

//	Device Fonts
ENG_9X15	: Integer	= 0;	//	9 x 15
ENG_12X20	: Integer	= 1;	//	12 x 20
ENG_16X25	: Integer	= 2;	//	16 x 25
ENG_19X30	: Integer	= 3;	//	19 x 30
ENG_24X38	: Integer	= 4;	//	24 x 38
ENG_32X50	: Integer	= 5;	//	32 x 50
ENG_48X76	: Integer	= 6;	//	48 x 76
ENG_22X34	: Integer	= 7;	//	22 x 34
ENG_28X44	: Integer	= 8;	//	28 x 44
ENG_37X58	: Integer	= 9;	//  37 x 58 

KOR_16X16	: Integer	= $61;	//	16 x 16
KOR_24X24	: Integer	= $62;	//	24 x 24	
KOR_20X20	: Integer	= $63;	//	20 x 20
KOR_26X26	: Integer	= $64;	//	26 x 26
KOR_20X26	: Integer	= $65;	//	20 x 26
KOR_38X38 : Integer = $66;  //  38 x 38

CHN_GB2312  : Integer	= $6D;
CHN_BIG5    : Integer	= $6E;

ASCII 			 : PChar	= 'U';
KS5601       : PChar	= 'K';
BIG5         : PChar	= 'B';
GB2312       : PChar	= 'G';
ShiftJIS     : PChar	= 'J';

LEFTALIGN    : PChar	= 'L';
RIGHTALIGN   : PChar	= 'R';
CENTERALIGN  : PChar	= 'C';


//	Speed
SPEED_25	: Integer	= 0;
SPEED_30	: Integer	= 1;
SPEED_40	: Integer	= 2;
SPEED_50	: Integer	= 3;
SPEED_60	: Integer	= 4;
SPEED_70	: Integer	= 5;

//	Orientation
TOP			: Integer	= 0;
BOTTOM	: Integer	= 1;

//	Media Type
GAP			    : Integer	= 0;
CONTINUOUS	: Integer	= 1;
BLACKMARK	  : Integer	= 2;

//	Block Option
LINE_OVER_WRITING	: Integer	= 0;
LINE_EXCLUSIVE_OR	: Integer	= 1;
LINE_DELETE			  : Integer	= 2;
SLOPE				      : Integer	= 3;
BOX					      : Integer	= 4;

// QRCode
QRECCLEVEL_L  : Integer	= 1;	// 7%
QRECCLEVEL_M  : Integer	= 2;	// 15%
QRECCLEVEL_Q  : Integer	= 3;	// 25%
QRECCLEVEL_H  : Integer	= 4;	// 30%

QRMODEL_1     : Integer	= 1;
QRMODEL_2     : Integer	= 2;

QRSIZE_1     : Integer	= 1;
QRSIZE_2     : Integer	= 2;
QRSIZE_3     : Integer	= 3;
QRSIZE_4     : Integer	= 4;

// Font Direction
LEFTTORIGHT : Integer	= 0;
RIGHTTOLEFT : Integer	= 1;

// Dither option
DITHER_NONE : Integer = -1;
DITHER_1 : Integer = 0;
DITHER_2 : Integer = 1;
DITHER_3 : Integer = 6;
DITHER_4 : Integer = 7;

//	Alignment
//ALIGN_LEFT = 0;
//ALIGN_CENTER = 1;
//ALIGN_RIGHT = 2;
//ALIGN_BOTH_SIDE = 3;


//	Import Funcions
function ConnectPrinter(
							szPrinterName: pChar
							): Boolean
      ;stdcall; external 'bxllib.dll'

function DisconnectPrinter(): Boolean
      ;stdcall; external 'bxllib.dll'

function StartLabel() : Boolean
      ;stdcall; external 'bxllib.dll'

procedure EndLabel()
      ;stdcall; external 'bxllib.dll'

function GetBIXOLON_PrinterList(pBxlPrtList : pChar): DWORD
      ;stdcall; external 'bxllib.dll'

function GetDllVersion(pDllVersion : pChar): Boolean
      ;stdcall; external 'bxllib.dll'

function GetPrinterResolution(): DWORD
      ;stdcall; external 'bxllib.dll'

function Print1DBarcode(nHorizontalPos: DWORD;
									   		nVerticalPos: DWORD;
									   		nBarcodeType: DWORD;
									   		nNarrowBarWidth: DWORD;
									   		nWideBarWidth: DWORD;
									   		nBarcodeHeight: DWORD;
									   		nRotation: DWORD;
									   		bHRI: Boolean;
									    	pData: pChar): Boolean
									   ;stdcall; external 'bxllib.dll'

function PrintDeviceFont(nHorizontalPos: DWORD;
										  	 nVerticalPos: DWORD;
										  	 nFontName: DWORD;
										  	 nHorizontalMulti: DWORD;
										  	 nVerticalMulti: DWORD;
										  	 nRotation: DWORD;
										  	 bBold: Boolean;
										  	 szText: pChar): Boolean
										  ;stdcall; external 'bxllib.dll'

function SetConfigOfPrinter(nSpeed: DWORD;
									 					nDensity: DWORD;
									 					nOrientation: DWORD;
									 					bAutoCut: Boolean;
									 					nCuttingPeriod: DWORD;
									 					bBackFeeding: Boolean): Boolean
									 ;stdcall; external 'bxllib.dll'

function Prints(nLabelSet: DWORD;
							  nCopiesOfEachLabel: DWORD): Boolean
      ;stdcall; external 'bxllib.dll'

function SetPaper(nHorizontalMagin: DWORD;
								  nVerticalMargin: DWORD;
								  nPaperWidth: DWORD;
								  nPaperLength: DWORD;
								  nMediaType: DWORD;
								  nOffSet: DWORD;
                  nGapLengthORThicknessOfBlackLine: DWORD): Boolean
								   ;stdcall; external 'bxllib.dll'

function ClearBuffer(): Boolean
      ;stdcall; external 'bxllib.dll'

function PrintCircle(nHorizontalStartPos: DWORD;
									 nVerticalStartPos: DWORD;
									 nDiameter: DWORD;
									 nMulti: DWORD) : Boolean
									 ;stdcall; external 'bxllib.dll'

function PrintBlock(nHorizontalStartPos: DWORD;
									 nVerticalStartPos: DWORD;
									 nHorizontalEndPos: DWORD;
									 nVerticalEndPos: DWORD;
									 nOption: DWORD;
									 nThickness: DWORD): Boolean
									 ;stdcall; external 'bxllib.dll'

function PrintDirect(pDirectData: pChar) : Boolean
      ;stdcall; external 'bxllib.dll'

function PrintTrueFontLib(nXPos : DWORD;
										nYPos : DWORD;
										pFontName : pChar;
										nFontSize : DWORD;
										nRotaion : DWORD;
										bItalic : Boolean;
										bBold : Boolean;
										bUnderline  : Boolean;
										pText : pChar) : Boolean
      ;stdcall; external 'bxllib.dll'


function PrintVectorFont(nXPos : DWORD;
										  nYPos : DWORD;
										  FontSelection : pChar;
										  FontWidth : DWORD;
										  FontHeight : DWORD;
										  RightSideCharSpacing : pChar;
										  bBold : Boolean;
										  ReversePrinting : Boolean;
										  TextStyle : Boolean;
										  Rotation : DWORD;
										  TextAlignment : pChar;
										  TextDirection : DWORD;
										  pData : pChar) : Boolean
      ;stdcall; external 'bxllib.dll'

function SetShowMsgBox(bShowMsgBox : Boolean) : Boolean
      ;stdcall; external 'bxllib.dll'

function PrintQRCode(nXPos : DWORD;
									  nYPos : DWORD;
									  nModel : DWORD;
									  nECCLevel : DWORD;
									  nQRCodeSize : DWORD;
									  nRotation : DWORD;
									  pData : pChar): Boolean
      ;stdcall; external 'bxllib.dll'

function PrintImageLib(nHorizontalStartPos : DWORD;
											 nVerticalStartPos : DWORD;
											 pBitmapFilename : pChar;
                       nDither : DWORD;
											 bCompression : Boolean) : Boolean
      ;stdcall; external 'bxllib.dll'

function PrintImageLibWithSize(
                        nHorizontalStartPos : DWORD;
											  nVerticalStartPos : DWORD;
                        nNewWidth : DWORD;
                        nNewHeight : DWORD;
											  pBitmapFilename : pChar;
                        nDither : DWORD;
											  bCompression : Boolean) : Boolean
      ;stdcall; external 'bxllib.dll'

implementation



end.
