--------------------------------------
-----  Basic Chinese descriptions  ---
--------------------------------------

-- Last Update: 2022.03.02

-- FORMAT: Item ID | Name | Description

-- Special character markup:
-- ↑ = Up Arrow  |  ↓ = Down Arrow  |  ! = Warning  |  # = Starts a new line
-- More can be found here: https://github.com/wofsauge/External-Item-Descriptions/wiki/Markup

local languageCode = "zh_cn"

local repCollectibles={
	[2] = {"2", "内眼", "三重眼泪#↓ {{Tears}} -49%射速修正"}, -- The Inner Eye
	[5] = {"5", "我的镜像", "眼泪有回旋效果#↑ {{Damage}} +1.5伤害#↑ {{Range}} x200%射程修正#↑ {{Range}} +1.5额外射程#↑ {{Shotspeed}} x160%弹速修正#↓ {{Luck}} -1运气"}, -- My Reflection
	[6] = {"6", "小号", "↑ {{Tears}} +1.5射速#↓ {{Range}} -1.5射程#↓ {{Range}} -20%额外射程"}, -- Number One
	[12] = {"12", "魔法蘑菇", "↑ +1心之容器#{{Heart}} 满血#↑ {{Damage}} +0.3伤害#↑ {{Damage}} +50%伤害倍数#↑ {{Range}} +2.5射程#↑ {{Speed}} +0.3移速#体型变大"}, -- Magic Mushroom
	[13] = {"13", "病毒", "{{Poison}} 接触敌人使其中毒#↑ {{Speed}} +0.2移速"}, -- The Virus
	[14] = {"14", "过量类固醇", "↑ {{Speed}} +0.3移速#↑ {{Range}} +2.5射程"}, -- Roid Rage
	[18] = {"18", "一美元", "{{Coin}} +100硬币"}, -- A Dollar
	[22] = {"22", "午餐", "↑ +1心之容器#{{Heart}} 治疗1红心"}, -- Lunch
	[23] = {"23", "正餐", "↑ +1心之容器#{{Heart}} 治疗1红心"}, -- Dinner
	[24] = {"24", "甜点", "↑ +1心之容器#{{Heart}} 治疗1红心"}, -- Dessert
	[25] = {"25", "早餐", "↑ +1心之容器#{{Heart}} 治疗1红心"}, -- Breakfast
	[26] = {"26", "烂肉", "↑ +1心之容器#{{Heart}} 治疗1红心"}, -- Rotten Meat
	[29] = {"29", "妈妈的内裤", "↑ {{Range}} +2.5射程#生成3-6只蓝苍蝇"}, -- Moms Underwear
	[30] = {"30", "妈妈的高跟鞋", "↑ {{Range}} +2.5射程#能对敌人造成12点接触伤害"}, -- Mom's Heels
	[31] = {"31", "妈妈的口红", "↑ {{Range}} +3.75射程#{{UnknownHeart}} 生成1随机心"}, -- Mom's Lipstick
	[37] = {"37", "炸弹先生", "在角色下方放置1个大炸弹，造成185点伤害"}, -- Mr. Boom
	[40] = {"40", "神风！", "在角色位置造成1次大爆炸#造成185点伤害"}, -- Kamikaze!
	[41] = {"41", "妈妈的卫生巾", "{{Fear}} 使所在房间内所有敌人恐惧5秒#使用时生成一只蓝苍蝇"},
	[42] = {"42", "鲍勃的烂头", "{{Poison}} 可投掷的有毒炸弹#{{Damage}} 造成185+100%角色伤害#产生毒气"}, -- Bob's Rotten Head
	[44] = {"44", "传送！", "将角色传送到除错误房外的房间#向所需方向移动可稍微影响传送方向"}, -- Teleport
	[45] = {"45", "美味的心", "{{Heart}} 治疗1红心#(多人游戏)也治疗其他玩家半红心"}, -- Yum Heart
	[46] = {"46", "幸运脚", "↑ {{Luck}} +1运气#赌博时赢的几率更高#清理房间后掉落物品的几率更高#将一些坏胶囊变成好胶囊"}, -- Lucky Foot
	[52] = {"52", "胎儿博士", "{{Bomb}} 炸弹眼泪#{{Damage}} 每个炸弹造成1000%角色伤害#{{Damage}} 如果结果超过60点伤害，则改为造成30+500%角色伤害#↓ {{Tears}} -60%射速修正"}, --Dr. Fetus
	[53] = {"53", "万磁王", "吸引掉落物#自动开箱子，忽略刺箱伤害"}, -- Magneto
	[55] = {"55", "妈妈的眼睛", "50%几率向后发射眼泪#{{Luck}} 运气5：100%几率"}, -- Mom's Eye
	[59] = {"59", "彼列之书", "<道具无法获得>"}, -- The Book of Belial (Judas's Birthright Version)
	[62] = {"62", "吸血鬼之魅", "↑ {{Damage}} +0.3伤害#{{HalfHeart}} 每杀死13个敌人治疗半红心"}, -- Charm of the Vampire
	[64] = {"64", "Steam大促", "{{Shop}} 商店物品价格-50%#多次获得会降得更低"}, -- Steam Sale
	[67] = {"67", "玛姬姐妹", "普通眼泪跟班#每次射击造成6.0点伤害"}, -- Sister Maggy
	[70] = {"70", "生长激素", "↑ {{Damage}} +1.0伤害#↑ {{Speed}} +0.2移速"}, -- Growth Hormones
	[71] = {"71", "小蘑菇", "↑ {{Speed}} +0.3移速#↑ {{Range}} +2.5射程#↑ 体型缩小"}, -- Mini Mush
	[72] = {"72", "念珠", "{{SoulHeart}} +3魂心#↑ {{Tears}} +0.5射速#{{Collectible33}}圣经添加至所有道具池"}, -- Rosary
	[78] = {"78", "启示录", "{{SoulHeart}} +1魂心#使用后天启骑士会替代本层Boss#{{AngelDevilChance}} +17.5% 恶魔房/天使房几率"}, -- Book of Revelations
	[79] = {"79", "咒印", "↑ {{Damage}} +1.0伤害#↑ {{Speed}} +0.2移速#{{BlackHeart}} +1黑心"}, -- The Mark
	[80] = {"80", "契约", "↑ {{Damage}} +0.5伤害#↑ {{Tears}} +0.7射速#{{BlackHeart}} +2黑心"}, -- The Pact
	[83] = {"83", "钉子", "{{HalfBlackHeart}} +半黑心#在当前房间获得：#↑ {{Damage}} +2.0伤害#↓ {{Speed}} -0.18移速#造成每秒1次40点接触伤害#粉碎经过的岩石"}, -- The Nail
	[84] = {"84", "我们需要深入挖掘！", "生成1个跳过所在层的活板门#在有装饰(草、碎石、骷颅头等)的地板上使用则改为生成一个{{LadderRoom}}暗门"}, -- We Need To Go Deeper!
	[87] = {"87", "洛基的角", "25%几率向4个方向发射眼泪#{{Luck}} 运气15：100%几率"}, -- Loki's Horns
	[91] = {"91", "探窟帽", "揭示相邻房间的类型#也可以揭示{{SecretRoom}}隐藏房，{{SuperSecretRoom}}超级隐藏房和{{MiniBoss}}小Boss房#阻挡上方弹幕的伤害"}, -- Spelunker Hat
	[98] = {"98", "圣遗物", "{{SoulHeart}} 每7-8个房间生成1魂心"}, -- The Relic
	[101] = {"101", "光环", "↑ +1心之容器#↑ {{Damage}} +0.3伤害#↑ {{Tears}} +0.2射速#↑ {{Range}}} +1.5射程#↑ {{Speed}} +0.3移速#{{Heart}} 治疗1红心"}, -- The Halo
	[106] = {"106", "大爆弹先生", "{{Bomb}} +5炸弹#↑ 炸弹伤害x1.85"}, -- Mr. Mega
	[110] = {"110", "妈妈的美瞳", "20%几率发射石化眼泪#↑ {{Range}} +1.5射程"}, -- Mom's Contacts
	[114] = {"114", "妈妈的菜刀", "{{Chargeable}} 用可控制的刀攻击#{{Damage}} 菜刀对接触的敌人造成每秒20次伤害#{{Damage}} 菜刀的伤害与蓄力时间成正比：未蓄力(未发射)时造成200%角色伤害，蓄力至约1/3时达到最大的600%角色伤害#进一步蓄力仅增加菜刀射程#{{Damage}} 伤害在回收途中会迅速衰减至200%角色伤害"}, -- Mom's Knife
	[115] = {"115", "通灵板", "幽灵眼泪#↑ {{Tears}} +0.5射速"},
	[118] = {"118", "硫磺火", "{{Chargeable}} 蓄力发射鲜血激光#{{Damage}} 共造成9次100%角色伤害#↓ {{Tears}} -67%射速修正"}, -- Brimstone
	[121] = {"121", "怪异蘑菇(大)", "↑ +1心之容器#↑ {{Damage}} +1.0伤害#↑ {{Range}} +1.5射程#↓ {{Speed}} -0.2移速"}, -- Odd Mushroom (Large)
	[123] = {"123", "怪物手册", "生成随机跟班#当前层持续"}, -- Monster Manual
	[126] = {"126", "剃刀片", "↑ {{Damage}} 所在房间+1.2伤害#房间内首次使用对角色造成1心伤害，之后每次使用造成半心伤害"},
	[129] = {"129", "桶装猪油", "↑ +2心之容器#↓ {{Speed}} -0.2移速"}, -- Bucket of Lard
	[135] = {"135", "献血袋", "便携式献血机#半心=1-2硬币#{{HardMode}} 困难模式：1硬币#{{Player14}} 店主：0-1硬币"}, -- IV Bag
	[138] = {"138", "圣痕", "↑ +1心之容器#↑ {{Damage}} +0.3伤害#{{Heart}} 治疗1红心"}, -- Stigmata
	[139] = {"139", "妈妈的钱包", "可以持有2个饰品#生成1个随机饰品"}, -- Mom's Purse
	[140] = {"140", "鲍勃的诅咒", "有毒炸弹#+5炸弹#炸弹会留下毒气#角色免疫中毒伤害"}, -- Bob's Curse
	[142] = {"142", "肩衣", "{{SoulHeart}} 当受伤降至半心时，获得1魂心(每房间一次)#!!! 被视作献血的伤害(如{{BloodDonationMachine}},{{Collectible126}},{{Collectible205}})无法触发效果#!!! 在{{SacrificeRoom}}献祭房中献祭可以触发效果"}, --Scapular
	[144] = {"144", "乞丐朋友", "拾取硬币并给予奖励#可能生成各类掉落物和乞丐道具池道具"}, -- Bum Friend
	[147] = {"147", "残损铁镐", "打碎所在房间接触到的岩石并对敌人造成伤害#攻击则降低1格充能#换层时再次充能"}, -- Notched Axe
	[148] = {"148", "害虫横行", "受伤时生成2-6只蓝苍蝇"}, -- Infestation
	[149] = {"149", "吐根酊", "{{Poison}} 爆炸有毒眼泪#↑ {{Damage}} +40伤害#↓ {{Shotspeed}} -0.2弹速#↓ {{Tears}} -67%射速修正#↓ {{Range}} -20%射程修正"}, -- Ipecac
	[152] = {"152", "科技II", "右眼以无限射程的持续穿透激光取代#{{Damage}} 激光造成每秒15次13%角色伤害#↓ {{Tears}} -33%射速修正"}, -- Technology 2
	[153] = {"153", "变异蜘蛛", "四重眼泪!#↓ {{Tears}} -58%射速修正"}, -- Mutant Spider
	[155] = {"155", "窥眼", "在房间内四处漂浮的跟班#每秒造成17点接触伤害#↑ {{Damage}} 角色左眼伤害+34%"}, -- The Peeper
	[158] = {"158", "水晶球", "揭示全图#生成随机卡牌，魂心或符文#持有时：#{{PlanetariumChance}} +15%星象房几率#{{PlanetariumChance}} 如果跳过{{TreasureRoom}}道具房则为100%"}, -- Crystal Ball
	[169] =	{"169", "巨人独眼", "↑ {{Damage}} +100%伤害倍率#↑ {{Damage}} +8.0额外伤害#↓ {{Tears}} -58%射速修正#眼泪杀死敌人后会继续前进"}, -- Polyphemus
	[171] = {"171", "蜘蛛屁股", "{{Slow}} 使敌人减速4秒#所有敌人受到10伤害#被它杀死的敌人生成蓝蜘蛛"}, -- Spider Butt
	[172] = {"172", "献祭匕首", "菜刀环绕物#阻挡敌人的弹幕#每秒造成112.5伤害"}, -- Sacrificial Dagger
	[176] = {"176", "干细胞", "↑ +1心之容器#↑ {{Shotspeed}} +0.16弹速#治疗1红心"}, -- Stem Cells
	[178] = {"178", "圣水", "{{Throwable}} {{ColorOrange}}可投掷{{CR}}#击中敌人时造成7伤害并破碎#留下的水迹能石化敌人并造成伤害"}, -- Holy Water
	[180] = {"180", "黑豆", "{{Poison}} 受到伤害时放出一连串屁并留下毒气云"},
	[182] = {"182", "圣心", "↑ {{Damage}} x230%伤害修正#↑ {{Damage}} +1.0额外伤害#↑ +1心之容器#{{Heart}} 满血#↓ {{Tears}} -0.4射速#↓ {{Shotspeed}} -0.25弹速#跟踪眼泪"}, -- Sacred Heart
	[184] = {"184", "圣杯", "飞行#↑ +1心之容器#{{Heart}} 治疗1红心"}, -- Holy Grail
	[186] = {"186", "血之权利", "对每个敌人造成40伤害#房间内首次使用对角色造成1心伤害，之后每次使用造成半心伤害"},
	[188] = {"188", "亚伯", "与角色移动互为镜像#向角色发射眼泪#每次射击造成3.5伤害#{{Player2}} 该隐：7.5伤害"}, -- Abel
	[189] = {"189", "超级食肉男孩死忠粉", "↑ +1心之容器#{{Heart}} 满血#↑ {{Damage}} +0.3伤害#↑ {{Tears}} +0.2射速#↑ {{Range}} +2.5射程#↑ {{Speed}} +0.2移速"}, -- SMB Super Fan
	[192] = {"192", "心灵感应傻瓜式教程", "所在房间眼泪获得：#跟踪眼泪#↑ +3.0射程"}, -- Telepathy for Dummies
	[193] = {"193", "生肉！", "↑ +1心之容器#↑ {{Damage}} +0.3伤害#{{Heart}} 治疗1红心"}, -- MEAT!
	[194] = {"194", "魔力八号球", "↑ {{Shotspeed}} +0.16弹速#{{Card}} +1卡牌#{{PlanetariumChance}} +15%星象房几率"}, -- Magic 8 Ball
	[197] = {"197", "耶稣果汁", "↑ {{Damage}} +0.5伤害#↑ {{Range}} +1.5射程"}, -- Jesus Juice
	[203] = {"203", "慈善捆绑包", "掉落物几率成对出现"}, -- Humbling Bundle
	[205] = {"205", "锋利插头", "{{Battery}} 使用时，以每格充能半心的代价为主动道具完全充能#优先使用红心"}, -- Sharp Plug
	[206] = {"206", "断头台", "↑ {{Damage}} +1.0伤害#↑ {{Tears}} +0.5射速修正#角色的头变成环绕物，不会受伤并造成105点接触伤害#角色仍从头发射眼泪"}, -- Guillotine
	[211] = {"211", "蜘蛛宝宝", "受伤时生成3-5只蓝蜘蛛"}, -- Spiderbaby
	[214] = {"214", "贫血", "↑ {{Range}} +1.5射程#受伤时在地上留下能造成伤害的血迹"}, -- Anemic
	[218] = {"218", "胎盘", "↑ +1心之容器#{{Heart}} 治疗1红心#{{HalfHeart}} 每过60秒有50%几率回复半颗红心"}, -- Placenta
	[222] =	{"222", "反重力", "按住发射键会使眼泪悬空#释放后，所有眼泪会向发射方向前进#↑ {{Tears}} +1射速修正"}, -- Anti-Gravity
	[224] = {"224", "柯吉猫的身体", "眼泪击中后会分裂为4个#分裂的眼泪造成一半伤害#↑ {{Tears}} +0.5射速修正#↓ {{Range}} -20%射程修正"}, -- Cricket's Body
	[228] = {"228", "妈妈的香水", "15%几率发射恐惧眼泪#↑ {{Tears}} +0.5射速修正"}, -- Moms Perfume
	[229] = {"229", "萌死戳的肺", "{{Chargeable}} 蓄力且霰弹式发射眼泪#↓ -77%射速修正"}, -- Monstro's Lung
	[230] = {"230", "亚巴顿", "↑ {{Damage}} +1.5伤害#↑ {{Speed}} +0.2移速#恐惧眼泪#将{{Heart}}心之容器变成{{BlackHeart}}黑心#{{BlackHeart}} +2黑心"}, -- Abaddon
	[232] = {"232", "{{Slow}} 怀表", "永久敌人减速效果#↑ {{Speed}} +0.3移速"}, -- Stop Watch
	[233] = {"233", "小小星球", "眼泪环绕在角色周围#↑ {{Range}} +6.5射程#幽灵眼泪"}, -- Tiny Planet
	[240] = {"240", "实验性疗法", "↑ 随机提升4项属性#↓ 随机降低2项属性"}, -- Experimental Treatment
	[245] = {"245", "完美视力", "角色眼泪加倍#↓ {{Damage}} -20%伤害"}, -- 20/20
	[248] = {"248", "虫群之心", "蓝蜘蛛/苍蝇造成双倍伤害#蜘蛛/苍蝇类跟班变得更强"}, -- Hive Mind
	[253] = {"253", "魔法血痂", "↑ +1心之容器#↑ {{Luck}} +1运气#{{Heart}} 治疗1红心"}, -- Magic Scab
	[254] = {"254", "血块", "!!! 只对左眼有效#↑ {{Damage}} +1.0伤害#↑ {{Range}} +1.5射程"}, -- Blood Clot
	[256] = {"256", "炙热炸弹", "{{Burning}} 燃烧炸弹#{{Bomb}} +5炸弹###角色不再受到火焰伤害#炸弹造成16点接触伤害"}, -- Hot Bombs
	[261] = {"261", "眼球突出", "↑ {{Damage}} +0.5伤害#↓ 眼泪走得越远伤害越低#近距离伤害为3倍，最大距离无伤害"}, -- Proptosis
	[262] = {"262", "遗失的书页2", "{{BlackHeart}} +1黑心#当降至1心时，对房间内所有敌人造成80点伤害#黑心和{{Collectible35}}死灵书伤害翻倍"}, -- Missing Page 2
	[263] = {"263", "透明符文", "{{Rune}} 复制持有符文或魂石的效果#{{Rune}} 拾取后生成1随机符文"}, -- Clear Rune   (REPENTANCE ITEM)
	[264] = {"264", "智能苍蝇", "环绕物#可阻挡弹幕#每秒造成6.4点接触伤害#受伤后在当前房间内智能苍蝇会离开角色追击敌人"},
	[273] = {"273", "鲍勃的脑浆子", "{{Throwable}} {{ColorOrange}}可投掷{{CR}}的炸弹跟班#爆炸造成100点伤害"}, -- Bob's Brain
	[274] = {"274", "生死之交", "受伤时获得1个中范围环绕物#环绕物造成每秒150点接触伤害"}, -- Best Bud
	[275] = {"275", "硫磺火宝宝", "{{Collectible118}} 发射硫磺火的跟班#每次发射共造成24点伤害"}, -- Lil Brimston
	[276] = {"276", "以撒的心脏", "让自身无敌#!!! 心脏跟班受伤时角色也受伤#跟班在角色发射时蓄力，释放时发射一串眼泪"}, -- Isaac's Heart
	[278] = {"278", "黑暗乞丐", "{{Heart}} 收集地板上的红心#每收集1.5个红心，生成一个黑心，卡牌，药丸，符文或蜘蛛"}, -- Dark Bum
	[280] = {"280", "长腿蛛妹妹", "在有敌人的房间里随机生成蓝蜘蛛#最多5只#魅惑接触的敌人"}, -- Sissy Longlegs
	[283] = {"283", "一百面骰", "重置所有底座道具，属性，掉落物，持有的被动道具#复制房间内随机1掉落物#重新开始所在房间并重新生成敌人，并将敌人重置#重置房间内所有岩石"}, -- D100
	[285] = {"285", "十面骰", "使房间内所有非Boss敌人降级"}, -- D10
	[287] = {"287", "秘密之书", "在本层获得以下道具的效果之一：#{{Blank}} {{Collectible54}} 藏宝图#{{Blank}} {{Collectible21}} 指南针 #{{Blank}} {{Collectible246}} 蓝地图#只产生未拥有的效果#如果三者都已拥有，施加{{Collectible76}}X光透视效果"}, -- Book of Secrets
	[288] = {"288", "蜘蛛盒", "生成4-8只蓝蜘蛛"}, -- Box of Spiders
	[289] = {"289", "红蜡烛", "投掷红火#火焰造成或抵挡5次伤害后或10秒后消失"}, -- Red Candle
	[291] = {"291", "冲水！", "使所有非Boss敌人变成便便#立即杀死便便敌人和Boss#熄灭火堆并将房间充满水#将岩浆坑变成可行走的地面"}, -- Flush!
	[292] = {"292", "撒但圣经", "{{BlackHeart}} +1黑心#{{DevilChance}} 在Boss战前使用则Boss房道具会变成恶魔交易#!!! 交易道具则会锁定在本局只能进行恶魔交易"}, -- Satanic Bible
	[294] = {"294", "棉豆", "击退附近的敌人和弹幕#将敌人击退到障碍物上会造成10点伤害"}, -- Butter Bean
	[295] = {"295", "魔术手指", "{{Damage}} 对房间内所有敌人造成10+200%角色伤害#{{Coin}} 价格：1硬币"}, -- Magic Fingers
	[296] = {"296", "转换器", "!!! 转换：#1魂心或黑心变成1心之容器"}, -- Converter
	[297] = {"297", "潘多拉魔盒", "{{Warning}} 一次性，根据所在层生成以下物品：#1章1:2{{SoulHeart}}; 1章2:2{{Key}}+2 {{Bomb}}#2章1:1{{BossRoom}}道具; 2章2:1章1+2章1#3章1:4{{SoulHeart}}; 3章2:20{{Coin}}#4章1:2{{BossRoom}}道具; 4章2:{{Collectible33}}圣经#???/虚空：无#地狱:1{{DevilRoom}}道具+1{{BlackHeart}}; 大教堂:1{{AngelRoom}}道具+1{{EternalHeart}}#暗室:解锁{{Collectible523}}搬家盒; 宝箱:1{{Coin}}#家:{{Collectible580}}红钥匙#若有迷宫诅咒则为章节1层"}, -- Pandora's Box
	[300] = {"300", "白羊座", "↑ {{Speed}} +0.25移速#{{Speed}} 对敌人造成25点接触伤害#移速不低于为0.85才能造成伤害，且自己不会受伤"}, -- Aries
	[307] = {"307", "摩羯座", "↑ +1心之容器#↑ {{Damage}} +0.5伤害#↑ {{Speed}} +0.1移速#↑ {{Range}} +0.75射程#↑ {{Tears}} +0.5射速修正#给予1炸弹，硬币和钥匙"}, -- Capricorn
	[308] = {"308", "宝瓶座", "留下水迹#{{Damage}} 对接触水迹的敌人造成每秒6次66%角色伤害#水迹与眼泪效果有协同效应"}, -- Aquarius
	[309] =	{"309", "双鱼座", "↑ {{Tears}} +0.5射速修正#提高眼泪击退力"}, -- Pisces
	[310] =	{"310", "夏娃的睫毛膏", "↑ {{Damage}} +100%伤害#↓ {{Tears}} -33%射速修正#↓ {{Shotspeed}} -0.5弹速"},
	[311] = {"311", "犹大之影", "死后以{{Player12}}黑暗犹大重生#{{Damage}} 犹大之影拥有200%伤害修正#{{Player24}} 堕化犹大复活为其自身"}, -- Judas' Shadow
	[314] = {"314", "霹雳大腿", "↑ +1心之容器#↓ {{Speed}} -0.4移速#{{Heart}} 治疗1红心#摧毁走过的岩石"}, -- Thunder Thighs
	[315] = {"315", "怪异磁铁", "磁性眼泪#影响敌人，掉落物和饰品#物品会被吸引到眼泪落地处"}, -- Strange Attractor
	[319] = {"319", "该隐的另一只眼", "跟在角色身后#向四个随机正方向射击#复制角色的眼泪效果，但伤害降低25%"}, -- Cain's Other Eye
	[320] = {"320", "???唯一的朋友", "可控制的苍蝇#造成每秒4.3次3.5点接触伤害"}, -- ???'s Only Friend
	[323] = {"323", "以撒的泪盆", "{{Damage}} 使用时向8个方向发射眼泪，每颗眼泪造成5+100%角色伤害#射击时充能"},
	[326] = {"326", "生命之息", "按住空格消耗充能，充能清空时无敌#无敌时，接触到的敌人会被光束攻击#在恰好清空充能时抵挡伤害可生成十字光束并获得短暂护盾#!!! 不要一直按着！"}, -- Breath of Life
	[328] = {"328", "底片", "↑ {{Damage}} +1.0伤害#受伤时如果红心不多于半颗则对房间内所有敌人造成40点伤害"}, -- The Negative
	[330] = {"330", "豆奶", "↑ {{Tears}} x550%射速修正#↓ {{Damage}} -80%伤害#击退大幅降低"}, -- Soy Milk
	[331] = {"331", "神性", "↑ {{Damage}} +0.5伤害#↓ {{Tears}} -0.3射速#↓ {{Shotspeed}} -0.3弹速#眼泪具有伤害光环，造成每秒30次2.0点伤害#跟踪眼泪"}, -- Godhead
	[336] = {"336", "烂洋葱", "穿透幽灵眼泪#↓ {{Range}} -1.5射程#↓ {{Shotspeed}} -0.4弹速#↑ +50%眼泪大小"}, -- Dead Onion
	[339] = {"339", "安全别针", "↑ {{Range}} +2.5射程#↑ {{Shotspeed}} +0.16弹速#{{BlackHeart}} +1黑心"}, -- Safety Pin
	[342] = {"342", "蓝盖蘑菇", "↑ +1心之容器#↑ {{Tears}} +0.7射速#↓ {{Shotspeed}} -0.16弹速#{{Heart}} 治疗1红心"}, -- Blue Cap
	[344] = {"344", "火柴盒", "+1黑心#生成2-3炸弹和{{Trinket41}}火柴棒"}, -- Match Book
	[345] = {"345", "合成油脂", "↑ {{Damage}} +1.0伤害#↑ {{Range}} +2.5射程"}, -- Synthoil
	[346] = {"346", "零食", "↑ +1心之容器#{{Heart}} 治疗1红心"}, -- A Snack
	[350] = {"350", "毒性休克", "{{Poison}} 每个房间的一开始所有敌人获得中毒效果#被毒死的敌人留下水迹#对毒气免疫"}, -- Toxic Shock
	[352] = {"352", "玻璃大炮", "发射一颗巨大的穿透幽灵眼泪((伤害x10)+10)#!!! 受伤时：#额外受到2红心伤害并在当前房间留下血迹#额外伤害不致命#↑ {{Range}} +1.5射程#主动伤害除外"}, -- Glass Canon
	[354] = {"354", "琥珀爆米花", "↑ +1心之容器#在地上生成随机饰品#{{Heart}} 治疗1红心"}, -- Crack Jacks
	[355] = {"355", "妈妈的珍珠项链", "↑ {{Range}} +1.5射程#↑ {{Luck}} +1运气#{{SoulHeart}} +1魂心"}, -- Mom's Pearls
	[360] = {"360", "淫魔", "获得与角色眼泪效果一致的恶魔跟班#{{Damage}} 造成75%角色伤害#{{Player13}} 人物为莉莉丝则造成100%角色伤害"}, -- Incubus
	[365] = {"365", "迷路苍蝇", "沿着房间内的墙/障碍物走#每秒造成56点接触伤害#吸引周围敌人以迷路苍蝇为目标"}, 
	[366] = {"366", "分裂炸弹", "{{Bomb}} +5炸弹#炸弹会炸成4-5个小炸弹"}, -- Scatter Bombs
	[367] = {"367", "粘性炸弹", "{{Bomb}} +5炸弹#炸弹杀死敌人则生成蓝蜘蛛#炸弹会粘在敌人身上#炸弹爆炸后留下白色减速水迹"},
	[368] =	{"368", "溢泪症", "↑ {{Tears}} 向单方向发射会提高射速修正，最多至200%"}, -- Epiphora
	[369] = {"369", "连续统", "↑ {{Range}} +3.0射程#幽灵眼泪#眼泪会穿墙，从另一边回来"}, -- Continuum
	[370] = {"370", "玩偶先生", "↑ {{Tears}} +0.7射速#↑ {{Range}} +2.5射程#{{UnknownHeart}} 捡起时生成3随机心"}, -- Mr. Dolly
	[374] = {"374", "圣光", "10%几率发射圣光眼泪，击中时会产生光柱#{{Damage}} 光柱造成300%角色伤害#{{Luck}} 运气9：50%几率"}, -- Holy Light
	[375] = {"375", "寄居骷髅帽", "获得爆炸免疫#阻挡上方弹幕的伤害#20%几率阻挡弹幕"}, -- Host hat
	[376] = {"376", "补货", "商店物品购买后会立刻补货#补充的物品价格缓慢提高"}, -- Restock
	[380] = {"380", "充钱游戏", "{{Coin}} +5硬币#使用硬币而非钥匙打开门和金箱子"}, -- Pay To Play
	[382] = {"382", "友好球", "可以扔向敌人将其捕捉#下一次使用则会生成相同的友好敌人#靠近捕捉后的球会立即将道具充能"}, -- Friendly Ball
	[384] = {"384", "肉山宝宝", "{{Chargeable}} 会蓄力发射并在房间内滑动#每次撞击造成5.0-20点接触伤害，与蓄力时间有关"}, -- Lil Gurdy
	[391] = {"391", "背叛", "敌人的弹幕也会击中其他敌人#被弹幕击中的敌人会转头攻击伤害它的敌人"},
	[389] = {"389", "符文袋", "{{Rune}} 每7-8个房间生成1个随机符文或魂石"}, -- Rune Bag
	[393] = {"393", "蛇蝎之吻", "{{Poison}} 15%几率发射有毒眼泪#{{Poison}} 会使接触的敌人中毒#{{BlackHeart}} 接触中毒的敌人被杀死时有20%几率掉落1黑心"}, -- Serpent`s Kiss
	[394] = {"394", "十字准星", "自动地发射眼泪，方向为玩家控制的地上红色标记#↑ {{Tears}} +0.7射速#↑ {{Range}} +3.0射程#跟班也向标记发射"}, -- Marked
	[395] = {"395", "科技X", "{{Chargeable}} 能够蓄力发射穿过整个房间的激光环#蓄力越久则激光环越大，伤害越高#{{Damage}} 激光环对接触的敌人造成每秒15次伤害，完全蓄力时每次造成100%角色伤害"}, -- Tech X
	[397] = {"397", "牵引光束", "角色的眼泪现在受光束指引，与角色一起移动#↑ {{Tears}} +1.0射速修正#↑ {{Range}} +2.5射程#↑ {{Shotspeed}} +0.16弹速"}, -- Tractor Beam
	[399] = {"399", "虚空之喉", "{{Chargeable}} 蓄力2.4秒后释放攻击键可生成持续2秒的黑色硫磺火环#{{Damage}} 火环共造成30次100%角色伤害"}, -- Maw of the Void
	[401] = {"401", "爆炸物", "25%几率发射粘性炸弹眼泪#{{Damage}} 几秒后爆炸并造成60+100%角色伤害#{{Luck}} 不受运气影响"}, -- Explosivo
	[404] = {"404", "放屁宝宝", "阻挡弹幕的跟班#如果被击中有几率放屁，效果为魅惑/中毒/击退三种其一#屁造成5.0-6.0点伤害"}, -- Farting Baby
	[405] = {"405", "恶性漏洞", "{{Throwable}} {{ColorOrange}}可投掷{{CR}}(双击发射键)#重置接触到的敌人和掉落物"}, -- GB Bug
	[407] = {"407", "纯洁", "↑ 根据角色光环颜色对角色属性进行增强#受伤或进入新房间时，获得新的光环：#{{ColorRed}}红色{{CR}} = {{Damage}}+4.0伤害#{{ColorOrange}}橙色{{CR}} = {{Range}}+3.0射程#{{ColorYellow}}黄色{{CR}} = {{Speed}}+0.5移速#{{ColorBlue}}蓝色{{CR}} = {{Tears}}+2.0射速修正"},
	[408] = {"408", "祭祀之刃", "消灭敌人时有概率在敌人死亡位置生成持续1秒的黑色硫磺火环# {{Luck}} 运气30：100%几率"}, -- Athame
	[415] = {"415", "光明之冠", "{{SoulHeart}} +2魂心#如果没有不满的心之容器：#↑ {{Damage}} +100%伤害倍率#↓ {{Shotspeed}} -0.3弹速#受伤后，当前房间无论心之容器是否是满的，效果消失"}, -- Crown Of Light
	[416] = {"416", "深口袋", "{{Coin}} 如果房间没有奖励，生成1-3硬币#{{Coin}} 提高硬币上限为999"}, -- Deep Pockets
	[417] = {"417", "魅魔", "在房间内漂浮的跟班，产生伤害光环，每秒10.8点伤害#↑ {{Damage}} 站在光环中+50%伤害倍率"}, -- Succubus
	[419] = {"419", "传送2.0", "传送至另1个未探索的随机房间#等级：{{Room}}>{{BossRoom}}>{{SuperSecretRoom}}>{{Shop}}>{{TreasureRoom}}>{{Planetarium}}>{{SacrificeRoom}}>{{DiceRoom}}> {{Library}}>{{CursedRoom}}>{{MiniBoss}}>{{ChallengeRoom}}>{{IsaacsRoom}}>{{ArcadeRoom}}>{{ChestRoom}}>{{SecretRoom}}>{{DevilRoom}}/{{AngelRoom}}>{{ErrorRoom}}"},
	[421] = {"421", "腰豆", "{{Charm}} 魅惑角色附近的敌人"}, -- Kidney Bean
	[422] = {"422", "发光沙漏", "将角色放回上一个房间，且与当时的状态一致#每层仅可使用三次"}, -- Glowing Hourglass
	[426] = {"426", "狂热粉丝", "跟随角色移动的跟班，有0.66秒延迟#每秒造成30点接触伤害"}, -- Obsessed Fan
	[430] = {"430", "狙击蝇老爹", "跟随角色移动的跟班，有0.66秒延迟#向附近敌人发射眼泪，造成100%角色伤害"}, -- Papa Fly
	[431] = {"431", "多维宝宝", "跟随角色移动的跟班，有0.66秒延迟#经过它的眼泪会分成2个并有速度加成"}, -- Multidimensional Baby
	[432] = {"432", "闪光炸弹", "{{Bomb}} +5炸弹#{{Charm}} 炸弹爆炸有15%几率魅惑敌人#炸弹爆炸有63%几率生成随机掉落物#闪光炸弹每生成一个掉落物，在本层中生成掉落物的几率减少1%"}, -- Glitter Bombs
	[433] = {"433", "我的影子", "紧跟着角色的影子#当敌人接触到影子时，不断生成友好的黑蛆"},
	[436] = {"436", "牛奶！", "↑ 受伤后，在当前房间获得+1射速修正"}, -- Milk!
	[437] = {"437", "七面骰", "使房间内所有敌人再生#能够重复获得清理房间奖励"}, -- D7
	[440] = {"440", "肾结石", "发射眼泪时几率进行蓄力攻击#松开发射键后发射肾结石和一串眼泪"}, -- Kidney Stone
	[442] = {"442", "黑王子之冠", "!!! 仅有1红心时：#↑ {{Tears}} +2射速修正#↑ {{Range}} +1.5射程#↑ {{Shotspeed}} +0.2弹速#对无法获得红心的角色无效"}, -- Dark Princes Crown
	[444] = {"444", "铅笔", "每发射15颗眼泪，发射一串眼泪"}, -- Lead Pencil
	[448] = {"448", "玻璃碎片", "受减红心的伤时：#在角色周围喷洒眼泪#攻击时控制喷出眼泪的方向#每20秒受到半红心伤害#直到捡到红心或无红心效果终止#不致死#{{Heart}} 受伤时有25%几率生成1红心"}, -- Shard of Glass
	[451] = {"451", "塔罗牌桌布", "{{Card}} 生成1个随机卡牌或符文#{{Card}} 某些卡牌有额外或双倍效果"}, -- Tarot Cloth
	[453] = {"453", "复杂性骨折", "↑ {{Range}} +1.5射程#骨头眼泪#眼泪击中时碎成1-3个小骨头碎片"}, -- Compound Fracture
	[455] = {"455", "爸爸丢失的硬币", "↑ {{Range}} +2.5射程#生成1幸运硬币"},
	[456] = {"456", "夜宵", "↑ +1心之容器#{{Heart}} 治疗1红心"}, -- Midnight Snack
	[459] = {"459", "鼻窦炎", "20%几率发射粘性有毒眼泪#{{Luck}} 不受运气影响#{{Damage}} 每秒造成100%角色伤害#能粘住10秒"}, -- Sinus Infection
	[462] = {"462", "彼列之眼", "↑ {{Range}} +1.5射程#穿透眼泪#眼泪击中第1个敌人后，造成双倍伤害并获得跟踪效果"}, -- Eye of Belial
	[464] = {"464", "平衡符号", "{{SoulHeart}} +2魂心#精英怪掉落掉落物更频繁#生成掉落物的优先级取决于角色最缺少的掉落物"}, -- Glyph of Balance
	[468] = {"468", "阴影", "跟随角色移动的跟班，有1秒延迟#每秒造成75点接触伤害"}, -- Shade
	[472] = {"472", "国王宝宝", "其他跟班都会跟着他并自动射击敌人#角色发射时停止移动#停止发射后传送回角色位置"}, -- King Baby
	[474] = {"474", "损坏的玻璃大炮", "使用时变成玻璃大炮"}, -- Broken Glass Canon
	[476] = {"476", "一面骰", "复制房间中随机1个掉落物#复制的掉落物可能与原来的不同"}, -- D1
	[477] = {"477", "虚空", "!!! 使用时消耗房间中所有底座道具#主动道具：以后每次使用虚空时会激活其效果#↑ 被动道具：随机小幅提升2项属性"}, -- Void
	[487] = {"487", "土豆削皮刀", "使用时移除1个心之容器#↑ {{Damage}} 使用时+0.2伤害并获得{{Collectible73}}肉块#在当前房间触发{{Collectible214}}贫血的效果"},
	[489] = {"489", "无限面骰", "可作为任何骰子，{{Collectible723}}计数二十面骰除外#按 {{ButtonRT}}丢弃键改变当前骰子#根据骰子改变充能，且使用时更新"}, -- D Infinity
	[491] = {"491", "毒瘾宝宝", "{{Pill}} 每7个房间生成1随机胶囊#{{Poison}} 使用胶囊会使房间内所有敌人中毒"}, -- Acid Baby
	[493] = {"493", "肾上腺素", "↑ {{Damage}} 空的心之容器提高伤害#根据公式，一些例子如下：#1空心+0.3#2空心+0.92,3空心+1.76#4空心+2.79#5空心+3.98"}, -- Adrenaline
	[494] = {"494", "雅各布天梯", "眼泪击中时会生成1道随机方向电弧#{{Damage}} 电弧造成50%角色伤害#电弧可以在敌人间跳跃"}, -- Jacobs Ladder
	[495] = {"495", "断魂椒", "8%几率发射蓝火，能阻挡敌人弹幕并造成接触伤害#{{Damage}} 火焰造成每秒6次600%-300%角色伤害，伤害随火焰前行逐渐降低#火焰2秒后消失#{{Luck}} 运气11：50%几率"}, -- Ghost Pepper
	[496] = {"496", "安乐死", "3.3%几率发射针#针会立即杀死非Boss敌人，并爆出10发眼泪#{{Damage}} 针击中Boss造成300%角色伤害#{{Luck}} 运气15：25%几率"}, -- Euthanasia
	[501] = {"501", "贪婪的胃袋", "拾取后，每获得25硬币增加1心之容器#最多硬币达到99，+4心之容器#{{Player14}} 店主也会增加额外的硬币心#{{Collectible416}} 超过99后每100硬币增加1心之容器"}, -- Greed's Gullet
	[503] = {"503", "小魔角", "5%几率发射能召唤巨角恶魔的手的眼泪#{{Luck}} 运气12：20%#手会立即杀死敌人或对Boss造成3次12点接触伤害#人物冲向敌人可造成3.5点接触伤害"}, -- Little Horn
	[504] = {"504", "棕色粪块", "生成1只苍蝇炮塔，能够向敌人发射眼泪#每次发射造成3.5点伤害"}, -- Brown Nugget
	[507] = {"507", "尖头吸管", "{{Damage}} 造成角色伤害+敌人最大血量10%的伤害#影响房间内所有敌人#{{HalfHeart}} 造成伤害时几率掉落半红心" },
	[508] = {"508", "妈妈的剃刀", "使接触的敌人流血，流血伤害取决于敌人移速#对接触的敌人造成每秒200%角色伤害"},
	[509] = {"509", "血丝眼", "当附近有敌人时，每0.33秒发射一颗眼泪的环绕物#每次射击造成3.5点伤害#每秒造成30点接触伤害"}, -- Bloodshot Eye
	[517] = {"517", "快速炸弹", "7炸弹#能更快地放置炸弹#炸弹相互之间不会弹开"}, -- Fast Bombs
	[523] = {"523", "搬家盒", "使用时储存所在房间的掉落物，最多10个#再次使用将储存物放回地上#可以在房间之间搬东西"}, -- Moving Box
	[524] = {"524", "科技零", "眼泪以电弧连接#{{Damage}} 电弧造成每秒15次30%角色伤害"}, -- Technology Zero
	[531] = {"531", "泪血症", "眼泪弧形前进，击中时眼泪分裂成更小的眼泪#↑ {{Damage}} +1伤害#↑ {{Damage}} +50%伤害倍率#↓ {{Tears}} 射速降低约2/3#↓ {{Range}} -20%射程修正"}, -- Haemolacria
	[543] = {"543", "圣地大便", "受伤时生成白便便#在白便便的光环中：#↑ {{Damage}} +20%伤害倍率#↑ {{Tears}} x250%射速修正#跟踪眼泪#50%几率阻挡伤害"}, -- Hallowed Ground
	[549] =	{"549", "脆骨症", "{{EmptyBoneHeart}} 以6骨心替换所有心之容器#失去骨心时：#向8个方向发射骨头眼泪#↑ {{Tears}} 永久+0.4射速修正"}, -- Brittle Bones
	[552] =	{"552", "妈妈的铲子", "生成通往下一层的活板门# 在有装饰(草、碎石、骷颅头等)的地板上使用则改为生成{{LadderRoom}}一个暗门#!!! 在\"暗室\"的土丘上使用铲子#!!! 解锁某个很酷的东西"}, -- Brittle Bones
	[553] = {"553", "毛霉菌病", "25%几率发射粘性孢子眼泪#{{Luck}} 不受运气影响#孢子在命中后2.5秒爆炸，造成伤害，使附近敌人中毒，并释放更多孢子"}, --  Mucormycosis
	[554] = {"554", "恐怖如斯", "{{Fear}} 使近距离内的敌人恐惧"}, --  2Spooky
	[555] = {"555", "金剃刀片", "将5硬币转换成+1.2伤害，所在房间内有效#{{Coin}} +5硬币"}, --  Golden Razor
	[556] = {"556", "炼金硫磺", "{{Collectible118}} 所在房间获得硫磺火"}, --  Sulfur
	[557] = {"557", "幸运饼干", "获得1魂心，1张塔罗牌，1个饰品，或1条预言"}, --  Fortune Cookie
	[558] = {"558", "眼瘤", "几率向随机方向发射1-3颗额外眼泪#{{Luck}} 不受运气影响"}, --  Eye Sore
	[559] = {"559", "220伏", "持续电击近距离的敌人#{{Damage}} 电击伤害为角色伤害的75%"}, --  120 Volt
	[560] = {"560", "好疼", "受伤时向四周发射10颗造成10点伤害的眼泪#↑ {{Tears}} 第一次受伤时+1.2射速修正#↑ {{Tears}} 后续受伤+0.4射速"}, --  It Hurts
	[561] = {"561", "杏仁奶", "↑ {{Tears}} x400%射速修正#↓ {{Damage}} -70%伤害倍率#眼泪获得蠕虫饰品和一些随机道具的效果"}, --  Almond Milk
	[562] = {"562", "谷底石", "↑ 本局游戏中属性不会再降低"}, --  Rock Bottom
	[563] = {"563", "魅彩炸弹", "{{Bomb}} +5炸弹#炸弹具有随机爆炸效果"}, --  Nancy Bombs
	[564] = {"564", "肥皂", "↑ {{Tears}} +0.57射速#↑ {{Shotspeed}} +0.2弹速"}, --  A Bar of Soap
	[565] = {"565", "嗜血小宠", "会追逐敌人的跟班#击杀15个敌人后，会造成更多伤害，每击杀10个敌人掉落半红心，但也会尝试对角色造成伤害#击杀40个敌人后，会造成更多伤害，掉落整红心，可以摧毁岩石#被角色攻击时恢复正常"}, --  Blood Puppy
	[566] = {"566", "捕梦网", "{{HalfSoulHeart}} 进入新一层时+半魂心#在过场动画中显示下一层的{{TreasureRoom}}道具房和{{BossRoom}}Boss"}, --  Dream Catcher
	[567] = {"567", "逾越节蜡烛", "↑ {{Tears}} 完成房间且不受伤害则+0.4射速修正#{{Tears}} 最多叠加到+2射速修正"}, --  Paschal Candle
	[568] = {"568", "神圣干预", "双击攻击键生成护盾#护盾持续1秒，能推开敌人，反弹敌人弹幕和激光"}, --  Divine Intervention
	[569] = {"569", "血誓", "在每一层开始时只保留半红心#在本层获得以下效果：#↑ {{Damage}} +0.15*整红心损失数^2的伤害#↑ {{Speed}} +0.05*半红心损失数的移速"}, --  Blood Oath
	[570] = {"570", "黏土饼干", "使眼泪变为彩色，不同颜色的眼泪有不同的状态效果"}, --  Playdough Cookie
	[571] = {"571", "孤儿的袜子", "免疫来自水迹和尖刺的伤害#↑ {{Speed}} +0.3移速#{{SoulHeart}}  +2魂心"}, --  Orphan Socks
	[572] = {"572", "玄秘魔眼", "眼泪飞行中可控制#↑ {{Damage}} +1.0伤害#↑ {{Range}} +2.0射程#↓ {{Shotspeed}} -0.16弹速"}, --  Eye of the Occult
	[573] = {"573", "无瑕圣心", "↑ +1心之容器#{{Heart}} 满血#↑ {{Damage}} +20%伤害倍率#几率发射环绕自己的幽灵眼泪"}, --  Immaculate Heart
	[574] = {"574", "圣体匣", "获得2个对敌人造成伤害的光环#内环伤害更高"}, --  Monstrance
	[575] = {"575", "侵体蜘蛛", "生成1个住在脑袋里的跟班，每1.5秒发射4颗减速眼泪#受伤时跑出来"}, --  The Intruder
	[576] = {"576", "龌龊之心", "摧毁便便时生成1-4个永久魅惑的粪滴#便便类型不同，生成的粪滴也不同"}, --  Dirty Mind
	[577] = {"577", "达摩克里斯之剑", "{{Warning}} 一次性 {{Warning}}#在头顶生成悬浮的剑，所有底座道具额外生成1个#不会影响商店，箱子和恶魔房的道具生成#头顶有剑时受伤，在随机时间后，角色会自动死亡"}, --  Damocles
	[578] = {"578", "免费柠檬水", "生成大范围的黄色水迹"}, --  Free Lemonade
	[579] = {"579", "英灵剑", "攻击方式改为挥剑#{{Damage}} 每次挥舞造成3.5+300%角色伤害#{{Chargeable}} 可蓄力发动旋转攻击，造成10+800%角色伤害，同时发射剑气，造成4.0+400%角色伤害#{{Damage}} 总心数大于心之容器数时，挥剑会发射剑气，造成2.0+100%角色伤害"}, --  Spirit Sword
	[580] = {"580", "红钥匙", "在合适的墙壁上生成新房间的入口，可生成时墙壁上显示红色的门轮廓#产生的房间可以是特殊房间#在13x13的地图范围外产生的房间，进入时将直接传送到{{ErrorRoom}}错误房"}, --  Red Key
	[581] = {"581", "灵能苍蝇", "环绕苍蝇跟班#自动反弹附近的弹幕#造成接触伤害"}, --  Psy Fly
	[582] = {"582", "迷幻蘑菇", "↑ {{Tears}} +0.75射速修正#↓ {{Speed}} -0.03移速#扭曲画面#效果可叠加"}, --  Wavy Cap
	[583] = {"583", "罐中火箭", "{{Bomb}} +5炸弹#若发射时放置炸弹，改为向发射的方向发射火箭"}, --  Rocket in a Jar
	[584] = {"584", "美德之书", "使用时生成1个魂火环绕跟班，发射幽灵眼泪，但可被摧毁#与其它主动道具结合时可产生特殊魂火#将第一个{{DevilRoom}}恶魔房变成{{AngelRoom}}天使房#{{AngelChance}} +12.5%天使房转换率#{{AngelChance}} 恶魔交易后仍会出现天使房"}, --  Book of Virtues
	[585] = {"585", "白玉香膏盒", "使用时生成3{{SoulHeart}}魂心和2个{{AngelRoom}}天使房道具#只能通过捡起魂心充能#{{DevilChance}} 若已进行过恶魔交易，则生成2{{SoulHeart}}魂心和1个{{AngelRoom}}天使房道具"}, --  Alabaster Box
	[586] = {"586", "天堂阶梯", "{{AngelRoom}} 在每一层的初始房间生成梯子，通向1个特殊的天使房道具商店"}, --  The Stairway
	[587] = {"587", "", "<道具不存在>"}, -- Menorah (Unused but skripted)
	[588] = {"588", "太阳", "揭示{{BossRoom}}Boss房位置#击败Boss后在所在层获得：# 激发{{Card20}}“太阳”的效果#{{Battery}} 为主动道具充能#{{CurseBlind}} 移除诅咒#↑ {{Damage}} +3.0伤害#↑ {{Luck}} +1运气"}, --  Sol
	[589] = {"589", "月亮", "为每一层增加1个{{SecretRoom}}隐藏房间和{{SuperSecretRoom}}超级隐藏房间#每层揭示1个{{SecretRoom}}隐藏房#隐藏房间内有光束，接触时获得：#{{HalfSoulHeart}} 半个魂心#↑ {{Tears}} 当前楼层+0.5射速修正 #↑ {{Tears}} 每层第一次接触月光额外获得+0.5射速修正"}, --  Luna
	[590] = {"590", "水星", "↑ {{Speed}} +0.4移速#进入房间后门不会关闭"}, --  Mercurius
	[591] = {"591", "金星", "↑ +1心之容器#{{Heart}} 治疗1红心#{{Charm}} 近距离内的敌人受到魅惑"}, --  Venus
	[592] = {"592", "地球", "↑ {{Damage}} +1.0伤害#眼泪变为石头#每颗伤害不定#可摧毁障碍物#击退增强"}, --  Terra
	[593] = {"593", "火星", "双击移动方向键进行冲锋#{{Damage}} 冲锋时无敌，造成400%角色伤害#3秒冷却时间"}, --  Mars
	[594] = {"594", "木星", "↑ +2心之容器#{{HalfHeart}} 治疗半红心#↓ {{Speed}} -0.3移速#角色免疫中毒伤害#{{Speed}} 不移动时累积至多0.5移速#{{Poison}} 移动时向后释放毒气"}, --  Jupiter
	[595] = {"595", "土星", "生成1个轨道#进入房间时生成7颗眼泪在轨道上环绕#轨道有几率捕获敌人的弹幕"}, --  Saturnus
	[596] = {"596", "天王星", "{{Freezing}} 发射冰冻眼泪，对敌人造成减速效果，击杀时使敌人冻结#冻结的敌人可以推开，撞碎时向四周发射6个冰锥"}, --  Uranus
	[597] = {"597", "海王星", "不发射眼泪时积攒眼泪，最多持续3秒#发射时射出大量眼泪#发射时积攒的眼泪逐渐减少"}, --  Neptunus
	[598] = {"598", "冥王星", "↑ {{Tears}} +0.7射速#体积缩小，可以挤进障碍物间隙#弹幕会从头顶飞过"}, --  Pluto
	[599] = {"599", "巫毒娃娃头", "每层额外生成1个{{CursedRoom}}诅咒房#升级{{CursedRoom}}诅咒房的布局，其中必定包含一枚{{Coin}}硬币"}, --  Voodoo Head
	[600] = {"600", "眼药水", "↑ {{Tears}} 只对左眼+40%射速修正#一段时间内第一次发射总是双发#↑ {{Tears}} 非眼泪攻击+20%射速修正"}, --  Eye Drops
	[601] = {"601", "痛悔短祷", "↑ {{Tears}} +0.7射速#{{EternalHeart}} +1永恒之心#{{AngelChance}} 进行过恶魔交易后天使房仍然会出现#{{AngelDevilChance}} 减缓受红心伤害减少恶魔房/天使房的几率"}, --  Act of Contrition
	[602] = {"602", "会员卡", "{{Shop}} 在商店内生成1个暗门，通向高级商店"}, --  Member Card
	[603] = {"603", "电池组", "{{Battery}} 生成2-4电池#对当前主动道具充能"}, --  Battery Pack
	[604] = {"604", "妈妈的手镯", "可以捡起岩石，TNT，便便，友好粪滴，寄居骷髅等障碍物进行投掷#捡起的东西可以带入下1个房间"}, --  Mom's Bracelet
	[605] = {"605", "挖眼勺", "在当前房间召唤眼球跟班，在地上生成血迹#↑ {{Damage}} 右眼眼泪伤害+34%"}, --  The Scooper
	[606] = {"606", "邪眼裂口", "5%几率发射在落地时生成裂隙的眼泪#{{Luck}} 几率受幸运影响#裂隙吸引周围的敌人，掉落物，弹幕"}, --  Ocular Rift
	[607] = {"607", "脓液囊宝宝", "向四周随机喷射眼泪的跟班#每颗眼泪造成3.5点或5.3点伤害"}, --  Boiled Baby
	[608] = {"608", "冰冻宝宝", "发射石化效果眼泪的跟班#{{Freezing}} 击杀时使敌人冻结"}, --  Freezer Baby
	[609] = {"609", "永恒六面骰", "重置房间内所有道具#道具有30%几率会消失"}, --  Eternal D6
	[610] = {"610", "鸟肥笼", "在被击中时跃向敌人的跟班#造成45点伤害并释放岩石波#之后追逐敌人造成伤害"}, --  Bird Cage
	[611] = {"611", "声带", "使用时发出怒吼，击退周围的敌人，并造成伤害#充能越多，效果越强"}, --  Larynx
	[612] = {"612", "迷失游魂", "幽灵跟班，被击中时死亡，下一层才能复活#如果存活了整层，则生成3魂心，或2永恒之心，或道具"}, --  Lost Soul
	[613] = {"613", "", "<道具不存在>"},
	[614] = {"614", "鲜血炸弹", "↑ +1心之容器#{{Heart}} 治疗5红心#炸弹爆炸时产生血迹#没有炸弹时也可放置炸弹，消耗半红心"}, --  Blood Bombs
	[615] = {"615", "屁球宝宝", "在角色即将受到伤害时放屁，推开附近的敌人与弹幕，同时进入休眠状态#可以在一段时间后走到宝宝旁以唤醒宝宝"}, --  Lil Dumpy
	[616] = {"616", "鸟眼椒", "8%几率发射红火，能阻挡敌人弹幕并造成接触伤害#火焰造成或阻挡4次伤害后或10秒后消失#{{Damage}} 一道火焰最多造成1100%角色伤害#{{Luck}} 运气11：50%几率"}, --  Bird's Eye
	[617] = {"617", "磁石", "17%几率发射使敌人磁化的眼泪#{{Luck}} 运气5：100%几率#磁化的敌人吸引掉落物，弹幕和其它敌人"}, --  Lodestone
	[618] = {"618", "烂番茄", "17%几率发射眼泪标记敌人#{{Luck}} 运气5：100%几率#被标记的敌人受其它敌人攻击"}, --  Rotten Tomato
	[619] = {"619", "长子名分", "不同角色效果不同"}, --  Birthright
	[620] = {"620", "", "<道具不存在>"},
	[621] = {"621", "红豆汤", "↑ {{Damage}} +21.6伤害#增加的伤害会不断衰减，在3分钟后衰减完毕#效果尚存时击杀敌人会延长时间#{{Heart}} 满血"}, --  Red Stew
	[622] = {"622", "创世纪", "{{Warning}} 一次性 {{Warning}}#移除持有的全部道具和掉落物#传送到特殊的卧室，内有掉落物，箱子和暗门#每移除1个道具，就显示1组3个道具供你选择"}, --  Genesis
	[623] = {"623", "尖头钥匙", "{{Key}} +5钥匙#使用时发射1钥匙，可造成伤害，摧毁障碍物，打开箱子或门#被其杀死的敌人有几率掉落箱子里的内容，包括道具"}, --  Sharp Key
	[624] = {"624", "扩展包", "{{Card}} 生成5张随机卡牌"}, --  Booster Pack
	[625] = {"625", "超级蘑菇", "巨化，持续30秒#提升伤害和射程#持续时间内无敌，能踩碎障碍物和敌人#效果可在多个房间内持续"}, --  Mega Mush
	[626] = {"626", "菜刀碎片1", "菜刀跟班的第一部件"}, --  Knife Piece 1
	[627] = {"627", "菜刀碎片2", "与{{Collectible626}}菜刀部件结合，生成1个菜刀跟班#可刺杀敌人#能刺开某个血肉之门"}, --  Knife Piece 2
	[628] = {"628", "死亡证明", "{{Warning}} 一次性 {{Warning}}#传送至含有所有游戏道具的房间#捡起1个道具后回到之前的房间"}, --  Death Certificate
	[629] = {"629", "机器苍蝇", "环绕物，能发射护盾眼泪"}, --  Bot Fly
	[630] = {"630", "", "<道具不存在>"},
	[631] = {"631", "切肉刀", "使敌人分裂为2个小型的，其血量大幅降低"}, --  Meat Cleaver
	[632] = {"632", "邪眼护符", "↑ {{Luck}} +2运气#免疫烧伤，混乱，毒气"}, --  Evil Charm
	[633] = {"633", "教条", "获得飞行和单次{{Collectible313}}神圣斗篷效果#↑ {{Damage}} +2.0伤害#↑ {{Speed}} +0.1移速#如果角色少于6心则以红心和魂心治疗至6心"}, --  Dogma
	[634] = {"634", "炼狱恶鬼", "在有敌人的房间内地面生成裂缝#走过裂缝时会召唤爆炸幽灵"}, --  Purgatory
	[635] = {"635", "织布魔偶", "在房间内生成1个跟班，随角色发射方向移动，造成接触伤害#使用时角色与跟班和其所在位置的内容互换位置，获得短时间无敌#传送的敌人受到大量伤害"}, --  Stitches
	[636] = {"636", "R键", "{{Warning}} 一次性 {{Warning}}#将角色带到新一局开始层#保留道具和掉落物"}, --  R Key
	[637] = {"637", "强力安眠药", "10%几率发射拳头，对敌人造成强力击退和击晕#{{Luck}} 运气9：100%几率"}, --  Knockout Drops
	[638] = {"638", "橡皮擦", "使用时掷出橡皮，秒杀击中的敌人#击杀的敌人在本局游戏中不会再出现#对Boss造成15点伤害#每层只能使用一次"}, --  Eraser
	[639] = {"639", "难吃的心", "使用时获得1腐心"}, --  Yuck Heart
	[640] = {"640", "灵魂之瓮", "喷射火焰#敌人死亡时获得充能"}, --  Urn of Souls
	[641] = {"641", "血田", "战斗时，在身体后方生成一串眼泪#眼泪造成3.5点伤害"}, --  Akeldama
	[642] = {"642", "玄奇驴皮", "{{BrokenHeart}} 将1心之容器或2魂心变为1碎心#从当前房间道具池中生成1个道具#使用次数越多，若不再持有，则后续生成的道具被玄奇驴皮替换的几率越大#如果当前层的底座道具有玄奇驴皮则降低该几率#{{Warning}} 游魂：一次性"}, --  Magic Skin
	[643] = {"643", "终末天启", "{{Chargeable}} 蓄力2.4秒可射出持续1.3秒的神圣光柱#{{Damage}} 光柱造成15次100%角色伤害#获得飞行能力#{{SoulHeart}} +2魂心"}, --  Revelation
	[644] = {"644", "安慰奖", "↑ 提升最低的属性#根据持有数量最少的掉落物，生成3{{Coin}}硬币，1{{Key}}钥匙或1{{Bomb}}炸弹"}, --  Consolation Prize
	[645] = {"645", "小畸胎瘤", "畸胎瘤环绕物#阻挡弹幕#造成接触伤害#被击中3次时分裂成小畸胎瘤#小畸胎瘤被摧毁时产生蓝蜘蛛#被完全摧毁后5秒复活"}, --  Tinytoma
	[646] = {"646", "硫磺火炸弹", "{{Bomb}} +5炸弹#{{Collectible118}} 炸弹爆炸时释放十字硫磺火"}, --  Brimstone Bombs
	[647] = {"647", "4.5伏特", "主动道具清理房间时不充能#改为对敌人造成伤害时充能#充能所需伤害量：40+20*层数"}, --  4.5 Volt
	[648] = {"648", "", "<道具不存在>"},
	[649] = {"649", "甜甜糖梅宝", "迷你甜蝇宝宝跟班#在房间内斜着前进，并发射眼泪"}, --  Fruity Plum
	[650] = {"650", "糖梅溜溜笛", "使用时，在所在房间召唤甜蝇宝宝，持续10秒"}, --  Plum Flute
	[651] = {"651", "伯列恒之星", "向Boss房缓缓移动的跟班#四周有光环，在其中时获得：#↑ {{Damage}} +80%伤害倍率#↑ {{Tears}} x250%射速修正#眼泪有跟踪效果#50%几率抵挡伤害"}, --  Star of Bethlehem
	[652] = {"652", "冰块宝宝", "可被推动的跟班#{{Freezing}} 接触敌人时造成伤害，并具有减速效果，击杀的敌人会被冻结"}, --  Cube Baby
	[653] = {"653", "驱魔护符", "非幽灵的敌人在死亡时生成小的红色幽灵#使用时引爆所有红色幽灵"}, --  Vade Retro
	[654] = {"654", "伪造药学博士证", "识别所有胶囊#{{BlackHeart}} +1黑心#{{Pill}} 好的胶囊自动转化为坏的#↑ {{Damage}} 降低属性的胶囊提供+1.0伤害#{{BlackHeart}} 其它坏胶囊使用时生成1黑心"}, --  False PHD
	[655] = {"655", "幸运转盘", "生成1个陀螺环绕跟班，可阻挡敌人弹幕#每秒造成10.5点接触伤害#↑ 使用时+0.5移速，使所有环绕物加速旋转#对蓝苍蝇和蓝蜘蛛也有效，且使用时无敌"}, --  Spin to Win
	[656] = {"656", "达摩克里斯之剑", "<道具无法获得>"}, -- Damocles
	[657] = {"657", "血管炎", "敌人死亡时爆发出眼泪，受角色眼泪效果影响"}, --  Vasculitis
	[658] = {"658", "巨细胞", "受到伤害时生成小以撒#小以撒自动攻击周围的敌人"}, --  Giant Cell
	[659] = {"659", "托吡卡胺", "↑ {{Range}} +2.5射程#↑ {{Tearsize}} 眼泪变大"}, --  Tropicamide
	[660] = {"660", "牌意解读", "在每层开始时生成2个传送门#离开房间时传送门消失#{{ColorRed}}红色：{{CR}}Boss房#{{ColorYellow}}黄色：{{CR}}道具房#{{ColorBlue}}蓝色：{{CR}}隐藏房"}, --  Card Reading
	[661] = {"661", "五胞胎", "敌人死亡处生成1个跟班，随角色一起发射#最多5个"}, --  Quints
	[662] = {"662", "", "<道具不存在>"}, -- Pacifist (Cut item)
	[663] = {"663", "肉中刺", "每6秒获得1秒无敌时间#转换前会闪光"}, --  Tooth and Nail
	[664] = {"664", "大胃王", "↑ +1心之容器#{{Heart}} 满血#所有道具会周期性地切换为食物道具#捡起食物道具时获得：#↑ {{Damage}} 临时+3.6伤害#↑ 永久提升2项属性#↓ {{Speed}} 永久-0.03移速#{{Heart}} 食物道具治疗3红心"}, --  Binge Eater
	[665] = {"665", "嗝屁猫的眼睛", "显示所有箱子，福袋，店主，火堆的内容"}, --  Guppy's Eye
	[666] = {"666", "", "<道具不存在>"},
	[667] = {"667", "稻草人", "{{Bomb}} +1炸弹#{{Player14}} 生成店主作为第二个角色#店主死亡时生成蓝蜘蛛#店主死亡时该道具消失#{{DevilChance}} 店主活着时恶魔交易花费硬币#!!! 店主能够捡起道具，包括剧情道具，死亡时也会永久移除"}, --  Strawman
	[668] = {"668", "爸爸的便条", "踏上回家的路#留在之前{{TreasureRoom}}道具房或{{BossRoom}}Boss房的饰品会变成 {{Card78}} 破裂的钥匙"}, --  Dad's Note
	[669] = {"669", "腊肠", "↑ +1心之容器#{{Heart}} 满血#↑ {{Damage}} +0.5伤害#↑ {{Speed}} +0.2移速#↑ {{Range}} +2.5射程#↑ {{Shotspeed}} +0.16弹速#↑ {{Luck}} +1运气#{{AngelDevilChance}} +6.9%恶魔房/天使房几率#{{Planetarium}} +6.9%星象房几率"}, --  Sausage
	[670] = {"670", "选择？", "如果清理的房间有奖励，产生2种不同的奖励#捡起其一后另1个奖励消失"}, --  Options?
	[671] = {"671", "糖心", "捡起红心时获得永久的属性提升#{{Heart}} 生成1红心"}, --  Candy Heart
	[672] = {"672", "一磅肉", "{{DevilChance}} 恶魔交易消耗硬币#{{Shop}} 商店里的道具消耗心之容器#{{Shop}} 商店里的其它物品免费，但被尖刺环绕"}, --  A Pound of Flesh
	[673] = {"673", "赎罪", "{{DevilChance}} 进入恶魔房但拒绝恶魔的诱惑时，于进入下一层后获得：#{{SoulHeart}} +1魂心#↑ {{Damage}} +1.0伤害"}, --  Redemption
	[674] = {"674", "灵魂枷锁", "死亡时，灵魂被锁链束缚在尸体上，可以继续战斗，血量为半个魂心#10 秒后复活#此效果捡起魂心后才能再次发动"}, --  Spirit Shackles
	[675] = {"675", "碎裂的宝珠", "受伤时，显示本层1个随机房间#并打开此房间锁住的门#破坏房间中所有的标记石头和有夹层的石头#可以打开超级撒旦房间与红色肉门#可显示{{UltraSecretRoom}}终极隐藏房间"}, --  Cracked Orb
	[676] = {"676", "空虚之心", "在开始新一层时，若只有1红心或更少，获得{{EmptyHeart}}1空的心之容器#对无法获得红心的角色无效"}, --  Empty Heart
	[677] = {"677", "灵魂出窍", "受伤时，暂停时间3秒#此时间内变为幽灵#幽灵具有飞行和幽灵眼泪，且免疫一次伤害"}, --  Astral Projection
	[678] = {"678", "剖腹产", "{{Chargeable}} 获得短延迟蓄力攻击，发射婴儿样式的跟踪幽灵眼泪#{{Damage}} 胎儿造成每秒6次75%角色伤害"}, --  C Section
	[679] = {"679", "亚巴顿宝宝", "{{Collectible399}} 发射迷你虚空之喉进行攻击的跟班"}, --  Lil Abaddon
	[680] = {"680", "水土不服症", "{{Chargeable}} 发射时，可蓄力发射短程硫磺火#从角色后方发射"}, --  Montezuma's Revenge
	[681] = {"681", "黑洞宝宝", "向发射方向飞行，并造成接触伤害的跟班#飞行时吸收掉落物#每吸收1个，增加体积和伤害，生成1只蓝苍蝇#每吸收4个，生成1个通向未探索房间的传送门"}, --  Lil Portal
	[682] = {"682", "触手朋友", "地面伸出一条触手，并束缚敌人#受缚的敌人受到伤害，减速并无法移动"}, --  Worm Friend
	[683] = {"683", "骨刺", "敌人死亡时生成悬浮的骨头#可阻挡弹幕并造成接触伤害"}, --  Bone Spurs
	[684] = {"684", "饥饿幽魂", "击杀敌人时有33%几率生成幽灵#{{Luck}} 生成几率不受运气影响#幽灵追踪敌人，造成接触伤害#5秒后幽灵爆炸，对敌人造成最多3次7.0点伤害#角色不会受到爆炸伤害"}, --  Hungry Soul
	[685] = {"685", "魂火罐", "使用时生成随机魂火，可发射各种眼泪，阻挡弹幕，造成接触伤害#使用次数越多生成数量越多"}, --  Jar of Wisps
	[686] = {"686", "灵魂吊坠", "捡起魂心时获得永久的属性提升#{{SoulHeart}} 生成1魂心"}, --  Soul Locket
	[687] = {"687", "寻友护符", "使用时生成1个永久魅惑的敌人，并模拟角色移动和攻击"}, --  Friend Finder
	[688] = {"688", "内在孩童", "+1额外生命#在所在房间内复活，复活时拥有半红心，体型大幅减小，{{Speed}}+0.2移速"}, --  Inner Child
	[689] = {"689", "错误王冠", "道具在5个随机选择间快速切换"}, --  Glitched Crown
	[690] = {"690", "肚肚软糖", "接触时弹开敌人#敌人被弹到障碍物上时受到伤害#有50%几率使角色免疫接触伤害#有50%几率反射敌人弹幕"}, --  Belly Jelly
	[691] = {"691", "十字圣球", "阻止品质为{{Quality0}}/{{Quality1}}的道具生成#33%几率重置品质为{{Quality2}}的道具"}, --  Sacred Orb
	[692] = {"692", "血色羁绊", "在恶魔房间内生成地刺#在地刺上献祭，可以获得以下奖励：#35%：无#33%：↑+0.5伤害#15%：6硬币#10%：2黑心# 5%：随机{{DevilRoom}}恶魔房道具# 2%：变形为{{Leviathan}}利维坦"}, --  Sanguine Bond
	[693] = {"693", "虫群", "获得8只环绕苍蝇，苍蝇被击中时变为蓝色苍蝇#每清理1个房间，生成1只环绕苍蝇"}, --  The Swarm
	[694] = {"694", "心碎", "{{BrokenHeart}} 获得3碎心#↑ {{Damage}} 每个碎心+0.25伤害#受致命伤害时增加2碎心#碎心达到12个时死亡"}, --  Heartbreak
	[695] = {"695", "嗜血腥风", "受伤时，在所在层提升{{Speed}}移速和{{Tears}}射速#最多+1.02移速，+3射速修正"}, --  Bloody Gust
	[696] = {"696", "救恩", "生成光环，其内的敌人受光柱攻击#受伤次数越多，光圈越大，进入新一层时恢复初始大小"}, --  Salvation
	[697] = {"697", "消失的胞胎", "跟班，在进入Boss房时，变成Boss的复制#将其击败掉落额外道具#复制的Boss动作较慢，血量只有真正Boss的75%"}, --  Vanishing Twin
	[698] = {"698", "作孽双子", "2个与角色并排而行的跟班#攻击方式与角色相同#{{Damage}} 每个宝宝造成37.5%的角色伤害#{{Player13}} 人物为莉莉丝则造成50%角色伤害"}, --  Twisted Pair
	[699] = {"699", "阿撒泻勒之怒", "清理房间获得怒气#清理4个房间后，在进入新房间时，发射{{Collectible118}}超粗硫磺火"}, --  Azazel's Rage
	[700] = {"700", "回声室", "使用卡牌，胶囊，符文时，发动在获得此道具之后使用过的最近3个卡牌，胶囊，符文的效果"}, --  Echo Chamber
	[701] = {"701", "以撒的坟墓", "在每层开始时生成1个需要钥匙解锁{{DirtyChest}}老箱子#老箱子含有魂心，饰品或道具#道具为{{AngelRoom}}天使房道具或爸爸，妈妈相关的道具"}, --  Isaac's Tomb
	[702] = {"702", "复仇之魂", "受伤时，生成魂火环绕跟班，在所在层持续#最多6个#发射眼泪，但无法阻挡敌人弹幕"}, --  Vengeful Spirit
	[703] = {"703", "小以扫", "使用时在当前角色和小以扫之间切换，小以扫初始拥有3黑心，{{Damage}}+2.0伤害和飞行#2个角色不共享生命值和道具#第一次使用时获得与角色等量的随机被动道具#{{Warning}} 任意角色死亡，游戏结束"}, --  Esau Jr.
	[704] = {"704", "狂怒！", "使用时进入狂暴状态5秒：#↑ {{Speed}} +0.4移速#↑ {{Tears}} x50%+2.0射速修正#↑ {{Damage}} +3.0伤害#只能使用特定近战武器#狂怒状态下击杀敌人可延长此状态持续时间1秒"}, --  Berserk!
	[705] = {"705", "暗仪刺刀", "使用时在1秒内+1.0移速，可穿过敌人和弹幕#对每个接触的敌人造成角色3.5+200%角色伤害，每经过1个敌人再+3.5#效果结束时的爆炸伤害等于之前伤害的总和"}, --  Dark Arts
	[706] = {"706", "无底坑", "摧毁房间内所有道具，每摧毁1个，生成一只攻击型苍蝇跟班#苍蝇具有的效果与摧毁的道具有关"}, --  Abyss
	[707] = {"707", "晚餐", "↑ +1心之容器#{{Heart}} 治疗1红心"}, --  Supper
	[708] = {"708", "订书机", "↑ {{Damage}} +1.0伤害#眼泪只从一只眼睛发射"}, --  Stapler
	[709] = {"709", "背摔！", "使用时冲向敌人或Boss，将其举起，再掷向地面#可控制投掷地点#投掷造成50伤害，并产生岩石波#伤害和影响范围与角色大小成比例"}, --  Suplex!
	[710] = {"710", "合成宝袋", "可收集储存最多8个掉落物，不能再拿出#集满时使用可将掉落物合成为道具#掉落物越稀有，合成的道具品质越高"}, --  Bag of Crafting
	[711] = {"711", "生死逆转", "当进入含有道具底座的房间中，道具后会显示另一个阴影道具#使用后，调换两者位置#拿走第一个道具后使用则两者都可拿走#!!! 如果在拿走第一个道具后离开房间则阴影道具会消失"}, --  Flip
	[712] = {"712", "所罗门魔典", "生成环绕的被动道具形跟班#获得该被动道具的效果#生成道具有25%几率本房间道具池内的道具"}, --  Lemegeton
	[713] = {"713", "圣血吸管", "移除半心并创造血凝块跟班#每种心的产生的血凝块的血量，伤害和眼泪效果不同"}, --  Sumptorium
	[714] = {"714", "召回", "使用时立刻召回遗骸的身体"}, --  Recall
	[715] = {"715", "保留", "保存1便便炸弹，以备后用"}, --  Hold
	[716] = {"716", "店主的胯袋", "在捡起时生成3{{Coin}}硬币和1{{Key}}钥匙#{{Shop}} 每花费3个硬币购买物品可获得以下一项提升：#↑ {{Damage}} +0.5伤害#↑ {{Range}} +0.25射程#↑ {{Speed}} +0.03移速"}, --  Keeper's Sack
	[717] = {"717", "店主的亲友", "岩石和障碍物在被摧毁时生成2只蓝蜘蛛#岩石在有敌人的房间中偶尔会产生蓝蜘蛛"}, --  Keeper's Kin
	[718] = {"718", "", "<道具不存在>"}, -- Keepers Robe (Cut item)
	[719] = {"719", "店主的盒子", "生成1个可购买的商店道具/掉落物"}, --  Keeper's Box
	[720] = {"720", "百宝罐", "使用时生成掉落物，使用时的充能不同，效果不同#满充能时具有强力随机效果#充能：1:便便 2:{{Coin}} 3:{{Bomb}} 4:{{Key}} 5:{{Heart}} 6:{{Pill}} 7:{{Card}} 8:{{SoulHeart}} 9:{{GoldenHeart}} 10:{{GoldenKey}} 11:{{GoldenBomb}}"}, --  Everything Jar
	[721] = {"721", "错误技", "使未来获得的所有物品混乱#其效果完全随机"}, --  TMTRAINER
	[722] = {"722", "孤魂铁索", "禁锢离角色最近的敌人5秒"}, --  Anima Sola
	[723] = {"723", "计数二十面骰", "将房间内所有道具转变为内部ID减1的道具"}, --  Spindown Dice
	[724] = {"724", "高凝血", "{{Heart}} 受伤时生成半红心或整红心#产生的红心在1.5秒后消失"}, --  Hypercoagulation
	[725] = {"725", "大肠激躁症", "造成足够伤害后，停止攻击并触发随机{{Player25}}堕化???的效果：#投掷随机便便#生成增益水迹#放有毒的屁#放置5个激活的炸弹"}, --  IBS
	[726] = {"726", "咯血症", "双击发射键咯血#{{Damage}} 对前方的敌人造成150%角色伤害#1秒冷却时间#{{BrimstoneCurse}} 被击中的敌人会受到硫磺火束的额外伤害"}, --  Hemoptysis
	[727] = {"727", "幽灵炸弹", "{{Bomb}} +5炸弹#爆炸时生成幽灵，对敌人造成接触伤害，幽灵10秒后爆炸"}, --  Ghost Bombs
	[728] = {"728", "格罗", "生成附着脑袋上的恶魔跟班#复制角色眼泪，属性和效果#{{Damage}} 跟班造成75%的角色伤害#{{Player13}} 人物为莉莉丝则造成100%角色伤害"}, --  Gello
	[729] = {"729", "飞头攻击", "使用时将脑袋投掷出去造成接触伤害，可在落点发射眼泪#再次使用或接触时可收回脑袋"}, --  Decap Attack
	[730] = {"730", "玻璃眼", "↑ {{Damage}} +0.75伤害#↑ {{Luck}} +1运气"}, -- Glass Eye
	[731] = {"731", "麦粒肿", "!!! 只对右眼有效#↑ {{Damage}} +1.0伤害#↑ {{Range}} +7.0射程#↓ {{Shotspeed}} -0.3弹速"}, --  Stye
	[732] = {"732", "妈妈的戒指", "↑ {{Damage}} +1.0伤害#{{Rune}} 生成1随机符文或魂石"}, --  Mom's Ring

}
EID:updateDescriptionsViaTable(repCollectibles, EID.descriptions[languageCode].collectibles)

---------- Modifiers ----------

EID.descriptions[languageCode].birthright ={
	{"以撒", "", "所有道具在2个选择间切换"},
	{"抹大拉", "", "↑ +1心之容器#心上限提高到18"},
	{"该隐", "", "↑ {{Luck}} +1运气#除暗室和宝箱层外，所有层都含有一个升级的赌博房#极大增强{{Collectible46}}幸运脚的获胜几率提高的效果"},
	{"犹大", "", "{{Collectible34}}彼列之书变成类似于{{Collectible584}}美德之书的被动道具#如果未持有{{Collectible34}}彼列之书则获得彼列之书#获得的伤害加成与在其上的主动道具充能量成比例#对特定的主动道具会获得特殊效果"},
	{"???", "", "生命提升获得的魂心翻倍"},
	{"夏娃", "", "无论血量如何，巴比伦娼妇始终激活#不受伤死鸟也会激活"},
	{"参孙", "", "嗜血获得额外4次伤害加成，新的上限为+14伤害"},
	{"阿撒泻勒", "", "阿撒泻勒的硫磺火变得更宽，就像超级喷射一样#对伤害无影响"},
	{"拉撒路", "", "无特殊效果，除非死亡并以复活的拉撒路重生#{{Damage}} 复活的拉撒路+7.2额外伤害#额外伤害在接下来的一分钟内逐渐衰退#击杀敌人可以延长获得额外伤害的时间"},
	{"伊甸", "", "从随机道具池生成3个随机道具#只能拿1个"},
	{"游魂", "", "不再产生对游魂无好处的道具#比如：生命提升，飞行，幽灵眼泪，受伤有效的道具"},
	{"复活的拉撒路", "", "{{Damage}} 获得+7.2额外伤害#额外伤害在接下来的一分钟内逐渐衰退#击杀敌人可以延长获得额外伤害的时间"},
	{"黑暗犹大", "", "{{Collectible34}}彼列之书变成类似于{{Collectible584}}美德之书的被动道具#如果未持有{{Collectible34}}彼列之书则获得彼列之书#获得的伤害加成与在其上的主动道具充能量成比例"},
	{"莉莉丝", "", "跟班在莉莉丝面前位置"},
	{"店主", "", "↑ +1心之容器"},
	{"亚玻伦", "", "使用{{Collectible477}}虚空时有几率生成之前被虚空化的道具#属性加成保留#使用的次数越多，生成道具的几率越高"},
	{"遗骸", "", "灵魂不再受锁，可自由移动"},
	{"遗骸之魂", "", "灵魂不再受锁，可自由移动"},
	{"伯大尼", "", "使用魂心充能主动道具时几率不消耗魂心"},
	{"雅各", "", "拿起这个道具的角色获得另1个角色3个被动道具的复制"},
	{"以扫", "", "拿起这个道具的角色获得另1个角色3个被动道具的复制"},
	{"堕化以撒", "", "增加4个额外被动道具槽位#本身不占用槽位"},
	{"堕化抹大拉", "", "增加1不流失的红心"},
	{"堕化该隐", "", "道具生成的掉落物数量翻倍"},
	{"堕化犹大", "", "{{Collectible705}}暗仪刺刀击中敌人和弹幕的范围变大"},
	{"堕化???", "", "增加便便最大携带量为29"},
	{"堕化夏娃", "", "死亡的红心血凝块生成红心，2秒后消失"},
	{"堕化参孙", "", "堕化参孙杀死敌人时狂暴计时器增加3秒而不是1秒"},
	{"堕化阿撒泻勒", "", "堕化阿撒泻勒的{{Collectible726}}咯血症攻击大小加倍"},
	{"堕化拉撒路", "", "生成另一种状态的角色的幻影作为副角色#幻影免疫伤害，可以发射眼泪，造成25%的伤害#主角色对首领的伤害降低20%#两个角色都有长子名分的效果"},
	{"堕化伊甸", "", "在长子权之前拿到的被动和主动道具不再因为受伤而重置"},
	{"堕化游魂", "", "获得1额外生命#复活的游魂在相同房间中重生并对附近敌人造成200点伤害"},
	{"堕化莉莉丝", "", "正常跟随堕化莉莉丝的跟班与{{Collectible728}}格罗行为一致#每个跟班造成的近战伤害+3"},
	{"堕化店主", "", "强力吸引短距离消灭的敌人掉落的硬币#对其他硬币无效果"},
	{"堕化亚玻伦", "", "如果按住发射键，蝗虫会持续对敌人造成伤害而不返回"},
	{"堕化遗骸", "", "堕化灵魂获得{{Collectible714}}召回能力，自动将堕化遗骸从远处取回"},
	{"堕化伯大尼", "", "生成4个品质{{Quality3}}和{{Quality4}}的随机道具魂火，血量比正常魂火高很多"},
	{"堕化雅各", "", "黑暗以扫分为两个#两者都会同时冲刺"},
	{"死亡的堕化拉撒路", "", "生成另一种状态的角色的幻影作为副角色#幻影免疫伤害，可以发射眼泪，造成25%的伤害#主角色对首领的伤害降低20%#两个角色都有长子名分的效果"},
	{"堕化雅各2", "", "黑暗以扫分为两个#两者都会同时冲刺#使用{{Collectible722}}孤魂铁索可将两者拴住"},
	{"堕化遗骸之魂", "", "堕化灵魂获得{{Collectible714}}召回能力，自动将堕化遗骸从远处取回"},
}

-- Buffs caused by Binge Eater
-- Note: "#" will be replaced with "#{{Collectible664}} " automatically, in order to add Binge eater icon infront of each buff-bulletpoint

EID.descriptions[languageCode].bingeEaterBuffs = {
	[22] = "↑ {{Tears}} +0.5射速#↑ {{Range}} +2.5射程#↓ {{Speed}} -0.03移速", -- Lunch
	[23] = "↑ {{Tears}} +0.5射速#↑ {{Shotspeed}} +0.2弹速#↓ {{Speed}} -0.03移速", -- Dinner
	[24] = "↑ {{Damage}} +1.0额外伤害#↑ {{Shotspeed}} +0.2弹速#↓ {{Speed}} -0.03移速", -- Dessert
	[25] = "↑ {{Shotspeed}} +0.2弹速#↑ {{Range}} +2.5射程#↓ {{Speed}} -0.03移速", -- Breakfast
	[26] = "↑ {{Damage}} +1.0额外伤害#↑ {{Range}} +2.5射程#↓ {{Speed}} -0.03移速", -- Rotten Meat
	[346] = "↑ {{Shotspeed}} +0.2弹速#↑ {{Luck}} +1运气#↓ {{Speed}} -0.03移速", -- A Snack
	[456] = "↑ {{Damage}} +1.0额外伤害#↑ {{Luck}} +1运气#↓ {{Speed}} -0.03移速", -- Midnight Snack
	[707] = "↑ {{Tears}} +0.5射速#↑ {{Luck}} +1运气#↓ {{Speed}} -0.03移速", -- Supper
}

-- Buffs caused by Book of Belial with Judas' Birthright
-- Note: "#" will be replaced with "#{{Collectible34}} " automatically, in order to add Book of Belial icon infront of each buff-bulletpoint
EID.descriptions[languageCode].bookOfBelialBuffs = {
	[40] = "同时产生{{Collectible35}}死灵之书效果", -- Kamikaze!
	[126] = "同时产生{{Collectible35}}死灵之书效果", -- Razor Blade
	[127] = "下一层中获得伤害提升", -- Forget me Now
	[133] = "获得永久伤害提升", -- Guppy's Paw
	[135] = "每次使用获得伤害提升", -- IV Bag
	[147] = "铁镐耐久，击退提高，使用速度更快，使敌人着火，摧毁便便和障碍物时掉落更多掉落物", -- Notched Axe
	[186] = "同时产生{{Collectible126}}剃刀片效果", -- Blood Rights
	[282] = "留下一路火焰，能造成接触伤害并使敌人着火", -- How to Jump
	[290] = "一次消耗1心，获得伤害提升并在地上留下血迹", -- The Jar
	[295] = "有几率产生{{Collectible555}}金剃刀片效果", -- Magic Fingers
	[297] = "除正常奖励外，还生成1个恶魔类跟班", -- Pandora's Box
	[323] = "发射的眼泪伤害增强", -- Isaac's Tears
	[352] = "破碎时激活彼列之书，伤害提升在大炮修复完之前保留", -- Glass Cannon
	[475] = "若能重生，重生为黑暗犹大", -- Plan C
	[482] = "将最后获得的道具换成{{Collectible51}}五芒星", -- Clicker
	[487] = "获得更高的永久伤害提升", -- Potato Peeler
	[536] = "每献祭1个跟班获得10.8临时伤害提升，像{{Collectible621}}红豆汤一样会缓慢降低", -- Sacrificial Altar
	[555] = "对房间中的敌人造成伤害并施加{{Collectible202}}弥达斯之触", -- Golden Razor
	[577] = "获得永久伤害提升", -- Damocles
	[582] = "根据当前剩余使用次数，在所在层获得额外伤害", -- Wavy Cap
	[585] = "将奖励改为2黑心和1恶魔房道具#如果做过恶魔交易则变为3黑心和2恶魔房道具", -- Alabaster Box
	[622] = "获得免费的{{Collectible51}}五芒星", -- Genesis
	[623] = "同时产生{{Collectible126}}剃刀片效果", -- Sharp Key
	[635] = "在你和织布魔偶之间产生1个{{Collectible705}}暗仪刺刀", -- Stitches
	[640] = "发射{{Collectible118}}硫磺火而不是火焰", -- Urn of Souls
	[642] = "获得永久伤害提升", -- Magic Skin
	[653] = "幽灵会跟踪敌人", -- Vade Retro
	[685] = "获得{{Collectible292}}撒但圣经魂火，能够提高恶魔交易几率", -- Jar of Wisps
	[705] = "能够获得临时伤害提升", -- Dark Arts
	[710] = "捡起红心时有几率将其替换成黑心", -- Bag of Crafting
	[729] = "当头分离时，获得高额的伤害和射速提升", -- Decap Attack
}

-- Book of Virtues wisp types
EID.descriptions[languageCode].bookOfVirtuesWisps = {
	[33] = "跟踪眼泪", -- The Bible
	[34] = "双倍伤害眼泪", -- The Book of Belial
	[35] = "3.5%几率发射恐惧眼泪#摧毁时触发死灵之书效果", -- The Necronomicon
	[36] = "2.5%几率发射大肠杆菌效果的眼泪", -- The Poop
	[37] = "摧毁时生成分裂炸弹", -- Mr. Boom
	[38] = "快速但不精准的眼泪", -- Tammy's Head
	[39] = "5%几率发射石化眼泪", -- Mom's Bra
	[40] = "爆炸眼泪#摧毁时爆炸", -- Kamikaze!
	[41] = "7.5%几率发射恐惧眼泪", -- Mom's Pad
	[42] = "7.5%几率发射吐根眼泪", -- Bob's Rotten Head
	[44] = "10%几率发射传送敌人的眼泪#魂火每5秒进行闪烁", -- Teleport!
	[45] = "20%几率击杀敌人掉落红心", -- Yum Heart
	[47] = "半伤害眼泪#使用时所有此类魂火向准线发射3颗爆炸眼泪", -- Doctor's Remote
	[49] = "不能发射眼泪#使用时所有此类魂火发射激光", -- Shoop da Whoop!
	[56] = "快速但低射程眼泪#魂火会滴落黄色水迹", -- Lemon Mishap
	[58] = "免疫弹幕", -- Book of Shadows
	[65] = "摧毁时生成1个即爆炸弹", -- Anarchist Cookbook
	[66] = "摧毁时使敌人减速3秒", -- The Hourglass
	[77] = "额外的接触伤害", -- My Little Unicorn
	[78] = "不能发射眼泪#摧毁时在所在房间生成1个七印跟班", -- Book of Revelations
	[83] = "击退眼泪", -- The Nail
	[84] = "无特殊效果", -- We Need to Go Deeper!
	[85] = "摧毁时生成1卡牌", -- Deck of Cards
	[86] = "牙齿眼泪", -- Monstro's Tooth
	[93] = "反重力眼泪#几率为恐惧眼泪", -- The Gamekid
	[97] = "8选1魂火：{{Collectible65}}{{Collectible42}}{{Collectible85}}{{Collectible102}}{{Collectible37}}{{Collectible177}}{{Collectible49}}{{Collectible45}}#很有可能为爆炸效果", -- The Book of Sin
	[102] = "6选1魂火，每局随机#几率为中毒，石化，迷惑，烧伤，即爆炸弹眼泪，或者在摧毁时生成1红蜘蛛#摧毁时生成1胶囊", -- Mom's Bottle of Pills
	[105] = "每重置1个道具额外生成1魂火", -- The D6
	[107] = "穿透眼泪", -- The Pinking Shears
	[111] = "摧毁时产生毒气", -- The Bean
	[123] = "随机眼泪", -- Monster Manual
	[124] = "生成对应的魂火", -- Dead Sea Scrolls
	[126] = "高血量魂火", -- Razor Blade
	[127] = "生成仅存在于当前层的无限血量魂火", -- Forget Me Now
	[130] = "不能发射眼泪#魂火会向角色发射方向冲刺", -- A Pony
	[133] = "3个高血量魂火", -- Guppy's Paw
	[135] = "无特殊效果", -- IV Bag
	[136] = "7.5%几率发射标记眼泪#标记的敌人会被其他敌人攻击", -- Best Friend
	[137] = "放置的炸弹爆炸时生成1魂火#在引爆炸弹时此类魂火也会爆炸", -- Remote Detonator
	[145] = "使用时生成魂火而不是苍蝇#摧毁时生成1蓝苍蝇", -- Guppy's Head
	[146] = "跟踪眼泪", -- Prayer Card
	[147] = "摧毁岩石时几率生成5选1魂火#几率发射煤炭，迷惑，硬币，双倍伤害或激光眼泪", -- Notched Axe
	[158] = "快速，自动瞄准的眼泪", -- Crystal Ball
	[160] = "接触时召唤光束", -- Crack the Sky
	[164] = "单房间魂火", -- The Candle
	[166] = "摧毁所有掉落物，每个都有一定几率生成1魂火", -- D20
	[171] = "7.5%几率发射减速眼泪", -- Spider Butt
	[175] = "魂火会解锁碰到的箱子/门，包括超级撒但，回溯，尸宫的门", -- Dad's Key
	[177] = "根据获得的奖励生成魂火", -- Portable Slot
	[181] = "10%几率发射圣光眼泪", -- White Pony
	[186] = "高血量魂火", -- Blood Rights
	[192] = "跟踪眼泪", -- Telepathy for Dummies
	[263] = "15%几率击杀敌人掉落符文#摧毁时生成1符文", -- Clear Rune
	[282] = "最多6个不动的魂火", -- How to Jump
	[283] = "重置魂火，额外增加1魂火#不重置美德之书", -- D100
	[284] = "移除魂火，每持有2个道具生成1随机魂火#不重置美德之书", -- D4
	[285] = "击中时有10%几率产生D10效果", -- D10
	[286] = "15%几率击杀敌人掉落卡牌#摧毁时生成1卡牌", -- Blank Card
	[287] = "摧毁时产生碎裂的宝珠效果", -- Book of Secrets
	[288] = "使用时生成魂火而不是蜘蛛#摧毁时生成1蓝蜘蛛", -- Box of Spiders
	[289] = "单房间魂火#红火焰眼泪", -- Red Candle
	[290] = "使用时生成魂火而不是红心#摧毁时几率生成半红心", -- The Jar
	[291] = "每有1便便类敌人额外生成1魂火", -- Flush!
	[292] = "每有1此类魂火+10%{{DevilRoom}}恶魔房或{{AngelRoom}}天使房几率", -- Satanic Bible
	[293] = "摧毁时发射4向激光", -- Head of Krampus
	[294] = "单房间魂火#不能发射眼泪#摧毁时产生棉豆的效果", -- Butter Bean
	[295] = "摧毁时几率生成1硬币", -- Magic Fingers
	[296] = "无特殊效果", -- Converter
	[297] = "无特殊效果", -- Pandora's Box
	[298] = "不能发射眼泪#免疫接触伤害#只有激活独角兽的残角才会造成接触伤害", -- Unicorn Stump
	[323] = "生成6魂火#只能维持3秒", -- Isaac's Tears
	[324] = "黏土饼干眼泪", -- Undefined
	[325] = "电弧群眼泪", -- Scissors
	[326] = "受伤时生成魂火", -- Breath of Life
	[338] = "单房间魂火#回旋眼泪", -- The Boomerang
	[347] = "完美视力眼泪#使其他魂火翻倍", -- Diplopia
	[348] = "摧毁时生成1胶囊", -- Placebo
	[349] = "摧毁时有50%几率生成1硬币", -- Wooden Nickel
	[351] = "使用时所有此类魂火产生岩石波#摧毁时石化敌人并产生毒气", -- Mega Bean
	[352] = "摧毁时摧毁所有此类魂火#魂火在切换房间时保留", -- Glass Cannon
	[357] = "所在房间内复制魂火", -- Box of Friends
	[382] = "捕获敌人死亡时会生成1个普通，跟踪，爆炸，或硫磺火魂火，与敌人行动方式有关", -- Friendly Ball
	[383] = "魂火的眼泪能被引爆，变成6个角色眼泪#摧毁时爆出角色眼泪#在不同房间能够保留", -- Tear Detonator
	[386] = "5%几率发射击中时能重置方格物体(除便便和TNT)的眼泪", -- D12
	[396] = "不能发射眼泪#每个传送门有1魂火", -- Ventricle Razor
	[406] = "随机伤害和射速", -- D8
	[419] = "20%几率发射传送敌人的眼泪#魂火每5秒进行闪烁", -- Teleport 2.0
	[421] = "摧毁时产生魅惑屁", -- Kidney Bean
	[422] = "30%几率发射石化眼泪", -- Glowing Hour Glass
	[427] = "在房间中弹动，被角色击中时爆炸#不能发射眼泪，也不造成接触伤害", -- Mine Crafter
	[434] = "使用时生成魂火而不是苍蝇#最多5苍蝇产生1个血量和伤害有所增强的魂火", -- Jar of Flies
	[437] = "第一次击中时产生七面骰效果", -- D7
	[439] = "无特殊效果", -- Mom's Box
	[441] = "小硫磺火眼泪(需要释放发射键)#所有此类魂火在超级喷射使用期间持续发射", -- Mega Blast
	[475] = "8个高伤害魂火", -- Plan C
	[476] = "如果没复制掉落物则生成第二个魂火", -- D1
	[477] = "生成所有吸收的主动道具的魂火#本身不生成魂火", -- Void
	[478] = "摧毁时暂停所有敌人和弹幕3秒", -- Pause
	[479] = "摧毁时几率生成1饰品", -- Smelter
	[480] = "摧毁的掉落物越多，生成的魂火血量越高", -- Compost
	[481] = "5%几率发射将敌人变成随机魂火的眼泪", -- Dataminer
	[482] = "生成1随机魂火", -- Clicker
	[483] = "8个在摧毁时生成金即爆炸弹的魂火", -- Mama Mega!
	[484] = "单房间魂火#不能发射眼泪#摧毁时产生等等，啥？的效果", -- Wait What?
	[485] = "所有此类魂火在其中一个受伤时摧毁或复制", -- Crooked Penny
	[486] = "不能发射眼泪#几率抵消角色受到的伤害", -- Dull Razor
	[487] = "永久魂火#追逐敌人并发射眼泪#不阻挡弹幕也不造成接触伤害", -- Potato Peeler
	[488] = "生成模仿道具的魂火(如果不是主动道具则随机)", -- Metronome
	[489] = "生成1普通魂火，带有模仿的骰子的魂火效果", -- D Infinity
	[490] = "生成1随机魂火#若被摧毁，则清理房间后重生", -- Eden's Soul
	[504] = "单房间魂火#快速，自动瞄准的眼泪", -- Brown Nugget
	[507] = "击杀时几率生成1魂火", -- Sharp Straw
	[510] = "萌死戳的肺，腐烂宝宝，洛基的角或硫磺火眼泪", -- Delirious
	[512] = "磁性眼泪", -- Black Hole
	[515] = "生成1随机魂火#若被摧毁，则清理房间后重生", -- Mystery Gift
	[516] = "发射像洒水器一样的8向眼泪", -- Sprinkler
	[521] = "三重眼泪#如果买东西，摧毁所有的此类魂火", -- Coupon
	[522] = "捕捉的弹幕会变成魂火", -- Telekinesis
	[523] = "魂火只在掉落物品时生成#摧毁时生成随机掉落物", -- Moving Box
	[527] = "不能发射眼泪#清理房间后，魂火会打来箱子/门", -- Mr. ME!
	[536] = "将所有魂火变成半红心#献祭时生成1强力魂火", -- Sacrificial Altar
	[545] = "摧毁时生成1友好的骷髅仔", -- Book of the Dead
	[550] = "眼泪有10%几率对敌人触发践踏", -- Broken Shovel
	[552] = "眼泪有10%几率对敌人触发践踏#另会生成1个高血量魂火，不能发射眼泪", -- Mom's Shovel
	[555] = "15%几率发射点金术眼泪", -- Golden Razor
	[556] = "短距离硫磺火眼泪", -- Sulfur
	[557] = "每有1此类魂火+0.2运气", -- Fortune Cookie
	[577] = "无特殊效果", -- Damocles
	[578] = "魂火会滴落黄色水迹", -- Free Lemonade
	[580] = "当进入新房间时几率创建红门", -- Red Key
	[582] = "最多1个此类魂火", -- Wavy Cap
	[584] = "多个复制无效果", -- Book of Virtues
	[585] = "8魂火", -- Alabaster Box
	[604] = "单房间魂火#东西落地时生成3魂火#10%几率发射迷惑眼泪", -- Mom's Bracelet
	[605] = "无特殊效果", -- The Scooper
	[609] = "无敌的魂火#使用时有50%几率摧毁所有此类魂火", -- Eternal D6
	[611] = "血量和伤害根据充能提升", -- Larynx
	[622] = "3魂火#移除所有其他魂火", -- Genesis
	[623] = "无特殊效果", -- Sharp Key
	[631] = "将你的魂火分割成两份(血量和伤害减半)#第三次分割时摧毁魂火", -- Meat Cleaver
	[635] = "留下1个不动的魂火#最多6个此类魂火", -- Stitches
	[636] = "无魂火", -- R Key
	[638] = "接触时消除非Boss敌人", -- Eraser
	[639] = "不能发射眼泪#清理房间后生成1蓝苍蝇", -- Yuck Heart
	[640] = "几率发射蓝火眼泪", -- Urn of Souls
	[642] = "有毒眼泪", -- Magic Skin
	[650] = "当甜蝇宝宝对角弹跳时，所有此类魂火也如此", -- Plum Flute
	[653] = "无魂火#红幽灵能发射眼泪", -- Vade Retro
	[655] = "使用时产生临时魂火", -- Spin to Win
	[685] = "生成的魂火加倍，再额外加1", -- Jar of Wisps
	[687] = "生成1随机魂火", -- Friend Finder
	[703] = "无特殊效果", -- Esau Jr.
	[704] = "高血量魂火#不能发射眼泪", -- Berserk
	[705] = "每杀死1个敌人产生1个单房间魂火", -- Dark Arts
	[706] = "高血量魂火#不能发射眼泪", -- Abyss
	[709] = "单房间魂火#落地时生成3魂火", -- Suplex
	[710] = "合成时生成1随机魂火", -- Bag of Crafting
	[711] = "无特殊效果", -- Flip
	[712] = "道具魂火能够发射跟踪眼泪", -- Lemegeton
	[713] = "无魂火", -- Sumptorium
	[719] = "20%几率击杀敌人掉落硬币", -- Keeper's Box
	[720] = "生成1随机魂火", -- Everything Jar
	[722] = "环绕被拴住的敌人并攻击#敌人死亡时魂火消失", -- Anima Sola
	[723] = "将所有魂火重置为相同类型", -- Spindown Dice
	[728] = "所有魂火围绕格罗", -- Gello
	[729] = "不动的魂火", -- Decap Attack
}

-- Special Locust effects when Item was eaten by Abyss
EID.descriptions[languageCode].abyssSynergies = {
	[2] = "3只普通蝗虫", -- The Inner Eye
	[3] = "紫色跟踪蝗虫", -- Spoon Bender
	[4] = "红色大蝗虫，能造成3倍伤害", -- Cricket's Head
	[6] = "黄色短距离快速蝗虫，能快速造成伤害", -- Number One
	[7] = "红色蝗虫，能造成双倍伤害", -- Blood of the Martyr
	[10] = "2只灰色蝗虫，能造成一半伤害", -- Halo of Flies
	[13] = "绿色蝗虫，能使敌人中毒", -- The Virus
	[103] = "绿色蝗虫，能使敌人中毒", -- The Common Cold
	[118] = "较大的灰色蝗虫，其他性质正常", -- Brimstone
	[149] = "绿色缓慢大蝗虫，能造成150%角色伤害并使敌人中毒", -- Ipecac
	[153] = "4只普通蝗虫", -- Mutant Spider
	[257] = "橙色燃烧的蝗虫，能使敌人着火", -- Fire Mind
	[305] = "绿色蝗虫，能使敌人中毒", -- Scorpio
	[374] = "青色发光蝗虫，能生成光束造成300%角色伤害", -- Holy Light
	[494] = "淡蓝色蝗虫，带有造成50%电击伤害的电弧", -- Jacob's Ladder
	[559] = "淡蓝色蝗虫，带有造成50%电击伤害的电弧", -- 120 Volt
}

---------- Trinkets ----------

local repTrinkets={
	[1] = {"1", "被吞下的硬币", "{{Coin}} 受伤时生成1硬币#{{Player14}} 店主：受伤时生成0-1硬币"}, -- Swallowed Penny
	[10] = {"10", "扭扭虫", "眼泪波形前进#↑ {{Tears}} +0.4射速#获得幽灵眼泪效果"}, -- Wiggle Worm
	[11] = {"11", "环形虫", "眼泪高速螺旋前进#↑ {{Tears}} +0.4射速#获得幽灵眼泪效果"}, -- Ring Worm
	[15] = {"15", "幸运石", "{{Coin}} 摧毁岩石有33%几率掉落硬币"},-- Lucky Rock
	[23] = {"23", "寻人启事", "{{Player10}} 死亡后会以游魂重生 #如果未解锁游魂，在持有该饰品的情况下于{{SacrificeRoom}}献祭房中死亡可以解锁游魂#{{Player31}} 堕化游魂死亡仍会复活为其自身"},-- Lucky Rock
	[24] = {"24", "屁股硬币", "{{Coin}} 便便产生硬币的几率+20%#捡起硬币时放屁#{{Poison}} 屁会使敌人中毒并击退敌人和弹幕"}, -- Butt Penny
	[26] = {"26", "钩形虫", "眼泪直角前进#↑ {{Tears}} +0.4射速#↑ {{Range}} +1.5射程#获得幽灵眼泪效果"}, -- Hook Worm
	[32] = {"32", "裸盖蘑菇", "每个房间25%几率出现随机蘑菇效果"}, -- Liberty Cap
	[33] = {"33", "脐带", "当进入房间后不多于半心时，获得{{Collectible100}}小史蒂文#受伤时高几率生成{{Collectible318}}双子座的跟班"}, -- Umbilical Cord
	[39] = {"39", "癌症", "↑ {{Tears}} +1.0射速修正"}, -- Cancer
	[48] = {"48", "遗失的书页", "受伤时5有%几率对房间内所有敌人造成80点伤害#黑心和类似{{Collectible35}}死灵之书的效果造成双倍伤害"}, -- A Missing Page
	[49] = {"49", "染血硬币", "{{HalfHeart}} 捡起硬币时有25%几率生成半红心"}, -- Bloody Penny
	[50] = {"50", "焦灼硬币", "{{Bomb}} 捡起硬币时有25%几率生成炸弹"}, -- Burnt Penny
	[51] = {"51", "扁平硬币", "{{Key}} 捡起硬币时有25%几率生成钥匙"}, -- Flat Penny
	[65] = {"65", "长条虫", "↑ {{Range}} +3.0射程"}, -- Tape Worm
	[66] = {"66", "懒散虫", "↓ {{Shotspeed}} -0.5弹速"}, -- Lazy Worm
	[69] = {"69", "褪色的全家福", "随机使角色伪装#迷惑敌人#可以用于打开前往\"家\"的门"}, -- Faded Polaroid
	[80] = {"80", "黑色羽毛", "↑ {{Damage}} 每持有1个\"邪恶上升\"道具+0.5伤害"}, -- Black Feather
	[92] = {"92", "碎裂的王冠", "↑ 使道具原始增益提高20%"}, -- Cracked Crown
	[96] = {"96", "衔尾虫", "眼泪螺旋式快速前进#↑ {{Tears}} +0.4射速#↑ {{Range}} +1.5射程#获得幽灵眼泪效果#几率为跟踪眼泪"}, -- Ouroboros Worm
	[98] = {"98", "鼻涕泡", "{{Poison}} 10%几率发射跟踪粘性有毒眼泪#{{Damage}} 每秒造成100%角色伤害#能粘住10秒"}, -- Nose Goblin
	[101] = {"101", "暗灯泡", "!!! 当主动道具无充能时：#↑ {{Damage}} +1.5伤害#↑ {{Speed}} +0.5移速#↑ {{Range}} +1.5射程#↑ {{Tears}} +0.5射速#↑ {{Shotspeed}} +0.3弹速#↑ {{Luck}} +2运气"}, -- Dim Bulb
	[110] = {"110", "银币", "{{Shop}} 商店会出现在子宫层和腐尸层"},
	[111] = {"111", "染血王冠", "{{TreasureRoom}} 道具房会出现在子宫层和腐尸层"}, -- Bloody Crown
	[119] = {"119", "干细胞", "{{Heart}} 进入下一层时治疗空的心之容器/骨心的一半#至少治疗半红心"}, -- Stem Cell
	[125] = {"125", "扩接电线", "使跟班以电束相连#每束造成6.0点伤害#也会在合作玩家之间产生电束(包括雅各和以扫)"}, -- Stem Cell
	[128] = {"128", "指骨", "{{EmptyBoneHeart}} 受伤时有4%几率获得骨心"}, -- Finger Bone
	[129] = {"129", "崩掉牙", "10%几率发射牙齿眼泪#{{Damage}} 牙齿造成320%角色伤害#{{Luck}} 运气9：100%几率"}, --  Jawbreaker
	[130] = {"130", "嚼烂的笔", "{{Slow}} 10%几率发射减速眼泪#{{Luck}} 运气18：100%几率"}, --  Chewed Pen
	[131] = {"131", "神圣硬币", "{{SoulHeart}} 捡起硬币时有17%几率生成半魂心"}, --  Blessed Penny
	[132] = {"132", "损坏的注射器", "25%几率在所在房间内获得随机药剂效果"}, --  Broken Syringe
	[133] = {"133", "短引线", "角色放置的炸弹爆炸更快"}, --  Short Fuse
	[134] = {"134", "巨豆", "增加屁的大小"}, --  Gigante Bean
	[135] = {"135", "打火机", "{{Burning}} 进入房间时有20%几率对敌人施加燃烧效果"}, --  A Lighter
	[136] = {"136", "损坏的挂锁", "门，钥匙砖和金箱子可以用爆炸打开#也可以打开前往\"家\"的门"}, --  Broken Padlock
	[137] = {"137", "勿忘草", "到下一层时，先前层未收集的最多4个掉落物在初始房间生成"}, --  Myosotis
	[138] = {"138", "'M", "使用主动道具会将其重置"}, --  'M
	[139] = {"139", "泪滴护符", "{{Luck}} 对基于运气的眼泪效果+3运气"}, --  Teardrop Charm
	[140] = {"140", "所多玛之果", "捡起红心可将其变成蓝蜘蛛#满血时也有效#效果可能会消耗用于治疗的红心"}, --  Apple of Sodom
	[141] = {"141", "失落摇篮曲", "提高跟班的射速"}, --  Forgotten Lullaby
	[142] = {"142", "伯大尼的信仰", "到下一层时生成4个{{Collectible584}}美德之书魂火"}, --  Beth's Faith
	[143] = {"143", "老旧电容", "阻止主动道具充能#{{Battery}} 清理房间后有20%几率生成电池"}, --  Old Capacitor
	[144] = {"144", "脑形虫", "眼泪如果会打不中敌人，则90度转向敌人"}, --  Brain Worm
	[145] = {"145", "满分考卷", "↑ {{Luck}} +10运气#持有时受到怪物，尖刺等非主动伤害时摧毁"}, -- Perfection
	[146] = {"146", "恶魔王冠", "{{RedTreasureRoom}} 道具房现在含有恶魔交易"}, --  Devil's Crown
	[147] = {"147", "充能硬币", "{{Battery}} 捡起硬币时有17%几率对主动道具充能1格"}, --  Charged Penny
	[148] = {"148", "友谊项链", "使跟班围着角色"}, --  Friendship Necklace
	[149] = {"149", "紧急按钮", "受伤时自动使用满充能的主动道具，但不免费"}, --  Panic Button
	[150] = {"150", "蓝钥匙", "进入需要钥匙的房间会将角色带到类似死寂层的房间#这个房间处于2个房间之间"}, --  Blue Key
	[151] = {"151", "扁锉", "尖刺全部缩回，不造成伤害#也影响{{CursedRoom}}诅咒房的门和任何尖刺障碍物"}, --  Flat File
	[152] = {"152", "望远镜片", "{{PlanetariumChance}} 提高星象房基础几率为10%#{{PlanetariumChance}} 第一次产生星象房前额外增加15%几率#生成星象房后仍可生成星象房#{{PlanetariumChance}} 在第一次进入后几率保持为10%#星象房可在子宫和尸宫生成"}, --  Telescope Lens
	[153] = {"153", "妈妈的发髻", "每个房间有25%几率获得随机妈妈道具的效果"}, --  Mom's Lock
	[154] = {"154", "骰子袋", "每次进入新房间，有50%几率获得1个一次性的随机骰子#离开房间后消失"}, --  Dice Bag
	[155] = {"155", "神圣王冠", "在大教堂里生成{{TreasureRoom}}道具房和商店{{Shop}}"}, --  Holy Crown
	[156] = {"156", "母亲的吻", "持有时获得1心之容器#{{Player14}} 对店主也有效"}, --  Mother's Kiss
	[157] = {"157", "扑克牌残片", "每15次发射，发射1个{{Collectible149}}吐根酊+{{Collectible5}}我的镜像眼泪，其射程值极高"}, --  Torn Card
	[158] = {"158", "破损的口袋", "每当角色受伤时，随机生成2个硬币、炸弹或钥匙#掉落物可能是原有形态的变种，如金钥匙，镍币等"}, --  Torn Pocket
	[159] = {"159", "镀金钥匙", "{{Key}} 首次捡起时+1钥匙#{{GoldenChest}} 以金箱子替换所有新箱子(除了旧箱子和巨型箱子)#{{GoldenChest}} 所有金箱子包含卡牌，胶囊或饰品#对巨型箱子无效"}, --  Gilded Key
	[160] = {"160", "幸运袋", "到下一层时生成1福袋"}, --  Lucky Sack
	[161] = {"161", "邪恶王冠", "在地狱生成{{TreasureRoom}}道具房和{{Shop}}商店"}, --  Wicked Crown
	[162] = {"162", "阿撒泻勒的残角", "{{Player7}} 清理房间后有50%几率变为阿撒泻勒#效果持续到清理或离开另一个房间"}, --  Azazel's Stump
	[163] = {"163", "粪蛋", "所有粪滴敌人友好#清理房间后生成1个随机粪滴"}, --  Dingle Berry
	[164] = {"164", "火药圈", "{{Bomb}} 放置炸弹时生成1个额外炸弹"}, --  Ring Cap
	[165] = {"165", "滚啊！", "在子宫或更深层，将所有硬币和钥匙以炸弹，心，胶囊，卡牌，饰品，电池，或红苍蝇取代"}, --  Nuh Uh!
	[166] = {"166", "塑型黏土", "每个房间有50%几率获得随机被动道具效果"}, --  Modeling Clay
	[167] = {"167", "抛光骨头", "清理房间后有25%几率生成友好的骷髅仔"}, --  Polished Bone
	[168] = {"168", "空壳心", "{{EmptyBoneHeart}} 进入新一层时+1骨心"}, --  Hollow Heart
	[169] = {"169", "儿童涂鸦", "{{Guppy}} 持有时当做1个嗝屁猫套装道具"}, --  Kid's Drawing
	[170] = {"170", "水晶钥匙", "{{Collectible580}} 清理房间后有33%几率打开一个与当前房间相连的红房间#红房间中触发几率降低"}, --  Crystal Key
	[171] = {"171", "店主的协议", "{{DevilChance}} 50%几率使恶魔交易花费硬币而不是心"}, --  Keeper's Bargain
	[172] = {"172", "诅咒硬币", "{{Coin}} 捡起硬币时传送至随机房间#可以传送到隐藏房"}, --  Cursed Penny
	[173] = {"173", "你的灵魂", "{{DevilChance}} 免费进行一次恶魔交易"}, --  Your Soul
	[174] = {"174", "数字冰箱贴", "{{DevilChance}} +10%恶魔房几率#防止恶魔交易中出现坎卜斯"}, --  Number Magnet
	[175] = {"175", "奇怪的钥匙", "解锁窒息胎战通道，不再限时#使用{{Collectible297}}潘多拉的盒子时从随机道具池生成6个道具，原效果失效#使用后两者都会被消耗"}, --  Strange Key
	[176] = {"176", "小血团", "生成1个血块跟班，模仿角色的行动，发射方向和眼泪效果#如果跟班死亡则在下一个房间重生"}, --  Lil Clot
	[177] = {"177", "纹身贴", "清理{{ChallengeRoom}}挑战房后生成1箱子，清理{{BossRushRoom}}Boss挑战房后生成1道具"}, --  Temporary Tattoo
	[178] = {"178", "被吞下的M80鞭炮", "受伤时有50%几率爆炸"}, --  Swallowed M80
	[179] = {"179", "赛车遥控器", "跟班的移动与玩家控制角色的方式一致#按住掉落键使跟班留在原地，就像雅各和以扫一样"}, --  RC Remote
	[180] = {"180", "复得游魂", "精确跟随角色移动的跟班，发射幽灵眼泪#属性与角色一样，造成一半伤害#一击死亡#新一层重生"}, --  Found Soul
	[181] = {"181", "扩展电路板", "使用主动道具时随机触发另1个1-2充能的主动道具"}, --  Expansion Pack
	[182] = {"182", "伯大尼的精华", "进入{{AngelRoom}}天使房时生成5魂火#当给乞丐钱时有25%几率生成1魂火"}, --  Beth's Essence
	[183] = {"183", "双胞胎", "每个房间有50%几率复制1个跟班#没有跟班则以{{Collectible8}}波比兄弟或{{Collectible67}}玛姬姐妹代替"}, --  The Twins
	[184] = {"184", "领养协议书", "{{Shop}} 商店变为宝宝商店，每个跟班卖10硬币"}, --  Adoption Papers
	[185] = {"185", "蟋蟀腿", "杀死敌人时有17%几率生成1只随机蝗虫"}, --  Cricket Leg
	[186] = {"186", "亚玻伦的挚友", "{{Collectible706}} 生成1只天启蝗虫"}, --  Apollyon's Best Friend
	[187] = {"187", "碎掉的眼镜", "{{TreasureRoom}} 50%几率在道具房添加1个额外的问号道具#{{TreasureRoom}} 50%几率揭示分支路线的问号道具"}, --  Broken Glasses
	[188] = {"188", "冰块", "进入房间时有20%几率石化1个敌人#{{Freezing}} 击杀石化的敌人可将其冻结"}, --  Ice Cube
	[189] = {"189", "巴风特之印", "杀死敌人时产生1秒护盾#期间杀死敌人额外增加1秒"}, --  Sigil of Baphomet
}
EID:updateDescriptionsViaTable(repTrinkets, EID.descriptions[languageCode].trinkets)
EID.descriptions[languageCode].goldenTrinket = "双倍效果！"
EID.descriptions[languageCode].tripledTrinket = "三倍效果！"
EID.descriptions[languageCode].quadrupledTrinket = "四倍效果！"

-- Most trinkets that can be doubled or tripled just have the numbers in their description multiplied
-- A few trinkets have odd edge cases where their effect completely changes, or is different depending on if it's Mom's Box or Golden
EID.descriptions[languageCode].goldenTrinketEffects = {
	-- Isaac's Fork (find+replace): find Phrase #1 in the localized description, change it to Phrase #2 or 3 for doubled/tripled
	[46] = { "半红心", "1红心", "1.5红心" },
	-- Tick (replace): A full replacement for Golden / Mom's Box / Both, as the Golden version can be removed and only one effect is tripled
	[53] = {
		"-{{ColorGold}}30{{CR}}%Boss血量#进入{{BossRoom}}Boss房时治疗{{ColorGold}}2{{CR}}红心#{{ColorGold}}可被替换！",
		"-{{ColorGold}}30{{CR}}%Boss血量#进入{{BossRoom}}Boss房时治疗{{ColorGold}}2{{CR}}红心#!!! 捡起后无法被其他饰品替换#只能被{{Trinket41}}火柴棒移除或吞下",
		"-{{ColorGold}}30{{CR}}%Boss血量#进入{{BossRoom}}Boss房时治疗{{ColorGold}}3{{CR}}红心#{{ColorGold}}可被替换！",
	},
	-- Rainbow Worm (append): With Mom's Box, it gives 2 copies of the temp worm, and doubles 1 of those copies, for triple effect
	[64] = { "双倍蠕虫属性效果", "三倍蠕虫属性效果", "四倍蠕虫属性效果", },
	-- Error (append): Same behavior as Rainbow Worm
	[75] = { "如果可能，双倍饰品效果", "如果可能，三倍饰品效果", "如果可能，四倍饰品效果", },
	-- NO!
	[88] = { "阻止品质{{Quality0}}道具生成" },
	-- Gilded Key (Golden version only): it doesn't give a key. bug that will get fixed (maybe it'll give a Golden Key?)
	[159] = { "以金箱子代替所有箱子(旧/大箱子除外)#金箱子中含有额外的卡牌，胶囊或饰品" },
}

---------- Cards ----------

local repCards={
	[2] = {"2", "I-魔术师", "当前房间获得：#跟踪眼泪#↑ {{Range}} +3.0射程"}, -- I - The Magician
	[12] = {"12", "XI-力量", "↑ +1心之容器#↑ {{Damage}} +0.3伤害#↑ {{Damage}} +50%伤害倍率#↑ {{Range}} +2.5射程#↑ {{Speed}} +0.3移速#仅所在房间"}, -- XI - Strength
	[18] = {"18", "XVII-星星", "{{TreasureRoom}} 传送至道具房#{{Planetarium}} 如果当前层有星象房，则改为传送至星象房"}, -- XVII - The Star
	[27] = {"27", "梅花A", "{{Bomb}} 将所有掉落物，箱子，非Boss敌人变成炸弹"}, -- Ace of Clubs
	[28] = {"28", "方片A", "{{Coin}} 将所有掉落物，箱子，非Boss敌人变成硬币"}, -- Ace of Diamonds
	[29] = {"29", "黑桃A", "{{Key}} 将所有掉落物，箱子，非Boss敌人变成钥匙"}, -- Ace of Spades
	[30] = {"30", "红桃A", "{{Heart}} 将所有掉落物，箱子，非Boss敌人变成红心"}, -- Ace of Hearts
	[39] = {"39", "保护符文", "无敌20秒"}, -- Algiz
	[51] = {"51", "神圣卡", "{{HolyMantle}} 获得神圣斗篷效果#(即免疫一次伤害)#受到伤害前始终有效"}, -- Holy Card
	[52] = {"52", "变巨术", "↑ {{Damage}} +7.0额外伤害#↑ {{Range}} +3.0射程#粉碎经过的岩石#体型变大#效果在所在房间持续"}, -- Huge Growth
	[55] = {"55", "符文碎片", "随机符文效果#触发的符文效果较弱"}, -- Rune Shard
	[56] = {"56", "0-愚者？", "将所有心和掉落物掉在地上#只保留半心#如果数量充足，可作为{{Collectible74}}25美分和{{Collectible19}}轰！生成"}, -- 0 - The Fool?
	[57] = {"57", "I-魔术师？", "生成较大的光环，排斥弹幕和敌人#持续1分钟"}, -- I - The Magician?
	[58] = {"58", "II-女祭司？", "妈腿持续践踏1分钟"}, -- II - The High Priestess?
	[59] = {"59", "III-皇后？", "获得1分钟效果：#↑ +2红心#↑ {{Tears}} +1.35射速"}, -- III - The Empress?
	[60] = {"60", "IV-皇帝？", "传送至额外Boss房，有额外战利品#Boss来自下一章节"}, -- IV - The Emperor?
	[61] = {"61", "V-教皇？", "{{EmptyBoneHeart}} 生成2骨心"}, -- V - The Hierophant?
	[62] = {"62", "IV-恋人？", "从所在房间的道具池中生成1个道具#{{BrokenHeart}} 将1心之容器或2魂心转化为1碎心"}, -- VI - The Lovers?
	[63] = {"63", "VII-战车？", "变成无敌的固定雕像10秒#↑ {{Tears}} 期间获得x400%射速修正"}, -- VII - The Chariot?
	[64] = {"64", "VIII-正义？", "生成2-4个金箱子"}, -- VIII - Justice?
	[65] = {"65", "IX-隐者？", "将房间内掉落物和道具转化成硬币#硬币值等同于其在商店的价格"}, -- IX - The Hermit?
	[66] = {"66", "X-命运之轮？", "随机骰子房效果"}, -- X - Wheel of Fortune?
	[67] = {"67", "XI-力量？", "{{Weakness}} 使当前房间内的敌人虚弱，减速并受到双倍伤害#持续1分钟"}, -- XI - Strength?
	[68] = {"68", "XII-倒吊人？", "{{Player14}} 将角色变为店主30秒#获得三重射击并降低移速#杀死敌人掉落随机硬币"}, -- XII - The Hanged Man?
	[69] = {"69", "XIII-死亡？", "产生{{Collectible545}}亡者之书的效果#(所在房间内每杀死1个敌人生成1个骨头实体)"}, -- XIII - Death?
	[70] = {"70", "XIV-节制？", "{{Pill}} 吃下5个随机胶囊"}, -- XIV - Temperance?
	[71] = {"71", "XV-恶魔？", "产生{{Collectible33}}圣经的效果#获得{{Collectible390}}撒拉弗#持续30秒"}, -- XV - The Devil?
	[72] = {"72", "XVI-塔？", "生成6堆随机岩石和障碍物#其中经常会有标记石头"}, -- XVI - The Tower?
	[73] = {"73", "XVII-星星？", "移除最旧的被动道具(初始道具除外)#从所在房间的道具池中生成2个随机道具"}, -- XVII - The Stars?
	[74] = {"74", "XVIII-月亮？", "传送至{{UltraSecretRoom}}终极隐藏房#返回的路由红房间构成"}, -- XVIII - The Moon?
	[75] = {"75", "XIX-太阳？", "获得{{Collectible159}}夜之精灵#↑ {{Damage}} +1.5伤害#在所在层持续#将红心转化为骨心，但效果结束后恢复#施加黑暗诅咒"}, -- XIX - The Sun?
	[76] = {"76", "XX-审判？", "生成1台{{RestockMachine}}补货机"}, -- XX - Judgement?
	[77] = {"77", "XXI-世界？", "生成1个{{LadderRoom}}暗门"}, -- XXI - The World?
	[78] = {"78", "红钥匙碎片", "{{Collectible580}} 一次性的红钥匙"}, -- Cracked Key
	[79] = {"79", "红桃Q", "{{Heart}} 生成1-12红心"}, -- Queen of Hearts
	[80] = {"80", "万用牌", "复制上一次使用过的胶囊，卡牌，符文，魂石或主动道具的效果"}, -- Wild Card
	[81] = {"81", "以撒的魂石", "重置房间内的道具#1秒周期地与原道具循环切换#多次使用则所有重置都循环切换"}, -- Soul of Isaac
	[82] = {"82", "抹大拉的魂石", "所在房间内角色被冒泡的红色光环围绕#被杀死的敌人掉落半红心，但2秒后消失"}, -- Soul of Magdalene
	[83] = {"83", "该隐的魂石", "打开房间中所有门#{{Collectible580}} 与红钥匙类似，创造所有可能的红房间"}, -- Soul of Cain
	[84] = {"84", "犹大的魂石", "将角色变成幻影，经过角色路径的敌人会被麻痹#几秒后，攻击所有麻痹的敌人，每个目标会对伤害有加成"}, -- Soul of Judas
	[85] = {"85", "???的魂石", "{{Poison}} 产生8团毒气并留下棕色水迹#然后放置7个大便炸弹#站在水迹中获得：#↑ {{Tears}} +1.35射速#↑ {{Damage}} +1.0伤害"}, -- Soul of ???
	[86] = {"86", "夏娃的魂石", "14只{{Collectible117}}死鸟跟班飞入并攻击敌人#所在房间有效"}, -- Soul of Eve
	[87] = {"87", "参孙的魂石", "变成狂暴参孙，使用近战攻击10秒#↑ {{Speed}} +0.4移速#↑ {{Tears}} x50%+2.0射速修正#↑ {{Damage}} +3.0伤害"}, -- Soul of Samson
	[88] = {"88", "阿撒泻勒的魂石", "产生{{Collectible441}}超级喷射的效果7.5秒"}, -- Soul of Azazel
	[89] = {"89", "拉撒路的魂石", "死亡并立即以半心复活，并在一段时间内无敌#受致命伤时自动使用"}, -- Soul of Lazarus
	[90] = {"90", "伊甸的魂石", "重置所在房间的底座道具和掉落物#道具使用随机道具池进行重置"}, -- Soul of Eden
	[91] = {"91", "游魂的魂石", "{{Player10}} 所在房间角色死亡并变成游魂#免费拿{{DevilRoom}}恶魔房1个道具，剩下的会消失#可以直接进入陵墓或炼狱"}, -- Soul of the Lost
	[92] = {"92", "莉莉丝的魂石", "添加1个随机跟班"}, -- Soul of Lilith
	[93] = {"93", "店主的魂石", "{{Coin}} 生成3-25随机硬币"}, -- Soul of the Keeper
	[94] = {"94", "亚玻伦的魂石", "生成15只随机蝗虫"}, -- Soul of Apollyon
	[95] = {"95", "遗骸的魂石", "{{Player16}} 所在房间生成遗骸作为临时第二角色"}, -- Soul of the Forgotten
	[96] = {"96", "伯大尼的魂石", "生成6个随机属性的{{Collectible584}}美德之书的魂火"}, -- Soul of Bethany
	[97] = {"97", "雅各与以扫的魂石", "{{Player20}} 所在房间生成以扫作为临时第二角色#以扫含有与角色等量的随机被动道具"}, -- Soul of Jacob and Esau
}
EID:updateDescriptionsViaTable(repCards, EID.descriptions[languageCode].cards)

-- Card Buffs caused by Tarot Cloth
-- Note: "#" will be replaced with "#{{Collectible451}}" automatically, in order to add Tarot Cloth icon infront of each buff-bulletpoint

EID.descriptions[languageCode].tarotClothBuffs = {
	[2] = "同时获得{{Collectible34}}彼列之书效果", -- I - The Magician
	[3] = "第一只脚落下后马上落下第二只", -- II - The High Priestess
	[4] = "属性提升量为4倍", -- III - The Empress
	[5] = "如果Boss尚未击败，传送时获得1魂心", -- IV - The Emperor
	[6] = "生成3魂心", -- V - The Hierophant
	[7] = "生成3红心", -- VI - The Lovers
	[8] = "双倍持续时间", -- VII - The Chariot
	[9] = "双倍掉落物生成", -- VIII - Justice
	[10] = "阻止贪婪在商店生成#如果已与贪婪战斗过，将商店变成普通的商店", -- IX - The Hermit
	[11] = "生成2台赌博机", -- X - Wheel of Fortune
	[12] = "属性提升量翻倍，伤害倍数除外", -- XI - Strength
	[14] = "造成80点伤害", -- XIII - Death
	[15] = "生成2台献血机", -- XIV - Temperance
	[16] = "伤害提升量翻倍", -- XV - The Devil
	[17] = "生成12个即爆炸弹", -- XVI - The Tower
	[18] = "如果道具房尚未进入过，产生2道具以供选择", -- XVII - The Stars
	[21] = "生成2个乞丐", -- XX - Judgement
	[56] = "同时掉落最后拾取的6个道具，将其生成为底座道具", -- 0 - The Fool?
	[59] = "获得3临时的心之容器", -- III - The Empress?
	[61] = "生成6骨心", -- V - The Hierophant?
	[62] = "添加4碎心并生成4道具", -- VI - The Lovers?
	[64] = "生成4-14个金箱子", -- VIII - Justice?
	[70] = "吃下10个随机胶囊", -- XIV - Temperance?
	[72] = "生成14岩石堆", -- XVI - The Tower?
	[73] = "移除2道具并生成4道具", -- XVII - The Stars?
	[76] = "生成2台{{RestockMachine}}补货机", -- XX - Judgement?
}

---------- Pills ----------

local repPills={
	[4] = {"3", "炸弹变钥匙", "交换炸弹和钥匙的数量#金炸弹和金钥匙也会交换"}, -- Bombs are Key
	[12] = {"11", "射程下降", "↓ {{Range}} -1.0射程"}, -- Range Down
	[13] = {"12", "射程上升", "↑ {{Range}} +1.25射程"}, -- Range Up
	[42] = {"41", "好困…", "使房间内所有敌人和角色减速"}, -- I'm Drowsy...
	[43] = {"42", "好兴奋！！！", "使房间内所有敌人和角色加速#在30秒以及60秒后再次触发一次"}, -- I'm Excited!!!
	[48] = {"47", "弹速下降", "↓ {{Shotspeed}} -0.15弹速"}, -- Shot Speed Down
	[49] = {"48", "弹速上升", "↑ {{Shotspeed}} +0.15弹速"}, -- Shot Speed Up
	[50] = {"49", "实验性胶囊", "↑ 提升1项随机属性#↓ 降低另外1项随机属性#有{{Collectible75}}药学博士证，{{Collectible46}}幸运脚或{{Collectible303}}处女座时不降属性#有{{Collectible654}}伪造药学博士证时不升属性"}, -- Experimental Pill
	[9999] = {"", "", "随机胶囊效果#使用几次后摧毁"}, -- Golden Pill
}
EID:updateDescriptionsViaTable(repPills, EID.descriptions[languageCode].pills)

EID.descriptions[languageCode].horsepills={
	{"0", "剧毒臭屁", "{{Poison}} 使整个房间敌人中毒"}, -- Bad Gas
	{"1", "过激幻觉", "对角色造成2心伤害#若致死则变成体力回满胶囊"}, -- Bad Trip
	{"2", "钢铁双蛋", "{{SoulHeart}} +4魂心"}, -- Balls of Steel
	{"3", "炸弹变钥匙", "交换炸弹和钥匙的数量#增加炸弹和钥匙的量50%#金炸弹和金钥匙也会交换"}, -- Bombs are Key
	{"4", "爆炸性腹泻", "在角色位置生成一些激活的会跟踪的超级炸弹"}, -- Explosive Diarrhea
	{"5", "体力回满", "满血#{{SoulHeart}} +3魂心"}, -- Full Health
	{"6", "体力下降", "↓ -2心之容器#若致死则变为体力上升胶囊"}, -- Health Down
	{"7", "体力上升", "↑ +2空的心之容器"}, -- Health Up
	{"8", "我找到枚怪药", "无效果"}, -- I Found Pills
	{"9", "青春期", "无效果"}, -- Puberty
	{"10", "漂亮苍蝇", "添加1个{{Collectible279}}大粉丝苍蝇环绕物#无上限"}, -- Pretty Fly
	{"11", "射程下降", "↓ {{Range}} -2.0射程"}, -- Range Down
	{"12", "射程上升", "↑ {{Range}} +2.5射程"}, -- Range Up
	{"13", "移速下降", "↓ {{Speed}} -0.24移速"}, -- Speed Down
	{"14", "移速上升", "↑ {{Speed}} +0.3移速"}, -- Speed Up
	{"15", "射速下降", "↓ {{Tears}} -0.56射速"}, -- Tears Down
	{"16", "射速上升", "↑ {{Tears}} +0.70射速"}, -- Tears Up
	{"17", "运气下降", "↓ {{Luck}} -2运气"}, -- Luck Down
	{"18", "运气上升", "↑ {{Luck}} +2运气"}, -- Luck Up
	{"19", "传送胶囊", "传送到随机房间"}, -- Telepills
	{"20", "48小时能量！", "对主动道具完全充能#{{Battery}} 生成3-4个电池"}, -- 48 Hour Energy!
	{"21", "呕血", "清空红心但保留1红心#{{Heart}} 生成1-4红心"}, -- Hematemesis
	{"22", "麻痹", "不能移动4秒"}, -- Paralysis
	{"23", "我能永远看清！", "打开当前层所有{{SecretRoom}}隐藏房间的入口#揭示全图"}, -- I can see forever!
	{"24", "信息素", "{{Charm}} 将房间内所有敌人永久变成友好的"}, -- Pheromones
	{"25", "失忆症", "{{CurseLost}} 隐藏当前层地图"}, -- Amnesia
	{"26", "柠檬派对", "生成满房间的水迹并对敌人造成接触伤害"}, -- Lemon Party
	{"27", "你是巫师吗？", "进行斜角射击60秒"}, -- R U a Wizard?
	{"28", "止痛药！", "所在房间受到的伤害减半"},  -- Percs!
	{"29", "上瘾！", "所在房间受到的伤害为整心"}, -- Addicted!
	{"30", "放-松", "移动生成便便4秒"}, -- Re-Lax
	{"31", "？？？", "当前层施加迷惑诅咒的效果"}, -- ???
	{"32", "变大胶囊", "体型变很大#不影响被命中的区域"}, -- One makes you larger
	{"33", "变小胶囊", "体型变很小#被命中的区域也变小"}, -- One makes you small
	{"34", "大量滋生！", "房间内每个便便生成2只蓝蜘蛛"}, -- Infested!
	{"35", "大量滋生？", "房间内每有1个敌人就生成2只蓝蜘蛛#房间内没有敌人则生成2-6只蓝蜘蛛"}, -- Infested?
	{"36", "大力丸！", "触发{{Collectible93}}游戏掌机和{{Card52}}“变巨术”的效果"}, -- Power Pill!
	{"37", "复古视野", "屏幕像素化90秒"}, -- Retro Vision
	{"38", "好朋友一辈子！", "生成6只蓝苍蝇"}, -- Friends Till The End!
	{"39", "泻药", "生成一滩长时间保留的打滑水迹"}, -- X-Lax
	{"40", "哪里不对…", "生成一滩长时间保留的减速水迹"}, -- Something's wrong...
	{"41", "好困…", "使房间内所有敌人减速"}, -- I'm Drowsy...
	{"42", "好兴奋！！！", "使房间内所有敌人加速"}, --I'm Excited!!!
	{"43", "咕噜！", "消耗当前饰品并永久获得其效果"}, -- Gulp!
	{"44", "呕！", "{{Collectible149}} 发射1串吐根眼泪"}, -- Horf!
	{"45", "感觉像漫步在阳光下！", "触发{{Collectible93}}的效果，在6秒内：#无敌#{{Fear}} 恐惧所有敌人#无法发射眼泪#造成每秒40点接触伤害#{{HalfHeart}} 吃掉两个敌人回复半个红心"}, -- Feels like I'm walking on sunshine!
	{"46", "嗝！", "生成上次使用的大胶囊"}, -- Vurp!
	{"47", "弹速下降", "↓ {{Shotspeed}} -0.3弹速"}, -- Shot Speed Down
	{"48", "弹速上升", "↑ {{Shotspeed}} +0.3弹速"}, -- Shot Speed Up
	{"49", "实验性胶囊", "↑ 提升1项随机属性两次#↓ 降低另外1项随机属性两次#有{{Collectible75}}药学博士证，{{Collectible46}}幸运脚或{{Collectible303}}处女座时不降属性#有{{Collectible654}}伪造药学博士证"}, -- Experimental Pill
	[9999] = {"", "", "随机胶囊效果#使用几次后摧毁"}, -- Golden Pill
}

---------- Glitched Item Descriptions ----------

EID.descriptions[languageCode].GlitchedItemText = {
	-- This will be appended to words to pluralize them, make it "" to not pluralize
	pluralize = "",

	-- Item Config info
	AddBlackHearts = "{1}黑心",
	AddBombs = "{1}炸弹",
	AddCoins = "{1}硬币",
	AddHearts = "治疗{1}红心",
	AddKeys = "{1}钥匙",
	AddMaxHearts = "{1}心之容器",
	AddSoulHearts = "{1}魂心",

	-- Cache Flag names
	cacheFlagStart = "可能会影响",
	[0] = "伤害", "射速", "弹速", "射程", "移速", "眼泪效果", "眼泪颜色", "飞行", "攻击类型", "跟班", "幸运", "大小", "颜色", "箱子内容物", [16] = "所有属性",

	-- Attribute triggers
	chain = "然后：{{CR}}",
	active = "使用时：#",
	pickup_collected = "捡到掉落物时：#",
	enemy_kill = "击杀时，几率：#",
	damage_taken = "受伤时：#",
	entity_spawned = "当生成{T1}时：#",
	tear_fire = "角色发射眼泪时，几率：#",
	enemy_hit = "击中敌人时，几率：#",
	room_clear = "清理房间后：#",

	-- Attribute effects
	area_damage = "在角色周围造成{1}伤害", 
	add_temporary_effect = "所在房间获得{1}效果",
	convert_entities = "将房间中所有{1}变成{2}",
	use_active_item = "使用{1}",
	spawn_entity = "生成1个{1}",
	fart = "放屁，大小为{1}",

	-- Generic entity names not obtained from entities2.xml
	-- This could also be a place to localize entity names; this table is read from before EID.XMLEntityNames
	["4.-1"] = "即爆炸弹",
	["5.0"] = "掉落物",
	["5.10"] = "心",
	["5.20"] = "硬币",
	["5.30"] = "钥匙",
	["5.40"] = "炸弹掉落物",
	["5.69"] = "福袋",
	["5.70"] = "胶囊",
	["5.90"] = "电池", 
	["5.300"] = "卡牌",
	["9.-1"] = "敌人弹幕",
	["999.-1"] = "方格物体",
	["1000.0"] = "效果",

}

EID.descriptions[languageCode].poopSpells = {
	{"大便", "可以生成掉落物的普通大便"},
	{"玉米大便", "可生成蓝苍蝇的大便"},
	{"燃烧大便", "可对接触的敌人造成伤害#被摧毁后留下一团火焰"},
	{"石化大便", "投掷时可造成3次接触伤害#更难被摧毁"},
	{"恶臭大便", "{{Poison}} 周围会生成毒气云的大便#{{Warning}} 毒气接触火会爆炸!"},
	{"黑大便", "周围会生成减速水迹的大便#被摧毁时造成10点伤害并使所有敌人混乱"},
	{"神圣大便", "{{Collectible543}} 投掷一个白便便#在白便便的光环中：#↑ {{Damage}} +20%伤害倍率#↑ {{Tears}} x250%射速修正#跟踪眼泪#50%几率阻挡伤害#"},
	{"棕色水迹", "留下一道水迹#水迹对踩在上面的敌人造成接触伤害#角色站在水迹上时，会获得伤害和射速加成#当轨迹与其他大便接触时，会获得额外效果"},
	{"屁", "{{Poison}} 推开周围的敌人，并生成一团毒气云#{{Warning}} 毒气接触火会爆炸!"},
	{"大便炸弹", "普通的可投掷炸弹"},
	{"爆炸性腹泻", "在角色位置生成5个激活的大便炸弹"},
}

---------- Misc. Text ----------

-- Void stat names: Replace "Tears" with "Fire Rate"
EID.descriptions[languageCode].VoidNames[2] = EID.descriptions[languageCode].GlitchedItemText[1]

EID.descriptions[languageCode].VoidShopText = "若在拾取后立即吸收，获得："
EID.descriptions[languageCode].VoidOptionText = "会被吸收"

EID.descriptions[languageCode].spindownError = "道具消失"

EID.descriptions[languageCode].CraftingBagContent = "袋中："
EID.descriptions[languageCode].CraftingRoomContent = "房间中："
EID.descriptions[languageCode].CraftingFloorContent = "整层中："

EID.descriptions[languageCode].CraftingBagQuality = "袋中品质："
EID.descriptions[languageCode].CraftingBestQuality = "最好品质："

EID.descriptions[languageCode].CraftingHideKey = "隐藏："
EID.descriptions[languageCode].CraftingPreviewKey = "预览："
EID.descriptions[languageCode].CraftingPreviewBackup =  "!!! 如果该道具锁定，则会变为"

EID.descriptions[languageCode].CraftingResults =  "(滚动：按住 {{CONFIG_BoC_Toggle}} + {{ButtonY}} {{ButtonA}}，锁定：{{ButtonX}}，刷新：{{ButtonB}}，重置袋：按住 {{ButtonRB}})"

EID.descriptions[languageCode].BlankCardCharge = "空白卡牌充能：" 
EID.descriptions[languageCode].BlankCardQCard = "传送至错误房#空白卡牌和？卡牌会被摧毁" 
EID.descriptions[languageCode].ClearRuneCharge = "透明符文充能：" 
EID.descriptions[languageCode].PlaceboCharge = "安慰剂充能：" 
EID.descriptions[languageCode].FlipItemToggleInfo = "(按住 {{ButtonSelect}}(地图)来显示其描述)"

EID.descriptions[languageCode].FalsePHDHeart = "生成1黑心"
EID.descriptions[languageCode].FalsePHDDamage = "{{Damage}} +0.6伤害"
EID.descriptions[languageCode].FalsePHDHorseDamage = "{{Damage}} +1.2伤害"

EID.descriptions[languageCode].AchievementWarningTitle = "{{ColorYellow}}!!! 警告 !!!"
EID.descriptions[languageCode].AchievementWarningText = "成就已禁用！#为了启用进度和成就，你需要击败妈妈的脚(深牢II)而不开启任何模组#(如果你打过了, 那么这条警告的出现是bug, 无视就好)#(这条警告可在设置中禁用)"

EID.descriptions[languageCode].OldGameVersionWarningText = "你的忏悔版本不是最新的！#只有官方最新版才支持这一功能(1.7.9b)#(这条警告可以在设置中禁用)"

EID.descriptions[languageCode].ModdedRecipesWarningText = "含有模组的道具可能会使合成配方计算不准确！#如果你的配方不正确，请使用无配方模式或者关闭合成袋的显示#(这条警告可以在设置中禁用)"


-- If Debug enabled, add overwrite tables to the languagepack in order for the language completion script to be able to compare them
if EID.enableDebug then
	EID.descriptions[languageCode].repCollectibles = repCollectibles
	EID.descriptions[languageCode].repTrinkets = repTrinkets
	EID.descriptions[languageCode].repCards = repCards
	EID.descriptions[languageCode].repPills = repPills
end 
