---------------------------------------
----  Basic Ukrainian descriptions ----
---------------------------------------

-- FORMAT: Item ID | Name | Description

-- Special character markup:
-- ↑ = Up Arrow  |  ↓ = Down Arrow  |  ! = Warning  |  # = Starts a new line
-- More can be found here: https://github.com/wofsauge/External-Item-Descriptions/wiki/Markup

local languageCode = "uk_ua"

-- init uk_ua table
EID.descriptions[languageCode] = {}
EID.descriptions[languageCode].custom = {} -- table for custom entity descriptions
EID.descriptions[languageCode].languageName = "Ukrainian"

-- Fonts to be used with this language pack
EID.descriptions[languageCode].fonts = {{name="default"}, {name="inverted"}, {name="borderless"}}


---------- Collectibles ----------
EID.descriptions[languageCode].collectibles={
	{"1", "Сумна цибуля", "↑ {{Tears}} +0.7 Темп Стрільби збільшено"},
	{"2", "Внутрішнє око", "Потрійний постріл#↓ {{Tears}} Темп Стрільби зменшено"},
	{"3", "Згинач ложок", "Самонавідні сльози"},
	{"4", "Голова Крікета", "↑ {{Damage}} +0.5 Шкоду збільшено#↑ {{Damage}} +50% множник Шкоди"},
	{"5", "Моє відображення", "Сльози персонажа мають ефект бумеранга#↑ {{Range}} +1.5 Дальність збільшено#↑ {{Shotspeed}} +0.6 Швидкість Стрільби збільшено#↑ +1 Висота Польоту Сльози"},
	{"6", "Номер один", "↑ {{Tears}} +1.5 Темп Стрільби збільшено#↓ {{Range}} -17.62 Дальність зменшено#↑ +0.76 Висота Польоту Сльози"},
	{"7", "Кров мученика", "↑ {{Damage}} +1 Шкоду збільшено#{{Collectible34}} +50% до Шкоди, якщо активний ефект Книги Беліала чи картки \"Диявол\""},
	{"8", "Брат Боббі", "Стріляє нормальними слізьми#Наносить 3.5 шкоди за сльозу"},
	{"9", "Скатол", "Всі мухи стають дружніми"},
	{"10", "Вінець з мух", "+2 мухи-орбіталі#Блокують ворожі снаряди"},
	{"11", "+1!", "↑ +1 життя#Персонаж воскресає з повним здоров'ям"},
	{"12", "Чарівний гриб", "↑ +1 Контейнер червоних сердець#{{Heart}} Повністю відновлює здоров'я персонажа#↑ {{Damage}} +0.3 Шкоду збільшено#↑ {{Damage}} +50% множник Шкоди#↑ {{Range}} +5.25 Дальність збільшено#↑ {{Speed}} +0.3 Швидкість збільшено#↑ +0.5 Висота Польоту Сльози#Розмір персонажа збільшено"},
	{"13", "Вірус", "{{Poison}} Ви отруюєте ворогів дотиком#↓ {{Speed}} -0.1 Швидкість знижено#{{BlackHeart}} З отруєних ворогів можуть випасти Чорні серця"},
	{"14", "Гнів Роїда", "↑ {{Speed}} +0.6 Швидкість збільшено#↑ {{Range}} +5.25 Дальність збільшено#↑ +0.5 Висота Польоту Сльози"},
	{"15", "<3", "↑ {{Heart}} +1 Контейнер червоних сердець#{{Heart}} Повністю відновлює здоров'я"},
	{"16", "Сира печінка", "↑ {{Heart}} +2 Контейнери червоних сердець#{{Heart}} Повністю відновлює здоров'я"},
	{"17", "Ключ скелета", "{{Key}} +99 ключів"},
	{"18", "Долар", "{{Coin}} +99 монет"},
	{"19", "Бум!", "{{Bomb}} +10 бомб"},
	{"20", "Трансцендентність", "Політ"},
	{"21", "Компас", "Відображає значки спеціальних кімнат на карті#Не відкриває саму карту"},
	{"22", "Обід", "↑ {{Heart}} +1 Контейнер червоних сердець"},
	{"23", "Вечеря", "↑ {{Heart}} +1 Контейнер червоних сердець"},
	{"24", "Десерт", "↑ {{Heart}} +1 Контейнер червоних сердець"},
	{"25", "Сніданок", "↑ {{Heart}} +1 Контейнер червоних сердець"},
	{"26", "Гниле м'ясо", "↑ {{Heart}} +1 Контейнер червоних сердець"},
	{"27", "Дерев'яна ложка", "↑ {{Speed}} +0.3 Швидкість збільшено"},
	{"28", "Пасок", "↑ {{Speed}} +0.3 Швидкість збільшено"},
	{"29", "Матусині трусики", "↑ {{Range}} +5.25 Дальність збільшено#↑ +0.5 Висота Польоту Сльози"},
	{"30", "Матусині каблуки", "↑ {{Range}} +5.25 Дальність збільшено#↑ +0.5 Висота Польоту Сльози"},
	{"31", "Матусина помада", "↑ {{Range}} +5.25 Дальність збільшено#↑ +0.5 Висота Польоту Сльози"},
	{"32", "Вішак для одягу", "↑ {{Tears}} +0.7 Темп Стрільби збільшено"},
	{"33", "Біблія", "Політ на одну кімнату#{{MomsHeart}} Миттєво вбиває Матусину Ногу та Матусине Серце#{{Warning}} Вбиває персонажа при використанні на Сатані"},
	{"34", "Книга Беліала", "↑ {{Damage}} +2 Шкоду збільшено#{{Collectible7}} +50% множник шкоди, якщо у персонажа є Кров Мученика#{{AngelDevilChance}} +12.5% до шансу появи кімнат Диявола/Ангела, поки ви тримаєте цей артефакт"},
	{"35", "Некрономікон", "Наносить 40 шкоди усім ворогам в кімнаті"},
	{"36", "Лайно", "Створює одну купку лайна та відштовхує ворогів#Лайно можна розмістити біля провалля та підірвати, створивши міст"},
	{"37", "Містер Бум", "Створює велику бомбу під персонажем, яка наносить 110 шкоди"},
	{"38", "Голова Таммі", "Випускає 10 сліз навколо персонажа#Ці сльози копіюють ефекти та характеристики сліз персонажа, плюс 25 шкоди"},
	{"39", "Матусин бюстгальтер", "Заморожує усіх ворогів в кімнаті на 4 секунди"},
	{"40", "Камікадзе!", "Спричинює вибух довкола персонажа#Наносить 40 шкоди"},
	{"41", "Матусина прокладка", "{{Fear}} Лякає всіх ворогів в кімнаті на 5 секунд"},
	{"42", "Гнила голова Боба", "При активації предмета, персонаж метає голову в бік стрільби#{{Poison}} Голова вибухає при приземленні та отруює ворогів поблизу"},
	{"43", "", "<item does not exist>"},
	{"44", "Телепорт!", "Телепортує персонажа до випадкової кімнати, окрім Я - ПОМИЛКА"},
	{"45", "Смачне серце", "Відновлює 1 червоне серце при активації"},
	{"46", "Щаслива ніжка", "↑ {{Luck}} +1 Удачу збільшено#+8% шанс отримати нагороду за зачистку кімнати#Вищі шанси на перемогу в азартних іграх"},
	{"47", "Пульт доктора Зародка", "{{Collectible168}} При активації, персонаж починає цілитись хрестиком-міткою#Ракета влучає у мітку через 1.5 секунди#Наносить 20x шкоди персонажа"},
	{"48", "Стріла Купідона", "Пронизуючі сльози"},
	{"49", "Шуп-да-Вуп!", "{{Collectible118}} При активації, персонаж випускає лазер Сірки в напрямку стрільби"},
	{"50", "Стівен", "↑ {{Damage}} +1 Шкоду збільшено"},
	{"51", "Пентаграма", "↑ {{Damage}} +1 Шкоду збільшено#{{AngelDevilChance}} +10% шанс появи кімнати Диявола/Ангела"},
	{"52", "Доктор Зародок", "{{Bomb}} Персонаж стріляє бомбами замість сліз#Кожна бомба наносить 5x шкоди + 30#↓ {{Tears}} Затримка між слізьми x2.5"},
	{"53", "Магнето", "Розхідники притягуються до персонажа"},
	{"54", "Карта скарбів", "Відкриває карту поверху#Не відображає значки кімнат"},
	{"55", "Матусине око", "50% шанс вистрілити додатковою сльозою зі спини#{{Luck}} 100% шанс при Удачі 2"},
	{"56", "Лимонна невдача", "Створює калюжу рідини#Рідина наносить 24 контактної шкоди в секунду"},
	{"57", "Фанат на відстані", "Орбіталь-муха середнього радіуса#Наносить 75 контактної шкоди за секунду"},
	{"58", "Книга Тіней", "Персонаж стає невразливим на 10 секунд"},
	{"59", "", "<item does not exist>"},
	{"60", "Драбина", "Дозволяє персонажу перетинати провалля шириною в одну клітинку"},
	{"61", "", "<item does not exist>"},
	{"62", "Чарівність вампіра", "{{HalfHeart}} Вбивство 13 ворогів відновлює персонажу половинку серця"},
	{"63", "Батарея", "Активні предмети можуть бути зарядженими та застосованими двічі підряд"},
	{"64", "Знижки Steam", "{{Shop}} Товари у магазині коштують на 50% дешевше#Наявність двох Знижок Steam робить усі товари безкоштовними"},
	{"65", "Кулінарна книга анархіста", "Створює 6 троль-бомб поблизу центру кімнати"},
	{"66", "Пісочний годинник", "{{Slow}} Сповільнює ворогів на 8 секунд"},
	{"67", "Сестра Меггі", "Стріляє нормальними слізьми#Наносить 3.5 шкоди за сльозу"},
	{"68", "Технології", "Персонаж стріляє лазерами замість сліз"},
	{"69", "Шоколадне молоко", "{{Chargeable}} Заряджувані сльози#↑ {{Damage}} Повністю заряджені сльози наносять 400% Шкоди#↓ {{Tears}} Темп Стрільби знижено"},
	{"70", "Гормони росту", "↑ {{Damage}} +1 Шкоду збільшено#↑ {{Speed}} +0.4 Швидкість збільшено"},
	{"71", "Грибочок", "↑ {{Speed}} +0.3 Швидкість збільшено#↓ {{Range}} -4.25 Дальність зменшено*#↑ +1.5 Висота Польоту Сльози*#(*Поєднання цих характеристик трішки збільшує фактичну Дальність)#↑ Розмір зменшено"},
	{"72", "Вервиця", "{{SoulHeart}} +3 серця Душі#{{Collectible33}} Біблія з'являється в усіх предметних пулах"},
	{"73", "Кубик м'яса", "Рівень1: Орбіталь#Рівень2: Сльозливий орбіталь#Рівень3: М'ясний Хлопчик Рівня1#Рівень4: М'ясний Хлопчик Рівня2"},
	{"74", "Четвертак", "{{Coin}} +25 монет"},
	{"75", "Доктор наук", "{{Pill}} Перетворює усі погані пігулки на хороші#Створює 1 пігулку#{{Heart}} Відновлює 2 червоні серця#{{BloodDonationMachine}} Автомати Прийому Крові та {{Collectible135}} Крапельниця дають більше монет"},
	{"76", "Рентгенівське бачення", "{{SecretRoom}} Відкриває всі проходи до секретних кімнат"},
	{"77", "Мій маленький єдиноріг", "Персонаж стає невразливим та отримує +0.28 Швидкості#Персонаж наносить 40 контактної шкоди за секунду#{{Timer}} Ефект триває 6 секунд"},
	{"78", "Книга Одкровень", "{{SoulHeart}} +1 серце Душі#Підвищує шанс появи боса Вершника при активації#{{AngelDevilChance}} +17.5% шанс появи кімнат Диявола/Ангела, поки персонаж тримає цей предмет"},
	{"79", "Мітка", "↑ {{Damage}} +1 Шкоду збільшено#↑ {{Speed}} +0.2 Швидкість збільшено#{{SoulHeart}} +1 серце Душі"},
	{"80", "Договір", "↑ {{Damage}} +0.5 Шкоду збільшено#↑ {{Tears}} +0.7 Темп Стрільби збільшено#{{SoulHeart}} +2 серця Душі"},
	{"81", "Мертвий кіт", "↑ +9 життів#Персонаж воскресає з 1 контейнером червоних сердець#↓ Встановлює кількість червоних контейнерів персонажа до 1#{{Warning}} Здоров'я персонажів, в яких не може бути червоних сердець, натомість встановлюється до 1 синього/чорного серця"},
	{"82", "Володар ями", "Політ#↑ {{Speed}} +0.3 Швидкість збільшено"},
	{"83", "Цвях", "{{SoulHeart}} +1 Soul Heart#↑ {{Damage}} +0.7 Damage up#↓ {{Speed}} -0.18 Speed down#Isaac deals 40 contact damage per second#Allows Isaac to destroy rocks by walking into them"},
	{"84", "Треба йти глибше!", "Відкриває люк на наступний поверх#{{LadderRoom}} 10% шанс відкрити люк до Криївки"},
	{"85", "Колода карт", "{{Card}} Створює 1 карту"},
	{"86", "Зуб Монстро", "Монстро падає на ворога та наносить 120 шкоди#{{Warning}} Монстро падає на персонажа, якщо в кімнаті немає ворогів"},
	{"87", "Ріжки Локі", "25% шанс вистрілити в 4 сторони#{{Luck}} 100% шанс при Удачі 7"},
	{"88", "Маленький Чаббі", "Летить у бік стрільби персонажа#Наносить 52.5 контактної шкоди за секунду"},
	{"89", "Укус павука", "{{Slow}} 25% шанс вистрілити сповільнювальними слізьми#{{Luck}} 100% шанс при Удачі 15"},
	{"90", "Маленький камінь", "↑ {{Damage}} +1 Шкоду збільшено#↑ {{Tears}} +0.2 Темп Стрільби збільшено#↓ {{Speed}} -0.2 Швидкість знижено"},
	{"91", "Шолом спелеолога", "Відображає тип прилеглих кімнат#{{SecretRoom}} Може відобразити секретні та суперсекретні кімнати"},
	{"92", "Супер пластир", "↑ {{Heart}} +1 Контейнер червоних сердець#{{SoulHeart}} +2 серця Душі#{{Heart}} Відновлює 1 червоне серце"},
	{"93", "Геймкід", "Невразливість#{{Fear}} Лякає усіх ворогів у кімнаті#Персонаж наносить 40 контактної шкоди за секунду#{{HalfHeart}} Вбивство 2 ворогів відновлює половинку серця#{{Timer}} Ефект триває 6.5 секунд"},
	{"94", "Мішок пенні", "{{Coin}} Створює випадкову монету кожні 2 кімнати"},
	{"95", "Робо-Дитя", "Стріляє лазерами#Наносить 3.5 шкоди за постріл"},
	{"96", "Маленький Ч.А.Д.", "{{HalfHeart}} Створює половинку серця кожні 3 кімнати"},
	{"97", "Книга Гріхів", "Створює випадковий розхідник"},
	{"98", "Реліквія", "{{SoulHeart}} Створює 1 серце Душі кожні 5-6 кімнат"},
	{"99", "Маленький Гіш", "{{Slow}} Сповільнювальні сльози#Наносить 3.5 шкоди за постріл"},
	{"100", "Маленький Стівен", "Стріляє самонавідними слізьми#Наносить 3.5 шкоди за постріл"},
	{"101", "Німб", "↑ {{Heart}} +1 Контейнер червоних сердець#↑ {{Damage}} +0.3 Шкоду збільшено#↑ {{Tears}} +0.2 Темп Стрільби збільшено#↑ {{Range}} +0.25 Дальність збільшено#↑ {{Speed}} +0.3 Швидкість збільшено#↑ +0.5 Висота Польоту Сльози"},
	{"102", "Матусина пляшечка для пігулок", "{{Pill}} Створює 1 пігулку"},
	{"103", "Застуда", "{{Poison}} 25% шанс вистрілити отруйною сльозою#{{Luck}} 100% шанс при Удачі 12"},
	{"104", "Паразит", "Сльози розбиваються навпіл при контакті#Розбиті сльози наносять половину шкоди"},
	{"105", "D6", "Реролить п'єдестальні предмети в поточній кімнаті"},
	{"106", "Містер Мега", "↑ Шкода від бомб x2.25#{{Bomb}} +5 бомб"},
	{"107", "Зубчасті ножиці", "Політ#Тіло персонажа від'єднується від голови й атакує ворогів, наносячи 82.5 контактної шкоди за секунду"},
	{"108", "Проскура", "Зменшує всю отримувану шкоду до половинки серця"},
	{"109", "Гроші = Сила", "↑ {{Damage}} +0.04 Шкоди за кожну {{Coin}} монетку в інвентарі персонажа"},
	{"110", "Матусині лінзи", "20% шанс вистрілити паралітичною сльозою#↑ +0.25 Дальність збільшено#↑ +0.5 Висота Польоту Сльози"},
	{"111", "Біб", "{{Poison}} Персонаж пукає отруйним газом#Газ наносить шкоду персонажа 6 разів"},
	{"112", "Ангел-Охоронець", "Орбіталь#Прискорює всіх інших орбіталів#Блокує ворожі снаряди#Наносить 105 контактної шкоди за секунду"},
	{"113", "Малюк Диявол", "Стріляє у ворогів поблизу#Наносить 3 шкоди за постріл"},
	{"114", "Матусин ніж", "Персонаж стріляє ножами замість сліз#Ніж наносить 2x шкоди персонажа в ближньому бою та 6x шкоди на максимальній можливій дистанції кидка"},
	{"115", "Дошка Уіджа", "Спектральні сльози"},
	{"116", "9 Вольтів", "Автоматично заряджає першу поділку активних предметів#{{Battery}} Повністю заряджає поточний активний предмет"},
	{"117", "Мертвий птах", "При отриманні персонажем шкоди, з'являється компаньйон-птах#Птах наносить 4 контактної шкоди за секунду"},
	{"118", "Сірка", "{{Chargeable}} Персонаж стріляє заряджуваним кривавим лазером"},
	{"119", "Мішок крові", "↑ {{Heart}} +1 Контейнер червоних сердець#↑ {{Speed}} +0.3 Швидкість збільшено#{{Heart}} Відновлює 4 серця"},
	{"120", "Дивний гриб (Тонкий)", "↑ {{Tears}} +1.7 Темп Стрільби збільшено#↑ {{Speed}} +0.3 Швидкість збільшено#↓ {{Damage}} -38% множник шкоди"},
	{"121", "Дивний гриб (Великий)", "↑ {{EmptyHeart}} +1 пустий Контейнер червоних сердець#↑ {{Damage}} +0.3 Шкоду збільшено#↑ {{Range}} +0.25 Дальність збільшено#↓ {{Speed}} -0.1 Швидкість знижено#↑ +0.5 Висота Польоту Сльози"},
	{"122", "Вавилонська повія", "Коли у персонажа половинка червоного серця чи менше:#↑ {{Damage}} +1.5 Шкоду збільшено#↑ {{Speed}} +0.3 Швидкість збільшено"},
	{"123", "Книга Монстрів", "Створює випадкового компаньйона для поточної кімнати"},
	{"124", "Сувої Мертвого моря", "Застосовує ефект випадкового активного предмета"},
	{"125", "Боббі-бомба", "Самонавідні бомби#{{Bomb}} +5 бомб"},
	{"126", "Лезо бритви", "↑ {{Damage}} +1.2 Шкоди для поточної кімнати#{{Warning}} Наносить 1 серце шкоди персонажу#Спочатку забирає червоні серця"},
	{"127", "Забудь мене зараз", "{{Warning}} ОДНОРАЗОВИЙ {{Warning}}#Реролить та перезапускає поточний поверх"},
	{"128", "Навіки самотній", "Муха-орбіталь великої дальності#Наносить 30 контактної шкоди за секунду"},
	{"129", "Відро смальцю", "↑ +2 пусті Контейнери червоних сердець#↓ -0.2 Швидкість зменшено#Відновлює половинку серця"},
	{"130", "Поні", "Політ, поки ви тримаєте цей предмет#{{Speed}} Встановлює вашу швидкість до, як мінімум, 1.5#При активації предмета, персонаж робить ривок"},
	{"131", "Сумка з бомбами", "{{Bomb}} Створює 1 бомбу кожні 2-3 кімнати"},
	{"132", "Кусок вугілля", "{{Damage}} Що далі летять сльози, тим більше шкоди вони наносять"},
	{"133", "Лапка Гаппі", "Перетворює 1 контейнер червоних сердець на 3 серця Душі"},
	{"134", "Хвіст Гаппі", "{{Chest}} 33% шанс, що нагорода за зачистку кімнати буде скринею#33% шанс, що нагороди не буде"},
	{"135", "Крапельниця", "Завдає персонажу 0.5 серця шкоди та створює 1-3 монетки#{{Player14}} Створює 0-1 монеток для Хранителя"},
	{"136", "Найкращий друг", "Створює ляльку-приманку, яка приваблює ворогів та вибухає через 5 секунд"},
	{"137", "Дистанційний детонатор", "{{Bomb}} +5 бомб#Бомби персонажа більше не вибухатимуть автоматично#Активуйте цей предмет, щоб одночасно підірвати всі поставлені бомби"},
	{"138", "Розп'яття", "↑ +1 Контейнер червоних сердець#↑ {{Damage}} +0.3 Шкоду збільшено"},
	{"139", "Матусина сумочка", "{{Trinket}} Персонаж може тримати 2 брелки"},
	{"140", "Прокляття Боба", "{{Poison}} Бомби персонажа отруюють ворогів, які потрапили в радіус вибуху#{{Bomb}} +5 бомб"},
	{"141", "Видатний хлопчик", "{{Coin}} Створює 7 випадкових монет"},
	{"142", "Скапулярій", "{{SoulHeart}} Персонаж отримує 1 серце Душі, коли його здоров'я зменшується до половинки серця#Спрацьовує раз на кімнату#Перезайдіть у кімнату, щоб ефект міг знову спрацювати"},
	{"143", "Спідбол", "↑ {{Speed}} +0.3 Швидкість збільшено#↑ {{Shotspeed}} +0.2 Швидкість Стрільби збільшено"},
	{"144", "Друг-жебрак", "{{Coin}} Компаньйон, що збирає монети та створює випадкові розхідники за них"},
	{"145", "Голова Гаппі", "Створює 2-4 сині мухи"},
	{"146", "Молитовна картка", "{{EternalHeart}} +1 Вічне серце"},
	{"147", "Вищерблене кайло", "Дозволяє розбивати камені та відкривати проходи в секретні кімнати"},
	{"148", "Зараження", "При отриманні персонажем шкоди, з'являються сині мухи"},
	{"149", "Іпекак", "Сльози персонажа летять по навісній траєкторії#{{Poison}} Сльози вибухають та отруюють ворогів поруч#↑ {{Damage}} +40 Шкоду збільшено#↓ {{Tears}} Темп Стрільби знижено"},
	{"150", "Жорстока любов", "10% шанс вистрілити зубом#{{Damage}} Зуб наносить 3.2x шкоди#{{Luck}} 100% шанс при Удачі 9"},
	{"151", "Маліган", "При влучанні сльозою у ворога, з шансом 1/6 з'явиться синя муха"},
	{"152", "Технологія 2", "Замінює праве око персонажа на лазер#Лазер наносить 20% шкоди#↓ {{Damage}} -35% Шкоду знижено#↓ {{Tears}} Затримка між слізьми x 2"},
	{"153", "Павук-мутант", "Персонаж одночасно випускає 4 сльози#↓ {{Tears}} Темп Стрільби знижено"},
	{"154", "Хімічний опік", "↑ {{Damage}} +2 Шкоду збільшено для лівого ока"},
	{"155", "Споглядач", "Літає по кімнаті#Наносить 17.1 контактної шкоди за секунду"},
	{"156", "Ряса", "{{Battery}} При отриманні персонажем шкоди, активні предмети заряджаються на 1 поділку"},
	{"157", "Кривава жага", "↑ {{Damage}} Коли персонажу завдають шкоди, його шкода зростає#Максимум 6 разів на поверх#Ефект діє до кінця поверху"},
	{"158", "Кришталева куля", "Відкриває карту поверху#Створює картку або серце Душі"},
	{"159", "Дух ночі", "Політ#Спектральні сльози"},
	{"160", "Розколи небеса", "Створює 5 променів світла біля ворогів#Наносить шкоду персонажа + 20"},
	{"161", "Анкх", "{{Player4}} Ви воскресаєте за ??? (Синього Малюка) при смерті"},
	{"162", "Кельтський хрест", "При отриманні шкоди, персонаж може тимчасово стати невразливим"},
	{"163", "Дитина-привид", "Компаньйон зі спектральними слізьми#Наносить 3.5 шкоди за постріл"},
	{"164", "Свічка", "Метає синій вогонь#Вогонь наносить контактну шкоду, блокує ворожі снаряди та зникає через 2 секунди"},
	{"165", "Дев'ятихвоста кішка", "↑ {{Damage}} +1 Шкоду збільшено#↑ {{Shotspeed}} +0.23 Швидкість Стрільби збільшено"},
	{"166", "D20", "Реролить усі розхідники в кімнаті"},
	{"167", "Малюк Арлекін", "Одночасно випускає дві сльози, що летять по діагоналі#Наносить 4 шкоди за постріл"},
	{"168", "Епічний Зародок", "Замість сліз, персонаж керує хрестиком-міткою#Ракета прилітає на мітку через 1.5 секунди#Ракети наносять 20x шкоди персонажа"},
	{"169", "Поліфем", "↑ {{Damage}} +100% Шкоду збільшено#↑ {{Damage}} +4 Шкоду збільшено додатково#↓ {{Tears}} Темп Стрільби знижено#Сльози продовжують свій політ після вбивства ворога"},
	{"170", "Довгоногий татусь", "У випадковий момент топче ворогів#Наносить 40 шкоди за секунду"},
	{"171", "Павуча дупка", "Сповільнює ворогів на 4 секунди#Наносить 10 шкоди усім ворогам"},
	{"172", "Ніж для жертвопринесень", "Орбіталь#Блокує ворожі постріли#Наносить 225 контактної шкоди за секунду"},
	{"173", "Митра", "{{SoulHeart}} Вищий шанс на появу сердець Душі"},
	{"174", "Веселковий малюк", "Стріляє випадковими слізьми#Наносить 3-5 шкоди за секунду"},
	{"175", "Татусів ключ", "Відкриває всі двері в кімнаті, включно з {{SecretRoom}}{{SuperSecretRoom}}секретними кімнатами, {{ChallengeRoom}}{{BossRushRoom}}кімнатами виклику та дверима Мегасатани"},
	{"176", "Стовбурові клітини", "↑ {{Heart}} +1 Контейнер червоних сердець#↑ {{Shotspeed}} +0.16 Швидкість Стрільби збільшено"},
	{"177", "Переносний автомат", "Портативний ігровий автомат#Витратьте 1 пенні, щоб з певним шансом створити розхідник"},
	{"178", "Свята вода", "Отримуючи шкоду, персонаж створює калюжу#Рідина наносить 24 шкоди за секунду"},
	{"179", "Доля", "Політ#{{EternalHeart}} +1 Вічне серце"},
	{"180", "Чорна квасоля", "Персонаж пукає, коли до нього торкаються"},
	{"181", "Білий поні", "Політ, поки ви тримаєте цей предмет#{{Speed}} Встановлює вашу швидкість до, як мінімум, 1.5#При активації предмета, персонаж робить ривок, створюючи за собою промені світла"},
	{"182", "Святе серце", "↑ +1 Контейнер червоних сердець#{{Heart}} Повне здоров'я#↑ 230% + 1 Шкоду збільшено#↓ -0.4 Темп Стрільби зменшено#↓ -0.25 Швидкість Стрільби зменшено#↑ +0.38 Дальність збільшено#↑ +0.75 Висота Польоту Сльози#Самонавідні сльози"},
	{"183", "Зубочистки", "↑ {{Tears}} +0.7 Темп Стрільби збільшено#↑ {{Shotspeed}} +0.16 Швидкість Стрільби збільшено"},
	{"184", "Святий Грааль", "Політ#↑ +1 Контейнер червоних сердець"},
	{"185", "Мертвий голуб", "Політ#Спектральні сльози"},
	{"186", "Криваві права", "Наносить 40 шкоди всім ворогам в кімнаті#{{Warning}} Наносить 1 серце шкоди персонажу#Спочатку забирає червоні серця"},
	{"187", "Клубок шерсті Гаппі", "Клубок рухається за персонажем по інерції#Розмір клубка збільшується, коли він вбиває ворогів#Шкода від клубка збільшується разом із розміром"},
	{"188", "Авель", "Дзеркально повторює рухи персонажа#Стріляє в сторону персонажа#Наносить 3.5 шкоди за постріл"},
	{"189", "Суперфанат SMB", "↑ +1 Контейнер червоних сердець#{{Heart}} Повне здоров'я#↑ +0.3 Шкоду збільшено#↑ +0.2 Темп Стрільби збільшено#↑ +0.5 Дальність збільшено#↑ +0.2 Швидкість збільшено#↑ +1 Висота Польоту Сльози"},
	{"190", "Пайро", "{{Bomb}} +99 бомб"},
	{"191", "Тридоларова купюра", "Сльози персонажа отримують випадковий ефект кожні 2-3 секунди"},
	{"192", "Телепатія для чайників", "Самонавідні сльози для поточної кімнати"},
	{"193", "М'ЯСО!", "↑ {{Heart}} +1 Контейнер червоних сердець#↑ {{Damage}} +0.3 Шкоду збільшено"},
	{"194", "Чарівна куля 8", "↑ {{Shotspeed}} +0.16 Швидкість Стрільби збільшено#{{Card}} +1 карта"},
	{"195", "Матусин гаманець", "{{Pill}} Створює 4 пігулки"},
	{"196", "Стискання", "{{SoulHeart}} Створює 2 серця Душі#↑ {{Tears}} +0.4 Темп Стрільби збільшено"},
	{"197", "Йсусів сік", "↑ {{Damage}} +0.5 Шкоду збільшено#↑ {{Range}} +0.25 Дальність збільшено#↑ +0.5 Висота Польоту Сльози"},
	{"198", "Коробка", "Створює по 1 розхіднику кожного типу"},
	{"199", "Матусин ключ", "{{Key}} +2 ключі#Скрині містять більше розхідників"},
	{"200", "Матусині тіні", "{{Charm}} 10% шанс вистрілити причаровувальними слізьми"},
	{"201", "Залізний зливок", "↑ {{Damage}} +0.3 Шкоду збільшено#{{Confusion}} 10% шанс вистрілити оглушливими слізьми"},
	{"202", "Дотик Мідаса", "Торкаючись ворогів, ви перетворюєте їх на золотих#Персонаж наносить контактну шкоду, що базується на кількості монет в нього в інвентарі#{{Coin}} При вбивстві, з золотих ворогів випадають монети#Купки лайна, створені персонажем, з великим шансом будуть золотими"},
	{"203", "Скромний згорток", "Подвоює кількість створюваних розхідників, якщо це можливо"},
	{"204", "Поясна сумка", "При отриманні персонажем шкоди, з шансом 50% буде створено випадковий розхідник"},
	{"205", "Гострий штекер", "{{Battery}} Використання незарядженого предмета повністю перезаряджає його за 2 серця#Працює лише коли у предмета немає зарядів"},
	{"206", "Гільйотина", "↑ {{Damage}} +1 Шкоду збільшено#↑ {{Tears}} Темп Стрільби збільшено#Голова персонажа стає компаньйоном, який стріляє, не отримує шкоди та наносить 105 контактної шкоди"},
	{"207", "Клубок бинтів", "Рівень1: Орбіталь#Рівень2: Сльозливий орбіталь#Рівень3: Бинтова Дівчинка Рівень1#Рівень4: Бинтова Дівчинка Рівень2"},
	{"208", "Чемпіонський пояс", "↑ {{Damage}} +1 Шкоду збільшено#+15% шанс на появу ворогів-чемпіонів"},
	{"209", "Дупні бомби", "{{Bomb}} +5 бомб#{{Confusion}} Вибух оглушує та наносить шкоду усім ворогам у кімнаті"},
	{"210", "Покусаний листочок", "Персонаж стає невразливим, стоячи нерухомо більше 1 секунди"},
	{"211", "Павучок", "При отриманні персонажем шкоди, з'являються 1-2 сині павуки"},
	{"212", "Нашийник Гаппі", "50% шанс воскреснути з половинкою серця, у випадку смерті"},
	{"213", "Втрачена лінза", "Сльози персонажа знищують ворожі снаряди#↓ {{Shotspeed}} -0.15 Швидкість Стрільби знижено"},
	{"214", "Анемія", "↑ {{Range}} +5 Дальність збільшено#Після отриманні шкоди, за персонажем з'являється кривавий слід, який наносить ворогам шкоду"},
	{"215", "Голова козла", "{{AngelDevilChance}} 100% шанс появи кімнат Диявола/Ангела"},
	{"216", "Церемоніальна мантія", "↑ {{Damage}} +1 Шкоду збільшено#{{BlackHeart}} +3 чорні серця"},
	{"217", "Матусина перука", "Випадковий шанс появи синіх павуків при стрільбі#{{Heart}} Відновлює 1 червоне серце"},
	{"218", "Плацента", "↑ {{Heart}} +1 Контейнер червоних сердець#{{HalfHeart}} Шанс відновити половинку серця кожної хвилини"},
	{"219", "Стара пов'язка", "↑ {{EmptyHeart}} +1 пустий Контейнер червоних сердець#{{Heart}} При отриманні персонажем шкоди, з випадковим шансом може з'явитися червоне серце"},
	{"220", "Плаксиві бомби", "При вибуху, бомби персонажа випускають 10 сліз навколо#{{Bomb}} +5 бомб"},
	{"221", "Гумовий клей", "Сльози персонажа рикошетять від ворогів та перешкод"},
	{"222", "Антигравітація", "Утримуйте кнопки стрільби, щоб сльози зависли в повітрі#Відпустіть кнопки стрільби, щоб дозволити сльозам полетіти в бік, у який вони були випущені#↑ {{Tears}} -2 Затримка між слізьми"},
	{"223", "Піроманіяк", "Отримання удару від вибуху відновлює 1 червоне серце персонажу, замість того, щоб нанести йому шкоду#Імунітет до кам'яних хвиль та атак Матусиної Ноги та ноги Сатани#{{Bomb}} +5 бомб"},
	{"224", "Тіло Крікета", "Сльози розділяються на 4 при влучанні#Розділенісльози наносять половину шкоди#↑ {{Tears}} +1 Темп Стрільби збільшено#↓ {{Range}} -10 Дальність зменшено"},
	{"225", "Покора", "{{SoulHeart}} При отриманні персонажем шкоди, може з'явитися серце Душі#{{HalfHeart}} При смерті з ворогів може випасти половинка червоного серця"},
	{"226", "Чорний лотос", "↑ {{Heart}} +1 Контейнер червоних сердець#{{SoulHeart}} +1 серце Душі#{{BlackHeart}} +1 чорне серце"},
	{"227", "Свинка-скарбничка", "{{Coin}} +3 монети#При отриманні шкоди, з'являються 1-2 монети#{{Player14}} 0-1 монети для Хранителя"},
	{"228", "Матусині парфуми", "{{Fear}} 15% шанс вистрілити сльозою страху#↑ {{Tears}} +1 Темп Стрільби збільшено"},
	{"229", "Легеня Монстро", "{{Chargeable}} Атаки стають заряджуваними, а сльози випускаються в стилі дробовика#↓ {{Tears}} 4.3x Затримка між слізьми"},
	{"230", "Абаддон", "↑ {{Damage}} +1.5 Шкоду збільшено#↑ {{Speed}} +0.2 Швидкість збільшено#{{Fear}} Сльози страху#↓ {{EmptyHeart}} Прибирає усі контейнери червоних сердець#{{BlackHeart}} +6 чорних сердець"},
	{"231", "Куля з дьогтю", "{{Slow}} 10% шанс вистрілити сповільнювальною сльозою#{{Luck}} 100% шанс при Удачі 18#Персонаж залишає за собою слід зі сповільнювальної рідини"},
	{"232", "Секундомір", "{{Slow}} При отриманні персонажем шкоди, вороги у кімнаті перманентно сповільнюються#↑ +0.3 Швидкість збільшено"},
	{"233", "Крихітна планета", "Сльози кружляють довкола персонажа#↑ {{Range}} Дальність значно збільшується#↑ +7 Висота Польоту Сльози#Спектральні сльози"},
	{"234", "Зараження 2", "При вбивстві ворога з'являється синій павук"},
	{"235", "", "<item does not exist>"},
	{"236", "Кишкова паличка", "Торкніться ворога, щоб перетворити його на купку лайна"},
	{"237", "Дотик смерті", "↑ {{Damage}} +1.5 Шкоду збільшено#↑ Розмір сльози збільшено#↓ {{Tears}} -0.3 Темп Стрільби зменшено#Пронизуючі сльози"},
	{"238", "1 частина ключа", "{{Warning}} Зберіть обидві частини ключа, щоб відкрити двері до Мегасатани#{{AngelChance}} На 25% вищий шанс на появу кімнати Ангела#{{EternalHeart}} +2% шанс на появу Вічних сердець"},
	{"239", "2 частина ключа", "{{Warning}} Зберіть обидві частини ключа, щоб відкрити двері до Мегасатани#{{AngelChance}} На 25% вищий шанс на появу кімнати Ангела#{{EternalHeart}} +2% шанс на появу Вічних сердець"},
	{"240", "Експериментальна терапія", "Усі характеристики ↑/↓ на випадкове значення"},
	{"241", "Контракт знизу", "Подвоює усі винагороди за зачистку кімнат#33% шанс, що винагороди не буде#{{GreedMode}} Не працює в Режимі Жадібності"},
	{"242", "Безславність", "50% шанс заблокувати ворожу атаку"},
	{"243", "Трисвятий щит", "Блокує ворожі постріли зі сторону, у яку стріляє персонаж"},
	{"244", "Технологія 0.5", "Зрідка стріляє лазером на додачу до основної атаки персонажа"},
	{"245", "20/20", "Персонаж випускає одночасно 2 сльози"},
	{"246", "Синя карта", "{{SecretRoom}} Відображає локацію секретної кімнати на карті"},
	{"247", "Найкращі друзі назавжди!", "Компаньйони наносять подвійну шкоду"},
	{"248", "Вуликовий розум", "Сині павуки та мухи наносять подвійну шкоду"},
	{"249", "У тебе є вибір", "Дозволяє обирати між 2 предметами після перемоги над босом"},
	{"250", "Подвійні бомби", "{{Bomb}} Всі бомби-розхідники стають подвійними"},
	{"251", "Стартова колода", "{{Card}} Персонаж може тримати 2 карти#Перетворює всі пігулки на карти#Створює 1 карту"},
	{"252", "Маленький мішечок", "{{Pill}} Персонаж може тримати 2 пігулки#Перетворює всі карти на пігулки#Створює 1 пігулку"},
	{"253", "Чарівний струп", "↑ {{Luck}} +1 Удачу збільшено#↑ {{Heart}} +1 Контейнер червоних сердець"},
	{"254", "Згусток крові", "↑ {{Damage}} +1 Шкоду збільшено#↑ {{Range}} +5 Дальність збільшено#Застосовується лише для лівого ока"},
	{"255", "Гвинт", "↑ {{Tears}} +0.5 Темп Стрільби збільшено#↑ {{Shotspeed}} +0.2 Швидкість Стрільби збільшено"},
	{"256", "Гарячі бомби", "{{Burning}} Бомби персонажа підпалюють землю на місці вибуху#{{Bomb}} +5 бомб"},
	{"257", "Вогняні думки", "{{Burning}} Сльози персонажа підпалюють ворогів#Шанс, що сльоза вибухне при контакті з ворогом#{{Luck}} 100% шанс вибуху при Удачі 13#{{Warning}} Вибух завдає шкоди персонажу"},
	{"258", "Загублений біт", "Реролить усі предмети та характеристики персонажа при піднятті цього предмета та на початку кожного наступного поверху"},
	{"259", "Чорна матерія", "↑ {{Damage}} +1 Шкоду збільшено#{{Fear}} 33% шанс вистрілити сльозою страху#{{Luck}} 100% шанс при Удачі 20"},
	{"260", "Чорна свічка", "{{CurseBlind}} Імунітет до проклять#{{BlackHeart}} +1 Чорне серце#{{AngelDevilChance}} +15% шанс появи кімнат Диявола/Ангела"},
	{"261", "Проптоз", "↑ {{Damage}} +100% Шкоду збільшено#↓ Сльози наносять менше шкоди з відстанню"},
	{"262", "Втрачена сторінка 2", "{{BlackHeart}} +1 Чорне серце#Коли здоров'я персонажа зменшується до 1 серця, наносить шкоду усім персонажам в кімнаті"},
	{"263", "", "<item does not exist>"},
	{"264", "Розумна мушка", "Орбіталь#Атакує ворогів, коли персонажу завдають шкоди#Наносить 22.5 шкоди за секунду"},
	{"265", "Висушене дитя", "10% шанс нанести шкоду всім ворогам у кімнаті, коли ворожа сльоза попадає в цього компаньйона"},
	{"266", "Соковитий мішечок", "Залишає слід зі сповільнювальної рідини#Створює 1-2 дружніх павуків після зачистки кімнати"},
	{"267", "Робо-дитя 2.0", "Стріляє лазерами#Наносить 3.5 шкоди за постріл#Рухається в бік стрільби персонажа"},
	{"268", "Гниле дитя", "Створює синіх мух, коли персонаж стріляє"},
	{"269", "Безголове дитя", "Залишає слід з рідини, що наносить 6 шкоди за секунду"},
	{"270", "П'явка", "Переслідує ворогів#{{HalfHeart}} Персонаж відновлює половинку серця за кожного ворога, вбитого П'явкою#Наносить 3.2 шкоди за секунду"},
	{"271", "Загадковий мішечок", "Створює випадковий розхідник кожні кілька кімнат"},
	{"272", "ВЧМ", "Дружня вибухова муха#Вибух наносить 60 шкоди#{{Warning}} Вибух може завдати шкоди персонажу"},
	{"273", "Мозок Боба", "Летить в бік стрільби персонажа#Вибухає, коли влучає у ворога#Вибух наносить 60 шкоди і може вразити персонажа"},
	{"274", "Найкращий друг", "Для поточної кімнати створює орбіталя середнього радіуса при отриманні персонажем шкоди#Орбіталь наносить 75 шкоди за секунду"},
	{"275", "Сірчаний крихітка", "{{Collectible118}} Компаньйон з заряджуваною атакою лазера Сірки#Наносить 31.5 шкоди за секунду"},
	{"276", "Серце Ісаака", "Персонаж стає невразливим#Створює компаньйона-серце, що рухається за персонажем#{{Warning}} Якщо серцю завдають шкоди, персонаж втрачає здоров'я"},
	{"277", "Крихітний привид", "Переслідує та лякає ворогів#Наносить 4 шкоди за секунду"},
	{"278", "Темний жебрак", "{{Heart}} Збирає червоні серця з підлоги#Створює Чорне/Синє серце чи павука за кожні 1.5 червоні серця"},
	{"279", "Великий фанат", "Великий орбіталь#Наносить 30 шкоди за секунду"},
	{"280", "Сісся Довгоногий", "Випадково створює синіх павуків у ворожих кімнатах"},
	{"281", "Боксерська груша", "Компаньйон-приманка#Вороги переслідують його замість персонажа"},
	{"282", "Як правильно стрибати", "Дозволяє персонажу стрибати через провалля та перешкоди"},
	{"283", "D100", "Реролить усі розхідники та п'єдестальні предмети в кімнаті, а також усі предмети в інвентарі персонажа"},
	{"284", "D4", "Реролить усі предмети в інвентарі персонажа"},
	{"285", "D10", "Реролить всіх ворогів у кімнаті"},
	{"286", "Порожня карта", "Активує ефект карти з рук персонажа без її використання"},
	{"287", "Книга Таїнств", "Активує один з ефектів на поверх:#{{Collectible54}} Карти Скарбів#{{Collectible21}} Компаса#{{Collectible246}} Синьої Карти"},
	{"288", "Коробка з павуками", "Створює 1-4 синіх павуків"},
	{"289", "Червона свічка", "Метає червоний вогонь#Вогонь зникає, коли наносить шкоду або блокує постріли 5 разів"},
	{"290", "Банка", "{{Heart}} При піднятті червоних сердець з повним здоров'ям, Банка зберігає до 4 з них у собі#Використання предмету викидає усі зібрані серця"},
	{"291", "Змив!", "Перетворює усіх ворогів-не-босів на купки лайна#Миттєво вбиває какашкових босів та ворогів"},
	{"292", "Сатанинська біблія", "{{BlackHeart}} +1 Чорне серце"},
	{"293", "Голова Крампуса", "Випускає лазери {{Collectible118}} Сірки на всі 4 сторони"},
	{"294", "Масляний біб", "Відштовхує ворогів та снаряди поблизу#10% шанс, що предмет перетвориться на сильніший {{Collectible484}}Стривай, Що? при зміні на інший активний предмет і назад"},
	{"295", "Чарівні пальчики", "Наносить 2x Шкоди персонажа усім ворогам в кімнаті#{{Warning}} Ціна - 1 монетка за використання"},
	{"296", "Перетворювач", "Конвертує 2 Синіх/Чорних серця в 1 Контейнер червоних сердець"},
	--NOTE FOR LOCALIZERS: There is code to highlight the text of your current floor
	--For it to work, only use line breaks or semicolons to separate floor details, and use the same order as English
	{"297", "Скринька Пандори", "{{Warning}} ОДНОРАЗОВИЙ, створює нагороди залежно від поверху:#B1: 2{{SoulHeart}}; B2: 2{{Bomb}} + 2{{Key}}#C1: Предмет з пулу кімнати боса; C2: B1+C1#D1: 4{{SoulHeart}}; D2: 20{{Coin}}#W1: 2 Предмети з пулу кімнати боса#W2: {{Collectible33}} Біблія#???/Void: Нічого#Sheol: Предмет Диявола + 1{{BlackHeart}}#Cathe: Предмет Ангела + 1{{EternalHeart}}#Dark Room: Відкриває {{Collectible523}} Коробку для Перенесень; Chest: 1{{Coin}}"},
	{"298", "Копито Єдинорога", "Невразливість та +0.28 Швидкості на 6 секунд#Не дає контактної шкоди"},
	{"299", "Телець", "↓ {{Speed}} -0.3 Швидкість знижено#↑ {{Speed}} Поступово підвищує швидкість персонажа у ворожій кімнаті#При Швидкості 2, персонаж стає невразливим та наносить контактну шкоду#Після цього, бонус швидкості зникає"},
	{"300", "Овен", "↑ {{Speed}} +0.25 Швидкість збільшено#Дотик до ворогів наносить їм контактну шкоду"},
	{"301", "Рак", "{{SoulHeart}} +3 серця Душі#Отримання шкоди зменшує всю подальшу шкоду у цій кімнаті до половинки серця"},
	{"302", "Лев", "Персонаж може топтати перешкоди на шляху#Розмір збільшено"},
	{"303", "Діва", "При отриманні шкоди, персонаж може стати тимчасово невразливим#{{Luck}} 100% шанс при Удачі 10#{{Pill}} Перетворює погані пігулки на хороші"},
	{"304", "Терези", "+6 монет, ключів та бомб#Балансує характеристики персонажа#Подальші зміни характеристик будуть рівномірно розподілені по всіх характеристиках"},
	{"305", "Скорпіон", "{{Poison}} Отруйні сльози"},
	{"306", "Стрілець", "↑ {{Speed}} +0.2 Швидкість збільшення#Пронизуючі сльози"},
	{"307", "Козоріг", "↑ {{Heart}} +1 Контейнер червоних сердець#↑ {{Damage}} +0.5 Шкоду збільшено#↑ {{Speed}} +0.1 Швидкість збільшено#↑ {{Range}} +1.5 Дальність збільшено#↑ {{Tears}} Темп Стрільби збільшено#+1 бомба, монетка та ключ"},
	{"308", "Водолій", "Персонаж залишає слід з рідини#Рідина наносить 6 шкоди за секунду"},
	{"309", "Риби", "↑ {{Tears}} -1 Затримка між Слізьми#Збільшує відштовхування"},
	{"310", "Туш Єви", "↑ {{Damage}} +100% Шкоду збільшено#↓ {{Tears}} -50% Темп Стрільби зменшено#↓ {{Shotspeed}} -0.5 Швидкість Стрільби зменшено"},
	{"311", "Тінь Юди", "{{Player12}} При смерті, персонаж воскресає як Темний Юда з 2x множником Шкоди"},
	{"312", "Бантик Меггі", "↑ {{Heart}} +1 Контейнер червоних сердець#{{Heart}} Відновлює 1 червоне серце#Усі червоні серця відновлюють вдвічі більше здоров'я"},
	{"313", "Свята мантія", "Поглинає перший удар у кімнаті"},
	{"314", "Громові стегна", "↑ {{Heart}} +1 Контейнер червоних сердець#↓ {{Speed}} -0.4 Швидкість знижено#Персонаж може топтати перешкоди в себе на шляху"},
	{"315", "Дивна принада", "Сльози персонажа притягують ворогів, розхідники та брелки"},
	{"316", "Прокляте око", "Заряджувана атака хвилею з 4 сліз#{{Warning}} Отримання шкоди при частково зарядженій атаці, телепортує персонажа до випадкової кімнати#{{Collectible260}} Чорна Свічка прибирає ефект телепортації"},
	{"317", "Загадкова рідина", "Сльози персонажа залишають мокрий слід на підлозі#Рідина наносить 30 шкоди за секунду"},
	{"318", "Близнюки", "Компаньйон ближнього бою#Наносить 6 контактної шкоди за секунду"},
	{"319", "Інше око Каїна", "Хаотично літає по кімнаті#Стріляє у бік персонажа#{{Damage}} Наносить таку ж шкоду, як і персонаж"},
	{"320", "Єдиний друг ???", "Контрольована муха#Наносить 37.5 контактної шкоди за секунду"},
	{"321", "Кайдани Самсона", "Куля на ланцюзі, яка може руйнувати камені#Наносить 10.7 контактної шкоди за секунду"},
	{"322", "Дитя Монго", "Мімікрує під одного з компаньйонів персонажа#Наносить подвійну шкоду цього компаньйона"},
	{"323", "Сльози Ісаака", "Випускає 8 сліз в усі сторони#Сльози мають ефекти сліз персонажа#Перезаряджається при стрільбі"},
	{"324", "Невизначено", "Телепортує персонажа до {{TreasureRoom}} Скарбниці, {{SecretRoom}} Секретки, {{SuperSecretRoom}} Суперсекретки чи {{ErrorRoom}} Я - ПОМИЛКА"},
	{"325", "Ножиці", "Голова персонажа перетворюється на стаціонарного компаньйона#Тіло контролюється окремо"},
	{"326", "Подих життя", "Затисніть кнопку активації, щоб розрядити предмет#Персонаж стає невразливим, коли полоска заряду порожня#{{Warning}} Не утримуйте кнопку активації надто довго - персонаж почне отримувати шкоду"},
	{"327", "Полароїд", "Якщо у персонажа половинка червоного серця чи менше, при отриманні шкоди він тимчасово стає невразливим"},
	{"328", "Негатив", "Якщо у персонажа половинка червоного серця чи менше, при отриманні ним шкоди, предмет наносить шкоду всім ворогам у кімнаті"},
	{"329", "Технологія Людовіко", "Замінює атаку персонажа на одну велику контрольовану сльозу"},
	{"330", "Соєве молоко", "↑ {{Tears}} Темп Стрільби збільшено: (Затримка /4) - 2#↓ {{Damage}} Шкоду зменшено: -80%"},
	{"331", "Божество", "Самонавідні сльози#↑ {{Damage}} +0.5 Шкоду збільшено#↑ {{Range}} +1.2 Дальність збільшено#↓ {{Tears}} -0.3 Темп Стрільби знижено#↓ {{Shotspeed}} -0.3 Швидкість Стрільби знижено#↑ +0.8 Висота Польоту Сльози#У сліз з'являється аура, що наносить ворогам шкоду"},
	{"332", "Ганчір'я Лазаря", "{{Player11}} При смерті, ви воскресаєте за Лазаря (Воскреслого)"},
	{"333", "Розум", "Відкриває повну карту кожного поверху"},
	{"334", "Тіло", "↑ {{Heart}} +3 повні Контейнери червоних сердець"},
	{"335", "Душа", "{{SoulHeart}} +2 серця Душі#Навколо персонажа з'являється аура, що відштовхує ворогів та снаряди"},
	{"336", "Гнила цибуля", "Пронизуючі спектральні сльози#↑ {{Range}} +0.25 Дальність збільшено#↓ {{Shotspeed}} -0.4 Швидкість Стрільби знижено#↓ -0.5 Висота Польоту Сльози#↑ {{Tearsize}} +50% розмір сльози збільшено"},
	{"337", "Зламаний секундомір", "Сповільнює час у кожній 4 кімнаті#13% шанс прискорити кімнату"},
	{"338", "Бумеранг", "Метальний бумеранг#Оглушує ворогів та наносить 2x шкоди персонажа#Може захоплювати та притягувати розхідники"},
	{"339", "Шпилька", "↑ {{Range}} +5.25 Дальність збільшено#↑ {{Shotspeed}} +0.16 Швидкість Стрільби збільшено#↑ +0.5 Висота Польоту Сльози#{{BlackHeart}} +1 Чорне серце"},
	{"340", "Кофеїнова пігулка", "↑ {{Speed}} +0.3 Швидкість збільшено#↑ Розмір зменшено#{{Pill}} Створює випадкову пігулку"},
	{"341", "Розірване фото", "↑ {{Tears}} +0.7 Темп Стрільби збільшено#↑ {{Shotspeed}} +0.16 Швидкість Стрільби збільшено"},
	{"342", "Синя шапочка", "↑ {{Heart}} +1 Контейнер червоних сердець#↑ {{Tears}} +0.7 Темп Стрільби збільшено#↓ {{Shotspeed}} -16% Швидкість Стрільби зменшено"},
	{"343", "Запасний ключ", "↑ {{Luck}} +1 Удачу збільшено#{{SoulHeart}} +1 серце Душі#{{Key}} Створює 2 ключі"},
	{"344", "Сірникова коробка", "{{BlackHeart}} +1 Чорне серце#{{Bomb}} Створює 3 бомби"},
	{"345", "Синтол", "↑ {{Damage}} +1 Шкоду збільшено#↑ {{Range}} +5.25 Дальність збільшено#↑ +0.5 Висота Польоту Сльози"},
	{"346", "Перекус", "↑ {{Heart}} +1 Контейнер червоних сердець"},
	{"347", "Диплопія", "{{Warning}} ОДНОРАЗОВИЙ {{Warning}}#Дублює всі п'єдестали, розхідники, скрині та брелки в кімнаті"},
	{"348", "Плацебо", "{{Pill}} Активує ефект пігулки з інвентарю персонажа без її використання"},
	{"349", "Дерев'яний нікель", "50% шанс створити випадкову монету"},
	{"350", "Токсичний шок", "{{Poison}} Отруює ворогів при вході в кімнату#Вбиті вороги залишають калюжу токсичної рідини"},
	{"351", "Мега біб", "На кілька секунд заморожує всіх ворогів у кімнаті#Наносить 5 шкоди та отруює всіх ворогів поблизу#Посилає кам'яну хвилю в напрямку руху персонажа#Хвиля знищує перешкоди та може відкрити прохід у Секретну кімнату"},
	{"352", "Скляна гармата", "↓ Стрільба з гармати зменшує здоров'я персонажа до половинки серця#Випускає гігантську пронизуючу спектральну сльозу, що наносить 10x шкоди"},
	{"353", "Хлопчик-Підривник", "{{Bomb}} +5 бомб#Бомби вибухають в хрестоподібному шаблоні"},
	{"354", "Хрусткий Джек", "↑ {{Heart}} +1 Контейнер червоних сердець#{{Trinket}} Створює випадковий брелок"},
	{"355", "Матусине намисто", "↑ {{Range}} +1.25 Дальність збільшено#↑ {{Luck}} +1 Удачу збільшено#↑ +0.5 Висота Польоту Сльози"},
	{"356", "Автомобільний акумулятор", "Використання активного предмета активує його ефект двічі"},
	{"357", "Коробка з друзями", "Дублює всіх компаньйонів для поточної кімнати#Створює {{Collectible113}}Малюка Диявола, якщо в персонажа немає компаньйонів"},
	{"358", "Чаклун", "Персонаж одночасно випускає 2 сльози по діагоналі#Спектральні сльози"},
	{"359", "8-дюймові цвяхи", "↑ {{Damage}} +1.5 Шкоду збільшено#Збільшує віддачу"},
	{"360", "Інкуб", "Стріляє слізьми з такими ж характеристиками й ефектами, що і в персонажа"},
	{"361", "Нагорода долі", "Стріляє слізьми з такими ж характеристиками й ефектами, що і в персонажа#Стріляє вдвічі повільніше за інших компаньйонів"},
	{"362", "Крихітна скринька", "Створює випадковий розхідник кожні кілька кімнат"},
	{"363", "Затятий захисник", "Орбіталь#Наносить 105 контактної шкоди за секунду#Блокує та притягує на себе ворожі снаряди#Якщо Захисник заблокує 10 снарядів в 1 кімнаті, ви отримаєте Вічне серце"},
	{"364", "Френдзона", "Муха-орбіталь середнього радіуса#Наносить 45 контактної шкоди за секунду"},
	{"365", "Розгублена мушка", "Рухається вздовж стін/перешкод#Наносить 105 контактної шкоди за секунду"},
	{"366", "Розкидні бомби", "{{Bomb}} +5 бомб#Бомби, поставлені персонажем, розлітаються на 2-4 бомбочки при вибуху"},
	{"367", "Липкі бомби", "{{Bomb}} +5 бомб#При вбивстві ворога бомбою, з'являється синій павук#Бомби персонажа прилипають до ворогів"},
	{"368", "Епіфора", "Стрільба в одному напрямку поступово зменшує затримку між пострілами аж до -200%"},
	{"369", "Континуум", "↑ {{Range}} +2.25 Дальність збільшено#↑ +1.5 Висота Польоту Сльози#Спектральні сльози#Сльози можуть вилітати з одної сторони кімнати та з'являтися з іншої"},
	{"370", "Містер Лялька", "↑ {{Tears}} +0.7 Темп Стрільби збільшено#↑ {{Range}} +5.25 Дальність збільшено#↑ +0.5 Висота Польоту Сльози#{{UnknownHeart}} Створює 3 випадкові серця при піднятті"},
	{"371", "Прокляття вежі", "При отриманні персонажем шкоди, з'являється 6 троль-бомб#Троль-бомби успадковують ефекти бомб персонажа"},
	{"372", "Заряджене дитя", "Кожні 30 секунд у ворожій кімнаті компаньйон може:#Створити батарейку (максимум 2 на кімнату)#Додати один заряд до активного предмета (максимум 2 на кімнату)#Тимчасово заморозити всіх ворогів в кімнаті"},
	{"373", "Мертве око", "↑ {{Damage}} Послідовні влучання слізьми в ворогів дають +25% Шкоди(максимум +100%)#Промах має шанс скинути множник"},
	{"374", "Святе світло", "10% шанс вистрілити Святими слізьми, які створюють промінь світла при влучанні#Промінь наносить 4x шкоди персонажа#{{Luck}} 50% шанс при Удачі 9"},
	{"375", "Капелюх Господаря", "Імунітет до вибухів#Імунітет до кам'яних хвиль та ударів ногами Мами та Сатани#25% шанс відбити ворожий постріл"},
	{"376", "Поповнення", "Створює 3 випадкові розхідники#При покупці предметів у магазині, новий асортимент з'являється миттєво"},
	{"377", "Розірваний кокон", "Ворожі павуки більше не завдають шкоди персонажу"},
	{"378", "Номер 2", "{{Collectible209}} Стріляйте протягом 3 секунд, щоб створити підпалену Дупну бомбу"},
	{"379", "Роздвоєні зіниці", "Хітбокс сліз персонажа значно збільшується#Спектральні сльози"},
	{"380", "Плати та грай", "{{Coin}} +5 монет#Двері, що відкриваються 1 ключем, тепер відкриваються монетами"},
	{"381", "Едемове благословення", "↑ {{Tears}} +0.7 Темп Стрільби збільшено#Дає випадковий предмет на початку наступного забігу"},
	{"382", "Дружній м'яч", "Киньте у ворога, щоб спіймати його#Використайте М'яч ще раз, щоб звільнити ворога#Звільнений ворог стає вашим компаньйоном"},
	{"383", "Підривник сліз", "Розділяє усі сльози персонажа на екрані на кільця з 6 сліз"},
	{"384", "Крихітка Гарді", "{{Chargeable}} Компаньйон, що запускається і рикошетить по кімнаті зі швидкістю, що залежить від його заряду#Наносить 5-90 контактної шкоди за секунду, залежно від швидкості"},
	{"385", "Жебрало", "Збирає монетки поблизу#Росте після підбору 6, 12 та 24 монет#Рівень2: Шанс створити розхідник/предмет після зачистки кімнати#Рівень3: Випускає сльози, що можуть створити монетку при влучанні#Рівень4: Переслідує ворогів, раптово гублячи підпалені бомби; може створити монетку або предмет"},
	{"386", "D12", "Реролить усі перешкоди на інші випадкові перешкоди (напр. купки лайна, вази, TNT, червоні купки лайна, кам'яні блоки тощо)"},
	{"387", "Кадило", "Компаньйон, якого оточує аура світла, що сповільнює ворогів та їхні снаряди"},
	{"388", "Жебрак-ключник", "Збирає ключі та створює випадкові скрині"},
	{"389", "Мішечок для рун", "{{Rune}} Створює випадкову руну кожні 5-6 кімнат"},
	{"390", "Серафим", "Стріляє слізьми з ефектами {{Collectible182}}Святого Серця#Наносить 10 шкоди за постріл"},
	{"391", "Зрадник", "{{Charm}} При отриманні шкоди, персонаж причаровує усіх ворогів у кімнаті"},
	{"392", "Зодіак", "Ефект випадкового знаку зодіаку на кожен поверх"},
	{"393", "Зміїний поцілунок", "{{Poison}} 15% шанс вистрілити отруйною сльозою#{{Poison}} Ви отруюєте ворогів при дотику#{{BlackHeart}} Отруєні вороги можуть створити Чорне серце при смерті"},
	{"394", "Мічений", "Персонаж автоматично стріляє в бік червоної мітки на землі#↑ {{Tears}} +0.7 Темп Стрільби збільшено#↑ {{Range}} +3.15 Дальність збільшено#↑ +0.3 Висота Польоту Сльози"},
	{"395", "Технологія X", "{{Chargeable}} Сльози персонажа замінюються на заряджуване лазерне кільце#Розмір кільця збільшується залежно від заряду"},
	{"396", "Наскрізне лезо", "Створює 2 портали для подорожі між ними#Портали можна розмістити в різних кімнатах"},
	{"397", "Промінь тягача", "Сльози персонажа летять строго вздовж променя світла перед ним#↑ {{Tears}} +0.5 Темп Стрільби збільшено#↑ {{Range}} +5.25 Дальність збільшено#↑ {{Shotspeed}} +0.16 Швидкість Стрільби збільшено#↑ +0.5 Висота Польоту Сльози"},
	{"398", "Божественна плоть", "Сльози можуть зменшувати ворогів#Зменшених ворогів можна розтоптати, пройшовши по них"},
	{"399", "Паща Порожнечі", "↑ {{Damage}} +1 Шкоду збільшено#{{Chargeable}} Стріляйте протягом 3 секунд і відпустіть кнопки стрільби, щоб створити чорне кільце Сірки навколо персонажа#{{BlackHeart}} З ворогів, вбитих кільцем Сірки, можуть випасти Чорні серця"},
	{"400", "Спис Долі", "Персонаж тримає спис перед собою#Спис наносить 2x шкоди персонажа і може злякати ворогів при контакті"},
	{"401", "Вибухівчик", "25% шанс вистрілити липкими вибуховими слізьми#Липкі вибухові сльози не наносять шкоди при влучанні та вибухають через кілька секунд"},
	{"402", "Хаос", "Всі предмети обираються з випадкових предметних пулів#Створює 1-6 випадкових розхідників"},
	{"403", "Робо-павук", "Відображає шкоду від пострілу та полоску здоров'я ворогів#Накладає випадкові ефекти на ворогів при дотику#Випадково створює батарейки"},
	{"404", "Малюк Пердун", "Блокує ворожі снаряди#При ударі, 10% шанс пукнути та причарувати, отруїти або відштовхнути ворогів"},
	{"405", "Ігровий баг", "Літає по кімнаті#Наносить 120 шкоди за секунду та накладає випадкові ефекти на ворогів при дотику"},
	{"406", "D8", "Множить значення Шкоди, Темпу Стрільби, Дальності та Швидкості персонажа на випадкове значення в діапазоні 0.5-2x#Множники змінюються при кожній активації"},
	{"407", "Чистота", "↑ Покращує одну з характеристик персонажа залежно від кольору аури#Отримання шкоди прибирає ефект і змінює колір аури для наступних кімнат#{{ColorRed}}Червона{{CR}} = {{Damage}} +4 Шкоди#{{ColorBlue}}Синя{{CR}} = {{Tears}} -4 Затримки між Слізьми#{{ColorYellow}}Жовта{{CR}} = {{Speed}} +0.5 Швидкості#{{ColorOrange}}Оранжева{{CR}} = {{Range}} +7.5 Дальності, +1 Висота Польоту Сльози"},
	{"408", "Атаме", "При отриманні шкоди, навколо персонажа з'являється чорне кільце Сірки#{{BlackHeart}} Вороги, вбиті кільцем, можуть створити Чорне серце"},
	{"409", "Пуста посудина", "{{BlackHeart}} +2 Чорні серця#{{Blank}} Коли у персонажа немає Червоних сердець:#Політ#Кожні 40 секунд у ворожій кімнаті дає 10-тисекундний щит"},
	{"410", "Зле око", "3.33% шанс вистрілити оком#Око рухається по прямій лінії та випускає сльози в бік стрільби персонажа"},
	{"411", "Ненаситна кров", "↑ {{Damage}} +0.5 Шкоди за кожного ворога, вбитого у поточній кімнаті#Максимум +5 Шкоди після 10 вбивств"},
	{"412", "Демонічне зачаття", "Після отримання шкоди 15 разів, створює перманентного компаньйона-демона#Після двох компаньйонів, наступні будуть з'являтися після 30 ударів#Максимум 4 компаньйони"},
	{"413", "Непорочне зачаття", "При підйомі 15 сердець з'являється перманентний компаньйон-ангел#Максимум 5 компаньйонів#Після отримання 5 компаньйонів, починає створювати серця Душі на тих же умовах"},
	{"414", "Більше можливостей", "{{TreasureRoom}} Дозволяє обирати між 2 предметами у Скарбницях"},
	{"415", "Світлова корона", "{{SoulHeart}} +2 серця Душі#{{Blank}} Якщо у персонажа повністю заповнені усі контейнери червоних сердець (або вони повністю відсутні):#↑ {{Damage}} +100% Шкоду збільшено#↑ {{Range}} +5.25 Дальність збільшено#↑ +0.5 Висота Польоту Сльози#↓ {{Shotspeed}} -0.3 Швидкість Стрільби знижено#{{Blank}}#Отримання шкоди прибирає ефект для поточної кімнати"},
	{"416", "Глибокі кишені", "Дозволяє персонажу тримати 2 карти/пігулки/руни"},
	{"417", "Сукуб", "Літає по кімнаті, оточений аурою, що наносить 129% шкоди персонажа кожну секунду#↑ {{Damage}} +50% Шкоди, коли персонаж знаходиться в аурі"},
	{"418", "Фруктовий пиріг", "Кожна зі сліз персонажа отримує унікальний ефект"},
	{"419", "Телепорт 2.0", "Телепортує персонажа до кімнати, що ще не була зачищеною#Ієрархія: {{Room}}>{{BossRoom}}>{{SuperSecretRoom}}>{{Shop}}>{{TreasureRoom}}>{{SacrificeRoom}}> {{DiceRoom}}>{{Library}}>{{CursedRoom}}>{{MiniBoss}}>{{ChallengeRoom}}{{BossRushRoom}}>{{IsaacsRoom}}{{BarrenRoom}}> {{ArcadeRoom}}>{{ChestRoom}}>{{SecretRoom}}>{{DevilRoom}}{{AngelRoom}}>{{ErrorRoom}}"},
	{"420", "Чорний порошок", "Пройдіть по колу, щоб зобразити пентаграму, що наносить ворогам 10 шкоди за ігровий тік"},
	{"421", "Квасоля", "{{Charm}} Причаровує та наносить 5 шкоди всім ворогам поблизу"},
	{"422", "Сяйливий годинник", "Повертає персонажа до попередньої кімнати та скасовує всі його дії, виконані в кімнаті, де було активовано Годинник"},
	{"423", "Захисне коло", "Оточує персонажа великим німбом, що наносить контактну шкоду, рівну шкоді персонажа#Шанс відбити ворожі снаряди"},
	{"424", "Голова-мішок", "З шансом 33% розхідники будуть замінені на мішечок#Створює мішечок"},
	{"425", "Нічник", "Створює потік світла перед персонажем#Світло сповільнює ворогів та їх снаряди"},
	{"426", "Закоханий фанат", "Повторює рухи персонажа з затримкою на 3 секунди#Наносить 30 контактної шкоди за секунду"},
	{"427", "Шахтарська вибухівка", "Створює пересувну бочку з динамітом#Використання предмету вдруге в тій самій кімнаті дистанційно підриває бочку"},
	{"428", "Піжама", "{{SoulHeart}} +4 серця Душі#Повністю відновлює червоні серця"},
	{"429", "Голова Хранителя", "{{Coin}} 5% шанс, що при влучанні сльозою у ворога, випаде монетка"},
	{"430", "Татусь Муха", "Повторює рухи персонажа з затримкою на 1 секунду#Стріляє у ворогів поблизу, наносячи шкоду, рівну шкоді персонажа"},
	{"431", "Міжвимірне дитя", "Повторює рухи персонажа з затримкою на 2 секунди#Сльози, що пролітають крізь нього, подвоюються та отримують бонус до швидкості польоту"},
	{"432", "Блискучі бомби", "{{Bomb}} +5 бомб#При вибуху, бомби персонажа з 25% шансом можуть створити випадковий розхідник та з 15% шансом причарувати ворогів"},
	{"433", "Моя тінь", "При отриманні персонажем шкоди, на всіх ворогів накладається ефект страху та з'являється дружній чорний монстр#Монстр наносить 5 контактної шкоди за секунду"},
	{"434", "Банка з мухами", "При вбивстві ворога, у банці з'являється 1 синя муха#Максимум 20 мух у банці#Використання предмета випускає всіх мух"},
	{"435", "Крихітка Локі", "Стріляє одночасно 4 слізьми навхрест#Наносить 3.5 шкоди за постріл"},
	{"436", "Молоко!", "{{Tears}} При отриманні шкоди, ви отримуєте бонус до Темпу Стрільби на поточну кімнату"},
	{"437", "D7", "Перезапускає кімнату та відновлює ворогів у ній#Може бути використаний для отримання декількох нагород з однієї кімнати#Якщо використаний після бою із Жадібністю, реролить кімнату на нормальний Магазин/Секретку"},
	{"438", "Пипка", "{{SoulHeart}} +1 серце Душі#↑ {{Tears}} +0.75 Темп Стрільби збільшено#↑ Розмір зменшено"},
	{"439", "Матусина коробка", "{{Trinket}} Створює випадковий брелок#Поки ви тримаєте цей предмет, подвоює ефекти брелків#↑ {{Luck}} +1 Удача, поки ви тримаєте цей предмет"},
	{"440", "Нирковий камінь", "Персонаж раптово перестає стріляти та заряджає атаку, що випускає потік сліз та нирковий камінь#↓ -0.2 Швидкість зменшено#↓ -17 Дальність зменшено down#↑ +2 Висота Польоту Сльози"},
	{"441", "Мегазаряд", "Протягом 15 секунд випускає гігантський сірчаний лазер Мегасатани#Лазер діє між кімнатами та поверхами"},
	{"442", "Корона Темного Принца", "{{Blank}} Коли у вас рівно 1 червоне серце:#↑ {{Range}} +1.5 Дальність збільшено#↑ {{Tears}} +0.75 Темп Стрільби збільшено#↑ {{Shotspeed}} +0.2 Швидкість Стрільби збільшено#↑ +1 Висота Польоту Сльози#Не працює для персонажів, що не можуть мати червоних сердець"}, -- Dark Princes Crown (apostrophe added to the name in Repentance)
	{"443", "Яблуко!", "Персонаж деколи кидає лезом бритви, що наносить 400% шкоди#{{Luck}} 100% шанс при Удачі 14#↑ {{Tears}} +0.3 Темп Стрільби збільшено"},
	{"444", "Графітовий олівець", "Персонаж випускає град зі сліз кожен 15 постріл#Сльози із граду наносять подвійну шкоду"},
	{"445", "Собачий зуб", "↑ {{Damage}} +0.3 Шкоду збільшено#↑ {{Speed}} +0.1 Швидкість збільшено#{{SecretRoom}} Вовк виє у кімнатах, що межують із Секреткою/Суперсекреткою#{{LadderRoom}} Собака гавкає у кімнатах з проходом до криївки під каменями"},
	{"446", "Мертвий зуб", "Під час стрільби, персонажа оточує зелена аура, що отруює ворогів"},
	{"447", "Довгий біб", "Стрільба без паузи протягом 7.5 секунд створює хмарку#Хмаринка наносить шкоду персонажа 5 разів за секунду#Хмаринка існує протягом 15 секунд і може переміщуватись при стрільбі в неї"},
	{"448", "Кусок скла", "При отриманні шкоди:#{{Heart}} 25% шанс появи червоного серця#{{Collectible214}} 10% шанс отримати ↑ +5 Дальності та залишати кривавий слід у поточній кімнаті"},
	{"449", "Металева пластина", "{{SoulHeart}} +1 серце Душі#{{Confusion}} 25% шанс відбити ворожі снаряди й перетворити їх на сльози з ефектом оглушення"},
	{"450", "Око Жадібності", "Кожні 20 сліз, персонаж випускає сльозу-монетку, що наносить подвійну шкоду#Вороги, в яких влучає монетка, перетворюються на золотих#При вбивстві, з золотих ворогів випадає 1-4 монетки#Такий постріл коштує вам 1 монету"},
	{"451", "Сукно таро", "{{Card}} Створює випадкову картку#{{Card}} Подвоює ефекти всіх карт"},
	{"452", "Варикозні вени", "При отриманні шкоди, персонаж випускає 10 сліз навколо#Сльози наносять шкоду персонажа + 25"},
	{"453", "Перелом", "Сльози розлітаються на 1-3 дрібні уламки кісток при влучанні в будь-що#↑ +1.5 Дальність збільшено#↑ +1 Висота Польоту Сльози"},
	{"454", "Полідактилія", "Дозволяє персонажу одночасно тримати 2 картки, руни чи пігулки#Створює карту, руну чи пігулки"},
	{"455", "Татусева втрачена монета", "↑ {{Range}} +1.5 Дальність збільшено#↑ +1 Висота Польоту Сльози#Створює щасливу монетку"},
	{"456", "Опівнічний перекус", "↑ {{Heart}} +1 Контейнер червоних сердець"},
	{"457", "Яйцеголовий", "{{SoulHeart}} +1 серце Душі#20% шанс проігнорувати отриману шкоду"},
	{"458", "Пупок", "{{Trinket}} Дозволяє персонажу одночасно тримати 2 брелки#{{Trinket}} Створює випадковий брелок"},
	{"459", "Синусит", "20% шанс вистрілити липкими шмарклями#Шмарклі наносять шкоду, рівну шкоді персонажа, раз в секунду та прилипають на 60 секунд"},
	{"460", "Глаукома", "{{Confusion}} 5% шанс вистрілити оглушливими слізьми#Робить екран трішки темнішим"},
	{"461", "Паразитоїд", "15% шанс вистрілити павучим коконом#{{Luck}} 50% шанс при Удачі 5#Кокони створюють калюжу сповільнювальної рідини та синього павука чи муху при влучанні"},
	{"462", "Око Беліала", "↑ {{Range}} +1.5 Дальність збільшено#↑ +1 Висота Польоту Сльози#Пронизуючі сльози#Влучання у ворога перетворює сльозу на самонавідну та подвоює її шкоду"},
	{"463", "Сульфатна кислота", "↑ {{Damage}} +0.3 Шкоду збільшено#Сльози персонажа можуть руйнувати камені та відкривати двері"},
	{"464", "Гліф рівноваги", "{{SoulHeart}} +2 серця Душі#З ворогів-чемпіонів випадає розхідник, якого персонаж потребує найбільше"},
	{"465", "Аналоговий джойстик", "↑ {{Tears}} +0.3 Темп Стрільби збільшено#Дозволяє персонажу стріляти в будь-якому напрямку"},
	{"466", "Зараза", "{{Poison}} Перший вбитий у кімнаті ворог вибухає та отруює всіх ворогів поблизу"},
	{"467", "Пальчик!", "{{Damage}} Постійно наносить 10% шкоди персонажа в напрямку, куди він вказує"},
	{"468", "Тінь", "Повторює рухи персонажа з затримкою на 1 секунду#Наносить 30 контактної шкоди#Після того, як Тінь нанесе 600 шкоди, вона поглинається персонажем, збільшуючи його контактну шкоду"},
	{"469", "Депресія", "Залишає за собою мокрий слід#Рідина наносить 6 шкоди за секунду#Ворогів, що вступили в рідину, з певним шансом може вдарити промінь святого світла"},
	{"470", "Мовчун", "Літає по кімнаті#Наносить 2 контактної шкоди за ігровий тік#Перестає рухатись, коли персонаж стріляє#Блокує ворожі снаряди, поки не рухається"},
	{"471", "Крихітка Монстро", "{{Chargeable}} Заряджає атаку в стилі дробовика, аналогічно до {{Collectible229}} Легені Монстро#Кожна сльоза наносить по 3.5 шкоди"},
	{"472", "Дитя Король", "Інші компаньйони рухаються слідом за ним#Перестає рухатись, коли персонаж стріляє#Телепортується назад до персонажа, коли той перестає стріляти"},
	{"473", "Великий Чаббі", "Дуже повільно повзе вперед#Блокує ворожі постріли#Наносить 40.5 контактної шкоди за секунду"},
	{"474", "Мигдалик", "Блокує ворожі снаряди"},
	{"475", "План C", "{{Warning}} ОДНОРАЗОВИЙ {{Warning}}#Наносить 9,999,999 шкоди усім ворогам#Вбиває персонажа через 3 секунди після активації"},
	{"476", "D1", "Дублює 1 випадковий розхідник у поточній кімнаті"},
	{"477", "Порожнеча", "Поглинає усі п'єдестальні предмети в кімнаті#Активні предмети: їх ефекти активуються при поглинанні та при кожній наступній активації Порожнечі#↑ Пасивні предмети: покращує дві випадкові характеристики персонажа"},
	{"478", "Пауза", "Заморожує ворогів у кімнаті, допоки персонаж не вистрілить#Дотик до замороженого ворога все ще наносить шкоду персонажу#Вороги розморожуються через 30 секунд"},
	{"479", "Плавильня", "{{Trinket}} Поглинає брелок персонажа та дає перманентний ефект від цього брелка#Збільшує частоту появи брелків"},
	{"480", "Компост", "Перетворює розхідники на синіх мух чи павуків#Подвоює кількість ваших синіх мух та павуків#Створює 1 синю муху чи павука, якщо у персонажа немає жодного"},
	{"481", "Датамайнер", "↑ Покращення випадкової характеристики#↓ Погіршення іншої випадкової характеристики#Випадковий ефект сліз для поточної кімнати#Ламає усі спрайти та музику в кімнаті"},
	{"482", "Клікер", "Змінює вашого персонажа на випадкового іншого#Забирає останній отриманий предмет"},
	{"483", "Мама Мега!", "{{Warning}} ОДНОРАЗОВИЙ {{Warning}}#Впливає на весь поверх#Підриває всі перешкоди#Наносить 200 шкоди всім ворогам#Відкриває двері до Бос Рашу, Хаша та всі секретні кімнати#Якщо у вас є золота бомба, при активації натомість буде поглинута вона, дозволяючи застосувати Маму Мега ще раз"}, -- TODO назви босів синхронізувати з перекладом гри від Demabel
	{"484", "Стривай, що?", "При використанні, відштовхує ворогів та створює кам'яну хвилю довкола персонажа#Хвиля може відкривати секретні кімнати та ламати камені"},
	{"485", "Зігнутий пенні", "50% шанс подвоїти всі предмети, розхідники та скрині в кімнаті#50% шанс прибрати усі предмети/розхідники з кімнати та створити 1 монетку"},
	{"486", "Тупе лезо", "Завдає болю персонажу, не забираючи здоров'я#Активує будь-які \"при-ударні\" ефекти предметів"},
	{"487", "Картоплечистка", "Забирає один Контейнер червоних сердець: #↑ {{Damage}} +0.2 Шкоду збільшено#{{Collectible73}} Кубик М'яса#↑ {{Range}} +5 Дальності та кривавий слід за персонажем у поточній кімнаті"},
	{"488", "Метроном", "Ефект випадкового предмета для поточної кімнати"},
	{"489", "D Безмежність", "Активує ефект випадкового Кубика при кожному використанні"},
	{"490", "Едемова душа", "{{Warning}} ОДНОРАЗОВИЙ {{Warning}}#Створює 2 випадкові предмети залежно від пулу поточної кімнати#При першому підйомі не має зарядів"},
	{"491", "Кислотне дитя", "{{Pill}} Створює випадкову пігулку кожні 3 кімнати#{{Poison}} Використання пігулок отруює всіх ворогів у кімнаті"},
	{"492", "ХЕЙ, СЛУХАЙ!", "↑ {{Luck}} +1 Удачу збільшено#Позначає розміщення {{SecretRoom}} Секретних кімнат, каменів з мітками та входи до криївок"},
	{"493", "Адреналін", "Для кожного пустого контейнера червоних сердець:#↑ +0.2 Шкоду збільшено"},
	{"494", "Драбина Якова", "Сльози 1-2 електричні іскри при влучанні#Іскри наносять половину шкоди персонажа"},
	{"495", "Перець-привид", "Шанс вистрілити червоним вогнем, що блокує ворожі снаряди та наносить контактну шкоду#Вогонь зникає після нанесення шкоди чи блокування снарядів 5 разів"},
	{"496", "Евтаназія", "3.33% шанс вистрілити голкою#{{Luck}} 100% шанс при Удачі 15#Голки миттєво вбивають звичайних ворогів, розриваючи їх на 10 сліз#Голки наносять 3x шкоди босам"},
	{"497", "Камуфляжні труси", "При вході у кімнату, накладає на ворогів ефект спантеличення, що спадає після першого пострілу персонажа"},
	{"498", "Подвійність", "{{AngelDevilChance}} Створює двері до Ангела та Диявола, якщо хоч одні з них мали з'явитись#При вході в одні з дверей, інші зникають"},
	{"499", "Євхаристія", "{{AngelChance}} 100% шанс появи кімнат Ангела"},
	{"500", "Мішечок монет", "Створює мішечок кожні 5-6 кімнат"},
	{"501", "Стравохід Жадібності", "Додає 1 Контейнер червоних сердець за кожні 25 монет, зібраних після отримання Стравоходу#{{Player14}} Хранитель може отримати додаткові Монетки-серця"},
	{"502", "Гігантський прищ", "Стріляючи, персонаж раптово створює білу рідину, що наносить подвійну шкоду#При отриманні шкоди, персонаж вистрілює сльозою з білої рідини"},
	{"503", "Маленький ріг", "5% шанс вистрілити слізьми, що миттєво вбивають ворогів#Персонаж наносить 3.5 контактної шкоди"},
	{"504", "Коричневий самородок", "Створює муху-турель, що стріляє у ворогів#Кожен постріл наносить 2 шкоди"},
	{"505", "Покемончик", "При вході у ворожу кімнату є шанс створити причарованого ворога"},
	{"506", "І ти, Бруте?", "Удар ворогів у спину наносить подвійну шкоду та спричиняє кровотечу, що наносить 10% шкоди від максимального здоров'я ворога кожні 5 секунд"},
	{"507", "Гостра соломинка", "{{Damage}} Наносить шкоду персонажа + 10% від максимального здоров'я ворога всім ворогам у кімнаті#{{HalfHeart}} При нанесенні шкоди соломинкою, з певним шансом може з'явитися половинка серця#{{HalfSoulHeart}} Якщо у персонажа немає червоних сердець, натомість будуть з'являтися половинки синіх"},
	{"508", "Матусина бритва", "Орбіталь, що спричиняє кровотечу, яка наносить 10% шкоди від максимального здоров'я ворога кожні 5 секунд#При контакті, наносить 3x шкоди персонажа за секунду#Не блокує ворожі снаряди"},
	{"509", "Криваве око", "Орбіталь, що стріляє у випадковому напрямку кожні 2 секунди#Наносить 3.5 шкоди за постріл#Наносить 30 контактної шкоди за секунду#Не блокує ворожих снарядів"},
	{"510", "Несамовитий", "Створює випадкову дружню \"несамовиту\" версію боса для поточної кімнати"},
	{"511", "Розлючена муха", "Обертає випадкового ворога довкола персонажа, допоки ворог не помре#Наносить 30 контактної шкоди за секунду іншим ворогам"},
	{"512", "Чорна діра", "Метальна чорна діра, що засмоктує все довкола#Наносить 0.4 шкоди кожен ігровий тік#Знищує камені поблизу#Існує 6 секунд"},
	{"513", "Бозо", "↑ +0.1 Шкоду збільшено#+1 серце Душі#Випадково причаровує/лякає ворогів#При отриманні шкоди, персонаж з випадковим шансом може створити веселкове лайно"},
	{"514", "Зламаний модем", "Змушує деяких ворогів та снаряди раптово завмирати на випадкові проміжки часу#25% шанс подвоїти нагороду за зачистку кімнати"},
	{"515", "Загадковий подарунок", "{{Warning}} ОДНОРАЗОВИЙ {{Warning}}#Створює випадковий предмет з пулу поточної кімнати#Шанс натомість створити {{Collectible132}} Кусок Вугілля чи {{Collectible36}} Лайно"},
	{"516", "Зрошувач", "Створює зрошувач, що стріляє слізьми з ефектами персонажа навколо себе"},
	{"517", "Швидкі бомби", "{{Bomb}} +7 бомб#Прибирає затримку між розміщенням бомб"},
	{"518", "Друзяка в коробці", "Компаньйон, що виглядає як випадкове кооперативне дитя#Випадкові ефекти сліз#Ефекти змінюються на кожному поверсі"},
	{"519", "Крихітка Делліріум", "Перетворюється на випадкового компаньйона кожні 10 секунд"},
	{"520", "Кабель-перемичка", "Вбивство 15 ворогів додає 1 заряд до активного предмета"},
	{"521", "Купон", "Робить безкоштовним один випадковий предмет у {{Shop}} магазині чи {{DevilRoom}} кімнаті Диявола#Допоки ви тримаєте цей предмет, один з товарів у магазині буде за знижкою"},
	{"522", "Телекінез", "На 3 секунди зупиняє усі ворожі снаряди, що наблизились до персонажа, та відкидає їх від нього опісля"},
	{"523", "Коробка для перенесень", "Зберігає всі розхідники та предмети з поточної кімнати#Повторне використання викидає на підлогу весь вміст Коробки#Дозволяє переносити речі між кімнатами та поверхами"},
	{"524", "Технологія Нуль", "Сльози персонажа з'єднані між собою електричними розрядами#Розряди наносять шкоду, рівну шкоді персонажа"},
	{"525", "Проказа", "При отриманні шкоди, з'являється орбіталь, що блокує снаряди#Максимум 3 орбіталі#Орбіталь може бути знищеним, якщо заблокує забагато шкоди"},
	{"526", "7 Печаток", "Створює компаньйона у вигляді малого вершника, що створює сарану#Тип вершника та сарани змінюється кожні 10 секунд"},
	{"527", "Містер Я!", "Протягом декількох секунд відображає рухомий курсор, після чого створює привида, дії якого залежать від положення курсора:#Відкриває двері чи скрині#Піднімає предмет#50% шанс вкрасти з магазину чи кімнати Диявола#Атакує ворога, допоки той не помре#Підриває стіни, камені, крамарів, статуї ангелів, ігрові автомати та жебраків"},
	{"528", "Ангельська призма", "Орбітальна призма#Дружні сльози, що влучають у неї, розділяються на 4"},
	{"529", "Хлюп!", "Сльози персонажа штовхають одна одну та зникають, коли перестають рухатись"},
	{"530", "Список смерті", "Вбивайте ворогів згідно з порядком, вказаним знаком {{DeathMark}} над ними, щоб отримати випадковий розхідник чи перманентне підвищення характеристики"},
	{"531", "Гемолакрія", "Сльози персонажа летять по навісній траєкторії та розлітаються на дрібні сльози при влучанні#↓ Темп Стрільби знижено#↑ +31% Шкоду збільшено"},
	{"532", "Сльозотеча", "Сльози персонажа поступово сповільнюються, зупиняються, а тоді вибухають на 8 менших#Сльози можуть об'єднуватись та ставити більшими"},
	{"533", "Трисвяте", "Замінює сльози персонажа на пронизливі промені світла#Промені наносять 33% шкоди, але можуть вдаряти ворогів декілька разів"},
	{"534", "Рюкзак", "Дозволяє персонажу тримати 2 активні предмети#Активні предмети можна міняти, використовуючи кнопку Скиду ({{ButtonRT}})"},
	{"535", "Ковдра", "{{SoulHeart}} +1 серце Душі#{{Heart}} Відновлює 1 червоне серце#{{Collectible313}} При вході у кімнату боса, персонаж отримує ефект {{HolyMantleSmall}} Святої Мантії"},
	{"536", "Вівтар для жертвопринесень", "{{Warning}} ОДНОРАЗОВИЙ {{Warning}}#Принесіть у жертву 1-2 компаньйонів, щоб створити предмет Диявола за кожну пожертву#Перетворює синіх павуків та мух на монети"},
	{"537", "Крихітка Ригачка", "{{Pill}} Створює випадкову пігулку#Випускає струмінь рідини#Тип рідини змінюється при кожному використанні пігулки"},
	{"538", "Камінці", "{{Trinket}} Створює 3 випадкові брелки#{{Collectible479}} При отриманні шкоди, активний брелок може бути поглинутий та перенесений до інвентарю предметів, перманентно даючи свій ефект"},
	{"539", "Загадкове яйце", "При отриманні персонажем шкоди, з'являється причарований ворог#Створює сильніших друзів, якщо ви зачистили багато кімнат без отримання шкоди"},
	{"540", "Плаский камінь", "Сльози персонажа відскакують від підлоги та наносять шкоду від сплеску при кожному стрибку"},
	{"541", "Кістковий мозок", "{{EmptyBoneHeart}} +1 Кісткове серце#{{Heart}} Створює 3 червоні серця"},
	{"542", "Зміщене ребро", "Орбіталь#Відбиває ворожі знаряди"},
	{"543", "Свята земля", "При отриманні шкоди, ви створюєте біле лайно#Допоки в аурі лайна:#↑ {{Tears}} -50% Затримка між Слізьми#Шанс заблокувати шкоду"},
	{"544", "Загострене ребро", "Зависає перед персонажем#Наносить шкоду персонажа 6 разів за секунду"},
	{"545", "Книга Мертвих", "Створює кістку-орбіталь або причарованого Боні за кожного вбитого у кімнаті ворога"},
	{"546", "Татусеве кільце", "Аура, що заморожує ворогів на місці"},
	{"547", "Документи про розлучення", "{{EmptyBoneHeart}} +1 Кісткове серце#↑ {{Tears}} +0.7 Темп Стрільби збільшено#{{Trinket21}} Створює брелок Загадковий листок"},
	{"548", "Щелепна кістка", "Компаньйон-бумеранг#Наносить 7 контактної шкоди#Може притягувати розхідники"},
	{"549", "Крихкі кістки", "{{EmptyBoneHeart}} Замінює усі Контейнери червоних сердець на 6 пустих Кісткових сердець#При втраті Кісткового серця:#Випускає 8 кісткових сліз у всіх напрямках#↑ {{Tears}} +0.5 Темп Стрільби збільшено перманентно"},
	{"550", "Зламана лопата", "Матусина Нога постійно намагається вас розтоптати#Використання предмета зупиняє тупіт для поточної кімнати#{{Warning}} (Спробуйте пройти Бос Раш!)"},
	{"551", "Зламана лопата", "Доповнює Матусину Лопату#{{Warning}} Застосуйте лопату на купці землі у \"Темній Кімнаті\""},
	{"552", "Матусина лопата", "Створює люк на наступний поверх#10% шанс створити {{LadderRoom}}прохід до криївки#{{Warning}} Застосуйте лопату на купці землі у \"Темній Кімнаті\""},
}

---------- Trinkets ----------
EID.descriptions[languageCode].trinkets={
	{"1", "Проковтнутий пенні", "{{Coin}} При отриманні персонажем шкоди, на підлозі з'являються монети"},
	{"2", "Скам'яніла какашка", "50% шанс отримати щось з купки лайна"},
	{"3", "AAA Батарейка", "Активні предмети потребують на 1 заряд менше"},
	{"4", "Зламаний пульт", "{{Collectible44}} При застосуванні активного предмета, персонаж телепортується у випадкову кімнату"},
	{"5", "Фіолетове серце", "2x шанс появи ворогів-чемпіонів"},
	{"6", "Зламаний магніт", "Притягує монети до персонажа"},
	{"7", "Намистина з вервиці", "{{AngelChance}} +50% шанс появи кімнати Ангела#{{Collectible33}} Збільшений шанс появи Біблії в {{Shop}} Магазинах та {{Library}} Бібліотеках"},
	{"8", "Картридж", "{{Collectible93}} Коли персонажу завдають шкоди, з 5% шансом може активуватись ефект Геймкіда"},
	{"9", "Пульсуючий черв", "Сльози персонажа пульсують#Впливає на хітбокс сліз"},
	{"10", "Хвилястий черв", "Сльози персонажа рухаються хвилями#↑ {{Tears}} +0.3 Темп Стрільби збільшено"},
	{"11", "Кільчастий черв", "Сльози персонажа з великою швидкістю рухаються по спіралі"},
	{"12", "Плаский черв", "На 50% ширші сльози#Підвищує відштовхування"},
	{"13", "Кредит", "{{Shop}} Дозволяє взяти 1 предмет з магазину безкоштовно"},
	{"14", "Мозоль", "Імунітет до рідини та шипів на підлозі"},
	{"15", "Щасливий камінь", "{{Coin}} При знищенні каменів, з'являються монетки"},
	{"16", "Матусин ніготь", "Матусина Нога тупає у випадковому місці кожні 60 секунд"},
	{"17", "Чорна помада", "{{BlackHeart}} +10% шанс, що замість серця Душі з'явиться чорне серце"}, -- base chance is +5%
	{"18", "Біблійний трактат", "{{EternalHeart}} +3% шанс появи Вічних сердець"}, -- base chance is 1.667%
	{"19", "Скріпка", "Золоті скрині {{GoldenChest}} відкриваються безкоштовно"},
	{"20", "Мавпяча лапа", "{{BlackHeart}} Створює 1 Чорне серце, коли здоров'я персонажа зменшується до половинки серця#{{Warning}} Зникає після створення 3 чорних сердець"},
	{"21", "Загадковий листок", "{{Blank}} Випадково дає ефект одного з предметів: #{{Collectible327}} Полароїд#{{Collectible328}} Негатив#{{Trinket48}} Втрачена сторінка#{{Trinket23}} Оголошення про зникнення"},
	{"22", "Хвіст демона", "{{Heart}} Знижує шанс появи сердець до 20%#{{BlackHeart}} Усі серця на підлозі стають чорними#{{Key}} Збільшує шанс появи ключів"},
	{"23", "Оголошення про зникнення", "Персонаж відроджується за {{Player10}} Загубленого при смерті#Смерть у {{SacrificeRoom}} Кімнаті Жертвопринесень, коли ви тримаєте цей брелок, відкриває Загубленого"},
	{"24", "Дуповий пенні", "{{Coin}} На 20% вищий шанс появи монетки з купи лайна#Персонаж пукає, підіймаючи монети"},
	{"25", "Загадкова цукерка", "Персонаж пукає або створює купу лайна кожні 30 секунд"},
	{"26", "Гаковий черв", "Сльози персонажа рухаються по кутовій траєкторії#↑ {{Range}} +10 Дальність збільшено"},
	{"27", "Батоговий черв", "↑ {{Shotspeed}} +0.5 Швидкість Стрільби збільшено"},
	{"28", "Зламаний хрест", "{{Player4}} 22% шанс відродитися як ??? (Синій Малюк) при смерті"},
	{"29", "Голова риби", "Коли персонажу завдають шкоди, з'являється 1 синя муха"},
	{"30", "Кон'юнктивіт", "{{Poison}} 10% шанс вистрілити отруйною сльозою"},
	{"31", "Канцелярська кнопка", "10% шанс вистрілити пронизуючою спектральною сльозою"},
	{"32", "Шапка свободи", "25% шанс на випадковий ефект гриба на кімнату#Може відобразити спеціальні кімнати на карті"},
	{"33", "Пуповина", "Компаньйон {{Collectible100}} Маленький Стівен на поточну кімнату, коли здоров'я персонажа зменшується до половинки серця"},
	{"34", "Дитяче серце", "{{Heart}} 10% шанс, що винагородою за зачистку кімнати буде випадкове серце#Шанс на додаткові серця зі скринь, каменів з мітками та зламаних автоматів"},
	{"35", "Загнутий ріг", "↑ {{Damage}} +2 Шкоду збільшено"},
	{"36", "Іржавий ключ", "{{Key}} 10% шанс, що нагородою за зачистку кімнати буде ключ#{{Key}} Шанс на додаткові ключі зі скринь, каменів з мітками та зламаних автоматів"},
	{"37", "Козляча ратиця", "↑ {{Speed}} +0.15 Швидкість збільшено"},
	{"38", "Матусина перлина", "+10% шанс на появу {{SoulHeart}} сердець Душі, {{BlackHeart}} Чорних сердець чи {{EmptyBoneHeart}} Кісткових сердець"}, -- base chance is 10%
	{"39", "Рак", "↑ {{Tears}} -2 Затримка між слізьми знижена"},
	{"40", "Червона латка", "{{Damage}} Коли персонажу завдають шкоди, з 20% шансом спрацьовує ефект +1.8 Шкоду збільшено#{{Luck}} 100% шанс при Удачі 8#{{Timer}} Ефект діє одну кімнату"},
	{"41", "Сірник", "{{Bomb}} 10% шанс, що нагородою за зачистку кімнати буде бомба#{{Bomb}} Шанс на додаткові бомби зі скринь, каменів з мітками та зламаних автоматів#{{Warning}} Знімає {{Trinket53}}Кліща"},
	{"42", "Щасливий палець", "↑ {{Luck}} +1 Удачу збільшено#+8% шанс отримати нагороду за зачистку кімнати#Додаткові розхідники зі скринь, каменів з мітками та зламаних автоматів"},
	{"43", "Проклятий череп", "Коли здоров'я персонажа знижується до половинки серця, він телепортується у випадкову кімнату"},
	{"44", "Захисний ковпачок", "{{Pill}} 10% шанс, що нагородою за зачистку кімнати буде пігулка#{{Pill}} Шанс на додаткову пігулку зі скринь, каменів з мітками та зламаних автоматів"},
	{"45", "Піковий туз", "{{Card}} 10% шанс, що нагородою за зачистку кімнати буде карта#{{Card}} Шанс на додаткову картку зі скринь, каменів з мітками та зламаних автоматів"},
	{"46", "Ісаакова виделка", "{{HalfHeart}} З шансом 10%, ви можете відновити половинку серця за зачистку кімнати"},
	{"47", "", "<Item does not exist>"},
	{"48", "Загублена сторінка", "Отримання шкоди з 5% шансом може активувати ефект, що наносить 40 шкоди всім ворогам у кімнаті"},
	{"49", "Кривавий пенні", "{{HalfHeart}} При піднятті монети, з 50% шансом з'являється половинка серця"},
	{"50", "Спалений пенні", "{{Bomb}} При піднятті монети, з 50% шансом може з'явитися бомба"},
	{"51", "Плаский пенні", "{{Key}} При піднятті монети, з 50% шансом може з'явитися ключ"},
	{"52", "Фальшивий пенні", "{{Coin}} При піднятті монети, з 50% шансом вам в інвентар може зарахуватися ще одна"},
	{"53", "Кліщ", "-15% здоров'я боса#{{BossRoom}} Відновлює 1 червоне серце, коли ви заходите в кімнату боса#{{Warning}} Може бути знятий лише {{Trinket41}} Сірником або проковтнутий"},
	{"54", "Голова Ісаака", "Компаньйон з пронизуючими слізьми#Наносить 3.5 шкоди за сльозу"},
	{"55", "Віра Меггі", "{{EternalHeart}} При переході на наступний поверх, персонаж отримує +1 Вічне серце"},
	{"56", "Язик Юди", "{{DevilRoom}} Зменшує усі ціни Диявольських Угод до 1 контейнера червоних сердець#Не знижує вартість угод за 3 серця Душі"},
	{"57", "Душа ???", "Компаньйон, що літає по кімнаті#Стріляє у тому ж напрямку, що і персонаж#Наносить 3.5 шкоди за сльозу"},
	{"58", "Пасмо волосся Самсона", "{{Damage}} За вбивство ворога, з шансом 1/15 ви можете отримати +0.5 Шкоди#{{Luck}} 100% шанс при Удачі 10#{{Timer}} Ефект триває 1 кімнату"},
	{"59", "Око Каїна", "При переході на новий поверх, з 25% шансом на карті будуть відображені значки кімнат#100% шанс при Удачі 3"},
	{"60", "Лапка пташки Єви", "{{Collectible117}} За вбивство ворога, з 5% шансом може з'явитися компаньйон Мертва Пташка#{{Luck}} 100% шанс при Удачі 8"},
	{"61", "Ліва рука", "Перетворює усі скрині на червоні"},
	{"62", "Блискучий камінь", "Камені з мітками та камені з входом до Криївки відблискують кожні 10 секунд"},
	{"63", "Безпечні ножиці", "Перетворює троль-бомби на бомби-розхідники"},
	{"64", "Веселковий черв", "Ефект випадкового черв'яка кожні 3 секунди"},
	{"65", "Стрічковий черв", "↑ {{Range}} x2 Дальність#↓ x0.5 Висота Польоту Сліз"},
	{"66", "Лінивий черв", "↓ {{Shotspeed}} -0.4 Швидкість Стрільби знижено#↑ {{Range}} +4 Дальність збільшено#↑ +2 Висота Польоту Сліз"},
	{"67", "Розбитий ігровий кубик", "При отриманні персонажем шкоди, з 50% шансом активується один з ефектів:#{{Collectible105}} D6#{{Collectible406}} D8#{{Collectible386}} D12 #{{Collectible166}} D20"},
	{"68", "Супермагніт", "Персонаж притягує розхідники та ворогів"},
	{"69", "Вицвілий полароїд", "Випадково маскує персонажа#Бентежить ворогів"},
	{"70", "Воша", "Раптово створює синіх павуків у ворожих кімнатах"},
	{"71", "Сечовий міхур Боба", "Бомби персонажа залишають мокрий слід, що наносить шкоду ворогам"},
	{"72", "Запасна батарейка", "6.66% шанс, що нагородою за зачистку кімнати буде батарейка#+10% до шансу, що випадково створений розхідник буде батарейкою#5% шанс отримати додатковий 1 заряд за зачистку кімнати"},
	{"73", "Вибуховий ковпачок", "10% шанс появи бомби-розхідника при вибуху іншої бомби"},
	{"74", "Шукач", "Коли ви знищуєте камені, з шансом 0.5% може відобразитись розташування люка до {{LadderRoom}} Криївки"},
	{"75", "Помилка", "Ефект випадкового брелка для кожної кімнати"},
	{"76", "Фішка для покеру", "↑ 50% шанс отримати додаткові розхідники зі скринь#↓ 50% шанс, що скриня міститиме 1 муху"},
	{"77", "Пухир", "Збільшує відштовхування"},
	{"78", "Секундна стрілка", "Накладені на ворогів ефекти тривають вдвічі довше"},
	{"79", "Безіменна нескінченність", "При використанні пігулки, карти чи руни, з 25% шансом ви отримаєте її копію"},
	{"80", "Чорна пір'їна", "↑ {{Damage}} +0.2 Шкоду збільшено за кожен \"Лихий\" предмет в інвентарі"},
	{"81", "Сліпа лють", "Ефект невразливості після отримання шкоди триває вдвічі довше"},
	{"82", "Золота підкова", "{{TreasureRoom}} +15% до шансу, що у наступних Скарбницях буде вибір між 2 предметами"},
	{"83", "Ключ до магазину", "{{Shop}} Дозволяє безкоштовно заходити у Магазин"},
	{"84", "Ребро Жадібності", "На 5% більше монет і менше сердець з наступних нагород#Жадібність і Супер Жадібність більше не з'являються у {{Shop}}Магазинах чи {{SecretRoom}}Секретних кімнатах"},
	{"85", "Карма", "{{DonationMachine}} При використанні Автомата для Пожертв, ви можете:#{{Heart}} Відновити 1 серце#{{Coin}} Отримати 1 монету#{{Luck}} Отримати +1 Удачу#{{Beggar}} Створити Жебрака"},
	{"86", "Крихітна личинка", "При знищенні купок лайна, з них з'являється 1 синя муха"},
	{"87", "Матусин медальйон", "При використанні ключа, ви відновлюєте половинку серця#Перетворює половинки сердець на цілі"},
	{"88", "НІ!", "Активні предмети більше не з'являтимуться"},
	{"89", "Дитячий повідок", "Компаньйони знаходяться ближче до персонажа"},
	{"90", "Коричневий ковпачок", "При знищенні, купки лайна вибухають і наносять 100 шкоди ворогам поблизу"},
	{"91", "Меконій", "33% шанс появи купок чорного лайна#При знищенні таких купок, з 5% шансом може з'явитися Чорне серце"},
	{"92", "Зламана корона", "↑ Надалі характеристики збільшуються на 33% ефективніше#↑ +0.2 Темп Стрільби збільшено#↑ -1 Затримка між слізьми"},
	{"93", "Використаний підгузок", "15% шанс, що усі мухи в кімнаті стануть дружніми"},
	{"94", "Риб'ячий хвіст", "Подвоює кількість створюваних синіх павуків та мух"},
	{"95", "Чорний зуб", "3% шанс вистрілити отруйною сльозою-зубом"},
	{"96", "Черв'як Уроборос", "Сльози персонажа швидко рухаються по спіралі#Спектральні сльози#↑ {{Range}} +4 Дальність збільшено#↑ +2 Висота Польоту Сльози"},
	{"97", "Мигдалик", "При отриманні персонажем шкоди 12-20 разів, з'являється компаньйон, що блокує ворожі снаряди#До 2 компаньйонів"},
	{"98", "Ніс гобліна", "10% шанс вистрілити липкою самонавідною сльозою#Соплі наносять шкоду персонажа раз на секунду#Соплі прилипають на 60 секунд"},
	{"99", "Пострибунчик", "10% шанс вистрілити сльозою, що рикошетить від ворогів та перешкод"},
	{"100", "Яскрава лампочка", "Поки персонаж тримає повністю заряджений активний предмет:#↑ {{Damage}} +0.5 Шкоду збільшено#↑ {{Speed}} +0.25 Швидкість збільшено#↑ {{Range}} +0.75 Дальність збільшено#↑ {{Tears}} +0.2 Темп Стрільби збільшено#↑ {{Shotspeed}} +0.1 Швидкість Стрільби збільшено#↑ {{Luck}} +1 Удачу збільшено"},
	{"101", "Згасла лампочка", "Поки персонаж тримає повністю розряджений активний предмет:#↑ {{Damage}} +1.5 Шкоду збільшено#↑ {{Speed}} +0.5 Швидкість збільшено#↑ {{Range}} +1.5 Дальність збільшено#↑ {{Tears}} +0.4 Темп Стрільби збільшено#↑ {{Shotspeed}} +0.3 Швидкість Стрільби збільшено#↑ {{Luck}} +2 Удачу збільшено"},
	{"102", "Фрагментована карточка", "{{SecretRoom}} +1 Секретна кімната на поверсі, поки ви тримаєте це брелок"},
	{"103", "Рівність!", "{{Warning}} Перетворює розхідники на їх подвійні версії, поки в інвентарі персонажа однакова кількість бомб, ключів та монет"},
	{"104", "Кістка бажання", "2% шанс створити п'єдестал з артефактом, коли персонажу завдають шкоди#Самознищується після цього"},
	{"105", "Сумка з обідом", "{{Collectible22}} 2% шанс створити Обід, коли персонажу завдають шкоди#Самознищується після цього"},
	{"106", "Втрачений корок", "Збільшує радіус калюж рідини, які залишає персонаж чи його компаньйони"},
	{"107", "Вороняче серце", "При отриманні шкоди, персонаж спочатку втрачає червоні серця, а не сині чи чорні#Це не зменшує шанс на появу кімнат Диявола/Ангела"},
	{"108", "Волоський горіх", "Отримання ударів від 1-9 вибухів знищує брелок та створює ключ, монету, серце та інший випадковий брелок#Отримання шкоди не є обов'язковим"},
	{"109", "Клейка стрічка", "Компаньйони зупиняються на одному місці та не можуть рухатись"},
	{"110", "Срібний долар", "{{Shop}} Магазини з'являються в Матці"},
	{"111", "Кривава корона", "{{TreasureRoom}} Скарбниці з'являються в Матці"},
	{"112", "Плати, щоб виграти", "{{RestockMachine}} Автомати Поповнення запасів завжди з'являються в {{TreasureRoom}} Скарбницях"},
	{"113", "Сарана Війни", "Заходячи у ворожу кімнату, персонаж створює вибухову атакуючу муху#Муха наносить x2 шкоди персонажа + шкоду від вибуху"},
	{"114", "Сарана Чуми", "Заходячи у ворожу кімнату, персонаж створює отруйну атакуючу муху#Муха наносить x2 шкоди персонажа"},
	{"115", "Сарана Голоду", "Заходячи у ворожу кімнату, персонаж створює сповільнювальну атакуючу муху#Муха наносить x2 шкоди персонажа"},
	{"116", "Сарана Смерті", "Заходячи у ворожу кімнату, персонаж створює атакуючу муху#Муха наносить x4 шкоди персонажа"},
	{"117", "Сарана Завоювання", "Заходячи у ворожу кімнату, персонаж створює 1-4 атакуючих мух#Кожна муха наносить x2 шкоди персонажа"},
	{"118", "Кажаняче крило", "За вбивство ворога, з 5% шансом ви можете отримати політ для поточної кімнати"},
	{"119", "Стовбурова клітина", "При переході на наступний поверх, персонаж відновлює половинку серця"},
	{"120", "Шпилька для волосся", "Заходячи в незачищену кімнату боса, ви повністю заряджаєте свої активні предмети"},
	{"121", "Дерев'яний хрест", "{{Collectible313}} Захищає від першого удару на поверсі"},
	{"122", "Масло!", "При використанні активних предметів, вони вислизають на підлогу#Отримуючи шкоду, з 2% шансом персонаж випустить на підлогу один з пасивних предметів"},
	{"123", "Філігранне перо", "Боси Ангели створюють предмети ангельського пулу замість частин ключа"},
	{"124", "Підпірка для дверей", "Двері, через які ви потрапили до кімнати, залишаються відкритими"},
	{"125", "Подовжувач", "З'єднує усіх компаньйонів електричними розрядами#Розряди наносять 6 шкоди"},
	{"126", "Гнилий пенні", "При піднятті монети з'являється синя муха"},
	{"127", "Дитяча ложка", "Усі компаньйони стріляють самонавідними слізьми"},
	{"128", "Кістка з пальця", "{{EmptyBoneHeart}} Коли персонажу завдають шкоди, з шансом 2% він отримає Кісткове серце"},
}

---------- Cards ----------
EID.descriptions[languageCode].cards={
	{"1", "0 - Дурень", "Телепортує персонажа до першої кімнати на поверсі"},
	{"2", "I - Чарівник", "Самонавідні сльози для поточної кімнати"},
	{"3", "II - Верховна жриця", "Матусина Нога чавить ворога#Якщо в кімнаті немає ворогів, Нога намагається попасти в персонажа"},
	{"4", "III - Імператриця", "Для поточної кімнати: #↑ {{Damage}} +2.35 Шкоду збільшено#↑ {{Speed}} +0.3 Швидкість збільшено"},
	{"5", "IV - Імператор", "{{BossRoom}} Телепортує персонажа в кімнату боса"},
	{"6", "V - Первосвященик", "{{SoulHeart}} Створює 2 серця Душі"},
	{"7", "VI - Коханці", "{{Heart}} Створює 2 червоні серця"},
	{"8", "VII - Колісниця", "Невразливість + контактна шкода на 6 секунд"},
	{"9", "VIII - Справедливість", "Створює 1 бомбу, 1 ключ, 1 монетку, 1 серце"},
	{"10", "IX - Відлюдник", "{{Shop}} Телепортує персонажа у Магазин"},
	{"11", "X - Колесо фортуни", "Створює {{Slotmachine}} Ігровий Автомат або {{FortuneTeller}} Автомат з Передбаченнями"},
	{"12", "XI - Сила", "Для поточної кімнати: #↑ {{Heart}} +1 Здоров'я збільшено#↑ {{Damage}} +0.3 Шкоду збільшено#↑ {{Damage}} +50% Шкоди#↑ {{Range}} +5.25 Дальність збільшено#↑ +0.5 Висота Польоту Сліз#↑ {{Speed}} +0.3 Швидкість збільшено"},
	{"13", "XII - Повішений", "Політ для поточної кімнати"},
	{"14", "XIII - Смерть", "Наносить 40 шкоди усім ворогам у кімнаті"},
	{"15", "XIV - Терпіння", "Створює {{DonationMachine}} Автомат Прийому Крові#{{GreedMode}} Створює Жебрака-Диявола у режимі Жадібності"},
	{"16", "XV - Диявол", "Для поточної кімнати: #↑ {{Damage}} +2 Шкоду збільшено"},
	{"17", "XVI - Башта", "Створює 6 Троль-бомб"},
	{"18", "XVII - Зірки", "{{TreasureRoom}} Телепортує персонажа у Скарбницю (Золоту кімнату)"},
	{"19", "XVIII - Місяць", "{{SecretRoom}} Телепортує персонажа в Секретну кімнату"},
	{"20", "XIX - Сонце", "Наносить 100 шкоди усім ворогам в кімнаті#Повне здоров'я#Відкриває карту цілого поверху"},
	{"21", "XX - Суд", "Створює Жебрака чи Жебрака-Диявола"},
	{"22", "XXI - Світ", "Відкриває карту поверху та типи кімнат"},
	{"23", "2 Трефа", "{{Bomb}} Подвоює кількість бомб в інвентарі персонажа"},
	{"24", "2 Бубни", "{{Coin}} Подвоює кількість монет в інвентарі персонажа"},
	{"25", "2 Піки", "{{Key}} Подвоює кількість ключів в інвентарі персонажа"},
	{"26", "2 Черви", "{{Heart}} Подвоює кількість червоних сердець#Має лише лікувальний ефект"},
	{"27", "Трефовий туз", "{{Bomb}} Перетворює усі розхідники в кімнаті на бомби"},
	{"28", "Бубновий туз", "{{Coin}} Перетворює усі розхідники в кімнаті на монети"},
	{"29", "Піковий туз", "{{Key}} Перетворює усі розхідники в кімнаті на ключі"},
	{"30", "Червовий туз", "{{Heart}} Перетворює усі розхідники в кімнаті на серця"},
	{"31", "Джокер", "{{AngelDevilChance}} Телепортує персонажа в кімнату Диявола чи Ангела"},
	{"32", "Хаґалаз", "Знищує усі камені в кімнаті"},
	{"33", "Джера", "Дублює усі розхідники в кімнаті"},
	{"34", "Еваз", "Створює люк на наступний поверх#8% шанс, що люк буде вести до {{LadderRoom}}Криївки"},
	{"35", "Даґаз", "{{SoulHeart}} +1 серце Душі#{{CurseCursed}} Знімає усі прокляття"},
	{"36", "Ансуз", "Відкриває карту поверху та типи кімнат"},
	{"37", "Пертро", "Реролить п'єдестальні предмети в кімнаті"},
	{"38", "Беркано", "Створює 3 синіх павуків та 3 синіх мух"},
	{"39", "Альґіз", "Ефект невразливості на 30 секунд"},
	{"40", "Порожня руна", "Triggers a random rune effect#25% chance to duplicate itself when used"},
	{"41", "Чорна руна", "Наносить 40 шкоди усім ворогам в кімнаті#Перетворює п'єдестальні предмети на випадкові покращення характеристик#Перетворює усі розхідники в кімнаті на синіх мух"},
	{"42", "Картка хаосу", "При використанні, персонаж метає картою в напрямку свого руху#Карта миттєво вбиває БУДЬ-ЯКОГО ворога (окрім Деліріума)"},
	{"43", "Кредитка", "Усі предмети та розхідники в {{Shop}} Магазині чи {{DevilRoom}} Кімнаті Диявола стають безкоштовними"},
	{"44", "Картка з правилами", "Відображає \"корисні\" поради"},
	{"45", "Картка проти людства", "Повністю заповнює кімнату купками лайна"},
	{"46", "Король-самогубець", "Миттєво вбиває персонажа та створює 10 розхідників чи предметів на підлозі"},
	{"47", "Картка \"Вийди з в'язниці\"", "Відкриває всі двері в поточній кімнаті"},
	{"48", "? Картка", "Безкоштовно застосовує активний предмет персонажа"},
	{"49", "Уламок кубика", "Реролить усі п'єдестальні предмети та розхідники в кімнаті"},
	{"50", "Аварійний виклик", "Дві Матусині Руки падають та хапають ворогів"},
	{"51", "Свята картка", "{{Collectible313}} Ефект щита {{HolyMantleSmall}} Святої Мантії на 1 кімнату#(Одноразовий захист від шкоди)#25% шанс створити ще одну Святу Картку"},
	{"52", "Гігантський ріст", "↑ {{Damage}} +7 Шкоду збільшено#↑ {{Range}} +30 Дальність збільшено#Дозволяє персонажу топтати камені та інші перешкоди на шляху#Розмір збільшено#{{Timer}} Ефект триває 1 кімнату"},
	{"53", "Виклик Древніх", "{{Card}} Створює 3 випадкові карти"},
	{"54", "Епохальна прогулянка", "{{Slow}} Сповільнює ворогів#↑ {{Speed}} +0.5 Швидкість збільшено#↓ {{Shotspeed}} -1 Швидкість Стрільби зменшено#{{Timer}} Ефект триває 1 кімнату"},
}

---------- Pills ----------
EID.descriptions[languageCode].unidentifiedPill = "Невідома пігулка"

EID.descriptions[languageCode].pills={
	{"0", "Кепський газ", "Персонаж пукає й отруює ворогів поблизу"},
	{"1", "Кепський прихід", "Наносить 1 серце шкоди персонажу#Перетворюється на Повне Здоров'я, якщо у персонажа 1 серце чи менше"},
	{"2", "Сталеві яйця", "{{SoulHeart}} +2 серця Душі"},
	{"3", "Бомби - це ключі", "Кількість ключів і бомб в інвентарі міняються місцями"},
	{"4", "Вибухова діарея", "Персонаж швидко створює 5 підпалених бомб"},
	{"5", "Повне Здоров'я", "Повністю відновлює червоне здоров'я"},
	{"6", "Здоров'я Знижено", "↓ {{Heart}} Забирає 1 контейнер червоних сердець#Перетворюється на Здоров'я Підвищено, якщо у персонажа 0 чи 1 контейнер"},
	{"7", "Здоров'я Підвищено", "↑ {{EmptyHeart}} +1 пустий контейнер червоних сердець"},
	{"8", "Я знайшов пігулки", "Без ефекту"},
	{"9", "Пубертат", "Без ефекту#Випийте 3 такі пігулки, щоб перетворитися на Дорослого (+1 повний контейнер червоних сердець)"},
	{"10", "Гарненька мушка", "1 муха-орбіталь"},
	{"11", "Знижена Дальність", "↓ {{Range}} -2 Дальність зменшено"}, -- Range
	{"12", "Підвищена Дальність", "↑ {{Range}} +2.5 Дальність збільшено"},
	{"13", "Знижена Швидкість", "↓ {{Speed}} -0.12 Швидкість зменшено"}, -- Speed
	{"14", "Підвищена Швидкість", "↑ {{Speed}} +0.15 Швидкість збільшено"},
	{"15", "Знижений Темп Стрільби", "↓ {{Tears}} -0.28 Темп Стрільби зменшено"}, -- Tears
	{"16", "Підвищений Темп Стрільби", "↑ {{Tears}} +0.35 Темп Стрільби збільшено"},
	{"17", "Знижена Удача", "↓ {{Luck}} -1 Удачу зменшено"}, -- Luck
	{"18", "Підвищена Удача", "↑ {{Luck}} +1 Удачу збільшено"},
	{"19", "Теле-пігулки", "Телепортує персонажа у випадкову кімнату#{{ErrorRoom}} Маленький шанс потрапити у Я - ПОМИЛКА"},
	{"20", "48 годин енергії!", "Повністю перезаряджає активний предмет#Створює 1-2 батарейки"},
	{"21", "Гематемезис", "Спустошує усі, крім одного, контейнери червоних сердець#Створює 1-4 Червоні серця"},
	{"22", "Параліч", "Персонаж не може рухатись та стріляти протягом 2 секунд"},
	{"23", "Я бачу Вічність!", "{{SecretRoom}} Відкриває всі проходи до секретних кімнат на поверсі"},
	{"24", "Феромони", "{{Charm}} Зачаровує всіх ворогів в кімнаті"},
	{"25", "Амнезія", "{{CurseLost}} Приховує карту поверху"},
	{"26", "Лимонна вечірка", "Створює велику калюжу, яка наносить ворогам контактну шкоду"},
	{"27", "Ти чарівник?", "Персонаж протягом 30 секунд стріляє діагонально"},
	{"28", "Знеболювальне!", "Зменшує всю шкоду до половинки серця за удар у поточній кімнаті"},
	{"29", "Залежність!", "Підвищує усю шкоду до повного серця за удар у поточній кімнаті"},
	{"30", "Роз-слабся", "Персонаж какає під себе протягом 2 секунд"},
	{"31", "???", "{{CurseMaze}} Прокляття Лабіринту для поточного поверху"},
	{"32", "Ця зробить тебе більшим", "Збільшує розмір персонажа#Не впливає на його хітбокс"},
	{"33", "Ця зробить тебе меншим", "Зменшує розміри персонажа#Також зменшує його хітбокс"},
	{"34", "Інфікований!", "Створює 1 синього павука за кожну купку лайна в кімнаті"},
	{"35", "Інфікований?", "Створює 1 синього павука за кожного ворога в кімнаті#Створює 1-3 павуків, якщо в кімнаті немає ворогів"},
	{"36", "Пігулка сили!", "Короткостроково робить персонажа невразливим#{{Fear}} Лякає усіх ворогів у кімнаті#Злякані вороги отримують 40 контактної шкоди в секунду#{{HalfHeart}} Поїдання 2 ворогів відновлює половинку червоного серця"},
	{"37", "Ретро-погляд", "Графіка стає піксельною тричі за 30 секунд"},
	{"38", "Друзі до кінця!", "Створює 3 сині мухи"},
	{"39", "Проносне", "Створює калюжу слизької рідини у вас під ногами"},
	{"40", "Щось не так...", "{{Slow}} Створює калюжу сповільнювальної рідини"},
	{"41", "Я сонний...", "{{Slow}} Сповільнює всіх ворогів у кімнаті"},
	{"42", "Я збуджений!!", "Прискорює всіх ворогів у кімнаті"},
	{"43", "Ковть!", "{{Trinket}} Персонаж ковтає свій брелок та отримує його ефект перманентно"},
	{"44", "Тьху!", "{{Collectible149}} Вистрілює однією сльозою Іпекаку"},
	{"45", "Відчуття, ніби крокую сонячним сяйвом!", "Тимчасово робить персонажа невразливим"},
	{"46", "Вурп!", "Створює останню пігулку, випиту перед Вурп!"},
}

---------- Sacrifice Room ----------
EID.descriptions[languageCode].sacrificeHeader = "[Наступна винагорода Кімнати Жертвопринесень]"

EID.descriptions[languageCode].sacrifice={
	{"1", "", "{{Coin}} 50% шанс на 1 монетку#{{Bomb}} 100% шанс на 1 бомбу, якщо ви на П1 і вбили боса менш ніж за 1 хвилину"}, -- П1 == B1
	{"2", "", "{{Coin}} 50% шанс на 1 монетку#{{Bomb}} 100% шанс на 1 бомбу, якщо ви на П1 і вбили боса менш ніж за 1 хвилину"}, -- п1 == b1
	{"3", "", "{{AngelChance}} 67% шанс збільшити ймовірність появи Кімнати Ангела"},
	{"4", "", "{{Chest}} 50% шанс на 1 випадкову скриню"},
	{"5", "", "{{Coin}} 33% шанс на 3 монетки#{{AngelChance}} 67% шанс збільшити ймовірність появи Кімнати Ангела"},
	{"6", "", "{{AngelRoom}} 33% шанс телепортуватися в Кімнату Ангела#{{DevilRoom}} Телепортує в Кімнату Диявола, якщо двері туди вже з'явилися на поточному поверсі#{{Chest}} 67% шанс на випадкову скриню"},
	{"7", "", "{{AngelRoom}} 33% шанс на 1 випадковий предмет з пулу Кімнати Ангела#{{SoulHeart}} 67% шанс на 1 серце Душі"},
	{"8", "", "100% шанс на 7 троль-бомб"},
	{"9", "", "100% шанс появи ангела \"Уріеля\""},
	{"10", "", "{{SoulHeart}} 50% шанс на 7 сердець Душі#{{Coin}} 50% шанс на 30 монет"},
	{"11", "", "100% шанс появи ангела \"Габріеля\""},
	{"12", "", "50% шанс телепортуватися на поверх \"Темна Кімната\""},
}

---------- Dice Room ----------
EID.descriptions[languageCode].diceHeader = "[Ефекти Кімнати Кубиків]"

EID.descriptions[languageCode].dice={
	{"1", "", "Реролить усі предмети персонажа на випадкові предмети з пулу кімнат, у яких вони були отримані"},
	{"2", "", "Реролить усі розхідники в кімнаті"},
	{"3", "", "Реролить усі розхідники та брелки на поверсі#Не впливає на кімнати {{DevilRoom}}Диявола чи {{AngelRoom}}Ангела"},
	{"4", "", "Реролить усі п'єдестальні артефакти на поверсі#Не впливає на кімнати {{DevilRoom}}Диявола чи {{AngelRoom}}Ангела"},
	{"5", "", "Реролить та перезапускає поточний поверх"},
	{"6", "", "Реролить усі предмети персонажа#Реролить усі розхідники, брелки та п'єдестальні предмети на поверсі"},
}

---------- Transformations ----------
EID.descriptions[languageCode].transformations={
	"",					-- 0 = none
	"Ґаппі",			-- 1
	"Веселий чувак",	-- 2
	"Вельзевул",		-- 3
	"З'єднаний",		-- 4
	"Обдовбаний",		-- 5
	"Так, Мамо?",		-- 6
	"От лайно..",		-- 7
	"Боб",				-- 8
	"Левіафан",			-- 9
	"Серафим",			-- 10
	"Супер-жебрак!",	-- 11
	"Книжковий черв'як",-- 12
	"Павуча дитинка",	-- 13
	"Дорослий",			-- 14
	"Топтань"			-- 15
}


---------- MISC ----------

EID.descriptions[languageCode].VoidText = "При поглинанні дає:"
-- {1} will become the number text (like "{1} Tears up" -> "+0.5 Tears up")
EID.descriptions[languageCode].VoidNames = {"{1} Швидкість збільшено", "{1} Темп Стрільби збільшено", "{1} Шкоду збільшено", "{1} Дальність збільшено", "{1} Швидкість Стрільби збільшено", "{1} Удачу збільшено"}

EID.descriptions[languageCode].CollectionPageInfo = "Цей предмет необхідно підняти для доповнення колекційної сторінки!"

EID.descriptions[languageCode].MCM = {
	DemoObjectName = "Приклад назви предмета",
	DemoObjectTransformation = "Приклад трансформації",
	DemoObjectText = "Це текст українською#Дуже крутий та довгий опис предмета для симуляції переходів на інший рядок, спричинених шириною текстового поля в EID!#{{Collectible4}} Це також крутий рядок#{{Heart}} Цей рядок любить тебе і Україну#{{AngelDevilChance}} Цей рядок може бути ще тим чортиком чи ангелом#\1 {{Damage}} +1 Характеристику збільшено",
}

EID.descriptions[languageCode].HoldMapTitle = "Нагадування"
-- the Hold Map description will predict the abilities of items with a header like "Item Name Result"
EID.descriptions[languageCode].HoldMapHeader = " Результат"

-- https://wofsauge.github.io/IsaacDocs/rep/enums/RoomType.html
-- Includes Repentance room types for localization convenience
EID.descriptions[languageCode].RoomTypeNames = { "Звичайна кімната", "Магазин", "Я - ПОМИЛКА", "Скарбниця", "Кімната Боса", "Кімната Міні-боса", "Секретна кімната", "Суперсекретна кімната", "Аркада", "Проклята кімната", "Кімната Виклику", "Бібліотека", "Кімната Жертвопринесень", "Кімната Диявола", "Кімната Ангела", "Криївка", "Кімната Бос Рашу", "Спальня", "Брудна Спальня", "Кімната-Скриня", "Кімната Кубиків", "Чорний Ринок", "Кімната Виходу", "Планетарій", "Вхід Телепортатора", "Вихід Телепортатора", "Люк Альтернативного Шляху", "Кімната Синього Ключа", "Ультра-секретна кімната",
-- Not technically room types but still potentially useful to have localized
[666] = "Кімната Ангела/Диявола", [1024] = "Червона кімната", [1025] = "Особлива Червона кімната" }

-- currently used for D1
EID.descriptions[languageCode].PickupNames = {
	["5.0"] = "Нічого",
	
	["5.10"] = "{{Heart}} Серце",
	["5.10.1"] = "{{Heart}} Серце", ["5.10.2"] = "{{HalfHeart}} Половинка серця", ["5.10.3"] = "{{SoulHeart}} Серце Душі", ["5.10.4"] = "{{EternalHeart}} Вічне серце", ["5.10.5"] = "{{Heart}} Подвійне серце", ["5.10.6"] = "{{BlackHeart}} Чорне серце", ["5.10.7"] = "{{GoldHeart}} Золоте серце", ["5.10.8"] = "{{HalfSoulHeart}} Половинка серця Душі", ["5.10.9"] = "{{Heart}} Злякане серце", ["5.10.10"] = "{{BlendedHeart}} Змішане серце", ["5.10.11"] = "{{EmptyBoneHeart}} Кісткове серце", ["5.10.12"] = "{{RottenHeart}} Гниле серце",
	
	["5.20"] = "{{Coin}} Монетка",
	["5.20.1"] = "{{Crafting8}} Пенні", ["5.20.2"] = "{{Crafting9}} Нікель", ["5.20.3"] = "{{Crafting10}} Дайм", ["5.20.4"] = "{{Crafting8}} Подвійний пенні", ["5.20.5"] = "{{Crafting11}} Щасливий пенні", ["5.20.6"] = "{{Crafting9}} Липкий нікель", ["5.20.7"] = "{{Crafting26}} Золотий пенні",
	
	["5.30"] = "{{Key}} Ключ",
	["5.30.1"] = "{{Crafting12}} Ключ", ["5.30.2"] = "{{Crafting13}} Золотий ключ", ["5.30.3"] = "{{Crafting12}} Кільце ключів", ["5.30.4"] = "{{Crafting14}} Заряджений ключ",
	
	["5.40"] = "{{Bomb}} Бомба",
	["5.40.1"] = "{{Crafting15}} Бомба", ["5.40.2"] = "{{Crafting15}} Подвійна бомба", ["5.40.3"] = "{{Crafting15}} Троль-бомба", ["5.40.4"] = "{{Crafting16}} Золота бомба", ["5.40.5"] = "{{Crafting15}} Мегатроль-бомба", ["5.40.7"] = "{{Crafting17}} Гіга-бомба",
	
	["5.90"] = "{{Battery}} Батарейка",
	["5.90.0"] = "{{Crafting19}} Мала батарейка", --AB+ didn't have subtypes for batteries
	["5.90.1"] = "{{Crafting19}} Мала батарейка", ["5.90.2"] = "{{Crafting18}} Мікро-батарейка", ["5.90.3"] = "{{Crafting20}} Мегабатарейка", ["5.90.4"] = "{{Crafting28}} Золота батарейка",
	
	["5.50"] = "{{Chest}} Скриня", ["5.51"] = "{{BombChest}} Кам'яна скриня", ["5.52"] = "{{SpikedChest}} Шипаста скриня", ["5.53"] = "{{EternalChest}} Вічна скриня", ["5.54"] = "{{MimicChest}} Скриня-мімік", ["5.55"] = "{{OldChest}} Стара скриня", ["5.56"] = "{{WoodenChest}} Дерев'яна скриня", ["5.57"] = "{{MegaChest}} Мегаскриня", ["5.58"] = "{{HauntedChest}} Скриня з привидами", ["5.60"] = "{{GoldenChest}} Золота скриня", ["5.360"] = "{{RedChest}} Червона скриня",  
	
	["5.69"] = "{{GrabBag}} Мішечок", ["5.69.1"] = "{{GrabBag}} Мішечок", ["5.69.2"] = "{{BlackSack}} Чорний мішечок",
	
	["5.70"] = "{{Pill}} Пігулка",
	["5.300"] = "{{Card}} Карта",
	["5.301"] = "{{Rune}} Руна", -- not a real id
	["5.350"] = "{{Trinket}} Брелок",

}
