---------------------------------------
-----  Basic Turkish descriptions  ----
---------------------------------------

-- FORMAT: Item ID | Name | Description

-- Special character markup:
-- ↑ = Up Arrow  |  ↓ = Down Arrow  |  ! = Warning  |  # = Starts a new line
-- More can be found here: https://github.com/wofsauge/External-Item-Descriptions/wiki/Markup

local languageCode = "tr_tr"

-- init tr_tr table
EID.descriptions[languageCode] = {}
EID.descriptions[languageCode].custom = {} -- table for custom entity descriptions
EID.descriptions[languageCode].languageName = "Turkish"

-- Fonts to be used with this language pack
EID.descriptions[languageCode].fonts = EID.descriptions["en_us"].fonts

---------- Collectibles ----------
EID.descriptions[languageCode].collectibles={
	{"1", "Üzgün Soğan", "↑ +0.7 Gözyaşı"},
	{"2", "Kalp Gözü", "Üçlü atış#↓ Gözyaşı azalır"},
	{"3", "Kaşık bükücü", "Takip eden gözyaşları"},
	{"4", "Mesutun Kafası", "↑ +0.5 Hasar#↑ +50% Hasar yüzdesi"},
	{"5", "My Reflection", "Gives tears a boomerang effect#↑ +1.5 Range up#↑ +0.6 Shot Speed up#↑ +1 Tear Height"},
	{"6", "Number One", "↑ +1.5 Tears up#↓ -17.62 Range down#↑ +0.76 Tear Height"},
	{"7", "Şehit Kanı", "↑ +1.0 Hasar#↑ +50% eğer Book of Belial kitabına sahip isen"},
	{"8", "Karhan Kardeş", "Normal gözyaşı arkadaşı#Gözyaşı başına 3.5 Hasar verir"},
	{"9", "Skatol", "Bütün sinek düşmanları artık arkadaş canlısı"},
	{"10", "Sinek Halesi", "+2 sinek yörüngeci#Düşman ateşini engeller"},
	{"11", "1Can!", "↑ +1 hayat#Full can ile tekrar doğarsın"},
	{"12", "Magic Mushroom", "↑ +1 Health up#↑ +0.3 Damage up#↑ +50% Damage Multiplier#↑ +5.25 Range up#↑ +0.3 Speed up#↑ +0.5 Tear Height#Full health!"},
	{"13", "The Virus", "Poison touch#↓ -0.1 Speed down#Enemies can drop black hearts if poisoned"},
	{"14", "Roid Rage", "↑ +0.6 Speed up#↑ +5.25 Range up#↑ +0.5 Tear Height"},
	{"15", "<3", "↑ +1 HP#Full can"},
	{"16", "Çiğ Ciğer", "↑ +2 Can#Full can"},
	{"17", "Maymuncuk", "+99 Anahtar"},
	{"18", "A Dollar", "+99 Coins"},
	{"19", "BOM!", "+10 Bomba"},
	{"20", "Kıyam Bi-Nefsihi", "Uçuş!"},
	{"21", "Pusula", "Haritadaki tüm ikonları açar#Odaların diziliş şeklini göstermez"},
	{"22", "Lunch", "↑ +1 Health up"},
	{"23", "Dinner", "↑ +1 Health up"},
	{"24", "Dessert", "↑ +1 Health up"},
	{"25", "Breakfast", "↑ +1 Health up"},
	{"26", "Rotten Meat", "↑ +1 Health up"},
	{"27", "Tahta Kaşık", "↑ +0.3 Hız"},
	{"28", "Kemer", "↑ +0.3 Hız"},
	{"29", "Mom's Underwear", "↑ +5.25 Range up#↑ +0.5 Tear Height"},
	{"30", "Mom's Heels", "↑ +5.25 Range up#↑ +0.5 Tear Height"},
	{"31", "Mom's Lipstick", "↑ +5.25 Range up#↑ +0.5 Tear Height"},
	{"32", "Metal Askılık", "↑ +0.7 Gözyaşı"},
	{"33", "İncil", "Oda için uçuş#Annenin ayağını ve annenin kalbi bosslarını anında öldürür#!!! Satanda kullanıldığında SENİ öldürür"},
	{"34", "İblisin Kitabi", "↑ +2 Hasar#↑ +12.5% Şeytan odası şansı#↑ Blood of the Martyr var ise +50% Hasar yüzdesi"},
	{"35", "Ölülerin Kitabı", "Odadaki her şeye 40 hasar verir"},
	{"36", "Bok", "Bir bok çıkartır#Deliğe yerleştirilip bomba ile köprü yapılabilir"},
	{"37", "Bomba Beyi", "Oyuncunun olduğu yere 100 hasar veren büyük bir bomba bırakır"},
	{"38", "Çileğin kafası", "Isaacin etrafında halka şeklinde 10 gözyaşı atar"},
	{"39", "Annenin sütyeni", "Odadaki tüm düşmanları 4 saniyeliğine dondurur"},
	{"40", "Kamikaze!", "Causes an explosion at the players location#Deals 40 damage"},
	{"41", "Annenin Pedi", "Odadaki tüm düşmanları 5 saniyeliğine korkutur"},
	{"42", "Amca Beyin Çürük Kafası", "Throwable poison bomb"},
	{"43", "", "<item does not exist>"},
	{"44", "Teleport!", "Teleports Isaac into a random room except I AM ERROR rooms"},
	{"45", "Yum Heart", "Heal 1 red heart"},
	{"46", "Lucky Foot", "↑ +1.0 Luck up#Better chance to win while gambling#Increases room clearing drop chance"},
	{"47", "Doktorun Kumandası", "Kullanılabilir Epic Fetus!#Kontrol edilebilir hava saldırısı"},
	{"48", "Aşk oku", "Delici gözyaşları"},
	{"49", "Shoop da Whoop!", "Yüksek hasarlı brimstone lazeri"},
	{"50", "Mesut", "↑ +1 Hasar"},
	{"51", "Pentagram", "↑ +1.0 Hasar#↑ +10% Şeytan odası şansı"},
	{"52", "Dr. Fetüs", "Bomba gözyaşları!"},
	{"53", "Magneto", "Magnetic attraction for Pick-ups"},
	{"54", "Hazine Haritası", "Odaların diziliş şeklini açar"},
	{"55", "Mom's Eye", "Chance to shoot a tear backwards#Chance is 100% at 2 Luck"},
	{"56", "Limon Talihsizliği", "Limonata havuzu bırakır#Saniyede 66 dokunma hasarı verir"},
	{"57", "Uzaktan Beğenme", "Orta-menzil sinek yörüngeci#Saniyede 75 dokunma hasarı verir"},
	{"58", "Gölgelerin Kitabi", "10 Saniyeliğine dokunulmazlık"},
	{"59", "", "<item does not exist>"},
	{"60", "Merdiven", "Küçük boşluklar üzerinde yürü"},
	{"61", "", "<item does not exist>"},
	{"62", "Charm of the Vampire", "Heals half a heart every 13 enemies killed"},
	{"63", "Pil", "Aktif itemler artık iki defa şarj edilebilir"},
	{"64", "Steam İndirimi", "-50% on shop items#Getting this item two times will make everything free"},
	{"65", "Anarşinin Tarif Kitabı", "Odanın ortasına yakın 6 troll bombası çıkartır"},
	{"66", "Kum Saati", "8 Saniyeliğine düşmanları yavaşlatır"},
	{"67", "Kader Kardeş", "Normal tear familiar#Deals 3.5 Damage per tear"},
	{"68", "Teknoloji", "Gözyaşları artık lazer"},
	{"69", "Çıkolatalı süt", "Şarj edilebilir gözyaşları#↑ 400%e kadar hasar#↓ Gözyaşı azalır"},
	{"70", "Growth Hormones", "↑ +1.0 Damage up#↑ +0.4 Speed up"},
	{"71", "Mini Mantar", "↑ +0.3 Speed up#↓ -4.25 Range down*#↑ +1.5 Tear height*#(*both add up to a slight Range up)#↑ Size down"},
	{"72", "Tespih", "+3 Soul Hearts#Bible is more common"},
	{"73", "Et Kübü", "LVL1: Yörüngeç#LVL2: Ateş eden yörüngeç#LVL3: Meat boy LVL 1#LVL4: Meat boy LVL 2"},
	{"74", "25 Kuruş", "+25 Altın"},
	{"75", "TUS", "Daha iyi haplar# +1 hap#2 Kalp iyileştirir#Kan başığı makinalarından daha fazla para"},
	{"76", "X-Ray Gçrüşü", "Gizli oda girişlerini gösterir"},
	{"77", "Benim Küçük Unicornum", "Invincibility#40 contact damage"},
	{"78", "Devirlerin Kitabı", "+1 Ruh kalbi#Kullanılırsa daha yüksek atlı şansı#↑ +17.5% Şeytan odası şansı"},
	{"79", "İşsaret", "↑ +1.0 Damage up#↑ +0.2 Speed up#+1 Soul Heart"},
	{"80", "Antlaşma", "↑ +0.5 Damage up#↑ +0.7 Tears up#+2 Soul Hearts"},
	{"81", "Ölü Kedi", "↑ +9 Hayat#1 Kalp ile tekrar doğarsın#↓ Kırmızı kalp sayını 1e indirir"},
	{"82", "Çukurun lordu", "Uçuş#↑ +0.3 Hız"},
	{"83", "The Nail", "+1 Soul heart#↑ +0.7 Damage up#↓ -0.18 Speed down#Deal contact Damage#Crush rocks"},
	{"84", "Daha Derine İnmeliyiz!", "Katı geçmek için bir tuzak kapısı yaratır#10% şans ile sürünme alanı tuzak kapısı şansı"},
	{"85", "Kart Destesi", "1 Kart çıkartır"},
	{"86", "Monstro'nun dişi", "1 vuruş için Monstro çıkartır"},
	{"87", "Loki'nin Boynuzları", "4 Yönde de ateş etme şansı"},
	{"88", "Küçük Chubby", "Öne atılan arkadaş#Saniyede 52.5 dokunma hasarı verir"},
	{"89", "Örümcek ısırığı", "Yavaşlatma gözyaşı atma şansı"},
	{"90", "Küçük Taş", "↑ +1 Hasar#↑ +0.2 Gözyaşı#↓ -0.2 Hız eksilir"},
	{"91", "Madenci Şapkası", "Bitişik odaların tiplerini gösterir#Gizli odaları, Süper gizli odaları ve MiniBoss odalarını da göstereblir"},
	{"92", "Süper Yara Bandı", "↑ +1 HP#+2 Ruh Kalbi"},
	{"93", "Atari Çocuğu", "Dokunulmazlık + dokunma hasarı#Düşmanı yemek canı iyileştirir"},
	{"94", "Kuruş Kesesi", "Her 2 odada rastgele bir altın düşürür"},
	{"95", "Robo-Bebek", "Lazer gözyaşları#Atış başına 3.5 hasar verir"},
	{"96", "Küçük C.H.A.D.", "Her 3 odada yarım kırmızı kalp düşürür"},
	{"97", "Günah Kitabı", "Rastgele bir pickup çıkartır"},
	{"98", "Kalıntı", "Spawns 1 Soul heart every 5-6 rooms"},
	{"99", "Küçük Gish", "Yavaşlatan gözyaşları#Atış başına 3.5 hasar verir"},
	{"100", "Küçük Mesut", "Takip eden gözyaşları#Atış başına 3.5 hasar verir"},
	{"101", "Hale", "↑ +1 Health up#↑ +0.3 Damage up#↑ +0.2 Tears up#↑ +0.25 Range up#↑ +0.3 Speed up#↑ +0.5 Tear Height"},
	{"102", "Annenin Hap Kutusu", "1 Hap çıkartır"},
	{"103", "Grip", "Zehir gözyaşları atma şansı"},
	{"104", "Parazit", "Temas ettiğinde gözyaşları ikiye bölünür#Bölünen gözyaşları yarım hasar verir"},
	{"105", "D6", "Odadaki itemleri değiştirir"},
	{"106", "Bay Mega", "↑ Bomb damage x2.25#+5 Bombs"},
	{"107", "Oyma Makası", "Uçuş#Vücudun saniyede 82.5 hasar ile düşmanlara saldırır"},
	{"108", "Mühür", "Alınan tüm hasarı yarım kalbe indirir"},
	{"109", "Para = Güç", "Eldeki her altın için ↑ +0.04 Hasar"},
	{"110", "Mom's Contacts", "Chance to shoot Freezing Tears#↑ +0.25 Range up#↑ +0.5 Tear Height"},
	{"111", "Fasülye", "Zehir osuruğu"},
	{"112", "Koruyucu Melek", "Yörüngeç#Tüm yörüngeçleri hızlandırır#Düşman ateşlerini bloklar#Saniyede 105 dokunma hasarı verir"},
	{"113", "Şeytan Bebek", "Otomatik ateş eden arkadaş#Atış başına 3 hasar verir"},
	{"114", "Annenin Bıçağı", "Kontrol edilebilir bıçak atağı#Bıçak elde iken Isaacin 2x hasarını verir ve en uzağa atıldığında 6x hasar verir"},
	{"115", "Ouija tahtası", "Hayalet gözyaşları"},
	{"116", "9 Volt", "Aktif itemler için -1 Şarj#Eldeki itemi tamamen şarj eder"},
	{"117", "Ölü Kuş", "Hasar aldığında kuş çıkartır#Kuş saniyede 4 dokunma hasarı verir"},
	{"118", "Brimstone", "Şarj edip sürekli hasar veren bir kan lazeri atar"},
	{"119", "Kan Torbası", "↑ +1 HP#↑ +0.3 Hız#5 Kalp iyileştirir"},
	{"120", "Garip Mantar", "↑ +1.7 Gözyaşı#↑ +0.3 Hız#↓ -10% Hasar düşer#↓ -0.4 Ekstra hasar düşer"},
	{"121", "Garip Mantar", "↑ +1 Boş kalp konteynırı#↑ +0.3 Hasar#↑ +0.25 Menzil#↓ -0.1 Hız azalır#↑ +0.5 Gözyaşı yüksekliği"},
	{"122", "Babylon Orospusu", "!!! Yarım kırmızı kalpte beya daha azında iken:#↑ +1.5 Hasar#↑ +0.3 Hız"},
	{"123", "Canavar El Kitabı", "Random familiar for current room"},
	{"124", "Ölüdeniz parşömenleri", "Rastgele aktif item efekti"},
	{"125", "Bilal-Bomba", "Takip eden bombalar#+5 Bomba"},
	{"126", "Jilet", "Oda için ↑ +1.2 hasar#↓ Sana 1 Kalp hasarı verir"},
	{"127", "Beni Unut", "{{Warning}} TEK KULLANIM {{Warning}}#Tüm katı baştan değiştir"},
	{"128", "Sonsuza dek yanlız", "Sinek yörüngeci#Uzakta#Saniyede 30 dokunma hasarı verir"},
	{"129", "Domuz Yağı Kovası", "↑ +2 Boş kalp konteynırı#↓ -0.2 Hız düşer#Yarım kalp iyileştirir"},
	{"130", "Midilli", "Elde ike uçuş sağlar#Hızın 1.5tan düşük ise hızını 1.5 yapar#Kullanıldığında bir yönde hızla ilerler"},
	{"131", "Bomba Kesesi", "Her 2-3 odada 1 Bomba pickupı düşürür"},
	{"132", "Kömür Parçası", "Gözyaşının gittiği mesafeye göre daha çok hasar verir"},
	{"133", "Şerbet'in Patisi", "!!! Çevir:#1 Kırmızı kalp to 3 Ruh kalbi"},
	{"134", "Şerbet'in Kuyruğu", "Daha fazla kasa çıkar"},
	{"135", "Kan Poşedi", "Portatif kan bankası#Yarım kalp = 1-3 Altın"},
	{"136", "En İyi Arkadaş", "Patlayan bir yanıltıcı#Düşmanları üzerine çeker"},
	{"137", "Kablosuz Fitil", "Bombaları istediğinde patlat#+5 bomba"},
	{"138", "Namus Lekesi", "↑ +1 Health up#↑ +0.3 Damage up"},
	{"139", "Mom's Purse", "You can now hold 2 trinkets"},
	{"140", "Bob's Curse", "Poison bombs#+5 bombs"},
	{"141", "Gösteri Çocuğu", "7 Rastgele altın düşürür"},
	{"142", "Skapular", "Yarım kalbe kadar indiğinde, 1 Ruh kalbi kazanırsın#(Odada 1 kere)"},
	{"143", "Hız topu", "↑ +0.3 Hız#↑ +0.2 Gözyaşı hızı"},
	{"144", "Evsiz Arkadaş", "Altınları pickuplara çevirir"},
	{"145", "Şerbet'in Kafası", "2-4 mavi sinek çıkartır"},
	{"146", "Dua Kartı", "+1 ebedi kalp"},
	{"147", "Hanonun Baltası", "Break rocks in current room on touch"},
	{"148", "Enfeksiyon", "Spawn flies when you get hit"},
	{"149", "Ipecac", "Explosive poison tears#↑ +40 Damage up#↓ Tears down"},
	{"150", "Sert Aşk", "Diş atma şansı#Dişler hasarının 3.2x katını verir"},
	{"151", "Güveç", "Düşmanlara gözyaşı vurunca 1/6 şans ile sinek çıkartır"},
	{"152", "Technology 2", "Permanent laser attack!#↓ -35% Damage down"},
	{"153", "Mutant Örümcek", "Dörtlü atış!#↓ Gözyaşı azalır"},
	{"154", "Kimyasal Soyulma", "Sol göz için ↑ +2 Hasar"},
	{"155", "Kapı Deliği", "Odada gezer#Saniyede 17.1 hasar verir"},
	{"156", "Alışkanlık", "Hasar alınca +1 şarj"},
	{"157", "Kanlı Tutku", "Her hasar aldığında ↑ Hasar artar #Kat başına 6 defaya kadar#Kat boyunca sürer"},
	{"158", "Crystal Ball", "Reveal full map#Drops random Card or soul heart"},
	{"159", "Gecenin Ruhu", "Uçuş#Hayalet gözyaşları"},
	{"160", "Göğü Çatlat", "Düşmanların yakınında 5 Işık hüzmesi çıkartır#Senin hasarın +20 verir"},
	{"161", "Ankh", "Ölünce ??? (Blue Baby) olarak tekrar doğarsın"},
	{"162", "Kelt Haçı", "Hasar alınca dokunulmazlık şansı"},
	{"163", "Hayalet Bebek", "Hayalet gözyaşı arkadaşı#Atış başına 3.5 hasar verir"},
	{"164", "Mum", "Mavi ateş çıkartır#Dokunma hasarı verir#Düşman gözyaşlarını bloklar#2 Saniye sonra yok olur"},
	{"165", "9-canlı-kedi", "↑ +1 Hasar#↑ +0.23 Gözyaşı hızı"},
	{"166", "D20", "Bütün pickupları değiştir"},
	{"167", "Soytarı Bebek", "V şeklinde iki gözyaşı atar#Atış başına 4 hasar verir"},
	{"168", "Epik Fetüş", "Gözyaşları yerine kontrol edilebilir hava saldırısı#Hasarının 20 katını verir"},
	{"169", "Polyphemus", "Mega Gözyaşları!#↑ +100% Hasar#↑ +4 ekstra hasar#↓ Gözyaşı azalır"},
	{"170", "Uzun Bacaklı Örümcek", "Düşmanların üstüne basar#Saniyede 40 hasar verir"},
	{"171", "Spider Butt", "Slows down enemies for 4 seconds#10 Damage to all enemies"},
	{"172", "Kurban Hançeri", "Yörüngeç bıçağı#Düşman gözyaşlarını bloklar#Saniyede 225 hasar verir"},
	{"173", "Gönye", "Ruh kalbi bulma şansını arttırır"},
	{"174", "Gökkuşağı Bebek", "Rastgele gözyaşı atar#Atış başına 3-5 hasar verir"},
	{"175", "Dad's Key", "Opens all doors in the current room, including secret rooms"},
	{"176", "Stem Cells", "↑ +1 Health up#↑ +0.16 Shot Speed up"},
	{"177", "Portatif Slot", "Portatif slot makinesi"},
	{"178", "Holy Water", "Leaves pool of creep when you get hit#Deals 24 damage per second"},
	{"179", "Kader", "Uçuş#+1 ebedi kalp"},
	{"180", "Siyah Fasülye", "Dokunulduğunda osurursun"},
	{"181", "Beyaz Midilli", "Elde iken uçuş sağlar#Hızın 1.5den küçük ise 1.5 Hız verir#Kullanıldığında kutsal ve hızlı hareket eder"},
	{"182", "Kutsal Kalp", "Homing tears#↑ +1 Health up#↑ 230% + 1 Damage up#↓ -0.4 Tears down#↓ -0.25 Shot Speed down#↑ +4.125 Range up"},
	{"183", "Kürdanlar", "↑ +0.7 Gözyaşı#↑ +0.16 Gözyaşı hızı"},
	{"184", "Holy Grail", "Grants flight#↑ +1 Health up"},
	{"185", "Ölü Güvercin", "Uçus#Hayalet gözyaşları"},
	{"186", "Kan Hakları", "Her düşmana 40 Hasar verir#Kullandımda sana 1 hasar verir"},
	{"187", "Şerbet'in Tüytopu", "Büyüyen kıl yumağı#Etrafında salınır#Düşman öldürdüğünde büyür#Büyük yumak daha fazla hasar verir"},
	{"188", "Abel", "Mirrors your movement#Shoots towards the player#Deals 3.5 damage per shot"},
	{"189", "SMB Süper Fan", "↑ +1 HP#↑ +0.3 Hasar#↑ +0.2 Gözyaşı#↑ +0.5 Menzil#↑ +0.2 Hız#↑ +1.0 Gözyaşı yüksekliği#Full can"},
	{"190", "Kundak", "+99 Bomba"},
	{"191", "3 Dolarlık Banknot", "Her 2-3 saniyede bir rastgele gözyaşı efekti"},
	{"192", "Aptallar İçin Telepati", "Homing tears for current room"},
	{"193", "ET!", "↑ +1 Health up#↑ +0.3 Damage up"},
	{"194", "Sihirli Top", "↑ +0.16 Shot speed up#+1 card"},
	{"195", "Annenin Cüzdanı", "4 Hap çıkartır"},
	{"196", "Sıkmaca", "2 Ruh kalbi çıkartır#↑ +0.4 Gözyaşı"},
	{"197", "İsa Suyu", "↑ +0.5 Damage up#↑ +0.25 Range up.#↑ +0.5 Tear Height"},
	{"198", "Koli", "Her tipten 1 pickup düşürür"},
	{"199", "Annenin Anahtarı", "+2 Anahtar#Kasalardan daha fazla şey düşer"},
	{"200", "Annenin Göz Farı", "Aşık eden gözyaşı atma şansı"},
	{"201", "Demir Külçesi", "↑ +0.3 Hasar#Afallatan gözyaşı atma şansı"},
	{"202", "Midas'ın Dokunuşu", "Dokunduğun düşmanları altına çevir#Elindeki altın sayısına göre dokunma hasarı verir#Altın düşmanlar altın düşürür"},
	{"203", "Humbleing Bundle", "Doubles all pickups"},
	{"204", "Bel Çantası", "Hasar aldığında 50% ihtimal ile rastgele pickup düşürür"},
	{"205", "Keskin Priz", "-2 Hearts = Fully charges item when pressing space#!!! Only works when item has no charges!"},
	{"206", "Giyotin", "↑ +1 Damage up#↑ Tears up#Your Head is now an orbital#You will shoot from the head#The head deals 105 contact damage"},
	{"207", "Yara Bandı Topu", "LVL1: Yörüngeç#LVL2: Ateş eden yörüngeç#LVL3: Bandage girl#LVL4: Bandage girl LVL2"},
	{"208", "Şampiyonluk Keneri", "↑ +1 Hasar#!!! Şampiyon düşmanlar daha fazla çıkar"},
	{"209", "Göt Bombası", "↑ +5 Bomba#Patlamalar odadaki düşmanları afallatır ve hasar verir"},
	{"210", "Çiğnenmiş Yaprak", "1 saniye sabit durduğunda dokunulmazlık"},
	{"211", "Örümcek Bebek", "Spawn 1-2 spiders when getting hit"},
	{"212", "Şerbet'in Boyunluğu", "↑ 50% tekrar doğma şansı"},
	{"213", "Kayıp Temas", "Korumalı gözyaşları#Gözyaşları düşman ateşlerini bloklar#↓ -0.16 Gözyaşı hızı azalır"},
	{"214", "Anemik", "↑ +5 Range up#Leave creep on floor when getting hit"},
	{"215", "Keçi Kafası", "Şeytan {{DevilRoom}}/ Melek{{AngelRoom}} odası şansı ↑ 100%"},
	{"216", "Seremoni Cübbesi", "↑ +1 Hasar#+3 Siyah kalp"},
	{"217", "Annenin Peruğu", "Ateş ederken mavi örümcek çıkarma şansı#Alındığında 1 kalp iyileştirir"},
	{"218", "Plesenta", "↑ +1 HP#Yavaşça canını doldurur"},
	{"219", "Eski Yara Bandı", "↑ +1 Boş kalp konteynırı#Hasar alındığında kırmızı kalp çıkarma şansı"},
	{"220", "Üzgün Bombalar", "Gözyaşı patlaması!#+5 Bomba"},
	{"221", "Lastik Çimento", "Bouncing tears"},
	{"222", "Anti-Yerçekimi", "↑ +2 Gözyaşı#Anti-Yerçekimi gözyaşları"},
	{"223", "Kundakçı", "Patlamalar seni iyileştirir#+5 Bomba"},
	{"224", "Cricket's Body", "↑ +1 Tears up#↓ -10 Range down#Tears split up in 4 on hit#Splitted tears deal half damage"},
	{"225", "SadoMazo", "Hasar alınca Ruh/Siyah kalp çıkarma şansı#Düşman öldürürken yarım kırmızı kalp çıkarma şansı"},
	{"226", "Siyah Lotus", "↑ +1 HP#+1 Ruh kalbi#+1 Siyah kalp"},
	{"227", "Kumbara", "+3 Altın#Hasar aldığında 1-2 altın çıkartır#Keeper için 0-1"},
	{"228", "Mom's Perfume", "Chance to shoot fearing tears#↑ +1 Tears up"},
	{"229", "Monstro'nun Ciğeri", "Gözyaşları artık şarj edilip pompalı türek tarzında ateş edilebilir"},
	{"230", "Abaddon", "↑ +1.5 Damage up#↑ +0.2 Speed up#Fear tears#↓ Removes all red hearts#+6 Black hearts"},
	{"231", "Asfalt Topu", "Yavaşlatma gözyaşı atma şansı#Yavaşlatan havuz sıvısı bırakır"},
	{"232", "Stop Watch", "Permanent slow effect#(activated when getting hit)#↑ +0.3 Speed up"},
	{"233", "Küçük Gezegen", "Gözyaşları etrafında yörünge yapar#↑ +7.0 Gözyaşı yüksekliği#Hayalet gözyaşı"},
	{"234", "Enfeksiyon 2", "Düşman öldürdüğünde mavi örümcek çıkartır"},
	{"235", "", "<item does not exist>"},
	{"236", "E. Coli", "Dokunulduğunda düşmanı boka çevirir"},
	{"237", "Ölümün Dokunuşu", "Orak gözyaşları!#↑ +1.5 Hasar#↓ -0.3 Gözyaşı azalır#Delici gözyaşları"},
	{"238", "Anahtar Parçası 1", "!!! Mega Satan odası için anahtar parçası!#Daha fazla Melek odası {{AngelRoom}} çıkar"},
	{"239", "Anahtar Parçası 2", "!!! Mega Satan odası için anahtar parçası!#Daha fazla Melek odası {{AngelRoom}} çıkar"},
	{"240", "Experimental Treatment", "All Stats ↑/↓ a random number"},
	{"241", "Alttan Gelen Antlaşma", "Düşen pickupları iki katına çıkartır#Greed modunda işe yaramaz"},
	{"242", "Alçaklık", "50% şans ile düşman ateşini bloklar"},
	{"243", "Kutsal Üçlü Kalkanı", "Gözyaşı bloklayan kalkan"},
	{"244", "Tekn.5", "Rastgele lazer tipi gözyaşları at"},
	{"245", "20/20", "Doubles all your shots"},
	{"246", "Mavi Harita", "Gizli odaları gösterir"},
	{"247", "KANKALAR!", "Your familiars deal double damage"},
	{"248", "Sürü Aklı", "Blue Spiders/flies deal double damage"},
	{"249", "Seçenekler Var", "1 yerine 2 Boss itemi çıkar#!!! Sadece biri seçilebilir"},
	{"250", "BOGO Bombaları", "Bütün düşen bombaları iki katına çıkart"},
	{"251", "Başlangıç Destesi", "2 Kart taşıyabilirsin#Bütün hapları karta çevirir"},
	{"252", "Minik Çanta", "2 Hap taşıyabilirsin#Bütün kartları hapa çevirir"},
	{"253", "Magic Scab", "↑ +1 Luck up#↑ +1 Health up"},
	{"254", "Blood Clot", "↑ +1 Damage up#↑ +5 Range up#!!! Applies only for the left eye"},
	{"255", "Vida", "↑ +0.5 Gözyaşı#↑ +0.2 Gözyaşı hızı"},
	{"256", "Sıcak Bombalar", "Burning bombs#+5 Bombs"},
	{"257", "Ateş Aklı", "Patlayan gözyaşı şansı#Gözyaşları düşmanları yakar"},
	{"258", "Kayıp No.", "Aldığında bütün itemlerini ve özelliklerini değiştirir, kat değişiminde de aynı efekti verir"},
	{"259", "Kara Madde", "↑ +1 Hasar#Korku gözyaşları atma şansı"},
	{"260", "Siyah Mum", "Lanetlere bağışıklık#+1 Siyah kalp#Daha yüksek Şeytan{{DevilRoom}} / Melek{{AngelRoom}} odası şansı"},
	{"261", "Proptosis", "↑ +100% Damage up#↓ Dealt damage decreases for traveled distance of the tear"},
	{"262", "Kayıp Sayfa 2", "+1 black heart#When down to 1 Heart, damages all enemies in the room"},
	{"263", "", "<item does not exist>"},
	{"264", "Akıllı Sinek", "Yörüngeç#Hasar aldığında düşmanlara saldırır#Saniyede 22.5 hasar verir"},
	{"265", "Kuru Bebek", "Düşman tarafından vurulduğunda, 10% şans ile tüm düşmanlara hasar verme şansı#Arkasına saklanılabilir"},
	{"266", "Sulu Kese", "Yavaşlatan sıvı bırakır#Oda temizlendiğinde 1-2 mavi örümcek çıkartır"},
	{"267", "Robo-Bebek 2.0", "Lazer atar#Atış başına 3.5 hasar verir#Ateş ettiğin yönde hareket eder"},
	{"268", "Çürük Bebek", "Oyuncu ateş ederken mavi sinekler çıkartır"},
	{"269", "Kafasız Bebek", "Saniyede 6 hasar veren bir sıvı bırakır"},
	{"270", "Sülük", "Düşman öldürdüğünde yarım siyah kalp verir#Saniyede 3.2 hasar"},
	{"271", "Gizemli Kese", "Bir kaç odada bir rastgele pickup düşürür"},
	{"272", "Büyük Zenci S.inek", "Patlayan sinek arkadaşı#Patlama 60 hasar verir"},
	{"273", "Amca Beyin Beyni", "Throwable bomb familiar#The explosion deals 60 Damage"},
	{"274", "Best Bud", "When getting hit, gain one midrange orbital#Orbital deals 75 damage per second"},
	{"275", "Lil Brimstone", "Shoots a brimstone laser#Shot deals 31.5 damage per second"},
	{"276", "Isaac's Heart", "Gain an invulnerable body#!!! When the heart familiar gets hit you take damage"},
	{"277", "Küçük Haunt", "Hayalet arkadaşı#Saniyede 4 hasar verir"},
	{"278", "Kara Evsiz", "!!! Converts:#1,5 Red hearts into 1 soul heart or a spider"},
	{"279", "Büyük Takipçi", "Büyük şişko martha yörüngeci#Saniyede 30 hasar verir"},
	{"280", "Kardeş Uzun Örümcek", "Randomly spawns blue spiders when in a hostile room"},
	{"281", "Boks Torbası", "Yanıltıcı arkadaş#Düşmanlar artık onu hedefler"},
	{"282", "Nasıl Zıplanır", "Zıplamanı sağlar"},
	{"283", "D100", "Reroll all pickups, pedestals and all your held passive items"},
	{"284", "D4", "Eldeki bütün pasif itemlerini değiştirir"},
	{"285", "D10", "Reroll all enemies in the room"},
	{"286", "Boş Kart", "Eldeki kartının efektini kopyalar"},
	{"287", "Book of Secrets", "Reveals parts of the map"},
	{"288", "Box of Spiders", "Spawn 1-4 blue spiders"},
	{"289", "Red Candle", "Throw red fire#The flame persists until it delt damage 5 times"},
	{"290", "Kavanoz", "Sonra kullanmak üzere 4 kırmızı kalbe kadar içinde saklar"},
	{"291", "Flush!", "!!! Insta kills Poop enemies & bosses!#Turns enemies into poop"},
	{"292", "Satanic Bible", "+1 Black heart"},
	{"293", "Krampusun Kafası", "4 yönde birden brimstone lazeri atar"},
	{"294", "Butter Bean", "Knocks back nearby enemies and projectiles#10% chance to turn into the stronger \"Wait What?\" when swapping it with a different active item and picking it up again"},
	{"295", "Magic Fingers", "Damages the whole room with 2x the player damage#Price: 1 coin"},
	{"296", "Converter", "!!! Convert:#2 Soul/Black hearts into 1 red heart"},
	{"297", "Pandora's Box", "!!! SINGLE USE !#!!! Drops things based on floor its activated on:#B1: 2 Soul Hearts#B2: 2 keys and bombs#C1: 1 Boss item#C2: B1+C1#D1: 4 Soul hearts#D2: 20 Coins#W1: 2 Boss items#W2: Bible#Sheol: 1 Devil item + Black heart#Cat: 1 Angel item + Soul heart#Chest: 1 Coin"},
	{"298", "Unicorn Ayağı", "6 Saniye boyunca dokunulmazlık ve +0.28 hız"},
	{"299", "Boğa", "Düşman olan odalarda hızlan!#Yeterince hızlı iken dokunulmazlık#↓ -0.3 Hız eksilir"},
	{"300", "Koç", "↑ +0.25 Speed up#Touching enemies hurts them"},
	{"301", "Yengeç", "+3 Soul hearts#Halves taken damage in room when you already got hit"},
	{"302", "Aslan", "Destroy rocks when walking over them"},
	{"303", "Başak", "Chance to get invincibility when hit#Converts negative pills into positive ones"},
	{"304", "Terazi", "+6 Coins / Keys / Bombs#Balances your stats!#!!! Every stats up afterwards will affect other stats too"},
	{"305", "Akrep", "Poison tears"},
	{"306", "Yay", "↑ +0.2 Hız#Delici gözyaşları"},
	{"307", "Oğlak", "↑ +1 Health / Key / Bomb / Coin#↑ +0.5 Damage up#↑ +0.1 Speed up#↑ +1.5 Range up#Tears up"},
	{"308", "Kova", "Leave trail of creep#Creep deals 6 damage per second"},
	{"309", "Balık", "↑ Gözyaşı artar#İttiren gözyaşları"},
	{"310", "Annenin Rimeli", "↑ +100% Hasar#↓ Gözyaşı azalır#↓ -0.5 Gözyaşı hızı azalır"},
	{"311", "Judas'ın Gölgesi", "Öldüğünde, Kara Judas olarak geri dön#↑ (Hasar x 2)"},
	{"312", "Maggy'nin Yayı", "↑ +1 HP#Tüm kırmızı kalpler artık değerinin iki katı iyileştirir"},
	{"313", "Kutsal Pelerin", "Her odada ilk alınan hasarı görmezden gelir"},
	{"314", "Thunder Thighs", "↑ +1 Health up#↓ -0.4 Speed down#Destroy rocks when walking over them"},
	{"315", "Strange Attractor", "Magnetic tears#Affects enemies, pickups and trinkets"},
	{"316", "Lanteli Göz", "Şarj edilen göz yaşı dalgası#Şarj ederken hasar alınırsa, rastgele bir odaya ışınlar"},
	{"317", "Gizemli Sıvı", "Gözyaşları sıvı bırakır#Sıvı saniyede 30 hasar verir"},
	{"318", "İkizler", "Yakın dövüş arkadaşı#Saniyede 6 dokunma hasarı verir"},
	{"319", "Cain'in Diğer Gözü", "Odada gezer#Isaace doğru ateş eder#Verdiği hasar senin hasarına eşit olur"},
	{"320", "???'s Only Friend", "Controllable Fly#Deals 5 contact damage per second"},
	{"321", "Samson's Chains", "Draggable ball that can destroy rocks#Deals 10.7 contact damage per second"},
	{"322", "Mongo Baby", "Copies the effect of one of your familiars#Deals double its damage"},
	{"323", "Isaac's Tears", "Shoot 8 tears in all directions when used#Charges when shooting"},
	{"324", "Undefined", "Teleports you to:#{{SecretRoom}}{{SuperSecretRoom}}Secret-, Error- or {{TreasureRoom}}Item-rooms"},
	{"325", "Makas", "Kafanı kes#Kafa sabit bir arkadaşa dönüşür#Vücudunu ayrı kontrol et"},
	{"326", "Breath of Life", "Hold down space till chargebar is empty for invincibility#!!! Don't hold it for too long!"},
	{"327", "Polaroid", "Yarım kırmızı kalp veya daha altında hasar aldığında dokunulmazlık"},
	{"328", "Negatif", "Damages all enemies in the room when getting hit and at half a red heart or none"},
	{"329", "Ludovico Tekniği", "Kontrol edilebilen gözyaşı"},
	{"330", "Soya Sütü", "↑ Very high Tears up: (delay /4) - 2#↓ -80% Damage down"},
	{"331", "Godhead", "Homing tears#↑ +0.5 Damage up#↑ +1.2 Range up#↓ -0.3 Tears down#↓ -30% Shot Speed down#↑ +0.8 Tear Height#Tears gain a damaging aura"},
	{"332", "Lazarus'un Bezleri", "Öldüğünde Lazarus (Risen) olarak geri dön"},
	{"333", "Akıl", "Tüm haritayı açar"},
	{"334", "Vücut", "↑ +3 HP"},
	{"335", "Ruh", "+2 Ruh Kalbi#Düşmanları ve gözyaşlarını uzaklaştıran bir aura verir"},
	{"336", "Dead Onion", "Piercing + spectral tears#↑ +0.25 Range up#↓ -0.4 Shot Speed down#↑ +50% Tear size"},
	{"337", "Bozuk Saat", "Her 4 odada bir hızlanır veya yavaşlar"},
	{"338", "Bumerang", "Atılabilir bumerang#Düşmanları afallatır ve hasarının 2 katını verir#İtemleri alabilir"},
	{"339", "Safety Pin", "↑ +5.25 Range up#↑ +0.16 Shot Speed up#+1 Black Heart#↑ +0.5 Tear Height"},
	{"340", "Kafein Hapı", "↑ +0.3 Hız#↑ Boy küçülür#Alındığında rastgele hap verir"},
	{"341", "Yırtık Fotoğraf", "↑ +0.7 Gözyaşı#↑ +0.16 Gözyaşı hızı"},
	{"342", "Blue Cap", "↑ +1 Health up#↑ +0.7 Tears up#↓ -16% Shot Speed down"},
	{"343", "Sürgü Anahtarı", "↑ +1 Şans#+1 Ruh Kalbi#2 Anahtar çıkartır"},
	{"344", "Match Book", "+1 Black Heart#Spawns 2-3 Bomb pickups"},
	{"345", "Synthoil", "↑ +1.0 Damage up#↑ +5.25 Range up#↑ +0.5 Tear Height"},
	{"346", "A Snack", "↑ +1 Health up"},
	{"347", "Diplopia", "!!! TEK KULLANIM !#Yerdeki itemleri, harcanılabilirleri çiftler"},
	{"348", "Plasebo", "Elindeki hapın efektini kopyalar"},
	{"349", "Ahşap Bozuk Para", "50% şans ile rastgele altın çıkartır"},
	{"350", "Toxic Shock", "At the start of every room every enemy gets a poison effect"},
	{"351", "Mega Fasülye", "Odadaki tüm düşmanları dondur#5 Hasar verir ve yakın düşmanları zehirler#Odada dıken dalgaları gönderir#!!! Gizli odaları açmak için kullanılabilir"},
	{"352", "Glass Cannon", "↓ Reduces your health to half a heart#Fires one large piercing spectral tear ((DMG+1) X 10)"},
	{"353", "Bombacı Oğlan", "+5 bomba#Bombalar artık artı şeklinde patlar"},
	{"354", "Çerezza", "↑ +1 HP#Yere rastgele bir trinket çıkartır"},
	{"355", "Mom's Pearls", "↑ +1.25 Range up#↑ +1 Luck up#↑ +0.5 Tear Height"},
	{"356", "Araba Aküsü", "Aktif item kullanıldığında iki kere aktive olmasını sağlar"},
	{"357", "Arkadaş Sandığı", "Oda boyunca arkadaşlarını iki katına çıkartır"},
	{"358", "Büyücü", "Çapraz olarak aynı anda 2 gözyaşı atar, R U A WIZARD hapına benzer şekilde#Hayalet gözyaşları"},
	{"359", "8 İnç Çiviler", "↑ +1.5 Hasar#Arttırılmış ittirme"},
	{"360", "Incubus", "Shoots the same tears as Isaac in terms of damage, stats and effects"},
	{"361", "Kaderin Ödülü", "Gözyaşlarının kopyası şeklinde ateş eder"},
	{"362", "Minik Sandık", "Bir kaç odada bir rastgele pickup çıkartır"},
	{"363", "Yeminli Koruyucu", "Yörüngeç arkadaş#Saniyede 105 dokunma hasarı verir#Ateşleri bloklar ver kendine çeker#Bir odada 10 gözyaşı bloklamak ebedi kalp düşürür"},
	{"364", "Arkadaş Bölgesi", "Yörüngeç arkadaş#Saniyede 45 dokunma hasarı verir"},
	{"365", "Kayıp Sinek", "Duvarların ve engellerin etrafında hareket eder#Saniyede 105 dokunma hasarı verir"},
	{"366", "Dağılan Bombalar", "+5 bombs#Causes your bombs to explode into 2-4 tiny bombs"},
	{"367", "Patlayan Bombalar", "+5 bomba#Düşman bomba tarafından öldürüldüğünde mavi örümcekler çıkartır#Bombaların düşmana yapışmasını sağlar"},
	{"368", "Epiphora", "Tek bir yönde ateş etmek atış sıklığını 200%e kadar arttırır"},
	{"369", "Devamlılıık", "↑ +2.25 Range up#↑ +1.5 Tear Height#Tears travel through walls and appear out of the opposite wall"},
	{"370", "Bay Dolly", "↑ +0.7 Tears up#↑ +5.25 Range up#↑ +0.5 Tear Height#Spawns 3 random hearts when picked up"},
	{"371", "Kulenin Laneti", "Her hasar aldığında 6 troll bombası düşürür#Bomba itemleri ile sinerji olur"},
	{"372", "Charged Baby", "Random chance to drop a battery or freeze all enemies in the room#Chance to add one charge to your spacebar item"},
	{"373", "Ölü Göz", "Düşmana vuran her gözyaşı için ↑ +12.5% hasar (max. +100%)"},
	{"374", "Holy Light", "Random chance to fire a Holy tear, which will spawn a beam of light on hit#The beam deals 4x your damage"},
	{"375", "Host Hat", "20% chance to block tears#Get immune to explosions/Stomps from Mom's and Satan's foot"},
	{"376", "Restock", "Spawns 3 random Pickups#Shops instantly restock their items when you buy them"},
	{"377", "Açılan kese", "Örümcek düşmanlar artık hedef alıp dokunma hasarı vermezler"},
	{"378", "2 Numara", "3 saniye boyunca ateş etmek göt bombası bırakır"},
	{"379", "Pupula Duplex", "Gözyaşları çok büyür#Hayalet gözyaşları"},
	{"380", "Oynamak İçin Öde", "+5 altın#Odalar artık anahtar değil altın ile açılır"},
	{"381", "Eden'in Kutsaması", "↑ +0.7 Gözyaşı#Sonraki oyununun başında sana rastgele bir item verir"},
	{"382", "Friendly Ball", "Can be thrown at enemies to capture them#Next usage will re-spawn the same enemy as a friendly companion"},
	{"383", "Gözyaşı Fünyesi", "Ekranda bulunan tüm gözyaşlarını patlatır, her birinin 6ya ayrılıp çember şeklinde dağılmasını sağlar"},
	{"384", "Lil Gurdy", "Will launch and slide around the room#Deals 90 contact damage per second"},
	{"385", "Bumbo", "Yakındaki altınları toplar#Her 6 altında seviye atlar, sadece 4. seviye 12 sürer#Level 2: Rastgele pickup bırakır#Level 3: Seninle aynı yönde gözyaşı atar#Level 4: Ateş etmez fakat düşmanları kovalar. Rastgele bomba bırakır#Level 4 Sonrası: altın toplayup rastgele pickup dülşürmeye devam eder"},
	{"386", "D12", "Herhangi bir objeyi farklı tipte bir objeye dönüştürür (örn. bok, testi, TNT, kırmızı bok, taş vs.)"},
	{"387", "Tütsülük", "İçindeki düşmanları ve ateşleri yavaşlatan kocaman bir aura verir"},
	{"388", "Anahtar Evsizi", "Anahtar toplar, karşılığında rastgele kasalar verir"},
	{"389", "Rune Kesesi", "Drops a random rune every 5-6 rooms"},
	{"390", "Seraphim", "Sacred Heart gözyaşları atar#Atış başına 10 hasar verir"},
	{"391", "İhanet", "Hasar alındığında, odadaki her düşmanı aşık eder"},
	{"392", "Burç", "Her katta rastgele bir burç itemı efekti verir"},
	{"393", "Serpent's Kiss", "Random chance to shoot poison tears#Poison enemies on contact#Enemies that were poisoned have a chance to drop a black heart on death"},
	{"394", "Marked", "Fire tears automatically directed at a red target on the ground which is controlled by the player#↑ +0.7 Tears up#↑ +3.15 Range up#↑ +0.3 Tear Height"},
	{"395", "Tech X", "Gain the ability to charge and fire a laser ring that travels across the room"},
	{"396", "Neşter", "Aralarında ışınlanmak için 2 portal yaratılabilir#Portallar farklı odalara yerleştirilebilir"},
	{"397", "Tractor Beam", "Isaac's tears now travel directly forwards following a beam of light, but will also move sideways based on your player movement#↑ +0.5 Tears up#↑ +5.25 Range up#↑ +0.16 Shot Speed up#↑ +0.5 Tear Height"},
	{"398", "Tanrının Eti", "Gözyaşları düşmanları küçültebilir#Küçülen düşmanlar üzerine yürünerek ezilip öldürülebilir"},
	{"399", "Maw Of The Void", "↑ +1.0 Damage up#After firing tears for 3 seconds, a red cross appears on Isaac's head. Upon releasing the fire button, creates a black brimstone ring#Enemies killed with the black ring have a chance to drop Black hearts"},
	{"400", "Kader Mızrağı", "Önüne bir mızrak koyar#Hasarının 2 katını verir#Temas halinde düşmanları korkutma şansı"},
	{"401", "Explosivo", "Chance to fire sticky bomb tears"},
	{"402", "Kaos", "İtemler artık rastgele havuzdan çekilir#Rastgele 1-6 pickup çıkartır"},
	{"403", "Örümcek Modu", "Gözyaşı hasarını ve düşmanların canlarını görmeni sağlar#Temas halinde rastgele bir durum efekti uygular#Rastgele pil düşürür"},
	{"404", "Farting Baby", "Blocks projectiles#If hit, it will fart, which will charms, poison or knockback enemies"},
	{"405", "GB Bug", "Bounces around the room#Deals 120 damage per second and applies a random status effect"},
	{"406", "D8", "Özelliklerini değiştirir#Sadece hasar, gözyaşı, menzil ve hızı etkiler"},
	{"407", "Purity", "↑ Boost one of your stats depending on the color of the aura around you#When you take damage, you will get a new aura#{{ColorRed}}Red{{CR}} = +4.0 Damage#{{ColorBlue}}Blue{{CR}} = -4 Tear Delay#{{ColorYellow}}Yellow{{CR}} = +0.5 Speed up#{{ColorOrange}}Orange{{CR}} = +7.5 Range up, +1 Tear height"},
	{"408", "Athame", "When you take damage, a black brimstone ring will appear around Isaac#Enemies killed with it have a chance to drop a black heart"},
	{"409", "Boş Kase", "+2 Siyah kalp#Isaac kırmızı kalbe sahip değil ise, uçuş kazanır ve kalkan çıkarma şansı kazanır"},
	{"410", "Nazar", "Ekran boyunca Isaac ile aynı yönde ateş eden bir göz çıkarma şansı"},
	{"411", "Tutkulu Kan", "↑ Odada öldürülen her düşman için +0.5 Hasar#Maksimum 10 düşmandan sonra +5 Hasar"},
	{"412", "Cambion Peydahı", "15 Defa Hasar aldıktan sonra, kalıcı şeytan arkadaşı kazanır#4 arkadaşa kadar mümkündür"},
	{"413", "Kusursuz Peydah", "15 kalp aldıktan sonra, kalıcı melek arkadaşı kazanır#5 arkadaşa kadar mümkündür"},
	{"414", "Daha Fazla Seçenek", "Hazine odalarında artık 2 item çıkar#Sadece birini seçebilirsin"},
	{"415", "Işık Tacı", "+2 Ruh Kalbi#↑ Yarım/Boş kırmızı kalp konteynırı yoksa Hasar X 2#Odada hasar alınırsa o oda için deaktive olur"},
	{"416", "Deep Pockets", "Allows you to carry two cards/pills/runes"},
	{"417", "Succubus", "Bounces around the room with a damaging aura, dealing 129% of your damage every second#↑ +50% damage while standing in the aura,"},
	{"418", "Meyvalı Keke", "Her atılan gözyaşı farklı bir efekte sahip olur"},
	{"419", "Işınlan 2.0", "Henüz girilmemiş bir odaya ışınlar#Hiyerarşi: {{Room}}>{{BossRoom}}>{{SuperSecretRoom}}>{{Shop}}>{{TreasureRoom}}>{{SacrificeRoom}}> {{DiceRoom}}>{{Library}}>{{CursedRoom}}>{{MiniBoss}}>{{ChallengeRoom}}>{{IsaacsRoom}}> {{ArcadeRoom}}>{{ChestRoom}}>{{SecretRoom}}>{{DevilRoom}}{{AngelRoom}}> Error-Odası"},
	{"420", "Kara Un", "Yürürken çember çizmek yerde pentagram sembolü çıkartır, tik başına 10 hasar verir"},
	{"421", "Kidney Bean", "Applies charm effect to any enemies in close range and deals 5 damage to them"},
	{"422", "Parlayan Kum Saati", "Zamanı geri alıp bir önceki odaya ışınlar, o andaki haline geri dönersin"},
	{"423", "Koruma Çemberi", "Etrafında büyük bir hale olur, dokunduğunda senin hasarın kadar hasar verir#Düşman ateşlerini geri yollama şansı"},
	{"424", "Kese Kafa", "Pickuplar 33% şans ile keseyle değiştirilir#Kese çıkartır"},
	{"425", "Gece Feneri", "Önüne düşmanları ve ateşlerini yavaşlatan bir ışık konisi çıkartır"},
	{"426", "Obsessed Fan", "Follows your exact movement on a 3 second delay#Deals 30 contact damage per second"},
	{"427", "Minecraftçı", "İttirilebilen TNT varili çıkartır#TNT odada iken tekrar kullanıldığında uzaktan detone eder"},
	{"428", "Pijama", "+4 Ruh Kalbi#Kırmızı kalplerini fuller"},
	{"429", "Keeperın Kafası", "Düşmanlar vurulduğunda 5% şans ile altın düşürür"},
	{"430", "Papa Fly", "Follows your movement pattern on a 1 second delay#Fires tears at nearby enemies that deal damage equal to your damage"},
	{"431", "Multidimensional Baby", "Follows your movement pattern on a 2 second delay#Tears that pass through it will split up and gain a speed boost"},
	{"432", "Sim Bombası", "+5 bomba#Bombalar patladığında rastgele pickup düşürme şansına sahip olur"},
	{"433", "Gölgem", "Hasar aldığında, tüm düşmanlara korku efekti uygulayıp siyah charger çıkartır#The charger saniyede 5 hasar verir"},
	{"434", "Sinek Kavanozu", "Her öldürdüğün düşmanda kavanoza mavi sinek eklenir#20 sineğe kadar#İtemi kullanmak tüm sinekleri salar"},
	{"435", "Minik Loki", "Artı şeklinde 4 gözyaşı atar#Atış başına 3.5 hasar verir"},
	{"436", "Süt!", "Hasar alındığında, oda boyunca gözyaşın artar"},
	{"437", "D7", "Respawn all enemies of the room#Allows you to farm room clear rewards#!!! If used in a greed fight, it can reroll the room into a Shop"},
	{"438", "Binky", "+1 Ruh Kalbi#↑ +0.7 Gözyaşı#↑ Isaacı çok küçük yapar, daha zor vurulur"},
	{"439", "Annenin Sandığı", "Rastgele bir trinket düşürür#↑ Elde iken +1 Şans#Elde iken, trinketlerin efektlerini iki katına çıkartır"},
	{"440", "Kidney Stone", "Randomly while firing you will stop firing and release a burst of tears and a kidney stone#↓ -0.2 Speed down#↓ -17 Range down#↑ +2.0 Tear height"},
	{"441", "Mega Atış", "15 Saniye boyunca dev bir Mega Satan lazeri atar#Lazer oda ve katlar arasında devam eder"},
	{"442", "Dark Princes Crown", "!!! While at 1 full red heart:#↑ +1.5 Range up#↑ +0.75 Tears up#↑ +0.2 Shot Speed up#(Doesnt work with characters without red HP)"},
	{"443", "Elma!", "Rastgele 400% hasar veren jilet gözyaşları atar#↑ +0.3 Gözyaşı"},
	{"444", "Kurşun Kalem", "Every 15 tears fired, you fire a cluster of tears#Each tear in the cluster deals double damage"},
	{"445", "Köpek Dişi", "↑ +0.3 Hasar#↑ +0.1 Hız#Gizli odaya bitişik bir odaya girdiğinde kurt ulumaya başlar#Sürünme alanı olan bir odaya girğinde köpek havlama sesi duyulur"},
	{"446", "Ölü Diş", "Ateş ederken, İçindeki düşmanları zehirleyen yeşil bir auraya sahip olursun#Zehir seninle aynı hasarı verir"},
	{"447", "Gitmeyen Fasülye", "Durmadan ateş ederken, her 7.5 saniyede bok bulutu çıkartır#Bulut saniyede 5 defa 3.5 hasar verir#Bulut 15 saniye sürer#Ateş ederek oynatılabilir"},
	{"448", "Cam parçası", "Hasar alırken, ↑ +5 Menzil ve kan sıvısı bırakma veya kırmızı kalp çıkarma şansı"},
	{"449", "Metal Plaka", "+1 Ruh Kalbi#Düşman gözyaşları 25% şans ile afallatan gözyaşı olarak geri gönderilir"},
	{"450", "Greedin gözü", "Her 20 gözyaşında bir, düşmanları altına çeviren para gözyaşı atar#Bu 1 altına mal olur#Vurulan düşmanlar altın düşürür"},
	{"451", "Tarot Cloth", "Drops a random card or rune on pickup#Doubles the effect of any card used"},
	{"452", "Varisli Damarlar", "Hasar alındığında, etrafında halka olarak 10 gözyaşı at#Gözyaşları hasarının 125%ini verir"},
	{"453", "Compound Fracture", "Bone tears#Tears shatter into 1-3 smaller bone shards upon hitting anything#↑ +1.5 Range up#↑ +1.0 Tear height"},
	{"454", "Polydactyly", "İki kart, rune veya hap taşıyabilirsin#Alındığında rastgele kart, rune veya hap düşürür"},
	{"455", "Dad's Lost Coin", "↑ +1.5 Range up#Spawns a lucky penny"},
	{"456", "Moldy Bread", "↑ +1 Health up"},
	{"457", "Koni Kafası", "+1 Ruh Kalbi#20% şans ile hasarı görmezden gelir"},
	{"458", "Göbek Deliği", "Yere rastgele bir trinket çıkartır#1 ekstra trinket slotu verir"},
	{"459", "Sinüs Enfeksiyonu", "Yapışan zehir gözyaşları#Tik başına senin hasarın kadar hasar verir#Düşman ölene kadar yapışık kalır"},
	{"460", "Glakoma", "Afallatan gözyaşı atma şansı"},
	{"461", "Parasitoid", "Yumurta kesesi atma şansı#Vurduğunda yavaşlatan sıvı çıkartır#Vurduğunda mavi örümcek ya da sinek çıkartır"},
	{"462", "Belialın Gözü", "↑ +1.5 Menzil#↑ +1.0 Gözyaşı yüksekliği#Delici gözyaşları verir#İlk düşman vurulduktan sonra, gözyaşı iki katı hasar verir ve takip eden efekt kazanır"},
	{"463", "Sülfürik Asit", "↑ +0.3 Hasar#Gözyaşları ile taşları yok edip kapıları açma şansı"},
	{"464", "Denge Sembolü", "+2 Soul Hearts#Champion enemies drop pickups more frequently"},
	{"465", "Analog Çubuğu", "↑ +0.3 Gözyaşı#İki yönde ateş ederek çapraz ateş etmeyi sağlar"},
	{"466", "Bulaşma", "Odada öldürülen ilk düşman patlar ve yakındaki düşmanları zehirler"},
	{"467", "Parmak!", "Parmağın baktığı yöndeki düşmanlara sürekli hasarının 10%unu uygular"},
	{"468", "Gölge", "1 saniye gecikme ile hareketlerini takip eder#Saniyede 30 dokunma hasarı verir"},
	{"469", "Depresyon", "Sıvı bırakır#Sıvı saniyede 6 hasar verir#Buluta dokunan düşmanların kutsal ışık süzmesi yaratma şansı olur"},
	{"470", "Hushy", "Oda etrafında gezer#Dokunma hasarı verir#Sen ateş ederken durur#Durduğunda ateşleri bloklayabilir"},
	{"471", "Minik Monstro", "Şarj edilebilir pompalı atağı#(monstros lung benzeri)#Her gözyaşı 3.5 hasar verir"},
	{"472", "King Baby", "Other familiars follow it#Stops moving when you are shooting#Will teleport back to you when you stop shooting"},
	{"473", "Büyük Chubby", "Çok yavaşça ileri hareket eder#Saniyede 40.5 dokunma hasarı verir"},
	{"474", "Tonsil", "Blocks enemy projectiles"},
	{"475", "Plan C", "!!! TEK KULLANIM ! #Tüm düşmanlara 9,999,999 hasar verir ve 3 saniye sonra seni öldürür"},
	{"476", "D1", "Odadaki rastgele 1 pickupı çift yapar"},
	{"477", "Boşluk", "!!! Kullanıldığında, odadaki itemleri yutar#Aktif item: Efekti Void'in efektine eklenir (üstüne biner)#↑ Pasif item: Rastgele bir özellik arttırır"},
	{"478", "Durdur", "Tekrar ateş edene kadar odadaki tüm düşmanları dondurur#Donmuş bir düşmana dokunmak sana hasar verir#Düşmanların 30 saniye sonra donması biter"},
	{"479", "Eritici", "Trinketini yutar ve kalıcı olarak sana efektini verir#Daha çok trinket düşmesini sağlar"},
	{"480", "Kompost", "Pickupları mavi sineğe veya örümceğe çevirir#O andaki sinek/örümcek sayını ikiye katlar#Hiç yoksa 1 mavi sinek veya örümcek çıkartır"},
	{"481", "Datamadencisi", "Kullanıldığında, ↑/↓ rastele miktarda özellik değişimi#Oda boyunca rastgele gözyaşı efektı#Görüntünün içine eder"},
	{"482", "Kumanda", "Seni başka bir karaktere çevirir#Son aldığın itemi siler"},
	{"483", "Ana Mega!", "!!! TEK KULLANIM ! #Bütün katı etkiler#Bütün objeleri patlatır#Her düşmana 200 hasar verir#Boss rush / hush kapılarını ve gizli odaları açar"},
	{"484", "Ney Ney?", "Kullanışdığında, düşmanları uzağa ittirir ve taş dalgası çıkartır#Odaları açıp taşları kırabilir"},
	{"485", "Yamuk Para", "50% şansla odadaki tüm itemleri, harcanabilirleri ve kasaları değiştirir#50% şans ile siler ve 1 altın verir"},
	{"486", "Kör Jilet", "Canını azaltmadan sana hasar verir#İtem efektleri için"},
	{"487", "Patates Soyucusu", "Bir kırmızı kalp konteynırını alır ve ↑ +0.2 Hasar ve \"Cube of Meat\" verir"},
	{"488", "Metronom", "Her odada rastgele item efekti verir"},
	{"489", "D infinity", "Random Dice-effect each usage"},
	{"490", "Eden'in Ruhu", "!!! TEK KULLANIM !#Bulunan odanın havuzundan 2 rastgele item çıkartır"},
	{"491", "Acid Baby", "Drops a random pill every 3 rooms#Using a pill poisons all enemies in the room"},
	{"492", "HEY DİNLE!", "↑ +1 Şans#Gizli odaların, işaretli taşların ve tuzak kapılarının yerini gösterir"},
	{"493", "Adrenaline", "For every empty heart container:#↑ +0.2 Damage up"},
	{"494", "Jacob's Ladder", "Tears spawn 1-2 sparks of electricity on impact#Sparks deal half your damage"},
	{"495", "Hayalet Biber", "Gözyaşı yerine ateş atma şansı#Ateş 5 defa hasar verene kadar kalır"},
	{"496", "Ötenazi", "İğne atma şansı#İğneler normal düşmanları anında öldürür#Aksi taktirde hasarının 3 katını verir"},
	{"497", "Kamuflaj Donu", "Odaya girdiğinde ateş etmeye başlayana kadar kendini kamuflaj yapar ve düşmanların kafasını karıştırır"},
	{"498", "Dualite", "Şeytan-{{DevilRoom}} VE Melek{{AngelRoom}}-Odaso kapıları çıkartır#Birine girince, diğeri kaybolur"},
	{"499", "Ayin", "100% Melek{{AngelRoom}} Odası bulma şansı"},
	{"500", "Kese Kesesi", "Her 5-6 odada kese çıkartır"},
	{"501", "Greed'in Boğazı", "Her 25 altın için 1 kalp konteynırı verir#Keeper daha fazla altın kalbine sahip olur"},
	{"502", "Büyük Sivilce", "İki katı hasar veren sıvı bırakan gözyaşı atma şansı"},
	{"503", "Little Horn", "Chance to fire tears that instantly kill enemies#Running into enemies will deal 3.5 damage to them"},
	{"504", "Brown Nugget", "Spawns a fly turret that shoots at enemies#Each shot deals 2 damage"},
	{"505", "Poke Go", "Düşmanlı odaya girildiğinde aşık bir düşman çıkarma şansı"},
	{"506", "İhanetçi", "Gözyaşları kanamaya sebep olabilir, düşmanın canının 10% hasarını her 5 saniye verir"},
	{"507", "Keskin Piper", "Senin hasarın + düşmanın maks canının 10%u hasar verir#Odadaki her düşmanı etkiler#Hasar verdiğinde yarım kalp düşürme şansı"},
	{"508", "Annenin Jileti", "Kanamaya sebep olan arkadaş, düşmanın canının 10% hasarını her 5 saniye verir.#Hasarının 300%ünü temas halinde verir"},
	{"509", "Bloodshot Eye", "Orbital that shoots a tear every 2 seconds in a random direction#Deals 3.5 damage per tear#Deals 30 contact damage per second"},
	{"510", "Delirious", "Oda için bossun küçük delirium versiyonunu arkadaş olarak çıkartır"},
	{"511", "Kızgın Sinek", "Öldürene kadar rastgele bir düşmanın etrafında yörünge çizer#Diğer düşmanlara saniyede 30 dokunma hasarı verir"},
	{"512", "Kara Delik", "Atılabilir jara delik, her şeyi içine çeker#Her tikte 0.4 hasar verir#Yakındaki taşları yok eder#6 Saniye sürer"},
	{"513", "Bozo", "↑ +0.1 Hasar#+1 Ruh kalbi#Düşmanı aşık etme veya korkutma şansı#Hasar aldığında gökkuşağı boku çıkarma şansı"},
	{"514", "Bozuk Modem", "Rastgele zamanlarda düşmanlarda 'lag' olmasını sağlar, donarlar#25% şans ile oda ödüllerini iki katına çıkartır"},
	{"515", "Gizemli Hediye", "!!! TEK KULLANIM !#Bulunduğu odanın havuzundan rastgele bir item çıkartır#Bunun yerine Lump of Coal veya The Poop itemlerini çıkarabilir"},
	{"516", "Sulayıcı", "Döçnen bir sulama aleti çıkartır, gözyaşlarını sprey olarak atar"},
	{"517", "Hızlı Bombalar", "+7 Bomba#Sürekli bomba bırakabilmeni sağlar"},
	{"518", "Kutuda Arkadaş", "Rastgele bir coop bebeği gibi gözüken arkadaş#Rastgele bir gözyaşı efektine sahip olur#Her kat değişir"},
	{"519", "Minik Delirium", "10 Saniyede bir başka arkadaşlara dönüşen arkadaş"},
	{"520", "Akü Kablosu", "Öldürülen her 15 düşman için aktif itemini +1 şarj doldurur"},
	{"521", "Kupon", "Kullanıldığında,Dükkan{{Shop}}- veya Şeytan{{DevilRoom}}- odası itemini bedava yapar"},
	{"522", "Telekinezi", "Sana yakın olan düşman ateşleri 3 saniye yerınde durur#Sonrasında diper yöne atılır#3 saniye sonra dolar"},
	{"523", "Moving Box", "When used, stores all Pick-Ups from the current room#Using it again will put them back on the floor again#This allows you to move things between rooms"},
	{"524", "Technology Zero", "Tears will be connected with beams of electricity#Electricity damage equals your damage"},
	{"525", "Cüzam", "Hasar almak ateş bloklayan bir arkadaş çıkmasına sebep olur#Aynı anda maks. 3 Arkadaş#Çok hasar aldıklarında yok olurlar"},
	{"526", "7 Atlı", "Küçük atlı arkadaşları#10 Saniyede bir değişir"},
	{"527", "Mr. ME!", "!!! Senin için bir şeyler yapabilecek bir arkadaş:#Kapı & kasa aç, İtem getir, dükkandan,şeytandan item çal, düşman ile savaş, patla ve düğmelere bas"},
	{"528", "Melek Prizması", "Arkadaş piramidi#Piramide çarpan gözyaşları 4e katlanır"},
	{"529", "Pop!", "Gözyaşları bilardo topu gibi davranır"},
	{"530", "Azrailin Listesi", "Düşmanlar işaretli sırada öldürülürlerse ödül verir"},
	{"531", "Haemolacria", "Tears fly in an arc#Tears burst into smaller tears on impact#↓ Tears down#↑ 31% Damage up"},
	{"532", "Lachryphagy", "Gözyaşları hareket ederken yavaşlar#Durduğunda, 8 parçaya ayrılıp patlarlar#Gözyaşları diğer gözyaşlarının içine atılıp daha büyük yapılabilir"},
	{"533", "Trisagion", "Beyaz işik patlamaları atar#(Kutsal Brimstone)"},
	{"534", "Okul Çantası", "2 Aktif item tutulmasını sağlar#Drop tuşuna basarak itemler değiştirilebilir"},
	{"535", "Battaniye", "+1 Ruh kalbi#1 Kırmızı kalp verir#Boss odasına girerken kalkan verir"},
	{"536", "Kurban Alanı", "!!! TEK SEFERLİK !#1-2 Arkadaşını feda edip Şeytan{{DevilRoom}} odası itemi çıkartır#Mavi sinek ve örümceklerini altına çevirir"},
	{"537", "Minik Tükürücü", "Rastgele bir hap verir#Sıvı fırlatan arkadaş#Sıvı tipi oyuncu her hap kullandığında değişir"},
	{"538", "Bilyeler", "3 rastgele trinket çıkartır#HAsar almak trinketın efektini kalıcı olarak ekleyebilir"},
	{"539", "Gizemli Yumurta", "Hasar aldığında aşık bir düşman çıkartır#Odalar hasar almadan temizlendikçe daha güçlü arkadaşlar çıkartır"},
	{"540", "Düz Taş", "Gözyaşları yerde zıplar#Gözyaşları her zıplamada hasar verir"},
	{"541", "Marrow", "+1 Bone Heart#Spawns 3 Red Hearts"},
	{"542", "Kaygan Pirzola", "Yörüngeç#Düşman ateşlerini geri gönderir"},
	{"543", "Çukur", "Spawn white poop when you get hit#(White poop has a ↑ Tears up aura and can block damage)"},
	{"544", "Sivri Pirzola", "Önünde havada duran bir çivi#Saniyede 6 kere hasarına eşit hasar verir"},
	{"545", "Ölülerin Kitabı", "Odada öldürülen her düşman için kemik arkadaşı ya da aşık bony çıkartır"},
	{"546", "Babanın Yüzüğü", "Düşmanları olduğu yerde donduran bir aura verir"},
	{"547", "Boşanma Belgeleri", "+1 Kemik Kalbi#↑ +0.7 Gözyaşı#Mysterious Paper trinketini çıakrtır"},
	{"548", "Çene Kemiği", "Bumeragn gibi arkadaş#7 Dokunma hasarı#Pickupları getirebilir"},
	{"549", "Kırılgan Kemikler", "Bütün kırmızı kalp konteynırlarını 6 Kemik kalp ile değiştirir#Kemik kalbi kaybetmek her yönde kemik gözyaşı atılmasına sebep olur ve kalıcı ↑ +0.5 gözyaşı ekler"},
	{"550", "Kırık Kürek", "Annenin ayağı sürekli sana saldırır#Kullanmak oda için annenin ayağını durdurur#!!! (bununla Bossrush odasını bitirmeyi dene!)"},
	{"551", "Kırık Kürek", "broken shovelın ikinci parçası#!!! Küreği \"Dark Room\"un toprak tepeciğinde kullan"},
	{"552", "Annenin Küreği", "Sonraki kata bir tuzak kapısı açar#!!! Küreği \"Dark Room\"un toprak tepeciğinde kullan!!! Havalı bir şey açar"},
}

---------- Trinkets ----------
EID.descriptions[languageCode].trinkets={
	{"1", "Swallowed Penny", "Drop 1 coin when you get hit"},
	{"2", "Taşlaşmıs Bok", "Boklardan 50% fazla şey düşer"},
	{"3", "AAA Pil", "Aktif itemler için -1 şarj gerekir"},
	{"4", "Bozuk Kumanda", "İtem kullanırken seni rastgele ışınlar"},
	{"5", "Pembe Kalp", "Daha fazla şampiyon düşmanlar#boss challenge odaları şansını arttırır({{BossRushRoom}})"},
	{"6", "Kırık Mıknatıs", "Altın mıknatısı"},
	{"7", "Tesbih Taşı", "Melek{{AngelRoom}} odası şansı artar#Bible {{Collectible33}} bulma şansı artar"},
	{"8", "Kaset", "Hasar aldığında Gamekid efekti şansı"},
	{"9", "Dalga Solucanı", "Boyu değişlen gözyaşları"},
	{"10", "Wiggle Worm", "Tears move in waves#↑ +0.3 Tears up"},
	{"11", "Ring Worm", "Tears move in spirals with high speed"},
	{"12", "Düz Solucan", "50% daha geniş gözyaşları"},
	{"13", "Dükkan Kredisi", "Bir dükkann itemi bedava"},
	{"14", "Nasır", "Sıvıdan ve dikenden gelen hasarı engeller"},
	{"15", "Lucky Rock", "Destroying rocks spawns coins"},
	{"16", "Annenin Tırnağı", "Annenin ayağı düşmanları her 60 saniye ezer"},
	{"17", "Siyah Ruj", "Daha fazla Siyah Kalp"},
	{"18", "İncil Toprağı", "Daha fazla Ebedi Kalp"},
	{"19", "Ataç", "Anahtar kullanmadan kasaları aç"},
	{"20", "Maymun Patisi", "Yarım kalpteyken, Siyah Kalp verir#!!! 3 sefer kullanım"},
	{"21", "Gizemli Kağıt", "\"Polaroid\", \"The Negative\", \"Missing Page\" ve \"Missing Poster\"i taklit eder"},
	{"22", "Şeytanın Kuyruğu", "Kalp çıkma oranı 20%ye düşer#Anahtar şansı artar#Kalp pickupları siyah kalbe dönüşür"},
	{"23", "Kayıp Poster", "Feda odasında {{SacrificeRoom}} öldüğünde \"The Lost\" olarak tekrar doğarsın #Eğer karakter açıksa, her odada bu geçerli"},
	{"24", "Göt Parası", "Fart when picking up coins#Farts knockback enemies"},
	{"25", "Gizemli Şeker", "30 Saniyede bir osurur veya bok çıkartır"},
	{"26", "Hook Worm", "Tears move in angular patterns#↑ +10 Range"},
	{"27", "Kamçı Solucanı", "↑ +0.5 Gözyaşı hızı"},
	{"28", "Kırık Ankh", "22% şans ile \"Blue Baby\" olarak tekrar doğarsın"},
	{"29", "Balık Kafası", "Hasar aldığında mavi sinek çıkartır"},
	{"30", "Göz Nezlesi", "10% şans ile zehir gözyaşı atar"},
	{"31", "Raptiye", "10% şans ile delici hayalet gözyaşı atar"},
	{"32", "Özgürlük Şapkası", "Random mushroom effect per room#Can reveal special rooms on the minimap"},
	{"33", "Umbilical Cord", "When down to half a heart, you get little Steven"},
	{"34", "Çocuk Kalbi", "Daha çok kırmızı kalp düşer"},
	{"35", "Spiral Boynuz", "↑ +2 Hasar"},
	{"36", "Paslı Anahtar", "Daha fazla anahtar"},
	{"37", "Keçi Ayağı", "↑ +0.15 Hız"},
	{"38", "Annenin İncisi", "Daha fazla Ruh Kalbi"},
	{"39", "Kanser", "↑ Gözyaşı artar"},
	{"40", "Kırmızı Yama", "↑ Hasar alınca +1.8 hasar şansı"},
	{"41", "Kibrit", "Daha çok bomba#!!! \"The Tick\"i kaldırır"},
	{"42", "Şanslı Ayak Parmağı", "↑ +1 Şans#Daha çok pickup düşer"},
	{"43", "Lanetli Kafatası", "Yarım kalp ve altına hasar alındığında, rastgele odaya ışınlar"},
	{"44", "Güvenlik Şapkası", "Daha çok hap"},
	{"45", "Maça Ası", "Daha çok kart"},
	{"46", "Isaac'in Çatalı", "Oda temizlerklen yarım kalp iyileştirme şansı"},
	{"47", "", "<Item does not exist>"},
	{"48", "A Missing Page", "When getting hit, chance to damage all enemies in the room"},
	{"49", "Bloody Penny", "50% chance to drop half a heart when picking up coins"},
	{"50", "Burnt Penny", "50% chance to drop a bomb when picking up coins"},
	{"51", "Flat Penny", "50% chance to drop a key when picking up coins"},
	{"52", "Sahte Para", "Altın alırken 50% şans ile +1 altın"},
	{"53", "Kene", "-15% Boss canı#Boss odasına ({{BossRoom}}) girerken 1 kırmızı kalp iyileştirir#!!! Alındığında bırakılamaz#Sadece {{Trinket41}}Match Stick veya yutarak ile çıkarılabilir"},
	{"54", "Isaac'in Kafası", "Delici ateş atan arkadaş#3.5 Hasar"},
	{"55", "Maggy'nin İnancı", "Kat başında 1 ebedi kalp"},
	{"56", "Judas'ın Dili", "Şeytan anlaşmalarını 2 kalpten 1e indirir"},
	{"57", "???'in Ruhu", "Odada gezen arkadaş#Oyuncuyla aynı yöne ateş eder#3.5 Hasar"},
	{"58", "Samson'un Saçı", "↑ Düşman öldürürken 1/15 Şans ile +0.5 Hasar#Efekt oda için geçerli"},
	{"59", "Cain'in Gözü", "25% Şans ile kat başında map ikonlarını gösterir"},
	{"60", "Eve'in Kuş Ayağı", "Düşman öldürürken ölü kuş çıkarma şansı"},
	{"61", "Sol El", "Tüm kasaları kırmızı kasaya çevirir"},
	{"62", "Parlak Taş", "Sürünme alanı tasşkarı ve işaretli taşlar her 10 saniye yanıp söner"},
	{"63", "Güvenli Makas", "Troll bombalarını bomba pickupına dönüştürür"},
	{"64", "Gökkuşağı Solucanı", "Her 3 saniye rastgele solucan efekti"},
	{"65", "Tape Worm", "↑ Doubles your Range#-50% Tear height"},
	{"66", "Lazy Worm", "↓ -0.4 Shot Speed down#↑ +4 Range up"},
	{"67", "Kırık Zar", "Hasar alınca rastgele zar efekti verme şansı"},
	{"68", "Süper Mıknatıs", "pickup ve düşmanlar için mıknatıs"},
	{"69", "Faded Polaroid", "Camouflages the player randomly#Confuses enemies"},
	{"70", "Bit", "Düşman odasında örümcek çıkarma şansı"},
	{"71", "Amca Beyin Mesanesi", "Bombalar sıvı bırakır"},
	{"72", "Saat Pili", "Daha fazla pil#Oda temizlendiğinde 5% şans ile tutulan aktif iteme +1 şarj ekler"},
	{"73", "Kapsül", "Patlayan bombalar bomba pickupı düşürür"},
	{"74", "Çivi Bulucu", "Taşları kırınca daha fazla sürünme alanı şansı"},
	{"75", "Hata", "Her odada farklı trinket efekti"},
	{"76", "Poker Fişi", "Kasalar 50/50 şans ile daha fazla şey çıkartır YA DA düşman veya hiç bir şey çıkartmaz"},
	{"77", "Su Toplaması", "İttirmeyi arttırır"},
	{"78", "İkinci El", "Düşmanlarda durum efektleri daha fazla sürer"},
	{"79", "Sonsuz Adsız", "25% şansla hap/kart kullanınca kopyasını düşürür"},
	{"80", "Black Feather", "↑ +0.2 Damage up for each evil item held"},
	{"81", "Kör Öfke", "Hasar alınca verilen dokunulmazlık daha fazla sürer"},
	{"82", "Altın At Nalı", "+15% sonraki katta çift hazine odası"},
	{"83", "Dükkan Anahtarı", "Dükkanları {{Shop}} ücretsiz aç"},
	{"84", "Greedin Kaburgası", "Greed/Super Greed artık dükkanlarda çıkmaz#Daha fazla altın"},
	{"85", "Karma", "Bağış makinesi kullanmak seni iyileştirir veya dilenci çıkartır"},
	{"86", "Minik Larva", "Bok parçalamak mavi sinek çıkartır"},
	{"87", "Annenin Kolyesi", "Anahtar kullanırken yarım kalp iyileştir#Yarım kalpleri tam kalp yapar"},
	{"88", "HAYIR!", "Aktif itemlerin çıkma ihtimalini çok fazla düşürür"},
	{"89", "Çocuk Tasması", "Arkadaşlar sana daha yakın durur"},
	{"90", "Kahverengi Kapak", "Boklar parçalandığında patlar"},
	{"91", "Meconium", "Daha fazla siyah bok#Siyah bok parçalandığında siyah kalp düşürme ihtimali"},
	{"92", "Kırık Taç", "↑ Stat increases of your items are 33% more effective#↑ +0.2 Tears up#↑ -1 Tear Delay"},
	{"93", "Kullanılmış Bebek Bezi", "Sinek düşmanlarının arkadaş olma ihtimali olur"},
	{"94", "Balık Kuyruğu", "Bütün çıkan mavi sinek/örümcekleri ikiye katla"},
	{"95", "Siyah Diş", "Zehirli diş gözyaşı atma ihtimali"},
	{"96", "Ouroboros Solucanı", "Gözyaşları hızlıca spiral halinde ilerler#Hayalet gözyaşı#↑ +4 Menzil"},
	{"97", "Bademcik", "12-20 defa hasar alınca bloklayıcı arkadaş verir#2 arkadaşa kadar"},
	{"98", "Burun Goblini", "Yapışkan zehirli gözyaşı atma ihtimali"},
	{"99", "Süper Top", "Seken gözyaşı atma ihtimali"},
	{"100", "Yanan ampül", "!!! Şarjı full aktif item tutarken:#↑ +0.5 Hasar#↑ +0.25 Hız#↑ +0.75 Menzil#↑ +0.2 Gözyaşı#↑ +0.1 Atış hızı#↑ +1 Şans"},
	{"101", "Sönük Ampül", "!!! While holding an uncharged active item:#↑ +1.5 Damage#↑ +0.5 Speed#↑ +1.5 Range#↑ +0.4 Tears#↑ +0.3 Shot Speed#↑ +2 Luck"},
	{"102", "Parçalanmış Kart", "+1 ekstra gizli oda"},
	{"103", "Eşitlik!", "!!! Altın, anahtar ve bomba sayısı eşit olduğunda:#Yarım pickupları tam yapar"},
	{"104", "Lades Kemiği", "Hasar alınca item düşürme ihtimali#Sonrasında yok olur"},
	{"105", "Öğlen Yemeği Çantası", "Hasar alınca Lunch {{Collectible22}} verme ihtimali#Sonrasında yok olur"},
	{"106", "Kayıp Şarap Mantarı", "Ürettiğin sıvıların çağını arttırır"},
	{"107", "Karga Kalbi", "Alınan hasar Mavi/Siyah kalplerini görmezden gelir, önce kırmızıları alır"},
	{"108", "Ceviz", "Patlamadan hasar alınca rastgele pickup/trinket düşürme ihtimali#Sonrasında yok olur"},
	{"109", "Koli Bandı", ":Arkadaşlarının hareket etmesini bırakmasına sebep olur"},
	{"110", "Gümüş Dolar", "Shops {{Shop}} will now appear in the womb"},
	{"111", "Kanlı Taç", "Item rooms {{TreasureRoom}} now appear in the womb"},
	{"112", "Kazanmak İçin Öde", "Stok kutuları her zaman item odasında({{TreasureRoom}}) bulunur"},
	{"113", "Savaş Çekirgesi", "Düşmanlı odaya girince patlayan atak sineği çıkartır#Sinek hasarının iki katı + patlama hasarı verir"},
	{"114", "Veba Çekirgesi", "Düşmanlı odaya girince zehirli atak sineği çıkartır#:Sinek hasarının 2 katını verir"},
	{"115", "Kıtlık Çekirgesi", "Düşmanlı odaya girince yavaşlatan atak sineği çıkartır#:Sinek hasarının 2 katını verir"},
	{"116", "Ölüm Çekirgesi", "Düşmanlı odaya girince atak sineği çıkartırm#Sinek hasarının 4 katını verir"},
	{"117", "Fetih Çekirgesi", "Düşmanlı odaya girince patlayan 1-4 atak sineği çıkartır#Her sinek hasarının 2 katını verir"},
	{"118", "Yarasa Kanadı", "Düşman öldürdükten sonra uçuş kazanma şansı#Oda boyunca"},
	{"119", "Kök Hücre", "Heals half a heart upon traveling to the next floor"},
	{"120", "Saç Teli", "Boss savaşı başlangıcında aktif itemini tamamen şarj eder"},
	{"121", "Ahşap Haç", "Her katta aldığın ilk hasardan korur"},
	{"122", "Margarin!", "İtemini kullanmak yere bırakmana sebep olur"},
	{"123", "Tel Tüy", "Melek bosslarının anahtar parçaları yerine melek itemleri vermesini sağlar"},
	{"124", "Kapı Durdurucu", "Son kullandığın kapı açık kalır"},
	{"125", "Uzatma Kablosu", "Arkadaşlarını elektrik ile birbirine bağlar#Elektrik başına 6 hasar verir"},
	{"126", "Çürük Para", "Altın alırken mavi sinek verir"},
	{"127", "Bebek-Bükücü", "Arkadaşların takıp eden gözyaşına sahip olur"},
	{"128", "Parmak Kemiği", "2% chance to gain a Bone Heart when taking damage"},
}

---------- Cards ----------
EID.descriptions[languageCode].cards={
	{"1", "0 - Deli", "Katın başladığı odaya ışınlar"},
	{"2", "I - Sihirbaz", "Oda için takip eden gözyaşları"},
	{"3", "II - Baş Rahibe", "Annenin ayağı düşmanın üstüne basar!"},
	{"4", "III - İmparatoriçe", "↑ Oda için +2.35 Hasar & +0.3 Hız"},
	{"5", "IV - İmparator", "Boss odasına({{BossRoom}}) ışınlar"},
	{"6", "V - Papa", "2 Mavi Kalp çıkartır"},
	{"7", "VI - Aşıklar", "2 Kırmızı Kalp çıkartır"},
	{"8", "VII - Savaş Arabası", "6 saniye boyunca dokunulmazlık + temas hasarı"},
	{"9", "VIII - Adalet", "1 bomba, 1 anahtar, 1 altın, 1 kalp"},
	{"10", "IX - Yaşlı Adam", "Dükkana{{Shop}} ışınlar"},
	{"11", "X - Feleğin Çarkı", "Slot veya fal makinası çıkartır"},
	{"12", "XI - Güç", "↑ +1 HP#↑ +0.3 Hasar#↑ +50% Hasar#↑ +5.25 Menzil#↑ +0.3 Hız#Oda için"},
	{"13", "XII - Asılı Adam", "Oda için uçuş verir"},
	{"14", "XIII - Ölüm", "Tüm düşmanlara 40 hasar verir"},
	{"15", "XIV - İtidal", "Kan bağış makınası çıkartır"},
	{"16", "XV - Şeytan", "↑ +2 Hasar oda için"},
	{"17", "XVI - Kule", "6 troll bombası çıkartır"},
	{"18", "XVII - Yıldızlar", "Hazine odasına({{TreasureRoom}}) ışınlar"},
	{"19", "XVIII - Ay", "Gizli odaya({{SecretRoom}}) ışınlar"},
	{"20", "XIX - Güneş", "Tüm düşmanlara 100 hasar verir#Full can#Haritayı açar"},
	{"21", "XX - Hüküm", "Dilenci çıkartır"},
	{"22", "XXI - Dünya", "Bütün haritayı açar"},
	{"23", "Sinek 2", "Bombax2"},
	{"24", "Karo 2", "Altınx2"},
	{"25", "Maça 2", "Anahtarx2"},
	{"26", "Kupa 2", "Kırmızı kalpx2#Sadece iyileştirir"},
	{"27", "Sinek Ası", "Turns all pickups into bombs"},
	{"28", "Karo Ası", "Turns all pickups into coins"},
	{"29", "Maça Ası", "Turns all pickups into keys"},
	{"30", "Kupa Ası", "Turns all pickups into hearts"},
	{"31", "Joker", "Şeytan{{DevilRoom}} veya Melek{{AngelRoom}} odasına ışınlar"},
	{"32", "Dolu", "Odadaki bütün taşları yok eder"},
	{"33", "Başarı", "Odadaki tüm pickupları kopyalar"},
	{"34", "Korunma", "Tuzak kapısı çıkartır"},
	{"35", "Değişim", "+1 Mavi Kalp#Lanet efektlerini kaldırır"},
	{"36", "Haberci", "Kat için full harita"},
	{"37", "Gizem", "Bütün alınacak itemleri değiştirir"},
	{"38", "Doğurganlık", "3er mavi sinek ve örümcek çıkartır"},
	{"39", "Korumacılık", "Invincibility for 30 seconds"},
	{"40", "Boş Rune", "Rastgele rune efekti#25% ihtimal ile kendini tekrar çıkartır"},
	{"41", "Kara Rune", "Tüm düşmanlara 40 hasar verir#Odadaki tüm itemler için rastgele özellik artar#(İtemleri yok eder)"},
	{"42", "Kaos Kartı", "Atılabilir tekte öldürme kartı"},
	{"43", "Kredi Kartı", "Odadaki tüm dükkan veya şeytan itemlerinden fiyatı kaldırır, ücretsiz yapar"},
	{"44", "Kural Kartı", "\"Yardımcı\" önerilerde bulunur"},
	{"45", "İnsanlığa Karşı Kartlar", "Bütün odayı bokla doldurur"},
	{"46", "İntihar Kralı", "Seni anında öldürür ve yere 10 pickup/collectible çıkartır"},
	{"47", "Kodesten Çık Kartı", "Odadaki tüm kapıları açar"},
	{"48", "? Kartı", "Aktif itemini ücretsiz aktive eder"},
	{"49", "Zar Parçası", "Odadaki itemleri ve pickupları değiştirir"},
	{"50", "Acil Durum Kişisi", "İki tane annenin eli gelir ve düşmanı alır"},
	{"51", "Kutsal Kart", "Grants the Holy Mantle effect for one room#(Next damage you take is 0)#25% Chance to spawn another holy card"},
	{"52", "Büyük Gelişme", "↑ +7 Hasar#↑ +30 Menzil#↑ +Boy artar#Taşları kır!#:Efekt oda boyunca sürer"},
	{"53", "Antik Hatıra", "3 Rastgele kart çıkartır"},
	{"54", "Era Yürüyüşü", "Düşmanları yavaşlatır#↓ -0.5 Hız azalır#-1 Gözyaşı hızı azalır#Efekt oda boyunca sürer"},
}

---------- Pills ----------
EID.descriptions[languageCode].unidentifiedPill = "Tanımlanmamış Hap"

EID.descriptions[languageCode].pills={
	{"0", "Kötü Gaz", "Gaz bulutu çıkartır"},
	{"1", "Kötü Kafa", "Sana 1 kalp hasar verir"},
	{"2", "Çelik Taşaklar", "+2 Ruh Kalbi"},
	{"3", "Bombalar Anahtar", "Switches number of bombs with keys"},
	{"4", "Patlayıcı İshal", "Bulunduğun yerde 5 troll bombası çıkartır"},
	{"5", "Full Can", "Full can"},
	{"6", "Can Azalt", "↓ HP azalır"},
	{"7", "Can Arttır", "↑ HP"},
	{"8", "Hap Buldum", "Efekt yok"},
	{"9", "Ergenlik", "3 Tane kullanmak Olgun tranformastonunu sağlar (+1 Red Heart)"},
	{"10", "Güzel Sinek", "1 Mavi sinek"},
	{"11", "Range Down", "↓ -2 Range down"},
	{"12", "Range Up", "↑ +2.5 Range up"},
	{"13", "Hız Azalt", "↓ -0.12 Hız azalır"},
	{"14", "Hız Arttır", "↑ +0.15 Hız"},
	{"15", "Gözyaşı Azalt", "↓ -0.28 Gözyaşı azalır"},
	{"16", "Gözyaşı Arttır", "↑ +0.35 Gözyaşı"},
	{"17", "Şans Azalt", "↓ -1 Şans azalır"},
	{"18", "Şans Arttır", "↑ +1 Şans"},
	{"19", "Işınhap", "Rastgele bir odaya ışınlar"},
	{"20", "48 Saatlik Enerji!", "Aktif itemini doldurur#1-2 pil düşürür"},
	{"21", "Kan Kusma", "Biri dışında bütün kalpleri boşaltır#1-4 kırmızı kalp düşürür"},
	{"22", "Paraliz", "2 Saniye hareket edemezsin"},
	{"23", "Sonsuzluğu Görüyorum!", "Kattaki gizli oda kapılarını açar"},
	{"24", "Feromon", "Odadaki tüm düşmanları aşık eder"},
	{"25", "Amnezya", "Kat haritasını gizler"},
	{"26", "Limon Partisi", "Yerde düşmanlara hasar veren büyük sarı bir havuz bırakır"},
	{"27", "Sen Büyücü Müsün?", "30 Saniye çapraz ateş et"},
	{"28", "Artılar!", "Oda için sadece yarım kalp hasar al"},
	{"29", "Bağımlı!", "Oda için sadece tam kalp hasar al"},
	{"30", "Rahatla", "2 Saniye yürümek bok çıkmasına sebep olur"},
	{"31", "???", "Kat için labirent laneti efekti"},
	{"32", "Büyütür", "Büyürsün#Hitboxına etki etmez"},
	{"33", "Küçültür", "Küçülürsün#Hitboxın da küçülür"},
	{"34", "Enfeksiyonlandın!", "Odadaki her bok için 1 mavi sinek çıkartır"},
	{"35", "Enfeksiyonlandın?", "Odadaki her düşman için 1 mavi örümcek çıkartır#Odada düşman yok ise 1-3 mavi örümcek çıkartır"},
	{"36", "Güç Hapı!", "Kısa süreli dokunulmazlık efekti"},
	{"37", "Retro Görüş", "30 Saniyeliğine ekranı pikselleştirir"},
	{"38", "Sonuna Kadar Arkadaş!", "3 mavi sinek"},
	{"39", "X-Lax", "Kaygan sıvı havuzu bırakır"},
	{"40", "Bir yanlışlık var...", "Yavaşlatan sıvı havuzu bırakır"},
	{"41", "Başım dönüyor...", "Slow all enemies in room"},
	{"42", "Heyecanlıyım!!!", "Speed up for all enemies in room"},
	{"43", "Gulp!", "Trinketi yutar ve efektine kalıcı olarak sahip olur"},
	{"44", "Horf!", "Bir ipecac gözyaşı atar"},
	{"45", "Güneş Işığında Yürüyorum!", "Kısa süreli dokunulmazlık efekti"},
	{"46", "Vurp!", "Son kullanılan hapı çıkartır"},
}

---------- Sacrifice Room ----------
EID.descriptions[languageCode].sacrificeHeader = "[Sonraki feda odası ödülü]"

EID.descriptions[languageCode].sacrifice={
	{"1", "", "50% ihtimal ile 1 Altın#100% ihtimal ile 1 Bomba, B1de iken 1dk altında boss öldürüldüğünde"},
	{"2", "", "50% ihtimal ile 1 Altın#100% ihtimal ile 1 Bomba, B1de iken 1dk altında boss öldürüldüğünde"},
	{"3", "", "67% ihtimal ile arttırışmış Melek{{AngelRoom}} odası şansı"},
	{"4", "", "50% ihtimal ile 1 rastgele Kasa"},
	{"5", "", "33% ihtimal ile 3 Altın#67% ihtimal ile arttırışmış Melek{{AngelRoom}} odası şansı"},
	{"6", "", "33% ihtimal ile Melek{{AngelRoom}}/Şeytan{{DevilRoom}} Odasına ışınlan#67% ihtimal ile rastgele Kasa"},
	{"7", "", "33% ihtimal ile 1 rastgele Melek{{AngelRoom}} Odası itemi#67% ihtimal ile 1 ruh kalbi"},
	{"8", "", "100% ihtimal ile 7 troll Bombası"},
	{"9", "", "100% ihtimal ile \"Uriel\" bossunu çıkart"},
	{"10", "", "50% ihtimal ile 7 Ruh Kalbi#50% ihtimal ile 30 Altın"},
	{"11", "", "100% ihtimal ile \"Gabriel\" bossunu çıkart"},
	{"12", "", "50% ihtimal ile \"Dark Room\" katına ışınla"},
}

---------- Dice Room ----------
EID.descriptions[languageCode].diceHeader = "[Zar efekti]"

EID.descriptions[languageCode].dice={
	{"1", "", "Tüm itemlerini değiştirir#(sadece toplanabilir itemleri etkiler)"},
	{"2", "", "Odadaki tüm pickupları değiştir"},
	{"3", "", "Kattaki tüm pickupları değiştir"},
	{"4", "", "Kattaki tüm itemleri değiştir#Şeytan anlaşmasını etkilemez"},
	{"5", "", "Kattaki değiştir ve tekrar başlat"},
	{"6", "", "Kattaki tüm pickupları ve itemleri, üzerindeki itemleri değiştir"},
}

---------- Transformations ----------
EID.descriptions[languageCode].transformations={
	"",					-- 0 = none
	"Şerbet",			-- 1
	"Eğlenceli",		-- 2
	"Sinek Tanrısı",	-- 3
	"Tek Parça",		-- 4
	"Kafalar",			-- 5
	"Anne",				-- 6
	"Bok",				-- 7
	"Amca Bey",			-- 8
	"Leviathan",		-- 9
	"Seraphim",			-- 10
	"Süper Evsiz",		-- 11
	"Kitap Kurdu",		-- 12
	"Örümcek Bebek",	-- 13
	"Yetişkin",			-- 14
	"Stompy"			-- 15
}
