---------------------------------------
-----  Basic English descriptions -----
---------------------------------------

-- FORMAT: Item ID | Name | Description

-- Special character markup:
-- ↑ = Up Arrow  |  ↓ = Down Arrow  |  ! = Warning  |  # = Starts a new line
-- More can be found here: https://github.com/wofsauge/External-Item-Descriptions/wiki/Markup

local languageCode = "en_us"

-- init en_us table
EID.descriptions[languageCode] = {}
EID.descriptions[languageCode].custom = {} -- table for custom entity descriptions
EID.descriptions[languageCode].languageName = "English"

-- Fonts to be used with this language pack
EID.descriptions[languageCode].fonts = {{name="default"}, {name="inverted"}, {name="borderless"}}


---------- Collectibles ----------
EID.descriptions[languageCode].collectibles={
	{"1", "The Sad Onion", "↑ {{Tears}} +0.7 Tears up"},
	{"2", "The Inner Eye", "Triple shot#↓ {{Tears}} Tears down"},
	{"3", "Spoon Bender", "Homing tears"},
	{"4", "Cricket's Head", "↑ {{Damage}} +0.5 Damage up#↑ {{Damage}} +50% Damage Multiplier"},
	{"5", "My Reflection", "Isaac's tears get a boomerang effect#↑ {{Range}} +1.5 Range up#↑ {{Shotspeed}} +0.6 Shot Speed up#↑ +1 Tear Height"},
	{"6", "Number One", "↑ {{Tears}} +1.5 Tears up#↓ {{Range}} -17.62 Range down#↑ +0.76 Tear Height"},
	{"7", "Blood of the Martyr", "↑ {{Damage}} +1 Damage up#{{Collectible34}} +50% Damage if Isaac has the Book of Belial or Devil Card effect active"},
	{"8", "Brother Bobby", "Fires normal tears#Deals 3.5 damage per tear"},
	{"9", "Skatole", "All fly enemies are friendly"},
	{"10", "Halo of Flies", "+2 fly orbitals#Blocks enemy projectiles"},
	{"11", "1up!", "↑ +1 life#Respawn with full health"},
	{"12", "Magic Mushroom", "↑ +1 Health up#{{Heart}} Full health#↑ {{Damage}} +0.3 Damage up#↑ {{Damage}} +50% Damage Multiplier#↑ {{Range}} +5.25 Range up#↑ {{Speed}} +0.3 Speed up#↑ +0.5 Tear Height#Size up"},
	{"13", "The Virus", "{{Poison}} Touching enemies poisons them#↓ {{Speed}} -0.1 Speed down#{{BlackHeart}} Poisoned enemies can drop Black Hearts"},
	{"14", "Roid Rage", "↑ {{Speed}} +0.6 Speed up#↑ {{Range}} +5.25 Range up#↑ +0.5 Tear Height"},
	{"15", "<3", "↑ {{Heart}} +1 Health up#{{Heart}} Full health"},
	{"16", "Raw Liver", "↑ {{Heart}} +2 Health up#{{Heart}} Full health"},
	{"17", "Skeleton Key", "{{Key}} +99 Keys"},
	{"18", "A Dollar", "{{Coin}} +99 coins"},
	{"19", "Boom!", "{{Bomb}} +10 Bombs"},
	{"20", "Transcendence", "Grants flight"},
	{"21", "The Compass", "Reveals icons on the map#Does not reveal the layout of the map"},
	{"22", "Lunch", "↑ {{Heart}} +1 Health up"},
	{"23", "Dinner", "↑ {{Heart}} +1 Health up"},
	{"24", "Dessert", "↑ {{Heart}} +1 Health up"},
	{"25", "Breakfast", "↑ {{Heart}} +1 Health up"},
	{"26", "Rotten Meat", "↑ {{Heart}} +1 Health up"},
	{"27", "Wooden Spoon", "↑ {{Speed}} +0.3 Speed up"},
	{"28", "The Belt", "↑ {{Speed}} +0.3 Speed up"},
	{"29", "Mom's Underwear", "↑ {{Range}} +5.25 Range up#↑ +0.5 Tear Height"},
	{"30", "Mom's Heels", "↑ {{Range}} +5.25 Range up#↑ +0.5 Tear Height"},
	{"31", "Mom's Lipstick", "↑ {{Range}} +5.25 Range up#↑ +0.5 Tear Height"},
	{"32", "Wire Coat Hanger", "↑ {{Tears}} +0.7 Tears up"},
	{"33", "The Bible", "Grants flight for the current room#{{MomsHeart}} Kills Mom's Foot and Mom's Heart instantly#{{Warning}} Kills Isaac when used on Satan"},
	{"34", "The Book of Belial", "↑ {{Damage}} +2 Damage up#{{Collectible7}} +50% Damage if Isaac has Blood of the Martyr#{{AngelDevilChance}} +12.5% Devil/Angel Room chance while held"},
	{"35", "The Necronomicon", "Deals 40 damage to all enemies in the room"},
	{"36", "The Poop", "Spawns one poop and knocks back enemies#Can be placed next to a pit and destroyed with a bomb to make a bridge"},
	{"37", "Mr. Boom", "Drops a large bomb below Isaac which deals 110 damage"},
	{"38", "Tammy's Head", "Fires 10 tears in a circle around Isaac#The tears copy Isaac's tear effects, plus 25 damage"},
	{"39", "Mom's Bra", "Freezes all enemies in the current room for 4 seconds"},
	{"40", "Kamikaze!", "Causes an explosion at Isaac's location#Deals 40 damage"},
	{"41", "Mom's Pad", "{{Fear}} Fears all enemies in the current room for 5 seconds"},
	{"42", "Bob's Rotten Head", "Using the item and firing in a direction throws the head#{{Poison}} The head explodes where it lands and poisons enemies caught in the blast"},
	{"43", "", "<item does not exist>"},
	{"44", "Teleport!", "Teleports Isaac into a random room except I AM ERROR rooms"},
	{"45", "Yum Heart", "Heals 1 Red Heart"},
	{"46", "Lucky Foot", "↑ {{Luck}} +1 Luck up#+8% room clear reward chance#Better chance to win while gambling"},
	{"47", "Doctor's Remote", "{{Collectible168}} On use, start aiming a crosshair#A missile lands on the crosshair after 1.5 seconds#Deals 20x damage"},
	{"48", "Cupid's Arrow", "Piercing tears"},
	{"49", "Shoop da Whoop!", "Using the item and shooting in a direction fires a high damage Brimstone laser"},
	{"50", "Steven", "↑ {{Damage}} +1 Damage up"},
	{"51", "Pentagram", "↑ {{Damage}} +1 Damage up#{{AngelDevilChance}} +10% Devil/Angel Room chance"},
	{"52", "Dr. Fetus", "{{Bomb}} Isaac shoots bombs instead of tears#Each bomb deals 5x damage + 30#↓ {{Tears}} Tear Delay x 2.5"},
	{"53", "Magneto", "Pickups are attracted to Isaac"},
	{"54", "Treasure Map", "Reveals the floor layout#Does not reveal room icons"},
	{"55", "Mom's Eye", "50% chance to shoot a tear backwards#{{Luck}} 100% chance at 2 Luck"},
	{"56", "Lemon Mishap", "Spills a pool of creep#The creep deals 24 contact damage per second"},
	{"57", "Distant Admiration", "Mid-range fly orbital#Deals 75 contact damage per second"},
	{"58", "Book of Shadows", "Makes Isaac invincible for 10 seconds"},
	{"59", "", "<item does not exist>"},
	{"60", "The Ladder", "Allows Isaac to cross 1-tile gaps"},
	{"61", "", "<item does not exist>"},
	{"62", "Charm of the Vampire", "{{HalfHeart}} Killing 13 enemies heals half a heart"},
	{"63", "The Battery", "Active items can be charged up twice and used twice in a row"},
	{"64", "Steam Sale", "{{Shop}} Shop items cost 50% less#Owning two Steam Sales makes all paid items free"},
	{"65", "Anarchist Cookbook", "Spawns 6 troll bombs near the center of the room"},
	{"66", "The Hourglass", "{{Slow}} Slows enemies down for 8 seconds"},
	{"67", "Sister Maggy", "Shoots normal tears#Deals 3.5 damage per tear"},
	{"68", "Technology", "Isaac fires lasers instead of tears"},
	{"69", "Chocolate Milk", "{{Chargeable}} Chargeable tears#↑ {{Damage}} Fully charged tears deal 400% Damage#↓ {{Tears}} Tears down"},
	{"70", "Growth Hormones", "↑ {{Damage}} +1 Damage up#↑ {{Speed}} +0.4 Speed up"},
	{"71", "Mini Mush", "↑ {{Speed}} +0.3 Speed up#↓ {{Range}} -4.25 Range down*#↑ +1.5 Tear Height*#(*both add up to a slight Range up)#↑ Size down"},
	{"72", "Rosary", "{{SoulHeart}} +3 Soul Hearts#{{Collectible33}} The Bible is added to all item pools"},
	{"73", "Cube of Meat", "LVL1: Orbital#LVL2: Shooting orbital#LVL3: Meat Boy LVL1#LVL4: Meat Boy LVL2"},
	{"74", "A Quarter", "{{Coin}} +25 coins"},
	{"75", "PHD", "{{Pill}} Changes bad pills into good pills#Spawns 1 pill on pickup#{{Heart}} Heals 2 Red Hearts#{{BloodDonationMachine}} Blood Donation Machines and {{Collectible135}} IV Bag give more coins"},
	{"76", "X-Ray Vision", "{{SecretRoom}} Opens all secret room entrances"},
	{"77", "My Little Unicorn", "Makes Isaac invincible and grants +0.28 Speed up#Isaac deals 40 contact damage per second while invincible#{{Timer}} Effects last 6 seconds"},
	{"78", "Book of Revelations", "{{SoulHeart}} +1 Soul Heart#Higher Horseman boss chance if used#{{AngelDevilChance}} +17.5% Devil/Angel Room chance while held"},
	{"79", "The Mark", "↑ {{Damage}} +1 Damage up#↑ {{Speed}} +0.2 Speed up#{{SoulHeart}} +1 Soul Heart"},
	{"80", "The Pact", "↑ {{Damage}} +0.5 Damage up#↑ {{Tears}} +0.7 Tears up#{{SoulHeart}} +2 Soul Hearts"},
	{"81", "Dead Cat", "↑ +9 lives#Respawn with 1 HP#↓ Removes all Red Heart containers but one#{{Warning}} Characters that can't have Red Hearts get set to 1 Soul/Black Heart"},
	{"82", "Lord of the Pit", "Flight#↑ {{Speed}} +0.3 Speed up"},
	{"83", "The Nail", "{{SoulHeart}} +1 Soul Heart#↑ {{Damage}} +0.7 Damage up#↓ {{Speed}} -0.18 Speed down#Isaac deals 40 contact damage per second#Allows Isaac to destroy rocks by walking into them"},
	{"84", "We Need To Go Deeper!", "Opens a trapdoor to the next floor#{{LadderRoom}} 10% chance to open a crawlspace trapdoor"},
	{"85", "Deck of Cards", "{{Card}} Spawns 1 Card"},
	{"86", "Monstro's Tooth", "Monstro falls on an enemy and deals 120 damage#{{Warning}} Monstro falls on Isaac if the room has no enemies"},
	{"87", "Loki's Horns", "25% chance to shoot in 4 directions#{{Luck}} 100% chance at 7 Luck"},
	{"88", "Little Chubby", "Charges forward in the direction Isaac is shooting#Deals 52.5 contact damage per second"},
	{"89", "Spider Bite", "{{Slow}} 25% chance to shoot slowing tears#{{Luck}} 100% chance at 15 Luck"},
	{"90", "The Small Rock", "↑ {{Damage}} +1 Damage up#↑ {{Tears}} +0.2 Tears up#↓ {{Speed}} -0.2 Speed down"},
	{"91", "Spelunker Hat", "Reveals the room type of adjacent rooms#{{SecretRoom}} Can reveal Secret and Super Secret Rooms"},
	{"92", "Super Bandage", "↑ {{Heart}} +1 Health up#{{SoulHeart}} +2 Soul Hearts#{{Heart}} Heals 1 Red Heart"},
	{"93", "The Gamekid", "Grants invincibility#{{Fear}} Fears all enemies in the room#Isaac deals 40 contact damage per second#{{HalfHeart}} Killing 2 enemies replenishes half a heart#{{Timer}} Effect lasts for 6.5 seconds"},
	{"94", "Sack of Pennies", "{{Coin}} Drops a random coin every 2 rooms"},
	{"95", "Robo-Baby", "Shoots lasers#Deals 3.5 damage per shot"},
	{"96", "Little C.H.A.D.", "{{HalfHeart}} Drops half a heart every 3 rooms"},
	{"97", "The Book of Sin", "Spawns a random pickup"},
	{"98", "The Relic", "{{SoulHeart}} Spawns 1 Soul Heart every 5-6 rooms"},
	{"99", "Little Gish", "{{Slow}} Slowing tears#Deals 3.5 damage per shot"},
	{"100", "Little Steven", "Shoots homing tears#Deals 3.5 damage per shot"},
	{"101", "The Halo", "↑ {{Heart}} +1 Health up#↑ {{Damage}} +0.3 Damage up#↑ {{Tears}} +0.2 Tears up#↑ {{Range}} +0.25 Range up#↑ {{Speed}} +0.3 Speed up#↑ +0.5 Tear Height"},
	{"102", "Mom's Bottle of Pills", "{{Pill}} Spawns 1 Pill"},
	{"103", "The Common Cold", "{{Poison}} 25% chance to shoot Poison tears#{{Luck}} 100% chance at 12 Luck"},
	{"104", "The Parasite", "Tears split in two on contact#Split tears deal half damage"},
	{"105", "The D6", "Rerolls pedestal items in the current room"},
	{"106", "Mr. Mega", "↑ Bomb damage x2.25#{{Bomb}} +5 Bombs"},
	{"107", "The Pinking Shears", "Flight#Isaac's body separates from his head and attacks enemies with 82.5 contact damage per second"},
	{"108", "The Wafer", "Reduces all damage taken to half a heart"},
	{"109", "Money = Power", "↑ {{Damage}} +0.04 Damage up for every {{Coin}}coin Isaac has"},
	{"110", "Mom's Contacts", "20% chance to shoot petrifying tears#↑ +0.25 Range up#↑ +0.5 Tear Height"},
	{"111", "The Bean", "{{Poison}} Farts a poison cloud#The poison deals Isaac's damage 6 times"},
	{"112", "Guardian Angel", "Orbital#Speeds up all other orbitals#Blocks projectiles#Deals 105 contact damage per second"},
	{"113", "Demon Baby", "Shoots enemies that get close to him#Deals 3 damage per shot"},
	{"114", "Mom's Knife", "Isaac's tears are replaced by a throwable knife#The knife deals 2x Isaac's damage while held and 6x damage at the furthest possible distance"},
	{"115", "Ouija Board", "Spectral tears"},
	{"116", "9 Volt", "Automatically charges the first bar of active items#{{Battery}} Fully recharges the current active item"},
	{"117", "Dead Bird", "Getting hit spawns a bird#The bird deals 4 contact damage per second"},
	{"118", "Brimstone", "{{Chargeable}} Isaac's tears are replaced by a chargeable blood laser"},
	{"119", "Blood Bag", "↑ {{Heart}} +1 Health up#↑ {{Speed}} +0.3 Speed up#{{Heart}} Heals 4 Hearts"},
	{"120", "Odd Mushroom (Thin)", "↑ {{Tears}} +1.7 Tears up#↑ {{Speed}} +0.3 Speed up#↓ {{Damage}} -10% Damage Multiplier#↓ {{Damage}} -0.4 Damage down"},
	{"121", "Odd Mushroom (Large)", "↑ {{EmptyHeart}} +1 Empty heart container#↑ {{Damage}} +0.3 Damage up#↑ {{Range}} +0.25 Range up#↓ {{Speed}} -0.1 Speed down#↑ +0.5 Tear Height"},
	{"122", "Whore of Babylon", "When on half a Red Heart or less:#↑ {{Damage}} +1.5 Damage up#↑ {{Speed}} +0.3 Speed up"},
	{"123", "Monster Manual", "Spawns a random familiar for the current room"},
	{"124", "Dead Sea Scrolls", "Triggers a random active item effect"},
	{"125", "Bobby-Bomb", "Homing bombs#{{Bomb}} +5 Bombs"},
	{"126", "Razor Blade", "↑ {{Damage}} +1.2 Damage up for the current room#{{Warning}} Deals 1 heart of damage to Isaac#Removes Red Hearts first"},
	{"127", "Forget Me Now", "{{Warning}} SINGLE USE {{Warning}}#Rerolls and restarts the entire floor"},
	{"128", "Forever Alone", "Long range fly orbital#Deals 30 contact damage per second"},
	{"129", "Bucket of Lard", "↑ +2 Empty heart container#↓ -0.2 Speed down#Heals half a heart"},
	{"130", "A Pony", "Grants flight while held#{{Speed}} Sets your Speed to at least 1.5#Using the item dashes in the direction of Isaac's movement"},
	{"131", "Bomb Bag", "{{Bomb}} Drops 1 Bomb pickup every 2-3 rooms"},
	{"132", "A Lump of Coal", "{{Damage}} Tears deal more damage the further they travel"},
	{"133", "Guppy's Paw", "Converts 1 heart container into 3 Soul Hearts"},
	{"134", "Guppy's Tail", "{{Chest}} 33% chance to replace the room clear reward with a chest#33% chance to spawn no room clear reward"},
	{"135", "IV Bag", "Hurts Isaac for half a heart and spawns 1-3 coins#{{Player14}} Spawns 0-1 coin as Keeper"},
	{"136", "Best Friend", "Spawns a decoy Isaac that attracts enemies and explodes after 5 seconds"},
	{"137", "Remote Detonator", "{{Bomb}} +5 bombs#Isaac's bombs no longer explode automatically#Using the item detonates all of Isaac's bombs at once"},
	{"138", "Stigmata", "↑ +1 Health up#↑ {{Damage}} +0.3 Damage up"},
	{"139", "Mom's Purse", "{{Trinket}} Isaac can hold 2 trinkets"},
	{"140", "Bob's Curse", "{{Poison}} Isaac's bombs poison enemies caught in the blast#{{Bomb}} +5 bombs"},
	{"141", "Pageant Boy", "{{Coin}} Spawns 7 random coins"},
	{"142", "Scapular", "{{SoulHeart}} Isaac gains 1 Soul Heart when damaged down to half a heart#Can only happen once per room#Exiting and re-entering the room allows the effect to trigger again"},
	{"143", "Speed Ball", "↑ {{Speed}} +0.3 Speed up#↑ {{Shotspeed}} +0.2 Shot Speed up"},
	{"144", "Bum Friend", "{{Coin}} Picks up coins and spawns random pickups in return"},
	{"145", "Guppy's Head", "Spawns 2-4 blue flies"},
	{"146", "Prayer Card", "{{EternalHeart}} +1 Eternal Heart"},
	{"147", "Notched Axe", "Allows Isaac to break rocks and Secret Room walls by walking into them"},
	{"148", "Infestation", "Taking damage spawns blue flies"},
	{"149", "Ipecac", "Isaac's tears are fired in an arc#{{Poison}} The tears explode and poison enemies where they land#↑ {{Damage}} +40 Damage up#↓ {{Tears}} Tears down"},
	{"150", "Tough Love", "10% chance to shoot teeth#{{Damage}} Teeth deal 3.2x Isaac's damage#{{Luck}} 100% chance at 9 Luck"},
	{"151", "The Mulligan", "Hitting an enemy with a tear has a 1/6 chance to spawn a fly"},
	{"152", "Technology 2", "Replaces Isaac's right eye tears with a continuous laser#Laser deals 20% of Isaac's damage#↓ {{Damage}} -35% Damage down#↓ {{Tears}} Tear Delay x 2"},
	{"153", "Mutant Spider", "Isaac fires 4 tears at once#↓ {{Tears}} Tears down"},
	{"154", "Chemical Peel", "↑ {{Damage}} +2 Damage up for the left eye"},
	{"155", "The Peeper", "Floats around the room#Deals 17.1 contact damage per second"},
	{"156", "Habit", "{{Battery}} Taking damage adds 1 charge to the active item"},
	{"157", "Bloody Lust", "↑ {{Damage}} Taking damage grants a damage up#Applies up to 6 times per floor#Lasts for the whole floor"},
	{"158", "Crystal Ball", "Reveals the map#Drops a Card or a Soul Heart"},
	{"159", "Spirit of the Night", "Flight#Spectral tears"},
	{"160", "Crack the Sky", "Spawns 5 beams of light near enemies#Deals Isaac's damage + 20"},
	{"161", "Ankh", "{{Player4}} Respawn as ??? (Blue Baby) on death"},
	{"162", "Celtic Cross", "Taking damage can make Isaac temporarily invincible"},
	{"163", "Ghost Baby", "Spectral tears familiar#Deals 3.5 damage per shot"},
	{"164", "The Candle", "Throws a blue flame#The flame deals contact damage, blocks enemy tears, and despawns after 2 seconds"},
	{"165", "Cat-o-nine-tails", "↑ {{Damage}} +1 Damage up#↑ {{Shotspeed}} +0.23 Shot speed up"},
	{"166", "D20", "Rerolls all pickups in the room"},
	{"167", "Harlequin Baby", "Shoots two tears in a V-shaped pattern#Deals 4 damage per shot"},
	{"168", "Epic Fetus", "Instead of tears, aim a crosshair#A rocket lands on the crosshair after 1.5 seconds#Rockets deal 20 times Isaac's damage"},
	{"169", "Polyphemus", "↑ {{Damage}} +100% Damage up#↑ {{Damage}} +4 additional Damage up#↓ {{Tears}} Tears down#Tears keep going after killing an enemy"},
	{"170", "Daddy Longlegs", "Randomly stomps on an enemy#Deals 40 damage per second"},
	{"171", "Spider Butt", "Slows down enemies for 4 seconds#Deals 10 damage to all enemies"},
	{"172", "Sacrificial Dagger", "Orbital#Blocks enemy shots#Deals 225 damage per second"},
	{"173", "Mitre", "{{SoulHeart}} Higher chance to find Soul Hearts"},
	{"174", "Rainbow Baby", "Shoots random tears#Deals 3-5 damage per shot"},
	{"175", "Dad's Key", "Opens all doors in the room, including {{SecretRoom}}{{SuperSecretRoom}}Secret Rooms, {{ChallengeRoom}}{{BossRushRoom}}Challenge Rooms, and the Mega Satan door"},
	{"176", "Stem Cells", "↑ {{Heart}} +1 Health up#↑ {{Shotspeed}} +0.16 Shot Speed up"},
	{"177", "Portable Slot", "Portable slot machine#Spend 1 coin for a chance to spawn a pickup"},
	{"178", "Holy Water", "Taking damage spills a pool of creep#The creep deals 24 damage per second"},
	{"179", "Fate", "Flight#{{EternalHeart}} +1 Eternal Heart"},
	{"180", "The Black Bean", "Isaac farts when touched"},
	{"181", "White Pony", "Grants flight while held#{{Speed}} Sets your Speed to at least 1.5#Using the item dashes in the direction of Isaac's movement, leaving behind beams of light"},
	{"182", "Sacred Heart", "↑ +1 Health up#{{Heart}} Full health#↑ 230% + 1 Damage up#↓ -0.4 Tears down#↓ -0.25 Shot Speed down#↑ +0.38 Range up#↑ +0.75 Tear Height#Homing tears"},
	{"183", "Tooth Picks", "↑ {{Tears}} +0.7 Tears up#↑ {{Shotspeed}} +0.16 Shot Speed up"},
	{"184", "Holy Grail", "Flight#↑ +1 Health up"},
	{"185", "Dead Dove", "Flight#Spectral tears"},
	{"186", "Blood Rights", "Deals 40 damage to every enemy#{{Warning}} Deals 1 heart of damage to Isaac#Removes Red Hearts first"},
	{"187", "Guppy's Hairball", "Moving swings the hairball around#The ball grows when it kills an enemy#The ball deals more damage the bigger it is"},
	{"188", "Abel", "Mirrors Isaac's movement#Shoots towards Isaac#Deals 3.5 damage per shot"},
	{"189", "SMB Super Fan", "↑ +1 Health up#{{Heart}} Full health#↑ +0.3 Damage up#↑ +0.2 Tears up#↑ +0.5 Range up#↑ +0.2 Speed up#↑ +1 Tear Height"},
	{"190", "Pyro", "{{Bomb}} +99 Bombs"},
	{"191", "3 Dollar Bill", "Isaac's tears get random effects every 2-3 seconds"},
	{"192", "Telepathy For Dummies", "Grants homing tears for the current room"},
	{"193", "MEAT!", "↑ {{Heart}} +1 Health up#↑ {{Damage}} +0.3 Damage up"},
	{"194", "Magic 8 Ball", "↑ {{Shotspeed}} +0.16 Shot speed up#{{Card}} +1 card"},
	{"195", "Mom's Coin Purse", "{{Pill}} Drops 4 Pills"},
	{"196", "Squeezy", "{{SoulHeart}} Spawns 2 Soul Hearts#↑ {{Tears}} +0.4 Tears up"},
	{"197", "Jesus Juice", "↑ {{Damage}} +0.5 Damage up#↑ {{Range}} +0.25 Range up#↑ +0.5 Tear Height"},
	{"198", "Box", "Spawns 1 pickup of each type"},
	{"199", "Mom's Key", "{{Key}} +2 Keys#Chests contain more pickups"},
	{"200", "Mom's Eyeshadow", "{{Charm}} 10% chance to shoot charming tears"},
	{"201", "Iron Bar", "↑ {{Damage}} +0.3 Damage up#{{Confusion}} 10% chance to shoot concussive tears"},
	{"202", "Midas' Touch", "Touching enemies turns them gold#Isaac deals contact damage based on his coin count#{{Coin}} Killing a golden enemy drops coins#Poop spawned by Isaac has a high chance to be Golden Poop"},
	{"203", "Humbleing Bundle", "Pickups spawned are doubled if possible"},
	{"204", "Fanny Pack", "Taking damage has a 50% chance to drop a random pickup"},
	{"205", "Sharp Plug", "{{Battery}} Using an uncharged active item fully recharges it at the cost of 2 Hearts#Only works when item has no charges"},
	{"206", "Guillotine", "↑ {{Damage}} +1 Damage up#↑ {{Tears}} Tears up#Isaac's head becomes an orbital that shoots, doesn't take damage and deals 105 contact damage"},
	{"207", "Ball of Bandages", "LVL1: Orbital#LVL2: Shooting orbital#LVL3: Bandage Girl LVL1#LVL4: Bandage Girl LVL2"},
	{"208", "Champion Belt", "↑ {{Damage}} +1 Damage up#+15% chance for champion enemies"},
	{"209", "Butt Bombs", "{{Bomb}} +5 Bombs#{{Confusion}} Explosions concuss and damage every enemy in the room"},
	{"210", "Gnawed Leaf", "Standing still for 1 second makes Isaac invincible"},
	{"211", "Spiderbaby", "Taking damage spawns 1-2 blue spiders"},
	{"212", "Guppy's Collar", "50% chance to revive with half a heart on death"},
	{"213", "Lost Contact", "Isaac's tears destroy enemy shots#↓ {{Shotspeed}} -0.15 Shot Speed down"},
	{"214", "Anemic", "↑ {{Range}} +5 Range up#Taking damage spills a trail of toxic blood for the duration of the room"},
	{"215", "Goat Head", "{{AngelDevilChance}} 100% chance for Devil/Angel Rooms to open"},
	{"216", "Ceremonial Robes", "↑ {{Damage}} +1 Damage up#{{BlackHeart}} +3 Black Hearts"},
	{"217", "Mom's Wig", "Shooting tears has a random chance to spawn a blue spider#{{Heart}} Heals 1 Red Heart"},
	{"218", "Placenta", "↑ {{Heart}} +1 Health up#{{HalfHeart}} Chance to heal half a heart every minute"},
	{"219", "Old Bandage", "↑ {{EmptyHeart}} +1 Empty heart container#{{Heart}} Taking damage has a random chance to drop a Red Heart"},
	{"220", "Sad Bombs", "Isaac's bombs fire 10 tears in a circle when they explode#{{Bomb}} +5 Bombs"},
	{"221", "Rubber Cement", "Isaac's tears bounce off enemies and obstacles"},
	{"222", "Anti-Gravity", "Holding the fire buttons causes tears to hover in midair#Releasing the fire buttons shoots them in the direction they were fired#↑ {{Tears}} -2 Tear Delay"},
	{"223", "Pyromaniac", "Getting hit by explosions heals 1 Red Heart instead of damaging Isaac#Grants immunity to rock wave attacks and Mom and Satan's stomp attacks#{{Bomb}} +5 Bombs"},
	{"224", "Cricket's Body", "Tears split up in 4 on hit#Split tears deal half damage#↑ {{Tears}} +1 Tears up#↓ {{Range}} -10 Range down"},
	{"225", "Gimpy", "{{SoulHeart}} Taking damage has a chance to spawn a Soul Heart#{{HalfHeart}} Enemies have a chance to drop a Half Red Heart on death"},
	{"226", "Black Lotus", "↑ {{Heart}} +1 Health up#{{SoulHeart}} +1 Soul Heart#{{BlackHeart}} +1 Black Heart"},
	{"227", "Piggy Bank", "{{Coin}} +3 coins#Taking damage spawns 1-2 coins#{{Player14}} 0-1 coin as Keeper"},
	{"228", "Mom's Perfume", "{{Fear}} 15% chance to shoot Fear tears#↑ {{Tears}} +1 Tears up"},
	{"229", "Monstro's Lung", "{{Chargeable}} Tears are charged and released in a shotgun style attack#↓ {{Tears}} 4.3x Tear Delay up"},
	{"230", "Abaddon", "↑ {{Damage}} +1.5 Damage up#↑ {{Speed}} +0.2 Speed up#{{Fear}} Fear tears#↓ {{EmptyHeart}} Removes all heart containers#{{BlackHeart}} +6 Black Hearts"},
	{"231", "Ball of Tar", "{{Slow}} 10% chance to shoot slowing tears#{{Luck}} 100% chance at 18 Luck#Isaac leaves a trail of slowing creep"},
	{"232", "Stop Watch", "{{Slow}} Taking damage slows all enemies in the room permanently#↑ +0.3 Speed up"},
	{"233", "Tiny Planet", "Isaac's tears orbit around him#↑ {{Range}} Range way up#↑ +7 Tear Height#Spectral tears"},
	{"234", "Infestation 2", "Killing an enemy spawns a blue spider"},
	{"235", "", "<item does not exist>"},
	{"236", "E. Coli", "Touching an enemy turns it into poop"},
	{"237", "Death's Touch", "↑ {{Damage}} +1.5 Damage up#↑ Tear size up#↓ {{Tears}} -0.3 Tears down#Piercing tears"},
	{"238", "Key Piece 1", "{{Warning}} Getting both parts of the key opens a big golden door#{{AngelChance}} 25% higher Angel Room chance#{{EternalHeart}} +2% chance for Eternal Hearts"},
	{"239", "Key Piece 2", "{{Warning}} Getting both parts of the key opens a big golden door#{{AngelChance}} 25% higher Angel Room chance#{{EternalHeart}} +2% chance for Eternal Hearts"},
	{"240", "Experimental Treatment", "All Stats ↑/↓ a random number"},
	{"241", "Contract from Below", "Doubles all room clear rewards#33% chance for no room clear reward#{{GreedMode}} Doesn't affect Greed Mode"},
	{"242", "Infamy", "50% chance to block tears"},
	{"243", "Trinity Shield", "Blocks enemy shots coming from the direction Isaac is firing"},
	{"244", "Tech.5", "Occasionally fire lasers in addition to Isaac's tears"},
	{"245", "20/20", "Isaac fires 2 tears at once"},
	{"246", "Blue Map", "{{SecretRoom}} Reveals secret room locations on the map"},
	{"247", "BFFS!", "Familiars deal double damage"},
	{"248", "Hive Mind", "Blue Spiders and Flies deal double damage"},
	{"249", "There's Options", "Allows Isaac to choose between 2 items after beating a boss"},
	{"250", "Bogo Bombs", "{{Bomb}} All bomb drops become double bombs"},
	{"251", "Starter Deck", "{{Card}} Isaac can carry 2 Cards#Turns all Pills into Cards#Spawns 1 card on pickup"},
	{"252", "Little Baggy", "{{Pill}} Isaac can carry 2 Pills#Turns all Cards into Pills#Spawns 1 pill on pickup"},
	{"253", "Magic Scab", "↑ {{Luck}} +1 Luck up#↑ {{Heart}} +1 Health up"},
	{"254", "Blood Clot", "↑ {{Damage}} +1 Damage up#↑ {{Range}} +5 Range up#Applies to the left eye only"},
	{"255", "Screw", "↑ {{Tears}} +0.5 Tears up#↑ {{Shotspeed}} +0.2 Shot Speed up"},
	{"256", "Hot Bombs", "{{Burning}} Isaac's bombs leave a flame where they explode#{{Bomb}} +5 Bombs"},
	{"257", "Fire Mind", "{{Burning}} Isaac's tears light enemies on fire#Chance for tears to explode on enemy impact#{{Luck}} 100% chance to explode at 13 Luck#{{Warning}} The explosion can hurt Isaac"},
	{"258", "Missing No.", "Rerolls all of Isaac's items and stats on pickup and at every new floor"},
	{"259", "Dark Matter", "↑ {{Damage}} +1 Damage up#{{Fear}} 33% chance to shoot Fear tears#{{Luck}} 100% chance at 20 Luck"},
	{"260", "Black Candle", "{{CurseBlind}} Grants immunity to curses#{{BlackHeart}} +1 Black Heart#{{AngelDevilChance}} +15% Devil/Angel Room chance"},
	{"261", "Proptosis", "↑ {{Damage}} +100% Damage up#↓ Tears deal less Damage the further they travel"},
	{"262", "Missing Page 2", "{{BlackHeart}} +1 Black Heart#Taking damage down to 1 heart damages all enemies in the room"},
	{"263", "", "<item does not exist>"},
	{"264", "Smart Fly", "Orbital#Attacks enemies when Isaac takes damage#Deals 22.5 damage per second"},
	{"265", "Dry Baby", "10% chance to damage all enemies in the room when it is hit by an enemy tear"},
	{"266", "Juicy Sack", "Leaves slowing creep#Spawns 1-2 friendly spiders after clearing a room"},
	{"267", "Robo-Baby 2.0", "Shoots lasers#Deals 3.5 damage per shot#Moves in the direction Isaac is firing"},
	{"268", "Rotten Baby", "Spawns blue flies when Isaac shoots"},
	{"269", "Headless Baby", "Leaves creep which deals 6 damage per second"},
	{"270", "Leech", "Chases enemies#{{HalfHeart}} Heals Isaac for half a heart when it kills an enemy#Deals 3.2 damage per second"},
	{"271", "Mystery Sack", "Drops a random pickup every few rooms"},
	{"272", "BBF", "Friendly exploding fly#The explosion deals 60 damage#{{Warning}} The explosion can hurt Isaac"},
	{"273", "Bob's Brain", "Dashes in the direction Isaac is shooting#Explodes when it hits an enemy#The explosion deals 60 damage and can hurt Isaac"},
	{"274", "Best Bud", "Taking damage spawns one midrange orbital for the room#The orbital deals 75 damage per second"},
	{"275", "Lil Brimstone", "{{Collectible118}} Familiar that charges and shoots a Brimstone laser#Deals 31.5 damage per second"},
	{"276", "Isaac's Heart", "Isaac becomes invincible#Spawns a heart familiar that follows Isaac#{{Warning}} If the heart familiar gets hit, Isaac takes damage"},
	{"277", "Lil Haunt", "Chases and fears enemies#Deals 4 damage per second"},
	{"278", "Dark Bum", "{{Heart}} Picks up Red Hearts from the floor#Spawns a Soul/Black Heart or spider for every 1.5 Red Hearts picked up"},
	{"279", "Big Fan", "Large orbital#Deals 30 damage per second"},
	{"280", "Sissy Longlegs", "Randomly spawns blue spiders while in hostile rooms"},
	{"281", "Punching Bag", "Decoy familiar#Enemies target him instead of Isaac"},
	{"282", "How to Jump", "Allows Isaac to jump over gaps and obstacles"},
	{"283", "D100", "Reroll all pickups and pedestal items in the room, and all of Isaac's passive items"},
	{"284", "D4", "Reroll all of Isaac's passive items"},
	{"285", "D10", "Reroll all enemies in the room"},
	{"286", "Blank Card", "Triggers the effect of the card Isaac holds without using it"},
	{"287", "Book of Secrets", "Activates one of these effects for the floor:#{{Collectible54}} Treasure Map#{{Collectible21}} Compass#{{Collectible246}} Blue Map"},
	{"288", "Box of Spiders", "Spawns 1-4 blue spiders"},
	{"289", "Red Candle", "Throws a red flame#The flame disappears when it has dealt damage or blocked shots 5 times"},
	{"290", "The Jar", "{{Heart}} Picking up Red Hearts while at full health stores up to 4 of them in the Jar#Using the item drops all stored hearts on the floor"},
	{"291", "Flush!", "Turns all non-boss enemies into poop#Instantly kills poop enemies and bosses"},
	{"292", "Satanic Bible", "{{BlackHeart}} +1 Black Heart"},
	{"293", "Head of Krampus", "Shoot brimstone lasers in all 4 directions"},
	{"294", "Butter Bean", "Knocks back nearby enemies and projectiles#10% chance to turn into the stronger {{Collectible484}}Wait What? when swapping it with a different active item and picking it up again"},
	{"295", "Magic Fingers", "Deals 2x Isaac's damage to all enemies#{{Warning}} Costs 1 coin to use"},
	{"296", "Converter", "Converts 2 Soul/Black Hearts into 1 Red Heart Container"},
	--NOTE FOR LOCALIZERS: There is code to highlight the text of your current floor
	--For it to work, only use line breaks or semicolons to separate floor details, and use the same order as English
	{"297", "Pandora's Box", "{{Warning}} SINGLE USE, spawns rewards based on floor:#B1: 2{{SoulHeart}}; B2: 2{{Bomb}} + 2{{Key}}#C1: Boss item; C2: B1+C1#D1: 4{{SoulHeart}}; D2: 20{{Coin}}#W1: 2 Boss items#W2: {{Collectible33}} The Bible#???/Void: Nothing#Sheol: Devil item + 1{{BlackHeart}}#Cathe: Angel item + 1{{EternalHeart}}#Dark Room: Unlocks {{Collectible523}} Moving Box; Chest: 1{{Coin}}"},
	{"298", "Unicorn Stump", "Invincibility and +0.28 speed up for 6 seconds#Doesn't grant contact damage"},
	{"299", "Taurus", "↓ {{Speed}} -0.3 Speed down#↑ {{Speed}} Slowly gain speed while in hostile rooms#At 2 speed, Isaac becomes invincible and deals contact damage#Afterwards, lose the Taurus speed boost for the room"},
	{"300", "Aries", "↑ {{Speed}} +0.25 Speed up#Touching enemies deals contact damage"},
	{"301", "Cancer", "{{SoulHeart}} +3 Soul Hearts#Taking damage reduces all future damage in the room to half a heart"},
	{"302", "Leo", "Isaac can destroy rocks by walking into them#Size up"},
	{"303", "Virgo", "Taking damage can make Isaac temporarily invincible#{{Luck}} 100% chance at 10 Luck#{{Pill}} Converts negative pills into positive ones"},
	{"304", "Libra", "+6 Coins, Keys, and Bombs#Balances Isaac's stats#Future stat changes will be spread across all stats"},
	{"305", "Scorpio", "{{Poison}} Poison tears"},
	{"306", "Sagittarius", "↑ {{Speed}} +0.2 Speed up#Piercing tears"},
	{"307", "Capricorn", "↑ {{Heart}} +1 Health up#↑ {{Damage}} +0.5 Damage up#↑ {{Speed}} +0.1 Speed up#↑ {{Range}} +1.5 Range up#↑ {{Tears}} Tears up#+1 Bomb, Coin, and Key"},
	{"308", "Aquarius", "Isaac leaves a trail of creep#The creep deals 6 damage per second"},
	{"309", "Pisces", "↑ {{Tears}} -1 Tear Delay#Increases knockback"},
	{"310", "Eve's Mascara", "↑ {{Damage}} +100% Damage up#↓ {{Tears}} -50% Tears down#↓ {{Shotspeed}} -0.5 Shot speed down"},
	{"311", "Judas' Shadow", "{{Player12}} When dead, respawn as Dark Judas with a 2x Damage Multiplier"},
	{"312", "Maggy's Bow", "↑ {{Heart}} +1 Health up#{{Heart}} Heals 1 Red Heart#All Red Hearts heal double their value"},
	{"313", "Holy Mantle", "Negates the first hit taken once per room"},
	{"314", "Thunder Thighs", "↑ {{Heart}} +1 Health up#↓ {{Speed}} -0.4 Speed down#Isaac can destroy rocks by walking into them"},
	{"315", "Strange Attractor", "Isaac's tears attract enemies, pickups and trinkets"},
	{"316", "Cursed Eye", "Charged wave of 4 tears#{{Warning}} Taking damage while partially charged teleports Isaac to a random room#{{Collectible260}} Black Candle removes the teleportation effect"},
	{"317", "Mysterious Liquid", "Isaac's tears leave creep#The creep deals 30 damage per second"},
	{"318", "Gemini", "Close combat familiar#Deals 6 contact damage per second"},
	{"319", "Cain's Other Eye", "Bounces around the room#Shoots towards Isaac#{{Damage}} Deals the same damage as Isaac"},
	{"320", "???'s Only Friend", "Controllable Fly#Deals 37.5 contact damage per second"},
	{"321", "Samson's Chains", "Draggable ball that can destroy rocks#Deals 10.7 contact damage per second"},
	{"322", "Mongo Baby", "Mimics one of Isaac's familiars#Deals double its damage"},
	{"323", "Isaac's Tears", "Shoots 8 tears in all directions#The tears copy Isaac's tear effects#Recharges by shooting tears"},
	{"324", "Undefined", "Teleports Isaac to the {{TreasureRoom}} Treasure, {{SecretRoom}} Secret, {{SuperSecretRoom}} Super Secret or {{ErrorRoom}} I AM ERROR Room"},
	{"325", "Scissors", "Isaac's head turns into a stationary familiar#The body is controlled separately"},
	{"326", "Breath of Life", "Holding down the USE button empties the charge bar#Isaac is temporarily invincible when the charge bar is empty#{{Warning}} Holding it for too long deals damage to Isaac"},
	{"327", "The Polaroid", "Taking damage at half a Red Heart or none makes isaac temporarily invincible"},
	{"328", "The Negative", "Taking damage at half a Red Heart or none damages all enemies in the room"},
	{"329", "The Ludovico Technique", "Replaces Isaac's tears with one giant controllable tear"},
	{"330", "Soy Milk", "↑ {{Tears}} Tears way up: (delay /4) - 2#↓ {{Damage}} Damage way down: -80%"},
	{"331", "Godhead", "Homing tears#↑ {{Damage}} +0.5 Damage up#↑ {{Range}} +1.2 Range up#↓ {{Tears}} -0.3 Tears down#↓ {{Shotspeed}} -0.3 Shot Speed down#↑ +0.8 Tear Height#Tears gain a damaging aura"},
	{"332", "Lazarus' Rags", "{{Player11}} When dead, revive as Lazarus (Risen)"},
	{"333", "The Mind", "Full mapping effect"},
	{"334", "The Body", "↑ {{Heart}} +3 Health up"},
	{"335", "The Soul", "{{SoulHeart}} +2 Soul Hearts#Grants an aura that repels enemies and projectiles"},
	{"336", "Dead Onion", "Piercing + spectral tears#↑ {{Range}} +0.25 Range up#↓ {{Shotspeed}} -0.4 Shot Speed down#↓ -0.5 Tear Height#↑ {{Tearsize}} +50% Tear size"},
	{"337", "Broken Watch", "Slows down every 4th room#13% chance to speed up the room instead"},
	{"338", "The Boomerang", "Throwable boomerang#Stuns enemies and deals 2x Isaac's damage#Can grab and bring back items"},
	{"339", "Safety Pin", "↑ {{Range}} +5.25 Range up#↑ {{Shotspeed}} +0.16 Shot Speed up#↑ +0.5 Tear Height#{{BlackHeart}} +1 Black Heart"},
	{"340", "Caffeine Pill", "↑ {{Speed}} +0.3 Speed up#↑ Size down#{{Pill}} Spawns a random pill"},
	{"341", "Torn Photo", "↑ {{Tears}} +0.7 Tears up#↑ {{Shotspeed}} +0.16 Shot Speed up"},
	{"342", "Blue Cap", "↑ {{Heart}} +1 Health up#↑ {{Tears}} +0.7 Tears up#↓ {{Shotspeed}} -16% Shot Speed down"},
	{"343", "Latch Key", "↑ {{Luck}} +1 Luck up#{{SoulHeart}} +1 Soul Heart#{{Key}} Spawns 2 keys"},
	{"344", "Match Book", "{{BlackHeart}} +1 Black Heart#{{Bomb}} Spawns 3 Bomb pickups"},
	{"345", "Synthoil", "↑ {{Damage}} +1 Damage up#↑ {{Range}} +5.25 Range up#↑ +0.5 Tear Height"},
	{"346", "A Snack", "↑ {{Heart}} +1 Health up"},
	{"347", "Diplopia", "{{Warning}} SINGLE USE {{Warning}}#Duplicates any pedestals and consumables in the current room"},
	{"348", "Placebo", "{{Pill}} Triggers the effect of the pill Isaac holds without using it"},
	{"349", "Wooden Nickel", "50% chance to spawn a random coin"},
	{"350", "Toxic Shock", "{{Poison}} Entering a room poisons all enemies#Enemies killed leave a puddle of creep"},
	{"351", "Mega Bean", "Freeze all enemies in the current room#Deals 5 damage and poisons any enemies nearby#Sends a rock wave in the direction Isaac is moving#The rock wave can open secret rooms and break rocks"},
	{"352", "Glass Cannon", "↓ Firing the cannon reduces Isaac's health down to half a heart#Fires a large piercing spectral tear that does 10x damage"},
	{"353", "Bomber Boy", "{{Bomb}} +5 bombs#Bombs explode in a cross-shaped pattern"},
	{"354", "Crack Jacks", "↑ {{Heart}} +1 Health up#{{Trinket}} Spawns a random trinket"},
	{"355", "Mom's Pearls", "↑ {{Range}} +1.25 Range up#↑ {{Luck}} +1 Luck up#↑ +0.5 Tear Height"},
	{"356", "Car Battery", "Using an active item triggers its effect twice"},
	{"357", "Box of Friends", "Duplicates all familiars for the current room#Spawns {{Collectible113}}Demon Baby if Isaac has no familiars"},
	{"358", "The Wiz", "Isaac fires 2 tears at once diagonally#Spectral tears"},
	{"359", "8 Inch Nails", "↑ {{Damage}} +1.5 Damage up#Increases knockback"},
	{"360", "Incubus", "Shoots tears with the same stats and effects as Isaac"},
	{"361", "Fate's Reward", "Shoots tears with the same damage and effects as Isaac#Shoots at half the rate of other familiars"},
	{"362", "Lil Chest", "Spawns a random pickup every few rooms"},
	{"363", "Sworn Protector", "Orbital#Deals 105 contact damage per second#Blocks and attracts bullets#Blocking 10 tears in one room drops an Eternal Heart"},
	{"364", "Friend Zone", "Midrange fly orbital#Deals 45 contact damage per second"},
	{"365", "Lost Fly", "Moves along walls/obstacles#Deals 105 contact damage per second"},
	{"366", "Scatter Bombs", "{{Bomb}} +5 bombs#Isaac's bombs scatter into 2-4 tiny bombs"},
	{"367", "Sticky Bombs", "{{Bomb}} +5 bombs#Killing an enemy with a bomb spawns blue spiders#Isaac's bombs stick to enemies"},
	{"368", "Epiphora", "Shooting in one direction gradually decreases tear delay by up to 200%"},
	{"369", "Continuum", "↑ {{Range}} +2.25 Range up#↑ +1.5 Tear Height#Spectral tears#Tears can travel through one side of the screen and come out the other side"},
	{"370", "Mr. Dolly", "↑ {{Tears}} +0.7 Tears up#↑ {{Range}} +5.25 Range up#↑ +0.5 Tear Height#{{UnknownHeart}} Spawns 3 random hearts when picked up"},
	{"371", "Curse of the Tower", "Taking damage spawns 6 troll bombs#The troll bombs inherit Isaac's bomb effects"},
	{"372", "Charged Baby", "Every 30 seconds while in an uncleared room, the familiar can:#Spawn a Battery (max 2 per room)#Add one charge to the active item (max 2 per room)#Freeze all enemies in the room"},
	{"373", "Dead Eye", "↑ {{Damage}} Consecutive tear hits on enemies grant +25% Damage up(max +100%)#Missing has a chance to reset the multiplier"},
	{"374", "Holy Light", "10% chance to shoot Holy tears, which spawn a beam of light on hit#The beam deals 4x Isaac's damage#{{Luck}} 50% chance at 9 Luck"},
	{"375", "Host Hat", "Grants immunity to explosions#Grants immunity to rock wave attacks and Mom and Satan's stomp attacks#25% chance to reflect enemy shots"},
	{"376", "Restock", "Spawns 3 random Pickups#Buying an item from a shop restocks it instantly"},
	{"377", "Bursting Sack", "Spider enemies no longer target or deal contact damage to Isaac"},
	{"378", "No. 2", "Firing tears for 3 seconds spawns a lit Butt Bomb"},
	{"379", "Pupula Duplex", "Isaac's tears get a much larger hitbox#Spectral tears"},
	{"380", "Pay To Play", "{{Coin}} +5 coins#Single-key doors must be opened with coins instead of keys"},
	{"381", "Eden's Blessing", "↑ {{Tears}} +0.7 Tears up#Grants a random item at the start of the next run"},
	{"382", "Friendly Ball", "Can be thrown at enemies to capture them#Using the item after capturing an enemy spawns the capture as a friendly companion"},
	{"383", "Tear Detonator", "Splits all of Isaac's tears currently on screen in a circle of 6 tears"},
	{"384", "Lil Gurdy", "{{Chargeable}} Launches and bounces around the room with speed based on charge amount#Deals 5-90 contact damage per second depending on speed"},
	{"385", "Bumbo", "Picks up nearby coins#Levels up after getting 6, 12, and 24 coins#LVL2: Chance to spawn item after room clears#LVL3: Fires tears that can drop coins on hit#LVL4: Chases enemies, occasionally dropping bombs, can spawn item on coin pickup"},
	{"386", "D12", "Rerolls any obstacle into another random obstacle (e.g. poop, pots, TNT, red poop, stone blocks etc.)"},
	{"387", "Censer", "Familiar surrounded by a huge aura of light that slows down enemies and projectiles in it"},
	{"388", "Key Bum", "Picks up keys and spawns random chests"},
	{"389", "Rune Bag", "{{Rune}} Drops a random rune every 5-6 rooms"},
	{"390", "Seraphim", "Fires Sacred Heart tears#Deals 10 damage per shot"},
	{"391", "Betrayal", "{{Charm}} Taking damage charms all enemies in the room"},
	{"392", "Zodiac", "Grants a random zodiac item effect every floor"},
	{"393", "Serpent's Kiss", "{{Poison}} 15% chance to shoot poison tears#{{Poison}} Poison enemies on contact#{{BlackHeart}} Poisoned enemies have a chance to drop a Black Heart on death"},
	{"394", "Marked", "Isaac automatically fires tears at a movable red target on the ground#↑ {{Tears}} +0.7 Tears up#↑ {{Range}} +3.15 Range up#↑ +0.3 Tear Height"},
	{"395", "Tech X", "{{Chargeable}} Isaac's tears are replaced by a chargeable laser ring#Ring size increases with charge time"},
	{"396", "Ventricle Razor", "Creates up to two portals to travel between#Can be placed in different rooms"},
	{"397", "Tractor Beam", "Isaac's tears always travel along a beam of light in front of him#↑ {{Tears}} +0.5 Tears up#↑ {{Range}} +5.25 Range up#↑ {{Shotspeed}} +0.16 Shot Speed up#↑ +0.5 Tear Height"},
	{"398", "God's Flesh", "Tears can shrink enemies#Shrunken enemies can be crushed and killed by walking over them"},
	{"399", "Maw of the Void", "↑ {{Damage}} +1 Damage up#{{Chargeable}} Firing tears for 3 seconds and releasing the fire button creates a black brimstone ring around Isaac#{{BlackHeart}} Enemies killed by the black ring have a chance to drop Black Hearts"},
	{"400", "Spear of Destiny", "Isaac holds a spear in front of him#The spear deals twice his damage and can fear enemies on contact"},
	{"401", "Explosivo", "25% chance to shoot sticky bomb tears#Sticky bomb tears do not deal damage on hit and explode after a few seconds"},
	{"402", "Chaos", "All items are chosen from random item pools#Spawns 1-6 random pickups"},
	{"403", "Spider Mod", "Displays tear damage and health bars of all enemies#Inflicts random status effects to enemies on contact#Randomly drops batteries"},
	{"404", "Farting Baby", "Blocks projectiles#When hit, 10% chance to fart and charm, poison or knockback enemies"},
	{"405", "GB Bug", "Bounces around the room#Deals 120 damage per second and applies random status effects to enemies on contact"},
	{"406", "D8", "Multiplies Isaac's damage, tears, range and speed stats by between 0.5x and 2x#The multipliers are rerolled each use"},
	{"407", "Purity", "↑ Boosts one of Isaac's stats depending on the color of the aura#Taking damage removes the effect, and gives Isaac a new effect in the next room#{{ColorRed}}Red{{CR}} = {{Damage}} +4 Damage#{{ColorBlue}}Blue{{CR}} = {{Tears}} -4 Tear Delay#{{ColorYellow}}Yellow{{CR}} = {{Speed}} +0.5 Speed up#{{ColorOrange}}Orange{{CR}} = {{Range}} +7.5 Range up, +1 Tear Height"},
	{"408", "Athame", "Taking damage creates a black brimstone ring around Isaac#{{BlackHeart}} Enemies killed by the ring have a chance to drop a Black Heart"},
	{"409", "Empty Vessel", "{{BlackHeart}} +2 Black Hearts#{{Blank}} When Isaac has no Red Hearts:#Grants flight#Every 40 seconds while in a hostile room, gain a shield for 10 seconds"},
	{"410", "Evil Eye", "3.33% chance to shoot an eye#The eye moves in a straight line and fires tears in the same direction as Isaac"},
	{"411", "Lusty Blood", "↑ {{Damage}} +0.5 Damage up for each enemy killed in the room#Caps at +5 Damage up after 10 kills"},
	{"412", "Cambion Conception", "Taking damage 15 times spawns a permanent demon familiar#After two familiars, it takes 30 instead of 15#Caps at 4 familiars"},
	{"413", "Immaculate Conception", "Picking up 15 hearts spawns a permanent angelic familiar#Caps at 5 familiars#If all familiars have been granted, spawns a Soul Heart instead"},
	{"414", "More Options", "{{TreasureRoom}} Allows Isaac to choose between 2 items in treasure rooms"},
	{"415", "Crown Of Light", "{{SoulHeart}} +2 Soul Hearts#{{Blank}} If Isaac has no damaged Red Heart containers:#↑ {{Damage}} +100% Damage up#↑ {{Range}} +5.25 Range up#↑ +0.5 Tear Height#↓ {{Shotspeed}} -0.3 Shot Speed down#{{Blank}}#Taking any damage removes the effect for the current room"},
	{"416", "Deep Pockets", "Allows Isaac to carry two cards/pills/runes"},
	{"417", "Succubus", "Bounces around the room surrounded by a damaging aura that deals 129% of Isaac's damage every second#↑ {{Damage}} +50% Damage while standing in the aura"},
	{"418", "Fruit Cake", "Each one of Isaac's tears gets a different effect"},
	{"419", "Teleport 2.0", "Teleports Isaac to a room that has not been cleared yet#Hierarchy: {{Room}}>{{BossRoom}}>{{SuperSecretRoom}}>{{Shop}}>{{TreasureRoom}}>{{SacrificeRoom}}> {{DiceRoom}}>{{Library}}>{{CursedRoom}}>{{MiniBoss}}>{{ChallengeRoom}}{{BossRushRoom}}>{{IsaacsRoom}}{{BarrenRoom}}> {{ArcadeRoom}}>{{ChestRoom}}>{{SecretRoom}}>{{DevilRoom}}{{AngelRoom}}>{{ErrorRoom}}"},
	{"420", "Black Powder", "Walking in a circle draws a pentagram on the floor, which deals 10 damage per tick"},
	{"421", "Kidney Bean", "{{Charm}} Charms and deals 5 damage to all enemies in close range"},
	{"422", "Glowing Hour Glass", "Brings Isaac back to the previous room and reverses all actions done in the room the item was used in"},
	{"423", "Circle of Protection", "Surrounds Isaac with a large halo that deals his damage on contact every second#Chance to reflect enemy projectiles"},
	{"424", "Sack Head", "Pickups have a 33% chance to be replaced with a sack#Spawns a sack"},
	{"425", "Night Light", "Spawns a slowing cone of light in front of Isaac"},
	{"426", "Obsessed Fan", "Mimics Isaac's exact movement on a 3 second delay#Deals 30 contact damage per second"},
	{"427", "Mine Crafter", "Spawns a pushable TNT barrel#Using the item a second time in the same room remotely detonates the barrel"},
	{"428", "PJs", "{{SoulHeart}} +4 Soul Hearts#Fully heals red hearts"},
	{"429", "Head of the Keeper", "{{Coin}} Hitting an enemy with a tear has a 5% chance to drop a Penny"},
	{"430", "Papa Fly", "Mimics Isaac's movement on a 1 second delay#Fires tears at nearby enemies that deal Isaac's damage"},
	{"431", "Multidimensional Baby", "Mimics Isaac's movement on a 2 second delay#Tears that pass through it are doubled and gain a speed boost"},
	{"432", "Glitter Bombs", "{{Bomb}} +5 bombs#Isaac's bombs have a 25% chance to drop a random pickup and a 15% chance to charm enemies when they explode"},
	{"433", "My Shadow", "Taking damage fears all enemies in the room and spawns a friendly black charger#The charger deals 5 damage per second"},
	{"434", "Jar of Flies", "Killing an enemy adds a blue fly to the Jar, up to 20 flies#Using the item releases all the flies"},
	{"435", "Lil Loki", "Shoots 4 tears in a cross pattern#Deals 3.5 damage per shot"},
	{"436", "Milk!", "{{Tears}} Taking damage grants a Tears up for the duration of the room"},
	{"437", "D7", "Restarts a room and respawns all enemies#Can be used to get multiple room clear rewards from a single room#If used after a Greed fight, rerolls the room into a normal Shop/Secret Room"},
	{"438", "Binky", "{{SoulHeart}} +1 Soul Heart#↑ {{Tears}} +0.75 Tears up#↑ Size down"},
	{"439", "Mom's Box", "{{Trinket}} Spawns a random trinket#While held, doubles trinket effects#↑ {{Luck}} +1 Luck while held"},
	{"440", "Kidney Stone", "Isaac occasionally stops firing and charges an attack that releases a burst of tears and a kidney stone#↓ -0.2 Speed down#↓ -17 Range down#↑ +2 Tear Height"},
	{"441", "Mega Blast", "Fires a huge Mega Satan laser for 15 seconds#The laser persists between rooms and floors"},
	{"442", "Dark Prince's Crown", "{{Blank}} While at 1 full Red Heart:#↑ {{Range}} +1.5 Range up#↑ {{Tears}} +0.75 Tears up#↑ {{Shotspeed}} +0.2 Shot Speed up#↑ +1 Tear Height#Does not work on characters without Red Hearts"}, -- Dark Princes Crown (apostrophe added to the name in Repentance)
	{"443", "Apple!", "Isaac sometimes fires razor blades which deal 400% damage#{{Luck}} 100% chance at 14 Luck#↑ {{Tears}} +0.3 Tears up"},
	{"444", "Lead Pencil", "Isaac fires a cluster of tears every 15 tears#Tears in the cluster deal double damage"},
	{"445", "Dog Tooth", "↑ {{Damage}} +0.3 Damage up#↑ {{Speed}} +0.1 Speed up#{{SecretRoom}} A wolf howls in rooms adjacent to a Secret/Super Secret Room#{{LadderRoom}} A dog barks in rooms with a crawlspace under a rock"},
	{"446", "Dead Tooth", "While firing, Isaac is surrounded by a green aura that poisons enemies"},
	{"447", "Linger Bean", "Firing without pause for 7.5 seconds spawns a poop cloud#The cloud deals Isaac's damage 5 times a second#The cloud lasts 15 seconds and can be moved by shooting it"},
	{"448", "Shard of Glass", "Upon taking damage:#{{Heart}} 25% chance to drop a Red Heart#{{Collectible214}} 10% chance to get ↑ +5 Range and leave a trail of blood creep for the current room"},
	{"449", "Metal Plate", "{{SoulHeart}} +1 Soul Heart#{{Confusion}} Enemy bullets have a 25% chance to be reflected as concussive tears"},
	{"450", "Eye of Greed", "Every 20 tears, Isaac shoots a coin tear that deals double damage#Enemies hit with the coin turn into gold#Killing a gold enemy drops 1-4 coins#Firing a coin tear costs 1 coin"},
	{"451", "Tarot Cloth", "{{Card}} Drops a card#{{Card}} Card effects are doubled"},
	{"452", "Varicose Veins", "Taking damage fires 10 tears in a circle around Isaac#The tears deal Isaac's damage + 25"},
	{"453", "Compound Fracture", "Tears shatter into 1-3 small bone shards upon hitting anything#↑ +1.5 Range up#↑ +1 Tear Height"},
	{"454", "Polydactyly", "Allows Isaac to carry 2 cards, runes or pills#Spawns a card, pill or rune on pickup"},
	{"455", "Dad's Lost Coin", "↑ {{Range}} +1.5 Range up#↑ +1 Tear Height#Spawns a lucky penny"},
	{"456", "Moldy Bread", "↑ {{Heart}} +1 Health up"},
	{"457", "Cone Head", "{{SoulHeart}} +1 Soul Heart#20% chance to negate damage taken"},
	{"458", "Belly Button", "{{Trinket}} Allows Isaac to carry 2 trinkets#{{Trinket}} Spawns a random trinket on pickup"},
	{"459", "Sinus Infection", "20% chance to shoot a sticky booger#Boogers deal Isaac's damage once a second and stick for 60 seconds"},
	{"460", "Glaucoma", "{{Confusion}} 5% chance to shoot concussive tears#Makes the screen slightly darker"},
	{"461", "Parasitoid", "15% chance to shoot egg sacks#{{Luck}} 50% chance at 5 Luck#Egg sacks spawn slowing creep and a blue spider or fly on hit"},
	{"462", "Eye of Belial", "↑ {{Range}} +1.5 Range up#↑ +1 Tear Height#Piercing tears#Hitting an enemy makes the tear homing and doubles its damage"},
	{"463", "Sulfuric Acid", "↑ {{Damage}} +0.3 Damage up#Isaac's tears can destroy rocks and open doors"},
	{"464", "Glyph of Balance", "{{SoulHeart}} +2 Soul Hearts#Champion enemies drop whatever pickup Isaac needs the most"},
	{"465", "Analog Stick", "↑ {{Tears}} +0.3 Tears up#Allows Isaac to fire tears in any direction"},
	{"466", "Contagion", "{{Poison}} The first enemy killed in a room explodes and poison all nearby enemies"},
	{"467", "Finger!", "{{Damage}} Constantly deals 10% of Isaac's damage in the direction it points"},
	{"468", "Shade", "Follows Isaac's movement on a 1 second delay#Deals 30 contact damage per second#After it deals 600 damage, it is absorbed by Isaac, increasing his contact damage"},
	{"469", "Depression", "Leaves a trail of creep#The creep deals 6 damage per second#Enemies that touch the cloud can be hit by a holy light beam"},
	{"470", "Hushy", "Bounces around the room#Deals contact damage#Stops moving when Isaac shoots#Blocks projectiles when stopped"},
	{"471", "Lil Monstro", "{{Chargeable}} Charges a shotgun attack similar to {{Collectible229}} Monstro's Lung#Each tear deals 3.5 damage"},
	{"472", "King Baby", "Other familiars follow it#Stops moving when Isaac shoots#Teleports back to Isaac when he stops shooting"},
	{"473", "Big Chubby", "Very slowly charges forwards#Blocks shots#Deals 40.5 contact damage per second"},
	{"474", "Tonsil", "Blocks enemy projectiles"},
	{"475", "Plan C", "{{Warning}} SINGLE USE {{Warning}}#Deals 9,999,999 damage to all enemies#Kills Isaac 3 seconds later"},
	{"476", "D1", "Duplicates 1 random pickup in the current room"},
	{"477", "Void", "Consumes all pedestal items in the room#Active items: Their effects activate, and will activate with every future use of Void#↑ Passive items: Grant two random stats up"},
	{"478", "Pause", "Freezes all enemies in the room until Isaac shoots#Touching a frozen enemy still deals damage to Isaac#Enemies unfreeze after 30 seconds"},
	{"479", "Smelter", "{{Trinket}} Consumes Isaac's held trinkets and grants their effects permanently#Increases the spawn rate of trinkets"},
	{"480", "Compost", "Converts pickups into blue flies or spiders#Doubles all blue flies and spiders#Spawns 1 blue fly or spider if Isaac has none"},
	{"481", "Dataminer", "↑ Random stat up#↓ Random stat down#Random tear effect for the room#Corrupts all sprites and music in the room"},
	{"482", "Clicker", "Changes your character to a random character#Removes the last item collected"},
	{"483", "Mama Mega!", "{{Warning}} SINGLE USE {{Warning}}#Affects the whole floor#Explodes all objects#Deals 200 damage to all enemies#Opens the door to Boss Rush, Hush and all secret rooms#Having a Golden Bomb when using the item consumes it and allows for another use of Mama Mega"},
	{"484", "Wait What?", "Upon use, pushes enemies away and spawns a rock wave around Isaac#The rock wave can open rooms and break rocks"},
	{"485", "Crooked Penny", "50% chance to double all items, consumables and chests in room#50% chance to remove items / pickups in room and spawn 1 coin"},
	{"486", "Dull Razor", "Hurts Isaac without removing health#Triggers any on-hit item effects"},
	{"487", "Potato Peeler", "Removes one Red Heart Container and grants: #↑ {{Damage}} +0.2 Damage up#{{Collectible73}} A Cube of Meat#↑ {{Range}} +5 Range and leave a trail of blood creep for the current room"},
	{"488", "Metronome", "Grants a random item effect for the current room"},
	{"489", "D Infinity", "Triggers a random dice effect each use"},
	{"490", "Eden's Soul", "{{Warning}} SINGLE USE {{Warning}}#Spawns 2 random items depending on the current room's item pool#Starts with no charges"},
	{"491", "Acid Baby", "{{Pill}} Drops a random pill every 3 rooms#{{Poison}} Using a pill poisons all enemies in the room"},
	{"492", "YO LISTEN!", "↑ {{Luck}} +1 Luck up#Highlights the location of {{SecretRoom}} secret rooms, tinted rocks and crawlspaces"},
	{"493", "Adrenaline", "For every empty heart container:#↑ +0.2 Damage up"},
	{"494", "Jacob's Ladder", "Tears spawn 1-2 sparks of electricity on impact#Sparks deal half of Isaac's damage"},
	{"495", "Ghost Pepper", "Chance to shoot a red flame that blocks enemy shots and deals contact damage#The flame disappears after dealing damage or blocking shots 5 times"},
	{"496", "Euthanasia", "3.33% chance to shoot a needle#{{Luck}} 100% chance at 15 Luck#Needles kill normal enemies instantly, bursting them into 10 tears#Needles deal 3x damage against bosses"},
	{"497", "Camo Undies", "Entering a room confuses all enemies until Isaac starts shooting"},
	{"498", "Duality", "{{AngelDevilChance}} Spawns both an Angel and Devil room if either would have spawned#Entering one makes the other disappear"},
	{"499", "Eucharist", "{{AngelChance}} 100% chance for Angel Rooms to spawn"},
	{"500", "Sack of Sacks", "Spawns a sack every 5-6 rooms"},
	{"501", "Greed's Gullet", "Gain 1 Heart Container for every 25 coins gained after getting Greed's Gullet#{{Player14}} Keeper can gain additional Coin Hearts"},
	{"502", "Large Zit", "Firing occasionally shoots a white creep tear that deals double damage#Taking damage shoots a white creep tear"},
	{"503", "Little Horn", "5% chance to shoot tears that instantly kill enemies#Isaac deals 3.5 contact damage"},
	{"504", "Brown Nugget", "Spawns a fly turret that shoots at enemies#Each shot deals 2 damage"},
	{"505", "Poke Go", "Entering a hostile room has a chance to spawn a charmed enemy"},
	{"506", "Backstabber", "Hitting an enemy in the back deals double damage and causes bleeding, which deals 10% damage of the enemy's max health every 5 seconds"},
	{"507", "Sharp Straw", "{{Damage}} Deals Isaac's damage + 10% of the enemy's max health to all enemies#{{HalfHeart}} Dealing damage with the Straw can drop half hearts#{{HalfSoulHeart}} Having no red HP drops Soul Hearts instead"},
	{"508", "Mom's Razor", "Orbital that causes bleeding, which deals 10% damage of the enemy's max health every 5 seconds#Deals 3x Isaac's damage on contact per second#Does not block shots"},
	{"509", "Bloodshot Eye", "Orbital that shoots a tear in a random direction every 2 seconds#Deals 3.5 damage per tear#Deals 30 contact damage per second#Does not block shots"},
	{"510", "Delirious", "Spawns a friendly delirium version of a boss for the current room"},
	{"511", "Angry Fly", "Orbits a random enemy until that enemy dies#Deals 30 contact damage per second to other enemies"},
	{"512", "Black Hole", "Throwable black hole, which sucks in everything#Deals 0.4 damage every tick#Destroys nearby rocks#Lasts 6 seconds"},
	{"513", "Bozo", "↑ +0.1 Damage up#+1 Soul Heart#Randomly charms/fears enemies#Taking damage has a random chance to spawn a rainbow poop"},
	{"514", "Broken Modem", "Causes some enemies and projectiles to briefly freeze at random intervals#25% chance to double room clear drops"},
	{"515", "Mystery Gift", "{{Warning}} SINGLE USE {{Warning}}#Spawns a random item from the current room's item pool#Chance to spawn Lump of Coal or The Poop instead"},
	{"516", "Sprinkler", "Spawns a Sprinkler that shoots the same tears as Isaac in a circle around itself"},
	{"517", "Fast Bombs", "{{Bomb}} +7 Bombs#Removes the delay between bomb placements"},
	{"518", "Buddy in a Box", "Familiar which looks like a random coop Baby#Has random tear effects#Effects change every floor"},
	{"519", "Lil Delirium", "Transforms into a random familiar every 10 seconds"},
	{"520", "Jumper Cables", "Killing 15 enemies adds 1 charge to the active item"},
	{"521", "Coupon", "Makes one random item in the {{Shop}} Shop or {{DevilRoom}} Devil Room free#Holding the item guarantees one Shop item is on sale"},
	{"522", "Telekinesis", "Stops all enemy projectiles that come close to Isaac for 3 seconds and throws them away from him afterwards"},
	{"523", "Moving Box", "Stores all pickups and items from the current room#Using the item again drops everything back on the floor#Allows Isaac to move things between rooms"},
	{"524", "Technology Zero", "Isaac's tears are connected with beams of electricity#The beams deal the same damage as Isaac"},
	{"525", "Leprosy", "Taking damage spawns a projectile blocking orbital#Caps at 3 orbitals#Orbitals are destroyed if they take too much damage"},
	{"526", "7 Seals", "Spawns a small horseman familiar that spawns locusts#The horseman and its locust changes every 10 seconds"},
	{"527", "Mr. ME!", "Displays a movable cursor for a few seconds, then summons a ghost that will, depending on the cursor position:#Open doors or chests#Fetch an item#50% chance to steal from the shop / Devil#Attack an enemy until it dies#Explode walls, rocks, shopkeepers, angel statues, machines, beggars"},
	{"528", "Angelic Prism", "Orbital prism#Friendly tears hitting it split into 4"},
	{"529", "Pop!", "Isaac's tears bounce off each other and disappear when they stop moving"},
	{"530", "Death's List", "Killing enemies in the order dictated by the mark {{DeathMark}} above them grants a random pickup or stat increase"},
	{"531", "Haemolacria", "Isaac's tears fly in an arc and burst into smaller tears on impact#↓ Tears down#↑ 31% Damage up"},
	{"532", "Lachryphagy", "Isaac's tears progressively slow down, stop, then explode into 8 smaller tears#Tears can merge and become bigger"},
	{"533", "Trisagion", "Replaces Isaac's tears with piercing beams of light#The beams deal 33% damage but can hit enemies multiple times"},
	{"534", "Schoolbag", "Allows Isaac to hold 2 active items#The items can be swapped using the Drop button ({{ButtonRT}})"},
	{"535", "Blanket", "{{SoulHeart}} +1 Soul Heart#{{Heart}} Heals 1 Red Heart#{{Collectible313}} Entering a boss room grants a {{HolyMantleSmall}} Holy Mantle shield"},
	{"536", "Sacrificial Altar", "{{Warning}} SINGLE USE {{Warning}}#Sacrifices up to 2 familiars and spawns a Devil item for each sacrifice#Turns blue spiders/flies into coins"},
	{"537", "Lil Spewer", "{{Pill}} Spawns a random pill on pickup#Fires a line of creep#The type of creep changes with each pill use"},
	{"538", "Marbles", "{{Trinket}} Spawns 3 random trinkets#{{Collectible479}} Taking damage can remove Isaac's held trinket and grant its effects permanently"},
	{"539", "Mystery Egg", "Taking damage spawns a charmed enemy#Spawns stronger friends the more rooms are cleared without taking damage"},
	{"540", "Flat Stone", "Isaac's tears bounce off the floor and cause splash damage on every bounce"},
	{"541", "Marrow", "{{EmptyBoneHeart}} +1 Bone Heart#{{Heart}} Spawns 3 Red Hearts"},
	{"542", "Slipped Rib", "Orbital#Reflects enemy projectiles"},
	{"543", "Hallowed Ground", "Taking damage spawns a white poop#While inside the poop's aura:#↑ {{Tears}} -50% Tear Delay#Chance to block damage"},
	{"544", "Pointy Rib", "Levitates in front of Isaac#Deals Isaac's damage 6 times per second"},
	{"545", "Book of the Dead", "Spawns a bone orbital or charmed bony per enemy killed in the room"},
	{"546", "Dad's Ring", "Grants an aura that freezes enemies in place"},
	{"547", "Divorce Papers", "{{EmptyBoneHeart}} +1 Bone Heart#↑ {{Tears}} +0.7 Tears up#{{Trinket21}} Spawns the Mysterious Paper trinket"},
	{"548", "Jaw Bone", "Boomerang-like familiar#Deals 7 contact damage#Can grab and bring back pickups"},
	{"549", "Brittle Bones", "{{EmptyBoneHeart}} Replaces all of Isaac's Red Heart containers with 6 empty Bone Hearts#Upon losing a Bone Heart:#Fires 8 bone tears in all directions#↑ {{Tears}} +0.5 permanent Tears up"},
	{"550", "Broken Shovel", "Mom's Foot constantly tries to stomp Isaac#Using the item stops the stomping for the room#{{Warning}} (Try to beat Boss Rush with it!)"},
	{"551", "Broken Shovel", "Completes Mom's Shovel#{{Warning}} Use the shovel on the hill of dirt in the \"Dark Room\""},
	{"552", "Mom's Shovel", "Spawns a trapdoor to the next floor#10% chance for {{LadderRoom}}crawlspace trapdoor#{{Warning}} Use the shovel on the hill of dirt in the \"Dark Room\""},
}

---------- Trinkets ----------
EID.descriptions[languageCode].trinkets={
	{"1", "Swallowed Penny", "{{Coin}} Taking damage spawns 1 coin"},
	{"2", "Petrified Poop", "50% chance to get drops from poop"},
	{"3", "AAA Battery", "-1 charge needed for active items"},
	{"4", "Broken Remote", "{{Collectible44}} Using an active item teleports Isaac to a random room"},
	{"5", "Purple Heart", "2x chance for champion enemies"},
	{"6", "Broken Magnet", "Attracts coins to Isaac"},
	{"7", "Rosary Bead", "{{AngelChance}} 50% higher Angel Room chance#{{Collectible33}} Higher chance to find The Bible in {{Shop}} Shops and {{Library}} Libraries"},
	{"8", "Cartridge", "{{Collectible93}} Taking damage has a 5% chance to trigger the Gamekid effect"},
	{"9", "Pulse Worm", "Isaac's tears pulsate#Affects tear hitbox"},
	{"10", "Wiggle Worm", "Isaac's tears move in waves#↑ {{Tears}} +0.3 Tears up"},
	{"11", "Ring Worm", "Isaac's tears move in spirals with high speed"},
	{"12", "Flat Worm", "50% wider tears#Increases knockback"},
	{"13", "Store Credit", "{{Shop}} Allows Isaac to take 1 shop item for free"},
	{"14", "Callus", "Grants immunity to creep and floor spikes"},
	{"15", "Lucky Rock", "{{Coin}} Destroying rocks spawns coins"},
	{"16", "Mom's Toenail", "Mom's Foot stomps a random spot in the room every 60 seconds"},
	{"17", "Black Lipstick", "{{BlackHeart}} +10% chance for random Soul Hearts to spawn as Black Hearts"}, -- base chance is +5%
	{"18", "Bible Tract", "{{EternalHeart}} +3% chance for Eternal Hearts"}, -- base chance is 1.667%
	{"19", "Paper Clip", "Gold Chests {{GoldenChest}} can be opened for free"},
	{"20", "Monkey Paw", "{{BlackHeart}} Spawns 1 Black Heart when Isaac's health gets down to half a heart#{{Warning}} Disappears after spawning 3 black hearts"},
	{"21", "Mysterious Paper", "{{Blank}} Randomly grants the effect of: #{{Collectible327}} The Polaroid#{{Collectible328}} The Negative#{{Trinket48}} A Missing Page#{{Trinket23}} Missing Poster"},
	{"22", "Daemon's Tail", "{{Heart}} Decreases spawn rate of hearts to 20%#{{BlackHeart}} All Heart pickups turn into Black Hearts#{{Key}} Increases the drop chance of keys"},
	{"23", "Missing Poster", "{{Player10}} Respawn as The Lost on death#Dying in a {{SacrificeRoom}} Sacrifice Room while holding this trinket unlocks The Lost"},
	{"24", "Butt Penny", "{{Coin}} 20% higher chance for coins to spawn from poop#Picking up coins makes Isaac fart"},
	{"25", "Mysterious Candy", "Isaac farts or spawns poop every 30 seconds"},
	{"26", "Hook Worm", "Isaac's tears move in angular patterns#↑ {{Range}} +10 Range"},
	{"27", "Whip Worm", "↑ {{Shotspeed}} +0.5 Shot Speed up"},
	{"28", "Broken Ankh", "{{Player4}} 22% chance to respawn as ??? (Blue Baby) on death"},
	{"29", "Fish Head", "Taking damage spawns 1 blue fly"},
	{"30", "Pinky Eye", "{{Poison}} 10% chance to shoot poison tears"},
	{"31", "Push Pin", "10% chance to shoot piercing spectral tears"},
	{"32", "Liberty Cap", "25% chance for a random mushroom effect per room#Can reveal special rooms on the minimap"},
	{"33", "Umbilical Cord", "Grants {{Collectible100}} Little Steven for the current room when Isaac's health is reduced to half a heart"},
	{"34", "Child's Heart", "{{Heart}} 10% chance for the room clear reward to be a random heart#Chance for a bonus heart from chests, tinted rocks and destroyed machines"},
	{"35", "Curved Horn", "↑ {{Damage}} +2 Damage up"},
	{"36", "Rusted Key", "{{Key}} 10% chance for the room clear reward to be a key#{{Key}} Chance for a bonus key from chests, tinted rocks and destroyed machines"},
	{"37", "Goat Hoof", "↑ {{Speed}} +0.15 Speed up"},
	{"38", "Mom's Pearl", "+10% chance for heart drops to be {{SoulHeart}} Soul Hearts, {{BlackHeart}} Black Hearts or {{EmptyBoneHeart}} Bone Hearts"}, -- base chance is 10%
	{"39", "Cancer", "↑ {{Tears}} -2 Tear Delay"},
	{"40", "Red Patch", "{{Damage}} Taking damage has a 20% chance to grant +1.8 Damage up#{{Luck}} 100% chance at 8 Luck#{{Timer}} Effect lasts for the current room"},
	{"41", "Match Stick", "{{Bomb}} 10% chance for the room clear reward to be a bomb#{{Bomb}} Chance for a bonus bomb from chests, tinted rocks and destroyed machines#{{Warning}} Removes {{Trinket53}}Tick"},
	{"42", "Lucky Toe", "↑ {{Luck}} +1 Luck up#+8% room clear reward chance#Extra pickups from chests, tinted rocks, and destroyed machines"},
	{"43", "Cursed Skull", "When damaged down to half a heart or less, Isaac is teleported to a random room"},
	{"44", "Safety Cap", "{{Pill}} 10% chance for the room clear reward to be a pill#{{Pill}} Chance for a bonus pill from chests, tinted rocks and destroyed machines"},
	{"45", "Ace of Spades", "{{Card}} 10% chance for the room clear reward to be a card#{{Card}} Chance for a bonus card from chests, tinted rocks and destroyed machines"},
	{"46", "Isaac's Fork", "{{HalfHeart}} Clearing a room has a 10% chance to heal half a heart"},
	{"47", "", "<Item does not exist>"},
	{"48", "A Missing Page", "Taking damage has a 5% chance to deal 40 damage to all enemies in the room"},
	{"49", "Bloody Penny", "{{HalfHeart}} Picking up a coin has a 50% chance to drop half a heart"},
	{"50", "Burnt Penny", "{{Bomb}} Picking up a coin has a 50% chance to drop a bomb"},
	{"51", "Flat Penny", "{{Key}} Picking up a coin has a 50% chance to drop a key"},
	{"52", "Counterfeit Penny", "{{Coin}} Picking up a coin has a 50% chance to add another coin to the counter"},
	{"53", "Tick", "-15% boss health#{{BossRoom}} Heals 1 Red Heart when entering a Boss Room#{{Warning}} Once picked up, it can't be removed#Only removeable with {{Trinket41}} Match Stick or gulping"},
	{"54", "Isaac's Head", "Familiar with piercing tears#Deals 3.5 damage per tear"},
	{"55", "Maggy's Faith", "{{EternalHeart}} Entering a new floor grants +1 Eternal Heart"},
	{"56", "Judas' Tongue", "{{DevilRoom}} Reduces all Devil Deal prices to 1 heart container#Doesn't reduce 3 Soul Heart prices"},
	{"57", "???'s Soul", "Familiar that bounces around the room#Shoots in the same direction as Isaac#Deals 3.5 damage per tear"},
	{"58", "Samson's Lock", "{{Damage}} Killing an enemy has a 1/15 chance to grant +0.5 Damage up#{{Luck}} 100% chance at 10 Luck#{{Timer}} Effect lasts for the current room"},
	{"59", "Cain's Eye", "Entering a new floor has a 25% chance to reveal map icons#100% chance at 3 Luck"},
	{"60", "Eve's Bird Foot", "{{Collectible117}} Killing an enemy has a 5% chance to spawn a Dead Bird#{{Luck}} 100% chance at 8 Luck"},
	{"61", "The Left Hand", "Turns all chests into red chests"},
	{"62", "Shiny Rock", "Crawlspace rocks and tinted rocks blink every 10 seconds"},
	{"63", "Safety Scissors", "Turns troll bombs into bomb pickups"},
	{"64", "Rainbow Worm", "Grants a random worm effect every 3 seconds"},
	{"65", "Tape Worm", "↑ {{Range}} x2 Range#↓ x0.5 Tear Height"},
	{"66", "Lazy Worm", "↓ {{Shotspeed}} -0.4 Shot Speed down#↑ {{Range}} +4 Range up#↑ +2 Tear Height"},
	{"67", "Cracked Dice", "Taking damage has a 50% chance to trigger one of these effects:#{{Collectible105}} D6#{{Collectible406}} D8#{{Collectible386}} D12 #{{Collectible166}} D20"},
	{"68", "Super Magnet", "Isaac attracts pickups and enemies"},
	{"69", "Faded Polaroid", "Randomly camouflages Isaac#Confuses enemies"},
	{"70", "Louse", "Occasionally spawns a blue spider in hostile rooms"},
	{"71", "Bob's Bladder", "Isaac's bombs leave damaging creep"},
	{"72", "Watch Battery", "6.66% chance for the room clear reward to be a battery#+10% chance for random pickups to be a battery#5% chance to add 1 charge to held active item when clearing a room"},
	{"73", "Blasting Cap", "10% chance for exploding bombs to drop a bomb pickup"},
	{"74", "Stud Finder", "Breaking a rock has a 0.5% chance to reveal a {{LadderRoom}} crawlspace"},
	{"75", "Error", "Grants a random trinket effect every room"},
	{"76", "Poker Chip", "↑ 50% chance for chests to spawn extra pickups#↓ 50% chance for chests to contain a single fly"},
	{"77", "Blister", "Increases knockback"},
	{"78", "Second Hand", "Status effects applied to enemies last twice as long"},
	{"79", "Endless Nameless", "Using a pill, card or rune has a 25% chance to drop a copy of that pill, card or rune"},
	{"80", "Black Feather", "↑ {{Damage}} +0.2 Damage up for each \"Evil up\" item held"},
	{"81", "Blind Rage", "Invincibility frames after taking damage last twice as long"},
	{"82", "Golden Horse Shoe", "{{TreasureRoom}} Future Treasure Rooms have +15% chance to let Isaac choose between two items"},
	{"83", "Store Key", "{{Shop}} Lets Isaac open Shops for free"},
	{"84", "Rib of Greed", "5% more coins and fewer hearts from room clear rewards#Greed and Super Greed no longer appear in {{Shop}}Shops or {{SecretRoom}}Secret Rooms"},
	{"85", "Karma", "{{DonationMachine}} Using a Donation Machine can:#{{Heart}} Heal 1 heart#{{Coin}} Give 1 coin#{{Luck}} Grant +1 Luck up#{{Beggar}} Spawn a Beggar"},
	{"86", "Lil Larva", "Destroying poop spawns 1 blue fly"},
	{"87", "Mom's Locket", "Using a key heals half a heart#Turns half hearts into full hearts"},
	{"88", "NO!", "Prevents active items from spawning"},
	{"89", "Child Leash", "Familiars stay closer to Isaac"},
	{"90", "Brown Cap", "Poop explodes for 100 damage when destroyed"},
	{"91", "Meconium", "33% chance for Black Poops to spawn#Destroying Black Poop has a 5% chance to spawn a Black Heart"},
	{"92", "Cracked Crown", "↑ Stat increases are 33% more effective#↑ +0.2 Tears up#↑ -1 Tear Delay"},
	{"93", "Used Diaper", "15% chance per room for all Fly enemies to become friendly"},
	{"94", "Fish Tail", "Doubles all Blue Fly / Spider spawns"},
	{"95", "Black Tooth", "3% chance to shoot poison tooth tears"},
	{"96", "Ouroboros Worm", "Isaac's tears move quickly in a spiral pattern#Spectral tears#↑ {{Range}} +4 Range up#↑ +2 Tear Height"},
	{"97", "Tonsil", "Taking damage 12-20 times spawns a projectile blocking familiar#Caps at 2 Familiars"},
	{"98", "Nose Goblin", "10% chance to shoot homing sticky tears#Boogers deal Isaac's damage once per second#Boogers stick for 60 seconds"},
	{"99", "Super Ball", "10% chance to shoot bouncing tears"},
	{"100", "Vibrant Bulb", "Holding a fully charged active item grants:#↑ {{Damage}} +0.5 Damage#↑ {{Speed}} +0.25 Speed#↑ {{Range}} +0.75 Range#↑ {{Tears}} +0.2 Tears#↑ {{Shotspeed}} +0.1 Shot speed#↑ {{Luck}} +1 Luck"},
	{"101", "Dim Bulb", "Holding a completely uncharged active item grants:#↑ {{Damage}} +1.5 Damage#↑ {{Speed}} +0.5 Speed#↑ {{Range}} +1.5 Range#↑ {{Tears}} +0.4 Tears#↑ {{Shotspeed}} +0.3 Shot Speed#↑ {{Luck}} +2 Luck"},
	{"102", "Fragmented Card", "{{SecretRoom}} +1 extra Secret Room per floor while held"},
	{"103", "Equality!", "{{Warning}} Turns single consumables into double consumables when Isaac's coin, key and bomb counts are equal"},
	{"104", "Wish Bone", "2% chance to spawn a pedestal item when hit#Gets destroyed afterwards"},
	{"105", "Bag Lunch", "{{Collectible22}} 2% chance to spawn Lunch when hit#Gets destroyed afterwards"},
	{"106", "Lost Cork", "Increases the radius of friendly creep"},
	{"107", "Crow Heart", "Taking damage depletes Red Hearts before Soul/Black Hearts#This red heart damage does not reduce Devil/Angel Room chances"},
	{"108", "Walnut", "Getting hit by 1-9 explosions destroys the trinket and drops a key, coin, heart, and random trinket#Taking damage isn't required"},
	{"109", "Duct Tape", "Familiars are stuck in one spot and cannot move"},
	{"110", "Silver Dollar", "{{Shop}} Shops appear in the Womb"},
	{"111", "Bloody Crown", "{{TreasureRoom}} Treasure Rooms appear in the Womb"},
	{"112", "Pay To Win", "{{RestockMachine}} Restock boxes always spawn in {{TreasureRoom}} Treasure Rooms"},
	{"113", "Locust of War", "Entering a hostile room spawns an exploding attack fly #The fly deals twice Isaac's damage + explosion damage"},
	{"114", "Locust of Pestilence", "Entering a hostile room spawns a poison attack fly#The fly deals twice Isaac's damage"},
	{"115", "Locust of Famine", "Entering a hostile room spawns a slowing attack fly#The fly deals twice Isaac's damage"},
	{"116", "Locust of Death", "Entering a hostile room spawns an attack fly#The fly deals 4 times Isaac's damage"},
	{"117", "Locust of Conquest", "Entering a hostile room spawns 1-4 attack flies#Each fly deals twice Isaac's damage"},
	{"118", "Bat Wing", "Killing an enemy has a 5% chance to grant flight for the current room"},
	{"119", "Stem Cell", "Entering a new floor heals half a heart"},
	{"120", "Hairpin", "Entering an uncleared boss room fully recharges active items"},
	{"121", "Wooden Cross", "{{Collectible313}} Negates the first damage taken on the floor"},
	{"122", "Butter!", "Using an active item drops it on a pedestal on the ground#Taking damage has a 2% chance to drop one of Isaac's passive items"},
	{"123", "Filigree Feather", "Angel bosses drop Angel items instead of Key Pieces"},
	{"124", "Door Stop", "The last door used stays open"},
	{"125", "Extension Cord", "Connects all familiars with beams of electricity#The beams deal 6 damage"},
	{"126", "Rotten Penny", "Picking up a coin spawns a blue fly"},
	{"127", "Baby-Bender", "Grants all familiars homing shots"},
	{"128", "Finger Bone", "{{EmptyBoneHeart}} Taking damage has a 2% chance to grant a Bone Heart"},
}

---------- Cards ----------
EID.descriptions[languageCode].cards={
	{"1", "0 - The Fool", "Teleports Isaac to the first room of the floor"},
	{"2", "I - The Magician", "Grants homing tears for the current room"},
	{"3", "II - The High Priestess", "Mom's Foot stomps on an enemy#Mom's Foot stomps Isaac if there are no enemies"},
	{"4", "III - The Empress", "For the current room, grants: #↑ {{Damage}} +2.35 Damage up#↑ {{Speed}} +0.3 Speed up"},
	{"5", "IV - The Emperor", "{{BossRoom}} Teleports Isaac to the Boss Room"},
	{"6", "V - The Hierophant", "{{SoulHeart}} Drops 2 Soul Hearts"},
	{"7", "VI - The Lovers", "{{Heart}} Drops 2 Red Hearts"},
	{"8", "VII - The Chariot", "Invincibility + contact damage for 6 seconds"},
	{"9", "VIII - Justice", "Spawns 1 bomb, 1 key, 1 coin, 1 heart"},
	{"10", "IX - The Hermit", "{{Shop}} Teleports Isaac to the Shop"},
	{"11", "X - Wheel of Fortune", "Spawns a {{Slotmachine}} Slot Machine or {{FortuneTeller}} Fortune Machine"},
	{"12", "XI - Strength", "For the current room, grants: #↑ {{Heart}} +1 Health up#↑ {{Damage}} +0.3 Damage up#↑ {{Damage}} +50% Damage#↑ {{Range}} +5.25 Range up#↑ +0.5 Tear Height#↑ {{Speed}} +0.3 Speed up"},
	{"13", "XII - The Hanged Man", "Grants flight for the current room"},
	{"14", "XIII - Death", "Deals 40 damage to all enemies in the room"},
	{"15", "XIV - Temperance", "{{DonationMachine}} Spawns a Blood Donation Machine#{{GreedMode}} Spawns a Devil Beggar in Greed Mode"},
	{"16", "XV - The Devil", "↑ {{Damage}} +2 Damage up for the current room"},
	{"17", "XVI - The Tower", "Spawns 6 troll bombs"},
	{"18", "XVII - The Stars", "{{TreasureRoom}} Teleports Isaac to the Treasure Room"},
	{"19", "XVIII - The Moon", "{{SecretRoom}} Teleports Isaac to the Secret Room"},
	{"20", "XIX - The Sun", "Deals 100 damage to all enemies#Full health#Reveals the entire map"},
	{"21", "XX - Judgement", "Spawns a Beggar or Devil Beggar"},
	{"22", "XXI - The World", "Reveals the map layout and room types"},
	{"23", "2 of Clubs", "{{Bomb}} Doubles Isaac's number of bombs"},
	{"24", "2 of Diamonds", "{{Coin}} Doubles Isaac's number of coins"},
	{"25", "2 of Spades", "{{Key}} Doubles Isaac's number of keys"},
	{"26", "2 of Hearts", "{{Heart}} Doubles Isaac's number of Red Hearts#Only has a healing effect"},
	{"27", "Ace of Clubs", "{{Bomb}} Turns all pickups into bombs"},
	{"28", "Ace of Diamonds", "{{Coin}} Turns all pickups into coins"},
	{"29", "Ace of Spades", "{{Key}} Turns all pickups into keys"},
	{"30", "Ace of Hearts", "{{Heart}} Turns all pickups into hearts"},
	{"31", "Joker", "{{AngelDevilChance}} Teleports Isaac to the Devil or Angel Room"},
	{"32", "Hagalaz", "Destroy all rocks in the room"},
	{"33", "Jera", "Duplicates all pickups in room"},
	{"34", "Ehwaz", "Spawns a trapdoor to the next floor#8% chance for a {{LadderRoom}}crawlspace trapdoor"},
	{"35", "Dagaz", "{{SoulHeart}} +1 Soul Heart#{{CurseCursed}} Removes all curses"},
	{"36", "Ansuz", "Reveals the map layout and room types"},
	{"37", "Perthro", "Rerolls all pedestal items in the room"},
	{"38", "Berkano", "Summons 3 blue spiders and 3 blue flies"},
	{"39", "Algiz", "Makes Isaac invincible for 30 seconds"},
	{"40", "Blank Rune", "Triggers a random rune effect#25% chance to duplicate itself when used"},
	{"41", "Black Rune", "Deals 40 damage to all enemies#Converts all pedestal items in the room into random stat ups#Converts all pickups in the room into blue flies"},
	{"42", "Chaos Card", "Using the card throws it in the direction Isaac is moving#Instantly kills ANY enemy it touches (except Delirium)"},
	{"43", "Credit Card", "Makes all items and pickups in a {{Shop}} Shop or {{DevilRoom}} Devil Room free"},
	{"44", "Rules Card", "Displays \"helpful\" tips on use"},
	{"45", "A Card Against Humanity", "Fills the whole room with poop"},
	{"46", "Suicide King", "Instantly kills Isaac and spawns 10 pickups or items on the floor"},
	{"47", "Get Out Of Jail Free Card", "Open all doors in the current room"},
	{"48", "? Card", "Uses Isaac's active item for free"},
	{"49", "Dice Shard", "Rerolls all pedestals and pickups in the current room"},
	{"50", "Emergency Contact", "Two of Mom's Hands come down and grab an enemy each"},
	{"51", "Holy Card", "{{Collectible313}} Grants a {{HolyMantleSmall}} Holy Mantle shield for one room#(Prevents damage once)#25% chance to spawn another Holy Card"},
	{"52", "Huge Growth", "↑ {{Damage}} +7 Damage up#↑ {{Range}} +30 Range up#Allows Isaac to destroy rocks by walking into them#Size up#{{Timer}} Effect lasts for one room"},
	{"53", "Ancient Recall", "{{Card}} Spawns 3 random cards"},
	{"54", "Era Walk", "{{Slow}} Slow down enemies#↑ {{Speed}} +0.5 Speed up#↓ {{Shotspeed}} -1 Shot Speed down#{{Timer}} Effect lasts for one room"},
}

---------- Pills ----------
EID.descriptions[languageCode].unidentifiedPill = "Unidentified Pill"

EID.descriptions[languageCode].pills={
	{"0", "Bad Gas", "Isaac farts and poisons nearby enemies"},
	{"1", "Bad Trip", "Deals 1 heart of damage to Isaac#Becomes a Full Health pill at 1 heart or less"},
	{"2", "Balls of Steel", "{{SoulHeart}} +2 Soul Hearts"},
	{"3", "Bombs are Key", "Swaps Isaac's number of bombs and keys"},
	{"4", "Explosive Diarrhea", "Isaac quickly spawns 5 lit bombs"},
	{"5", "Full Health", "Fully heals all red heart containers"},
	{"6", "Health Down", "↓ {{Heart}} Health down#Becomes a Health Up pill at 0 or 1 Heart Containers"},
	{"7", "Health Up", "↑ {{EmptyHeart}} +1 Empty heart container"},
	{"8", "I Found Pills", "No effect"},
	{"9", "Puberty", "No effect#Eating 3 grants the Adult transformation (+1 Red Heart)"},
	{"10", "Pretty Fly", "Grants 1 fly orbital"},
	{"11", "Range Down", "↓ {{Range}} -2 Range down"},
	{"12", "Range Up", "↑ {{Range}} +2.5 Range up"},
	{"13", "Speed Down", "↓ {{Speed}} -0.12 Speed down"},
	{"14", "Speed Up", "↑ {{Speed}} +0.15 Speed up"},
	{"15", "Tears Down", "↓ {{Tears}} -0.28 Tears down"},
	{"16", "Tears Up", "↑ {{Tears}} +0.35 Tears up"},
	{"17", "Luck Down", "↓ {{Luck}} -1 Luck down"},
	{"18", "Luck Up", "↑ {{Luck}} +1 Luck up"},
	{"19", "Telepills", "Teleports Isaac to a random room#{{ErrorRoom}} Small chance to teleport Isaac to the I AM ERROR room"},
	{"20", "48 Hour Energy!", "Fully recharges the active item#Drops 1-2 batteries"},
	{"21", "Hematemesis", "Drains all but one heart container#Spawns 1-4 Red Hearts"},
	{"22", "Paralysis", "Prevents Isaac from moving and shooting for 2 seconds"},
	{"23", "I can see forever!", "{{SecretRoom}} Opens all secret room entrances on the current floor"},
	{"24", "Pheromones", "{{Charm}} Charms all enemies in the room"},
	{"25", "Amnesia", "{{CurseLost}} Hides the floor map"},
	{"26", "Lemon Party", "Spawns a large puddle on the ground which damages enemies"},
	{"27", "R U A Wizard?", "Isaac shoots diagonally for 30 seconds"},
	{"28", "Percs!", "Reduces all damage taken to half a heart for the duration of the room"},
	{"29", "Addicted!", "Increases all damage taken to a full heart for the duration of the room"},
	{"30", "Re-Lax", "Isaac spawns poop behind him for 2 seconds"},
	{"31", "???", "{{CurseMaze}} Curse of the Maze effect for the current floor"},
	{"32", "One makes you larger", "Increases Isaac's size#Doesn't affect his hitbox"},
	{"33", "One makes you small", "Decreases Isaac's size#Also decreases his hitbox's size"},
	{"34", "Infested!", "Spawns 1 blue spider for each poop in the room"},
	{"35", "Infested?", "Spawn 1 blue spider for each enemy in the room#Spawns 1-3 blue spiders if there are no enemies in the room"},
	{"36", "Power Pill!", "Makes Isaac briefly invincible#{{Fear}} Fears all enemies in the room#Feared enemies take 40 contact damage per second#{{HalfHeart}} Eating 2 enemies replenishes half a heart"},
	{"37", "Retro Vision", "Pixelates the screen 3 times over 30 seconds"},
	{"38", "Friends Till The End!", "Spawns 3 blue flies"},
	{"39", "X-Lax", "Spawns a pool of slippery creep"},
	{"40", "Something's wrong...", "{{Slow}} Spawns a pool of slowing creep"},
	{"41", "I'm Drowsy...", "{{Slow}} Slows all enemies in the room"},
	{"42", "I'm Excited!!", "Speeds up all enemies in the room"},
	{"43", "Gulp!", "{{Trinket}} Consumes Isaac's current trinket and grants its effects permanently"},
	{"44", "Horf!", "{{Collectible149}} Shoots one Ipecac tear"},
	{"45", "Feels like I'm walking on sunshine!", "Makes Isaac briefly invincible"},
	{"46", "Vurp!", "Spawns the last pill used before Vurp!"},
}

---------- Sacrifice Room ----------
EID.descriptions[languageCode].sacrificeHeader = "[Next Sacrifice Room payout]"

EID.descriptions[languageCode].sacrifice={
	{"1", "", "{{Coin}} 50% chance for 1 coin#{{Bomb}} 100% chance for 1 Bomb, when on B1 and killed the Boss under 1 minute"},
	{"2", "", "{{Coin}} 50% chance for 1 coin#{{Bomb}} 100% chance for 1 Bomb, when on B1 and killed the Boss under 1 minute"},
	{"3", "", "{{AngelChance}} 67% chance for increased Angel Room chance"},
	{"4", "", "{{Chest}} 50% chance for 1 random chest"},
	{"5", "", "{{Coin}} 33% chance for 3 coins#{{AngelChance}} 67% chance for increased Angel Room chance"},
	{"6", "", "{{AngelRoom}} 33% chance for a teleport to the Angel Room#{{DevilRoom}} Teleports to the Devil Room instead if its door was spawned on the current floor#{{Chest}} 67% chance for random chest"},
	{"7", "", "{{AngelRoom}} 33% chance for 1 random Angel Room item#{{SoulHeart}} 67% chance for 1 Soul Heart"},
	{"8", "", "100% chance for 7 troll bombs"},
	{"9", "", "100% chance to spawn \"Uriel\""},
	{"10", "", "{{SoulHeart}} 50% chance for 7 Soul Hearts#{{Coin}} 50% chance for 30 coins"},
	{"11", "", "100% chance to spawn \"Gabriel\""},
	{"12", "", "50% chance to teleport to the \"Dark Room\""},
}

---------- Dice Room ----------
EID.descriptions[languageCode].diceHeader = "[Dice Room effects]"

EID.descriptions[languageCode].dice={
	{"1", "", "Rerolls all of Isaac's items into random items from the room pool they were acquired in"},
	{"2", "", "Rerolls all pickups in the room"},
	{"3", "", "Rerolls all pickups and trinkets on the entire floor#Does not affect the {{DevilRoom}}Devil or {{AngelRoom}}Angel Room"},
	{"4", "", "Rerolls all pedestal items on the floor#Does not affect the {{DevilRoom}}Devil or {{AngelRoom}}Angel Room"},
	{"5", "", "Rerolls and restarts the current floor"},
	{"6", "", "Rerolls all of Isaac's items#Rerolls all pickups, trinkets and pedestal items on the floor"},
}

---------- Transformations ----------
EID.descriptions[languageCode].transformations={
	"",					-- 0 = none
	"Guppy",			-- 1
	"Fun Guy",			-- 2
	"Beelzebub",		-- 3
	"Conjoined",		-- 4
	"Spun",				-- 5
	"Yes Mother?",		-- 6
	"Oh Crap",			-- 7
	"Bob",				-- 8
	"Leviathan",		-- 9
	"Seraphim",			-- 10
	"Super Bum",		-- 11
	"Bookworm",			-- 12
	"Spider Baby",		-- 13
	"Adult",			-- 14
	"Stompy"			-- 15
}


---------- MISC ----------

EID.descriptions[languageCode].VoidText = "If absorbed, gain:"
-- {1} will become the number text (like "{1} Tears up" -> "+0.5 Tears up")
EID.descriptions[languageCode].VoidNames = {"{1} Speed up", "{1} Tears up", "{1} Damage up", "{1} Range up", "{1} Shot Speed up", "{1} Luck up"}

EID.descriptions[languageCode].CollectionPageInfo = "This item needs to be picked up for the collection page!"

EID.descriptions[languageCode].MCM = {
	DemoObjectName = "Demo Object Name",
	DemoObjectTransformation = "Demo Transformation",
	DemoObjectText = "This text is in english#A very cool and long description to simulate linebreaks caused by EID textbox width!#{{Collectible4}} This is also a cool line#{{Heart}} This line loves you#{{AngelDevilChance}} This line can be your angel or your devil#\1 {{Damage}} +1 Stat Change up",
}

EID.descriptions[languageCode].HoldMapTitle = "Item Reminder"
-- the Hold Map description will predict the abilities of items with a header like "Item Name Result"
EID.descriptions[languageCode].HoldMapHeader = " Result"

-- https://wofsauge.github.io/IsaacDocs/rep/enums/RoomType.html
-- Includes Repentance room types for localization convenience
EID.descriptions[languageCode].RoomTypeNames = { "Normal Room", "Shop", "I AM ERROR Room", "Treasure Room", "Boss Room", "Miniboss Room", "Secret Room", "Super Secret Room", "Arcade Room", "Curse Room", "Challenge Room", "Library", "Sacrifice Room", "Devil Room", "Angel Room", "Crawlspace Room", "Boss Rush Room", "Isaac's Room", "Barren Room", "Chest Room", "Dice Room", "Black Market", "Exit Room", "Planetarium", "Teleporter Entrance", "Teleporter Exit", "Alt Path Trapdoor", "Blue Key Room", "Ultra Secret Room",
-- Not technically room types but still potentially useful to have localized
[666] = "Angel/Devil Room", [1024] = "Red Room", [1025] = "Special Red Room" }

-- currently used for D1
EID.descriptions[languageCode].PickupNames = {
	["5.0"] = "None",
	
	["5.10"] = "{{Heart}} Heart",
	["5.10.1"] = "{{Heart}} Heart", ["5.10.2"] = "{{HalfHeart}} Half Heart", ["5.10.3"] = "{{SoulHeart}} Soul Heart", ["5.10.4"] = "{{EternalHeart}} Eternal Heart", ["5.10.5"] = "{{Heart}} Double Heart", ["5.10.6"] = "{{BlackHeart}} Black Heart", ["5.10.7"] = "{{GoldHeart}} Gold Heart", ["5.10.8"] = "{{HalfSoulHeart}} Half Soul Heart", ["5.10.9"] = "{{Heart}} Scared Heart", ["5.10.10"] = "{{BlendedHeart}} Blended Heart", ["5.10.11"] = "{{EmptyBoneHeart}} Bone Heart", ["5.10.12"] = "{{RottenHeart}} Rotten Heart",
	
	["5.20"] = "{{Coin}} Coin",
	["5.20.1"] = "{{Crafting8}} Penny", ["5.20.2"] = "{{Crafting9}} Nickel", ["5.20.3"] = "{{Crafting10}} Dime", ["5.20.4"] = "{{Crafting8}} Double Penny", ["5.20.5"] = "{{Crafting11}} Lucky Penny", ["5.20.6"] = "{{Crafting9}} Sticky Nickel", ["5.20.7"] = "{{Crafting26}} Golden Penny",
	
	["5.30"] = "{{Key}} Key",
	["5.30.1"] = "{{Crafting12}} Key", ["5.30.2"] = "{{Crafting13}} Golden Key", ["5.30.3"] = "{{Crafting12}} Key Ring", ["5.30.4"] = "{{Crafting14}} Charged Key",
	
	["5.40"] = "{{Bomb}} Bomb",
	["5.40.1"] = "{{Crafting15}} Bomb", ["5.40.2"] = "{{Crafting15}} Double Bomb", ["5.40.3"] = "{{Crafting15}} Troll Bomb", ["5.40.4"] = "{{Crafting16}} Golden Bomb", ["5.40.5"] = "{{Crafting15}} Megatroll Bomb", ["5.40.7"] = "{{Crafting17}} Giga Bomb",
	
	["5.90"] = "{{Battery}} Battery",
	["5.90.0"] = "{{Crafting19}} Lil' Battery", --AB+ didn't have subtypes for batteries
	["5.90.1"] = "{{Crafting19}} Lil' Battery", ["5.90.2"] = "{{Crafting18}} Micro Battery", ["5.90.3"] = "{{Crafting20}} Mega Battery", ["5.90.4"] = "{{Crafting28}} Golden Battery",
	
	["5.50"] = "{{Chest}} Chest", ["5.51"] = "{{BombChest}} Bomb Chest", ["5.52"] = "{{SpikedChest}} Spiked Chest", ["5.53"] = "{{EternalChest}} Eternal Chest", ["5.54"] = "{{MimicChest}} Mimic Chest", ["5.55"] = "{{OldChest}} Old Chest", ["5.56"] = "{{WoodenChest}} Wooden Chest", ["5.57"] = "{{MegaChest}} Mega Chest", ["5.58"] = "{{HauntedChest}} Haunted Chest", ["5.60"] = "{{GoldenChest}} Golden Chest", ["5.360"] = "{{RedChest}} Red Chest",  
	
	["5.69"] = "{{GrabBag}} Grab Bag", ["5.69.1"] = "{{GrabBag}} Grab Bag", ["5.69.2"] = "{{BlackSack}} Black Sack",
	
	["5.70"] = "{{Pill}} Pill",
	["5.300"] = "{{Card}} Card",
	["5.301"] = "{{Rune}} Rune", -- not a real id
	["5.350"] = "{{Trinket}} Trinket",

}
