-----------------------------------------
-----  Basic Bulgarian descriptions  ----
-----------------------------------------

-- FORMAT: Item ID | Name | Description

-- Special character markup:
-- ↑ = Up Arrow  |  ↓ = Down Arrow  |  ! = Warning  |  # = Starts a new line
-- More can be found here: https://github.com/wofsauge/External-Item-Descriptions/wiki/Markup

local languageCode = "bul"

-- init bul table
EID.descriptions[languageCode] = {}
EID.descriptions[languageCode].custom = {} -- table for custom entity descriptions
EID.descriptions[languageCode].languageName = "Bulgarian (WIP) (AB+)"

-- Fonts to be used with this language pack
EID.descriptions[languageCode].fonts = EID.descriptions["en_us"].fonts

---------- Collectibles ----------
EID.descriptions[languageCode].collectibles={
	{"1", "Тъжният лук", "↑ {{Tears}} +0.7 честота на стреляне"},
	{"2", "Трето око", "Тройна стрелба#↓ {{Tears}} Намалена честота на стреляне"},
	{"3", "Огъната лъжица", "Самонасочващи се сълзи"},
	{"4", "Главата на Крикет", "↑ {{Damage}} +0.5 щети#↑ {{Damage}} +50% множител на щетите"}, -- +50% -> x1.5??
	{"5", "Моето отражение", "Дава бумеранг ефект на сълзите#↑ {{Range}} +1.5 обхват на сълзите#↑ {{Shotspeed}} +0.6 скорост на сълзите#↑ +1 височина на сълзите"},
	{"6", "Номер едно", "↑ {{Tears}} +1.5 честота на стреляне#↓ {{Range}} -17.62 обхват на сълзите#↑ +0.76 височина на сълзите"},
	{"7", "Кръвта на мъченика", "↑ {{Damage}} +1 щети#{{Collectible34}} Още +50% щети, ако имаш ефекта на книгата на Белиал"},
	{"8", "Брат Боби", "Спътник с нормални сълзи#Прави 3.5 щети на сълза"},
	{"9", "Скатол", "Враждебните мухи стават приятелски"},
	{"10", "Ореол от мухи", "+2 мухи за орбитали#Блокират враждебни изстрели"},
	{"11", "1up!", "↑ Допълнителен живот#Прераждаш се с пълно здраве"},
	{"12", "Вълшебна гъба", "↑ +1 здраве#{{Heart}} Пълно здраве#↑ {{Damage}} +0.3 щети#↑ {{Damage}} +50% множител на щетите#↑ {{Range}} +5.25 обхват на сълзите#↑ {{Speed}} +0.3 скорост#↑ +0.5 височина на сълзите#Уголемяваш се"},
	{"13", "Вирус", "{{Poison}} Отровно докосване#↓ {{Speed}} -0.1 скорост#{{BlackHeart}} Отровените врагове могат да пуснат черно сърце"},    -- better "poison touch" translation?
	{"14", "Стероидна злоба", "↑ {{Speed}} +0.6 скорост#↑ {{Range}} +5.25 обхват на сълзите#↑ +0.5 височина на сълзите"},  -- literal translation: "Steroid rage" - based on definition of (alleged cause) of "roid rage"
	{"15", "<3", "↑ {{Heart}} +1 здраве#{{Heart}} Пълно здраве"},
	{"16", "Суров черен дроб", "↑ {{Heart}} +2 здраве#{{Heart}} Пълно здраве"},
	{"17", "Скелетен ключ", "{{Key}} +99 ключа"},
	{"18", "Долар", "{{Coin}} +99 монети"},
	{"19", "Бум!", "{{Bomb}} +10 бомби"},
	{"20", "Възнасяне", "Летене"}, -- hold off the "Grants flight"->"Дава летене" for now
	{"21", "Компас", "Показва всички икони на картата#Не показва цялата карта"},
	{"22", "Обяд", "↑ {{Heart}} +1 здраве"},
	{"23", "Вечеря", "↑ {{Heart}} +1 здраве"},
	{"24", "Десерт", "↑ {{Heart}} +1 здраве"},
	{"25", "Закуска", "↑ {{Heart}} +1 здраве"},
	{"26", "Развалено месо", "↑ {{Heart}} +1 здраве"},
	{"27", "Дървена лъжица", "↑ {{Speed}} +0.3 скорост"},
	{"28", "Коланът", "↑ {{Speed}} +0.3 скорост"},
	{"29", "Бельото на мама", "↑ {{Range}} +5.25 обхват на сълзите#↑ +0.5 височина на сълзите"},
	{"30", "Токчетата на мама", "↑ {{Range}} +5.25 обхват на сълзите#↑ +0.5 височина на сълзите"},
	{"31", "Червилото на мама", "↑ {{Range}} +5.25 обхват на сълзите#↑ +0.5 височина на сълзите"},
	{"32", "Закачалка", "↑ {{Tears}} +0.7 честота на стреляне"},
	{"33", "Библията", "Летене за сегашната стая#{{MomsHeart}} Убива \"Мама\" и \"Сърцето на мама\"#{{Warning}} Убива теб, ако я използваш срещу \"Сатаната\"!"},
	{"34", "Книгата на Белиал", "↑ {{Damage}} +2 щети#{{Collectible7}} Още +50% щети, ако имаш Кръвта на мъченика#{{AngelDevilChance}} +12.5% шанс за дяволска/ангелска стая"},   -- translation check: preserved transliteration. Based on what the term *might* refer to (in other languages), a loose translation could be "Книгата на падналите" - "The book of the Fallen(plural)".
	{"35", "Некрономикон", "Нанася 40 щети на всички чудовища в стаята"},
	{"36", "Ако", "Създава едно ако на пода#Отблъсква близки чудовища#Може да бъде поставено до яма и да бъде гръмнато, за да стане мост"},
	{"37", "Мистър Бум", "Пуска голяма бомба под играча, която нанася 110 щети"},
	{"38", "Главата на Тами", "Изстрелва кръг от 10 сълзи около играча#Всяка сълза е с ефекти и щети като на играча, + още 25 щети"},
	{"39", "Сутиенът на мама", "Вкаменява всички чудовища в стаята за 4 секунди"},
	{"40", "Камикадзе!", "Прави експлозия около играча за 40 щети#Играчът също поема щети от експлозията"},
	{"41", "Превръзката на мама", "{{Fear}} Плаши всички чудовища в стаята за 5 секунди"},
	{"42", "Изгнилата глава на Боб", "{{Poison}} Отровна бомба, която може да бъде изстреляна като сълза в избрана посока"},
	{"43", "000", "<предметът не съществува!>"},
	{"44", "Телепорт!", "Телепортира те в случайна стая (без стаята I AM ERROR)"},
	{"45", "Вкусно сърце", "Лекува 1 червено сърце"},  -- Yum - delicious.
	{"46", "Късметлийски крак", "↑ {{Luck}} +1 късмет#+8% шанс за награда при минаване на стая#По-висок шанс за победа на машини"},
	{"47", "Дистанционното на доктора", "{{Collectible168}} Изстрелва ракета, която се приземява след 1.5 секунди в посочена от вас точка#Нанася 20х щети"},
	{"48", "Стрелата на Купидон", "Пронизващи сълзи"},
	{"49", "Шуп Да Хуп!", "{{Collectible119}} Изстрелва една сярна лазерна атака в избрана посока"},
	{"50", "Стивън", "↑ {{Damage}} +1 щети"},
	{"51", "Пентаграм", "↑ {{Damage}} +1 щети#{{AngelDevilChance}} +10% шанс за дяволска/ангелска стая"},
	{"52", "Д-р Ембрион", "{{Bomb}} Изстрелваш бомби вместо сълзи#Бомбите правят по 5x щети + 30#↓ {{Tears}} Период между сълзите x 2.5"},
	{"53", "Магнит", "Магнитно привличане за предмети по пода"}, -- TODO: translation token for "pickups"
	{"54", "Карта на съкровище", "Показва стаите на картата за целия етаж#Не показва иконите на картата"},   -- "макет на картата"->"стаите на картата"
	{"55", "Окото на мама", "50% шанс да изстреляш допълнителна сълза назад#100% шанс при +2 късмет"},
	{"56", "Лимонова злополука", "Пуска локва от лимонада на пода#Локвата нанася 24 щети в секунда при докосване"},
	{"57", "Отдалечено възхищение", "Орбитална муха на средна дистанция от играча#Нанася 75 щети в секунда при докосване"},
	{"58", "Книга на сенките", "Дава неуязвимост за 10 секунди"},
	{"59", "000", "<предметът не съществува!>"},
	{"60", "Стълбата", "Позволява на играча да минава през дупки от 1 квадратче"},
	{"61", "000", "<предметът не съществува!>"},
	{"62", "Чарът на вампира", "{{HalfHeart}} Лекува половин сърце на всеки 13 убити чудовища"},
	{"63", "Батерията", "Активните предмети могат да бъдат заредени два пъти"},
	{"64", "Разпродажба в Steam", "{{Shop}} 50% намаление на всички цени в магазините#С две копия от този предмет всички цени стават 0"},
	{"65", "Анархистична готварска книга", "Създава 6 трол бомби в стаята"},
	{"66", "Пясъчен часовник", "{{Slow}} Забавя чудовищата за 8 секунди"},
	{"67", "Сестра Маги", "Спътник с нормални сълзи#Прави 3.5 щети на сълза"},
	{"68", "Технология", "Вместо сълзите стреляш с лазер"},
	{"69", "Шоколадово мляко", "{{Chargeable}} Сълзите се зареждат чрез задържане на копчето за стрелба#↑ {{Damage}} Според заряда нанасят от 10% до 400% щети#↓ {{Tears}} Намалена честота на стреляне"}, -- Зареждащи се сълзи
	{"70", "Хормони за растеж", "↑ {{Damage}} +1 щети#↑ {{Speed}} +0.4 скорост"},
	{"71", "Малка гъба", "↑ {{Speed}} +0.3 скорост#↓ {{Range}} -4.25 обхват на сълзите#↑ +1.5 височина на сълзите#(общо става малко по-голям обхват)#Смаляваш се"},
	{"72", "Молитвена броеница", "{{SoulHeart}} +3 духовни сърца#{{Collectible33}} Библията може да се появи във всяка специална стая"},
	{"73", "Куб от месо", "Ниво 1: Орбитал#Ниво 2: Стрелящ орбитал#Ниво 3: Месно момче ниво 1#Ниво 4: Месно момче ниво 2"},
	{"74", "Монета от 25 стотинки", "{{Coin}} +25 монети"},    -- translation check: We do not have a coin of the same value, nor shorthand names for compound coin values. Possible (very loose) translations: "Стотинка" - currency equivalent of "penny", 1/100; "25 стотинки" - see previous one, likely if that is used as the translation of "coin"; "Монета" - "coin".
	{"75", "Лиценз за лекар", "{{Pill}} Всички негативни хапчета стават позитивни#При взимане създава 1 хапче#{{Heart}} Лекува 2 червени сърца#{{BloodDonationMachine}} Кръводарителски машини и {{Collectible135}} Кръвна банка дават повече монети"},
	{"76", "Рентгеново зрение", "{{SecretRoom}} Разкрива и отваря входовете на тайните стаи"},
	{"77", "Моят малък еднорог", "Дава на играча неуязвимост и +0.28 скорост#40 щети в секунда при докосване#{{Timer}} Ефектът продължава 6 секунди"},
	{"78", "Книга на откровенията", "{{SoulHeart}} +1 духовно сърце#Голяма вероятност босът на този етаж да е конник#{{AngelDevilChance}} +17.5% шанс за дяволска/ангелска стая"},
	{"79", "Белегът", "↑ {{Damage}} +1 щети#↑ {{Speed}} +0.2 скорост#{{SoulHeart}} +1 духовно сърце"},
	{"80", "Пактът", "↑ {{Damage}} +0.5 щети#↑ {{Tears}} +0.7 честота на стреляне#{{SoulHeart}} +2 духовни сърца"},
	{"81", "Мъртва котка", "↑ Дава 9 живота#↓ Отнема всички червени сърца без едно#{{Warning}} На герои, които не могат да имат червени сърца, отнема духовните/черните#Прераждаш се с 1 сърце"},
	{"82", "Властелинът на ямата", "Летене#↑ {{Speed}} +0.3 скорост"},
	{"83", "Пиронът", "{{SoulHeart}} +1 духовно сърце#↑ {{Damage}} +0.7 щети#↓ {{Speed}} -0.18 скорост#40 щети в секунда при докосване#Можете да чупите скали, като ги тъпчете"},
	{"84", "Трябва да идем по-дълбоко!", "При използване отваря люк на земята към следващия етаж#{{LadderRoom}} 10% шанс да отвори люк със стълба към тайник"},
	{"85", "Тесте карти", "{{Card}} Създава 1 произволна таро карта"},
	{"86", "Зъбът на Монстро", "Монстро пада върху произволно чудовище и нанася 120 щети#{{Warning}} Ако няма чудовища, Монстро пада върху играча"},
	{"87", "Рогата на Локи", "25% шанс за изстрели в 4 посоки#{{Luck}} 100% шанс при 7 късмет"},
	{"88", "Малкият Чъби", "Спътник, който лети в посока на стрелбата#Нанася 52.5 щети в секунда на докоснатите врагове"},
	{"89", "Паякова захапка", "{{Slow}} 25% шанс за забавящи сълзи#{{Luck}} 100% шанс при 15 късмет"},
	{"90", "Малкият камък", "↑ {{Damage}} +1 щети#↑ {{Tears}} +0.2 честота на стреляне#↓ {{Speed}} -0.2 скорост"},
	{"91", "Миньорска шапка", "Разкрива какви типове са съседните стаи#{{SecretRoom}} Разкрива съседни тайни и супер тайни стаи"}, -- "spelunker"->"спелеолог", but that's pretentious
	{"92", "Супер лепенка", "↑ {{Heart}} +1 здраве#{{SoulHeart}} +2 духовни сърца#{{Heart}} Лекува още 1 червено сърце"},
	{"93", "Геймкид", "Неуязвимост#{{Fear}} Плаши всички чудовища в стаята#40 щети в секунда при докосване#{{HalfHeart}} Всеки 2 убити чудовища лекуват половин червено сърце#{{Timer}} Ефектът продължава 6.5 секунди"},
	{"94", "Кесия с монети", "{{Coin}} Пуска произволна монета на всеки 2 стаи"},
	{"95", "Робо-бебе", "Спътник с лазерни изстрели#Прави 3.5 щети на изстрел"},
	{"96", "Малък Ч.А.Д.", "{{HalfHeart}} Пуска половин сърце на всеки 3 стаи"},
	{"97", "Книгата на греховете", "Пуска произволен предмет по пода"},    -- "The Book of Sins"
	{"98", "Реликвата", "{{SoulHeart}} Пуска 1 духовно сърце на всеки 5-6 стаи"},
	{"99", "Малък Гиш", "{{Slow}} Спътник със забавящи сълзи#Прави 3.5 щети на сълза"},
	{"100", "Малък Стивън", "Спътник със самонасочващи се сълзи#Прави 3.5 щети на сълза"},
	{"101", "Ореолът", "↑ {{Heart}} +1 здраве#↑ {{Damage}} +0.3 щети#↑ {{Tears}} +0.2 честота на стреляне#↑ {{Range}} +0.25 обхват на сълзите#↑ {{Speed}} +0.3 скорост#↑ +0.5 височина на сълзите"},
	{"102", "Флаконът с хапчета на мама", "{{Pill}} Пуска 1 произволно хапче"},
	{"103", "Настинка", "{{Poison}} 25% шанс за отровни сълзи#{{Luck}} 100% шанс при 12 късмет"},
	{"104", "Паразитът", "Сълзите се разделят на две при допир#Всяка половина нанася половин щети"},
	{"105", "D6", "Променя всички предмети на пиедестали в стаята"},
	{"106", "Мистър Мега", "↑ Бомбите имат по-голям обхват и правят 2.25х щети#+{{Bomb}} 5 бомби"},
	{"107", "Шивашки ножици", "Летене#Тялото ви се отделя като самостоятелен спътник#Нанася 82.5 щети в секунда при докосване"},
	{"108", "Вафлата", "Всяка щета отнема само половин сърце"},    -- translation check: preserving literal simplistic translation. Implied is that The Wafer has special (religious) meaning, but not what terms should refer to that.
	{"109", "Пари = Сила", "↑ {{Damage}} +0.04 щети за всяка твоя {{Coin}}монета"},
	{"110", "Лещите на мама", "20% шанс за вкаменяващи сълзи#{{Luck}} 50% шанс при 20 късмет#↑ +0.25 обхват на сълзите#↑ +0.5 височина на сълзите"},
	{"111", "Бобчето", "{{Poison}} Пърди отровен облак газ#Отровата нанася щетата на играча общо 6 пъти"},
	{"112", "Ангел пазител", "Орбитален спътник#Ускорява всички други орбитали#Блокира изстрели#Нанася 105 щети в секунда при докосване"},
	{"113", "Бебе демон", "Автоматично стрелящо бебе#Има малък радиус на действие#Прави 3 щети на сълза"},
	{"114", "Ножът на мама", "Вместо сълзи държите и стреляте нож#Нанася 2х щетите на играча при държане и 6х при максимално зареден изстрел"},
	{"115", "Уиджа дъска", "Спектрални сълзи"},    -- translation check: preserving transliteration of Ouija for lack of better terms
	{"116", "9 волтова батерия", "Автоматично дава +1 заряд след използване на активния предмет#{{Battery}} При взимане зарежда напълно текущия активен предмет"},
	{"117", "Мъртва птица", "Атакува чудовищата, след като някое ти нанесе щета#Нанася 4 щети в секунда при докосване"},
	{"118", "Сяра", "{{Chargeable}} Вместо сълзи стреляте зареждащ се кървав лазер, който нанася много щети"},
	{"119", "Пакет с кръв", "↑ {{Heart}} 1 здраве#↑ {{Speed}} +0.3 скорост#{{Heart}} Лекува 4 червени сърца"},
	{"120", "Странна гъба (тънка)", "↑ {{Tears}} +1.7 честота на стреляне#↑ {{Speed}} +0.3 скорост#↓ Намалява щетите на базата на увеличенията от други взети предмети:#(увеличения * 0.9) - 0.4"}, -- any more concise descriptions? / list the -0.4 Damage as a separate point?
	{"121", "Странна гъба (дебела)", "↑ {{EmptyHeart}} +1 празен контейнер за червено сърце#↑ {{Damage}} +0.3 щети#↑ {{Range}} +0.25 обхват на сълзите#↓ {{Speed}} -0.1 скорост#↑ +0.5 височина на сълзите"},
	{"122", "Вавилонска блудница", "Ако имате 1/2 или по-малко червени сърца:#↑ {{Damage}} +1.5 щети#↑ {{Speed}} +0.3 скорост"},
	{"123", "Наръчник за чудовища", "Дава произволен спътник за стаята"},
	{"124", "Свитъци от Мъртво море", "Ефект от произволен активен предмет"},
	{"125", "Боби-Бомба", "Самонасочващи се бомби#{{Bomb}} +5 бомби"},
	{"126", "Бръснарско ножче", "#↑ {{Damage}} +1.2 щети за стаята#{{Warning}} Нанася 1 сърце щета#Ако има червени сърца, първо премахва тях"},
	{"127", "Забрави за мен", "{{Warning}} ИЗПОЛЗВА СЕ ВЕДНЪЖ!#Текущият етаж се рестартира и се регенерира"},
	{"128", "Завинаги сам", "Орбитална муха на голяма дистанция от играча#Нанася 30 щети в секунда при докосване"},
	{"129", "Кофа с маз", "↑ +2 празни контейнера за червени сърца#↓ -0.2 скорост#Лекува половин червено сърце"},
	{"130", "Пони", "Пасивно получаваш летене#{{Speed}} Скоростта ти става 1.5, ако е била по-малко#При използване, се блъска в чудовища в посоката на движение на играча"}, -- more accurate dash attack description?
	{"131", "Торба с бомби", "{{Bomb}} Пуска 1 произволна бомба на всеки 2-3 стаи"},
	{"132", "Парче въглен", "{{Damage}} Колкото по-дълго лети сълзата, толкова повече щети нанася"},
	{"133", "Лапата на Гъпи", "Когато се използва маха 1 контейнер за Червено сърце и ти дава 3 духовни сърца"},   -- TODO: Item133 continue from here
	{"134", "Опашката на Гъпи", "Появяват се повече сандъци"},
	{"135", "Кръвна банка", "Преносима банка с кръв#Дава 1 монета за половин сърце"},
	{"136", "Най-добър приятел", "Привлича чудовищата#След 5 секунди той избухва"},
	{"137", "Детонатор", "Бомбите експлодират при използване на детонатора#+5 Бомби"},
	{"138", "Стигмата", "↑ 1 Червено сърце#↑ {{Damage}} 0.3 Щети"},
	{"139", "Чантата на мама", "Позволява ти да носиш 2 дрънкулки"},
	{"140", "Проклятието на Боб", "Отровни бомби#+5 Бомби"},
	{"141", "Артистично момче", "Появяват се 7 произволни монети"},    -- translation check: "pageant" could loosely be described in 2 words as (US)"beauty show"/(UK)"historical reenactment", nothing more accurate possible for the translation
	{"142", "Скапуляр", "Ако сте поели щети и сте останали на половин сърце, дава 1 духовно сърце#(веднъж на стая)"},   -- translation check: transliteration/borrow from Russian word, again with the note of this religious term possibly not existing
	{"143", "Спидбол", "↑ {{Speed}} 0.3 Скорост#↑ {{Shotspeed}} 0.2 скорост на сълзите"},  -- translation check: transliteration/Russian translation preserved due to specialized drug term
	{"144", "Просяк-приятел", "Събира монети и дава предмети за тях"},
	{"145", "Главата на Гъпи", "Призовава 2-4 Съюзнически мухи"},
	{"146", "Молитвена карта", "Когато се използва, дава бяло сърце"},
	{"147", "Кирка", "Унищожава камъни#Може да направи дупка в Тайната стая!"},
	{"148", "Нашествие", "Когато поемете щети, се появява съюзническа муха"},  -- translation check: word used here may mean "animal/insect infestation", but also "invasion" (corrected from "infection")
	{"149", "Буркан с отрова", "Сълзите летят в дъга и избухват#Ефектът от отравяне#↑ {{Damage}} +40 щета#↓ {{Tears}} По-малко сълзи"},
	{"150", "Трудна любов", "10% Шанс за изстрел на зъб с {{Damage}} 3.2x щети#{{Luck}} 100% шанс при 9 късмет"},
	{"151", "Мълиганът", "1/6 шанс да призове муха когато сълзите докоснат чудовище"},
	{"152", "Технология 2", "Безкраен лазер#↓ {{Damage}} -35% Щети#↓ {{Tears}} Период между сълзите x 2"}, -- AB+ en_us.lua claims Tear Delay x 2. Was there a tears down to Tech 2 before Repentance?? ~~Wiki also claims: "Tear delay is effectively doubled, as Isaac will do a bit of the animation to fire a right eye tear, but no tear will come out."
	{"153", "Паяк Мутант", "Четворна стрелба#↓ {{Tears}} скорост на стреляне"},
	{"154", "Химическо Изгаряне", "↑ {{Damage}} +2 Щети за лявото око"},
	{"155", "Зъркелът", "Лети из стаята#Нанася щети при контакт"},
	{"156", "Калугерска одежда", "+1 заряд на активният предмет когато те ударят"},    -- translation check: roughly "Nun's habit", though in this form the first word used is not gendered like "Nun" is
	{"157", "Жажда за кръв", "↑ {{Damage}} +Щета всеки път щом те ударят#Ефектът се прилага до 6 пъти на етаж#Продължава до края на етажа"},
	{"158", "Кристална топка", "Показва цялата Карта#Дава духовно сърце или произволна карта"},
	{"159", "Дух на нощта", "Летене#Спектрални сълзи"},
	{"160", "Удар от небето", "Когато се използа пуска лъчове светлина върху чудовищата и прави много щети"},  -- translation check: literally "Hit from the sky"
	{"161", "Анкх", "След като умреш се прераждаш като ??? (Синьото бебе)"},
	{"162", "Келтски кръст", "Вероятност за временна неуязвимост след като поемете щети#100% шанс с късмет +27"},
	{"163", "Бебе дух", "Бебе което стреля спектрални сълзи"},
	{"164", "Свещта", "Стреля сини пламъци"},
	{"165", "Котка с девет опашки", "↑ {{Damage}} +1 Щети#↑ {{Shotspeed}} +0.23 Скорост на стрелбата"},
	{"166", "D20", "Променя пикъповете в стаята"},
	{"167", "Бебе Арлекин", "Изтрелва V-образни сълзи"},
	{"168", "Епичен Ембрион", "Сълзите се заменят с ракети!"},
	{"169", "Полифем", "Мега сълзи!#↑ {{Damage}} Увеличена щета: (Щета + 4) x 2#↓ {{Tears}} 2 скорост на стреляне#Сълзите продължават след убито чудовище"},    -- Typed out exact Damage formula. The en_us desc is grossly incorrect in this regard (at least, 4 additional damage should be 8 if we are describing it that way).
	{"170", "Татко Дълги Крака", "Крак който настъпва чудовищата в стаята"},   -- translation check: literal translation, leaves ambiguous what kind of spider the familiar is
	{"171", "Паяшки задник", "забавя чудовищата за 4 секунди#Прави по 10 щети на всяко чудовище"},
	{"172", "Жертвена кама", "Орбитален нож#Нанася много щети"},
	{"173", "Митра", "Висок шанс да намериш духовно сърце"},
	{"174", "Бебе дъга", "Бебе което стреля различен цвят сълзи с различни ефекти"},
	{"175", "Ключа на тати", "Отваря абсолютно всички врати в стаята"},
	{"176", "Стволови клетки", "↑ 1 Червено сърце#↑ {{Shotspeed}} 0.16 скорост на сълзите"},
	{"177", "Преносим слот", "Преносима игрална машина"},
	{"178", "Светена Вода", "Ако вземете щети, тя ще се счупи #Ще се появи локва на пода, която причинява щети на чудовищата"},
	{"179", "Съдба", "Летене#+1 вечно сърце"},
	{"180", "Черен боб", "Когато поемете щети, вие отравяте чудовищата с отровен газ"},
	{"181", "Бяло пони", "Докато държиш предметът:#Получаваш летене#{{Speed}} Скоростта ти става 1.5, ако е по-малко#При използване, атакува чудовища в избраната посока"},    -- TODO: clarify holy dash
	{"182", "Свещено сърце", "Самонасочващи се сълзи#↑ 1 Червено сърце#↑ Щети (Щети 2.3+1)#↓ 0.4 скорост на стреляне#↓ 0.25 скорост на сълзите#↑ 0.375 обхват на сълзите"},
	{"183", "Клечки за зъби", "↑ {{Tears}} +0.7 скорост на стреляне#↑ {{Shotspeed}}+0.16 скорост на сълзите"},
	{"184", "Светия Граал", "Летене#↑ 1 Червено сърце"},
	{"185", "Мъртъв гълъб", "Летене#Спектрални сълзи"},
	{"186", "Кръвни права", "Когато се използва, нанася 40 щети на всички в стаята#За използване наранява играча с 1 сърце"},
	{"187", "Топката косми на Гъпи", "Нападателна топка от косми#Лети около вас и расте, когато убива врагове"},
	{"188", "Авел", "Копира огледално движенията ти#Стреля към играча"},
	{"189", "Фен на Super Meat Boy", "↑ 1 Червено сърце#↑ 0.3 Щети#↑ 0.2 скорост на стреляне#↑ 0.5 обхват на сълзите#↑ 0.2 скорост#↑ 1.0 височина на сълзите#Лекува играча"},   -- translation check: game name stays in English
	{"190", "Пиро", "+99 Бомби"},
	{"191", "Тридоларова банкнота", "Сълзи със случаен ефект"},
	{"192", "Телепатия за Глупаци", "Когато се използва, получаваш самонасочващи се сълзи"},
	{"193", "МЕСО!", "↑ 1 Червено сърце#↑ {{Damage}} 0.3 Щети"},
	{"194", "Вълшебна топка 8", "↑ {{Shotspeed}} +0.16 скорост на стрелбата#{{Card}} Дава случайна карта"},
	{"195", "Портмонето на мама", "{{Pill}} Пуска 4 хапчета"},
	{"196", "Играчка за стискане", "+2 Духовни сърца#↑ {{Tears}} 0.4 скорост на стреляне"}, -- translation check: literal translation "Toy to squeeze", based on the wiki trivia ~~even though it also looks like a flip-flop to hit someone with
	{"197", "Сокът на Исус", "↑ 0.5 Щети#↑ 0.25 Обхват на сълзите#↑ 0.5 височина на сълзите"},
	{"198", "Кутия", "Дава по 1 пикъп на земята от всеки вид"},
	{"199", "Ключът на мама", "2 Ключа#Получаваш повече неща от кутиите"},
	{"200", "Сенките на мама", "Шанс да очароваш чудовищата#100% шанс с късмет +27"},
	{"201", "Желязно кюлче", "↑ {{Damage}} 0.3 Щети#Има шанс да изтреляш сълза която обърква чудовищата#100% шанс с късмет +27"},
	{"202", "Докосването на Мидас", "Превръща чудовищата в злато като ги докоснеш#Когато убиеш златно чудовища то пуска монети"},
	{"203", "Скромен комплект", "Удвоява всички пикъпи"},
	{"204", "Раменна чанта", "50% шанс да пуснеш случаен пикъп като те одарят"},
	{"205", "Остър щепсел", "Ако активният предмет е празен можете да го използвате за 2 сърца"},
	{"206", "Гилотина", "↑ {{Damage}} 1 Щети#↑ {{Tears}} +скорост на стреляне#Главата ви сега се движи около вас в орбита"},
	{"207", "Топка от лепенки", "Ниво1: орбитал#Ниво2: стрелящ орбитал#Ниво3: Момиче лепенка#Ниво4: Момиче лепенка ниво2"},
	{"208", "Шампионски пояс", "↑ {{Damage}} 1 Щети#Повече Чудовища шампиони се появяват"},    -- Шампионски колан?
	{"209", "Бомби от задник", "5 Бомби#Взривът зашеметява и нанася щети на всички чудовища в стаята"},
	{"210", "Изгризано листо", "Неуязвимост, ако стоите неподвижно по-дълго от секунда"},
	{"211", "Бебе паяк", "Когато нанесете щети, се появява съюзен паяк"},
	{"212", "Яката на Гъпи", "50% шанс да се преродиш след смъртта"},
	{"213", "Изгубена контактна леща", "Сълзите ще имат щит, блокиращ другите сълзи#Когато такава сълза и вражеска сълза се сблъскат, и двете ще изчезнат#↓ {{Shotspeed}} -0.15 скорост на стрелбата"},
	{"214", "Анемия", "↑ {{Range}} +5 Обхват на сълзите#Когато поемете щети, започвате да оставяте отровна следа в стаята"},
	{"215", "Козя глава", "100% шанс за сделка Ангел / Дявол"},
	{"216", "Церемониална роба", "↑ {{Damage}} 1 Щети#+3 Черни сърца"},
	{"217", "Перуката на мама", "шанс да създаде съюзнически паяци по време на стрелба"},
	{"218", "Плацента", "Много бавна регенерация#↑ 1 Червено сърце"},
	{"219", "Стара лепенка", "↑ 1 празен контейнер за Червено сърце#Случаен шанс като те ударят да пуснеш 1 червено сърце"},
	{"220", "Тъжни бомби", "Бомбата избухва, пускайки сълзи в различни посоки#+5 Бомби#Сълзите копират ефекта на сълзите на играча"},
	{"221", "Гумено лепило", "Отскачащи сълзи"},
	{"222", "Анти-гравитация", "Сълзите висят във въздуха, докато стреляте#↑ {{Tears}} -2 период между сълзите"},
	{"223", "Пироман", "Експлозиите ви лекуват!#+5 Бомби"},
	{"224", "Тялото на Крикет", "↑ {{Tears}} +1 скорост на стреляне#↓ {{Range}} -10 обхват на сълзите#Сълзите се разпадат на 4 части при сблъсък"},
	{"225", "Гимпи", "Шанс за създаване на Духовно сърце / Черно сърце при поемане на щети"},
	{"226", "Черен лотос", "↑ 1 Червено сърце#+1 Духовно сърце#+1 Черно сърце"},
	{"227", "Прасе касичка", "+3 Монети#Когато поемате щети пускате 1 или 2 монети"},
	{"228", "Парфюмът на мама", "↑ {{Tears}} 1 скорост на стреляне#Шанс да изплаши чудовищата"},
	{"229", "Белият дроб на Монстро", "Сълзите зареждат и стрелят в насипно състояние#Атаката е подобна на атаката на Монстро#↓ {{Tears}} 4.3x период между сълзите"},
	{"230", "Абадон", "↑ {{Damage}} 1.5 Щети#↑ {{Speed}} 0.2 скорост#Шанс да изплаши чудовищата#Маха всички червени сърца#+6 Черни сърца"},
	{"231", "Топка смола", "{{Slow}} 10% шанс да изстреляте забавящи сълзи#{{Luck}} 100% шанс при 18 късмет#Оставяте слуз на пода която забавя чудовищата"},
	{"232", "Секундомер", "При поемане на щети враговете в стаята трайно се забавят"},
	{"233", "Малка планета", "Сълзи летят около вас в орбита#↑ +7 височина на сълзите"},   -- {{Range}} "Range way up!" claimed in en_us.lua. Due to that being related to tear height/tear falling speed, it will not be added here.
	{"234", "Нашествие 2", "Ще получите съюзнически паяк за всяко убито чудовище"},    -- see Infestation comment
	{"235", "000", "<Не съществува>"},
	{"236", "Ешерихия коли", "Превръща врага в ако при докосване"},
	{"237", "Докосването на смъртта", "Сълзите се превръщат в коси!#↑ 1.5 Щети#↓ 0.3 скорост на стреляне"},
	{"238", "Парче от ключ 1", "Част от ключа към вратата на Мега Сатана!#По-голям шанс за стая на Ангел"},
	{"239", "Парче от ключ 2", "Част от ключа към вратата на Мега Сатана!#По-голям шанс за стая на Ангел"},
	{"240", "Експериментално лечение", "Вашите настройки се променят на случаен принцип"},
	{"241", "Споразумение с Подземния свят", "Всички пикъпове, които падат след почистване на стаята, се дублират"},
	{"242", "Позор", "Шанс за блокиране на летящи сълзи"},
	{"243", "Щит на Троицата", "Блокиращ щит на сълзите"},
	{"244", "Техно.5", "Лазерна атака#Лазерът има произволни ефекти"},
	{"245", "20/20", "Двойна стрелба!"},
	{"246", "Синя карта", "Показва тайните стаи"},
	{"247", "Най-добри приятели завинаги!", "Спътниците нанасят повече щети"},
	{"248", "Кошерен ум", "Мухите и паяците, които са от твоя страна, нанасят двойни щети"},
	{"249", "Има опции", "След боса има два Предмета от които да избирате#Можете да вземете само един"},
	{"250", "Двойни бомби", "Всички бомби за пикап стават двойни"},    -- translation check: current ("Double bombs") is fine, BOGO = Buy One Get One (free)
	{"251", "Начално тесте", "Можеш да носиш по две карти#Превръща всички хапчета в карти"},
	{"252", "Малка торбичка", "Може да носиш по две хапчета#Превръща всички карти в хапчета"},
	{"253", "Вълшебна кора", "↑ {{Luck}} +1 късмет#↑ 1 Червено сърце"},
	{"254", "Кръвен съсирек", "↑ {{Damage}} 1 Щети#↑ {{Range}} +5 обхват на сълзите#Само за лявото око"},
	{"255", "Винт", "↑ {{Tears}} 0.5 скорост на стреляне#↑ {{Shotspeed}} 0.2 скорост на сълзите"},
	{"256", "Горещи бомби", "Изгарящи бомби, оставящи огън след експлозия#+5 Бомби"},
	{"257", "Огнен ум", "Горящи сълзи#Шанс за експлозия"},
	{"258", "Изгубен №", "С всеки етаж той променя произволно всички предмети, с които разполагате"},
	{"259", "Тъмна материя", "↑ {{Damage}} 1 Щети#Шанс за изплашване на врагове#100% шанс с късмет +20"},
	{"260", "Черна свещ", "Имунитет срещу проклятия#+1 Черно Сърце"},
	{"261", "Проптоза", "↑ {{Damage}} +100% бонус щети#Колкото по-далеч лети сълзата, толкова по-малък е бонусът"},
	{"262", "Изгубена страница 2", "+1 Черно Сърце#Когато останат 1,5 сърца, нанася щети на всички в стаята"},
	{"263", "000", "<Не съществува!>"},
	{"264", "Умна муха", "Орбитална муха#Когато ви нанесът щета, започва да атакува враговете"},
	{"265", "Сухо бебе", "Спътник блокиращ щети#След блокиране има шанс да нанесе щети на всички врагове в стаята"},
	{"266", "Сочен пашкул", "Оставя забавяща слуз по пътя ви#Може да изхвърли съюзни паяци, след изчистване на стая"},
	{"267", "Робо-бебе 2.0", "Стреля лазери#Стреля в посоката, в която стреляте вие"},
	{"268", "Гнило бебе", "Спалнва съюзни мухи, когато стреляте"},
	{"269", "Бебе без глава", "Оставя следи от кръв по пътя ви, които нанасят щети на враговете"},
	{"270", "Пиявица", "Запълва половин червено сърце, когато убие някой"},
	{"271", "Тайнствена торбичка", "Дава произволни пикъпи, през няколко стаи"},
	{"272", "Голяма красива муха", "Съюзническа експлодираща муха"},
	{"273", "Мозъкът на Боб", "Спътник, управляван от вашата стрелба#Експлодира при контакт"},
	{"274", "Най-добър другар", "Орбитална муха, която спалнва орбитални мухи, когато ви нанесът щети"},   -- Best Friend<->Най-добър приятел, Best Bud<->Най-добър другар (as one can expect, the difference is very thin)
	{"275", "Бебе малка сяра", "{{Collectible118}} Стреля зареждащ кръвен лазер"},
	{"276", "Сърцето на Исаак", "Ставате неуязвим#Ако сърцето понесе щета, понасяте и вие"},
	{"277", "Малкият призрак", "Спътник, който атакува враговете"},
	{"278", "Тъмният просяк", "Спътник, който събира червени сърца и дава в замяна Духовни сърца"},
	{"279", "Голям фен", "Голяма орбитална муха#Блокира снаряди"},
	{"280", "Сиси дългите крака", "Спътник, който създава съюзнически мухи"},
	{"281", "Боксова круша", "Отклонява вниманието на враговете"},
	{"282", "Ръководство за скачане", "Позволява ви да скачате"},
	{"283", "D100", "Ефект на D4, D6 и D20:#Променя всички елементи в стаята#Променя артефактите на педесталите#Променя артефактите, които носите"},
	{"284", "D4", "Когато се активира, произволно променя артефактите, носени от вашия герой"},
	{"285", "D10", "Променя всички врагове в стаята с произволни"},
	{"286", "Празна карта", "Копира ефекта на картата / руната, която държите, когато се използва"},
	{"287", "Книга на тайните", "Показва част от картата, когато се използва"},
	{"288", "Кутия с паяци", "Призовава 2-4 съюзнически паяци"},
	{"289", "Червена свещ", "Изстрелва червени пламъци"},
	{"290", "Бурканът", "Може да съхранява до 4 червени сърца"},
	{"291", "Тоалетна!", "Когато се използва, превръща всички врагове в изпражнения#Не работи на Boss-oве"},
	{"292", "Сатанистка Библия", "+1 Черно сърце при използване"},
	{"293", "Главата на Крампус", "Атака с кръвен лазер в 4 посоки"},
	{"294", "Маслен боб", "Пърди и отблъсква враговете при използване"},
	{"295", "Вълшебни пръсти", "Когато се използва, той нанася щети на всички врагове в стаята#Разходи за използване - 1 монета"},
	{"296", "Конвертор", "Превръща 2 Духовни сърца в 1 Червено сърце"},
	{"297", "Кутията на Пандора", "Само едно използване! Нещата, които може да пусне са зависимост от етажа:#B1: 2 Духовни сърца#B2:2 ключа, 2 бомби#C1:1 Boss предмет#C2:B1 + C1#D1:4 Духовни сърца#D2: 30 Монети#W1:2 Boss предмета#W2: Библия#Sheo1: 1 Дяволски предмет+Черное сърце#Cat: 1 Ангелски предмет+Духовно сърце#Съндък: 1 Монета"},
	{"298", "Копито от еднорог", "Временна неуязвимост + скорост, когато се използва"},
	{"299", "Телец", "↓ {{Speed}} -0.3 Speed down#↑ {{Speed}} Ставате по-бързи в стая с врагове#{{Collectible77}} При пълно ускорение (2.0 скорост) ставате неуязвими#Ефектът се губи за стаята няколко секунди по-късно"},   -- Remove the ↑ in front of {{Speed}} Slowly gain speed(...)?
	{"300", "Овен", "↑ {{Speed}} +0.25 скорост#Сблъскването с врагове им нанася щети"},
	{"301", "Рак", "+3 Духовни сърца#Когато понасяте щети, всякакви допълнителни щети в стаята ще отнемат половин сърце"},
	{"302", "Лъв", "Можете да чупите скали, като ги тъпчете"},
	{"303", "Дева", "Шанс за временна неуязвимост след поемане на щети#100% шанс с късмет +10"},
	{"304", "Везни", "+6 монети / ключове / бомби#Балансира вашите параметри!#Всички следващи подобрения ще бъдат разпределени между всички ваши параметри"},
	{"305", "Скорпион", "Отровни сълзи"},
	{"306", "Стрелец", "↑ {{Speed}} +0.2 скорост#Сълзите пронизват враговете"},
	{"307", "Козирог", "1 Ключ / 1 Бомба / 1 Монета#↑ 1 Червено сърце#↑ {{Damage}} 0.5 Щети#↑ {{Speed}} 0.1 скорост#↑ {{Range}} 1.5 обхват на стрелба#↑ {{Tears}} +Скорост на стреляне"},
	{"308", "Водолей", "Героят оставя следа от сълзи зад себе си, причинявайки щети на враговете"},
	{"309", "Риби", "↑ {{Tears}} -1 период между сълзите#Обратни сълзи"},
	{"310", "Спиралата на Ева", "↑ {{Damage}} Щети x2#↓ {{Tears}} -50% скорост на стреляне#↓ {{Shotspeed}} -0.5 скорост на сълзите"},
	{"311", "Сянката на Юда", "След смъртта ще се появиш като Черен Юда#↑ {{Damage}} (той има щети x 2) "},
	{"312", "Панделката на Маги", "↑ 1 Червено сърце#Удвоява ефекта от лечението на сърцата"},
	{"313", "Свещена мантия", "Блокира първите нанесени щети във всяка стая"},
	{"314", "Гръмотевични бедра", "↑ 1 Червено сърце#↓ {{Speed}} -0.4 скорост#Можете да чупите скали, като ги тъпчете"},
	{"315", "Странно привличане", "Магнитни сълзи#Привлича предмети и врагове"},
	{"316", "Прокълнато око", "Зареждаща се вълна от сълзи#Ако нанесете щети по време на зареждане, има шанс да се телепортирате в произволна стая"},
	{"317", "Мистериозна течност", "Сълзите оставят отровен басейн"},
	{"318", "Близнаци", "Брат атакуващ врагове в близък бой"},
	{"319", "Другото око на Каин", "Бавно лети из стаята#Стреля сълзи към вашата позиция#{{Damage}} Щетата им е равна на вашата"},
	{"320", "Единственият приятел на ???", "Контролираща се муха, която уврежда враговете"},
	{"321", "Веригите на Самсон", "Верига + топка#Може да чупи камъни, да наранява врагове и да блокира снаряди"},
	{"322", "Бебе Монго", "Копира ефекта на сълзите на друг спътник"},
	{"323", "Сълзите на Исаак", "Когато се използва, пуска 8 сълзи около героя#Зарежда се докато стреляте"},
	{"324", "Неопределено", "Телепортира се до:#- Тайната стая#- Стаята съм - ГРЕШКА#- Стаята с предмети"},
	{"325", "Ножици", "Отрязва главата ти#Главата стои неподвижно#Ти контролираш тялото си"},
	{"326", "Глътка живот", "Задръжте интервал, докато лентата за зареждане се изпразни за неуязвимост# !!! Не го дръжте твърде дълго или ще поемете щети!"},
	{"327", "Полароид", "Дава кратка неуязвимост, ако останете на 1/2 сърце#Позволява ви да преминете към нивото Съндък"},
	{"328", "Негатив", "Нанася щети на всички врагове в стаята, ако остане 1/2 сърце#Позволява ви да преминете към нивото на Тъмната стая"},
	{"329", "Техниката Лудовико", "Голяма управляема от вас сълза"},
	{"330", "Соево мляко", "↑ {{Tears}} Изключително висока скорост на стреляне#↓ {{Damage}} -80% Щети"},
	{"331", "Божественост", "Насочване на сълзите#Имате аура, която нанася щети#↑ {{Damage}} +0.5 Щети#↑ {{Range}} 1.2 Обхват на сълзите#↓ {{Tears}} 0.3 скорост на стреляне#↓ {{Shotspeed}} -0.3 скорост на сълзите#↑ 0.8 Височина на сълзите"},   -- translation check: literal "Godhood" preserved (ft. wiki trivia)
	{"332", "Дрипите на Лазар", "След смъртта ти ще се явиш като Лазар и ще получиш неговия предмет"},
	{"333", "Разум", "Отключва напълно картата на всички етажи"},
	{"334", "Тяло", "↑ 3 Червени сърца"},
	{"335", "Душа", "+2 Духовни сърца#Дава аура, която отблъсква враговете и снарядите"},
	{"336", "Мъртъв лук", "Пиърсинг + спектрални сълзи#↑ {{Range}} +0.25 Обхват на сълзите#↓ {{Shotspeed}} -0.4 Скорост на стрелба#↓ -0.5 Височина на сълзите#↑ {{Tearsize}} +50% големина на сълзите"}, -- TODO: Piercing - Пиърсинг->Пронизващи (as token aka on every occurrence)
	{"337", "Счупен часовник", "Забавя враговете в произволни стаи#(по-малко вероятно е да ги ускори)"},
	{"338", "Бумеранг", "Замразява враговете#Може да вземе недостъпни предмети"},
	{"339", "Безопасна игла", "↑ {{Range}} +5.25 Обхват на сълзите#↑ {{Shotspeed}} +0.16 Бързина на стреляне#+1 Черно Сърце#↑ 0.5 Височина на сълзите"},
	{"340", "Кофеиново хапче", "↑ {{Speed}} 0.3 Бързина#Ставате по-малки#{{Pill}} Дава 1 произволно хапче"},
	{"341", "Разкъсана фотография", "↑ {{Tears}} 0.7 скорост на стреляне#↑ {{Shotspeed}} 0.16 скорост на сълзите"},
	{"342", "Синя шапка", "↑ 1 Червено сърце#↑ {{Tears}} 0.7 скорост на стреляне#↓ {{Shotspeed}} -0.16 скорост на сълзите"},   -- ~~en_us.lua: -16% Shot Speed down is wrong? (if it is always -0.16)
	{"343", "Ключ за външна врата", "↑ {{Luck}} +1 Късмет#+1 Духовно сърце#+2 ключа"},
	{"344", "Кибритена кутия", "+1 Черно Сърце#+3 Бомби"},
	{"345", "Синтетично масло", "↑ {{Damage}} 1.0 Щети#↑ {{Range}} 5.25 Обхват на сълзите#↑ 0.5 Височина на сълзите"},
	{"346", "Лека закуска", "↑ 1 Червено сърце"},  -- best possible common translation of Snack
	{"347", "Диплопия", "Само едно използване!#Удвоява всички артефакти/предмети в стаята"},
	{"348", "Плацебо", "Копира ефекта на хапчето, което държите"},
	{"349", "Дървен никел", "50% шанс да създатете произволна монета"},    -- see A Quarter comment on the nickel not being a type of coin (name) in Bulgaria
	{"350", "Токсичен шок", "Когато влезеъе в стая, всички враговете се натравят"},
	{"351", "Мега боб", "Нанася щети и отравя близките врагове#Създава взривна вълна#Тази вълна може да отвори тайни стаи"},
	{"352", "Стъклено оръдие", "Намалява здравето до 1/2 сърце при употреба#Пуска огромна, прозрачна спектрална сълза ((DAMAGE + 1) X 10)"},
	{"353", "Момче-бомбардировач", "+5 бомби#Бомбите експлодират в кръстовидна форма"},
	{"354", "Хрупкав Джак", "↑ 1 Червено сърце#Създава произволна дрънкулка на пода"},
	{"355", "Огърлицата на мама", "↑ {{Range}} 1.25 Обхват на сълзите#↑ 0.5 Височина на сълзите#↑ {{Luck}} +1 Късмет"},   -- translation check: literal "Mom's Necklace" (no pearls)
	{"356", "Акумулаторна батерия", "Активният предмет вече има двоен ефект"},
	{"357", "Кутия с приятели", "Дублира вашите спътници само за стаята в която сте"},
	{"358", "Вещер", "Стреляте диагонално с две сълзи като хапче R U A WIZARD#Спектрални слези"},
	{"359", "8 инчови пирони", "↑ {{Damage}} +1.5 Щети#Увеличава отблъскването на сълзите"},
	{"360", "Инкуб", "Копира атаката, статовете и ефектите на вашия герой"},
	{"361", "Подарък от съдбата", "Стреля сълзи със същите щети като вашия герой"},
	{"362", "Малък сандък", "Дава произволен елемент на през няколко стаи"},
	{"363", "Заклет протектор", "Нанася щети при контакт#Блокира и привлича снаряди#След блокиране има шанс да създадете вечно сърце"},
	{"364", "Зона \"Дружба\"", "Орбитална муха#Нанася щети при допир"},  -- TODO: test whether this formatting works correctly; translation check: translation of the concept of "Friend zone" based on the Bulgarian translation in Regular Show
	{"365", "Изгубена муха", "Движи се по стени и препятствие# Нанася щети при контакт"},
	{"366", "Разпръснати бомби", "+5 бомби#След детонация бомбата оставя 4 малки бомби, които експлодират"},
	{"367", "Залепващи се бомби", "+5 Бомби#Бомбите се придържат към врага#Когато бъде убит с бомба, съюзнически паяк се хвърля"},
	{"368", "Епифора", "Стрелянето в една посока увеличава скоростта на стрелба"},
	{"369", "Континуум", "↑ {{Range}} 2.25 Обхват на сълзите#↑ 1.5 Височина на сълзите#Сълзите минават през стени и се появяват от противоположната страна"},
	{"370", "Мистър Кукла", "↑ {{Tears}} 0.7 скорост на стреляне#↑ {{Range}} 5.25 Обхват на съзлите#↑ 0.5 Височина на сълзите#Дава 3 произволни сърца когато го вземете"},
	{"371", "Проклятието на кулата", "6 трол бомби се хвърлят, когато понесете щети"},
	{"372", "Заредено бебе", "Придружител на батерията#Създава батерия на случаен принцип или замразява всички врагове за известно време#Шанс да получите +1 заряд към вашия активен предмет"},
	{"373", "Мъртво око", "↑ {{Damage}} +25% Щети за всяка сълза, която удари успешно противник (макс. +100%)"},
	{"374", "Божествена светлина", "Случайна възможност за изстрелване на Свещена сълза, която изстрелва Лъч Светлина, когато удари враг"},
	{"375", "Шапка наблюдател", "Случайна възможност за избягване на снаряд#Имунитет от експлозии (включително Майчин крак)"}, -- translation check: good enough for the custom meaning here of Host
	{"376", "Презареждане", "Актуализира артикулите в магазина след покупка"}, -- translation check: based on translation of "re-stocking a store", although same word could also indicate "recharge"
	{"377", "Разкъсан пашкул", "Вражеските паяци стават неутрални"},
	{"378", "Номер 2", "След стрелба непрекъснато в продължение на 3 секунди, създава Butt Бомба под вас"},
	{"379", "Двойна визия", "Hotbox-а на сълзите става по-голям #Спектрални сълзи"},
	{"380", "Плати и Играй", "+5 Монети#Вратите изискват монети вместо ключове"},
	{"381", "Благословията на Едем", "↑ {{Tears}} 0.7 Бързина на сълзите#В началото на следващото ти бягане ще получиш произволен предмет"},
	{"382", "Приятелска топка", "Може да бъде хвърлен срещу враг, за да го хване#След следващото хвърляне заловеното същество ще се появи като съюзническо#Ще бъде с вас, докато умре"},
	{"383", "Детонатор за сълзи", "Детонира всяка сълза в стаята#Всяка сълза се разделя на 6"},
	{"384", "Малкият Гърди", "Зарежда и атакува врагове със заряд, нанасяйки щети при контакт"},   -- changed from "Малкият Харди" to the transliteration
	{"385", "Бъмбо", "Вдига легналите монети. Всяка 6 монета, която вземе, увеличава нивото си (UR4 изисква 12 монети)#UR2: може да даде произволен предмет за вдигане#UR3: стреля в същата посока като вас#UR4: гони врагове, оставя бомби#След получаване на UR4 продължава да събира монети и дава предмети за тях"},
	{"386", "D12", "Променя всички камъни и предмети в стаята на произволни (купчини, саксии, тротил, каменни блокове и др.)"},
	{"387", "Кадилница", "Създава голяма аура, която забавя враговете"},
	{"388", "Просяк за ключове", "Събира ключове, в замяна дава произволни сандъци"},
	{"389", "Торбичка с руни", "Създава произволна руна на всеки 5 стаи"},
	{"390", "Серафим", "Придружител, атаки със самонасочващи се сълзи с увеличени щети"},
	{"391", "Предателство", "Когато понесете щети, всички врагове в стаята са очаровани"},
	{"392", "Зодиак", "Дава ви ефект на произволен зодиакален знак#Ефектът се променя с всеки етаж"},
	{"393", "Змийска целувка", "Случайни шансове да отровите враг#Отравяне от контактни щети#Отровени врагове имат шанс да пуснат черно сърце"},
	{"394", "Белязан", "Стреляте сълзи автоматично по посока на маркер, който контролирате#↑ {{Tears}} 0.7 скорост на стреляне#↑ 0.3 Височина на сълзите#↑ {{Range}} 3.15 Обхват на сълзите"},
	{"395", "Технология X", "Атакувате с зареждащи лазерни пръстени"},
	{"396", "Камерен бръснач", "Създава портали, между, които можете бързо да се телепортирате"},  -- translation check: not a Stomach Razor
	{"397", "Привличащ лъч", "Сълзите ви летят стриктно по лъча светлина, без да се отклоняват дори когато се движите#↑ {{Tears}} 0.5 скорост на стреляне#↑ {{Range}} 5.25 Обхват на сълзите#↑ {{Shotspeed}} 0.16 скорост на сълзите#↑ 0.5 Височина на сълзите"},
	{"398", "Плът на бога", "Случайна възможност за свиване на враг#По-малките врагове може да бъдат убити чрез смачкване"},
	{"399", "Паст от пустотата", "↑ {{Damage}} 1.0 Щети#↑ 0.5 Височина на сълзите#{{Chargeable}} След продължителна стрелба в продължение на 3 секунди на главата ще се появи червен кръст, след спиране на стрелбата ще се появи черен пръстен, причиняващ големи щети#Враговете, убити от пръстена, имат шанс да пуснат Черно сърце"},    -- roughly even more literal translation (was closer to "Maw of the Abyss" in previous commit)
	{"400", "Копието на съдбата", "Пред вас се появява копие, което нанася X 2 щети"},
	{"401", "Експлозивен", "Сълзите със случаен шанс могат да залепнат за врага, след което започват да растат по размер, докато не избухнат"},
	{"402", "Хаос", "Сега пиедесталите ще бъдат избирани от произволни групи от предмети# Също така създава 1-6 предмета за взимане"},
	{"403", "Паячна модификация", "Показва здравето на враговете и щетите, които нанасяте#Налага случаен ефект върху врага при контакт#Може да създаде съюзник паяк или батерия"},
	{"404", "Детето Пръдня", "Блокира снаряди#След блокиране може да отдели отровни газове#Газовете могат да очароват с определен шанс"},
	{"405", "Фатален бъг", "Лети из стаята и прилага случайни ефекти върху враговете при контакт"},    -- translation check: literally "Fatal bug" to indicate the "Game breaking bug"
	{"406", "D8", "Случайно променя вашите параметри#Засяга само щети, скороста на сълзите, обхват на сълзите и скорост"},
	{"407", "Чистота", "Увеличава една от характеристиките, в зависимост от цвета на аурата#При получаване на щети в съседната стая ще се появи произволна аура#Червено = ↑ {{Damage}} +4.0 щети # Синьо = ↑ {{Tears}} -4 период между сълзите#Жълто = ↑ {{Speed}} +0,5 скорост#Оранжево = ↑ {{Range}} +7,5 обхват на сълзите"},
	{"408", "Атаме", "Когато нанесете щети, ще се появи черен пръстен, причиняващ големи щети#Враговете, убити от пръстена, имат шанс да пуснат Черното сърце"},
	{"409", "Празен съд", "+2 Черни сърца#Ако нямате останали червени сърца, дава летене и кратка неуязвимост при поемане на щети"},
	{"410", "Зло око", "Има случаен шанс да освободите око, което стреля в същата посока като вас"},
	{"411", "Жадуваща кръв", "За всяко убийство дава ↑ {{Damage}} +0,5 щети#Макс. +5 щети за 10 убийства#Действа само в стаята"},
	{"412", "Демонично зачатие", "След като нанесете достатъчно щети, вие постоянно ще получите дяволски спътник#Възможно е да получите няколко спътници"},
	{"413", "Непорочно зачатие", "След като вземете достатъчно сърца, ще получите постоянно ангелски спътник#Възможно е да получите няколко спътници"},
	{"414", "Повече опции", "2 елемента се появяват в златни стаи#Можете да вземете само един"},
	{"415", "Корона от светлина", "+2 Духовни сърца#↑ {{Damage}} Щети X 2, ако нямате нито едно празно червено сърце#При поемане на щети бонусът се нулира и опреснява при преместване в друга стая"}, -- TODO: Add heart-dependent effects list-wise (straight up missing in this one); ~~en_us.lua has "Crown Of Light" capitalization
	{"416", "Дълбоки джобове", "Можете да носите 2 карти / руни / хапчета със себе си"},
	{"417", "Сукуб", "Лети из стаята, има аура, която нанася щети на врагове#↑ {{Damage}} +50% щета, докато си в аурата"},
	{"418", "Плодов пай", "Всяка сълза има произволен ефект"},
	{"419", "Телепорт 2.0", "Телепортира се в произволна стая, в която все още не сте били#Последователност: {{Room}}>{{BossRoom}}>{{SuperSecretRoom}}>{{Shop}}>{{TreasureRoom}}>{{SacrificeRoom}}>{{DiceRoom}}>{{Library}}>{{CursedRoom}}>{{MiniBoss}}>{{ChallengeRoom}}{{BossRushRoom}}>{{IsaacsRoom}}{{BarrenRoom}}>{{ArcadeRoom}}>{{ChestRoom}}>{{SecretRoom}}>{{DevilRoom}}{{AngelRoom}}>{{ErrorRoom}}"}, -- ~~a couple of extra(?) spaces in en_us.lua
	{"420", "Черен прах", "Оставяте черна следа на пода#Ако образувате кръг, ще създаде пентаграма, която нанася щети на враговете"},
	{"421", "Бъбречен боб", "Прилага чар на близки врагове, когато се активира"},
	{"422", "Светещ пясъчен часовник", "Ще ви отведе до предишната стая#Всичко наоколо възстановява първоначалното си състояние, което са имали, когато сте били в предишната стая"},
	{"423", "Кръг на защитата", "Голям кръг от светлина, нанасящ щети#Шанс за отклоняване на вражески снаряди"},
	{"424", "Торбичка за глава", "Често ще намирате торбички с предмети"},
	{"425", "Фенерче", "Фенерче, неговата светлина забавя враговете и техните снаряди"},
	{"426", "Обсебен фен", "Повтаря вашите движения с 3 секунди закъснение#Нанася щети при контакт"},
	{"427", "Миньор", "Създава цев от динамит#Цевта може да се движи из стаята#Ако се използва повторно в същата стая, взривява старата цев и създава нова"},
	{"428", "Пижама", "+4 Духовни сърца#Възстановява здравето"},
	{"429", "Главата на Търговеца", "Случайни шансове за хвърляне на стотинка след удряне на враг"},    -- TODO: translation token for Keeper
	{"430", "Бащина муха", "Повтаря вашите движения с 3 секунди закъснение#Стреля по близките врагове"},
	{"431", "Многоизмерно дете", "Повтаря вашите движения с 3 секунди закъснение#Сълзите, преминали през него, се дублират и нанасят повече щети"},
	{"432", "Лъскави бомби", "Бомбите имат шанс да пуснат случаен пикап след детонация"},
	{"433", "Моята сянка", "Когато нанесете щети, ще се появи черна съюзническа ларва, която атакува врагове#Остава с вас, докато умре"},
	{"434", "Буркан с мухи", "За всяко убийство в банката ще се появи една съюзническа муха#Можете да натрупате общо 20 мухи#Използването на банката с мухи ще освободи всички мухи"},
	{"435", "Малкият Локи", "Спътник, стреля в 4 посоки"},
	{"436", "Мляко!", "{{Tears}} След като понесете щети, вие получавате по-бърза стрелба на сълзите за останалата част от стаята"},
	{"437", "D7", "Възстановява преди това убитите врагове в стаята#Позволява ви да получите отново наградата за освобождаване на стаята"},
	{"438", "Биберон", "+1 Духовно сърце#↑ {{Tears}} 0.75 скорост на стреляне#Героят ви става малък, хитбоксът му намалява"},
	{"439", "Кутията на мама", "Създава произволна дрънкулка на пода#Докато държите предмета:#Удвоява ефекта от дрънкулката#↑ {{Luck}} +1 късмет"},
	{"440", "Камък в бъбрека", "В случаен момент персонажът ще спре да стреля, по това време можете да заредите серия от атаки#Характерът ще изплюе камъка от бъбреците, причинявайки големи щети, а след това ще пусне вълна от сълзи с много висока скорост # ↓ 0,2 скорост # ↓ 15 обхват на стрелба # ↑ 2,0 Височина на сълзите"},
	{"441", "Мега Заряд", "Когато се използва, атакува с мощен кървав поток, като#Атаката на Мега Сатаната продължава 15 секунди#Можете да се движите между стаите, продължавайки да стреляте"},
	{"442", "Короната на тъмния принц", "Ако имате точно 1 червено сърце:#↑ {{Range}} 1,5 обхват на сълзите#↑ {{Tears}} 0,75 скорост на стреляне#↑ {{Shotspeed}} 0,2 скорост на сълзите#Не работи с Lost"},
	{"443", "Ябълка!", "Случайна възможност за изстрел на острие, нанасящо 400% щети#↑ {{Tears}} 0.3 скорост на стреляне"},
	{"444", "Графитен молив", "На всеки 15 изстрела ще пускате голямо разпръскване на сълзи#Всяка такава сълза ще нанася двойна щета"},
	{"445", "Кучешки зъб", "↑ {{Damage}} +0,3 щети # ↑ {{Speed}} +0,1 скорост#Ще чуете вой на вълк, ако наблизо има тайна стая или таен люк"},    -- TODO: differentiate between wolf howl effect and dog bark effect
	{"446", "Мъртъв зъб", "По време на стрелба се появява зелена аура, която отравя враговете"},
	{"447", "Задържащ се боб", "Докато стреляте, можете да създадете облак с щети с някакъв шанс#Може да се премести, като се стреля по него"},    -- very hard to come up with a meaningful translation of "linger"
	{"448", "Парче стъкло", "Когато получите щета, има шанс да получите +5 до обхвата на атака и възможността да оставите кървава следа зад себе си, която нанася щети на врагове#Действа само в стаята"},
	{"449", "Метална пластина", "+1 Духовно сърце#Снарядът на врага може да бъде отблъснат"},
	{"450", "Окото на Алчността", "Сълзите имат малък шанс да превърнат врага в злато"},
	{"451", "Таро покривка", "Дава произволна карта / руна#Усилва ефекта на повечето карти, руни и подобни предмети"},    -- translation check: re-translation of "cloth" in accordance with wiki trivia; changed description to "*boosts* effect of *most* cards, runes and similar", I don't remember the range of effect of this item in AB+, but I'm pretty sure even then not everything was doubled
	{"452", "Разширени вени", "Когато нанесете щети, ще пуснете 10 сълзи около себе си#Сълзите са с увеличени щети"},
	{"453", "Отворена фрактура", "Стреляте кости#Костите се разделят на малки парчета при удар#↑ 1,5 обхват на стрелба"},  -- addition to translation based on desc of "compound fracture" (as open)
	{"454", "Полидактилия", "Може да носи две карти / хапчета / руни#Дава произволна карта / хапче / руна"},
	{"455", "Изгубената монета на татко", "↑ {{Range}} 1,5 обхват на стрелба#{{Coin}} Дава късметлийска монета"},
	{"456", "Мухлясал хляб", "↑ 1 Червено сърце"},
	{"457", "Конична глава", "+1 Духовно сърце#Има шанс да блокира щети"},
	{"458", "Пъп", "Дава произволна дрънкулка#+ допълнителен слот за дрънкулки"},
	{"459", "Синузит", "Шанс за стрелба на сополи#Сополите се придържат към врага и му нанасят щети, докато той умре"},
	{"460", "Глаукома", "Шанс да зашемети враговете"},
	{"461", "Паразитоид", "Шанс за изстрелване на бавно яйце паяк#Когато бъде ударен от яйце паяк, съюзническа муха / паяк ще се появи"},
	{"462", "Окото на Белиал", "↑ {{Range}} +1.5 Обхват на сълзите#↑ +1 Височина на сълзите#Сълзите пронизват враговете#След първия удар, сълзата удвоява щетите си и става самонасочваща се"},
	{"463", "Сярна киселина", "↑ {{Damage}} 0.3 щети#Киселинна сълза може да разбие камък или да отвори тайна стая"},
	{"464", "Символ за баланс", "+2 Духовни сърца#Шампионски чудовища пускат по-добри предмети"},  -- translation check: "symbol" for "glyph" considered good enough
	{"465", "Аналогов стик", "↑ {{Tears}} +0.3 скорост на стреляне#Позволява ви да стреляте по диагонал или в двете посоки, ако стреляте с аналоговия стик"},
	{"466", "Зараза", "Първият враг, убит в стаята, експлодира с облак газ и отрови всички близки врагове#Отровените врагове също експлодират"},
	{"467", "Палец!", "{{Damage}} Нанася малки щети на враговете, в която посока гледа пръстът"},
	{"468", "Сянка", "Повтаря вашите движения с 3 секунди закъснение#Нанася щети при контакт"},
	{"469", "Депресия", "Оставя следа от сълзи#При контакт с враг, ще пусне Лъч Светлина с определен шанс"},
	{"470", "Хъши", "Лети из стаята#Нанася щети при контакт#Спира при стрелба"},   -- translation check: transliteration
	{"471", "Малък Монстро", "Зарежда атаката си#Атакува също като шефа на Чудовището"},
	{"472", "Бебе крал", "Всички спътници го следват#Спира, докато стреля#Телепортира се обратно при вас, когато спрете да стреляте"},
	{"473", "Голям Чъби", "Лети много бавно в посока на огъня#Нанася щети при контакт"},
	{"474", "Сливица", "Блокира снаряди"},
	{"475", "План C", "Само едно използване!#Нанася 9 999 999 щети на всички врагове в стаята, след 3 секунди ви убива"},
	{"476", "D1", "Дублира 1 случаен елемент в стаята"},
	{"477", "Пустота", "При използване абсорбира всички вещи на пиедестали в стаята#Активни вещи: Активират се на момента и при всяко следващо използване#Пасивният предмет дава произволен бонус към характеристиките"},
	{"478", "Пауза", "Когато се активира, всички врагове замръзват, докато не стрелнете"},
	{"479", "Леярна", "Абсорбира дрънкулката, която носите и ви дава ефекта завинаги"},
	{"480", "Компост", "Преобразува всеки предмет, взет в стаята, в съюзнически паяк / муха#Удвоява броя на наличните мухи / паяци"},
	{"481", "Анализатор", "Когато се използва, той дава малък +/- към произволни характеристики#Дава случаен ефект на сълзите, само за стаята в която сте#Прецаква всички спрайтове"},
	{"482", "Превключване", "Когато се използва, той променя характера ви на случаен#Има вероятност по време на употреба последният предмет, който сте взели, да изчезне"},
	{"483", "Мама Мега!", "Само едно използване!#Засяга целия етаж#Експлодира всички обекти#Нанася 200 щети на всички врагове#Отваря тайни стаи / Стая на бос Ръш / вход в Синята паст"},
	{"484", "Чакай, какво?", "Когато се използва, отблъсква враговете и създава взривна вълна"},
	{"485", "Изкривено пени", "50% шанс да дублирате всички предмети в стаята#50% шанс да унищожите всички предмети в стаята и да създадете 1 монета"},    -- possible alt of roughly same meaning: "Извито пени"
	{"486", "Тъп бръснач", "Нанася щети, но без да губи здраве#Активира елементи, които работят след нанасяне на щети"},
	{"487", "Картофобелачка", "Когато се активира, премахва 1 контейнер с червено сърце, в замяна дава: #↑ {{Damage}} 0,2 щети и \"Meat Cube \""}, -- TODO: fill in all effects list-wise
	{"488", "Метроном", "Когато се използва, той дава ефект на произволен предмет в стаята"},
	{"489", "D-безкрайност", "Ефект на случайна матрица#Можете да видите кой ефект на матрицата ще бъде следващ"},
	{"490", "Душата на Едем", "Само едно използване!#Създава 2 артефакта в стаята, в която се намирате"},
	{"491", "Киселинно бебе", "Дава произволно хапче на всеки две стаи#Всяко използване на хапчето отравя враговете в стаята"},
	{"492", "ХЕЙ, СЛУШАЙ!", "↑ {{Luck}} +1 Късмет#Показва тайни стаи, маркирани камъни или тайни люкове под камъни"},
	{"493", "Адреналин", "За всяко празно сърце дава ↑ 0,2 щети"},
	{"494", "Стълбата на Яков", "Електрически сълзи#Излъчват искри в произволна посока при удар"},
	{"495", "Фантом чушка", "Шанс да изстреля пламък вместо сълза"},
	{"496", "Евтаназия", "Шанс за изстрел на спринцовка#Спринцовката незабавно убива обикновени врагове, експлодирайки в няколко малки спринцовки"},
	{"497", "Камуфлажни гащи", "Слага камуфлаж на героя при влизане в стая, докато не започнете да стреляте"},
	{"498", "Двойственост", "Ако след шефа трябва да се появи стая ангел / дявол, тогава ще се появят и двете#Можете да влезете само в една по ваш избор"},
	{"499", "Причастие", "100% шанс за откриване на ангелска стая"},
	{"500", "Торбичка с торбички", "С произволен шанс дава торбички с предмети"},
	{"501", "Торбичка на Алчността", "На всеки 25 монети дава ↑ 1 Red Heart#Позволява на пазителя да има повече здраве"},    -- original translation: "Езофаг на алчността" <-> "Greed's Esophagus" (for which "Gullet" is an old-fashioned word). Re-translated to "Greed's sack" because it is simpler and item looks enough like that visually.
	{"502", "Голяма пъпка", "Шанс да изстреляте бавна сълза, която нанася повече щети и оставя слуз на пода"},
	{"503", "Малкия рог", "Шанс да изстреляш сълза, мигновено убивайки врагове#Не работи на Bosses и Mini-Bosses"},
	{"504", "Кафяво късче", "Призовава съюзническа куполна муха за използване за атака на врагове"},
	{"505", "Poke Go", "Шанс за хвърляне на очарован враг при влизане в нова стая"},
	{"506", "Предател", "Удрянето на враг има шанс да причини кървене, като нанася щети, равни на 10% от здравето на врага на всеки 5 секунди"},
	{"507", "Остра сламка", "{{Damage}} Нанася щетите ви + 10% от макс. вражеско здраве#Засяга всички врагове в стаята#Шанс да получите половината червено сърце или половината Духовно сърце"},
	{"508", "Бръсначът на мама", "Придружаващ орбитален спътник, при контакт, нанася кървене, като нанася щети, равни на 10% от здравето на врага на всеки 5 секунди."},
	{"509", "Кърваво око", "Орбитален спътник изстрелва по посока на погледа ви на всеки 2 секунди"},
	{"510", "Бълнуващ", "Призовава съюзник - луда версия на шефа#Шефът е произволно избран#Работи в стаята"},
	{"511", "Ядосана муха", "Лети около произволен враг, докато умре#Нанася щети при контакт"},
	{"512", "Черна дупка", "Хвърля черна дупка на земята, всмуквайки всичко, вкл. врагове#Нанася щети на враговете"},
	{"513", "Бозо", "↑ 0,1 щети#+ 1 Духовно сърце# Шанс да очарова / изплаши врага#Случайна възможност за създаване на дъгова купчина при понасяне на щети"},
	{"514", "Счупен модем", "Случайно лагва враговете и техните снаряди"},
	{"515", "Тайнствен подарък", "Само едно използване#Създава артефакт от басейна на стаята, в която се намирате#Шанс да получите парче въглен или кака"},
	{"516", "Пръскачка", "Спринклер, който изстрелва сълзи в кръг#Може да копира ефектите от сълзите ви"},
	{"517", "Бързи бомби", "+7 бомби#Премахва закъснението между употребите на бомби, за да можете да ги използвате много бързо, като бързо натиснете клавиша на бомбата"},
	{"518", "Приятел в кутия", "Случайно дете от режим на кооперация#Има произволен ефект на сълзите#Случайно се променя на всеки етаж"},
	{"519", "Малката лудост", "Луда версия на спътника#На всеки 10 секунди се променя произволно"},
	{"520", "Кабели за стартов ток", "+1 зареждане за активния предмет за всеки 15 убийства"},
	{"521", "Купон", "Прави един произволен артикул в магазина безплатен"},
	{"522", "Телекинеза", "Замразява близки вражески снаряди за 3 секунди#След това те летят обратно#Презарежда се за 2 секунди"},
	{"523", "Кутия за доставка", "Когато се използва, взима до 6 елемента#Повторното използване създава тези елементи на пода#Може да премества елементи между стаите"},   -- translation check: original translation "Delivery Box" preserved as close enough
	{"524", "Технология Нула", "Сълзите са електрически свързани заедно"},
	{"525", "Проказа", "При получаване на щети, получавате орбитален спътник#Макс. 3 сателита едновременно#Сателитите ще бъдат унищожени, ако нанесат твърде много щети"},
	{"526", "7 печата", "Случайният спътник на ездач се появява и се сменя на всеки 10 секунди"},
	{"527", "Мистър МИ!", "Придружителят, който изпълнява вашите поръчки:#Отваря врати и сандъци, вдига предмети, краде предмети от магазина / от дявола, атакува врагове, експлодира, активира плочи под налягане"},  -- translation check: translating "properly" as "Мистър АЗ!" would ruin the reference
	{"528", "Ангелска призма", "Сълза, прелетяла през орбитална призма, ще се разцепи на 4 подобни сълзи"},
	{"529", "Пук!", "Сега сълзите имат физика като билярдни топки"},
	{"530", "Списък на смъртта", "Осигурява полезна награда, ако убивате врагове в реда, в който ще бъдат маркирани"},
	{"531", "Хемолакрия", "Сълзите летят в дъга#При сблъсък те летят на фрагменти#↑ {{Damage}} 31% щети#↓ {{Tears}} - скорост на стреляне"}, -- ~~en_us.lua: markup items for stats missing! (this might not hold true in latest commits?)
	{"532", "Лакрифагия", "Една сълза в полет се забавя#След спиране, тя избухва в малки сълзи#Можете да \"нахраните\" сълза, като стреляте по нея, тогава тя ще стане по-голяма"},
	{"533", "Трисвятост", "Сълзите стават пронизващи лъчи светлина#(принцип, подобен на Brimstone)"},  -- a religious hymn name. word in translation formatted as an abstract concept rather than as an adjective (which should be more accurate, but less good sounding).
	{"534", "Ученическа раница", "Позволява ви да носите 2 активни предмета#Сменяте ги с CTRL"},
	{"535", "Одеяло", "+1 Духовно сърце#Дава еднократен щит в стаята на боса"},
	{"536", "Жертвен олтар", "Жертва 2 случайни спътници на играча, в замяна дава дяволски предмет за всеки"},
	{"537", "Малкият плювач", "+1 хапче# Атакува чрез плюене на слуз на пода#Когато изядете хапче, неговият тип атака се променя"},
	{"538", "Стъклени топчета", "Дава 3 случайни дрънкулки#При получаване на щети има шанс да консумирате дрънкулка и да постигнете неговия ефект завинаги"},
	{"539", "Тайнствено яйце", "Когато получите щети, се появява омагьосан враг#Колкото повече стаи преминете, без да понесете щети, толкова по-силно ще бъде омагьосаното същество"},
	{"540", "Плосък камък", "Сълзите отскачат от пода#Удрянето на пода причинява AoE щети"},
	{"541", "Костен мозък", "+1 Сърце от кост#Създава 3 червени сърца на пода"},
	{"542", "Ставно ребро", "Орбитален сателит#Отблъсква снаряди"},    -- trahslation check: preserved, for a lack of a better translation
	{"543", "Света земя", "При получаване на щети създава Бяла купчина на пода#Бялата купчина има аура, която увеличава скоростта на сълзите"},    -- TODO: Add poop's aura effects list-wise
	{"544", "Наточено ребро", "Нокът витае пред героя#Нанася щети при контакт"},
	{"545", "Книга на мъртвите", "При използване призовавате Орбитална кост или Омагьосано чудовище за всеки убит враг в стаята#Използвайте преди да излезете от почистената стая"},
	{"546", "Пръстенът на татко", "Създава аурен пръстен, който замразява враговете"},
	{"547", "Документи за развод", "+1 Сърце от кост#↑ {{Tears}} 0,7 скорост на стреляне#{{Trinket21}}Дава дрънкулка \"Тайнствен лист хартия \""},
	{"548", "Челюстна кост", "Бумеранг# Нанася X 2 от щетите ви"},
	{"549", "Крехки кости", "Заменя всичките ви червени сърца с 6 Сърца от кости#Когато загубите Сърцата от кости, изстрелва кости в различни посоки и дава постоянна ↑ {{Tears}} 0,5 скорост на стреляне"},    -- TODO: Add bone heart damage effects list-wise
	{"550", "Счупена лопата", "Кракът на Мама непрекъснато ви атакува#Използване спира Кракър на Мама в стаята#Ако го замените с друг елемент и излезете от стаята, той ще изчезне#(Опитайте Boss-Rush с този елемент!)"},
	{"551", "Счупена лопата", "Втора част на лопатата#Използвайте лопатата върху купчината мръсотия в \"Тъмната стая\""},
	{"552", "Лопатата на мама", "Когато се използва, той създава капак на пода до следващото ниво#Използвайте лопата в купчина мръсотия на ниво \"Тъмната стая\"#Отключва нещо страхотно "},
}

---------- Trinkets ----------
EID.descriptions[languageCode].trinkets={
	{"1", "Погълната монета", "Когато понесете щета, монета пада на пода"},
	{"2", "Вкаменено ако", "50% повече дропове от изпражненията"},   -- TODO: translation token for "poop" (currently different on every entry); TODO: if the current one is used, lacks stress on the "a" to be best read
	{"3", "AAA батерия", "Намалява размера на таксата за активния предмет с 1"},
	{"4", "Счупено дистанционно", "Телепортира ви в произволна стая, когато използвате активния предмет"},
	{"5", "Лилаво сърце", "Повече шампионски чудовища#Увеличава шанса за появата на Бос Предизвикателна стая"},
	{"6", "Счупен магнит", "Привлича монети"},
	{"7", "Мънисто от броеница", "Увеличава шанса за намиране на Ангелска стая"},
	{"8", "Игрова дискета", "Шанс за ефект на предмета \"Детето игра\" при поемане на щети#(кратка неуязвимост + щети при контакт)"},  -- for lack of a better translation of "cartridge" (unless one is colloquially known.)
	{"9", "Пулсиращ червей", "Пулсиращи сълзи#Засяга само hitbox-а"},
	{"10", "Извиващ се червей", "Сълзите летят като вълни#↑ {{Tears}} +0,3 скорост на стреляне"},
	{"11", "Червей пръстен", "Сълзите летят на спирала"},
	{"12", "Сплескан червей", "Големи сълзи"},
	{"13", "Кредит за магазин", "Позволява ви да вземете един артикул от магазина безплатно#Може да се използва само един път"},
	{"14", "Гъбички", "Бодлите и локвите вече не ви увреждат"},
	{"15", "Късметлийски камък", "На мястото на разрушения камък се появява монета"},
	{"16", "Нокътят на мама", "Кракът на мама атакува враговете веднъж в минута#Може да ви атакува, ако няма врагове"},
	{"17", "Черно червило", "Появяват се повече черни сърца"},
	{"18", "Библейска брошура", "Появяват се повече вечни сърца"}, -- re-translation based on modern interpretation of the literary "tract", formerly "Библейски трактат"
	{"19", "Кламер", "Златни сандъци се отварят без ключове"},
	{"20", "Маймунска лапа", "Дава черно сърце, ако останете на половин сърце#Изчезва след 3 употреби"},
	{"21", "Тайнствена хартия", "Имитира \"Полароид\", \"Отрицателен\" и \"Липсващ плакат\""},
	{"22", "Опашка от Демон", "Променя сърцата в стаите с черни сърца или други предмети"},
	{"23", "Плакат за изгубен", "След смъртта в Стаята на жертвоприношението, вие ще се появите като \"Изгубеният\""},
	{"24", "Монета за дупето", "Всеки път когато взмете монета, пърдите"},
	{"25", "Мистериозен шоколад", "Създава изпражнения произволно"},
	{"26", "Кука червей", "Сълзите летят по Г-образна траектория#↑ {{Range}} +10 Обхват на сълзите"},
	{"27", "Прав червей", "↑ {{Shotspeed}} +0.5 скорост на стреляне"},
	{"28", "Счупен Анкх", "22% шанс да се възродите отново като ??? (Синьото дете)"},
	{"29", "Рибешка глава", "Призовава съюзническа муха при повреда"},
	{"30", "Зачервено око", "Случайна възможност за отровни врагове#100% шанс с късмет +18"},
	{"31", "Пинче", "Случайна възможност за изстрелване на пронизваща сълза"}, -- not to be confused with "drawing pin", respectively "габърче" (*apparently officially correct spelling since 2012).
	{"32", "Псилоцибинова гъба", "Всяка стая получавате ефекта на произволна гъба"},   -- more "official" translation based on the non-colloquial name of the mushroom; feel free to update with a more colloquial name if any.
	{"33", "Пъпна връв", "Ако останат 1/2 сърца, ще получите Стивън младши"},
	{"34", "Детско сърце", "Появяват се повече червени сърца"},
	{"35", "Извит рог", "↑ {{Damage}} +2 Щети"},
	{"36", "Ръждив ключ", "Още ключове и сандъци"},
	{"37", "Козе копито", "↑ {{Speed}} +0.15 Скорост"},
	{"38", "Перлата на мама", "Появяват се повече Духовни сърца"},
	{"39", "Рак", "↑ {{Tears}} -2 Период между сълзите"},
	{"40", "Червена кръпка", "{{Damage}} 20% Шанс да получите +1,8 щети за стаята, ако сте ранени#{{Luck}} 100% шанс при 8 късмет"},
	{"41", "Кибритена клечка", "Появяват се повече бомби#Премахва \"Кърлеж\""},
	{"42", "Късметлийски пръст", "↑ {{Luck}} +1 Късмет"},   -- TODO: add extra effects
	{"43", "Прокълнат череп", "Когато останат 1/2 сърца, телепортира се в предишната стая"},
	{"44", "Безопасно покритие", "Появяват се повече хапчета"},    -- translation check: ambiguous translation preserved because of the ambiguous meaning/reference of Safety Cap itself
	{"45", "Асо Пика", "Появяват се повече карти"},
	{"46", "Вилицата на Исаак", "Шанс за възстановяване на 1/2 червено сърце след освобождаване на стая"},
	{"47", "000", "<Не съществува>"},
	{"48", "Изгубена страница", "При получаване на щети има шанс да нанесете щети на всички врагове в стаята"},
	{"49", "Кърваво пени", "Шанс да получите половин червено сърце, когато вземете монета"},
	{"50", "Изгорено пени", "Шанс да получите бомба, когато вземете монета"},
	{"51", "Плоско пени", "Шанс да получите ключ, когато вземете монета"},
	{"52", "Фалшиво пени", "Когато вземете монета, има шанс да получите допълнителна"},
	{"53", "Кърлеж", "- 15% здраве на боса#лекува за 1 сърце, когато влезете в стаята на боса#Не можете да го премахнете, след като го вземете (само с ключодържателя \"Match\")"},
	{"54", "Главата на Исаак", "Спътник със пронизващи сълзи"},
	{"55", "Вярата на Маги", "Всеки етаж дава 1 вечно сърце"},
	{"56", "Езикът на Юда", "Отстъпка за дяволска стая"},
	{"57", "Душата на ???", "Спътник който подскача из стаята#Стреля в същата посока като вас"},
	{"58", "Къдрицата на Самсон", "{{Damage}} 1/15 шанс да получите +0.5 щети за стаята при убиване на чудовище#{{Luck}} 100% шанс при 10 късмет"},
	{"59", "Окото на Каин", "25% шанс за разкриване на цялата карта на всеки етаж"},
	{"60", "Кракът на Ева", "{{Collectible117}} 5% шанс да изхвърли мъртва птица при правене на убийство#{{Luck}} 100% шанс при 8 късмет"},    -- TODO: translation token for "spawn"; check: "bird" part dropped
	{"61", "Лява ръка", "Преобразува всички сандъци в червени"},
	{"62", "Блестящ камък", "Маркираните камъни и камъните с тайни люкове се подчертават на всеки 10 секунди"},
	{"63", "Безопасни ножици", "Намалява трол бомбите и ги прави нормални пикапи"},
	{"64", "Дъгов червей", "Случаен ефект на червей всеки 3 секунди"},
	{"65", "Тения", "↑ {{Range}} Обхват на сълзите x 2#-50% Височина на сълзите"},
	{"66", "Мързелив червей", "↓ {{Shotspeed}} -0,4 скорост на стреляне#↑ {{Range}} 4 обхват на стрелба#↑ 2 височина на сълзите"},
	{"67", "Пропукан зар", "Шанс срабатывания эффекта случайного кубика при получении урона"}, -- TODO: translate from Russian (lol, also not the only case)
	{"68", "Супер магнит", "Привлича обекти и врагове"},
	{"69", "Избледнял полaроид", "Случайно замаскира играча#Обърква враговете"},
	{"70", "Въшка", "Шанс за хвърляне на съюзнически паяк, докато разчиствате стая"},
	{"71", "Бъбрекът на Боб", "Бомбите оставят отровна локва"},
	{"72", "Батерия за часовник", "Повече батерии"},
	{"73", "Експлодираща шапка", "След като бомба експлодира, има шанс да остави друга бомба за взимане"}, -- "cap" translated as "hat" (as opposed to ru.lua and original translation here - "cover"/"lid")
	{"74", "Търсач на съкровища", "Повече тайни люкове под камъни"},   -- translation preserved for better reading, though "stud" =/= "treasure"
	{"75", "Грешка", "Случаен ефект на дрънкулка във всяка стая"},
	{"76", "Покер чип", "50/50 шанс да намерите допълнителни предмети или нищо/враг в сандъци"},
	{"77", "Блистер", "Увеличава отблъскването"},
	{"78", "Втора ръка", "Ефектите върху враговете продължават по-дълго"},
	{"79", "Неизследвана безкрайност", "Малък шанс да получите копие на карта / руна, след като я използвате"},    -- translation check: preserved. sounds better than the accurate one and wouldn't make sense either way.
	{"80", "Черно перо", "↑ {{Damage}} +0,2 щети за всеки наличен дяволски предмет"},  -- TODO: clarify "devil item" using different wording
	{"81", "Сляпа ярост", "Неуязвимостта след нанасяне на щети трае по-дълго"},
	{"82", "Златна подкова", "+ 15% шанс за двойна златна стая#(два елемента за избор, можете да вземете само един)"},
	{"83", "Ключ от магазина", "Отваря всички магазини"},
	{"84", "Ребро на Алчността", "Алчността / Супер Алчността вече няма да се появяват в магазини / тайни стаи"},
	{"85", "Карма", "Използването на дарителската машина може да ви излекува или да създадете просяк"},    -- TODO: Add effects list-wise
	{"86", "Малка ларва", "След счупването на изпражнение, се появява съюзническа муха"},
	{"87", "Медальонът на Мама", "Лекува за половин червено сърце, когато използвате ключ#Всички половин сърца се заменят с пълни"},
	{"88", "НЕ!", "Изключително нисък шанс за намиране на активен предмет"},
	{"89", "Детска каишка", "Сателитите са по-близо един до друг"},
	{"90", "Кафява шапка", "Изпражненията избухват, след като бъдат унищожени"},
	{"91", "Меконий", "Увеличава шанса за появата на черно сърце от Черно изпръжнение"},
	{"92", "Напукана корона", "Подобрява статистиката ви с около 33% въз основа на вашите артефакти#↑ 0,2 бързина на сълзите"},
	{"93", "Използвана пелена", "Мухите на врага могат да станат неутрални"},
	{"94", "Рибешка опашка", "Дублира всички паяци/мухи, когато се създадат"},
	{"95", "Черен зъб", "Случайна възможност за изстрел на отровен черен зъб"},
	{"96", "Червей Уроборос", "Сълзите летят по огромна сводеста траектория#Спектрални сълзи#↑ {{Range}} +4 Обхват на сълзите#↑ +2 Височина на сълзите"},
	{"97", "Сливица", "Много нисък шанс за появата на спътник при поемане на щети#Може да се задейства два пъти, след което изчезва"},
	{"98", "Сопол", "Шанс да изстреляш лепкави сополи"},
	{"99", "Супер топка", "Шанс да изстреляш подскачаща сълза"},
	{"100", "Осветяваща крушка", "Когато вашият активен артикул е зареден:#↑ {{Speed}} 0,25 скорост#↑ {{Range}} +0,75 обхват на стрелба#↑ {{Tears}} 0,2 бързина на сълзите#↑ {{Shotspeed}} +0,1 скорост на стреляне#↑ {{Damage}} +0,5 щети#↑ {{Luck}} +1 късмет"},
	{"101", "Затъмнена крушка", "Когато вашият активен артикул е напълно разреден:#↑ {{Speed}} 0,5 скорост#↑ {{Range}} 1,5 обхват на стрелба#↑ {{Tears}} 0,4 бързина на сълзите#↑ {{Shotspeed}} +0,3 скорост на стреляне#↑ {{Damage}} +1,5 щети#↑ {{Luck}} +2 късмет"},
	{"102", "Разкъсана карта", "+1 допълнителна тайна стая на новия етаж, ако го сържите"},
	{"103", "Равенство!", "Ако имате еднакъв брой монети, бомби и ключове:#прави предметите за взимане двойни"},
	{"104", "Ядец", "Възможност за поява на пиедесталите на артефактите при нанасяне на щети#Изчезва след употреба"},
	{"105", "Торба с обяд", "Шанс за хвърляне на артефакт с допълнително здраве при нанасяне на щети#Изчезва след употреба"},
	{"106", "Изгубен корк", "Увеличава радиуса на увреждане на локви и следи, оставени от вас"},
	{"107", "Гарваново сърце", "Щетите ще игнорират Духовни сърца/Черни сърца, отнемайки Червени сърца"},
	{"108", "Орехче", "Дава произволен предмет за вдигане при повреда#Изчезва след употреба#Може да се задейства, ако преминете през търговец"},
	{"109", "Скоч", "Всички ваши спътници, вкл. орбиталните, замръзват"},  -- token "familiar" = "спътник"
	{"110", "Сребърен долар", "Магазините ще се появят в утробата"},
	{"111", "Кървава корона", "Златните стаи ще се появят в утробата"},
	{"112", "Платете и спечелете", "Машината за подновяване винаги ще бъде в стаята за артикули"},
	{"113", "Насекомо на Войната", "В началото на всяка стая се хвърля взривна съюзническа муха"}, -- feel free to translate "locust" as "скакалец" (~= "grasshopper", "locust"), if more fitting than current generic "insect".
	{"114", "Насекомо на Заразата", "Отровната съюзническа муха се хвърля в началото на всяка стая"},
	{"115", "Насекомо на Глада", "Бавна съюзническа муха се появява в началото на всяка стая"},
	{"116", "Насекомо на Смъртта", "Съюзническа муха се хвърля в началото на всяка стая, нанасяйки 2x - 4x вашата щета"},
	{"117", "Насекомо на Завоевателя", "2-5 съюзнически мухи се хвърлят в началото на всяка стая, нанасяйки двойни щети"},
	{"118", "Крило от прилеп", "Шанс за получаване на крила при нанасяне на щети#Работи само в стаята"},
	{"119", "Стволова клетка", "В началото на нов етаж, лекува за половин червено сърце"},
	{"120", "Фиба за коса", "Презарежда напълно активния ви артикул, когато влезете в Бос стаята"},
	{"121", "Дървен кръст", "Предоставя еднократен щит в началото на нов етаж"},
	{"122", "Масло!", "Когато използвате активиран елемент, той ще бъде на пода на пиедестал"},
	{"123", "Филигранно перо", "Ангелските босове ще пуснат други артефакти вместо ключови части"},
	{"124", "Стопер за врата", "Вратата, през която сте минали, остава отворена"},
	{"125", "Удължител", "Електрическа верига свързва вашите спътници помежду си"},
	{"126", "Гнило пени", "Когато вземете монета, се появява съюзническа муха"},
	{"127", "Детски огъвател", "Насочване на сълзите от спътниците ви"},   -- freely reinterpreting translation based on Spoon Bender
	{"128", "Кост от пръст", "Шанс да получите Костно сърце при нанасяне на щети"},
}

---------- Cards ----------
EID.descriptions[languageCode].cards={
	-- translations remaining: certain tokens (pickups, stats); on demand rune names and bosses
	{"1", "0 - Глупакът", "Телепортира те обратно до стартовата стая на етажа"},
	{"2", "I - Магьосникът", "Самонасочващи се сълзи за сегашната стая"},
	{"3", "II - Върховната жрица", "Кракът на мама се стоварва върху някой враг!#!!! Ако няма врагове, се стоварва върху теб"},    -- ~~extra vs en_us.lua: "!!!If no enemies, it stomps on you"
	{"4", "III - Императрицата", "За една стая: #↑ {{Damage}} +2.35 Щети#↑ {{Speed}} +0.3 Скорост"},
	{"5", "IV - Императорът", "{{BossRoom}} Телепортира те до стаята на боса"},
	{"6", "V - Йерофантът", "{{SoulHeart}} Пуска 2 духовни сърца"},
	{"7", "VI - Влюбените", "{{Heart}} Пуска 2 червени сърца"},
	{"8", "VII - Колесницата", "Неуязвимост + щета при контакт за 6 секунди"},
	{"9", "VIII - Справедливост", "Създава 1 бомба, 1 ключ, 1 монета, 1 сърце (от случайни видове)"},  -- ~~extra vs en_us.lua: "... (of random types)"
	{"10", "IX - Отшелникът", "{{Shop}} Телепортира те до магазина"},
	{"11", "X - Колелото на съдбата", "Създава {{Slotmachine}} игрална машина или {{FortuneTeller}} гадателска машина"},
	{"12", "XI - Сила", "За една стая: #↑ {{Heart}} +1 Здраве#↑ {{Damage}} +0.3 Щети#↑ {{Damage}} +50% Щети#↑ {{Range}} +5.25 Обхват#↑ +0.5 Височина на сълзите#↑ {{Speed}} +0.3 Скорост"},
	{"13", "XII - Обесеният", "Летене за сегашната стая"},
	{"14", "XIII - Смърт", "Нанася 40 щети на всички врагове в стаята"},
	{"15", "XIV - Умереност", "{{DonationMachine}} Създава кръводарителска машина#{{GreedMode}} В режим \"Алчност\" създава дяволски просяк"},
	{"16", "XV - Дяволът", "↑ {{Damage}} +2 щети за сегашната стая"},
	{"17", "XVI - Кулата", "Създава 6 трол бомби"},
	{"18", "XVII - Звездите", "{{TreasureRoom}} Телепортира те до златната стая"},
	{"19", "XVIII - Луната", "{{SecretRoom}} Телепортира те до тайната стая"},
	{"20", "XIX - Слънцето", "Нанася 100 щети на всички врагове в стаята#Възстановява здравето напълно#Разкрива цялата карта на етажа"},   -- with extra verbosity, TODO check looks ingame
	{"21", "XX - Съд", "Създава просяк или дяволски просяк"},
	{"22", "XXI - Светът", "Разкрива цялата карта на етажа и показва вида на всяка стая"},
	{"23", "Двойка спатии", "{{Bomb}} Удвоява твоите бомби"},
	{"24", "Двойка кари", "{{Coin}} Удвоява твоите пари"},
	{"25", "Двойка пики", "{{Key}} Удвоява твоите ключове"},
	{"26", "Двойка купи", "{{Heart}} Удвоява твоите червени сърца#Само възстановява здраве"},
	{"27", "Асо спатии", "{{Bomb}} Превръща всички пикъпи в стаята в бомби"}, -- pickups??
	{"28", "Асо кари", "{{Coin}} Превръща всички пикъпи в стаята в монети"},
	{"29", "Асо пики", "{{Key}} Превръща всички пикъпи в стаята в ключове"},
	{"30", "Асо купи", "{{Heart}} Превръща всички пикъпи в стаята в сърца"},
	{"31", "Жокер", "{{AngelDevilChance}} Телепортира те в дяволската или ангелската стая"},
    -- BEGIN RUNES SECTION: Purposefully not translating runes to anything. If needed, transcribe.
	{"32", "Hagalaz", "Разрушава всички скали в стаята"},
	{"33", "Jera", "Дублира всички пикъпи в стаята"},  -- ~~en-us.lua inconsistency: "room" instead of "the room"
	{"34", "Ehwaz", "Създава люк към следващия етаж#8% шанс за {{LadderRoom}}люк със стълба"},
	{"35", "Dagaz", "{{SoulHeart}} +1 духовно сърце#{{CurseCursed}} Премахва проклятията за етажа"},
	{"36", "Ansuz", "Пълна карта (с тайни стаи и икони) за етажа"},
	{"37", "Perthro", "Променя всички предмети на пиедестали в стаята"},    -- reroll?
	{"38", "Berkano", "Призовава 3 съюзнически паяка и 3 съюзнически мухи"},
	{"39", "Algiz", "Неуязвимост за 30 секунди#Не се запазва при излизане от стаята"}, -- explicit mention that the shield is removed on room transition
    -- END RUNES SECTION
	{"40", "Празна руна", "Случаен ефект на руна#25% шанс да се създаде нова празна руна"},
	{"41", "Черна руна", "Нанася 40 щета на всички врагове#Превръща всички предмети на пиедестали в стаята в случайни подобрения на *stats#Превръща всички *пикъпи в стаята в съюзнически мухи"}, -- untranslated token: "stats"
	{"42", "Хаос карта", "При използване изстрелва картата в твоята посока на движение#Изстреляната карта напълно убива всеки враг или бос в играта, който бъде докоснат (освен Delirium)"},   -- translate Delirium? all bosses?
	{"43", "Кредитна карта", "Премахва цената от всички предмети в сегашния {{Shop}} магазин (или {{DevilRoom}} дяволска стая), правейки предметите безплатни"},
	{"44", "Карта с правила", "Показва \"полезни\" съвети"},
	{"45", "Карта срещу човечеството", "Изпълва цялата стая с акита"},
	{"46", "Крал-самоубиец", "!!!Убива те на място#Създава 10 пикъпи/предмети на пода"},  -- translation based on the wiki trivia about king of hearts in a standard deck
	{"47", "Карта \"Излез от затвора\"", "Отваря всички врати в стаята#!!!Може да отвори вратата към {{MegaSatan}} Mega Satan"},   -- verified, they really translated it literally so this is the best available
	{"48", "? карта", "Моментално използване на активният предмет"},
	{"49", "Парче от зарче", "Променя предметите (пиедестали и пикъпи) в сегашната стая"},
	{"50", "Спешен контакт", "Две ръце на мама се спускат и сграбчват врагове"},
	{"51", "Свещена карта", "{{Collectible313}} Дава щит като \"Свещена мантия\" за една стая#(Спира щета веднъж)#25% шанс да се създаде нова Свещена карта"},
	{"52", "Огромен растеж", "↑ {{Damage}} +7 Щети#↑ {{Range}} +30 Обхват#Можете да чупите скали, като ги тъпчете#Уголемяване на героя#Ефектите са за сегашната стая"},
	{"53", "Древен спомен", "{{Card}} Създава 3 случайни карти"},  -- translation checked against the "recall" meant in Magic: The Gathering
	{"54", "Вековен поход", "{{Slow}} Забавя всички врагове#↑ {{Speed}} +0.5 Скорост#↓ {{Shotspeed}} -1 скорост на сълзите#Ефектите са за сегашната стая"},
}

---------- Pills ----------
EID.descriptions[languageCode].unidentifiedPill = "Неидентифицирано хапче"

EID.descriptions[languageCode].pills={
	{"0", "Неприятен газ", "Създава отровен облак от газ около теб"},
	{"1", "Лошо преживяване", "Нанася 1 сърце щета#Превръща се в хапче \"Пълно здраве\", ако имаш 1 сърце или по-малко"},
	{"2", "Стоманени топки", "{{SoulHeart}} +2 духовни сърца"},
	{"3", "Бомбите са Ключ", "Разменя бройките на притежаваните бомби и ключове"},
	{"4", "Екплозивна диария", "Създава 5 бомби в период от общо 5 секунди на моментната ти позиция"},
	{"5", "Пълно здраве", "Запълва всички червени сърца"},
	{"6", "По-малко здраве", "↓ {{Heart}} -1 контейнер за червено сърце#Превръща се в хапче \"Повече здраве\", ако имаш 1 контейнер или по-малко"},
	{"7", "Повече здраве", "↑ {{EmptyHeart}} +1 празен контейнер за червено сърце"},   -- ~~en_us.lua is inconsistent here with the health down vs up descriptions
	{"8", "Намерих хапче", "Никакъв ефект"},
	{"9", "Пубертет", "Само визуален ефект на пубертет#!!!3 такива дават трансформацията \"Възрастен\" (+1 червено сърце)"},
	{"10", "Хубава муха", "Добавя 1 орбитална муха"},
	{"11", "По-малко обхват", "↓ {{Range}} -2 обхват"},
	{"12", "Повече обхват", "↑ {{Range}} +2.5 обхват"},
	{"13", "По-малко скорост", "↓ {{Speed}} -0.12 скорост"},
	{"14", "Повече скорост", "↑ {{Speed}} +0.15 скорост"},
	{"15", "По-малко скорост на стреляне", "↓ {{Tears}} -0.28 скорост на стреляне"},
	{"16", "Повече скорост на стреляне", "↑ {{Tears}} +0.35 скорост на стреляне"},
	{"17", "По-малко късмет", "↓ {{Luck}} -1 късмет"},
	{"18", "Повече късмет", "↑ {{Luck}} +1 късмет"},
	{"19", "Телехапче", "Телепортира те в произволна стая#{{ErrorRoom}} Малък шанс за телепорт до стаята I AM ERROR"},
	{"20", "48-часова енергия!", "Напълно презарежда активната вещ#Създава 1-2 батерии"},
	{"21", "Хематемеза", "{{EmptyHeart}} Изпразва всички налични контейнери за червени сърца освен едно#{{Heart}} Създава 1-4 червени сърца"}, -- extra markup icons vs en_us.lua
	{"22", "Парализа", "Не можеш да се движиш за 2 секунди"},
	{"23", "Мога да видя всичко!", "{{SecretRoom}} Отваря входовете към тайните стаи на този етаж"},   -- "forever" -> "everything" (meme can't be preserved anyway)
	{"24", "Феромони", "{{Charm}} Очарова всички врагове в стаята"},
	{"25", "Амнезия", "{{CurseLost}} Скрива цялата карта на етажа"},
	{"26", "Лимоново парти", "Създава голяма локва на пода, която нанася щети на враговете"},
	{"27", "Ти магьосник ли си?", "Сълзите ти се стрелят диагонално за 30 секунди"},
	{"28", "Обезболяващи", "{{Collectible108}} Всички източници на щети причиняват само по половин сърце наведнъж за тази стая"},  -- translation based on ru.lua + reference; extra markup icon of The Wafer
	{"29", "Пристрастен!", "Всички източници на щети причиняват по цяло сърце наведнъж за тази стая"},
	{"30", "Ре-Лакс", "Създава ако при движение за следващите 2 секунди"},
	{"31", "???", "{{CurseMaze}} Проклятието на Лабиринта (с подменяне на стаи) се прилага за сегашният етаж"},    -- extra info in parentheses about the curse type because Maze and Labyrinth translate to the same word; if found too verbose, remove the parentheses part
	{"32", "От едно ставаш по-голям", "Визуално порастваш#Зоната, в която могат да те ударят, не нараства"},
	{"33", "От едно ставаш по-малък", "Визуално се смаляваш#Зоната, в която могат да те ударят, също се смалява"},
	{"34", "Заразен!", "Създава 1 съюзнически паяк от всяко ако в стаята (с минимум от 1)"},    -- pill name courtesy of google translate
	{"35", "Заразен?", "Създава 1 съюзнически паяк за всеки враг в стаята#Създава 1-3 паяци, ако няма врагове"},
	{"36", "Силово хапче!", "{{Collectible93}} Кратък ефект на неуязвимост"}, -- extra markup icon vs en_us.lua
	{"37", "Ретро визия", "Екранът става много по-пикселиран за 30 секунди"},
	{"38", "Приятели до края!", "Създава 3 съюзнически мухи"},
	{"39", "Екс-лакс", "Създава локва от хлъзгава течност"},
	{"40", "Нещо не е наред...", "{{Slow}} Създава локва от забавяща течност"},
	{"41", "Сънлив съм...", "{{Slow}} Забавя всички врагове в стаята"},
	{"42", "Възбуден съм!!!", "Забързва всички врагове в стаята"},
	{"43", "Глът!", "{{Trinket}} Консумира държаната дрънкулка в момента и прибавя нейният ефект перманентно"},    -- note here that "ѝ" quite possibly does not exist in the font
	{"44", "Horf!", "{{Collectible149}} Изстрелва една сълза като \"Буркан с отрова\""},
	{"45", "Сякаш ходя по дъгата!", "{{Collectible298}} Кратък ефект на неуязвимост"}, -- "sunshine" -> "rainbow"
	{"46", "Vurp!", "Създава последното използвано хапче преди това#Ако друго хапче не е било използвано, създава копие на себе си"},
    -- Horf and Vurp not translated because, like, how should they be.
} 

---------- Sacrifice Room ----------
EID.descriptions[languageCode].sacrificeHeader = "[Следваща отплата от жертвена стая]"

EID.descriptions[languageCode].sacrifice={
	{"1", "", "{{Coin}} 50% шанс за 1 монета#{{Bomb}} 100% шанс за 1 бомба, ако си на първият етаж и босът е убит за по-малко от 1 минута"},
	{"2", "", "{{Coin}} 50% шанс за 1 монета#{{Bomb}} 100% шанс за 1 бомба, ако си на първият етаж и босът е убит за по-малко от 1 минута"},
	{"3", "", "{{AngelChance}} 67% шанс за получаване на по-голям шанс да се отвори ангелска стая"},
	{"4", "", "{{Chest}} 50% шанс за произволен сандък"},
	{"5", "", "{{Coin}} 33% шанс за 3 монети#{{AngelChance}} 67% шанс за получаване на по-голям шанс да се отвори ангелска стая"},
	{"6", "", "{{AngelRoom}} 33% шанс за телепорт до ангелската стая#{{DevilRoom}} Телепортът е до дяволската стая, ако такава вече се е появила на етажа#{{Chest}} 67% шанс за произволен сандък"},
	{"7", "", "{{AngelRoom}} 33% шанс за произволен предмет от ангелската стая#{{SoulHeart}} 67% шанс за 1 духовно сърце"},
	{"8", "", "100% шанс за 7 трол бомби"},
	{"9", "", "100% шанс за появяване на ангелът-бос \"Уриил\""},
	{"10", "", "{{SoulHeart}} 50% шанс за 7 духовни сърца#{{Coin}} 50% шанс за 30 монети"},
	{"11", "", "100% шанс за появяване на ангелът-бос \"Гавриил\""},
	{"12", "", "50% шанс за телепорт до \"Тъмна стая\""},
}

---------- Dice Room ----------
EID.descriptions[languageCode].diceHeader = "[Ефекти на стая зар]"

EID.descriptions[languageCode].dice={
	{"1", "", "Превръща всички твои предмети в случайни предмети според стаите, откъдето са взети"},
	{"2", "", "Променя всички предмети по пода на тази стая"}, -- "pickups" desperately needs an unambiguous translation that cannot mean "items" here
	{"3", "", "Променя всички предмети по пода и дрънкулки на целия етаж#Не засяга {{DevilRoom}}дяволската или {{AngelRoom}}ангелската стая"},
	{"4", "", "Променя всички вещи на пиедестали на целия етаж#Не засяга {{DevilRoom}}дяволската или {{AngelRoom}}ангелската стая"},
	{"5", "", "Рестартира и наново генерира сегашния етаж"},
	{"6", "", "Променя всички твои предмети#Променя всички предмети по пода, дрънкулки и вещи на пиедестали на целия етаж"},
}

---------- Transformations ----------
EID.descriptions[languageCode].transformations = {
	"",					-- 0 = none
	"Гъпи",			    -- 1
	"Гъбчо",			-- 2  -- "Забавен човек" as per old Magic Mushroom translation
	"Велзевул",		    -- 3  -- unconfirmed by official (literary) sources. can resort to "Повелител на мухите" -> "Lord of the Flies" if it is a concern.
	"Съединени",		-- 4
	"Дрогиран",			-- 5  -- loose translation based on personal perception that "Spun" tries to represent this via colloquial meaning (could not find sources). a bit of a "bad word" moment.
	"Да, майко?",		-- 6
	"Ох, говно",		-- 7  -- literal translation because of the transformation content
	"Боб",				-- 8
	"Левиатан",    		-- 9
	"Серафим",			-- 10
	"Супер просяк",		-- 11
	"Книжен червей",	-- 12  -- "книжен плъх"? I suppose the usage is similar/interchangeable
	"Бебе паяк",		-- 13
	"Възрастен",		-- 14
	"Мачкащ"			-- 15
}

---------- MISC ----------

EID.descriptions[languageCode].VoidText = "При абсорбиране:"    -- no "получаваш"->"you gain" because it becomes a two-liner
-- {1} will become the number text (like "{1} Tears up" -> "+0.5 Tears up")
EID.descriptions[languageCode].VoidNames = {"{1} скорост", "{1} честота на стреляне", "{1} щета", "{1} обхват", "{1} скорост на изстрелите", "{1} късмет"}

EID.descriptions[languageCode].CollectionPageInfo = "Тази вещ трябва да се вземе за списъка с вещи в менюто!"

EID.descriptions[languageCode].MCM = {
	DemoObjectName = "Примерно име на вещ",
	DemoObjectTransformation = "Примерна трансформация",
	DemoObjectText = "Това е текст на български#Много яко и дълго описание, автоматично се разпределя на няколко реда заради максималната ширина на кутията!#{{Collectible4}} И това е готин ред#{{Heart}} Този ред те обича#{{AngelDevilChance}} Този ред може да ти е ангел или дявол#\1 {{Damage}} +1 промяна на характеристика",
}

EID.descriptions[languageCode].HoldMapTitle = "Напомняне за вещ"
-- the Hold Map description will predict the abilities of items with a header like "Item Name Result"
EID.descriptions[languageCode].HoldMapHeader = " (резултат)"  -- this string applies after the item name for example on Teleport 2.0

-- https://wofsauge.github.io/IsaacDocs/rep/enums/RoomType.html
-- Includes Repentance room types for localization convenience
EID.descriptions[languageCode].RoomTypeNames = { "Обикновена стая", "Магазин", "Стая I AM ERROR", "Златна стая", "Стая на боса", "Стая на минибос", "Тайна стая", "Супер тайна стая", "Аркадна стая", "Прокълната стая", "Стая с предизвикателство", "Библиотека", "Жертвена стая", "Дяволска стая", "Ангелска стая", "Тайник", "Поредица от босове", "Спалнята на Исаак", "Запустяла спалня", "Стая сандък", "Стая зар", "Черен пазар", "{{GreedMode}} Изходна стая", "Планетариум", "Вход на телепорт", "Изход на телепорт", "Люк към страничния път", "{{Trinket150}} Синя стая", "Ултра тайна стая",
-- Not technically room types but still potentially useful to have localized
[666] = "Ангелска/дяволска стая", [1024] = "Червена стая", [1025] = "Специална червена стая" }
-- if an icon gets added for Blue Key Room, remove the {{Trinket150}} markdown and possibly re-translate; respectively for (Greed Mode) Exit Room; good to suggest for en_us.lua?

-- currently used for D1
EID.descriptions[languageCode].PickupNames = {
	["5.0"] = "Никакъв",   -- gender bias, de facto dependent on the translation of "pickup"
	
	["5.10"] = "{{Heart}} Сърце",  -- TODO: check where this displays and whether to translate as "Red Heart" specifically
	["5.10.1"] = "{{Heart}} Червено сърце", ["5.10.2"] = "{{HalfHeart}} Половин червено сърце", ["5.10.3"] = "{{SoulHeart}} Soul Heart", ["5.10.4"] = "{{EternalHeart}} Вечно сърце", ["5.10.5"] = "{{Heart}} Двойно червено сърце", ["5.10.6"] = "{{BlackHeart}} Черно сърце", ["5.10.7"] = "{{GoldHeart}} Златно сърце", ["5.10.8"] = "{{HalfSoulHeart}} Half Soul Heart", ["5.10.9"] = "{{Heart}} Бягащо сърце", ["5.10.10"] = "{{BlendedHeart}} Смесено сърце", ["5.10.11"] = "{{EmptyBoneHeart}} Костно сърце", ["5.10.12"] = "{{RottenHeart}} Гнило сърце",
	
	["5.20"] = "{{Coin}} Монета",  -- "Стотинка"??
    -- "Dime" translation = ?
	["5.20.1"] = "{{Crafting8}} Монета", ["5.20.2"] = "{{Crafting9}} Петак", ["5.20.3"] = "{{Crafting10}} Десетак", ["5.20.4"] = "{{Crafting8}} Двойна монета", ["5.20.5"] = "{{Crafting11}} Късметлийска монета", ["5.20.6"] = "{{Crafting9}} Лепкав петак", ["5.20.7"] = "{{Crafting26}} Златна монета",
	
	["5.30"] = "{{Key}} Ключ",
	["5.30.1"] = "{{Crafting12}} Ключ", ["5.30.2"] = "{{Crafting13}} Златен ключ", ["5.30.3"] = "{{Crafting12}} Двоен ключ", ["5.30.4"] = "{{Crafting14}} Зареден ключ",
	
	["5.40"] = "{{Bomb}} Бомба",
	["5.40.1"] = "{{Crafting15}} Бомба", ["5.40.2"] = "{{Crafting15}} Двойна бомба", ["5.40.3"] = "{{Crafting15}} Трол бомба", ["5.40.4"] = "{{Crafting16}} Златна бомба", ["5.40.5"] = "{{Crafting15}} Мега трол бомба", ["5.40.7"] = "{{Crafting17}} Гигантска бомба",
	
	["5.90"] = "{{Battery}} Батерия",
	["5.90.0"] = "{{Crafting19}} Батерия", --AB+ didn't have subtypes for batteries
    -- also screw the "Lil'" in the default Battery name
	["5.90.1"] = "{{Crafting19}} Батерия", ["5.90.2"] = "{{Crafting18}} Микро батерия", ["5.90.3"] = "{{Crafting20}} Мега батерия", ["5.90.4"] = "{{Crafting28}} Златна батерия",
	
    -- following are multiple examples where a literal translation hurts understandability
	["5.50"] = "{{Chest}} Сандък", ["5.51"] = "{{BombChest}} Каменен сандък", ["5.52"] = "{{SpikedChest}} Сандък с шипове", ["5.53"] = "{{EternalChest}} Ангелски сандък", ["5.54"] = "{{MimicChest}} Измамен сандък", ["5.55"] = "{{OldChest}} Стар сандък", ["5.56"] = "{{WoodenChest}} Дървен сандък", ["5.57"] = "{{MegaChest}} Мега сандък", ["5.58"] = "{{HauntedChest}} Обитаван сандък", ["5.60"] = "{{GoldenChest}} Златен сандък", ["5.360"] = "{{RedChest}} Червен сандък",  
	
	["5.69"] = "{{GrabBag}} Торбичка", ["5.69.1"] = "{{GrabBag}} Торбичка", ["5.69.2"] = "{{BlackSack}} Черна торбичка",
	
	["5.70"] = "{{Pill}} Хапче",
	["5.300"] = "{{Card}} Карта",
	["5.301"] = "{{Rune}} Руна", -- not a real id
	["5.350"] = "{{Trinket}} Дрънкулка",

}
