----------------------------------------------------------------------------
----- Detailed English descriptions based on the Binding of Isaac Wiki -----
----------------------------------------------------------------------------

-- Last Sync with en_us: 03.07.2021

-- Transformations: uses the number next to the transformation entry (can be found at the bottom of this file)

-- Item ID | transformation id| Description text 

-- '#' = starts new line of text

-- Example:  69|1|+1.0 Tears up |Example Item#Example Second Line

-- init en_us_detailed table
local languageCode = "en_us_detailed"

local repCollectibles={
	{"1", "" ,"+0.7 Tears up. #Disappears if the Spindown Dice is used on it."},
	{"2", "" ,"Triple shot. #Tears down: (Delay * 2.1) + 3."},
	{"3", "" ,"Homing tears."},
	{"4", "" ,"+0.5 Damage up.#1.5x Damage multiplier. #Increased knockback and tear size. #Damage multiplier does not stack with: #Magic Mushroom, #Book of Belial plus Blood of the Martyr, #Other Cricket's Heads."},
	{"5", "" ,"Gives tears a boomerang effect, pulling tears toward Isaac as he moves.#+1.5 Range Up.#x1.6 Shot Speed multiplier.#+1 Tear Height."},
	{"6", "" ,"+1.5 Tears up.#-17.62 Range down.#+0.76 Tear height.#Tears fire from Isaac's lower body instead of his head."},
	{"7", "" ,"+1.0 Damage up.#1.5x Damage multiplier when used with Book of Belial. #No damage multiplier if you have: #Magic Mushroom, #Cricket's Head."},
	{"8", "" ,"Familiar that follows Isaac. #Standard tears that deal 3.5 damage."},
	{"9", "" ,"Transforms roughly 1/3rd of flies into Black Flies. #Removes contact damage from roughly 1/3rd of flies. #Roughly 1/3rd of flies retain their form and deal contact damage."},
	{"10", "" ,"Two 'Pretty Fly' orbitals which block shots. #Maximum of 3 'Pretty Fly' orbitals that cannot be exceeded. #Kills some fly enemies on contact."},
	{"11", "" ,"Gain an extra life. #Respawn with full heart containers. #Respawn with 1/2 soul heart if you have 0 containers. #Revival items activate in this order: #Guppy's Collar, Broken Ankh, 1up!, Lazarus' Rags, Dead Cat, Ankh, Judas' Shadow, Missing Poster."},
	{"12", "" ,"+1 Health up.#+0.3 Damage up.#+5.25 Range up.#+0.3 Speed up.#+0.5 Tear height.#Full health.#Size increase.#1.5x Damage multiplier.#Damage multiplier does not stack with: #Cricket's Head, #Book of Belial plus Blood of the Martyr, #Other Magic Mushroom."},
	{"13", "" ,"Poisons enemies on contact.#Deals 12 damage on contact. #Poison lasts for 6-7 ticks, dealing (0.2 * HeartContainers ^ 2) + 2, #HeartContainers is the total number of heart containers and bone hearts Isaac has. #+0.2 Speed Up. #No longer drops black hearts."},
	{"14", "" ,"+0.3 Speed up.#+5.25 Range up.#+0.5 Shot height."},
	{"15", "" ,"+1 Health up.#Full health."},
	{"16", "" ,"+2 Health up.#Full health."},
	{"17", "" ,"+99 Keys."},
	{"18", "" ,"+99 Coins."},
	{"19", "" ,"+10 Bombs."},
	{"20", "" ,"Flight."},
	{"21", "" ,"Reveals all special rooms on the map except secret and super secret rooms. #Does not reveal the map layout."},
	{"22", "" ,"+1 Health up. #Heals one health."},
	{"23", "" ,"+1 Health up. #Heals one health."},
	{"24", "" ,"+1 Health up."},
	{"25", "" ,"+1 Health up."},
	{"26", "" ,"+1 Health up."},
	{"27", "" ,"+0.3 Speed up."},
	{"28", "" ,"+0.3 Speed up."},
	{"29", "" ,"+1.5 Range up.#+0.5 Tear height. #Spawns 3-6 blue flies on pickup."},
	{"30", "" ,"+1.5 Range up.#+0.5 Tear height. #Enemies that touch Isaac take 12 damage."},
	{"31", "" ,"+2.25 Range up.#+0.5 Tear height. #Spawns one random heart."},
	{"32", "" ,"+0.7 Tears up."},
	{"33", "" ,"Grants flight until you leave the current room.#Kills Mom, Mom's Heart and It Lives instantly.#Instantly kills you when used on Satan."},
	{"34", "" ,"+2 Damage up for the rest of the room on use.#+12.5% Devil deal chance if you kill the boss while holding it.#1.5x Damage multiplier if you also have Blood of the Martyr.#No damage multiplier if you have: #Magic Mushroom, #Cricket's Head."},
	{"35", "" ,"Deals 40 damage to every enemy in the room."},
	{"36", "" ,"Creates a poop when used on a tile with no other solid obstacles.#When activated, deflects nearby enemy bullets away from your character.#When placed next to a pit, can be exploded like a rock to make a bridge. #Poop can drop pickups like normal poop."},
	{"37", "" ,"Drops a bomb below your character on use.#This bomb is similar to Mr. Mega bombs, dealing 110 damage and having increased blast radius."},
	{"38", "" ,"Fires 10 tears in a circle around Isaac.#These tears retain the shot speed and all special effects of the player's tears.#Each tear deals regular tear damage plus 25."},
	{"39", "" ,"Freeze all enemies in the current room.#This effect lasts roughly 4 seconds."},
	{"40", "" ,"Causes an explosion on top of the player. #The explosion is identical to Mr. Mega or Mr. Boom, dealing 185 damage in a large radius, and half a heart to the player.#This increases to a full heart on later floors.#This explosion works with some bomb changing items:#Bob's Curse, Hot Bombs, Sad Bombs, Butt Bombs, Bomber Boy, and Glitter Bombs"},
	{"41", "" ,"Fears all enemies on the current room for 5 seconds."},
	{"42", "" ,"Upon use, the character holds a poison bomb which can be thrown in the cardinal directions. #Once thrown, it explodes dealing 185 + Isaac's tear damage, and leaving behind a poison gas cloud. #The cloud deals 5 damage."},
	{"43", "" ,"<If you see this, there's a problem.>"},
	{"44", "" ,"Teleports the player into a random room on the current floor. #It is possible to loosely influence the direction of the teleport by moving in that direction before teleporting. #Cannot teleport to the I AM ERROR room or a Crawl Space/Black Market.#In Greed mode it is possible to teleport to a super secret room with no doors."},
	{"45", "" ,"Heals one health. #Not effected by Maggy's Bow. #In co-op, heals all other players for half a red heart."},
	{"46", "" ,"+1.0 Luck up.#Increases chances of winning at the Shell Game Beggar and the Fortune Teller, independent of luck stat. #Converts some bad pills into good pills, without identifying. #This is the same conversion effect as the PHD."},
	{"47", "" ,"On activation, acts like you have Epic Fetus for one shot. #Spawns a large red marker controlled by the arrow keys. #After two seconds, a large missile lands on the marker. #Deals 20x tear damage and acts like a large bomb."},
	{"48", "" ,"Tears pierce enemies but not obstacles."},
	{"49", "" ,"On use, fires a large laser in place of the next tear.#The laser deals 4x tear damage."},
	{"50", "" ,"+1 Damage up."},
	{"51", "" ,"+1.0 Damage up.#+10% chance for devil deals if obtained before killing the boss. #A second Pentagram only gives +5% increased deal chance."},
	{"52", "" ,"Tears are replaced with bombs that explode roughly one second after being fired. #Each bomb deals 10 times Isaac's normal tear damage. #Tears down: Delay * 2.5. #Range and shot speed affect the bomb's velocity when fired. #Does not affect the explosion delay. #Bombs grow larger and smaller with tear size modifiers. #Bombs do not knock each other back."},
	{"53", "" ,"Pulls pickups towards the player. #This can pull pickups over pits and rocks, but not through key blocks. #Hearts and batteries are only pulled to the player if they can be picked up. #A few enemies (like Horfs) are pulled towards the player as well."},
	{"54", "" ,"Causes all rooms, except the secret rooms, to appear on the minimap. Does not show room icons."},
	{"55", "" ,"Luck dependent chance to shoot a single tear out of the back of the player. #Has a luck cap for a 100% chance to fire a second tear. #Wiki does not list max cap currently."},
	{"56", "" ,"On use, drops a small pool of lemonade under the player. #Enemies on this pool take 22 damage per tick, or 66 damage per second."},
	{"57", "" ,"Spawns a red attack fly that circles the player at a small distance, dealing 5 damage per tick or 75 damage per second. #Circles further than standard orbitals, but closer than a similar item, Forever Alone."},
	{"58", "" ,"Shields the player from all damage for 10 seconds. #Does not prevent loss of Health Down pills or Devil Room deals. #When active, the Sacrifice Room will not pay out."},
	{"59", "" ,"<Judas's Birthright Book of Belial should never be on a pedestal>"},
	{"60", "" ,"Allows the player to walk over one square gaps by creating a platform between them. #Enemies cannot use this platform."},
	{"61", "" ,"<If you see this, there's a problem.>"},
	{"62", "" ,"Heals half a red heart every 13 enemies killed. #+0.3 damage."},
	{"63", "" ,"Active items can store two full charges at once. #Secondary charge appears in yellow over the normal charge meter."},
	{"64", "" ,"-50% cost for all shop items. #Multiple Steam Sales reduce prices further. #Price is lowered to (price / n + 1), where n is the number of Steam Sales. #Prevents shops having natural discounts as well as the Steam Sale. #Causes Devil room deals to not automatically change from red hearts to soul hearts or vice versa if you lose all your red hearts or gain more."},
	{"65", "" ,"Spawn 6 troll bombs around the room, usually near the center. #All passive bomb effect items affect these bombs."},
	{"66", "" ,"Slows down all enemies in the current room for roughly 8 seconds."},
	{"67", "" ,"Familiar that follows Isaac. #Standard tears that deal 5 damage."},
	{"68", "" ,"Replaces tears with a laser that has unlimited range and pierces all enemies. #Does not fire over rocks or other obstacles. #Laser size scales with tear size. #Unlike previous versions, Technology is affected by momentum like normal tears."},
	{"69", "" ,"Causes the player to charge their tears while holding the fire button before firing when releasing the fire button. #Deals roughly 30% tear damage at minimum charge, and roughly 400% damage at full charge."},
	{"70", "" ,"+1.0 Damage up.#+0.2 Speed up."},
	{"71", "" ,"+0.3 Speed up. #Reduces the player's size. #-4.25 Range, +1.5 Shot Height. #Results in a slight increase in range for most characters. #Characters such as Azazel or anyone with Dr. Fetus, whose tears are not affected by shot height, lose range."},
	{"72", "" ,"Grants 3 soul hearts. #+0.5 tears. #The Bible becomes more common, and can appear in any item pool. #This stacks with the Rosary Bead trinket."},
	{"73", "" ,"Level 1: Orbital, deals 7 damage per tick/105 per second. #Level 2: Orbital shoots tears which deal 3.5 damage.#Level 3: Turns into a familiar which hunts nearby enemies, dealing 3.5 damage on contact twice per second.#Level 4: Increases size of the familiar and damage to 5.5. #Further cubes of meat start from level 1 again."},
	{"74", "" ,"Gives the player 25 coins."},
	{"75", "" ,"All pills are identified. #Spawns a pill. #Replenishes 2 red hearts. #Adds 0-2 coins to the payout of the Blood Bank or the IV Bag. #Converts a number of 'bad' pills into their 'good' counterparts. #With False PHD, pills can be good or bad again. #Bad pills apply False PHD's effects."},
	{"76", "" ,"Secret and super secret room doors are automatically opened."},
	{"77", "" ,"Upon use, grants invulnerability and +0.28 Speed up. #Isaac loses the ability to shoot tears during this, but deals 40 contact damage to enemies."},
	{"78", "" ,"Grants a soul heart.#+17.5% devil deal chance if held when the boss dies.#When used on a level, guarantees a Harbinger will replace the normal boss of the level. #This cannot cause a preset boss such as Mom to be replaced. #Will not replace Alt path bosses."},
	{"79", "" ,"+1.0 Damage up.#+0.2 Speed up.#Grants a black heart."},
	{"80", "" ,"+0.5 Damage up.#+0.7 Tears up.#Grants two black hearts."},
	{"81", "" ,"Removes all red hearts before adding one. #??? and The Soul have their soul hearts set to 1. #Jacob and Esau both respawn with one heart container, but only one of them is set to 1 red heart upon taking the item. #Grants 9 lives, which revive the player with 1 heart container. #Revival items activate in this order: #Guppy's Collar, Broken Ankh, 1up!, Lazarus' Rags, Dead Cat, Ankh, Judas' Shadow, Missing Poster."},
	{"82", "" ,"Grants Flight.#+0.3 Speed up."},
	{"83", "" ,"Upon use grants: #1/2 Black heart.#+0.7 Damage up.#-0.18 Speed down.#The ability to crush rocks.#Allows the player to deal contact damage, though it does not stop them taking contact damage."},
	{"84", "" ,"Spawns a trapdoor that leads to the next floor.#10% chance to lead to a Crawl Space or a Black Market instead. #Crawl Spaces and Black Markets are identified by the ladder in the hole, instead of just a black void. #If The Forgotten has been unlocked, can be used on dirt patches in the Dark Room to dig up a random chest."},
	{"85", "" ,"Spawns a random tarot card."},
	{"86", "" ,"Summons Monstro to land on nearby enemies, dealing 120 damage and destroying obstacles like rocks. #Targets the player if there are no enemies in the room. #Will target shopkeepers. #Does nothing if Monstro is in the room. #Like Mom's stomp attack, this is treated as an explosion."},
	{"87", "" ,"Luck dependent chance to shoot a tear in the four cardinal directions instead of just in front of Isaac. #Caps at 100% chance to activate at 7 or higher luck. #Will never activate if obtained on Lilith."},
	{"88", "" ,"Familiar which charges across the room until it hits a wall before returning to the player to recharge. #Deals 3.5 contact damage per tick, 52.5 damage per second total. #Can be shot diagonally, like normal tears."},
	{"89", "" ,"Luck dependent chance to shoot a tear which slows hit enemies and projectiles shot by them for 2.5 seconds. #Caps at 100% chance to activate at 15 or higher luck."},
	{"90", "" ,"+1 Damage up.#+0.2 Tears up.#-0.2 Speed down.#While rare, it is possible to spawn two Small Rocks on the same floor. #In this case, the speed and tear changes stack but the damage does not."},
	{"91", "" ,"Reveals on your map what the rooms adjacent to your current room are. #Reveals secret and super secret rooms. #The player glows more strongly in the dark."},
	{"92", "" ,"Grants 1 red heart container.#Grants 2 soul hearts."},
	{"93", "" ,"Upon use grants invulnerability and fears all enemies in the room. #Removes the ability to shoot tears and causes the player to deal 40 contact damage. #Replenishes half a red heart for every 2 enemies killed with the effect."},
	{"94", "" ,"Drops a random coin every 2 rooms. #BFFS! adds a 33% chance to drop a coin on completing a room where a coin would not normally spawn."},
	{"95", "" ,"Familiar that shoots spectral Technology tears that deal 3.5 damage. #Shoots at half the speed of Isaac's base tear rate."},
	{"96", "" ,"Drops a half red heart every 3 rooms."},
	{"97", "" ,"Spawn a random heart, coin, bomb, key, battery, pill, or card/rune. #Can drop soul or black hearts as well as red hearts. #Coins can be pennies, nickels or dimes. #Bombs and keys are always single drops, never 1+1 drops."},
	{"98", "" ,"Spawns a soul heart roughly every 4 rooms. #Specifically, it spawns a soul heart every X rooms where X is a sequence 3, 4, 5, 4, 4, 1, 4, 4, 5, 4, 5 before going back to position 2 and restarting."},
	{"99", "" ,"Familiar that fires slowing tears that deal 3.5 damage."},
	{"100", "" ,"Familiar that fires homing tears."},
	{"101", "" ,"Grants 1 full red heart container.#+0.3 Damage up.#+0.2 Tears up.#+0.25 Range up.#+0.3 Speed up.#+0.5 Tear height"},
	{"102", "" ,"Gives the player a pill. #If the player also has Starter Deck, this will spawn a tarot card instead."},
	{"103", "" ,"Luck dependent chance to fire a poison tear which inflicts a target hit by it with poison. #Poison deals 1x the player's tear damage 2 times. #Caps at 100% chance to activate at 12 or higher luck."},
	{"104", "" ,"Tears split in two upon hitting an obstacle or enemy. #These tears are fired perpendicular to the direction the original tear is moving. #The split tears can impact another object and split a third time. #Each split reduces the damage dealt by the tear by 50%."},
	{"105", "" ,"Upon use, every item in the current room is rerolled into an item from the current room's item pool. #When an item pool is exhausted, every item will be rerolled into Breakfast."},
	{"106", "" ,"Grants 5 bombs. #Increases bomb damage from 60 to 185. #Causes the screen to shake when bombs explode. #The bomb damage increase does not stack if multiple copies of this item are obtained."},
	{"107", "" ,"Grants flight and detaches the player's body from their head. #The body turns into a familiar which seeks out nearby enemies to deal contact damage. #The body's speed is dependent on the player's speed, but deals a static 82.5 damage per second. #This damage is doubled by BFFS! #Can be used multiple times to spawn multiple bodies on one room. #Picking up another item immediately despawns the body for the current room. #The familiar will avoid standing on creep, making it hard for it to damage enemies which leave creep as they walk."},
	{"108", "" ,"Reduces damage taken from all sources to half a heart. #This includes self inflicted damage such as Sharp Plug or Razor Blade. #Does not prevent death from things such as the Suicide King card, or HP loss from things like Devil deals. #Does nothing for the Keeper."},
	{"109", "" ,"+0.04 Damage up for every coin you have. #Caps at 3.96 Damage up at 99 coins. #Collecting more coins after hitting the cap does not increase damage. #With Deep Pockets, damage stacks up to +39.96 at 999 coins."},
	{"110", "" ,"+0.25 Range up. #+0.5 Tear height. #Adds a chance to shoot tears which freeze enemies in place, stopping them from moving or attacking. #Petrifying an enemy with a weak spot causes them to take damage everywhere, making fights such as Scolex or Carrion Queen much easier. #Wiki claims this is not affected by luck, but also is affected by luck with a 50% chance at 10 or higher luck."},
	{"111", "" ,"Damages and poisons enemies in a one tile area around the player on use. #Deals 5 damage on use and poisons enemies for 1x player damage, hitting 6 times. #Damage AOE is slightly larger than poison AOE."},
	{"112", "" ,"Orbital which deals 7 damage per tick, 105 damage per second, on contact. #Speeds up the rotation of all orbitals."},
	{"113", "" ,"Familiar that follows the player, shooting tears that deal 3 damage twice as quickly as a normal familiar at nearby enemies. #These tears activate the fly spawning portion of the Guppy transformation."},
	{"114", "" ,"Replaces the player's tears with a knife that pierces enemies and travels through obstacles. #Can be held as a stationary orbital to deal 2x tear damage. #Can be charged up, increasing damage and range when fired. #Damage caps at 6x tear damage. #Does nothing on challenges with the Blindfolded effect. #Cannot be used to unlock the door to the Corpse."},
	{"115", "" ,"Allows the player's tears to pass through obstacles, but not enemies, without breaking."},
	{"116", "" ,"Upon pickup, fully charges the currently held active item. #Items whose recharge time is longer than 1 room will immediately gain 1 charge upon use. #Items which recharge once per room will instead recharge every 15 seconds as long as there are enemies in the room. #Effect varies for items with real-world timed recharges."},
	{"117", "" ,"Spawns a bird which cases enemies, dealing 4 contact damage per second, for the rest of the room."},
	{"118", "" ,"Replaces the player's tears with a charged laser beam that goes through all enemies and obstacles in it's path. #Deals 1x tear damage 9 times each time it's fired. #Tears down: Delay * 3. #The second received Brimstone gives a powered-up version with a much larger beam. #Further Brimstones only increase damage. #Overrides and synergizes with many tear effects. #Too many to list here, a full list is available on the wiki page."},
	{"119", "" ,"Grants red heart container. #+0.3 Speed up. #Heals 5 red hearts. #Can be found multiple times in a run."},
	{"120", "" ,"+1.7 Tears up.#+0.3 Speed up.#Reduces damage by this formula: #(Damage ups from other items * 0.9) - 0.4."},
	{"121", "" ,"+1 Empty red heart container.#+1.0 Damage up.#+0.25 Range up.#-0.2 Speed down.#+0.5 Tear height."},
	{"122", "" ,"When on half a red heart or less:#+1.5 Damage up.#+0.3 Speed up.#Activates and deactivates upon entering a new room. #Always active if you have 0 red heart containers. #Does nothing for The Keeper. #On Eve, this item will be active at one red heart instead of one half, and increases her damage multiplier from 0.75x to 1.0x."},
	{"123", "" ,"Spawns a random familiar for the current floor. #Can spawn familiars the player has not unlocked yet. #If a cube of meat or ball of bandages spawns and the player already has one, instead increases the current level of their cube of meat by one."},
	{"124", "" ,"When used, a random activate item effect will be used. #The possible effects do not include more recently added items. #A full list of possible effects can be found on the wiki."},
	{"125", "" ,"Grants 5 bombs. #Causes placed bombs to home towards enemies."},
	{"126", "" ,"On use this deals one heart of damage to the player and increases your damage by 1.2 for the current room. #Like Blood Banks and similar items, this deals damage to red and eternal hearts before damaging soul hearts. #Does not affect Devil or Angel room chances."},
	{"127", "" ,"Re-rolls the entire floor and causes the player to spawn as if they had just started a new floor. #Does not remove anything gained on the floor before use. #If used on the Chest or the Dark Room after opening the door to Mega Satan, the Golden Key will not re-open the door. #If used on an XL floor, this item can separate them into two floors."},
	{"128", "" ,"Fly orbital that deals 2 damage per tick, 30 damage per second, on contact.#This orbital rotates far away from the player, instead of right around them like normal orbitals."},
	{"129", "" ,"Grants 2 full red heart containers.#-0.2 Speed down."},
	{"130", "" ,"Grants flight while held. #If the player's speed is below 1.5, increases the player's speed to 1.5 while held.#On use, the player charges in the direction the pony is facing. #Grants invulnerability and deals 4 times Isaac's damage plus a flat 28 contact damage to enemies while charging."},
	{"131", "" ,"Drops 1 bomb every 3 rooms. #This bomb can be a normal bomb, a 1+1 bomb, a Troll bomb or a Golden bomb."},
	{"132", "" ,"Tears gain a flat damage bonus based on travel distance, which starts at 0 and increases to roughly +6 at a standard room's width. #This is not the cap, and can increase further in larger rooms."},
	{"133", "" ,"Converts one red heart container into three soul hearts."},
	{"134", "" ,"Grants a 1/3rd chance to replace a pickup with a normal or gold chest, but also a 1/3rd chance to replace it with nothing at all."},
	{"135", "" ,"When used deals one half heart (increases to a full heart on The Womb and beyond) and spawns 1-3 coins. #Damages red and eternal hearts before soul hearts.#Activates items such as Gimpy or Fanny Pack, but does not affect Devil Room chances. #Damage goes through invulnerability. #Only spawns 0-1 coins on The Keeper."},
	{"136", "" ,"Spawns a decoy which distracts enemies and explodes after a few seconds, dealing 110 damage."},
	{"137", "" ,"On pickup for the first time in a run, grants 5 bombs. #Regular bombs will no longer explode automatically. #On use, all bombs on the room explode immediately. #Does not control Troll bombs or Mega Troll bombs."},
	{"138", "" ,"Grants one red heart container.#+0.3 Damage up."},
	{"139", "" ,"You can now hold 2 trinkets at once. #Can hold two identical trinkets. #Spawns a random trinket on pick up."},
	{"140", "" ,"Grants 5 bombs. #Causes the player's bombs to leave a green poison cloud after exploding.#Makes the player immune to poison damage, e.g. the poison clouds spawned when destroying Mushrooms."},
	{"141", "" ,"Spawns 7 random coins. #These can be pennies, nickels, or dimes."},
	{"142", "" ,"Once per room, when the player is reduced to their last half heart they are granted one soul heart. #Leaving and re-entering a room will allow this effect to trigger again. #Will not protect you from lethal damage if you take damage at one half heart while Scapular is active. #Does not recharge between waves in Greed Mode. #Does nothing for The Lost or The Keeper."},
	{"143", "" ,"+0.3 Speed up.#+0.2 Shot speed up."},
	{"144", "" ,"Spawns a beggar which follows the player around, picking up coins from the ground. #After picking up 6 coins, he drops a pickup. #After that, he has a 67% chance to drop a pickup after 3 coins and 33% after 4. #He can drop: #Hearts, Bombs, Keys, Card/Runes, Pills, and Trinkets. #He cannot drop batteries or pedestal items. #He cannot pick up sticky nickels, but can pick up lucky pennies."},
	{"145", "" ,"Spawns 2-4 blue flies. #Blue flies deal 2x tear damage."},
	{"146", "" ,"Grants one eternal heart on use. #Does nothing for The Keeper."},
	{"147", "" ,"Allows the player to break any rock he touches by hitting it, similar to The Forgotten's club. #Hitting rocks or enemies with the Axe decreases it's charge. #Isaac can toggle back and forth between tears and the Axe with the Active Item button. #Upon running out of charge, it will recharge on the next floor."},
	{"148", "" ,"Spawns 2-6 flies when the player takes damage."},
	{"149", "" ,"Replaces tears with projectiles that fly in an arc, exploding and poisoning the area hit. #Tears down - (Tear Delay * 2) + 10. #+13 Shot height. #+40 flat damage. #Explosion range increases with tear size."},
	{"150", "" ,"Luck dependent chance to fire teeth which deal 3.2x damage. #Caps at 100% chance to activate at 9 or higher luck."},
	{"151", "" ,"1 in 6 chance to spawn a fly when tears hit an enemy. #Blue flies deal 2x tear damage. #Does nothing for Lilith. #Does nothing after obtaining the Guppy transformation."},
	{"152", "" ,"Replaces tears fired from the character's right eye with an unlimited range piercing laser that fires continuously. #0.65x Damage multiplier. #The laser deals 20% of the player's damage per tick, compounding with the damage down. #Effectively doubles tear delay. #Replaces Cain's tears completely, unless he has Technology or a charged attack. #Does nothing except decrease Lilith's damage."},
	{"153", "" ,"Causes the player to fire four tears in a spread at once. #Tears down - (Tear Delay * 2.1) + 3."},
	{"154", "" ,"Grants +2 flat damage to tears fired from the player's left eye. #This is unaffected by damage multipliers. #Cain has a 50% chance to fire a shot with the effects of Chemical Peel."},
	{"155", "" ,"Spawns a familiar which floats around the room, blocking shots and dealing 8 damage per tick, 17 damage per second, on contact. #The pupil on the friendly Peeper is larger than the pupils on the ones spawned by Peep."},
	{"156", "" ,"On taking damage, the player's active item gains 1 room's worth of charge."},
	{"157", "" ,"Increases the player's damage upon taking damage. #Increases by +0.5 for the first hit, #+0.2 for each additional hit, #until +1.5 on the sixth hit, #maximum of +6.0 damage. #Resets each time the player enters a new floor."},
	{"158", "" ,"Reveals the map layout and all special rooms except the Super Secret Room.#Spawns either a soul heart or a random tarot card/rune. #50% chance of either spawning.#↑ +15% Planetatium chance#100% if a treasure room was skipped"},
	{"159", "" ,"Grants flight. #Grants spectral tears."},
	{"160", "" ,"When used, spawns 5 beams of light in random locations, with a high chance to directly target enemies. #Beams last 0.8 seconds and deal (tear damage + 20) damage on contact."},
	{"161", "" ,"Grants an extra life. #On death, the player respawns as ??? in the previous room. #Revival items activate in this order: #Guppy's Collar, Broken Ankh, 1up!, Lazarus' Rags, Dead Cat, Ankh, Judas' Shadow, Missing Poster."},
	{"162", "" ,"Luck dependent chance to grant the Book of Shadows effect for 7 seconds on taking damage. #Base chance of activate is 20%, capping at 100% at 27 or higher luck."},
	{"163", "" ,"Familiar that fires spectral tears that deal 3.5 damage. #Fires at half the speed of Isaac's base tears."},
	{"164", "" ,"After use, reduces the player's movement speed until they a fire button, which will shoot a blue flame projectile in that direction. #Deals 23 damage per tick, for a maximum of 184 damage per second. #Averages 115 damage per second. #Destroys enemy shots that come into contact with it."},
	{"165", "" ,"+1 Damage up.#+0.23 Shot speed up."},
	{"166", "" ,"Rerolls all pickups and chests on the current room. #Will not reroll empty chests. #Can reroll pickups into batteries and other battery items."},
	{"167", "" ,"Familiar which shoots two tears in a V shape which deal 4 damage each."},
	{"168", "" ,"Replaces the player's tears with guided missiles, like the Doctor's Remote. #Missiles deal 20x tear damage, and benefit from most bomb enhancing effects. #Overrides most items in the game; a full list can be found on the wiki page."},
	{"169", "" ,"Greatly increases damage: (Damage + 4) * 2. #Tears Down: (Tear Delay * 2.1) + 3. #If a tear kills an enemy, the tear continues traveling with the leftover damage."},
	{"170", "" ,"Familiar which follows the player around as a shadow, traveling to stomp on enemies roughly every 4 seconds. #The stomp deals 20 damage on contact, and can hit each enemy twice."},
	{"171", "" ,"On use, deals 10 damage and slows all enemies for 4 seconds. #Enemies killed by Spider Butt spawn blue spiders."},
	{"172", "" ,"Orbital dagger which deals 15 damage per tick, 225 damage per second, on contact. #Blocks enemy shots."},
	{"173", "" ,"Roughly 33% chance of converting any red heart pickup into a soul heart instead."},
	{"174", "" ,"Familiar which shoots a random tear with effects similar to other familiars. #Full list of possible tears can be found on the wiki."},
	{"175", "" ,"Opens all closed doors in the current room. #Opens the door to the Mega Satan fight. #Can be used to escape boss rush, but not enter it. #Will not open the Blue Womb or Boss Rush doors. #Will not open Challenge or Boss Challenge rooms from the inside, but will open them from the outside. #Will not open the exit room door in Greed Mode. #Unlocks the alt path doors for free. #Cannot open the Depths II door, nor Ultra Secret Rooms."},
	{"176", "" ,"Grants one full red heart container.#+0.16 Shot speed up."},
	{"177", "" ,"On use, consumes one coin and gives a random reward. #Can give almost any reward a slot machine can. #Cannot drop the 'A Dollar' item. #Cannot explode."},
	{"178", "" ,"Familiar which follows the player that launches forward when the player shoots. #Upon hitting an enemy, shatters and creates damaging blue creep. #Petrifies enemies on the pool. #After breaking, Holy Water respawns and can be fired again shortly."},
	{"179", "" ,"Grants flight. #Grants one eternal heart."},
	{"180", "" ,"On taking damage, the player farts, dealing 5 damage and then 21 damage per tick for 6 ticks."},
	{"181", "" ,"Passively grants flight while held. #If the player's speed is below 1.5, passively increases speed to 1.5 while held. #Upon use, the player charges in the direction the pony is facing, becoming invulnerable and damaging enemies while also casting an effect similar to Crack the Sky. #The charge deals 4 times Isaac's damage plus a flat 28. #The beams of light deal 4 times Isaac's damage plus a flat 10."},
	{"182", "" ,"Grants one heart container and replenishes all red hearts. #Grants homing tears and homing bombs. #+4.125 Range up. #-0.4 Tears down. #-0.25 Shot speed. #+1 Damage up. #2.3x Damage multiplier. #No longer results in a range decrease, as shot speed no longer effects range."},
	{"183", "" ,"+0.7 Tears up.#+0.16 Shot speed up. #Turns into Sacred Heart when rerolled by Spindown Dice."},
	{"184", "" ,"Grants Flight and one full red heart container."},
	{"185", "" ,"Grants flight and spectral tears."},
	{"186", "" ,"Upon use, deals one full heart of damage to the player and deals 40 damage to all enemies. #Invulnerability does not protect against this damage."},
	{"187", "" ,"Spawns a hair ball that loosely follows around the player. #Can be swung around by moving in circles. #Gains one level per enemy killed, to a max of 5. #Deals (level * 2) + 3 contact damage twice per second. #If the player is Guppy, a blue fly spawns each time the hairball deals contact damage. #On entering a new floor, the level decreases by: #2 > 1, #3 or 4 > 2, #and 5 > 3."},
	{"188", "" ,"Familiar that mirrors the player's movements and shoots towards the player. #Deals 3.5 damage per shot. #When used by Cain, Abel's tears do 5 damage."},
	{"189", "" ,"Grants one red heart container and refills all empty red heart containers. #+0.3 Damage up. #+0.2 Tears up. #+0.2 Speed up. #+0.5 Range up. #+1 Shot height."},
	{"190", "" ,"Grants 99 bombs."},
	{"191", "" ,"Grants a tear effect which changes every 2-3 seconds. #A full list of possible tear effects can be found on the wiki."},
	{"192", "" ,"On use, grants homing tears and +3.0 range for the current room."},
	{"193", "" ,"Grants one red heart container.#+0.3 Damage up."},
	{"194", "" ,"+0.16 Shot speed up. #Drops a random tarot card on the ground.#+15% Planetarium chance"},
	{"195", "" ,"Drops 4 pills on the ground. #If the player has Starter Deck, it drops 4 cards instead."},
	{"196", "" ,"Drops 2 soul hearts on the ground.#+0.4 Tears up."},
	{"197", "" ,"+0.5 Damage up.#+0.25 Range up.#+0.5 Tear height."},
	{"198", "" ,"Spawns: #1 Coin. #1 Key. #1 Bomb. #1 Heart. #1 Card/rune. #1 Pill. #1 Trinket. #Can drop different types of bombs, hearts, coins and keys."},
	{"199", "" ,"Grants 2 keys. #Chests drop additional pickups."},
	{"200", "" ,"Luck dependent chance to shoot charming tears, causing enemies to temporarily fight on the player's side. #Caps at 100% chance at 27 or higher luck."},
	{"201", "" ,"+0.3 Damage up.#Luck dependent chance to shoot concussive tears, causing enemies to walk around randomly. #Caps at 100% chance at 27 or higher luck."},
	{"202", "" ,"On contact with enemies: #Deals damage equal to the number of coins the player has. #Freezes and turns enemies into gold. #Enemies killed in this state drop 1-4 pennies. #Causes many poop-generating items, such as The Poop, to have a high chance to create a Golden poop instead. #Impairs Ultra Greed's armor by 75%."},
	{"203", "" ,"Hearts, Bombs, Pennies and Keys have a chance to drop 1+1 versions.. #Does nothing with: #Soul or black hearts, half red hearts, nickels, dimes, gold hearts, lucky pennies, sticky nickels, or the drops from Book of Sin."},
	{"204", "" ,"Upon taking damage, the player has a chance to drop a random coin, bomb, key or heart."},
	{"205", "" ,"If the player's current active item has no charges, attempting to use it will immediately charge it at the cost of one half heart per charge slot filled. #Attempts to draw from red hearts first. #Cannot deal fatal damage. #As the Keeper, trades 2 charges per coin heart; 1 charge uses 1 coin heart."},
	{"206", "" ,"Removes the player's head from their body, causing it to act like an orbital. #Deals 7 damage per tick, 105 damage per second, on contact. #Shots still originate from the head. #+1 Damage up. #Tear delay directly reduced by 1. #This can reduce the tear delay past the normal cap."},
	{"207", "" ,"Level 1: Orbital, deals 7 damage per tick/105 per second. #Level 2: Orbital shoots charm tears which deal 3.5 damage.#Level 3: Turns into a familiar which hunts nearby enemies, dealing 3.5 contact damage twice per second. #Level 4: Increases size of the familiar and damage to 5.5. Also grants a chance for enemies killed by the bandage girl to drop full red hearts. #Further balls of bandages start from level 1 again."},
	{"208", "" ,"+1 Damage up.#Increases the chance for champion enemies to appear."},
	{"209", "" ,"Grants 5 bombs.#Bombs briefly confuse and deal 10 damage to all enemies on the room when they explode."},
	{"210", "" ,"The player becomes invincible after standing still and not attacking for one second. #Using bombs and active items stops this effect."},
	{"211", "" ,"On taking damage, spawns 3-5 friendly blue spiders."},
	{"212", "" ,"Grants a permanent 50% chance to respawn with a half red heart on death. #Can activate multiple times in each run. #Revival items activate in this order: #Guppy's Collar, Broken Ankh, 1up!, Lazarus' Rags, Dead Cat, Ankh, Judas' Shadow, Missing Poster."},
	{"213", "" ,"Causes all of the player's tears to have a shield around them, which destroys both an enemy's shot and the player's shot when they collide. #Affects Fate's Reward and Incubus' tears. #-0.16 Shot Speed Down."},
	{"214", "" ,"+5 Range up. #Range up does not stack if the player gets this item twice.#After taking damage, the player leaves a trail of red creep which damages enemies until the next room."},
	{"215", "" ,"Forces a Devil or Angel room door to spawn after every boss fight. #These doors will not disappear after leaving the boss room. #Taking this item after not getting a Devil deal on a floor will force one to spawn on that floor. #Will not force a door to spawn in a narrow room. #Doors do not spawn on the first floor or any floor after the Womb II. #Overridden by Eucharist. #If obtained before/on floor 2 and the Devil Room is ignored, guarantees floor 3 to be an Angel Room."},
	{"216", "" ,"+1 Damage up.#Grants 3 black hearts"},
	{"217", "" ,"Heals 1 red heart on pickup. #Luck dependent chance to spawn a spider on firing a tear, up to a max of 5 spiders. #Caps at 100% chance at 10 or higher luck."},
	{"218", "" ,"Grants one full red heart container on pickup. #The player has a chance to regenerate a half red heart every one minute of gameplay. #Does not require you to be actually playing the game; if need be, the player can go AFK until they reach full health again. #The Keeper will regain a full coin heart, and The Forgotten will restore a third of a bone heart. #Does nothing for ???."},
	{"219", "" ,"Grants an empty red heart container.#Luck dependent chance to drop a red heart on taking damage. #Capping at 50% at 29 or higher luck."},
	{"220", "" ,"Grants 5 bombs. #Causes bombs to shoot 10 tears in a circle, similar to Tammy's Head, on explosion. #Tears are affected by the player's tear effects."},
	{"221", "" ,"Tears bounce off walls, enemies, bombs and environmental objects. #Tears that bounce off enemies bounce randomly, while every other object causes them to bounce directly back."},
	{"222", "" ,"Causes tears to hover in mid air while a fire button is held. Releasing the button causes the tears to shoot in the direction they were originally shot. #Tears will automatically release after a while. #-2 tear delay. #This can reduce the tear delay past the normal cap."},
	{"223", "" ,"Grants 5 bombs. #All explosions heal the player for one half red heart instead of hurting him. #This makes the player immune to the stomp attacks from Mom, Satan and other enemies. #This makes the player immune to the rock wave attack from The Cage, The Adversary, and Mega Satan. #Grants immunity to damage from Fire Places or enemy fires, but does not heal Isaac. #Makes it impossible to get Knife Piece 1."},
	{"224", "" ,"-1 Tear delay.#This can reduce the tear delay past the normal cap. #-10.0 Range down.#When the player's normal tears disappear, they split into 4 smaller tears which deal 50% of the player's damage."},
	{"225", "" ,"Enemies have a chance to drop half a red heart on death. #Luck dependent chance to drop a soul or black heart on taking damage. #Caps at 50% chance to happen at 22 luck."},
	{"226", "" ,"Grants one red heart container, one soul heart and one black heart."},
	{"227", "" ,"On pickup, gain 3 coins. #When the player takes damage, 1-2 coins drop on the ground. #When playing as The Keeper, drops 0-1 coins instead. #Heals 1 HP and gives 2 coins if taken by The Keeper when you have one empty coin heart. #Unlike attacks from a Keeper, Greed, or Super Greed, coins dropped by this item are not subtracted from the player's coin total. #Does not activate multiple times if multiple copies are obtained."},
	{"228", "" ,"Tear delay directly reduced by 1. #This can reduce the tear delay past the normal cap. #Luck dependent chance to shoot a tear which fears any hit enemy. #Caps at 100% at 85 or higher luck. #Multiple copies of the item do not stack the tear delay reduction."},
	{"229", "" ,"Replaces tears with a charged attack. #At full charge, shoots a burst of tears similar to Monstro's attack."},
	{"230", "" ,"+1.5 Damage up.#+0.2 Speed up.#Converts all Red Hearts into Black Hearts. #Adds 2 additional Black hearts.#Luck dependent chance to shoot a tear which fears any hit enemy. #Caps at 100% at 85 or higher luck. #Sets Keeper's coin hearts to 1. #If taken by Bethany, sets her to one half red heart and removes all other containers."},
	{"231", "" ,"The player leaves a trail of black creep which slows enemies.#Luck dependent chance to shoot a tear which slows any hit enemy. #Caps at 100% at 18 or higher luck."},
	{"232", "" ,"+0.3 Speed up. #Slows all enemies in every room, though not as drastically as the slow effect. #Slows enemies and shots that are spawned after the effect activates. #Can make it difficult to tell different champion types apart when active."},
	{"233", "" ,"Tears revolve around the player at a fixed distance until they hit the ground.#+7.0 Tear height. #Tears fly over all obstacles due to the tear height increase. #Tears orbit close to Isaac, offset in the direction fired slightly. #Changing firing direction redirects all previously fired tears."},
	{"234", "" ,"Spawns a blue spider when you kill an enemy."},
	{"235", "" ,"<If you see this, there's a problem.>"},
	{"236", "" ,"On touch, turns the enemy into poop."},
	{"237", "" ,"Grants piercing tears.#+1.5 Damage up.#-0.3 Tears down.#Further increases tear size.#Tears are replaced by Death's scythes. #This is cosmetic only."},
	{"238", "" ,"Combined with Key Piece 2, this opens the golden door at the start of The Chest and the Dark Room to fight Mega Satan.#Adds a second 25% chance (independent of the first 50% chance) to spawn an Angel room instead of a Devil room. #Cannot be rerolled by the D4, D100 or Dice Rooms."},
	{"239", "" ,"Combined with Key Piece 1, this opens the golden door at the start of The Chest and the Dark Room to fight Mega Satan.#Adds a second 25% chance (independent of the first 50% chance) to spawn an Angel room instead of a Devil room. #Cannot be rerolled by the D4, D100 or Dice Rooms."},
	{"240", "" ,"Randomly increases 4 and decreases 2 of the player's stats. #Each increase or decrease will be a fixed value: #1 Health, #1 Damage, #0.2 Speed, #0.5 Range, #0.5 Tears, #0.2 Shot speed, #1 Luck #Cannot modify speed above 2, can break the tear cap of 5.0."},
	{"241", "" ,"Doubles all pickup drops earned for clearing a room, but reduces the chance for drops after a room ends. #Neither effect applies to coins dropped in Greed/Greedier mode. #Having two of this item from something such as Diploplia triples item drops."},
	{"242", "" ,"The player gains a 'high chance' to block projectiles which hit the player directly, causing him to flash blue instead of taking damage."},
	{"243", "" ,"Spawns a shield which faces in the same direction the player is firing, blocking all shots that hit it. #Cannot block beams or explosions. #Can be held in any direction with a joystick, despite tears only firing on the cardinal directions."},
	{"244", "" ,"Grants an unlimited range piercing laser with a random rate of fire. #Does *not* replace tears. #Damage dealt scales directly with the player's damage. #The laser occasionally fires with the effect of a random item or trinket. #A full list of possible effects can be found on the wiki."},
	{"245", "" ,"The player shoots two tears at once, one from each eye. #-25% damage multiplier."},
	{"246", "" ,"Reveals the secret and super secret rooms on the map. #Does not display ultra secret rooms."},
	{"247", "" ,"Increases the size and doubles the damage of familiars and orbitals that deal damage via tears or contact damage. #Affects other familiars in ways that are not necessarily obvious. #For example, many pickup generating familiars drop pickups more often."},
	{"248", "" ,"Blue spiders and flies deal 2x damage and are larger. #Also effects locusts. #Doubles the spider limit of Mom's Wig to 10. #Fly and Spider familiars become stronger, just like BFFS! #Does not stack with BFFS! "},
	{"249", "" ,"Spawns an extra item after boss fights. #After choosing one, the other disappears. #The second item is always picked from the Boss Item Pool instead of whichever item pool normally used. #Does not effect the Krampus fight."},
	{"250", "" ,"All bombs become 1+1 bomb pickups."},
	{"251", "" ,"Spawns a random card. #Allows the player to hold two cards. #Replaces all pills with cards. #The only exception is the single pill dropped by the item Caffeine Pill. #By default, the key to cycle between cards is Control (PC), R2 (PlayStation) or RT (XBox). #Having Little Baggy will allow both cards and pills to appear again."},
	{"252", "" ,"Spawns a random pill. #Allows the player to hold two pills. #Replaces all cards and runes with pills. #By default, the key to cycle between pills is Control (PC), R2 (PlayStation) or RT (XBox). #Cracked Key counts as a card and will be converted. #Blowing up the skull marked with an X guarantees a telepills drop."},
	{"253", "" ,"Grants one red heart container. #+1 Luck up."},
	{"254", "" ,"+1 Flat damage up.#+5 Range up.#Only applies to tears fired from the player's left eye. #Damage bonus is unaffected by any damage multipliers. #Azazel has a chance to fire a beam with the damage bonus and gains no range. #Cain has a 50% chance to fire a shot with the bonus. #Every other set of tears The Keeper fires is effected. #Stacks with Chemical Peel."},
	{"255", "" ,"+0.5 Tears up.#+0.2 Shot speed up."},
	{"256", "" ,"Grants 5 bombs. #Bombs deal 16 contact damage and leave behind a fire that deals contact damage upon exploding. #Isaac can no longer take damage from fire. #Isaac produces a large circle of lights. #This fire does not hurt the player. #Hoppers who touch the fire turn into Flaming Hoppers. #The contact damage dealt by the bomb does not scale, and disappears entirely if the player acquires another item which changes the bomb graphic such as Mr. Mega or Glitter Bombs."},
	{"257", "" ,"Tears Burn enemies.#Luck dependent chance to fire an exploding tear, which deals 1x tear damage on top of the tear's damage and leaves behind a fire which deals 22 damage per tick. #This fire does not hurt the player, but the explosion can. #In dark areas, such as a Curse of Darkness floor, the player glows."},
	{"258", "" ,"Rerolls all your passive items and stats on pickup and at the start of every floor. Does not affect trinkets, cards, pill, pretty flies, The Polaroid/Negative, or active items. #Causes but does not remove transformations. #Not rerolled by the D4 or D100 after being picked up. #Stats gain a random flat modifier; these modifiers do not stack between levels, and are instead rerolled each time. #Possible stats are: #Speed, -0.2, 0 or +0.2. #Range, -0.5, 0 or +0.5. #Tears, -0.5, 0, or +0.5. #Shot speed, -0.2, 0, or +0.2. #Damage, -1, 0 or +1. #Luck, -1, 0 or +1. "},
	{"259", "" ,"+1 Damage up. #Luck dependent chance to shoot a tear which fears any hit enemy. #Caps at 100% at 20 or higher luck."},
	{"260", "" ,"Grants immunity to floor curses and immediately removes any curse on the current floor. #Grants 1 black heart. #+15% chance to spawn a Devil door to spawn after killing at boss. #Removes the teleportation effect on Cursed Eye. #Does nothing on the Cursed! or Pitch Black challenges. #Will remove the effects of the Amnesia pill, but does not prevent another from being used."},
	{"261", "" ,"Flat damage increase based on distance traveled. #At point blank range, tears deal 3x damage. At max range, they deal no damage. #At base damage, the damage decrease over distance is roughly equal to the damage increase from Lump of Coal, but this is not true at higher damage points."},
	{"262", "" ,"Grants 1 black heart.#If the player's health total (counting all heart types) is 1 or 1/2 hearts after taking damage, deals 80 damage to all enemies in the room. #Doubles Black heart damage to 80."},
	{"263","Clear Rune","Copies the effects of Isaac's held rune or soul stone. #Drops one random rune the first time it's picked up. #Variable recharge time based on which rune or soul stone is used. #Full list of charge times can be found on the wiki."},
	{"264", "" ,"Spawns a familiar that deals 1.5 damage per tick, 22.5 damage per second, on contact with enemies. #By default, the fly orbits the player and blocks enemy shots. #After taking damage, the fly instead seeks out nearby enemies to attack them."},
	{"265", "" ,"Familiar which follows the player, blocking enemy projectiles. #Upon blocking a shot, it has a 10% chance to deal 40 damage to all enemies in the room. #This can happen multiple times per room."},
	{"266", "" ,"Familiar which follows the player, leaving a trail of white creep that slows enemies. #Spawns 1-2 blue spiders after every room."},
	{"267", "" ,"Familiar that automatically shoots Technology lasers which deal 3.5 damage towards enemies when aligned with them. #The familiar movies in the direction the player is shooting. #Cannot be controlled by the mouse if mouse control is enabled."},
	{"268", "" ,"Familiar which spawns friendly blue flies which deal 2x tear damage instead of shooting tears."},
	{"269", "" ,"Familiar which leaves a trail of red creep that deals 2 damage per tick to non flying enemies. #Wiki claims 'The creep deals damage much more rapidly' in Repentance."},
	{"270", "" ,"Familiar which hunts nearby enemies, dealing 1.5 damage per tick or 3.2 damage per second. #If the Leech kills an enemy, the player is healed by half a red heart. #The Keeper can benefit from this healing."},
	{"271", "" ,"Familiar which has a chance to drop a heart, coin, bomb or key after clearing a room."},
	{"272", "" ,"Familiar which flies around the room, similar to a Boom Fly, exploding on contact. #Deals 10 damage on contact and 60 damage from the explosion. #Respawns after 10 seconds or upon entering a new room. #This can damage the player. #Most bomb modifiers apply to BBF as well."},
	{"273", "" ,"Familiar which can be fired towards enemies as a projectile. #If it hits an enemy, it deals 3.5 damage and explodes. #The explosion deals 100 damage and the poison deals a total of 2x tear damage. #The explosion can hurt the player. #After exploding, it takes a few seconds to reappear. #Bob's Brain is affected by most bomb modifiers. "},
	{"274", "" ,"Upon taking damage, a white attack fly appears for the rest of the room. #Orbits at a medium range, similar to Forever Alone, but much faster. #The fly deals 10 damage per tick, 150 damage per second, on contact."},
	{"275", "" ,"Spawns a familiar which fires a thin Brimstone beam. #The beam deals 2.5 damage per tick, and hits up to 8 times for a total of 20 damage. #This charges and fire independently of the player's tears, so to fire it you must release the fire key when charged. #Lil Brimstone takes priority over all following familiars but Incubus. #Always appears first in line, or second behind Incubus."},
	{"276", "" ,"Spawns a heart familiar which attempts to position itself opposite where Isaac is shooting. #The player's body becomes invulnerable, and instead the player takes damage if the familiar is hit. #As Isaac fires, the heart charges up to knock back nearby enemies and tears. #Also creates a puddle of red creep on the ground and shoots blood shots in 8 directions.#Enemies that contact Isaac take 7 damage over 2-3 ticks per second. #Enemies still target Isaac. #Items that activate on contact, such as Turdy Touch, still activate on contact without hurting the player. #Blood donation machines and devil beggars still damage Isaac. #Self harm damage from items is not prevented."},
	{"277", "" ,"Familiar which chases down enemies, dealing 4.4 damage per second and inflicting fear."},
	{"278", "" ,"Familiar which follows the player and collects red hearts. Every 1.5 red hearts collected, he generates one of the following: #A hostile Spider. #A friendly Blue Spider. #A random pill. #A random card or rune. #A single black heart. This is the most likely drop."},
	{"279", "" ,"Large orbital which blocks shots and deals 2 damage per tick, 30 damage per second, on contact. #Rotates more slowly than other familiars. #Does not occupy one of the three defense orbital slots; instead it rotates independently. #If it's the first orbital obtained, other orbitals will match it's speed. #Guardian Angel only speeds it up if obtained after obtaining Big Fan."},
	{"280", "" ,"Spawns blue spiders while in a room with enemies, up to a max of 5. #An enemy that touches Sissy Longlegs will be charmed briefly."},
	{"281", "" ,"Spawns a familiar that walks around the room. #Enemies that are closer to the decoy than the player will target it instead. #Will block enemy shots. #Can die after taking too much damage and will respawn after a long period of time, or upon entering and exiting a room."},
	{"282", "" ,"Upon use, the player jumps in the direction they're currently moving. #The distance jumped depends on how fast the player was moving when the item was used. #Jumping allows the player to travel over obstacles such as rocks, pits and spikes. #While jumping, the player is not effected by enemies, bombs, shots, and so on - however, the player also cannot pick things up or open chests either."},
	{"283", "" ,"Activates the effect of the D1, D4, D6, D7, D8, D10, D12 and the D20 at once. #Further information on each effect can be found on the wiki, as a full explanation would be far too long."},
	{"284", "" ,"Rerolls each of the player's passive items into a random item from the item pool it was acquired from. #Does not reroll Key Piece 1/2, Knife Piece 1/2, Dad's Note, Dogma, Missing No., The Polaroid/Negative, or Tonsil. #Does not remove Lilith's first Incubus or Azazel's Brimstone laser. #Items that grant pickups or health do not remove those bonuses when rerolled. #The player does not lose transformations upon rerolling. #Can grant items that are not yet unlocked. #Items gained count towards the Collection Page. #Does not reroll Holy Mantle on The Lost anymore."},
	{"285", "" ,"Rerolls all enemies in the room into different enemies from anywhere in the game. #Red and yellow flies, as well as Camillo Jr, cannot be rerolled. #Fly enemies will become other fly enemies. #Attempts to reroll monsters into those with similar max HP."},
	{"286", "" ,"Mimics the effect of your currently held card without consuming it. #If you are holding two cards, the card in the active slot will be used. #Does not mimic pills or Souls. #Recharge time is based on the card Isaac was holding when he used it. #Further information on recharge times can be found on the wiki."},
	{"287", "" ,"Grants the effects of either the Treasure Map, the Compass or the Blue Map for the rest of the current floor on use. #Does nothing if the player is effected by the Curse of the Lost or an Amnesia pill. #Cannot give mapping effects Isaac already has; if Isaac has all the mapping effects, gives X-Ray Vision for that floor."},
	{"288", "" ,"Spawn 4-8 blue spiders which deal 2x the player's damage."},
	{"289", "" ,"Upon activation, the player holds the candle above their head. Upon pressing a fire button, they throw a fire in the direction which deals up to 115 damage and blocks enemies shots. #Disappears after 10 seconds."},
	{"290", "" ,"When at full health, the player stores up to 4 extra hearts in the jar. #On use, the hearts stored in the Jar drop on the ground."},
	{"291", "" ,"Turns all non-boss enemies into poop. #Immediately kills all poop-related enemies, including Dingle, Dangle and Brownie. #Extinguishes all fireplaces in the room. #Turns lava-filled pits into rock, allowing them to be walked over."},
	{"292", "" ,"Grants a black heart on use. #When used before a boss fight, the boss room pedestal for that floor will instead contain an item from the Devil Room pool, which must be paid for as normal. #These do not affect Devil/Angel room chances. #Does not affect The Polaroid or The Negative. #Bosses with set drops will still drop their normal item, but at the cost of one red heart container.."},
	{"293", "" ,"Shoot a brimstone laser in the cardinal directions. #Deals 10 damage over 19 ticks. #50% chance to rotate around the player, similar to Krampus' second Brimstone attack."},
	{"294", "" ,"Knocks back nearby enemies and enemy shots. #Enemies pushed into walls or obstacles take 10 damage."},
	{"295", "" ,"Damages the whole room for the cost of 1 coin. #Deals 2x Isaac's damage plus 10."},
	{"296", "" ,"Converts soul or black hearts into one red heart container."},
	{"297", "" ,"Based on current floor, drops:#B1: 2 Soul Hearts#B2:2 keys and bombs#C1: 1 Boss item#C2: B1+C1 rewards #D1:4 Soul hearts#D2: 30 Coins#W1:2 Boss items#W2: Bible#Sheol: 1 Devil item+Black heart#Cathedral: 1 Angel item+Soul heart#Chest: 1 Coin#Home: Red Key."},
	{"298", "" ,"Temporary invincibility and speed up, but removes the ability to shoot tears. #The player does not deal contact damage while active."},
	{"299", "" ,"-0.3 Speed down. #While in hostile rooms, the player gains 0.065 speed per tick. #When the player reaches 2.0 speed they gain the My Little Unicorn effect for 5 seconds, becoming invulnerable and dealing contact damage."},
	{"300", "" ,"+0.25 Speed up.#Causes enemies to take 18 points of damage on contact. #Does not prevent the player from taking contact damage."},
	{"301", "" ,"Grants 3 soul hearts. #Upon taking damage, grants The Wafer effect (reducing all damage to one half heart) for the rest of the room."},
	{"302", "" ,"The player breaks obstacles by walking into them. #Increases the player's size. #The player can walk over red poops without taking damage, though they will hurt the player if it respawns while they're on it."},
	{"303", "" ,"Luck dependent chance to gain the Book of Shadows effect, becoming invulnerable for 7 seconds. #Caps at 100% chance to activate at ten or higher luck. #All stats down pills become stat up pills, Bad Trip becomes Balls of Steel, and Amnesia becomes I Can See Forever. #Does not identify pills."},
	{"304", "" ,"Grants 6 coins, bombs and keys. #Causes your primary attributes (damage, range, tears and speed) to balance, but does not effect luck, tear height or shot speed. #The balancing is based on Isaac's stats. #The balancing happens each time you pick up a stat increase/decrease for the rest of the game."},
	{"305", "" ,"The player's tears inflict poison which deals 2x the player's tear damage."},
	{"306", "" ,"+0.2 Speed up.#Grants piercing tears."},
	{"307", "" ,"Grants 1 heart container, 1 coin, 1 bomb, and 1 key.#+0.97 Damage up.#+0.1 Speed up.#+0.75 Range up.#Tear delay directly reduced by 1. #This can increase Isaac's rate of fire past the normal cap."},
	{"308", "" ,"Leave a trail of creep where you move, dealing 2 damage per tick, 6 damage per second, to enemies who walk on it. #Synergizes with tear effects."},
	{"309", "" ,"Increases tear knockback. #Slightly increases tear size. #Tear delay directly reduced by 1. #This can increase Isaac's rate of fire past the normal cap."},
	{"310", "" ,"-0.5 Shot speed down. #2x Damage multiplier. #2x Tear delay multiplier."},
	{"311", "" ,"Upon death, the player respawns in the previous room as Black Judas. #Black Judas has a base speed of 1.1 and a damage multiplier of 2.0. #Beating bosses will grant Completion Marks for Judas.#Revival items activate in this order: #Guppy's Collar, Broken Ankh, 1up!, Lazarus' Rags, Dead Cat, Ankh, Judas' Shadow, Missing Poster."},
	{"312", "" ,"+1 Health up.#Doubles the health replenished by all red hearts."},
	{"313", "" ,"Ignore the first damage taken in every room. #Grants 0.5 seconds of invulnerability frames. #Does not stack with The Lost's passive Holy Mantle effects. #Does not protect you from damage dealt by Blood Banks, Devil Beggars, or Blood Rights. #Holy Mantle will block damage from Sacrifice Room spikes, but will not spawn anything. #Holy Mantle will not be active for the first room of a floor, you must leave and re-enter the first room to get the effect."},
	{"314", "" ,"+1 Health up.#-0.4 Speed down.#Grants you Leo's effect, allowing you to break obstacles by walking into them."},
	{"315", "" ,"Monsters, pickups, trinkets and the player's bombs are pulled towards where the player's tear lands."},
	{"316", "" ,"Causes your tears to charge instead of firing normally. #When fully charged, the player shoots a short burst of 5 tears very quickly. #Shooting before you've fully charged shoots 0-3 tears based on how long you've charged. #Taking damage while charging will teleport the  to a random room. #Does not teleport when fully charged. #Lilith will not teleport if hit while charging."},
	{"317", "" ,"Tears leave creep upon hitting an enemy or when reaching maximum range. #Creep deals 1 damage per tick, 30 damage per second, to any non-flying enemy standing on it."},
	{"318", "" ,"Familiar which is leashed to the player. #Hunts enemies close to the player, dealing 6 contact damage per second."},
	{"319", "" ,"Familiar which floats slowly around the room in a zig-zag pattern, shooting normal tears in the direction the player is shooting. #Tear damage is equal to the player's damage."},
	{"320", "" ,"Familiar which deals 2.5 damage per tick on contact. #Controlled by the player, similar to Ludovico Technique, with the arrow keys. #Holding two opposing fire keys (such as both left and right) will keep it in place, while the player fires in the direction of whichever fire key was pressed second."},
	{"321", "" ,"Attaches a ball and chain to the player's ankle that crushes rocks, blocks projectiles and deals 5 damage per tick, 10.7 damage per second, on contact. #When the chain is fully extended, the ball must be dragged, slowing the player down slightly."},
	{"322", "" ,"Familiar which cycles through shooting the tears of the player's other familiars. #If the player has no familiar, he will fire normal tears. #Fires twice as far as normal familiars, shooting at the same speed as Isaac's base tears. #A full list of interactions with other familiars can be found on the wiki."},
	{"323", "" ,"Fires 8 tears in a circle around the player, similar to Tammy's Head, without the benefit of tear replacing items such as Brimstone. #Each tear fired by the player gives one charge to the item."},
	{"324", "" ,"On use, teleports the player to one of: #The Item Room, #The Secret Room, #The Super Secret Room, #The I AM ERROR Room, #Or a Black Market. #Black markets are very rare. #Does nothing in Home."},
	{"325", "" ,"On use, the player's head is detached from his body for the rest of the room. #The head turns into a stationary familiar that fires Isaac's tears. #The player controls the body, which constantly spews a controllable fountain of blood shots and can also fire tears. #If the player is blindfolded, the head will still fire tears."},
	{"326", "" ,"Holding spacebar will gradually deplete the charge bar. #At zero charge, the player gains invincibility. #This invincibility disappears shortly after releasing the space bar. #Holding the space bar for more than a second causes the player to take damage."},
	{"327", "" ,"If the player has a half red heart or no red hearts, when taking damage they becomes invincible for 5 seconds. #Allows entrance to The Chest after beating Isaac in the Cathedral by touching the chest. #Having two Polaroids does not cause the effect to last longer. #Opens the special door in The Depths."},
	{"328", "" ,"+1.0 damage. #If the player has half a red heart or no red hearts, when taking damage the Necronomicon effect damages all enemies in the room. #Allows entrance to the Dark room after beating Satan in Sheol by touching the chest. #Having two Negatives does not cause the effect to stack. #Opens the special door in The Depths."},
	{"329", "" ,"Upon pickup, replaces the player's ability to fire tears with a controllable tear that moves around the room and deals contact damage. #This tear is controlled by the firing keys. #The tear's movement speed is determined by the Shot Speed stat. #The number of hits per second the tear deals is determined by the Tears stat."},
	{"330", "" ,"Reduces tear delay by the formula: (delay / 4) - 2#0.2x damage multiplier. #At base damage, Soy Milk is a very small DPS increase if the player hits every single shot. #Any tears increases cause Soy Milk to reduce your overall DPS, not taking into account tear effects. #Drastically reduces knockback from Isaac's tears."},
	{"331", "" ,"Grants homing tears.#Causes your tears to deal damage in an area around them as well.#+0.93 Damage up.#+0.5 Range up.#-0.6 Tears down.#-0.3 Shot speed down.#+0.8 Tear height."},
	{"332", "" ,"Grants an extra life, causing the player to revive as Lazarus Risen. #Lazarus Risen is similar to Lazarus, and completion marks gained as Lazarus Risen count for Lazarus.#Revival items activate in this order: #Guppy's Collar, Broken Ankh, 1up!, Lazarus' Rags, Dead Cat, Ankh, Judas' Shadow, Missing Poster.#Turns into Godhead when rerolled by Spindown Dice."},
	{"333", "" ,"Grants the combined effects of the Blue Map, the Treasure Map, and The Compass. #Reveals the floor layout and all special rooms, including both secret rooms."},
	{"334", "" ,"Grants 3 heart containers."},
	{"335", "" ,"Grants 2 soul hearts.#Grants the player a pulsing blue aura that repels enemies and projectiles. #The strength of the repellent force pulses with the aura. "},
	{"336", "" ,"Grants piercing and spectral tears.#Increases tear size without increasing damage.#-1.5 Range down.#-0.4 Shot speed down.#-0.5 Shot height."},
	{"337", "" ,"Every 4th newly discovered room, the Broken Watch slows all enemies and shots on the room down. #Has a small chance to speed the room up, instead. #The effect is lost if you leave and re-enter the room."},
	{"338", "" ,"If thrown into an enemy, deals 2x tear damage and stuns them for about 2 seconds. #Pierces enemies it hits. #Will grab pickups from afar, with the exception of sacks and chests. #Will destroy dead shopkeepers in shops and secret rooms, though if the player has low damage it may take multiple uses."},
	{"339", "" ,"Grants 1 black heart. #+5.25 Range up.#+0.16 Shot speed up.#+0.5 Tear height."},
	{"340", "" ,"Decreases the player's size.#+0.3 Speed up.#Gives you a random pill when picked up."},
	{"341", "" ,"+0.7 Tears up.#+0.16 Shot speed up."},
	{"342", "" ,"Grants a full red heart container.#+0.7 Tears up.#-0.16 Shot speed down."},
	{"343", "" ,"Grants 1 soul heart.#+1 Luck up.#Spawns 2 keys.#Rare chance to spawn a golden key instead of a regular key."},
	{"344", "" ,"Grants 1 black heart. #Spawns 2-3 bomb pickups near the player. #Can spawn troll bombs or 1+1 bombs instead of regular bombs. #Also drops the Match Stick trinket."},
	{"345", "" ,"+1.0 Damage up.#+5.25 Range up.#+0.5 Tear height."},
	{"346", "" ,"Grants one red heart container, heals two hearts of health."},
	{"347", "" ,"Duplicates all pickups and pedestal items in the current room. #Duplicating a trinket will instead spawn a random trinket. #If used in a shop or Devil Deal/Black Market, the duplicated items can be taken for free. #Does not grant Devil deal precedent. #If used in the Boss Rush room, will copy all 4 items. #Only one duplicate may be taken, along with one of the originals, but taking one will start the Rush. #Duplicate items do not count twice towards transformations. #Cannot duplicate Diplopia. #A full list of duplicated item synergies can be found on the wiki page."},
	{"348", "" ,"Activates the effect of the pill you are currently holding without using the pill. #Recharge time changes based on the pill held. #A full list of recharge times can be found on the wiki."},
	{"349", "" ,"50% chance to drop a coin. #This coin may be a penny, nickel, dime, lucky penny or a sticky nickel."},
	{"350", "" ,"Upon entering a room, all enemies are poisoned. #The poison deals 2x the player's tear damage. #Killing enemies leaves a small pool of green creep on the ground which deals 1 damage per tick, 30 damage per second, to enemies standing on it."},
	{"351", "" ,"Freeze all enemies in the current room.#Deals 5 damage and poisons enemies near the player.#Sends out a wave of spikes in the direction the player is facing, dealing 10 damage to enemies it comes in contact with.#The wave will open secret rooms and break rocks to fill gaps."},
	{"352", "" ,"Upon taking damage, turns into the Broken Glass Cannon. #For the rest of the room, all damage to Isaac is increased by 2 hearts unless this would be fatal. #Fires one large piercing spectral tear which deals ((player damage + 1) * 10) damage. #Slight knockback effect on use. #Can be used to steal Devil deal items. #Recharge rate is not affected by the 9 Volt."},
	{"353", "" ,"Grants 5 bombs. #Bombs will now explode in a cross-shaped pattern. #Enemies hit by more than one explosion take 50% reduced damage from each extra explosion past the first. #The second explosion deals 30 damage instead of the base 60, the third 15 and so on."},
	{"354", "" ,"Grants one red heart container.#Spawns a random trinket on the floor.#If Almond Milk or Soy Milk is possessed, it is consumed."},
	{"355", "" ,"+1.25 Range up.#+0.5 Tear Height#+1 Luck up.#Grants one soul heart."},
	{"356", "" ,"Causes your spacebar item to activate twice when used. #A full list of effects can be found on the wiki page."},
	{"357", "" ,"If used with no familiars, grants a Demon Baby familiar for the duration of the current room. #Otherwise, creates an extra copy of each familiar the player currently has. #If the player has multiple copies of a familiar, either through multiple uses of this item or other means, it will only create one copy of it."},
	{"358", "" ,"The player fires from both eyes at once. #Grants the effect of the 'R U A Wizard?' pill, causing the player to fire diagonally at a 45 degree angle instead of straight forward. #The player's tears travel above all obstacles."},
	{"359", "" ,"+1.5 Damage up.#Turns the player's tears into nails, which increases knockback."},
	{"360", "" ,"Spawns a familiar that fires tears which are effected by the player's stats (such as damage and tear rate) and tear modifiers. #The Incubus ignores the shot speed stat completely, and range increase/decrease items have little to no effect. #Always appears first in line behind Isaac."},
	{"361", "" ,"Familiar which fires tears that deal the same damage and have the same effects as the player's tears. #Fires at half the speed of a normal familiar."},
	{"362", "" ,"Familiar which drops things found in brown chests or a battery. #Upon clearing a room, Lil Chest has a 25% chance to spawn a pickup and a 10% chance to spawn a trinket."},
	{"363", "" ,"Orbital which blocks enemy shots and deals 7 damage per tick, 105 damage per second, on contact. #Also attracts enemy shots towards itself, making them more likely to be blocked. #Once per room, upon blocking 10 shots in one room, it will drop an eternal heart."},
	{"364", "" ,"Orbital which deals 3 damage per tick, 45 damage per second, on contact. #Orbits at a medium distance from the player, between Distant Admiration and Forever Alone."},
	{"365", "" ,"Familiar which flies in a straight line upon entering a room, attaching itself to the first obstacle or wall it comes into contact with before moving around that obstacle or wall similar to a Guts enemy from the Womb floors. #Deals 7 damage per tick, 105 damage per second, on contact."},
	{"366", "" ,"Grants 5 bombs.#Causes your bombs to explode into 2-4 smaller bombs, which deal 50% damage. #The smaller bombs receive the full effect of Sad Bombs despite this. #The tiny bombs explode immediately upon landing. #They also retain all bomb synergies, with the exception of Mr. Mega and Bomber Boy's increased blast radius."},
	{"367", "" ,"Grants 5 bombs. #When a bomb kills an enemy, it spawns blue spiders.#Causes your bombs to stick to enemies."},
	{"368", "" ,"Shooting in one direction increases your fire rate while decreasing accuracy. #When fully activated, Epiphora reduces tear delay by 50%, rounded down."},
	{"369", "" ,"+3.0 Range up.#+1.5 Tear height.#Causes tears to be able to travel through all obstacles, including walls. #If tears leave the screen, they loop back through the opposite wall."},
	{"370", "" ,"+0.7 Tears up.#+5.25 Range up.#+0.5 Tear height.#Spawns 3 random hearts when picked up."},
	{"371", "" ,"Upon taking damage, spawns six troll bombs similar to the Tower tarot card. #These bombs hurt the player as well as enemies, but do not activate Curse of the Tower. #Most, if not all, bomb effects effect these bombs. #If there are enemies present, the bombs will spawn near them."},
	{"372", "" ,"Occasionally spawns a micro battery, freezes all enemies, or adds a charge to the player's active item. #Can only add a charge to the player's item twice per room."},
	{"373", "" ,"Adds a damage multiplier which starts at 1 and increases each time they hit an enemy with a tear. #Each hit adds 0.125 to the damage multiplier, up to a maximum of 2x damage after 8 hits. #If the player misses a shot, there is a chance for the multiplier to reset to 1. #This chance is 20% for the first miss, 33% for the second, and 50% for the third and beyond. #The player can also shoot flames, moving spikes and Stone Grimaces to stack the multiplier, though shooting poop counts as a miss."},
	{"374", "" ,"Luck dependent chance to fire a Holy tear, which will spawn a light beam similar to Crack the Sky which deals 4x the player's tear damage. #Chance maxes out at 50% at 9 luck and above."},
	{"375", "" ,"Grants a chance to block projectiles before retaliating with a triple shot. #Grants immunity to explosions like Pyromaniac, not including the stomp attack of Stan and Mom. #Does not protect against exploding mushrooms or shock waves."},
	{"376", "" ,"Upon purchasing an item from the shop, a new purchasable item is added in place of the purchased item. #For pickups such as spirit hearts and keys, the new item is the same as the purchased item, allowing the player to purchase infinite spirit or red hearts, among other things. #Items that are on sale when purchased will spawn a new item that is on sale. #Using Credit Card or other similar items on the shop will cause it not to restock. #Does nothing on Black Markets. #Outside Greed Mode the restocked item's cost is increased after purchase. #For items, this is 2 cents per purchase. #Everything else increases by 1 cent. #Not affected by discounts; maximum 99 cent price."},
	{"377", "" ,"Most spider enemies no longer target or deal contact damage to the player. #Affects both Jacob and Esau if either one has it."},
	{"378", "" ,"Continuously firing or charging tears for 3 seconds causes the player to drop a Butt Bomb. #Some bomb effect items effect this bomb."},
	{"379", "" ,"Tears have a much larger hitbox.#Grants spectral tears."},
	{"380", "" ,"+Grants 5 coins.#Replaces key doors with coin doors. #Does not effect the entrance to the Downpour/Dross."},
	{"381", "" ,"+0.7 Tears up.#Gives you a random item at the start of your next run. #Cannot grant Key Piece 1 or 2."},
	{"382", "" ,"When empty, the Friendly Ball will instantly capture any non-boss enemy it hits, removing them from the room. #The next time the Friendly Ball is thrown, it releases the capture enemy as a permanently charmed friendly unit which persists between rooms and cannot harm the player. #Walking over a Friendly Ball after it captures an enemy will instantly recharge the item."},
	{"383", "" ,"Detonate any of the player's tears currently on the screen and cause each one to fire 6 tears in a circle, similar to Tammy's Head."},
	{"384", "" ,"Familiar which charges up before launching in the direction the player is firing, dealing 6 damage per tick, 90 damage per second, on contact. #Damage drops off the slower the familiar is moving. #Bounces off walls multiple times."},
	{"385", "" ,"Familiar which floats around the room picking up coins. Every 6 coins it levels up, except for level 4 which takes 12 coins#At level 1, it only collects coins.#At level 2, it can drop random pickups.#At level 3, it fires tears which deal 3.5 damage in the same direction as the player. Enemies hit by these tears have a chance to drop a coin.#At level 4 it no longer fires tears but will chase enemies, dealing 37.5 contact damage per second and randomly drop bombs.#After hitting level 4, it will continue collecting coins and dropping pickups. #Can rarely drop a pedestal item. #Will not level up from coins from the donation machine."},
	{"386", "" ,"Re-rolls obstacles in the current room into other obstacles. #Will not re-roll key blocks, fireplaces, stone grimaces or any other obstacle classified as an enemy."},
	{"387", "" ,"Familiar which projects a circular aura that slows down enemies and shots within it's radius. #Does not slow bosses, but will slow their shots."},
	{"388", "" ,"Familiar which collects keys, giving random chests in return. #Leaves a Little Battery upon picking up a charged key."},
	{"389", "" ,"Drops a random rune every few rooms. #If no runes are unlocked, will instead drop cards."},
	{"390", "" ,"Familiar which fires homing tears which deal 10 damage, have -0.25 shot speed and a reduced fire rate."},
	{"391", "" ,"If there is more than one enemy in the current room, taking damage causes all enemies in the room to be charmed."},
	{"392", "" ,"Gives the player a random Zodiac item effect each floor. #Gaining Capricorn will not give the player a heart container, nor will Libra give consumables or Cancer give soul hearts."},
	{"393", "" ,"Grants a chance to fire poison tears which deal damage over time when they hit an enemy. #Also causes enemies who come into contact with the player to become poisoned. #Enemies killed after being poisoned by contact with Isaac have a 20% chance to drop a Black Heart."},
	{"394", "" ,"+0.7 Tears up.#+0.3 Tear height.#+3.15 Range up.#Creates a crosshair which is controllable with the arrow keys. #The player automatically fires at this crosshair instead of the direction held, and cannot stop firing. #Can be controlled by the mouse on PC; further instructions found on the wiki. #Pressing the drop key will make the crosshair disappear and stop firing until a firing key is pressed. #By default this is left control on keyboard, right trigger on controller. #On Lilith, as well as with many items that cause the player to charge instead of shoot constantly, Marked only grants the stats up. #A full list of interactions can be found on the wiki."},
	{"395", "" ,"Replaces the player's tears with laser rings. #Shots can be charged to increase the size of the rings. #Rings pass through obstacles and enemies, and have infinite range, moving until they hit a wall. #Only the outer edge of the ring will deal damage. #Damage is dealt based on amount charged, from 25-100% of Isaac's damage."},
	{"396", "" ,"Upon first activation, places a blue portal under the player's feet. #The second activation places an orange portal. #Once two portals are placed, the player can walk into one to immediately be teleported out the other, gaining a small invulnerability period. #Activations past the first two replace the oldest portal. #Portals placed in rooms that don't appear on the map, such as Devil or Angel rooms, Crawl Spaces, Boss Rush and so on can be used to leave the room, but not re-entered."},
	{"397", "" ,"+0.5 Tears up.#+5.25 Range up.#+0.16 Shot speed up.#+0.5 Tear height.#Creates a beam of light that faces the direction the player is facing. #Tears fired move in the path of the beam; the player moving sideways or turning to fire a different direction cause the tears to snap back into the beam instead of traveling normally."},
	{"398", "" ,"Grants tears a chance to shrink enemies when struck.#The chance to shrink enemies is not increased by having higher luck. #Shrunken enemies can be crushed and killed by walking over them."},
	{"399", "" ,"#After firing tears for 2.5 seconds, releasing the fire button creates a black Brimstone ring which deals damage to enemies touching it.#The player gains a red upside-down cross on their forehead when fully charged. #Having charge bars enabled also displays a Maw charge bar."},
	{"400", "" ,"Causes the player to hold a spear in front of him that deal 2x tear damage to enemies, and rarely inflicts fear. #Does not replace tears. #If the player loses their body via an item, Spear of Destiny becomes useless. #Despite the size of the spear, the hitbox is only the silver part and the handle. #Does not work while blindfolded."},
	{"401", "" ,"Tears gain a chance to stick to enemies and explode a few seconds afterwards, dealing 60 plus tear damage. #Tears deal normal tear damage upon sticking to an enemy. #Chance to stick to enemies is not affected on luck. #The explosions can hurt the player. #If an enemy dies or teleports (except Loki or Lokii), the Explosivo tears stuck to them drop off and fall to the ground. #These falling tears can drop on another enemy and re-attach."},
	{"402", "" ,"On pickup, drops 1-6 random pickups around the player. #Causes items to be chosen from a random item pool instead of the pool the room normally chooses from."},
	{"403", "" ,"Spawns a grey spider familiar that wanders around. #Adds a health bar and damage numbers to all enemies. #Upon contact with enemies, the spider will inflict a random status effect. #The spider will also occasionally drop a battery or spawn a blue spider on completing a room. #Damage numbers are multiplied by 10 and rounded to the nearest number. #Health bars don't differentiate between enemies with armor - such as mushrooms - or are invulnerable."},
	{"404", "" ,"Familiar which follows the player around and blocks enemy projectiles. #Upon blocking a shot, it has a 10% chance of farting. #This fart can poison, knock back or charm all nearby enemies. #The charm fart deals 5 damage, and the poison fart deals 5 damage initially and then 3.5 poison damage."},
	{"405", "" ,"Familiar which follows Isaac. #Double tapping fire launches it forward, rerolling the first monster of pickup it hits. #Respawns on clearing a room. #If it cannot reroll an enemy - such as a boss - it deals damage instead."},
	{"406", "" ,"Rerolls the player's speed, range, tears and damage stats. #Each stat is given a multiplier that applies after all other adjustments. #The multipliers can cause the player's tear delay to go below 5, but cannot cause the player's speed to go below 0.1 or above 2.0. #Multipliers are chosen in a way that keeps their total product roughly the same, and most often will increase and decrease two of the player's stats. #It is possible for three to increase and one to decrease (and vice versa), however."},
	{"407", "" ,"Purity grants a random aura upon pickup. #Taking damage removes the aura until you enter the next room, at which time you gain a new random aura. #There are four possible auras:#Red: +4.0 damage.#Blue: -4 tear delay.#Yellow: +0.5 speed up.#Orange: +7.5 range up. #The tear delay aura can reduce the player's tear delay past the cap of 5."},
	{"408", "" ,"When you take damage, a black ring will appear around the player that damages any enemies in contact with it."},
	{"409", "" ,"Grants 2 Black Hearts.#If the player has no red hearts, this item also grants flight. #Every second time the seconds timer hits 00, 20 or 40, grants a 10 second shield if Isaac is in a room with enemies. #Has no effect on Keeper."},
	{"410", "" ,"The player will occasionally fire a slow-moving eye with infinite range that fires tears identical to the player's tears in the direction the player is firing. #These eyes will disappear upon hitting a wall, enemy or obstacle, even if the player has piercing or spectral tears. #The chance to fire these tears is not affected by luck. #The eyes are not familiars, and therefore will not be affected by items such as BFFS!"},
	{"411", "" ,"Each time the player kills an enemy, they gain +0.5 damage for the current room.#The damage increase is capped to +5 damage after 10 kills. #Some summoned enemies, such as Rag Man's Rag Lings, do not trigger this effect."},
	{"412", "" ,"Upon taking damage a certain number of times, the player gains a permanent demonic familiar. #This familiar can be Dark Bum, Demon Baby, Incubus, Leech, Lil Brimstone, Lil Abaddon, or Succubus. #The first and second familiars spawn after taking damage 15 times each. #The third and fourth spawn after taking damage 30 times each. #No further familiars will spawn. #Only one type of each familiar can be spawned."},
	{"413", "" ,"After picking up enough hearts, the player gains a permanent angelic familiar and generates a soul heart drop. #This familiar can be Holy Water, Guardian Angel, Sworn Protector, The Relic, or Seraphim. #The first and second familiars spawn after picking up 15 heart pickups each. #The third, fourth and fifth familiars spawn after picking up 30 heart pickups each. #No further familiars will spawn. #Red, soul and black hearts count towards spawning a familiar, but items that directly add health such as Book of Revelations or Yum Heart do not. #Only one type of each familiar can be spawned. #The Lost can pick up soul and black hearts, and thus can use this item, but it does nothing for the Keeper."},
	{"414", "" ,"Causes two items to spawn instead of one in each Treasure Room, as long as the Treasure Room is not a small room. #Only one of the two items can be taken, the other disappears. #In alt path treasure rooms, two known items and one unknown item will appear."},
	{"415", "" ,"Grants 2 soul hearts. #Replaces normal tears with blue diamond tears while the player has no empty red heart containers, even if the player has no red heart containers whatsoever. #While the effect is active, grants 2x damage, +5.25 range up, +0.5 tear height and -0.30 shot speed down. Also causes the crown above the player's heart to glow blue. #Taking damage will deactivate the effect for the rest of the current room, regardless of the player's current hp."},
	{"416", "" ,"Increases the coin cap to 999. #If a room would yield no reward, drop 1-3 random coins instead."},
	{"417", "" ,"Familiar that bounces around the room with a damaging aura, dealing 30% of the player's damage per tick, or roughly 129% of the player's damage per second, to enemies standing within it.#While standing in the aura, the player gains a 1.5x damage multiplier. #This multiplier stacks with other Succubi if you have more than one."},
	{"418", "" ,"Each tear fired gains a random effect. #A full list of possible effects can be found on the wiki page."},
	{"419", "" ,"On use, teleports the player to the next room that has not been explored. #If possible, the chosen room will be touching an explored room. #When used in a room with enemies in it, it will teleport the player to the same room. #The order of rooms chosen is: #Normal rooms, the boss room, the super secret room, the shop, the treasure room, the sacrifice room, the dice room, the library, the curse room, the mini-boss room, the challenge or boss challenge room, the bedroom, the arcade, the vault, the secret room, the devil or angel room, and the I AM ERROR room. #If every room on this list is mapped, Teleport 2.0 will keep you in the I AM ERROR room. #Cannot teleport to crawl spaces, the boss rush room, the blue womb entrance or mega satan. #In the Ascent sequence, if all rooms are explored it will teleport Isaac to the Angel/Devil room."},
	{"420", "" ,"Walking in a circle will spawn a pentagram symbol on the floor, which deals 10 damage per tick to all enemies."},
	{"421", "" ,"Applies charm effect to any enemies in close range."},
	{"422", "" ,"Upon use, the player is returned to the previous room with everything that happened in the current room undone. #Does not refund the Joker card. #Does not return extra lives. #Resets event counters such as Donation Machines, Greed Machines and Eden's Blessing. #Taking damage and then using Glowing Hourglass will reverse the damage for the purposes of attempting a no-damage achievement."},
	{"423", "" ,"Surrounds the player with a large white halo that pulsates. #Each time it pulses, it deals contact damage to enemies equal to the player's tear damage.#Each pulse also converts any enemies touching it into friendly homing tears that deal the player's tear damage."},
	{"424", "" ,"Spawns a sack on pickup. #Coins have a 10% chance to be replaced with grab bags. #Bombs, keys, card, runes and little batteries have a 20% chance. #The exception to this are pickups spawned by Isaac himself, such as from IV Bag or Fanny Pack, or the contents of other sacks."},
	{"425", "" ,"Causes a cone of light to shine from the player's chest in the direction they're facing. #The cone slows all enemies and enemy shots that are within it. #Will not slow bosses, but does slow their shots. #Enemies do not stay slowed after moving the light off them, but shots will.#Removes Curse of Darkness for the current floor, but does not provide immunity."},
	{"426", "" ,"Familiar which follows your movement on a 3 second delay.#Deals 2 damage per tick, 30 damage per second, on contact to enemies."},
	{"427", "" ,"Places a pushable TNT barrel which can be pushed and detonated normally.#If used a second time in the same room while the last TNT barrel is still there, it will remotely explode the TNT, consuming the charge without creating another TNT. #This remote detonation can be used while the item is uncharged."},
	{"428", "" ,"Grants 4 soul hearts.#Fully restores your red health."},
	{"429", "" ,"Grants tears a 5% chance to drop pennies on the floor upon hitting an enemy. #Enemies that do not take damage but still get hit, such as the front side of a Knight, will still spawn coins. #Does not work with The Forgotten, but does work with The Soul."},
	{"430", "" ,"Familiar that follows your movement on a 2.5 second delay.#Fires tears at nearby enemies that deal damage equal to the player's tear damage."},
	{"431", "" ,"Familiar that follows your movement on a 2.5 second delay.#When a friendly tear, either shot by the player or a familiar, passes through Multidimensional Baby, it splits into two tears which gain speed and flash black and white."},
	{"432", "" ,"Grants 5 bombs. #Grants bombs a random chance to spawn a pickup or trinket when they explode. #Grants bombs a chance to charm random enemies in the room when they explode. #In Greed Mode, bombs will not drop coins."},
	{"433", "" ,"Each time you take damage, My Shadow will apply a fear effect to all enemies in the room and spawn a friendly black charger that will attack for you."},
	{"434", "" ,"Every time you kill an enemy a blue fly will be added to the Jar.#The Jar can hold up to 20 flies.#Using the Jar of Flies will release all the flies.#Killing an enemy with a familiar, including flies from the jar, does not add a fly to the jar.#This means that this item is significantly less useful on Lilith, as her original Incubus will not give flies."},
	{"435", "" ,"Familiar which shoots tears in the four cardinal directions. #His tears do 3.5 damage."},
	{"436", "" ,"Glass of milk familiar which follows the player. #Upon taking damage the milk spills on the ground, increasing Isaac's rate of fire by +1.0 for the rest of the room."},
	{"437", "" ,"Restart the room and respawn all enemies. #Pickups or chests may be granted for clearing the room.#If used on a boss, devil or angel room, the player is teleported to another room and that room is restarted. #Does nothing on Challenge rooms or on a room that had no enemies. #When used on a secret room that had a Greed or Super Greed, it becomes a regular secret room. #Similarly, using it on a shop which had a Greed in it causes it to spawn items like a regular shop. #Does nothing in Greed Mode."},
	{"438", "" ,"Grants 1 soul heart.#+0.7 Tears up.#Reduces the player's size.#Increases the pitch of the player's voice."},
	{"439", "" ,"On use, drops a random trinket on the ground.#+1 Luck while held.#While held, doubles the effect of most trinkets. #A list of trinkets that are not affected by this can be found on the wiki page."},
	{"440", "" ,"#-17.0 Range down.#+2.0 Tear height.#Overall, the range down and tear height up result in a slightly lower effective range, though characters like Azazel who aren't affected by tear height will be greatly impacted. #Approximately every 25 seconds, the player will stop firing tears until the fire key is released. #Upon releasing the fire key, a kidney stone which deals extra damage while piercing enemies and walls will be fired, followed by a large barrage of normal tears."},
	{"441", "" ,"Fires a giant Brimstone laser, similar to the beam fired by Mega Satan, for 15 seconds. #The beam deals 5x the player's tear damage per tick. #The beam pushes the player backwards while firing. #The beam lasts between rooms and floors. #The beam can be aimed in any direction. #The beam destroys fires and poop, and will detonate TNT. #While firing the laser, the player cannot open chests, pick up batteries, trinkets, pills, cards, runes, or collectibles, pick up the trophy or enter the chest after defeating Isaac or ???, or sleep in a bed. #Picking up a Battery or a Charged Key will only fill 6 of the 12 charges. #A 48 Hour Energy pill will fully charge the item. #A mega battery will fully charge it twice."},
	{"442", "" ,"While the player has exactly one red heart, they gain +1.50 Range up, +0.7 Tears up, and +0.20 Shot speed up."},
	{"443", "" ,"Luck dependent chance to fire a razor blade that deals 4x tear damage. #Chance increases to 100% at 14 or higher luck. #+0.3 Tears up."},
	{"444", "" ,"Every 15 tears fired, the player fires a cluster of tears. #Causes tears to only fire from the player's right eye. #Gives non-Cain characters the same special properties that Cain has in regards to items like Blood Clot."},
	{"445", "" ,"+0.3 Damage up.#+0.1 Speed up.#Upon entering a room with an undiscovered secret room or super secret room adjacent to it, a howl sound effect plays. #Upon entering a room with an undiscovered crawlspace in it, a barking sound effect plays."},
	{"446", "" ,"While firing, the player is surrounded by a green aura that poisons enemies nearby, dealing 1x tear damage."},
	{"447", "" ,"Every 7.5 seconds of uninterrupted firing a small brown cloud is created. #The cloud deals 1x the player's tear damage roughly 5 times per second on contact. #They can be moved by shooting them. #They last 15 seconds."},
	{"448", "" ,"Upon taking damage, there is a chance to drop a full red heart. #Taking damage causes Isaac to bleed, spewing red tears around him constantly. #Can be focused by firing in a direction with slightly increased range. #If the bleeding goes for too long, Isaac takes more damage with a large chance of dropping a full heart. #Bleeding stops after receiving any form of red heart healing, or if the next hit would be fatal."},
	{"449", "" ,"Grants 1 soul heart.#Enemy bullets have a chance to be deflected upon hitting the player, returning as confusion-causing shots that use the player's tear damage and tear effects."},
	{"450", "" ,"Every 20 tears fired also fires a golden tear alongside it, which turns enemies to gold and freezes them for a few seconds at the cost of one penny. #Can fire golden tears even if the player has no coins. #The golden tear deals 2x tear damage. #Enemies killed while golden will drop 1-4 pennies."},
	{"451", "" ,"Drops random card or rune on pickup.#Adds an extra effect to most tarot cards used, with most simply doubling the effectiveness of the card. #A full list of effects of cards can be found on the wiki page. #Tarot Cloth's effect applies to card effects used through Blank Card."},
	{"452", "" ,"Causes the player to fire 10 tears in a circle around them, similar to Tammy's Head, after taking damage. #These tears are given a +25 damage bonus. #Also has a chance to activate the Anemic effect for 2 seconds, granting +5.0 range and causing the player to leave a red trail of creep."},
	{"453", "" ,"Turns the players tears into bones, which shatter into 1-3 shards upon hitting an obstacle or enemy.#The shards deal 50% of the player's normal damage.#+1.5 Range up. #+1.0 Tear height."},
	{"454", "" ,"Allows the player to carry two cards, runes or pills, or any combination of the three, at the same time.#Drops random card, pill or rune on pickup."},
	{"455", "" ,"+1.5 Range up.#Drops a lucky penny, which gives +1 luck upon pickup."},
	{"456", "" ,"Grants one full red heart container."},
	{"457", "" ,"Grants one soul heart.#Grants a chance for any damage to not deduct health. #This includes damage through tears, contact, explosions, cursed doors, blood banks, and demon beggars."},
	{"458", "" ,"Drops one random trinket on pickup.#Grants a second trinket slot.#Cannot grant a third if the player has a second already."},
	{"459", "" ,"Grants a chance to fire a booger which sticks to an enemy and poisons it. #Multiple boogers can stick to one enemy, dealing their damage once per second. #Each tick of poisons deals damage equal to the player's tear damage. #Lasts 60 seconds or until the enemy dies. #The chance to fire a booger tear is not affected luck."},
	{"460", "" ,"Grants a chance to shoot concussive tears, which confuse enemies. #The confusion caused by this item is effectively permanent for normal enemies, and lasts much longer than normal for bosses. #Makes the screen darker. #The chance to fire concussive tears is not affected by luck."},
	{"461", "" ,"Grants a chance to fire an egg sack which spawns slowing creep. #If an egg sack hits an enemy, a blue fly or spider is spawned. #Egg sack tears have significantly higher tear height and thus higher range. #The chance to fire an egg sack is affected by luck, but cannot reach 100% at high luck."},
	{"462", "" ,"Grants piercing shots.#A tear which pierces an enemy doubles in damage and homes in on enemies."},
	{"463", "" ,"+0.3 Damage up.#Grants a chance to fire an acidic tear which destroys destructibles such as rocks, as well as open doors and secret rooms upon contact. #Can be used to bridge gaps with destructibles. #Does not open stone chests, but can destroy Angel statues. #Key blocks are destroyed without consuming a key. #The chance to fire an acid tear does not increase with luck."},
	{"464", "" ,"Grants 2 soul hearts.#Modifies the drops of enemy champions as well as room clear drops depending on certain conditions. The priorities of drops, in order, are as follows: #Soul Hearts, when the player has no read heart containers and less than 2 soul heart. #Full Red Hearts, while at 0.5 red hearts. #Keys, when the player has no keys. #Bombs, when the player has no bombs. #Full Red Hearts, when the player has at least a half red heart container empty. #Coins, when the player has less than 15 pennies. #Keys, when the player has less than 5 keys. #Bombs, when the player has less than 5 bombs. #Trinkets, if the player has no trinkets and there are no trinkets on the ground in the room. #Soul Hearts, when the player has less than 6 total heart containers of any kind. #If none of the above conditions are true, champions drop pickups as normal."},
	{"465", "" ,"+0.3 Tears up.#Allows you to fire tears diagonally; with keyboard or when using buttons to fire on a controller, tears can be fired at 45 degree angles by holding two buttons. #If using an analog input, tears can be fired in any direction. #Mouse control can be enabled to allow full directional firing with the mouse."},
	{"466", "" ,"The first enemy killed in a room release a gas explosion which poisons nearby enemies. #Poisoned enemies will also release the explosion upon death, even if the poison effect has ended before they die."},
	{"467", "" ,"Floating finger familiar that can be aimed with the fire buttons. #Fires invisible spectral lasers that deal 10% of the player's tear damage continuously. #While not being aimed, it points in the direction of movement, or downwards if the player is still. #The Finger applies the player's tear effects. #The Finger does not do contact damage."},
	{"468", "" ,"Follows your movement on a 1 second delay, dealing 2 damage per tick, 30 damage per second, on contact with enemies.#Permanently dies after dealing 600 damage and turns into friendly dark Chargers."},
	{"469", "" ,"Familiar which follows the enemy, leaving a trail of creep that deals 2 damage per tick, 6 damage per second, to non flying enemies who walk on it.#Enemies touching the cloud have a chance to spawn a Holy Light beam, dealing 20 + tear damage and hit up to 8 times."},
	{"470", "" ,"Familiar which bounces around the room, dealing 2 damage per tick, 30 damage per second, on contact with enemies. #While the player fires tears, Hushy stops moving and can block tears."},
	{"471", "" ,"Familiar which charges up and fires a cluster of tears, similar to Monstro's Lung or Monstro's main attack. #Fires 12-14 tears that deal 3.5 damage each."},
	{"472", "" ,"Familiar which follows the player and always appears first in the familiar chain. #While the player fires tears, King Baby stops moving and glows white. #While King Baby is stationary, all other familiars remain stationary and fire at nearby enemies automatically. #When the player stops firing tears, King Baby moves rapidly back towards the player. #There are a number of familiars that are not affected by King Baby, and the full list can be found on the wiki."},
	{"473", "" ,"Familiar that follows the player, charging across the room slowly when the player fires. #Blocks enemy shots and deals 2.7 damage per tick, 40.5 damage per second, on contact with enemies."},
	{"474","Broken Glass Cannon","Turns into Glass Cannon when fully charged. #Acquired when Isaac takes damage holding the Glass Cannon."},
	{"475", "" ,"Upon use, deals 9,999,999 damage to every enemy in the room, then kills you 3 seconds later. #Does not kill both phases of bosses such as The Lamb, Hush, or Mega Satan. #Without extra lives, you will be unable to enter the chest or the next floor quickly enough to survive; however, the boss kill will still count for a completion mark on the character's post it note. #The only exceptions are Delirium and Mother, whose death animation is long enough that the player dies before gaining the credit for completion without Lazarus' Rags, which revives you in the room you died in."},
	{"476", "" ,"Duplicates 1 random pickup in the current room, including cards, runes, chests and trinkets. #Cannot duplicate Jera runes or Mimic chests, though a regular chest may duplicate into a red chest or a mimic. #The player cannot hold two of the same trinket at once, even with two slots. #It is possible to duplicate unpurchased shop pickups."},
	{"477", "" ,"When used, consume any pedestal items in the room.#If the consumed item is an active item, it adds that ability to Void; using Void at any time in the future activates the effect of all previously consumed active items. #Single use items such as Diploplia only activate once.#If the consumed item is a passive item, the player gains 2 random stat increases. The possibilities include: #+1 flat damage. #+0.5 Tears up. #+0.2 Speed up. #+0.2 Shot speed up. #+1 Luck up. #+0.5 Range up. #If tears or speed are at their maximum and are chosen, there will be no visible increase. #Does not work on items in the shop, devil deals, etc. if they have not been bought first. #Can consume items Isaac is holding above his head, allowing the player to absorb passive items bought from devil deals or shops."},
	{"478", "" ,"Stops all enemies in the current room until a fire button is pressed. #This does not affect troll bombs, and does not disable contact damage. #Bosses are affected, but will begin moving after 30 seconds. #The player can still deal damage with orbitals or other sources of damage during this time."},
	{"479", "" ,"Consumes your trinket and gives you the effect permanently. #While held, Mom's Box will double the effect of all absorbed trinkets if they can be affected by Mom's Box normally. #Trinkets which normally only activate once still only activate once after being absorbed. #Picking up a copy of an already smelted trinket gives no bonus."},
	{"480", "" ,"Upon use, converts pickups within the current room into blue flies or spiders. #If the room has no pickups to convert, it instead doubles the player's current amount of blue flies and spiders, or spawns one blue fly or spider if the player has none."},
	{"481", "" ,"On use, grants random tear effects for the rest of the room. #Rotates most sprites, including enemies and pickups, 90 degrees and moves it up and left. #Does not change hitboxes at all. #Increases one of the player's stats, and decreases another. Possible changes include: #+/-1 Damage. #+/-0.5 Tears. #+/-0.2 Speed. #+/-0.2 Shot speed. #+/-1 Luck. #+/-0.5 Range. #Also speeds up or slows down the music for the current room."},
	{"482", "" ,"Changes the player into a different character at the cost of the last item collected. #All stat changes of the new character are applied; for example, the 2x damage bonus from being Dark Judas. #Does not grant starting items of other characters, such as the Holy Mantle on The Lost. #It is possible for the player to transform into the character they currently are. #Removed items do not count towards transformations. #Cannot transform the player into characters that are not unlocked. #Further interactions can be found on the wiki page."},
	{"483", "" ,"Destroys all obstacles, machines, beggar, and fire places in the current room, and deals 200 damage to every enemy. #This effect applies to every room the player walks into after using it as well. #Opens all Secret room and Super Secret room doors. #Opens the Boss Rush and Blue Womb doors regardless of time limits, though leaving the boss room for any reason (such as to go to a Deal with the Devil) will cause it to close again, and leaving the room after entering it will not allow the player to re-enter. #Will not open the Mega Satan door."},
	{"484", "" ,"Upon use, the player farts, knocking back enemies and their shots. #Also sends out rock waves that deal 10 damage per tick to nearby enemies and break destructibles, such as rocks and secret room entrances. #Will open stone chests and explode the donation machine."},
	{"485", "" ,"Upon use, this item has a 50% chance to duplicate all items, pickups and chests in the current room. #On rooms like the shop or a devil room, the duplicated items can be taken at no cost. #Duplicating items in Boss Rush will allow the player to take all of the duplicated items and one of the originals, though taking any of them will start the Rush. #If this duplication fails, all the items, pickups and chests disappear and a penny is created instead. #Failing to duplicate on Boss Rush will not start the Rush."},
	{"486", "" ,"Causes the player to 'take damage' without taking away health, activating any items that trigger upon taking damage."},
	{"487", "" ,"Upon use, one red heart container is removed. #The player gains +0.2 flat damage, one Cube of Meat, and the Anemic effect. #The Anemic effect ends upon leaving the current room. #It is possible to generate multiple Meatboys with this item, though it is also possible for the player to kill themselves with it. #Health removed this way activates Bloody Lust."},
	{"488", "" ,"Grants a random item's effect for the current room. #This can choose any item, passive or active, with the exception of itself, Plan C, and Glowing Hour Glass. #Many possibilities have unexpected effects; a more comprehensive list can be found on the wiki page. #For example, Eden's Blessing does not give an extra item for the next run."},
	{"489", "" ,"Acts as any dice item, and can be cycled through by pressing the drop key (left control on keyboard, right bumper on controller by default). #Charge time varies based on the current die, and updates when used."},
	{"490", "" ,"Upon pickup, this item starts with the number of charges the player's current active item has. #A little battery fills six charges. #Upon use, two random item pedestals using the item pool of the current room are spawned."},
	{"491", "" ,"Drops a random pill every 7 cleared rooms. #The first drop happens after 6 rooms. #Upon using a pill, all enemies in the room are poisoned. #The poison deals 2x Isaac's tear damage, lasts for 6-7 ticks and deals 10 additional damage."},
	{"492", "" ,"Familiar that moves around the room randomly. #If the current room has a Secret or Super Secret room, a tinted rock, or a rock with a crawl space under it, the familiar will fly to stay on top of that area. #If there are multiple secrets, it will fly between them. #+1 Luck up."},
	{"493", "" ,"For every empty heart container gain +0.2 Damage."},
	{"494", "" ,"Tears fire 1-2 sparks of electricity in random directions upon hitting an obstacle or enemy. #These sparks behave like spectral homing lasers that deal 0.5x the player's tear damage. #In Repentance the arcs are much shorter range but will chain between other nearby enemies upon hitting."},
	{"495", "" ,"Shooting tears sometimes spawns a fire similar to Blue Candle, damaging enemies and destroying shots it comes into contact with. #Can pass through obstacles and walls. #Using pooping items, such as the Re-Lax pill or The Poop, causes fires to appear alongside the poop. #The chance of spawning a fire is affected by luck."},
	{"496", "" ,"Luck dependent chance to fire a needle which deals 3x tear damage. #If the needle hits a regular enemy, they will be killed instantly and burst into 10 more tears in a circle around them. #Needle tears fired from the burst from an instant kill do not retain the instant kill or burst-causing abilities, though they still deal 3x damage. #The chance to fire a needle depends on luck."},
	{"497", "" ,"Upon entering a room, the player becomes camouflaged and confuses all non-boss enemies. #The effect lasts until the player presses a fire button. #Lil' Haunts, Stone Grimaces and Stoneys are not affected by this. #Active items and orbitals can be used to deal damage without breaking the effect."},
	{"498", "" ,"Causes both a Devil and Angel room to spawn after defeating a boss if either one of them would spawn normally. #In a room with only two accessible walls, only one of two will spawn. #Upon entering one, the other will disappear even if the player has Goat Head or Eucharist."},
	{"499", "" ,"Causes an Angel Room door to always spawn after every boss fight, excluding the first floor and floors after Chapter 4. #The spawned door will not disappear when leaving and re-entering the boss room. #Without Duality, there is no way to get a Devil Room with this item as it overrides Goat Head."},
	{"500", "" ,"Familiar which follows the player and has a chance to drop a sack upon clearing a room."},
	{"501", "" ,"Grants an extra heart container for every 25 coins the player has, up to a maximum of 4 containers at 99 coins. #This can allow you to exceed the maximum heart container limit on Keeper. #Dropping below the required number of coins for a heart container removes the container. #The opposite is true; losing hearts given by this item causes Isaac to lose the appropriate amount of coins. #The Keeper can go above 2 coin hearts due to this item, as well as go past the 12 health limit when used with Deep Pockets. #The health gain is retroactive, meaning if you pick up the item at 99 coins you gain 4 heart containers. #You will still lose a container for dropping below 99 coins in that situation, however, and losing your last heart container this way can kill you."},
	{"502", "" ,"Grants a chance to fire an additional shot that deals 2x damage and leaves a trail of white creep that slows enemies. #This chance is not affected by luck. #The creep shots are affected by range and shot speed, but don't take tear effects. #The player also fires a creep shot in a random direction upon taking damage."},
	{"503", "" ,"Luck dependent chance to fire a piercing tear that summons Big Horn's hand, killing non-boss enemies instantly and dealing extra damage to bosses. #Also causes enemies to take 3.5 damage on contact with the player, overriding all other contact damage effects with the exception of Midas' Touch. #The chance of firing a tear scales from 5% at 0 luck to 20% at 15 luck."},
	{"504", "" ,"Upon use, spawns a stationary fly turret that shoots at enemies, dealing 3.5 damage per shot. #The flies are completely invulnerable and are ignored by enemies. #Only 35 flies can be spawned in total."},
	{"505", "" ,"Adds a chance to spawn a friendly charmed enemy upon entering a room with enemies in it. #These persist between rooms and floors, and will follow the player until they die. #Unlike normal charmed enemies, these cannot hurt the player. #Multiple charmed enemies can spawn at the same time. #For enemies that spawn other enemies, the spawned enemies will also be friendly. #The effect is not activated upon entering the main room in Greed or Greedier mode."},
	{"506", "" ,"When tears hit the 'back' of an enemy, they deal 2x damage and inflict bleeding. #Bleeding enemies take 10% of their maximum health in damage every 5 seconds."},
	{"507", "" ,"Damages all enemies in the room, dealing the player's tear damage plus 10% of the enemy's maximum health. #Mostly ignores damage bonus from Ipecac. #Has a chance to drop half red when it damages an enemy. #When used on Delirium, damage is calculated using the max health of the current boss it's mimicking. Using this item when Delirium is not transformed will deal the most damage."},
	{"508", "" ,"Razor orbital which deals 20% of the player damage per tick, 300% per second, on contact with enemies, as well as causing them to bleed. #Bleeding enemies take 10% of their maximum health as damage every 5 seconds. #Bosses cannot bleed and take no damage from the razor. #Will not block enemy shots."},
	{"509", "" ,"Orbital eye which shoots in the direction it faces when enemies are in it's line of sight. #It deals 2 damage per tick, 30 damage per second, on contact and it's tears deal 3.5 damage. #Does block enemy shots."},
	{"510", "" ,"Spawns a Charmed version of a boss to fight for you for the rest of the room. #Changes the appearance of the current room so it looks like a different chapter. #This item can be fully charged with a single battery. #If a spawned boss leaves creep, the creep will damage the player. #In 1x2 rooms, Ultra Greed will spawn, locking all doors and targeting the player. #He won't deal damage to the player, but his summons can. #If any other boss summons monsters, they will be charmed as well and persist to other rooms."},
	{"511", "" ,"Fly familiar that orbits around a random enemy, dealing 5 damage per tick, 10.75 damage per second, to enemies it comes in contact with. #When the enemy it's orbiting dies, it moves to a different enemy. #If no enemies are alive, it orbits the player."},
	{"512", "" ,"Upon use, the player throws a black hole which sucks in and damages enemies. #It lasts about 6 seconds, dealing 0.4 damage per tick very rapidly. #The black hole also destroys nearby obstacles and slightly attracts the player and pickups. #Pickups can be pulled across pits."},
	{"513", "" ,"+0.1 Damage up.#Grants 1 sou l heart.#Enemies may randomly become charmed or feared for a brief moment.#Grants a chance to spawn a rainbow poop upon taking damage. #This chance is not affected by luck."},
	{"514", "" ,"Enemies, enemy shots, tears and pickups will briefly freeze in place at random intervals. #Frozen enemy shots will disappear. #The frequency of this effect depends on the player's luck. #25% chance to double the room drop, though it cannot double chests, pills or cards."},
	{"515", "" ,"Upon use, spawns a random item from the current room's item pool.#There is a chance to spawn a Lump of Coal or The Poop instead."},
	{"516", "" ,"Upon use, spawns a sprinkler that rotates in a circle, spraying tears in the 8 cardinal and diagonal directions. #The sprinkler copies the player's stats and tear effects, with the rate of fire and rotation speed depending on the player's tear stat."},
	{"517", "" ,"Grants 7 bombs.#Removes the delay between bomb placements, allowing them to be placed very quickly. #Fast bombs do not knock each other back."},
	{"518", "" ,"Grants a familiar with random tear effects, fire rate and damage which takes the appearance of a random co-op baby. #The familiar is randomized upon entering a new floor."},
	{"519", "" ,"Grants a familiar that transforms into a random familiar every 10 seconds. #The transformed familiar deals the same damage as their non-Delirium counterparts, but will not deal contact damage. #A full list of possible transformations can be found on the wiki."},
	{"520", "" ,"Grants one charge for your active item for every 15 enemies killed."},
	{"521", "" ,"Upon use, one random item in a shop, devil room, or black market becomes free. #While held, guarantees a random item or pickup from the shop will be on sale. #Using the coupon in the shop while holding Restock will not spawn a new item."},
	{"522", "" ,"Upon use, for the next 3 seconds any enemy shots that come near the player are held in place. #After the charge is depleted, they are fired back as tears which deal 3.5 damage. #The player can move the tears into enemies while they're held up; they won't disappear until the effect ends, but will deal no more damage past the first hit. #Pushes enemies away for the duration of the item's usage."},
	{"523", "" ,"Upon use, if the box is empty it stores up to 6 items and pickups from the current room.#If the box is full, it places all stored items and pickups on the ground."},
	{"524", "" ,"Connects the player's tears together with electricity that deals 33% of Isaac's tear damage on contact to enemies. #Tears can also connect to other allied tears, such as those from shooting familiars."},
	{"525", "" ,"Upon taking damage, an orbital is spawned which blocks enemy shots and deals 7 damage per tick to enemies it comes into contact with. #A maximum of three of these orbitals can appear at once. #They will be destroyed if they take enough damage from enemies or enemy shots."},
	{"526", "" ,"Grants a Harbinger familiar which changes every 10 seconds.#All harbingers deal contact damage to enemies and periodically spawn spawn locusts if the player has none. Locusts act like blue flies unless otherwise stated.#Famine and Pestilence wander around the room, Famine leaving a trail of black slowing creep and Pestilence leaving a green trail of creep which deals 1 damage per tick, 30 per second, to non flying enemies. They deal 0.5 damage per tick, 15 per second, on contact. Famine spawns yellow locusts which slow enemies, and Pestilence spawns green locusts which poison enemies. #Conquest deals the same amount of damage and moves just like Famine and Pestilence, but spawns two locusts at once and much more quickly than the rest. #War and Death chase enemies, dealing 1.5 damage per tick, 45 per second, on contact. War spawns red locusts that explode upon damaging an enemy at a slower rate than the other Harbingers, and Death spawns black locusts which deal 'a very high amount of damage'."},
	{"527", "" ,"Summons a familiar near the player that will follow him around, as well as summoning a controllable blue crosshair. After a few seconds, the crosshair disappears and the ghost will perform an action depending on what the cross was targeting. #Can be used to steal shop items, with a chance to fail, grab pickups across rooms, open golden, stone and eternal chests for free, press buttons, opens doors (including Mega Satan's door) and more. #Does not open the Depths II door, but does work on alt path doors. #A full list can be found on the wiki page."},
	{"528", "" ,"Familiar that orbits the player at a medium distance. #Tears that pass through the prism split into four multi-colored tears. #Unlike Multidimensional Baby, these extra tears are exactly the same as the base tear and gain no extra stats or abilities."},
	{"529", "" ,"Replaces the player's tears with eyeballs that can bounce off each other. #The player's tears are no longer limited by range, and will instead dissipate when they stop moving or hit an enemy or obstacle."},
	{"530", "" ,"Upon entering a room with enemies, a skull appears over a random enemy's head. #Killing the marked enemy will cause the skull to move to a different enemy, but killing a non-marked enemy causes the skull to disappear. #If all the enemies in a room are killed in order, the player gains a random reward: #A soul heart, pill, key, bomb or a nickel, #Or +0.2 speed, +0.5 range, +0.5 tears, +0.2 shot speed, +1 flat damage or +1 luck."},
	{"531", "" ,"Tears are fired in an arc, able to fly over obstacles sometimes. #Upon hitting the floor, an obstacle, or an enemy they burst into many smaller tears in all directions. #Increases tear delay by a static 35, and damage by about 31%. #The smaller tears deal a random amount of damage, roughly 50-80% of the main tear."},
	{"532", "" ,"The player's tears decelerate while traveling. Upon stopping or hitting an obstacle, they explode into a burst of 8 tears in all directions. #Hitting an enemy will not cause them to explode. #Tears can be fired into other tears to feed them, increasing their damage and the damage of the burst of tears. #Tears in the burst deal half the damage the main tear would have."},
	{"533", "" ,"Replaces the player's tears with piercing white blasts of light which deal 33% of the player's tear damage, but can hit the same enemy multiple times at lower shot speeds."},
	{"534", "" ,"Allows the player to hold two active items. #The button to swap between active items is the same to swap between cards and pills. #The ? Card does not activate both items. #While holding an active item that grants passive bonuses in the secondary slot, swapping the main slot item with a pedestal item may remove the bonuses. #Swapping the bonus-granting item to the pedestal and back will cause you to regain them."},
	{"535", "" ,"Heals one red heart. #Grants one soul heart. #Grants a shield that blocks one hit, similar to Holy Mantle, upon entering a boss room."},
	{"536", "" ,"Upon use, sacrifices up to 2 random familiars and spawns an item from the Devil Room pool for each familiar sacrificed. #If the player has no familiars, it will do nothing and not be consumed. #In addition to the familiars, any blue flies or spiders are converted to 1 coin each. #Lilith's starting Incubus familiar will not be sacrificed. #Pretty flies count as a single sacrifice. #Isaac's Head familiar can be sacrificed. #Some familiars cannot be sacrificed, or only can be in certain situations. A full list can be found on the wiki page. #The Conjoined transformation will be lost if you do not have enough familiars after using it."},
	{"537", "" ,"Drops a random pill on pickup. #Spawns a familiar that charges up and fires different types of creep. #The type of creep changes randomly each time the player uses a pill. #Possibilities include a line of damaging green creep, slowing black creep, or short-lasting damaging red creep, a short-ranged cone of damaging yellow creep, or a large ring of slowing white creep. #The yellow creep does 2-15.19 damage per tick, randomly. #Red creep does 12 damage per tick. #Green creep does 0.35 damage per tick."},
	{"538", "" ,"Spawns 3 random trinkets on pickup. #Grants a small chance to swallow the player's current trinket, gaining it's effect permanently, upon taking damage."},
	{"539", "" ,"Egg familiar that cracks and turns into a random charmed enemy when the player takes damage. #Regenerates upon entering a different room. #The usefulness of the spawned enemy depends on how many rooms have been cleared without getting hurt."},
	{"540", "" ,"Tears bounce off the floor. #Whenever a tear bounces, it deals 25% of tear damage as splash damage to nearby enemies."},
	{"541", "" ,"Grants 1 bone heart. #Spawns three red heart pickups."},
	{"542", "" ,"Bone orbital that reflects enemy shots. #Reflected projectiles deal 5 damage if they would have dealt a half heart to the player, or 10 for a full heart. #Enemy damage modification from item effects or by stage has no effect on this. #Does no contact damage."},
	{"543", "" ,"Familiar which spawns a white poop when the player takes damage. #White poop has durability similar to golden poop. #White poop has an aura that halves tear delay, has a high chance to block damage like the Cone Head item, increases damage by 1.25x and gives Isaac's tears a homing effect."},
	{"544", "" ,"Bone familiar that can be aimed with the fire buttons and deals the players tear damage six times per second on contact with enemies. #Being hurt boosts the damage slightly for a short moment."},
	{"545", "" ,"Upon use, spawns one of four things for each enemy killed in the current room: #An orbital bone familiar, commonly. #A charmed bony, uncommonly. #A friendly Bone Fly, uncommonly #Or a charmed black bony, rarely. #Orbital bones deal contact damage equal to the player's damage at the time it was spawned, repel enemies that touch it, and block 3 shots or deal 2 ticks of contact damage before being destroyed. #Bonys deal 8.3 contact damage and 5 damage with thrown bones, and Black Bonys explode on death dealing 40 damage to enemies. #This explosion does not hurt or knock back the player."},
	{"546", "" ,"Creates a ring of light around the player that petrifies enemies on contact. #Non-boss enemies are petrified as long as they're touching the ring regardless of duration, while boss enemies will be petrified normally, with a time limit, even if they leave the ring."},
	{"547", "" ,"Grants 1 bone heart.#+0.7 Tears up.#Spawns a Mysterious Paper trinket if the trinket has been unlocked."},
	{"548", "" ,"Familiar that behaves similarly to the boomerang. #It gets thrown out by firing a tear, and deals 2x the player's damage if it hits an enemy. #It will pierce the enemy if the enemy dies, or return to the player if not. #Can retrieve pickups like the boomerang. #Blocks enemy tears both while stationary and when thrown."},
	{"549", "" ,"Removes all the player's red heart containers and grants 6 empty bone hearts. #Upon losing a bone heart, the player fires bones in 8 directions around them and permanently gains +0.5 tears up. #The Lost and Keeper will gain a minor tears up, and Keeper will gain lots of blue flies."},
	{"550", "" ,"While held, Mom's foot will frequently stomp around or on the player. #Using the item will stop this effect until you enter another room. #On Boss Rush, this effect only lasts for one wave. #This effect does not happen on the Mom fight. #Will disappear if you pick up another active item and leave the room. #One of two parts necessary to create Mom's Shovel; the other is obtained by beating Boss Rush while holding it."},
	{"551", "" ,"Second part of Mom's Shovel.#Use Mom's Shovel on the hill of dirt in the Dark Room to unlock a secret character. #Picking up this item will complete the shovel and stop the stomping effect for the rest of this run."},
	{"552", "" ,"Spawns a trapdoor that leads to the next floor.#10% chance to lead to a Crawl Space or a Black Market instead. #Crawl Spaces and Black Markets are identified by the ladder in the hole, instead of just a black void. #Use Mom's Shovel on the hill of dirt in the Dark Room to unlock a secret character."},
	{"553", "" ,"Gives Isaac the chance to shoot a spore that will stick to enemies. #Deals normal damage as well. #The spore explodes 2.5 seconds after sticking to an enemy, dealing 5 damage to and poisoning nearby enemies. #Fires four more spores with homing in a cross pattern."},
	{"554", "" ,"Applies fear on enemies in a small radius around Isaac."},
	{"555", "" ,"Grants 5 coins on pickup. #On use, consumes 5 coins and grants +1.2 damage for the rest of the room. #Can be stacked, but does nothing if Isaac has fewer than 5 coins."},
	{"556", "" ,"Upon activation, Isaac gains the effect of Brimstone for the current room. #If used a second time in the same room, it instead gives Isaac +1.8 damage and increases the size of the laser for the current room."},
	{"557", "" ,"Gives Isaac a fortune, soul heart, card or trinket. #Fortunes are the most likely drop. #Has a chance to give a random luck up or down on use."},
	{"558", "" ,"When Isaac shoots, there is a chance to fire 1-2 additional tears in random directions. #Unaffected by luck. #Increases the aura of light around Isaac during Curse of Darkness."},
	{"559", "" ,"After a short targeting delay, repeatedly zaps enemies that are within close proximity to Isaac with electricity beams. #Can zap enemies up to 6 times per second for 0.75x tear damage each zap. #Beams will chain between enemies, even going outside of the initial activation range."},
	{"560", "" ,"Taking damage causes Isaac to release a ring of 10 tears and gain tears for the current room. #Each tear in the ring does 10 damage and does not use Isaac's tear effects. #Does not activate if damage is absorbed by Holy Mantle. #The first hit taken increases Isaac's tears per second by 1.2. #Each subsequent hit increases tears by 0.4. #Can stack indefinitely, ignoring the tear cap."},
	{"561", "" ,"Quadruples fire rate. #0.3x damage multiplier. #Tears gain random worm trinket effects."},
	{"562", "" ,"Upon pickup, all stats are reverted to the character's base stats. #Prevents stats being lowered for the rest of the run. #Does not effect damage multipliers such as Soy Milk; current damage does not change but future damage increases will be lowered."},
	{"563", "" ,"Grants 5 bombs. #Bombs explode with a random bomb effect. #Can include effects from not yet unlocked items."},
	{"564", "" ,"+0.5 Tears up. #+0.2 Shot speed up."},
	{"565", "" ,"Spawns a chasing familiar that deals contact damage to enemies. #After killing enough enemies, transforms into an angry version that gains a dash attack but attempts to hurt Isaac. #Damaging the aggressive Blood Puppy enough will return it to normal eventually. #Occasionally drops Red hearts."},
	{"566", "" ,"During the transition between floors, Isaac's nightmare shows the item that will be found in the Treasure Room and what boss will be at the end of the floor. #Reveals unknown items. #Grants half a soul heart upon entering a new floor. #Reveals both bosses and items on XL floors."},
	{"567", "" ,"Upon clearing a room Isaac gains +0.4 tears. #Can stack up to five times for a maximum of +2.0 tears per second. #This bonus is reset upon taking damage. #Has a chance to spawn a soul heart on taking damage. #Trap room waves count as room completions."},
	{"568", "" ,"Double tapping a fire key creates a Divine Shield that moves slowly in the direction chosen. #Lasts 1 second and has a cooldown of 3 seconds. #The shield pushes enemies backwards, reflects tears, and reflects enemy Brimstone lasers. #Enemies that hit walls or other enemies take 10 damage and deal 10 damage to other enemies hit. #Enemy reflected tears deal damage depending on the tear source. #Enemy Brimstone beams deal 7 damage per tick (105 per second)."},
	{"569", "" ,"Drains Isaac to one half red heart (or zero red hearts if he has a soul/bone heart) at the start of each new floor. #Give Isaac +(0.15* HeartsLost ^ 2) damage and +(0.05 * HeartsLost) speed for the rest of the floor. #HeartsLost is equal to the total half-hearts of damage taken from Blood Oath."},
	{"570", "" ,"Tears randomly change colors and gain a random status effect on each shot. #A full list of possible effects can be found on the wiki."},
	{"571", "" ,"+0.3 Speed up. #Grants two soul hearts. #Isaac becomes immune to spikes and creep."},
	{"572", "" ,"+1.0 Damage up. #+7.5~ Range up. #-0.16 Shot speed down. #Isaac's tears are controlled mid-flight with tear controls instead of moving on their own. #Similar to The Ludovico Technique, except tears are still fired normally before being controllable."},
	{"573", "" ,"Adds one red heart container and fully restores Isaac's health. #1.2x damage multiplier. #Isaac will occasionally fire extra spectral tears that orbit around him."},
	{"574", "" ,"Gives Isaac an aura that damages enemies inside it. #Deals more damage to enemies closer to Isaac, from 0.75 damage on the edge up to 4 damage when Isaac is in contact with them. #Damages up to five times per second."},
	{"575", "" ,"Gives Isaac a spider familiar that fires four slowing tears in addition to his normal tears. #Slowing tears deal 1.5 damage each, and are fired every 1.5 seconds. #Unaffected by Isaac's stats. #Upon taking damage, there is a chance that Isaac's head will pop, spawning friendly spiders and releasing the familiar. #Leaps at enemies, dealing up to 4.5 contact damage depending on how fast it's moving. #Continues firing slowing tears at nearby enemies, but twice as quickly. #Affected by all familiar synergies even while in Isaac's head."},
	{"576", "" ,"Destroying poops spawns 1-4 friendly Dips. #Converts all enemy Dips into friendly Dips. #Rocks have a chance to be replaced by poop on generation. #Different poops spawn different types of dips with special effects. #A full list of effects can be found on the wiki."},
	{"577", "" ,"Upon use, summons a sword that hangs directly above Isaac. #As long as it hands there, all item pedestals and items spawned from Beggars spawn an additional free item next to them. #After Isaac takes damage once, the sword may fall at any time without warning, killing him regardless of his health. #Being hit more times increases the chance of it falling. #Self-damage does not increase the chance for the sword to fall."},
	{"578", "" ,"Spawns a pool of Lemonade underneath Isaac similar to the Lemon Party pill effect. #Deals 6 damage per tick, 18 per seconds, and lasts 9 seconds."},
	{"579", "" ,"Replaces Isaac's tears with a sword he can swing in front of him. #Deals 3x Isaac's damage + 3.5 and knocks back both enemies and Isaac if it hits. #Can be swung as fast as the fire button can be tapped. #Can collect pickups. #If Isaac has no empty red hearts, occasionally fires a projectile when swung. #Projectile deals Isaac's damage + 2 and a cooldown 2x Isaac's normal tear rate. #Holding an attack button charges a spin attack which hits all enemies around Isaac and deflects enemy projectiles. #Also launches a projectile regardless of Isaac's HP. #The spin attack deals 8x Isaac's damage + 10 and charges at roughly 4x his tear rate. #The projectile fired deals 4x Isaac's damage +4."},
	{"580", "" ,"Allows Isaac to create new rooms by using the key next to a wall where no conditions that could prevent a (secret) room from spawning are met. #These walls have red door outlines on them. #Most commonly normal rooms, but has a chance to be various special rooms. #Huge list of notes for functionality can be found on the wiki, far too long to list here."},
	{"581", "" ,"Spawns a fly orbital familiar which rapidly flies out to deflect enemy tears that are going to strike Isaac. #They return as friendly homing tears that deal 2 damage. #Deals 1 contact damage per tick, 15 per second."},
	{"582", "" ,"Gives Isaac a flat +0.75 fire rate increase which can go past the cap. #Also gives -0.03 speed and distorts the screen and background music. #Each use increases the recharge time, up to 15 seconds on the 9th use. #Can be stacked in the same room. #Does not recharge automatically on the 10th, but can be recharged with batteries. #Leaving the room doubles the speed penalty and multiplies the fire rate bonus by 0.4x for the uses in that room. #Clearing a room removes one uses worth of penalties and bonuses, giving +0.06 speed and -0.3 fire rate."},
	{"583", "" ,"Adds 5 bombs. #If Isaac places a bomb while moving, he will instead fire a fast moving explosive rocket in the direction he's facing."},
	{"584", "" ,"Spawns a wisp that orbits Isaac and fires small spectral tears alongside him. The wisps are damaged and eventually destroyed if they make contact with an enemy, an enemy shot or an explosion. #A normal wisp has 2 health and spectral tears which deal 1.6-2.4 damage. #Multiple wisps can exist at once, up to 26 depending on combinations. #The book will combine with other active items, sometimes granting special effects depending on which item, and using the other item's recharge time."},
	{"585", "" ,"Starts with no charges. Rather than gaining charges by clearing rooms or picking up batteries, it's charged by picking up soul hearts. #Requires 6 total hearts worth of soul hearts to fully charge. #Isaac does not receive the HP from the collected hearts. #Upon activation, it is consumed and spawns three soul hearts and two items from the Angel Room pool. #If Isaac has taken a devil deal, instead spawns 2 hearts and 1 item."},
	{"586", "" ,"Generates a ladder which leads to a special Angel Room at the start of each floor. #This room generates independently from the normal angel room. #Always contain the following: #Three items or pickups for sale. #An Angel statue, which can be fought for a key piece. #A normal beggar near the door. #The ladder disappears if Isaac leaves the starting room."},
	{"587", "" ,"<There is an issue if you are seeing this. Contact somebody!>"},
	{"588", "" ,"Shows the location of the boss room on the map. #After killing the boss of a floor, activates the following effects: #Activates The Sun card effect, full healing Isaac, revealing most of the map and dealing 100 damage to all enemies in the room. #Gives Isaac +3.0 damage and +1.0 luck for the rest of the floor. #Fully charges Isaac's active item. #Removes any curses from the floor."},
	{"589", "" ,"Adds an extra secret and super secret room to each floor. #Reveals one random secret room on the map at the start of each floor. #Each secret room has a beam of light that will raise Isaac's fire rate for the rest of the floor. #Raises it by +1.0 for the first and +0.5 for the rest."},
	{"590", "" ,"+0.4 Speed up. #All doors stay open after entering a room, even if there are enemies."},
	{"591", "" ,"Grants one heart container. #Heals one heart of health. #Charms enemies that are close to Isaac."},
	{"592", "" ,"+1.0 Damage up. #Isaac's tears become rocks which have extra knockback and a chance to destroy obstacles that are destroyed by explosions. #Also destroys key blocks. #Damage dealt is randomly between 0.5x an 1.5x Isaac's tear damage."},
	{"593", "" ,"Double tapping a direction makes Isaac quickly dash in that direction. #Isaac is immune to damage from all sources except blood donation machines, devil beggars and similar self-damage active items. #Deals 4x Isaac's damage + 8. #Direction can be changed by holding another direction. #Has roughly a 3 second cooldown."},
	{"594", "" ,"Grants two red heart containers, only fills one half of one. #-0.3 Speed down. #Standing still causes Isaac to build up speed at +0.25 Speed up per second, max of +0.5 Speed up. #If Isaac has a speed buff, moving releases a fart cloud which damages and inflicts Poison on enemies and drains the speed buff. #Drains at -0.25 Speed down per second."},
	{"595", "" ,"A circle surrounds Isaac which spawns 7 orbiting tears upon entering a room. #These tears copy Isaac's tear properties and drop after 13 seconds. #Enemy tears have a chance to be caught in the orbit for the rest of the room and can be used to damage enemies."},
	{"596", "" ,"Isaac's tears become icicles that slow enemies and freeze monsters kill by them. #Frozen enemies can be kicked, sliding across the floor and shattering to release 10 icicle tears outward."},
	{"597", "" ,"When Isaac is not firing tears, he will charge for up to 3 seconds. #Holding down the fire button releases all stored tears in rapid succession."},
	{"598", "" ,"+0.7 Tears up. #Significantly shrinks Isaac, allowing him to squeeze between objects and makes some enemy shots pass over him."},
	{"599", "" ,"Spawns an additional curse room each floor."},
	{"600", "" ,"Decreases the tear delay of tears fired from Isaac's left eye by roughly 28%. #This difference causes tears to be fired at a staggered rate."},
	{"601", "" ,"Grants an eternal heart. #Allows you to receive an Angel room even if you've taken a Devil deal before. #Also a tears up, but wiki does not list the amount."},
	{"602", "" ,"Spawns a trap door in each shop that leads to an additional underground shop that can sell 2-5 special items, including items from the Secret, Devil, Angel and Boss room item pools. #Prices and other information can be found on the wiki."},
	{"603", "" ,"Fully charges the current active item. #Spawns 2-4 random battery pickups."},
	{"604", "" ,"Upon use, Isaac will pick up a close enough rock or similar item, allowing him to throw it in a direction. #Thrown obstacles deal 40 damage to enemies and break on impact, giving their normal contents if they had any."},
	{"605", "" ,"Summons The Peeper familiar for the current room. #Deals 12 contact damage per tick, 36 per second, and leaves a trail of creep which deals 2 damage per tick, 20 per second."},
	{"606", "" ,"Gives Isaac a chance to fire tears that create rifts where they land. #The Rifts deal 0.5x Isaac's damage twice per tick, 3x Isaac's damage per second, to nearby enemies and pull in enemies, pickups and tears/shots from all sources for 2 seconds. #Enemy shots pulled in will damage other enemies."},
	{"607", "" ,"Gives Isaac a familiar that fires chaotic bursts of tears in all directions at random intervals while in a room with enemies. #Each tear fired does either 3.5 or 5.3 damage."},
	{"608", "" ,"Spawns a shooting familiar which has a chance to petrify or freeze enemies. #Frozen enemies will block enemy shots and slide away when walked into by Isaac. #After colliding with an obstacle or being shot by Isaac enough, Frozen enemies explode into a ring of 10 ice tears which can slow or freeze."},
	{"609", "" ,"Upon use, replaces every item in the current room with other random items corresponding to the current room's item pool. #Items rerolled have a 50% chance to disappear."},
	{"610", "" ,"Gives Isaac a familiar that sits on his head until he takes damage. #Upon taking damage it jumps off Isaac's head onto a nearby enemy, dealing 45 damage and creating a rock line that deals 10 damage in a random direction. #Then acts like Dead Bird for the rest of the room, dealing 6 contact damage per second."},
	{"611", "" ,"Only charges when Isaac is hit. #Makes Isaac shout, dealing damage equal to 20 + 28x the charges it has and pushing away enemies. #Can be used when not fully charged, but the damage and range scale based on charges used."},
	{"612", "" ,"Gives Isaac a small soul that follows closely behind him. If it takes damage, it dies and respawns at the start of the next floor. #If the soul survives to the next floor, it spawns either: #3 soul hearts. #2 eternal hearts. #An item from the Treasure or Angel room pool."},
	{"613", "" ,"<There is an issue if you are seeing this. Contact somebody!>"},
	{"614", "" ,"Gives Isaac a heart container and heals 5 hearts. #Causes Isaac's bombs to leave a pool of creep on the ground when they explode. #Deals 20 damage per second and lasts 15 seconds. #If Isaac has no bombs, he can place a bomb at the cost of half a heart of damage, prioritizing red hearts. #Can kill The Lost."},
	{"615", "" ,"Gives Isaac a Dumpy as a familiar, which very loosely follows Isaac. #If Lil Dumpy gets hit (either by contact damage, enemy shots, or explosions), it either: #pushes nearby enemies and shots away. #deals 3 damage to and stuns nearby enemies. #or makes a poisonous fart that deals 5 damage to and poisons nearby enemies. #It then flies in a random direction."},
	{"616", "" ,"Gives Isaac the chance to shoot fires alongside his regular tears that block enemy shots and deal damage to enemies that touch them, similar to those shot by Red Candle. #Blocks up to four shots or deals up to 4 ticks of damage. #The first tick does 4x damage, 3x after being hit once, and 2x for the rest. #Destroys shopkeepers. #Depends on luck, up to 100% at 11 luck."},
	{"617", "" ,"Gives Isaac the chance to fire tears that magnetize enemies they hit, pulling enemies and pickups towards them. #All tears and enemy shots will be strongly pulled towards magnetized enemies. #Enemy shots will damage enemies when pulled this way."},
	{"618", "" ,"Adds a chance to fire tears that mark enemies. #Marked enemies will be attacked by other enemies until either they kill all the enemies attacking it or are killed (similar to the Charmed effect)."},
	{"619", "" ,"Gives a unique passive ability that varies from character to character. #The effects are defined related to each character's feature. #Further information can be found on the wiki; it's a real big table, have fun!"},
	{"620", "" ,"<There is an issue if you are seeing this. Contact somebody!>"},
	{"621", "" ,"On pickup, fully heals Isaac and gives him a temporary +21.6 damage up. #Damage scales down over 3 minutes. #Because of how the damage formula works, this accelerates over time."},
	{"622", "" ,"Resets your character to default and teleports you to a unique Bedroom like an I AM ERROR room. #It has a Bed, two random Chests, two Sacks and a random trinket. #For each item removed by Genesis, you are given the choice between three items from the removed item's pool to choose from, one after another."},
	{"623", "" ,"On use, Isaac holds a key above his head. #Pressing a fire button removes one key and throws it as a piercing projectile. #The key deals 5x Isaac's damage + 30 to enemies hit, and opens locked doors and chests it hits. #Also breaks rocks. #Grants 5 keys on first pick up on a run."},
	{"624", "" ,"Spawns 5 random cards."},
	{"625", "" ,"For 30 seconds, persisting between rooms, Isaac gains: #A 4x damage multiplier and +7.0~ range. #A 2.5x tear delay multiplier. #Invulnerability to damage. #The ability to destroy obstacles and open doors by walking into them. #1,600 contact damage per second to enemies."},
	{"626", "" ,"Spawns a knife handle familiar. #Causes Knife Piece 2 to appear in Mines/Ash Pit II. #If Isaac has both knife pieces, grants a familiar that flies forward when Isaac shoots, dealing heavy damage."},
	{"627", "" ,"Combines with knife piece 1, granting a familiar that flies forward when Isaac shoots, dealing heavy damage."},
	{"628", "" ,"Takes Isaac to an abandoned and expanded version of Home, which has one copy of every item in the game. #After taking an item, Isaac returns to the room he used Death Certificate in. #In addition to items, the area also has several pickups."},
	{"629", "" ,"Spawns a familiar that orbits around Isaac, dealing contact damage and firing shielded tears at incoming enemy projectiles."},
	{"630", "" ,"<There is an issue if you are seeing this. Contact somebody!>"},
	{"631", "" ,"Splits enemies in the room into two smaller versions with 40% HP each. #Enemies who normally split, such as The Fallen, take damage required to make them split. #Segmented enemies will lose have their segments, rounded down. #Cables between enemies will be cut. #Cannot be used on invincible enemies. #Does not function on Hush or any final boss *except* Delirium."},
	{"632", "" ,"+2.0 Luck up."},
	{"633", "" ,"Grants flight and a one-time Holy Mantle style effect. #+0.1 Speed up. #+2.95 Damage up. #If Isaac is below 6 hearts, he is healed to 6 hearts with a combination of red and soul hearts. #Immune to full-run rerolls. #If you see this message, congratulations on unlocking Death Certificate, that's insane. #Or knowing the Spindown dice interaction, that's less insane but still props. #I lost the game."},
	{"634", "" ,"Spawns a red crack on the ground while Isaac is in a room with enemies. #Walking over the crack summons a ghost that homes in on the nearest enemy, exploding for twice Isaac's damage up to 3 times. #If the enemy is killed, another cracks spawns."},
	{"635", "" ,"While held, spawns a familiar that moves in the direction Isaac shoots. #Activating the item causes Isaac to swap places with the familiar, gaining brief damage immunity. #Teleporting onto an enemy deals 40 + 3.5x Isaac's damage. #Teleporting next to a fire will put it out. #Deals 1.5 contact damage to enemies per tick, 3 per second."},
	{"636", "" ,"Returns Isaac to the start of the run with all items and stat boosts intact, similar to a Victory Lap, and disappears on use. #Works slightly differently overall, further details available on the wiki. #Most notably, achievements are still unlockable after use and the timer/score do not reset."},
	{"637", "" ,"Adds a chance to shoot fist shape tears that cause extreme knockback and confusion. #Enemies knocked into walls or other enemies will take/deal 10 damage."},
	{"638", "" ,"Instantly kills the first monster it hits, as well as all other copies in the room. #Only one use per floor. #The hit enemy no longer spawns for the rest of the run. #Bosses instead take 15 damage. If this attack is fatal, any further encounters are removed."},
	{"639", "" ,"Grants a rotten heart on use."},
	{"640", "" ,"On use, emits a stream of blue flames in whichever direction Isaac is facing. #Each flame deals 1.5 - 2.1 damage per tick, depending on how far it's traveled, for 22.5-31.5 damage per second. #Multiple flames can damage the same enemy simultaneously. #The fire destroys enemy projectiles, poop, and other fires, but bounces off rocks. #Killing enemies grants a soul charge to the Urn, up to a maximum of 20. Killing bosses grants a larger boost. #Charges must be used to power Urn of Souls. Each charge is equivalent to 15 flames over half a second."},
	{"641", "" ,"While in a room with enemies, creates a chain of tears that Isaac drags behind him. #Tears deal 3.5 damage. #The shorter the chain is, the faster it grows."},
	{"642", "" ,"Consumes a red heart container or two soul hearts to spawn an item from the current room's item pool. #Gives Isaac a broken heart container which can never be filled, permanently reducing his max possible health. #The Lost loses the item upon uses it. #If Isaac discards Magic Skin, all further items have a chance to be replaced by a fully charged Magic Skin. #More uses increases this chance."},
	{"643", "" ,"Gives Isaac flight and two soul hearts. #Continuously firing for 2.5 seconds allows Isaac to fire a powerful holy laser when the fire button is released, dealing Isaac's damage per tick up to 15 times."},
	{"644", "" ,"Gives Isaac one of: #+1.0 flat Damage up. #+0.6 Tears up. #+0.2 Speed up. #or +5.25 Range up. #Depends on which attribute the game thinks Isaac has the least of. #Also drops either 3 coins, 1 bomb or 1 key."},
	{"645", "" ,"Grants a large orbital similar to Teratoma that slowly orbits Isaac, dealing 3.5 contact damage per second to enemies and repelling them. #After blocking 3 shots and/or dealing 3 ticks of contact damage, the orbital splits into two smaller ones that orbit opposite of each other. #They behave the same as the original, except they are smaller and can only take 2 hits before being destroyed, bursting into 3 blue spiders in the process. #5 seconds after both orbitals are destroyed, the original, full-size orbital respawns."},
	{"646", "" ,"Gives Isaac 5 bombs. #Causes Isaac's bombs to fire brimstone lasers in the cardinal directions, dealing 8 damage per tick up to 20 times."},
	{"647", "" ,"Causes Isaac's active item to charge when Isaac deals damage to enemies, rather than when he clears rooms or picks up batteries. #Charges are gained at a rate of 60 damage dealt per charge."},
	{"648", "" ,"<There is an issue if you are seeing this. Contact somebody!>"},
	{"649", "" ,"Gives Isaac a familiar that mimics Baby Plum's attack of shooting tears and propelling itself diagonally around the room. #It deals 2 contact damage per tick to enemies (6 per second) and 3 with the tears it fires behind itself while moving."},
	{"650", "" ,"On use, summons Baby Plum to fight for Isaac in the current room for ~10 seconds. #Baby plum will always twirl, jump, then spit blood and bounce around the room before waving goodbye and flying away. #Deals 12 contact damage per tick, 24 per second, 3.5 damage per shot and 2 damage per tick with creep."},
	{"651", "" ,"Spawns a familiar that slowly travels through the floor to the boss room, fading through doors. #Stands in the middle of the boss room once it reaches it. #The familiar emits an aura that grants +1.0 Damage up, a 1.2x damage multiplier, a 0.4x tear delay multiplier and homing tears."},
	{"652", "" ,"Spawns an ice cube familiar that cannot move unless Isaac pushes it or enemies shoot it. #Blocks projectiles. #Freezes enemies killed by it. #Deals up to 11 contact damage depending on speed when it collides with an enemy."},
	{"653", "" ,"While held, non-ghost enemies leave behind small, red ghosts on death; using the item causes the ghosts to explode, dealing damage to nearby enemies. #The damage exploding ghosts deal is equal to 3 + 0.04x the health of the enemy the ghost spawned from, and each explosion can hit the same enemy up to 3 times. #Enemies with high health, such as champion enemies, minibosses and bosses will leave behind a larger ghost that creates three explosions, instead of just one. #Explosions from this item do not damage the player or terrain, but can destroy enemy projectiles."},
	{"654", "" ,"Grants one black heart on pickup. #Identifies all pills on pickup. #Converts all good pills into their bad counterparts, including stat up pills turning into stat downs, but gives them positive secondary effects. #Bad stat down pills grant +0.6 Damage up. Bad non-stat down pills drop a black heart on use."},
	{"655", "" ,"While held but not in use, grants a spinning orbital top that blocks enemy shots and deals 3.5 damage per tick, 10.5 per second, contact damage. #While the use item key is held, Isaac gains +0.5 speed that can exceed the cap and all of his orbital familiars #spin faster, #knock back enemies and Isaac on dealing damage, #and deal 1.5x their normal damage + 6."},
	{"656", "" ,"<There is an issue if you are seeing this. Contact somebody!>"},
	{"657", "" ,"Upon killing an enemy, tears that are identical to Isaac's, but red, are released from them in random directions. #Releases up to 16 tears, one for every tear that hit the enemy."},
	{"658", "" ,"Whenever Isaac takes damage, he summons a micro-Isaac familiar that chases nearby enemies and shoots at them from the cardinal directions.  #They deal 1.4 damage per tear with a tear delay of 8, persisting between rooms and floors."},
	{"659", "" ,"+1.50 Range up. #Increases tear size."},
	{"660", "" ,"At the beginning of each floor, spawns 2 portals that each lead to either to the Boss Room, Treasure Room. or Secret Room. #Past chapter 4 only one will spawn. #They disappear upon leaving the starting room whether they leave or not. #The Boss portal is red, Treasure portal is yellow and Secret Room portal is blue."},
	{"661", "" ,"Spawns a stationary familiar upon killing an enemy in a room, up to a max of 5. #A list of spawnable familiars can be found on the wiki."},
	{"662", "" ,"<There is an issue if you are seeing this. Contact somebody!>"},
	{"663", "" ,"Every 6 seconds Isaac turns to stone and sprouts spikes for 1 second. #He is immune to damage and deals 40 contact damage, and can still move and shoot tears. #Does not mitigate damage from blood donation machines or devil beggars."},
	{"664", "" ,"Grants one red heart container and fully heals Isaac. #Item pedestals periodically switch between any food item and the item they would normally contain. #Upon picking up a food item, Isaac gains +3.6 Damage up that fades over 30 seconds and a permanent boost to 2 stats depending on the food item. #A full list of stats gained can be found on the wiki. #The temporary boost does not stack, it resets to +3.6 Damage up."},
	{"665", "" ,"Shows what is in chests and sacks, as well as all fires, before opening or blowing them up. #Includes Mom's chest, but not mega chests. #Does not show the contents of tinted rocks, poops, urns, buckets, mushrooms, skulls, or polyps."},
	{"666", "" ,"<There is an issue if you are seeing this. Contact somebody!>"},
	{"667", "" ,"Spawns Keeper as an extra character alongside Isaac, who is controlled exactly like Esau. #Keeper will have his base stats, heal with coins, 3 coin hearts, and is unable to pick up items. #If Keeper dies, he spawns several blue spiders and Strawman is removed from Isaac's inventory."},
	{"668", "" ,EID.descriptions["en_us"].collectibles[668][3]},
	{"669", "" ,"Fully heals Isaac's red heart containers#Gives Isaac a heart container. #+0.2 Speed up. #+0.5 Damage up. #+0.5 Tears up. #+1.5 Range up. #+0.2 Shot speed up. #+1.0 Luck up.#+6.9% chance to get a Devil/Angel Room#+6.9% chance to find a {{Planetarium}}Planetarium."},
	{"670", "" ,"Upon completing a room, if a room clear reward would spawn, another, different reward spawns next to it. If Isaac takes/opens one, the other disappears."},
	{"671", "" ,"Gives Isaac one of the following stat boosts per half heart healed with red heart pickups: #+0.02 Speed up. #+0.05 Tears up. #+0.10 Damage up. #+0.15 Range up. #+0.02 Shot speed up. #+0.10 Luck up."},
	{"672", "" ,"Devil Deals cost coins; shop items cost health. #Consumables are free but surrounded by spikes and cannot be moved by explosions. #Immunity to spikes does not prevent damage from these spikes."},
	{"673", "" ,"Upon entering a Devil Deal room, a white cross appears above Isaac's head. #If he goes down to the next floor with this icon above his head, he gains a soul heart and +1.0 damage. #Picking up any items or black hearts in the Devil room will cause it to disappear."},
	{"674", "" ,"Upon death, Isaac turns into a ghost that is linked to Isaac's dead body, and can continue fighting with 1/2 of a heart. #10 seconds after this effect occurs, Isaac comes back to life. #He gains flight and spectral tears in ghost form. #After this effect occurs, Spirit Shackles cannot activate again until Isaac picks up a soul heart. #Soul hearts that are used to charge Spirit Shackles will not be added to Isaac's health."},
	{"675", "" ,"Upon being hit, reveals a random room on the floor and unlocks all doors in the room that require keys to open."},
	{"676", "" ,"If Isaac has an empty heart container, another one is added at the start of every floor. #Does nothing for ??? or similar characters. #Empty Bone hearts do not trigger this."},
	{"677", "" ,"If Isaac takes damage while in a room with enemies, time is stopped for 3 seconds and Isaac becomes a ghost and leaves his body behind. #While in ghost form, Isaac has flight and spectral tears and the next hit Isaac takes is negated. #Isaac's tears and speed are greatly increased while time is stopped. #Isaac's ghost re-enters his body after the room is cleared or if he gets hit again."},
	{"678", "" ,EID.descriptions["en_us"].collectibles[678][3]},
	{"679", "" ,"Gives Isaac a familiar that creates a fluctuating black ring after a 1 second charge time that damages enemies that touch it, similar to Maw of the Void. #Deals 3.5 damage per tick up to 15 times per ring."},
	{"680", "" ,"Continuously shooting for 2.5 seconds allows Isaac to fire a short-range laser and corn tears behind himself by releasing the fire button, similar to Brimstone. #Tears deal 6 damage, beam deals Isaac's damage per tick, 15x his damage per second, for 1.33 seconds."},
	{"681", "" ,"Summons a portal familiar that launches itself in the direction Isaac shoots to deal contact damage to enemies. #Consumes all consumables and trinkets in it's path, turning them into blue flies and causing it to become larger and deal more contact damage. #Lil Portal deals contact damage equal to (2x consumables destroyed count + 2), and ticks up to 10 times per second. #When the portal consumes four pickups, it will summon a portal that leads to an unexplored room on the current floor and it's damage bonus will reset."},
	{"682", "" ,"Gives Isaac a Nerve Ending familiar that burrows out of the ground to grab enemies for 4 seconds. #Grabbed enemies take 8 damage per second, 32 total per grab, are slowed, and are unable to move. "},
	{"683", "" ,"Enemies spawn 1-2 floating bones on death, which block enemy shots and damage/repel enemies that touch them. #Contact damage is equal to Isaac's damage."},
	{"684", "" ,"Gives enemies the chance to spawn ghosts when they die, which rapidly chase and deal contact damage to enemies. #Ghosts deal half Isaac's damage per tick, 2x his damage per second, on contact. #After 5 seconds, the ghost explodes, dealing 7 damage to nearby enemies up to 3 times. #Isaac does not take damage from the explosion. #Enemies killed by ghosts are unable to spawn more ghosts, except for those killed by the ghost's final explosion."},
	{"685", "" ,"Spawns a wisp that orbits Isaac, blocking shots, firing tears and dealing contact damage, similar to the ones from Book of Virtues. #Can have up to 26 wisps. #The jar spawns an additional wisp per time used, up to 12 per use."},
	{"686", "" ,"Spawns a soul heart on pickup. #Gives Isaac one of the following stat boosts per half heart gained from picking up soul hearts and black hearts. #+0.04 Speed up. #+0.1 Tears up. #+0.2 Damage up. #+0.3 Range up. #+0.04 Shot speed up. #+0.2 Luck up."},
	{"687", "" ,"On use, spawns a random friendly monster that mimics Isaac's movements and attacks, similar to Jacob and Esau."},
	{"688", "" ,"Gives Isaac an extra life. #Upon death, Isaac respawns in the current room with half a heart left, a massive size down, and +0.2 speed."},
	{"689", "" ,"Causes new item pedestals very quickly cycle between 5 random items. #Cycles every 0.2 seconds. #Items such as The Polaroid or Knife Pieces do not cycle."},
	{"690", "" ,"Enemies that touch Isaac will bounce off him and propel in the opposite direction. #If they hit an obstacle or wall while bouncing, they will take 10 damage. #Hitting another enemy deals 10 damage to both enemies. #Additionally grants a chance for projectiles to bounce off Isaac without taking damage. #Deflected shots deal 6-7 damage to enemies they hit, depending on the source."},
	{"691", "" ,"Prevents low-quality items from spawning, greatly increasing the quality of items received from all items pools. #Items with a 'quality' of 0-1 are automatically rerolled. #Items with a 'quality' of 2 have a 33% chance to be automatically rerolled."},
	{"692", "" ,"Spawns a special set of spikes in the Devil room. #Taking damage from the spikes has a chance to grant one of these rewards: #35% chance - 6 pennies. #15% chance - 0.5 Damage up. #5% chance - 2 black hearts. #2% chance - random item. #1% chance - Transform into Leviathan."},
	{"693", "" ,"Gives nine orbital flies when picked up. #Each time one blocks a projectile, it turns into a blue fly. #Each time a room is cleared it spawns another orbital fly, up to a max of 9."},
	{"694", "" ,"Grants +0.25 damage for every broken heart Isaac has. #Immediately grants 3 broken hearts. #Every otherwise fatal hit will instead add 2 more, replacing other types of hearts if necessary, and deal 40 damage to all enemies in the room. #Once Isaac has no non-broken hearts left, he dies. Extra lives will apply at this point."},
	{"695", "" ,"When Isaac takes damage, he gains speed and tears for the rest of the floor. #The speed Isaac gains each hit is 4x the number of hits Isaac has already taken this floor + 0.07. #Isaac gains +0.25 tears on the first hit and +0.1 on all subsequent hits. #Both effects stack up to six times, for a total of +1 speed and +3 tears."},
	{"696", "" ,"Isaac receives an angelic halo around him which grows in size up to 10 times when he takes damage, resetting when he leaves the floor. #Enemies who stay in the halo for about a second are struck down by a beam of light, which creates 4 light beams in the cardinal directions. #The initial beam does 3.5 damage per tick up to 15 times, and the others deal 1.75 damage per tick up to 15 times."},
	{"697", "" ,"Spawns a familiar that follows Isaac. #Upon entering a boss room, it becomes a clone of the boss. #Isaac must defeat both bosses. #Both bosses have slower attack patterns and 75% HP. #Upon death, the clone boss will drop an item from the boss item pool, even if the fight isn't over. #Returns on the next floor. #Does not happen on end-chapter fights like Mom, Mom's Heart, etc."},
	{"698", "" ,"Spawns two demon familiars that stand by Isaac's side, and fire tears that use Isaac's tears, range, shot speed, and tear effects, and deal 0.375x Isaac's damage."},
	{"699", "" ,"Every four cleared rooms, Isaac fires a large Brimstone laser for 3.33 seconds."},
	{"700", "" ,"When using a pill or card, Echo Chamber activates one of every pill type and card type that has been previously used since obtaining Echo Chamber."},
	{"701", "" ,"Spawns an Old Chest at the start of each floor after pickup."},
	{"702", "" ,"Upon taking damage, spawns a red wisp that fires tears that deal 3 damage and deals 1x Isaac's damage in contact damage per second, but does not block projectiles. #These last the entire floor, and are capped at 6."},
	{"703", "" ,"When used, swaps between the current character and Esau Jr., who has three black hearts, +2.0 damage, and flight. #Esau Jr. keeps his own separate health and items, and items are not shared between the two characters. #If either character dies, they both die, regardless of whether the other character has any remaining health."},
	{"704", "" ,"On use Isaac gains +0.4 Speed up, +3.0 Damage up and increased tears for 5 seconds. #He becomes restricted to using a jaw bone, similar to The Forgotten's club. #The jaw bone deals 3x Isaac's damage when swung and 3x Isaac's damage per second when thrown. #While berserking his tear delay is multiplied by two then he gains +2.0 tears per second; this is usually a tears upgrade unless he has a lot of tears upgrades previously. #As The Forgotten, he does not gain the delay modifier as he already has it. #Killing an enemy increases this duration by 1 second. #Isaac cannot die while berserking; he will die when the timer ends. #Charged by dealing damage to enemies, not clearing rooms; takes 120 damage for a full charge."},
	{"705", "" ,"When used, Isaac gains +1.0 speed and can walk through enemies/bullets for 1 second or until he shoots. #If Isaac walks through an enemy or bullet during this time, it freezes until the effect ends, then takes damage equal to 3x Isaac's damage. #At the end of the effect, an area of effect blast is created, dealing more damage the more enemies or bullets were pierced during the effect. #For every enemy/bullet Isaac walked through, he will gain a temporary +1 damage bonus, which wears off at a rate of -0.25 damage every half second."},
	{"706", "" ,"When used, destroys all items in the room and gives Isaac a unique red locust familiar for each item destroyed. #These locusts loosely follow Isaac around and charge in the direction Isaac is firing until they hit an enemy or a wall, dealing Isaac's damage per tick (3 times per second)."},
	{"707", "" ,"Gives Isaac one red heart container and heals him for one extra heart."},
	{"708", "" ,"+1.0 Damage up. #Prevents Isaac from firing tears from his left eye, similar to Cain."},
	{"709", "" ,"Causes Isaac to dash a short distance. #If Isaac runs into an enemy while dashing, he picks them up and a crosshair spawns under him that can be controlled with tear controls. #After one second, Isaac slams down with the enemy, dealing 50 damage to them and any enemies he lands on and creates circular rock waves that damage nearby enemies and destroy obstacles. "},
	{"710", "" ,EID.descriptions["en_us"].collectibles[710][3]},
	{"711", "" ,EID.descriptions["en_us"].collectibles[711][3]},
	{"712", "" ,"Upon use, grants a random passive item from the current room's item pool. #More than one of these items can be held at once, and you can have more than one of the same item. #A small ghost appears around Isaac for each item he gains, which disappears upon taking enough damage. #Isaac loses the effect of the passive when the item wisp disappears."},
	{"713", "" ,EID.descriptions["en_us"].collectibles[713][3]},
	{"714", "" ,EID.descriptions["en_us"].collectibles[714][3]},
	{"715", "" ,"Preserves one poop bomb inside and can be used later."},
	{"716", "" ,"Gives Isaac either: #+0.05 Damage up, #+0.03 Speed up, #or +0.25 Range up each time he buys items or pickups from the shop. #He gains one stat upgrade when he makes a purchase, plus one for every 5 cents spent on the item or pickup. #Spawns 3 coins and a key on pickup."},
	{"717", "" ,"If Isaac is in a room with enemies, Rocks and props will occasionally spawn blue spiders. #Causes all rocks and props to spawn 0-2 blue spiders when destroyed."},
	{"718", "" ,"<There is an issue if you are seeing this. Contact somebody!>"},
	{"719", "" ,"Spawns a random pickup/item, which will be on sale for its normal shop price. #Will always be a shop item. #Will be surrounded by spikes if used in a Devil room."},
	{"720", "" ,"If the item is not fully charged, it spawns a pickup based on how many charges it had. #If it is fully charged, it has one of many effects. #A full list of pickups and effects can be found on the wiki, as they're too long to list here."},
	{"721", "" ,"When picked up, all future items become 'Glitched', causing them to become random combinations of 2-3 effects based on other items. #Glitched items can be passive or active, and are completely randomly generated. #Random effects combine effects that exist on other items, and assign them to a random event (e.g. on enemy death, on room clear, on damage taken etc.)."},
	{"722", "" ,"Chains down the nearest enemy, completely preventing them from acting for 5 seconds. #Chained enemies can be released manually by reactivating the item again. #As Tainted Jacob, Dark Esau will always become the chained target."},
	{"723", "" ,"Rerolls all pedestal items in a room by subtracting their internal ID number by one until a valid item is rolled. This effect occurs per item and is independent of any other items in the room. #Unlockable items will be skipped if they are not unlocked. #Hidden items (Damocles and items specific to Tainted characters, generally) will always be skipped. #Certain items are very good to spin down, for example Blood Bag becomes Brimstone and Toothpicks becomes Sacred Heart."},
	{"724", "" ,"When Isaac gets hit by an enemy, a half or full red heart is launched out of him, which despawns after 1.5 seconds."},
	{"725", "" ,"When Isaac deals damage to an enemy, he has a chance to do one of a few things: #Hold up one of a few types of poop, #Fart, dealing 5 damage and poisoning nearby enemies, as well as spawning a toxic cloud. #Create a trail of brown creep that gives +1.0 Damage up, +1.3 Tears up, and other effects. #Drop 5 live bombs, similar to the Explosive Diarrhea pill. #Further information can be found on the wiki, there are a few big lists."},
	{"726", "" ,"Double-tapping a fire button causes Isaac to sneeze blood, dealing damage to enemies in front of him. #The sneeze deals damage equal to 1.5x Isaac's damage and pushes enemies back. #If the enemy is pushed into a wall/obstacle, they take 10 damage and deal 10 damage to enemies they collide with. #1 second cooldown."},
	{"727", "" ,"Gives Isaac 5 bombs. #Isaac's bombs create ghosts when they explode, which rapidly chase and deal 2x Isaac's damage per second to enemies. #After 10 seconds, the ghost explodes, dealing 7 damage to nearby enemies up to 3 times. Isaac does not take damage from the explosion. "},
	{"728", "" ,"Spawns a demon familiar that's attached to Isaac and moves and fires in the direction Isaac shoots, using Isaac's damage, tears, range, shotspeed, and special tear effects. #Deals 0.75x Isaac's damage, of 1.0x if used by Lillith."},
	{"729", "" ,"Throws Isaac's head while allowing to shoot from the spot it lands, as well as dealing contact damage to nearby enemies. #Meanwhile, Isaac's body can no longer shoot tears. #The head can return by picking it up with the body, or by using the item again without requiring charges. #Both the throwing and retaking of the head can deal damages to enemies passing through."},
	--Glass Eye, Stye, Mom's Ring go here
}

EID:updateDescriptionsViaTable(repCollectibles, EID.descriptions[languageCode].collectibles)

---------- Trinkets ----------

local repTrinkets={
	{"1", "", "Drops 1 penny, nickel or dime upon taking damage. #Spawns 0-1 coins as The Keeper."},
	{"2", "", "Increases drop rate of pickups from poop to 50%."},
	{"3", "", "Immediately gives one charge towards an item upon use. #Has no effect on items with only one bar of charge or those with automatic recharges. #Stacks with the 9 Volt, but does not work with The Battery. #Recharging an item by taking damage with the Habit will cause this trinket not to activate."},
	{"4", "", "Upon using an active item, teleports the player to a random room which can appear on the map."},
	{"5", "", "2x chance for champion enemies to spawn."},
	{"6", "", "Pulls coins towards the player."},
	{"7", "", "Increases the chance to get an Angel room from 50% base chance to 75%. #Increases chance to find The Bible in The Shop to 13% and in a Library to 45%."},
	{"8", "", "Luck dependent chance to activate The Gamekid effect upon taking damage. #Chance goes up to 100% at 38 or higher luck."},
	{"9", "", "Causes tears to pulsate in size as they travel, changing the hitbox of the tear."},
	{"10", "", "Tears move in waves. #+0.4 Tears up. #Grants spectral tears while held."},
	{"11", "", "Tears move in a high-speed spiral pattern. #Slightly increases the player's effective range as a result. #+0.4 Tears up. #Grants spectral tears."},
	{"12", "", "Tears gain an oblong appearance. #Increases knockback."},
	{"13", "", "While holding the trinket, all Shop items cost 0 cents. #Trinket disappears after purchasing one thing from the shop. #Does nothing in Devil Deals or the Black Market. #Purchasing a trinket while holding Store Credit will not consume Store Credit. #Does not activate multiple times if smelted using the trinket Smelter or a Gulp pill."},
	{"14", "", "Prevents damage from creep and floor spikes. #Does not prevent damage from curse room doors or Greed/Greedier Mode's stop button. #Does not prevent the use of Sacrifice Rooms. #Does not protect from Mama Gurdy's spike attack."},
	{"15", "", "Rocks and their variants have a 33% chance to drop 1 penny when destroyed."},
	{"16", "", "Mom's foot drops down every 60 seconds, dealing 300 damage. #Can blast open doors, but it still hurts the player for a full heart upon being hit. #Like the High Priestess card, this will stomp the player if the player is in a room with no enemies when the timer runs out."},
	{"17", "", "Increases the chance of black hearts appearing by 1%."},
	{"18", "", "Increases the chance of eternal hearts appearing by 3%."},
	{"19", "", "Allows the player to unlock all chests without using keys."},
	{"20", "", "If the player has half a heart or less after taking damage, this trinket drops 1 black heart. #This can happen up to 3 times, after which the trinket disappears. #The trinket will display the number of activations left with the number of fingers sticking up."},
	{"21", "", "Upon taking damage, has a small chance to activate the A Missing Page effect. #Upon taking damage at one half red heart or less, there is a moderately common chance to trigger the effects of The Polaroid or The Negative. #Small chance for the player to be able to go to The Chest or The Dark Room without the appropriate Polaroid/Negative. #Small chance to revive the player as The Lost upon death, and to display a puzzle piece on the death screen in the same way as Missing Poster. #Does not open the strange door."},
	{"22", "", "All red, soul and eternal heart drops turn into black hearts, if they can. #The drop chances for every kind of heart is reduced. #A full list of drops that can turn into black hearts, as well as further mechanics for this item, can be found on the wiki page."},
	{"23", "", "Dying in a sacrifice room while holding this trinket unlocks a The Lost. #If they has been unlocked and the player dies while holding it, it will be consumed and they will be revived as the Lost without the normal Holy Mantle starting item. #Tainted Lost will not become the normal Lost upon dying."},
	{"24", "", "Upon picking up a coin, the player farts, knocking back nearby enemies. #Increases the chances of coins dropping from poop by 20%."},
	{"25", "", "The player has a chance to fart or poop every 30 seconds. #Taking damage can also trigger this."},
	{"26", "", "Tears move in a shifting left to right and back to form a pattern of right angles. #Grants +1.5 range up, but lowers effective range as the tear travels further due to the movement pattern. #+0.4 Tears up. #Grants spectral tears."},
	{"27", "", "+0.5 Shot speed up."},
	{"28", "", "Grants a 22.22% chance to be revived as ??? upon death. #Can happen multiple times in a run."},
	{"29", "", "Spawns 1 blue fly when the player takes damage."},
	{"30", "", "Grants a luck dependent 10% chance to shoot a poison tear. #Chance increases to 100% at 18 or higher luck."},
	{"31", "", "Grants a luck dependent 10% chance to shoot a piercing and spectral tear. #Chance increases to 100% at 18 or higher luck."},
	{"32", "", "Grants a 25% chance of triggering one of the following effects for the current room upon entering it: #Mini Mush, #Fat Odd Mushroom, #Skinny Odd Mushroom, #God's Flesh, #Blue Cap, #Magic Mushroom."},
	{"33", "", "When damaged to half a red heart and no soul hearts, the player gains a Little Steven familiar for the remainder of the room. #When Isaac takes damage, there is a high chance to spawn a Gemini familiar for the current room. #Can occur more than once."},
	{"34", "", "Increases the chance of a red heart dropping after clearing a room or from a chest."},
	{"35", "", "+2 Damage up that is applied after normal calculations but before damage multipliers; thus it always gives 2 damage unless the player has a damage multiplier, such as Skinny Odd Mushroom or Soy Milk."},
	{"36", "", "Increases the chances of finding keys and golden chests."},
	{"37", "", "+0.15 Speed up."},
	{"38", "", "Grants a secondary chance of any non-specific heart drop becoming a soul heart."},
	{"39", "", "Tear delay directly reduced by 2. #This can reduce the tear delay past the normal cap."},
	{"40", "", "Chance to get +1.8 damage up upon taking damage. #Stacks with Bloody Lust and the Razor."},
	{"41", "", "Increases the chance of bombs dropping after clearing a room or when opening a chest. #Will replace the Tick if the player has it, though it will not remove it if the player has Mom's Purse or Belly Button."},
	{"42", "", "+1 Luck up. #Grants a 1/3rd chance to drop an additional pickup when opening a golden chest, destroying a machine or blowing up a Tinted rock."},
	{"43", "", "If the player has less than one full red heart after taking damage, he is immediately teleported to a random room."},
	{"44", "", "Improves the chance of pills dropping after clearing a room and opening a chest. #Causes tinted rocks to be able to drop pills."},
	{"45", "", "Improves the chance of tarot cards or playing cards dropping after clearing a room, opening a chest or playing a fortune teller machine."},
	{"46", "", "Grants a 10% chance to be healed for a half red heart upon clearing a room. #Fills a full coin heart for Keeper."},
	{"47", "", "<If you see this, there's a problem.>"},
	{"48", "", "Upon getting hit, the player has a 5% chance to deal 80 damage to all enemies in the room. #Chance goes up to about 50% at very high luck, between 50-60. #Necronomicon-like effects, such as Black Hearts, The Negative, and Dry Baby deal 2x damage."},
	{"49", "", "Grants a 25% chance to drop a half red heart when collecting a coin."},
	{"50", "", "Grants a 25% chance to drop a bomb pickup when collecting a coin."},
	{"51", "", "Grants a 25% chance to drop a key pickup when collecting a coin."},
	{"52", "", "Grants a 50% chance to gain an extra coin when picking up another coin. #On Keeper, this can cause you to heal from picking up a coin and still gain a penny. #Only the brother holding the Penny can trigger the effect when playing Jacob and Esau."},
	{"53", "", "#Removes 15% of an enemy's health if that enemy has more than 60 HP. #Heals one red heart upon entering an uncleared boss room. #Cannot be dropped or replaced with another trinket unless the player picks up Match Stick and does not have Mom's Purse or Belly Button. #Can be consumed by Smelter and Gulp! pills."},
	{"54", "", "Spawns a familiar that follows the player, firing piercing tears that deal 3.5 damage. #This trinket can be dropped on the ground and picked up again to move familiars obtained after it up the familiar chain."},
	{"55", "", "Grants 1 eternal heart at the start of every floor."},
	{"56", "", "Reduces the cost of all 2 heart Devil deals to 1 heart. #Does not reduce the cost of Soul heart deals, nor will it reduce the cost of a Devil deal if you have seen that Devil deal before obtaining Judas' Tongue."},
	{"57", "", "Familiar that bounces around the room, shooting spectral, homing tears that deal 3.5 damage in the direction the player is shooting. #Does not deal contact damage. #Cannot shoot while flying over obstacles."},
	{"58", "", "Luck dependent chance to increase damage by 0.5 for the current room each time an enemy dies. #This chance starts at 1/15 and increases to 100% at 10 luck or higher. #Can activate up to 10 times per room."},
	{"59", "", "Upon starting a floor, there is a luck dependent chance to get the Compass effect for the duration of a floor. #This chance starts at 25% and increases to 100% at 3+ luck."},
	{"60", "", "5% chance to spawn a Dead Bird familiar which chases enemies, dealing 4 contact damage per second, each time an enemy dies. #Cannot spawn more than one Dead Bird per room, but it will stack with the Dead Bird item."},
	{"61", "", "Replaces all chests with red chests. #Does not include already spawned chests."},
	{"62", "", "Causes crawlspace rocks and tinted rocks to flash white every 10 seconds."},
	{"63", "", "Turns troll bombs into bomb pickups and Mega troll bombs into 1+1 bomb pickups before they explode. #Golden troll bombs turn into Golden bombs. #Giga bombs thrown by enemies in the Ashpit and Ultra War turn into collectible pickups."},
	{"64", "", "Grants a worm trinket effect that changes every 3 seconds of the in-game timer. #This effect cycles through the possible worm trinkets in this order: #Pulse Worm, Ring Worm, Tape Worm, Whip Worm, Wiggle Worm, Fat Worm, Hook Worm, Lazy Worm."},
	{"65", "", "+3 Range. #2x Tear Height. #Increases Azazel's Brimstone range, though not quite by 2x. #Causes Dr. Fetus to shoot bombs very far, very quickly. #Does not affect Lilith's familiars. #Affects normal Incubus'."},
	{"66", "", "-0.5 Shot speed down."},
	{"67", "", "When the player takes damage, there is a 50% chance to activate one of four dice effects: #The D6, #The D8, #The D12, #The D20."},
	{"68", "", "Pickups and enemies are attracted towards the player. #Can pull pickups across pits and rocks, but not through key blocks. #Pulls the doors in the Ultra Greed fight as well. #Does not pull other trinkets. #Causes the Ludovico Technique tear to move towards the player more quickly."},
	{"69", "", "Causes the player to occasionally blend into the background, which briefly confuses all enemies in the room. #The confusion effect is only applied at the start of the camoflauge effect; thus, enemies spawned while the player is camoflauged are not confused. #Can open the door in The Depths II."},
	{"70", "", "Occasionally spawns 1 Blue Spider while in hostile rooms."},
	{"71", "", "Bombs leave green creep when moved or pushed around."},
	{"72", "", "Increases the chance of batteries dropping. #Grants a chance to add 1 extra charge to the player's active item upon completing a room."},
	{"73", "", "Grants a 10% chance for exploding bombs to drop bombs."},
	{"74", "", "Gives rocks a 0.5% chance to reveal a Crawl Space when broken. #Does not depend on the rock's location. #Can affect rocks seen before Stud Finder is obtained. #Shiny Rock, which causes Crawl Space rocks to flash, does nothing with Stud Finder."},
	{"75", "", "Grants a random trinket effect in each room. #Each room is locked to a single trinket effect; leaving and re-entering a room grants the same effect. #In rooms where the Tick effect is given, the player will be unable to swap Error with another trinket. #Store Credit on a shop will not consume Error despite reducing the cost of items. #Removes the limit of black hearts given for the Monkey Paw effect. #The Walnut effect, like Store Credit, will not consume the trinket but will still spawn items."},
	{"76", "", "Chests have a 50/50 chance to either drop extra consumables or pay out with nothing. #Can also cause chests to pay out with flies instead of nothing."},
	{"77", "", "Slightly increases the player's knockback. #Causes Brimstone to push enemies back."},
	{"78", "", "Doubles the time that status effects stay on enemies."},
	{"79", "", "Grants a 25% chance to spawn a copy of a consumable item like a card or pill upon use."},
	{"80", "", "Grants +0.5 damage for each Evil item the player has. #These items include: #Black Candle, Ceremonial Robes, Goat Head, Match Book, Missing Page 2, Safety Pin, and Abaddon."},
	{"81", "", "Makes the invincibility after taking damage last twice as long. #Affects Holy Mantle invincibility time, making it extremely useful for The Lost."},
	{"82", "", "Increases the chance for an item room with two items to spawn on future floors by 15%. #On these item rooms, only one of the two items can be taken; the other disappears."},
	{"83", "", "Allows shops to be opened without using keys."},
	{"84", "", "Prevents Greed and Super Greed from appearing in shops and secret rooms. #If Rib of Greed is picked up after a Greed fight in a shop, re-entering the room will turn it into a regular shop with items for sale."},
	{"85", "", "Grants a chance to heal for a full red heart, refund the coin, or spawn a beggar upon donating to the donation machine. #Also increases the chance that donating to the donation machine will increase the player's luck."},
	{"86", "", "Destroying poop spawns 1 blue fly."},
	{"87", "", "The player heals a half red heart each time they use a key. #Half red hearts on the ground become full red hearts. #Opening things with a Golden Key will not heal the player. #On Keeper, it will restore a full health coin."},
	{"88", "", "Prevents active item from spawning, if possible, from all item pools while the trinket is held. #A full list of exceptions can be found on the wiki page. #If multiple copies are held, rerolls items with quality 0."},
	{"89", "", "Causes familiars to stay closer to the player."},
	{"90", "", "Destroying poop causes an explosion. #Red poops do not explode when destroyed."},
	{"91", "", "Grants a chance for regular poop to turn into black poop."},
	{"92", "", "Boosts speed, range, shot speed and damage by about 20% if they are above their base values."},
	{"93", "", "Grants the Skatole effect on some rooms. #When the effect happens, attack, dart and ring flies become black flies, pooters and super pooters do not shoot, and boom flies move more slowly."},
	{"94", "", "Many items and trinkets that generate blue flies, spiders or locusts will generate twice as many. #A full list of interactions can be found on the wiki. #Does double flies from the Guppy transformation."},
	{"95", "", "Grants a chance to fire a black tooth that poisons enemies. #These teeth deal 2x the player's tear damage."},
	{"96", "", "Tears move in a large spiral pattern. #Grants spectral tears. #+1.5 range. #+0.4 tears up. #A luck dependent chance to fire a homing shot. #This chance increases to 100% at 9 or higher luck."},
	{"97", "", "Upon taking damage, the player has a chance to spawn a familiar that follows the player, blocking enemy shots. #This can happen twice. #Upon spawning a familiar, the player gains a passive item representing the familiar, meaning the trinket can be dropped without losing it."},
	{"98", "", "Grants a chance to fire a homing booger which sticks to enemies and damages it once per second, for up to 60 seconds or until the enemy dies. #As this effect is almost identical to the item Sinus Infection, all synergies that apply to it apply to Nose Goblin as well."},
	{"99", "", "Grants a chance to fire tears that bounce of enemies and obstacles."},
	{"100", "", "Grants the following stats when the player is holding a fully charged active item: #+0.25 Speed up. #+0.75 Range up. #+0.2 Tears up. #+0.10 Shot speed up. #+0.5 Damage up. #+1 Luck up. #Items with no charge bar, such as Potato Peeler, count as fully charged for this trinket."},
	{"101", "", "Grants the following stats when the player is holding an active item with no charges: #+0.5 Speed up. #+1.5 Range up. #+0.4 Tears up. #+0.3 Shot speed up. #+1.5 Damage up. #+2 Luck up. #Items with no charge bar, such as Potato Peeler, count as uncharged for this trinket."},
	{"102", "", "Causes two Secret Rooms to spawn upon entering a new floor while holding this trinket."},
	{"103", "", "Turns all pickups into their doubled versions while the player has an equal number of coins, bombs and keys. #Upon picking up a non-doubled pickup that causes the player's pickups to become equal in number, a doubled variant will be spawned. #Doubled pickups do not revert if the player's pickups become unequal. #This also effects Greed and Greedier Mode, doubling the coin pickups. #Keys, bombs, and red hearts in the shop will double and become free."},
	{"104", "", "Grants a small chance to destroy the trinket and spawn a random item using the item pool of the current room upon taking damage."},
	{"105", "", "Grants a small chance to destroy the trinket and spawn Lunch upon taking damage."},
	{"106", "", "Increases the radius of any creep you produce."},
	{"107", "", "The player's red hearts will be depleted before taking soul or black heart damage. #Red hearts lost this way will affect your Devil or Angel deal champions as normal. #Bone hearts will lose the red hearts in them, but not break until the player has one half red heart left."},
	{"108", "", "Grants a chance to be destroyed and spawn various pickups upon taking damage from an explosion. #Can spawn coins, hearts, keys or a random trinket."},
	{"109", "", "Stops orbital familiars from rotating around the player and shooting familiars from moving. #Dropping and picking up the trinket again will snap the familiars back to the place they were in when the trinket was first picked up; only exiting the run and continuing will allow the familiars to be fixed to a new spot. #A list of familiars unaffected by this item can be found on the wiki."},
	{"110", "", "Shops will now appear in The Womb, Utero, and Scarred Womb if the trinket is held while entering the floor."},
	{"111", "", "Item rooms now appear in The Womb, Utero, Scarred Womb, and the Corpse if the trinket is held while entering the floor."},
	{"112", "", "Restock boxes will always spawn in item rooms if the trinket is held while entering the floor. #Does not affect the item rooms in the Blue Womb."},
	{"113", "", "Spawn a Red Locust when entering a hostile room. #The locust deals 2x tear damage upon contact with an enemy, and explodes, dealing 60 damage to nearby enemies. #This explosion takes most bomb effects, but further interactions can be found on the wiki."},
	{"114", "", "Spawn a Green Locust when entering a hostile room. #The locust deals 2x tear damage on contact and poisons the enemy for 2x tear damage over time."},
	{"115", "", "Spawn a Yellow Locust when entering a hostile room. #The locust deals 2x tear damage on contact and slows the enemy."},
	{"116", "", "Spawn a Black Locust when entering a hostile room. #The locust deals 4x tear damage on contact, applied as two 2x damage hits."},
	{"117", "", "Spawn 2-5 White Locusts upon entering a hostile room. #The locusts deal 2x tear damage."},
	{"118", "", "Grants a chance to gain flight for the rest of the room upon killing an enemy."},
	{"119", "", "Heals half a red heart upon traveling to the next floor. #If Isaac is below 50% HP, instead sets his health to half of the maximum."},
	{"120", "", "Fully recharges your active item upon entering a boss room for the first time."},
	{"121", "", "Protects you from the first damage you take for every floor, similar to Holy Mantle. #If the player has both this and Holy Mantle, this will block damage first. #If the effect has not been used on a floor yet, the trinket can be dropped so the effect can be saved for a boss fight."},
	{"122", "", "Using your active item will cause it to drop onto a pedestal. #Does not apply to active items in the pill/card slot. #When the player takes damage, there is a 2% chance one of their passive items will drop in a similar fashion. #Butter will cancel the effects of many active items; a full list can be found on the wiki page."},
	{"123", "", "Causes the Angel bosses to drop items from the Angel Room pool instead of Key Pieces. #The angels spawned during Mega Satan and the Boss Rush do not drop items. #Items are dropped even if the player already has both key pieces."},
	{"124", "", "The last door you used stays open, allowing him to leave even if the room is hostile. #Does nothing in Mom's boss room."},
	{"125", "", "Beams of yellow electricity flow between the player and his familiars, dealing 6 damage to any enemies between them. #Does not effect temporary familiars. #The Forgotten's Soul acts as a familiar with this trinket."},
	{"126", "", "Spawns a blue fly upon picking up a coin."},
	{"127", "", "Grants your familiars homing shots."},
	{"128", "", "Grants a 5% chance to gain a bone heart upon taking damage."},
	{"129", "",  "Adds a chance to fire teeth that deal 3.2x damage, similar to Tough Love. #Increases with Luck."}, 
	{"130", "",  "Adds a chance to fire tears that slow enemies."}, 
	{"131", "",  "Gives a chance to drop a Half Soul Heart when a coin is collected. #The chance is based on the coin's worth."}, 
	{"132", "",  "When Isaac enters a new room, has a 25% chance to give the effect of any syringes for the current room."}, 
	{"133", "",  "Bombs placed by Isaac explode more quickly."}, 
	{"134", "",  "Makes farts (ie. Butter Bean) significantly larger."}, 
	{"135", "",  "Has a chance to inflict burning on enemies upon entering a new room. #Deals Isaac's damage per tick up to 5 times. #Chance increases with luck."}, 
	{"136", "",  "Doors that require a key can be opened with explosions. #Also works on key blocks, golden chests, and the door in Depths II."}, 
	{"137", "",  "Spawns pickups left on the previous floor in the starting room of the current floor. #Maximum of 4 pickups."}, 
	{"138", "",  "When picked up, using an active item rerolls it into a completely different active item."}, 
	{"139", "",  "Luck-based tear effects have a higher chance of occurring. #This is equivalent to having +3 luck, but it does not confer other luck based benefits."}, 
	{"140", "",  "Picking up Red Hearts can convert them into 1-4 Blue Spiders. #Isaac can pick up red hearts at full hp, in which case this effect always works. #If spiders are spawned, no health is gained."}, 
	{"141", "",  "Improves the rate of fire of Isaac's familiars."}, 
	{"142", "",  "At the beginning of each floor, spawn 4 wisps that orbit Isaac and fires tears alongside him. The wisps are the same as the wisps that spawn with the Book of Virtues while you do not have another active item combined with it. #Getting 2 rewards from beggars will also grant a wisp. #Will not bring the total wisps above 8."}, 
	{"143", "",  "Active items don't charge when clearing rooms.#Adds a 20% chance to spawn a Lil' Battery when clearing a room, independent of the room's original drop.#33% chance at 5 Luck."}, 
	{"144", "",  "Tears snap 90 degrees to target enemies that they may have missed."}, 
	{"145", "",  "Gives +10 luck. Disappears upon taking damage."}, 
	{"146", "",  "Treasure Rooms are replaced with Red Treasure Rooms that contain items from the Devil Room pool that can be bought for the usual number of Heart containers."}, 
	{"147", "",  "Picking up coins has a chance to add one charge to Isaac's currently held Active Item. #Chance is equal to 1/6th the value of the coin, and cannot activate more than once per coin."}, 
	{"148", "",  "Familiars that normally follow Isaac orbit around him instead."}, 
	{"149", "",  "Activates Isaac's active item just before damage would be taken. #Single use items are consumed."}, 
	{"150", "",  "Entering a room that requires a key brings Isaac to a room resembling the Blue Womb, which acts as an in-between of the two rooms. #These rooms contain assortments of Blue Gapers, Blue Boils, and/or Blue Conjoined Fatties, and are always long rooms (either normal or slim). #They have a chance to give a reward when cleared, like normal rooms."}, 
	{"151", "",  "Makes all spikes contract, preventing them from dealing damage. #Affects spiked rocks, mimic and spiked chests, curse rooms and so on."}, 
	{"152", "",  "Increases the chance for a Planetarium to spawn. #Keeps the chance to spawn them after entering the first one. #Makes it possible to spawn a planetarium in chapter 4."}, 
	{"153", "",  "25% chance to grant the effects of a random Mom item each room."}, 
	{"154", "",  "Has a 50% chance to give Isaac a Dice item as a consumable when he enters a new room. The Dice disappears when he leaves the room. #Also grants Isaac the ability to hold two consumable items for that room, so Isaac gets a Dice even if he is already holding a consumable item."}, 
	{"155", "",  "Causes a Treasure Room and Shop to generate in Cathedral."}, 
	{"156", "",  "Grants 1 heart container while held. #Will be filled the first time the trinket is picked up. #Can exceed the coin heart limit as Keeper."}, 
	{"157", "",  "Every 15 shots, Isaac will shoot an Ipecac + My Reflection tear with a very high range value."}, 
	{"158", "",  "Upon taking damage, Isaac drops 2 of his coins, keys or bombs.#These pickups are subjected to standard drop rules which will usually result in a net positive.#E.g. Isaac can lose 2 coins from is inventory but get a nickel or a dime."}, 
	{"159", "",  "Replaces all new chests, except Mega Chests, with Locked Chests.#Gain +1 key the first time you pick it up."}, 
	{"160", "",  "Spawns 1 Grab Bag upon traveling to the next floor."}, 
	{"161", "",  "Causes a Treasure Room and Shop to generate in Sheol."}, 
	{"162", "",  "Gives Isaac a 50% chance to turn into Azazel when clearing a room. Isaac keeps his hearts, items and stats, but changes his tears to be a short Brimstone and gaining the ability to fly. #Lasts until clearing and leaving another room."}, 
	{"163", "",  "Spawns 1 friendly Dip upon clearing a room. #All enemy Dips turn into friendly Dips, similar to Dirty Mind."}, 
	{"164", "",  "Places 1 extra bomb for free for each bomb placed."}, 
	{"165", "",  "On Womb and beyond, replaces all pickup spawns with either a bomb, heart, pill, card, trinket or battery. #If it's a coin it can be a random pickup. #Full list of probabilities can be found on the wiki."}, 
	{"166", "",  "Has a 50% chance to grant the effect of a random Passive Item when entering a room."}, 
	{"167", "",  "After clearing a room, adds a 25% chance to spawn a friendly Bony."}, 
	{"168", "",  "Grants 1 bone heart container upon entering a new floor. #Will replace the rightmost soul heart if Isaac has 12 heart containers."}, 
	{"169", "",  "While held, acts as 1 of the 3 items needed for the Guppy transformation. #Effect is lost if the trinket is dropped."}, 
	{"170", "",  "Whenever Isaac clears a room, has a 33% chance to unlock a neighboring Red Room. #Lower chance to occur inside a Red Room. #Chance increases with luck."}, 
	{"171", "",  "Devil Deals cost money instead of health. #1 heart translates to 15 cents of cost."}, 
	{"172", "",  "Teleports to a random room upon picking up a penny. #Can teleport to the secret rooms."}, 
	{"173", "",  "While held, this trinket will be sacrificed instead of Hearts for the first Devil Deal (or other similar max health trade) taken."}, 
	{"174", "",  "Increases the chance of earning a Devil Room by 10%.#Prevents Krampus from appearing in Devil Rooms.#Devil Rooms will be special variants with more deals, Black Hearts and enemies."}, 
	{"175", "",  "Unlocks the passage to the Blue Womb, regardless of run duration. #Unlocks Pandora's Box, giving it a new effect. #The normal effect of Pandora's Box for that level is ignored, and instead 6 items from random pools are spawned. #This consumes the trinket as well as Pandora's Box."}, 
	{"176", "",  "Spawns 1 blood clot familiar on the ground next to Isaac. This familiar moves and shoots through the same inputs as Isaac, effectively acting as a second source of tears. #Deals 0.35x Isaac's damage, but otherwise mimics all tear properties. #Dies after being hit 3 times, and respawns in the next room."}, 
	{"177", "",  "Spawns a chest after completing a normal Challenge Room. #Spawns an item after completing a boss Challenge Room."}, 
	{"178", "",  "50% chance for Isaac to explode when he takes damage, similar to Kamikaze!. #Deals 185 damage and uses Isaac's bomb synergies."}, 
	{"179", "",  "Instead of trailing behind Isaac, familiars are directly controlled by the same inputs as Isaac's."}, 
	{"180", "",  "Summons a familiar that follows Isaac's exact movements, akin to Jacob and Esau, and shoots spectral tears. #Deals 0.4x Isaac's damage and gives Isaac a 0.8x damage multiplier while it's alive. #When Isaac places a bomb, the familiar will as well. #Can press buttons. #Dies after taking any damage and respawns on the next floor."}, 
	{"181", "",  "Upon use of active item, triggers the use of another random active item that has 1 or 2 max charges."}, 
	{"182", "",  "Upon entering an Angel Room, spawns 5 wisp orbitals. #Giving money to beggars has a 25% chance to create a wisp orbital."}, 
	{"183", "",  "Adds a 50% chance to duplicate one of Isaac's familiars when entering a new room. #If Isaac has no familiars, instead spawns Brother Bobby or Sister Maggy."}, 
	{"184", "",  "Shops now sell Familiars. #Familiars on sale will always be sold for 10 cents instead of the usual price of 15."}, 
	{"185", "",  "Has a 1 in 6 chance to spawn yellow locusts, green locusts, black locusts, red locusts, or white locusts when killing an enemy."}, 
	{"186", "",  "Spawns 1 Abyss locust familiar which will fly forward while Isaac shoots."}, 
	{"187", "",  "50% chance of adding an extra blind item in item rooms. #Instead reveals the extra items on the alt path."}, 
	{"188", "",  "Upon entering a room, there is a 20% chance that enemies will be petrified. #Enemies that are killed while petrified by Ice Cube are also frozen. #Lasts for 4 seconds. #Increases with luck."}, 
	{"189", "",  "Shields Isaac for 1 second after killing an enemy. #Adds 1 second to the shield timer if Isaac is still shielded after killing an enemy."}, 
}

EID:updateDescriptionsViaTable(repTrinkets, EID.descriptions[languageCode].trinkets)

---------- Cards ----------

local repCards={
	{"1", "", "Teleports you back to the starting room of a floor."},
	{"2", "", "Grants homing tears and +3.0 range for the current room."},
	{"3", "", "Calls down Mom's foot to stomp on the enemy with the most health in the current room, dealing 300 damage. #If used in an empty room or during the fight with Mom, it will stomp on the player instead."},
	{"4", "", "Grants the Whore of Babylon effect for the current room, increasing damage by 2.35 and speed by 0.3. #On Eve, it also increases her damage multiplier from 0.75 to 1.0."},
	{"5", "", "Teleports you into the boss room of a floor."},
	{"6", "", "Spawns 2 soul hearts."},
	{"7", "", "Spawns 2 full red hearts. If used in a super secret room that contains black or eternal hearts, it will spawn those types of hearts instead."},
	{"8", "", "Grants the effect of My Little Unicorn, giving you invulnerability and the ability to deal contact damage, but removing your ability to shoot tears, for 6 seconds."},
	{"9", "", "Spawns a bomb, a key, a coin, and a heart."},
	{"10", "", "Teleports you to the shop. If no shop exists on the floor, it acts as a random teleport."},
	{"11", "", "Spawns a slot machine or fortune teller."},
	{"12", "", "+1 Health up.#+0.3 Damage up.#+0.3 Speed up.#for current room"},
	{"13", "", "Grants flight for the current room."},
	{"14", "", "Deals 40 damage to all enemies in the room."},
	{"15", "", "Spawns a Blood Donation Machine. #In Greed mode, it spawns a devil beggar."},
	{"16", "", "Grants the Book of Belial effect for the current room, increasing damage by +2.95 and giving a 1.5x damage multiplier if the player also has Blood of the Martyr. #The damage multiplier does not stack with the multiplier from Cricket's Head or Magic Mushroom."},
	{"17", "", "Spawns 6 troll bombs randomly around the room."},
	{"18", "", "Teleports you to the item room. If no item room exists on the floor, it acts as a random teleport. #On a Curse of the Labyrinth floor with two item rooms, it randomly chooses one."},
	{"19", "", "Teleports you to the secret room. #Also opens one random wall in the secret room, so you can leave even if you have no bombs."},
	{"20", "", "Deals 100 damage to all enemies in the current room, restores all your red hearts and reveals the entire floor map excluding the super secret room. #Removes Curse of Darkness for the current floor."},
	{"21", "", "Spawns a beggar. #Can spawn a devil beggar, a key master or a bomb bum instead of a regular beggar."},
	{"22", "", "Reveals the entire floor map excluding the super secret room. #Has no effect if the current floor has Curse of the Lost or you've used an Amnesia pill."},
	{"23", "", "Doubles the number of bombs you have. If you have none, gives you 2 bombs instead."},
	{"24", "", "Doubles the number of coins you have. If you have none, gives you 2 coins instead."},
	{"25", "", "Doubles the number of keys you have. If you have none, gives you 2 keys instead."},
	{"26", "", "Doubles the player's current number of red hearts without adding new heart containers. #Does not affect eternal, soul or black hearts."},
	{"27", "", "Turns all pickups, chests and non-boss enemies in the room into bombs."},
	{"28", "", "Turns all pickups, chests and non-boss enemies in the room into coins."},
	{"29", "", "Turns all pickups, chests and non-boss enemies in the room into keys."},
	{"30", "", "Turns all pickups, chests and non-boss enemies in the room into random heart pickups.."},
	{"31", "", "Teleports the player to the Devil or Angel room. #This grants different contents than if you had gotten the deal after the boss fight."},
	{"32", "", "Destroy all breakable objects in the room. #Affects key blocks."},
	{"33", "", "Duplicate all pickups and chests in the room, including shop pickups. #Cloned shop pickups can be taken for free. #Cloned chests will contain exactly the same type of items as the original. #Cannot clone other Jera runes or trinkets."},
	{"34", "", "Spawns a trapdoor to the next floor. #Has a roughly 8-10% chance to spawn a Crawl Space instead."},
	{"35", "", "Grants 1 soul heart and will remove any curse that is not Curse of the Labyrinth from the current floor."},
	{"36", "", "Reveals the whole map, including both secret rooms, for the current floor."},
	{"37", "", "Reroll all pedestal items in the current room."},
	{"38", "", "Summons 3 blue spiders and 3 blue flies."},
	{"39", "", "Grants a shield which blocks all damage for 20 seconds."},
	{"40", "", "Grants the effect of a random rune on use. #Has a 25% chance to spawn another Blank Rune."},
	{"41", "", "Deals 40 damage to all enemies in the current room.#Consumes all pickups in the room and turns them into blue flies and spiders. #Consumes all pedestal items in the room and turns them into random stat upgrades, presumably similar to upgrades the Void item gives."},
	{"42", "", "Upon use, the player throws the card in the last direction they moved. #The thrown card will kill anything in it's path except Delirium, and can open doors as if a bomb exploded them. #Will not open locked doors. #Can extinguish fires and break rocks. #Will instantly end most multiphase boss fights - ie. Satan or The Lamb - but will only skip one phase of Mega Satan and Ultra Greed. #Will only kill one phase of Hush unless you throw it from the bottom side."},
	{"43", "", "Removes the cost of items in either the Shop, the Devil room or the Black Market. #Taking Devil room items this way does not prevent Angel rooms from appearing. #Works with Blank Card. #Items taken this way do not restock if the player has Restock; however, Restock Boxes will spawn new items."},
	{"44", "", "Displays cryptic statements or game seeds on use. #The statements are often hints to do with bosses, bonus areas and so on."},
	{"45", "", "Fills the whole room with poop. #This is not instant, and leaving the room before it finishes will cause it to stop and not re-start. #Poop will not fill tiles with obstacles, even if they've already been destroyed."},
	{"46", "", "On use, instantly kills the player and spawns 10 random consumables, chests, or items. #The spawned items will be drawn from the pool of the room that the card was used."},
	{"47", "", "Open all doors in the current room, including the golden door in The Chest/Dark Room. #Works similarly to Dad's Key, and will not open the door to the Blue Womb."},
	{"48", "", "Activates your spacebar item."},
	{"49", "", "Rerolls pedestals and pickups in current room."},
	{"50", "", "Spawns two of Mom's hands that fall down onto two random enemies in the room, killing them. #Bosses are pinned to the ground for a while, unable to do anything. #Only spawns one hand if there's one enemy in the room. #When used on Hush, damage resistance is briefly disabled. #Does nothing if there are no enemies in the room."},
	{"51", "", "Grants the Holy Mantle effect for one room, negating the next damage you take.#25% chance to spawn another Holy card"},
	{"52", "", "Grants +7 damage up, +30 range up, and increases the player's size for the current room. #Also allows the player to walk over obstacles to destroy them. #Does not stack if used multiple times."},
	{"53", "", "Spawns 3 random cards when used. #Can spawn special 'cards' like the Dice Shard, but not runes."},
	{"54", "", "For the current room, enemies are slowed, the player gains +0.5 speed and loses -1.0 shot speed. #Does not stack if used multiple times."},
	{"55", "", "Activates a random, weak rune effect. #Algiz grants a 3 second shield. #Ansuz reveals the map up to 3 rooms way. #Berkano gives 1 blue fly and spider. #Dagaz gives half a soul heart. #Ehwaz makes a trapdoor. #Hagalaz destroys some rocks. #Jera duplicates one pickup. #Perthro rerolls one item."},
	{"56", "", "Drops all hearts and pickups on the floor, leaving Isaac at half a heart. May spawn pickups as items, such as A Quarter and Boom!"},
	{"57", "", "Grants a repelling blue aura for one minute, like The Soul but stronger and with a wider area of effect."},
	{"58", "", "Mom's leg starts stomping repeatedly for one minute, similar to holding Broken Shovel."},
	{"59", "", "Grants 2 temporary red heart containers and +1.35 tears for one minute, along with Magdalene's hairstyle. #Does not stack."},
	{"60", "", "Teleports Isaac into an extra Boss Room. #Does drop a reward, but the room has no trapdoor and can be returned to only with another card."},
	{"61", "", "Spawns 2 bone hearts."},
	{"62", "", "Spawns a random item from the current room's pool. #Turns 1 red heart container or 2 soul hearts into a broken heart. #Can be fatal."},
	{"63", "", "Isaac becomes an invincible, immobile statue with extreme fire rate for 10 seconds."},
	{"64", "", "Spawns 2-4 golden chests."},
	{"65", "", "\"Sells\" items and pickups in the room for their standard shop price, spawning a matching amount of coins. #Does not affect grab bags. #If there is nothing to sell, spawns a penny."},
	{"66", "", "Invokes a random dice room effect."},
	{"67", "", "All enemies in the room become slow and take double damage."},
	{"68", "", "Isaac turns into Keeper visually for 30 seconds, gaining triple shot, no damage bonus and -0.1 speed. #Killed enemies drop random coins."},
	{"69", "", "Invokes a Book of the Dead effect."},
	{"70", "", "Forces Isaac to eat 5 random pills in quick succession."},
	{"71", "", "Invokes The Bible and grants a Seraphim familiar and flight for 30 seconds."},
	{"72", "", "Spawns 6 clusters of random rocks and other obstacles. #The pathways between exists cannot be blocked."},
	{"73", "", "Removes Isaac's oldest passive item and spawns 2 random items from the current room's pool."},
	{"74", "", "Teleports the player to the Ultra secret Room. #The pathway back to normal rooms will be made of red rooms."},
	{"75", "", "Gain Spirit of the Night and +1.5 damage for the current level. #Turns Isaac's red hearts into bone hearts that revert once the effect ends. #Also causes a Curse of Darkness that cannot be dispelled."},
	{"76", "", "Spawns a Restock Machine."},
	{"77", "", "Spawns a trap door to a crawl space."},
	{"78", "", "Creates a room adjacent to a viable wall, like the Red Key."},
	{"79", "", "Spawns 1-12 full red hearts."},
	{"80", "", "Copies the effect of the most recently used pill, card, rune, soul stone or activated item on use."},
	{"81", "", "Rerolls the items in the room like the D6, but they cycle back to their original form after one second, repeating. #If used more than once, all the rerolls are cycled through."},
	{"82", "", "Surrounds Isaac with a bubbling red aura for the current room. #All enemies killed drop red half hearts that disappears in 2 seconds."},
	{"83", "", "Creates a red room like the Red Key, for every possible exit."},
	{"84", "", "Invokes Dark Arts, turning Isaac into a phantom that can pass through enemies to paralyze them. #After a few seconds, he attacks them all, gaining damage bonuses for each target."},
	{"85", "", "Causes 8 poison farts that leave lingering brown creep, then plants a trail of 7 Butt Bombs in quick succession. #Standing on the creep gives +1.35 tears and +1 damage."},
	{"86", "", "14 Dead Bird familiars fly in and attack enemies. #They leave after all victims are dead or Isaac leaves the room."},
	{"87", "", "Isaac turns into a berserk Tainted Samson for 10 seconds, gaining +0.4 speed, some tears and +3 flat damage along with his melee attack."},
	{"88", "", "Activates Mega Blast for 7.5 seconds."},
	{"89", "", "Isaac dies, and is immediately revived at half a heart remaining in the same room, with some invincibility time. #The soul stone is automatically used upon taking fatal damage, as well, functioning as a minimal extra life."},
	{"90", "", "Activates the D6 and D20 effects. #The rerolled items use random pools, as if Chaos was active."},
	{"91", "", "Isaac turns into The Lost with all the benefits and weaknesses until he leaves the current room."},
	{"92", "", "Adds one random familiar."},
	{"93", "", "Spawns ~3-25 random coins."},
	{"94", "", "Spawns 15 random locusts."},
	{"95", "", "Spawns The Forgotten as a temporary secondary character, controlled at the same time as Isaac. #Dies if his two bone hearts run out with no further consequences, and disappears when Isaac leaves the room."},
	{"96", "", "Spawns 6 Book of Virtues wisps with random properties."},
	{"97", "", "Spawns Esau as a temporary secondary character, controlled at the same time as Isaac. #Dies if his health runs out with no further consequences, and disappears when Isaac leaves the room."},
}

EID:updateDescriptionsViaTable(repCards, EID.descriptions[languageCode].cards)

---------- Pills ----------

local repPills={
	{"0", "", "On use, the player farts, poisoning enemies around him."},
	{"1", "", "Deals a full heart of damage to the player. #If the player has a single heart or less left, it turns into a Full Health pill. #The damage does not count as red heart damage for purposes of getting a Devil Deal."},
	{"2", "", "Grants 2 soul hearts."},
	{"3", "", "Switches the values of the player's bombs and keys. #Also swaps the effects of Golden Keys and Bombs."},
	{"4", "", "Spawns 5 troll bombs behind the player over a period of five seconds, one per second."},
	{"5", "", "Restores all red hearts."},
	{"6", "", "Removes one red heart container. #If the player has one or fewer red heart containers, it will act as a Health Up instead."},
	{"7", "", "Grants one empty red heart container."},
	{"8", "", "Changes the appearance of the player's face."},
	{"9", "", "Does nothing on use."},
	{"10", "", "Adds fly orbital, blocking projectiles and damaging fly-type enemies on contact."},
	{"11", "", "Reduces the player's range by -0.6."},
	{"12", "", "Increases the player's range by +0.45."},
	{"13", "", "Reduces the player's speed by 0.12."},
	{"14", "", "Increases the player's speed by 0.15."},
	{"15", "", "Reduces the player's tears by 0.28."},
	{"16", "", "Increases the player's tears by 0.35."},
	{"17", "", "Reduces the player's luck by 1."},
	{"18", "", "Increases the player's luck by 1."},
	{"19", "", "Teleports the player to a random room. #Has a small chance to teleport the player to an I AM ERROR room, and an even smaller chance to teleport to a Black Market."},
	{"20", "", "Drops one to two batteries and fully charges the active item."},
	{"21", "", "Empties all but one red heart container and spawns 1-4 full red heart pickups. #If the player only has one half of a heart, it heals them to one heart. #Will spawn red hearts regardless of whether the player has red hearts or not. #Will spawn Black or Eternal hearts if in a super secret room with that type of heart in it."},
	{"22", "", "Freezes the player in place for a few seconds."},
	{"23", "", "Opens all entrances to both secret room entrances for the current floor."},
	{"24", "", "Charms all enemies in the room for a short time."},
	{"25", "", "Replaces the floor map with a question mark for the rest of the floor. This effect is not negated by Black Candle."},
	{"26", "", "Spawns a large yellow pool of creep around the player, dealing 22 damage per tick, 66 per second, to non-flying enemies standing on it."},
	{"27", "", "Tears are shot diagonally outwards for about a minute. #Persists between rooms."},
	{"28", "", "Grants The Wafer effect for the current room, reducing damage taken to half a heart."},
	{"29", "", "Makes the player take a full heart of damage from all sources for the current room. #This effect is negated if the player has The Wafer item, but overrides the Percs! pill."},
	{"30", "", "Spawns poop wherever the player moves for a short time."},
	{"31", "", "Gives the Curse of the Maze effect for the remainder of the floor. #Cannot be negated by Black Candle."},
	{"32", "", "Increases the player's size and decreases the pitch of their voice. #Does not increase the size of the player's hitbox."},
	{"33", "", "Decreases the player's size and increases the pitch of his voice. #This effect decreases the player's hitbox."},
	{"34", "", "Destroys all poop in the room and spawns one blue spider under the player, as well as one on top of each destroyed poop."},
	{"35", "", "Spawns one blue spider for each enemy in the room. #If there are no enemies in the room, instead spawns 1-3 blue spiders."},
	{"36", "", "Grants an effect similar to The Gamekid, granting invulnerability, fearing all enemies, removing the ability to shoot tears while causing the player to deal contact damage, and healing one half red heart for every two enemies killed."},
	{"37", "", "Briefly pixelates the screen 3 times over 30 seconds. #Can crash the game on some machines."},
	{"38", "", "Spawns 3 blue flies."},
	{"39", "", "Creates a pool of slippery brown creep under the player."},
	{"40", "", "Creates a pool of slowing black creep under the player."},
	{"41", "", "Slows all enemies, Isaac and the music for the duration of the room."},
	{"42", "", "Upon use, increases the speed of all enemies, Isaac and the music in the current room for the duration of the room. #This effect triggers again 30 seconds after use, and again 60 seconds after use."},
	{"43", "", "Upon use, any trinkets that the player is holding are consumed, giving the player their effects permanently."},
	{"44", "", "Upon use, the player shoots an explosive tear with the Ipecac explosion and poison effect that always deals 200 damage."},
	{"45", "", "Temporarily grants the Unicorn Stump effect, granting invulnerability and increased speed for 5 seconds. #Does not grant the ability to deal contact damage."},
	{"46", "", "Upon use, spawns a copy of the last pill consumed. #If there are no previously taken pills, will spawn another Vurp! pill."},
	{"47", "", "-0.15 shot speed."},
	{"48", "", "+0.15 shot speed."},
	{"49", "", "Increases one attribute and decreases another randomly, with the same power as standard attribute increase/decrease pills. #If taken with PHD, it will not reduce an attribute."},
} 

EID:updateDescriptionsViaTable(repPills, EID.descriptions[languageCode].pills)
