----------------------------------------
-----  Basic Russian descriptions  -----
----------------------------------------

-- FORMAT: Item ID | Name | Description

-- Special character markup:
-- ↑ = Up Arrow  |  ↓ = Down Arrow  |  ! = Warning  |  # = Starts a new line
-- More can be found here: https://github.com/wofsauge/External-Item-Descriptions/wiki/Markup

local languageCode = "ru"

-- init ru table
EID.descriptions[languageCode] = {}
EID.descriptions[languageCode].custom = {} -- table for custom entity descriptions
EID.descriptions[languageCode].languageName = "Russian"

-- Fonts to be used with this language pack
EID.descriptions[languageCode].fonts = EID.descriptions["en_us"].fonts

---------- Collectibles ----------
EID.descriptions[languageCode].collectibles={
	{"1", "Грустный лук", "↑ +0.7 к скорострельности"},
	{"2", "Внутренний глаз", "Тройной выстрел#↓ Уменьшает скорострельность"},
	{"3", "Сгибатель ложек", "Самонаводящиеся слезы"},
	{"4", "Голова Крикета", "↑ +0.5 к урону#↑ +50% множитель урона"},
	{"5", "Моё отражение", "Дает слезам эффект бумеранга#↑ +1.5 дальность стрельбы#↑ Множитель х1.6 к скорости слезы#↑ +1 высота слезы"},
	{"6", "Номер один", "↑ +1.5 скорострельность#↓ -17.62 дальность стрельбы#↑ +0.76 высота слезы"},
	{"7", "Кровь мученика", "↑ +1.0 к урону#↑ +50% урона, при использовании Книги Белиала"},
	{"8", "Братик Бобби", "Спутник с обыкновенными слезами#Наносит 3.5 урона"},
	{"9", "Скатол", "Все вражеские мужи становятся союзными"},
	{"10", "Нимб из мух", "+2 орбитальные мухи#Блокируют вражеские снаряды"},
	{"11", "1UP", "↑ +1 дополнительная жизнь#Возрождение с полным здоровьем"},
	{"12", "Волшебный гриб", "↑ +1 к здоровью#↑ 0.3 к урону#↑ +50% множитель урона#↑ +5.25 дальность стрельбы#↑ +0.3 к скорости#↑ +0.5 высота слезы#Восстанавливает здоровье!#Больше размер"},
	{"13", "Вирус", "Ядовитое касание#↓ -0.1 к скорости#С некоторым шансом враги оставят Черное Сердце, если они умерли от отравления"},
	{"14", "Стероидная ярость", "↑ +0.6 к скорости#↑ +5.25 дальность стрельбы#↑ +0.5 высота слезы"},
	{"15", "Меньше трёх", "↑ +1 к здоровью#Восстанавливает здоровье"},
	{"16", "Сырая печень", "↑ +2 к здоровью#Восстанавливает здоровье"},
	{"17", "Скелетный ключ", "+99 Ключей"},
	{"18", "Доллар", "+100 Монет"},
	{"19", "Бум!", "+10 Бомб"},
	{"20", "Трансцендентность", "Даёт полёт"},
	{"21", "Компас", "Показывает все иконки на карте#Не влияет на остальную карту"},
	{"22", "Полдник", "↑ +1 к здоровью"},
	{"23", "Обед", "↑ +1 к здоровью"},
	{"24", "Десерт", "↑ +1 к здоровью"},
	{"25", "Завтрак", "↑ +1 к здоровью"},
	{"26", "Гнилое мясо", "↑ +1 к здоровью"},
	{"27", "Деревянная ложка", "↑ +0.3 к скорости"},
	{"28", "Ремень", "↑ +0.3 к скорости"},
	{"29", "Мамино нижнее бельё", "↑ +5.25 дальность стрельбы#↑ +0.5 высота слезы"},
	{"30", "Мамины туфли", "↑ +5.25 дальность стрельбы#↑ +0.5 высота слезы"},
	{"31", "Мамина губная помада", "↑ +5.25 дальность стрельбы#↑ +0.5 высота слезы"},
	{"32", "Проволочная вешалка", "↑ +0.7 к скорострельности"},
	{"33", "Библия", "Полет в пределах комнаты#Моментально убивает Маму и Сердце Мамы!#!!! Убивает ВАС при использовании на Сатане"},
	{"34", "Книга Белиала", "↑ +2 к урону#↑ +12.5% шанс сделки с дьяволом#↑ +50% к урону при использовании, если есть Кровь Мученика (Blood of the Martyr)"},
	{"35", "Некрономикон", "Наносит 40 урона всем в комнате"},
	{"36", "Какашка", "Оставляет какашку на полу#Ее можно взорвать, как обычный камень, чтобы проложить мост"},
	{"37", "Мистер Бум", "При использовании появляется большая бомба, которая наносит 110 урона"},
	{"38", "Голова Тамми", "Выстреливает 10 слез вокруг персонажа"},
	{"39", "Мамин лифчик", "При использовании замораживает всех врагов в комнате на 4 секунды"},
	{"40", "Камикадзе!", "Вызывает взрыв вокруг персонажа"},
	{"41", "Мамина прокладка", "При использовании пугает всех врагов в комнате на 5 секунд"},
	{"42", "Гнилая голова Боба", "Отравляющая бомба, которую можно бросить в выбранном направлении"},
	{"43", "ID в игре не задействован", "<я - ошибка!>"},
	{"44", "Телепорт!", "Телепортирует персонажа в случайную комнату кроме комнат Я - ОШИБКА"},
	{"45", "Ням сердце", "При использовании лечит на 1 красное сердце"},
	{"46", "Счастливая нога", "↑ +1.0 к удаче#+8% к шансу награды за зачистку комнаты#Высокий шанс выигрыша в автоматах и у наперсточников"},
	{"47", "ПДУ Доктора", "При использовании запускает ракету, которая приземляется в указанную вами точку"},
	{"48", "Стрела Купидона", "Слезы пронзают врагов насквозь"},
	{"49", "Шуп Да Вуп!", "Атака серным лазером наносящее большой урон"},
	{"50", "Стивен", "↑ +1 к урону"},
	{"51", "Пентаграмма", "↑ +1.0 к урону#↑ +10% шанс сделки с дьяволом"},
	{"52", "Доктор Зародыш", "Слезы становятся бомбами!"},
	{"53", "Магнето", "Притягивает подбираемые предметы к персонажу"},
	{"54", "Карта сокровищ", "Показывает карту уровня#Не показывает иконки комнат"},
	{"55", "Мамин глаз", "Случайный шанс выстрелить назад#100% шанс с удачей +2"},
	{"56", "Лимонная авария", "При активации создает под вами лужу, которая наносит 66 контактного урона в секунду"},
	{"57", "Сдержанное восхищение", "Орбитальная муха#Летает на средней дистанции#Наносит 75 контактного урона в секунду"},
	{"58", "Книга Теней", "При использовании делает неуязвимым на 10 секунд"},
	{"59", "ID в игре не задействован", "<я - ошибка!>"},
	{"60", "Лесенка", "Позволяет ходить через пропасти шириной в 1 клетку"},
	{"61", "ID в игре не задействован", "<я - ошибка!>"},
	{"62", "Очарование вампира", "Лечит на пол-сердца за каждые 13 убитых врагов"},
	{"63", "Батарейка", "Активный предмет можно зарядить дважды"},
	{"64", "Распродажа в Стиме", "Скидка 50% в магазине#Вторая скидка сделает товары бесплатными"},
	{"65", "Поваренная книга анархиста", "При использовании призывает 6 тролль-бомб в случайном месте в комнате"},
	{"66", "Песочные часы", "Замедляет врагов на 8 секунд"},
	{"67", "Сестра Мэгги", "Спутник с обыкновенными слезами#Наносит 3.5 урона"},
	{"68", "Технология", "Заменяет слезы на лазер"},
	{"69", "Шоколадное молоко", "Заряжающиеся слезы#↑ от 30% до 400% урона#↑ к скорострельности"},
	{"70", "Гормоны роста", "↑ +1.0 к урону#↑ +0.4 к скорости"},
	{"71", "Мини гриб", "↑ +0.3 к скорости#↓ -4.25 дальность стрельбы#↑ +1.5 высота слезы*#(*обе складываются в увеличении дальности стрельбы)#↑ Уменьшает вас"},
	{"72", "Чётки", "+3 Сердца Души#Больше шанс найти Библию"},
	{"73", "Кубик мяса", "УР1: Орбитальный спутник#УР2: Стреляющий спутник#УР3: Маленький Мясной Пацан#УР4: Полноценный Мясной Пацан"},
	{"74", "Четвертак", "+25 Монет"},
	{"75", "Докторская степень", "Все пилюли имеют либо положительный, либо нейтральный эффекты# +1 пилюля#Лечит 2 сердца#Больше монет из автомата для сдачи крови"},
	{"76", "Рентгеновское зрение", "Открывает секретные комнаты"},
	{"77", "Мой маленький единорог", "Неуязвимость#Возможность нанести 40 контактного урона"}, -- My Little Unicorn
	{"78", "Книга Откровений", "+1 Сердце Души#Многие боссы заменятся на Всадников#↑ +17.5% шанс сделки с дьяволом"},
	{"79", "Метка", "↑ +1.0 к урону#↑ +0.2 к скорости#+1 Сердце Души"},
	{"80", "Договор", "↑ +0.5 к урону#↑ +0.7 скорострельность#+2 Сердца Души"},
	{"81", "Мёртвый кот", "Дает 9 жизней#Отнимает все Красные Сердца, кроме одного#Возрождение с 1 сердцем"},
	{"82", "Повелитель ямы", "Полет#↑ +0.3 к скорости"},
	{"83", "Гвоздь", "+1 Сердце Души#↑ +0.7 к урону#↓ -0.18 скорость#Возможность наносить контактный урон#Разрушение камней при хождении по ним"},
	{"84", "Нам нужно глубже!", "При использовании создает на полу люк на следующий уровень#10% шанс создать люк в ретро-сокровищницу"},
	{"85", "Колода карт", "Дает случайную карту таро при использовании"},
	{"86", "Зуб Монстро", "При использовании на случайного врага приземляется Монстро"},
	{"87", "Рога Локи", "Шанс выстрелить в 4 стороны#100% шанс с удачей +7"},
	{"88", "Маленький Чабби", "Спутник, летит в направлении стрельбы#Наносит 52.5 урона в секунду"},
	{"89", "Укус паука", "Шанс замедлить врагов#100% шанс с удачей +15"},
	{"90", "Маленький камень", "↑ +1 к урону#↑ +0.2 скорострельность#↓ -0.2 скорость"},
	{"91", "Шапка спелеолога", "Показывает, что в соседних комнатах#Позволяет увидеть секретные комнаты"},
	{"92", "Суперпластырь", "↑ +1 к здоровью#+2 Сердца Души"},
	{"93", "Геймкид", "Неуязвимость + контактный урон (при использовании)#Поедание врагов лечит вас"},
	{"94", "Мешочек с монетами", "Дает случайную монету каждые 2 комнаты"},
	{"95", "Робо-малыш", "Спутник, атакующий лазером#Наносит 3.5 урона"},
	{"96", "Маленький Чад", "Дает пол-сердца каждые 3 комнаты"},
	{"97", "Книга Греха", "При использовании создает на полу случайный подбираемый предмет"},
	{"98", "Реликвия", "Создает Сердце Души каждые 4 комнаты"},
	{"99", "Маленький Гиш", "Спутник с замедляющими слезами#Наносит 3.5 урона"},
	{"100", "Маленький Стивен", "Спутник с самонаводящимися слезами#Наносит 3.5 урона"},
	{"101", "Нимб", "↑ +1 к здоровью#↑ +0.3 к урону#↑ +0.2 скорострельность#↑ +0.25 дальность стрельбы#↑ +0.3 скорость#↑ +0.5 высота слезы"},
	{"102", "Мамин пузырёк с пилюлями", "При использовании дает случайную пилюлю"},
	{"103", "Простуда", "Шанс отравить врага слезой#100% шанс с удачей +12"},
	{"104", "Паразит", "Слезы разлетаются на две части при столкновении#Разделенные слезы наносят половину урона"},
	{"105", "D6", "Меняет артефакты на пьедесталах в комнате"},
	{"106", "Мистер Мега", "↑ Урон от бомб x2.25#+5 Бомб"},
	{"107", "Фестонные ножницы", "Полет в пределах комнаты#Ваше тело атакует врагов и наносит 82.5 контактного урона в секунду"},
	{"108", "Облатка", "Любой урон отнимает лишь пол-сердца"},
	{"109", "Деньги равно Сила", "↑ +0.04 к урону за каждую монетку#Чем больше монеток поднимает персонаж, тем меньше урона они дают#На бонус действуют множители персонажей"}, --оставить другую часть описания на детальный раздел русского описания?
	{"110", "Мамины линзы", "Шанс выстрелить замораживающую слезу (зависит от удачи)#↑ +0.25 дальность стрельбы#↑ +0.5 высота слезы#При удаче +12 шанс увеличивается до максимального (50%)"},
	{"111", "Боб", "Ядовитые газы"},
	{"112", "Ангел-хранитель", "Орбитальный спутник#Ускоряет всех спутников#Блокирует снаряды#Наносит 105 контактного урона в секунду"},
	{"113", "Малыш демон", "Авто-наводящийся спутник#Имеет небольшой радиус действия#Наносит 3 урона"},
	{"114", "Мамин нож", "Управляемый нож (наносит много урона)"},
	{"115", "Доска Уиджа", "Спектральные слезы"},
	{"116", "9 вольт", "+1 заряд после использования активного предмета#Полностью заряжает текущий предмет"},
	{"117", "Мёртвая птичка", "Атакует врагов после того, как вы получите урон#Наносит 4 контактного урона в секунду"},
	{"118", "Сера", "Заряжаемый кровавый лазер, наносящий много урона"},
	{"119", "Пакет с кровью", "↑ +1 к здоровью#↑ +0.3 к скорости#Лечит на 5 сердец"},
	{"120", "Странный гриб", "↑ +1.7 скорострельность#↑ +0.3 скорость#↓ Множитель x0.9 и -0.4 от урона"}, -- Thin
	{"121", "Странный гриб", "↑ +1 пустое сердце#↑ +0.3 к урону#↑ +0.25 дальность стрельбы#↓ -0.1 скорость#↑ +0.5 высота слезы"}, -- Thick
	{"122", "Вавилонская блудница", "!!! Если у вас 1/2 или меньше красных сердец:#↑ +1.5 к урону#↑ +0.3 к скорости"},
	{"123", "Руководство по монстрам", "При использовании дает случайного спутника в пределах комнаты"},
	{"124", "Свитки Мёртвого моря", "Эффект случайного активного предмета"},
	{"125", "Бобби-Бомба", "Самонаводящиеся бомбы#+5 Бомб"},
	{"126", "Лезвие бритвы", "При использовании: ↑ +1.2 к урону#Наносит игроку урон в 1 сердце"},
	{"127", "Забудь меня", "!!! ОДНОРАЗОВЫЙ !!!#Текущий уровень перезапускается и генерируется заново"},
	{"128", "Один навсегда", "Орбитальныя муха#Летает далеко от вас#Наносит 30 контактного урона"},
	{"129", "Ведро сала", "↑ +2 к здоровью#↓ -0.2 скорость#Лечит лишь на пол-сердца"},
	{"130", "Пони", "Даёт полет, если вы держите этот предмет#Ваша скорость будет увеличена до 1.5, если у вас меньше 1.5#Атака рывком в выбранном направлении"}, --потом добавить про скорость
	{"131", "Мешочек с бомбами", "Дает 1 бомбу каждые 2-3 комнаты"},
	{"132", "Кусок угля", "Чем дольше летит слеза, тем больше урона она наносит"},
	{"133", "Лапка Гаппи", "!!! При использовании превращает 1 контейнер Красного Сердца в 3 Сердца Души#Не работает с Костяными Сердцами"},
	{"134", "Хвост Гаппи", "33% шанс, что появится сундук после зачиски комнаты#33% шанс, что не появится ничего"},
	{"135", "Капельница", "Портативный банк крови#Дает 1 монету за пол-сердца"},
	{"136", "Лучший друг", "Привлекает к себе врагов#Через 5 секунд взрывается"},
	{"137", "Дистанционный детонатор", "Бомбы взрываются при использовании детонатора#+5 Бомб"},
	{"138", "Стигмата", "↑ +1 к здоровью#↑ +0.3 к урону"},
	{"139", "Мамина сумочка", "Позволяет носить 2 брелока"},
	{"140", "Проклятье Боба", "Ядовитые бомбы#+5 Бомб"},
	{"141", "Артистичный мальчик", "Появляется 7 случайных монет"},
	{"142", "Наплечники", "Если вы получили урон и осталось пол-сердца, дает Сердце Души#(Только один раз за комнату)"},
	{"143", "Спидбол", "↑ +0.3 к скорости#↑ +0.2 скорость слезы"},
	{"144", "Друг-бездельник", "Собирает монеты и дает за них предметы"},
	{"145", "Голова Гаппи", "Призывает 2-4 союзных мух"},
	{"146", "Молитвенная карточка", "При использовании дает вечное сердце"},
	{"147", "Зубчатая кирка", "Разрушает камни и объекты в пределах комнаты#Может проделать дыру в Секретную комнату!"},
	{"148", "Заражение", "При получении вами урона появляется союзная муха"},
	{"149", "Рвотный корень", "Слезы летят по дуге и взрываются#Эффект отравления"},
	{"150", "Жёсткая любовь", "Шанс выстрелить зубом, наносящим двойной урон#100% шанс с удачей +9"},
	{"151", "Плакса", "1/6 шанс появления союзной мухи при нанесении урона врагу"},
	{"152", "Технология 2", "Бесконечный лазер#↓ -35% к урону"},
	{"153", "Паук мутант", "4-кратный выстрел#↓ к скорострельности"},
	{"154", "Химический ожог", "↑ +2 к урону для левого глаза"},
	{"155", "Наблюдатель", "Летает по комнате#Наносит 17.1 контактного урона"},
	{"156", "Одеяние", "+1 заряд при получении урона"},
	{"157", "Жажда крови", "↑ + к урону, если вас ранят#Эффект сохраняется до конца этажа"},
	{"158", "Хрустальный шар", "Показывает всю карту#Дает Сердце Души или случайную карту"},
	{"159", "Дух ночи", "Полет#Спектральные слезы"},
	{"160", "Разверзшиеся небеса", "При использовании на врагов упадут Лучи Света#Лучи наносят урон персонажа+20 врагам"},
	{"161", "Анх", "После смерти вы появитесь в виде ??? (Синего ребенка)"},
	{"162", "Кельтский крест", "Шанс на временную неуязвимость после получения урона#100% шанс с удачей +27"},
	{"163", "Малыш призрак", "Спутник со спектральными слезами#Наносит 3.5 урона"},
	{"164", "Свеча", "Стреляет синим пламенем#Наносит контактный урон#Блокирует вражеские снаряды#Исчезает спустя 2 секунды"},
	{"165", "Девятихвостая плеть", "↑ +1 к урону#↑ +0.23 скорость слезы"},
	{"166", "D20", "Меняет подбираемые предметы в комнате"},
	{"167", "Малыш арлекин", "Стреляет слезами по V-образной траектории#Наносит 4 урона"},
	{"168", "Эпичный Зародыш", "Слезы заменяются на ракеты!"},
	{"169", "Полифем", "Мега слезы!#↑ к урону#↓ к скорострельности"},
	{"170", "Папочка Длинные Ноги", "За вами следует нога Папочки, которая давит врагов#Наносит 40 урона в секунду"},
	{"171", "Паучья задница", "Замедляет всех врагов#Наносит им небольшой урон"},
	{"172", "Жертвенный кинжал", "Орбитальный нож#Блокирует снаряды#Наносит 225 урона в секунду"},
	{"173", "Митра", "Высокий шанс найти Сердце Души"},
	{"174", "Радужный малыш", "Спутник, стреляет слезами со случайным эффектом#Наносит 3-5 урона"},
	{"175", "Папин ключ", "Открывает абсолютно все двери в комнате"},
	{"176", "Стволовые клетки", "↑ +1 к здоровью#↑ +0.16 скорость слезы"},
	{"177", "Переносной автомат", "Переносной игровой автомат"},
	{"178", "Святая вода", "Если вы получите урон, она разобьется#На полу появится лужа, которая наносит 24 урона врагам"},
	{"179", "Судьба", "Полет#+1 вечное сердце"},
	{"180", "Чёрный боб", "При получении урона вы отравляете врагов ядовитым газом"},
	{"181", "Белый пони", "Полет, если вы держите этот предмет#Если стандартная скорость персонажа менее чем 1.5, то при подборе артефакта она будет увеличена до 1.5#Атака рывком и небесными лучами"},
	{"182", "Священное сердце", "Самонаводящиеся слезы#↑ +1 к здоровью#Полное лечение#↑ +230% + 1 к урону#↓ -0.4 к скорострельности#↓ -0.25 скорость слезы#↑ +0.375 дальность стрельбы#↑ +0.75 высоты слезы"},
	{"183", "Зубочистки", "↑ +0.7 скорострельность.#↑ +0.16 скорость слезы"},
	{"184", "Святой Грааль", "Полет#↑ +1 к здоровью"},
	{"185", "Мёртвая голубка", "Полет#Спектральные слезы"},
	{"186", "Право на кровь", "При использовании наносит 40 урона всем в комнате#За использование ранит игрока на 1 сердце"},
	{"187", "Комок шерсти Гаппи", "Атакующий комок шерсти#Катается вокруг вас и растет, когда убивает врагов#Большой комок наносит больше урона"},
	{"188", "Авель", "Зеркально повторяет ваши движения#Стреляет в сторону игрока#Наносит 3.5 урона"},
	{"189", "Фанат Super Meat Boy", "↑ +1 к здоровью#↑ +0.3 к урону#↑ +0.2 скорострельность#↑ +0.5 дальность стрельбы#↑ +0.2 скорость#↑ +1.0 высота слезы#Восстанавливает здоровье"},
	{"190", "Пиро", "+99 Бомб"},
	{"191", "Трёхдолларовая банкнота", "Дает слезам случайные эффекты каждые 2-3 секунды"},
	{"192", "Телепатия для чайников", "При использовании делает ваши слезы самонаводящимися в пределах комнаты"},
	{"193", "Мясо", "↑ +1 к здоровью#↑ +0.3 к урону"},
	{"194", "Магический Шар 8", "↑ +0.16 скорость слезы#Дает случайную карту"},
	{"195", "Мамин кошелёк", "Создает на полу 4 пилюли"},
	{"196", "Давление", "+2 Сердца Души#↑ +0.4 скорострельность"},
	{"197", "Сок Иисуса", "↑ +0.5 к урону#↑ +0.25 дальность стрельбы#↑ +0.5 высота слезы"},
	{"198", "Коробка", "Появляется 1 подбираемый предмет каждого типа"},
	{"199", "Мамин ключ", "+2 Ключа#Больше предметов в сундуках"},
	{"200", "Мамины тени", "Шанс очаровать врагов#100% шанс с удачей +27"},
	{"201", "Железный слиток", "↑ +0.3 к урону#Шанс оглушить врага#100% шанс с удачей +27"},
	{"202", "Прикосновение Мидаса", "Превращает врагов в золото при касании#При контакте с врагом, наносит урон, равный количеству монет#Если их разбить, из них выпадут монеты"},
	{"203", "Скромный набор", "Подбираемые предметы становятся двойными"},
	{"204", "Сумка на ремне", "Шанс создать случайный предмет при получении урона"},
	{"205", "Острый штепсель", "Если активный предмет не заряжен, можно использовать его за 2 сердца"},
	{"206", "Гильотина", "↑ +1 к урону#↑ скорострельность#Ваша голова теперь движется вокруг вас по орбите#Голова наносит 105 контактного урона"},
	{"207", "Шар из пластырей", "УР1: орбитальный спутник#УР2: стреляющий спутник#УР3: маленькая Девочка-Пластырь#УР4: полноценная Девочка-Пластырь"},
	{"208", "Пояс чемпиона", "↑ +1 к урону#!!! +15% к шансу появления врагов-чемпионов"},
	{"209", "Бомбы из задницы", "+5 Бомб#Взрыв оглушает и наносит урон всем врагам в комнате"},
	{"210", "Обглоданный лист", "Неуязвимость, если вы стоите на месте дольше секунды"},
	{"211", "Паук малыш", "При получении вами урона появляется союзный паук"},
	{"212", "Ошейник Гаппи", "50% шанс возродиться после смерти"},
	{"213", "Потерянная линза", "У слез появится щит, блокирующий другие снаряды#При столкновении такой слезы и снаряда обе исчезнут#↓ -16% к скорости слезы"},
	{"214", "Анемия", "↑ +5 дальность стрельбы#При получении урона вы начинаете оставлять ядовитый след в пределах комнаты"},
	{"215", "Козья голова", "100% шанс появления комнаты Дьявола{{DevilRoom}}/Ангела{{AngelRoom}}"},
	{"216", "Церемониальная мантия", "↑ +1 к урону#+3 Черных Сердца"},
	{"217", "Мамин парик", "Со случайным шансом создает союзных пауков во время стрельбы#Лечит 1 контейнер здоровья"},
	{"218", "Плацента", "↑ +1 к здоровью#Очень медленная регенерация"},
	{"219", "Старый пластырь", "↑ +1 пустой контейнер сердец#При получении урона есть случайный шанс создать красное сердце"},
	{"220", "Грустные бомбы", "Бомба взрывается, выпуская слезы в разные стороны#+5 Бомб#Слезы копируют эффект ваших слез"},
	{"221", "Резиновый клей", "Отскакивающие слезы"},
	{"222", "Анти-гравитация", "↑ +2 к скорострельности#Слезы висят в воздухе, пока вы стреляете"},
	{"223", "Пироманьяк", "Взрывы лечат вас!#+5 Бомб"},
	{"224", "Тело Крикета", "↑ +1 к скорострельности#↓ -10.0 дальность стрельбы#Слезы разлетаются на 4 части при столкновении#Разделенные слёзы наносят половину урона"},
	{"225", "Убогий", "Шанс создать Сердце Души/Черное Сердце при получении урона#Шанс создать половину Красного Сердца за убитого врага"},
	{"226", "Чёрный лотос", "↑ +1 к здоровью#+1 Сердце Души#+1 Черное Сердце"},
	{"227", "Свинка копилка", "+3 Монеты#При получении урона дает 1-2 монеты#Даёт 0-1 за Хранителя"},
	{"228", "Мамины духи", "↑ +1 к скорострельности#Шанс напугать врагов"},
	{"229", "Лёгкое Монстро", "Слезы заряжаются и выстреливают россыпью#Атака аналогична атаке Монстро"},
	{"230", "Абаддон", "↑ +1.5 к урону#↑ +0.2 к скорости#Шанс напугать врагов#↓ Лишает вас красных сердец#+6 Черных Сердец"},
	{"231", "Шар смолы", "Замедляющие слезы#Вы оставляете за собой на полу замедляющую слизь"},
	{"232", "Остановившиеся часы", "При получении урона, враги в комнате перманентно замедляются#↑ +0.3 к скорости"},
	{"233", "Крошечная планета", "Слезы летают вокруг вас по орбите#↑ +7.0 к высоте слез#Спектральные слёзы"},
	{"234", "Заражение 2", "Вы будете получать союзного паука за каждого убитого врага"},
	{"235", "ID в игре не задействован", "<я - ошибка!>"},
	{"236", "Кишечная палочка", "Превращает врага в какашку при касании"},
	{"237", "Прикосновение Смерти", "Слезы превращаются в косы!#↑ +1.5 к урону#↓ -0.3 к скорострельности#Сквозные слезы"},
	{"238", "Первая часть Ключа", "!!! Часть ключа от двери к Мега-Сатане!#Выше вероятность появления {{AngelRoom}} Комнаты Ангела"},
	{"239", "Вторая часть Ключа", "!!! Часть ключа от двери к Мега-Сатане!#Выше вероятность появления {{AngelRoom}} Комнаты Ангела"},
	{"240", "Экспериментальное лечение", "↑/↓ Ваши параметры меняются случайным образом"},
	{"241", "Договор с Преисподней", "Все предметы, падающие после зачистки комнаты, дублируются#33% шанс, что не появится ничего после зачистки комнаты#Не влияет в Режиме Жадности "},
	{"242", "Позор", "Шанс блокировать летящие снаряды#Блокирует с любой стороны"},
	{"243", "Триединый щит", "Щит, блокирующий снаряды"},
	{"244", "Технология.5", "Атака лазером#Лазер имеет случайные эффекты"},
	{"245", "20/20", "Двойные выстрелы!"},
	{"246", "Голубая карта", "Показывает секреты на карте"},
	{"247", "Лучшие друзья навсегда!", "Спутники наносят больше урона"},
	{"248", "Разум улья", "Союзные мухи и пауки наносят в два раза больше урона"},
	{"249", "Выбор есть", "После босса появляются два артефакта на выбор вместо одного#!!! Взять можно только один"},
	{"250", "Парные бомбы", "Все подбираемые бомбы становятся двойными"},
	{"251", "Базовая колода", "Можно нести с собой 2 карты#Превращает все пилюли в карты"},
	{"252", "Маленький мешочек", "Можно нести с собой 2 пилюли#Превращает все карты в пилюли"},
	{"253", "Волшебная корка", "↑ +1 к удаче#↑ +1 к здоровью"},
	{"254", "Сгусток крови", "↑ +1 к урону#↑ +5 к дальности стрельбы#!!! Только для левого глаза"},
	{"255", "Шуруп", "↑ +0.5 к скорострельности#↑ +0.2 скорость слезы"},
	{"256", "Горячие бомбы", "Горящие бомбы, оставляют огонь после взрыва#+5 Бомб"},
	{"257", "Огненный разум", "Горящие слезы#С некоторым шансом взрываются"},
	{"258", "Потерянный №", "С каждым этажом меняет все артефакты, что у вас имеются, на случайные"},
	{"259", "Тёмная материя", "↑ +1 к урону#Шанс испугать врагов#100% шанс с удачей +20"},
	{"260", "Чёрная свеча", "Иммунитет к Проклятиям#+1 Черное Сердце#Высокий шанс на появление комнаты Дьявола{{DevilRoom}}/Ангела{{AngelRoom}}"},
	{"261", "Проптоз", "↑ +100% бонус к урону#Чем дальше летит слеза, тем меньше бонус"},
	{"262", "Потерянная страница 2", "+1 Черное Сердце#Когда осталось 1 сердце, наносит всем урон в комнате"},
	{"263", "Чистая руна", "<я - ошибка! В Repentance>"},
	{"264", "Умная муха", "Орбитальная муха#При получении вами урона начинает атаковать врагов#Наносит 22.5 урона в секунду"},
	{"265", "Высушенный ребёнок", "Спутник, блокирует снаряды#После блокирования с шансом 10% может нанести урон всем врагам в комнате"},
	{"266", "Сочащийся кокон", "Оставляет за собой замедляющую слизь#Может создать союзных пауков после зачистки комнаты"},
	{"267", "Робо-малыш 2.0 ", "Стреляет лазером#Управляется клавишами стрельбы#Наносит 3.5 урона"},
	{"268", "Гнилой малыш", "Атакует союзными мухами"},
	{"269", "Безголовый малыш", "Оставляет кровавый след, который наносит врагам 6 урона в секунду"},
	{"270", "Пиявка", "Лечит вас на пол-сердца, когда убивает кого-нибудь"},
	{"271", "Загадочный мешочек", "Создает случайные предметы"},
	{"272", "Большая красивая муха", "Союзная взрывающаяся муха#Взрыв наносит 60 урона"},
	{"273", "Мозг Боба", "Спутник, летит в направлении вашей стрельбы#При контакте взрывается и наносит 60 урона"},
	{"274", "Лучший приятель", "При получении вами урона появляется орбитальная муха#Наносит 75 урона в секунду"},
	{"275", "Маленькая сера", "Стреляет заряжающимся кровавым лазером#Наносит 31.5 урона в секунду"},
	{"276", "Сердце Исаака", "Ваш персонаж неуязвим#!!! Вы теряете здоровье, когда ваш спутник-сердце получает урон"},
	{"277", "Маленький призрак", "Спутник, атакующий врагов и пугающий их#Наносит 4 урона в секунду"},
	{"278", "Тёмный бездельник", "Спутник, собирающий красные сердца и дающий Сердца Души или пауков взамен"},
	{"279", "Большой фанат", "Большая орбитальная муха#Блокирует снаряды#Наносит 30 урона в секунду"},
	{"280", "Сисси Длинные Ноги", "Спутник, создает союзных пауков в комнате с врагами"},
	{"281", "Боксерская груша", "Отвлекает на себя внимание врагов"},
	{"282", "Руководство по прыжкам", "Позволяет вам прыгать"},
	{"283", "D100", "Эффект D4, D6 и D20:#Меняет все предметы в комнате#Меняет артефакты на пьедесталах#Меняет артефакты, которые вы носите"},
	{"284", "D4", "При активации случайным образом изменяет пассивные артефакты, которые носит ваш персонаж"},
	{"285", "D10", "Меняет всех врагов в комнате на случайных"},
	{"286", "Пустая карта", "При использовании копирует эффект взятой вами карты/руны"},
	{"287", "Книга тайн", "Показывает часть карты при использовании"},
	{"288", "Коробка с пауками", "Призывает 1-4 союзных пауков"},
	{"289", "Красная свеча", "Стреляет красным пламенем#Пламя сохраняется до тех пор, пока не будет повреждено 5 раз"},
	{"290", "Банка", "Может хранить в себе до 4 красных сердец"},
	{"291", "Слив", "При использовании превращает всех врагов в кучки#Не работает на Боссах"},
	{"292", "Сатанинская Библия", "+1 Черное Сердце при использовании"},
	{"293", "Голова Крампуса", "Атака кровавым лазером в 4 стороны"},
	{"294", "Масленый боб", "При использовании пукает и отталкивает врагов"},
	{"295", "Магические пальцы", "При использовании наносит урон всем врагам в комнате#Цена использования - 1 монета"},
	{"296", "Преобразователь", "Превращает 2 Сердца Души в 1 Красное Сердце"},
	--NOTE FOR LOCALIZERS: There is code to highlight the text of your current floor
	--For it to work, only use line breaks or semicolons to separate floor details, and use the same order as English
	{"297", "Ящик Пандоры", "!!! ОДНОРАЗОВЫЙ!!!# В зависимости от этажа:#ПI:2 Сердца Души#ПII:2 ключа, 2 бомбы#КI:1 артефакт Босса#KII:ПI+КI#ГI:4 Сердца Души#ГII: 30 Монет#УI:2 артефакта Босса#УII: Библия#Шеол: 1 артефакт Дьявола+Черное Сердце#Собор: 1 артефакт Ангела+Сердце Души#Сундук: 1 Монета"},
	{"298", "Копыто единорога", "Временная неуязвимость и + 0.28 к скорости при использовании"},
	{"299", "Телец", "Вы становитесь быстрее в комнате с врагами#При полном ускорении вы становитесь неуязвимым"},
	{"300", "Овен", "↑ +0.25 к скорости#Столкновение с врагами наносит им урон"},
	{"301", "Рак", "+3 Сердца Души#При получении урона любой следующий урон в пределах комнаты отнимет пол-сердца"},
	{"302", "Лев", "Позволяет ломать камни, растаптывая их#Больше размер"},
	{"303", "Дева", "Шанс временной неуязвимости после получения урона#Превращает негативные пилюли в положительные#100% шанс с удачей +10"},
	{"304", "Весы", "+6 Монет / Ключей / Бомб#Балансирует ваши параметры!#!!! Все последующие улучшения будут распределяться между всеми вашими параметрами"},
	{"305", "Скорпион", "Ядовитые слезы"},
	{"306", "Стрелец", "↑ +0.2 к скорости#Сквозные слёзы"},
	{"307", "Козерог", "+1 Ключ / Бомба / Монета#↑ +1 к здоровью#↑ +0.5 к урону#↑ +0.1 к скорости#↑ +1.5 дальность стрельбы"},
	{"308", "Водолей", "Персонаж оставляет за собой след из слез, наносящий врагам 6 урона в секунду"},
	{"309", "Рыбы", "↑ +0.5 к скорострельности#Увеличивает отталкивание"},
	{"310", "Тушь Евы", "Множитель урона x2#↓ Множитель х0.5 к скорострельности#↓ -0.5 скорость слезы"},
	{"311", "Тень Иуды", "После смерти вы появитесь в виде Черного Иуды#(он имеет урон x2 и + к скорости)"},
	{"312", "Бант Мэгги", "↑ +1 к здоровью#Удваивает эффект лечения сердец"},
	{"313", "Святая мантия", "Блокирует первый полученный урон, после чего исчезает#Обновляется каждую комнату"},
	{"314", "Громовые бёдра", "↑ +1 к здоровью#↓ -0.4 к скорости#Вы можете ломать камни, растаптывая их"},
	{"315", "Странное влечение", "Магнитные слезы#Притягивают предметы и врагов"},
	{"316", "Проклятый глаз", "Заряженный залп из слез#Если вы получите урон во время зарядки, с некоторой вероятностью телепортирует в случайную комнату"},
	{"317", "Загадочная жидкость", "Слезы оставляют ядовитую лужу#Лужа наносит 30 урона в секунду"},
	{"318", "Близнецы", "Братик, атакующий врагов в ближнем бою#Наносит 6 контактного урона в секунду"},
	{"319", "Другой глаз Каина", "Медленно летает по комнате#Стреляет в ту же сторону, что и вы"},
	{"320", "Единственный друг ???", "Управляемая муха#Наносит 5 контактного урона в секунду"},
	{"321", "Цепи Самсона", "Цепь + Шар#Может ломать камни, ранить врагов и блокировать снаряды#Шар наносит 10.7 контактного урона в секунду"},
	{"322", "Малыш монго", "Копирует эффект слез другого спутника#Слеза наносит вдвое больше урона"},
	{"323", "Слезы Исаака", "При использовании выпускает 8 слез вокруг персонажа#Заряжается во время стрельбы"},
	{"324", "Неопределённый", "Телепортирует в:#{{SecretRoom}}{{SuperSecretRoom}}Секретную комнату-, Комнату Я - ОШИБКА- или {{TreasureRoom}}Комнату с артефактом"},
	{"325", "Ножницы", "Отрезает вам голову#Голова стоит на месте#Вы управляете своим телом"},
	{"326", "Дыхание жизни", "Заряд уменьшается, когда вы держите ПРОБЕЛ#Когда у вас не останется зарядов, вы получите кратковременную неуязвимость#!!! Если вы слишком долго держите ПРОБЕЛ, вы получите урон#Если вы отпустите ПРОБЕЛ, неуязвимость исчезнет"},
	{"327", "Фотокарточка", "Дает короткую неуязвимость, если осталось 1/2 сердца#Позволяет пройти на уровень Сундук"},
	{"328", "Негатив", "Наносит урон всем врагам в комнате, если осталось 1/2 сердца#Позволяет пройти на уровень Темная комната"},
	{"329", "Техника Людовика", "Большая управляемая слеза"},
	{"330", "Соевое молоко", "↑ Крайне высокая скорострельность#↓ -80% к урону"},
	{"331", "Божественность", "Самонаводящиеся слезы, имеют ауру, наносящую урон#↑ +0.5 к урону#↑ +1.2 дальность стрельбы#↓ -0.3 скорострельность#↓ -0.3 скорость слезы#↑ +0.8 высота слезы"},
	{"332", "Лохмотья Лазаря", "После смерти вы появитесь в виде Лазаря и получите его артефакт"},
	{"333", "Разум", "Полностью открывает карту на всех этажах"},
	{"334", "Тело", "↑ +3 к здоровью"},
	{"335", "Душа", "+2 Сердца Души#Снаряды замедляются и отлетают в сторону от вас"},
	{"336", "Мёртвый лук", "Сквозные + спектральные слезы#↑ +0.25 дальность стрельбы#↓ -0.4 скорость слезы"},
	{"337", "Сломанные часы", "Замедляет или ускоряет врагов в каждой 4-ой комнате"},
	{"338", "Бумеранг", "Замораживает врагов#Может хватать недоступные предметы"},
	{"339", "Безопасная булавка", "↑ +5.25 дальность стрельбы#↑ +0.16 скорость слезы#+1 Черное Сердце#↑ +0.5 высота слезы"},
	{"340", "Кофеиновая пилюля", "↑ +0.3 к скорости#↑ Меньше размер#Дает 1 случайную пилюлю"},
	{"341", "Порванная фотография", "↑ +0.7 к скорострельности#↑ +0.16 скорость слезы"},
	{"342", "Голубая шляпка", "↑ +1 к здоровью#↑ +0.7 скорострельность#↓ -0.16 скорость слезы"},
	{"343", "Отмычка", "↑ +1 к удаче#+1 Сердце Души#Создает 2 ключа"},
	{"344", "Коробок спичек", "+1 Черное Сердце#Создает 3 бомбы"},
	{"345", "Синтол", "↑ +1.0 к урону#↑ +5.25 дальность стрельбы#↑ +0.5 высота слезы"},
	{"346", "Закуска", "↑ +1 к здоровью"},
	{"347", "Диплопия", "!!! ОДНОРАЗОВЫЙ!!!#Дублирует все артефакты / предметы в комнате"},
	{"348", "Плацебо", "Копирует эффект пилюли, которую вы держите"},
	{"349", "Деревянный пятак", "50% шанс создать случайную монету"},
	{"350", "Токсический шок", "При заходе в комнату все враги получают отравление"},
	{"351", "Мега боб", "Наносит 5 урона и отравляет ближайших врагов#Создает взрывную волну#Этой волной можно открыть секретные комнаты"},
	{"352", "Стеклянная пушка", "↓ При использовании уменьшает здоровье до 1/2 сердца#Выпускает огромную сквозную спектральную слезу ((УРОН+1) X 10)"},
	{"353", "Бомбербой", "+5 Бомб#Бомбы взрываются по +-образной траектории"},
	{"354", "Хрустящий Джэк", "↑ +1 к здоровью#Создает случайный брелок на полу"},
	{"355", "Мамин жемчуг", "↑ +1.25 дальность стрельбы#↑ +1 к удаче #↑ +0.5 высота слезы"},
	{"356", "Аккумулятор", "Активируемый предмет теперь имеет двойной эффект"},
	{"357", "Коробка с друзьями", "Дублирует ваших спутников в пределах комнаты#Если у вас нет спутников, создаёт {{Collectible113}} Малыша демона на данную комнату"},
	{"358", "Колдун", "Вы стреляете по диагонали двумя слезами, как от пилюли R U A WIZARD#Спектральные слезы"},
	{"359", "Восьмидюймовые гвозди", "↑ +1.5 к урону#Увеличивает отдачу"},
	{"360", "Инкуб", "Копирует атаку вашего персонажа"},
	{"361", "Дар судьбы", "Стреляет слезами с таким же уроном, что и у вашего персонажа"},
	{"362", "Маленький сундучок", "Дает случайный предмет через каждые несколько комнат"},
	{"363", "Присягнувший защитник", "Наносит 105 контактного урона#Блокирует и притягивает снаряды#При блокировании 10 выстрелов в одной комнате создает вечное сердце"},
	{"364", "Френдзона", "Орбитальная муха#Наносит 45 контактного урона"},
	{"365", "Потерянная муха", "Летит вдоль стен и препятствий#Наносит 105 контактного урона"},
	{"366", "Разбросанные бомбы", "+5 Бомб#Бомба разделяется на 2-4 маленькие бомбы после взрыва"},
	{"367", "Липкие бомбы", "+5 Бомб#Бомбы прилипают к врагу#При убийстве бомбой появляется союзный паук"},
	{"368", "Эпифора", "Стрельба в одном направлении увеличивает вашу Скорострельность"},
	{"369", "Континуум", "↑ +2.25 дальность стрельбы#↑ +1.5 высота слезы#Слезы проходят сквозь стены и появляются с противоположной стороны"},
	{"370", "Мистер Куколка", "↑ +0.7 к скорострельности#↑ +5.25 дальность стрельбы#↑ +0.5 высота слезы#Создает 3 случайных сердца"},
	{"371", "Проклятие башни", "При получении вами урона появляются 6 тролль-бомб#Бомбы влияют на модификаторы"},
	{"372", "Заряженный малыш", "Спутник-батарейка#Со случайным шансом создает батарейку или на время замораживает всех врагов#Шанс получить +1 заряд к вашему предмету"},
	{"373", "Мёртвый глаз", "↑ +25% к урону за каждое точное попадание (макс. +100%)#Шанс потери множителя при промахе"},
	{"374", "Божественный свет", "Случайный шанс выстрелить Святой Слезой, выпускающей Луч Света при попадании по врагу#Луч наносит 4x от вашего урона"},
	{"375", "Шляпа Наблюдателя", "20% шанс отразить снаряд#Иммунитет от взрывов (в т.ч. Маминой Ноги)"},
	{"376", "Пополнение", "Создает 3 случайных предмета#Обновляет предметы в магазине после покупки"},
	{"377", "Разорванный кокон", "Вражеские пауки становятся нейтральными"},
	{"378", "Номер 2", "После непрерывной стрельбы в течение 3 секунд, создает под вами бомбу из задницы"},
	{"379", "Двойной взгляд", "Хитбокс слез становится больше#Спектральные слезы"},
	{"380", "Плати и играй", "+5 Монет#Вместо ключей двери требуют монету"},
	{"381", "Благословение Эдема", "↑ +0.7 к скорострельности#В начале следующего забега вы получите случайный артефакт"},
	{"382", "Дружелюбный шар", "Можно бросить во врага, чтобы поймать его#После следующего броска пойманное существо появится как союзное#Оно будет с вами, пока не умрет"},
	{"383", "Слезный детонатор", "При активации разделяет каждую слезу в комнате на 6 слёз во все стороны"},
	{"384", "Малютка Гёрди", "Заряжается и атакует врагов с разгона#Наносит 90 контактного урона в секунду"},
	{"385", "Бамбо", "Подбирает лежащие монеты. Каждые подобранные им 6 монет повышают его уровень (УР4 требует 12 монет)#УР2: может дать случайный подбираемый предмет#УР3: стреляет в ту же сторону, что и вы#УР4: преследует врагов, оставляет бомбы#после получения УР4 продолжает собирать монеты и давать за них предметы"},
	{"386", "D12", "Меняет все камни и объекты в комнате на случайные (кучки, горшки, TNT, каменные блоки и т.д.)"},
	{"387", "Кадило", "Создает большую ауру, замедляющую врагов и летящие вражеские снаряды"},
	{"388", "Ключник-бездельник", "Собирает лежащие ключи, взамен дает случайные сундуки"},
	{"389", "Мешочек с рунами", "Создает случайную руну каждые 5 комнат"},
	{"390", "Серафим", "Спутник, атакует самонаводящимися слезами#Слёзы наносят 10 урона"},
	{"391", "Предательство", "При получении вами урона все враги в комнате очаровываются"},
	{"392", "Зодиак", "Дает вам эффект случайного знака зодиака#С каждым этажом эффект меняется"},
	{"393", "Змеиный поцелуй", "Случайный шанс отравить врага#Отравляющий контактный урон#Отравленные враги после смерти с некоторым шансом оставляют Черное Сердце"},
	{"394", "Отмеченный", "Вы стреляете слезами в направлении маркера, которым вы управляете#↑ +0.7 к скорострельности#↑ +3.15 дальность стрельбы#↑ +0.3 высота слез"},
	{"395", "Технология X", "Вы атакуете заряжающимися лазерными кольцами"},
	{"396", "Желудочная бритва", "Создает порталы, между которыми можно быстро перемещаться#Можно установить в разных комнатах"},
	{"397", "Тяговый луч", "Ваши слезы летят строго вдоль луча света, не отклоняясь даже при вашем движении#↑ +0.5 скорострельность#↑ +5.25 дальность стрельбы#↑ +0.16 скорость слезы#↑ +0.5 высота слезы"},
	{"398", "Плоть Бога", "Случайный шанс уменьшить врага#Уменьшенного врага можно убить, раздавив его"},
	{"399", "Пасть бездны", "↑ +1.0 к урону#После непрерывной стрельбы в течение 3 секунд, на голове появится красный крест. После прекращения стрельбы появится черное кольцо, наносящее большой урон#Убитые кольцом враги имеют шанс оставить Черное Сердце"},
	{"400", "Копье Судьбы", "Перед вами появляется копье, наносящее x2 от вашего урона#Шанс напугать врагов при контакте"},
	{"401", "Взрывчатко", "Слезы со случайным шансом могут прилипнуть к врагу, после чего они начнут увеличиваться в размерах, пока не взорвутся"},
	{"402", "Хаос", "Никаких ограничений: везде, где есть артефакты, можно найти абсолютно любой!#Создает 1-6 подбираемых предметов"},
	{"403", "Паучья модификация", "Показывает здоровье врагов и урон, наносимый вами#Накладывает на врага случайный эффект при контакте#Может создать союзного паука или батарейку"},
	{"404", "Пукающий малыш", "Блокирует снаряды#После блокирования может выпустить газы, которые могут отравить,очаровать или отбросить врагов"},
	{"405", "Игровой баг", "Летает по комнате и накладывает на врагов случайные эффекты при контакте"},
	{"406", "D8", "Случайным образом меняет ваши параметры#Влияет только на урон, скорострельность, дальность стрельбы и скорость"},
	{"407", "Чистота", "↑ Повышает одну из характеристик, в зависимости от цвета аура#При получении урона, случайная аура появится в следующей комнате#{{ColorRed}}Красная{{CR}} = +4.0 к урону#{{ColorBlue}}Синяя{{CR}} = -4 к задержке между выстрелами#{{ColorYellow}}Желтая{{CR}} = +0.5 скорость#{{ColorOrange}}Оранжевая{{CR}} = +7.5 дальность стрельбы, +1 высота слезы"},
	{"408", "Атаме", "При получении вами урона появится черное кольцо, наносящее большой урон#Убитые кольцом враги имеют шанс оставить Черное Сердце"},
	{"409", "Пустой сосуд", "+2 Черных Сердца#Если у персонажа нет красных сердец:#Дает полет#10 секунд неуязвимости каждые 40 секунд в комнате с врагами, когда секунды на таймере достигли 00, 20 или 40"},
	{"410", "Злой глаз", "Есть случайный шанс выпустить глаз, стреляющий в одном с вами направлении"},
	{"411", "Вожделенная кровь", "↑ За каждое убийство дает +0.5 к урону#Макс. +5 урона за 10 убийств#Действует в пределах комнаты"},
	{"412", "Зачатие Камбиона", "Получив 15 кол-во урона, вы перманентно получите дьявольского спутника#До 4 возможных спутников"},
	{"413", "Непорочное зачатие", "Подобрав 15 кол-во сердец, вы перманентно получите ангельского спутника#До 5 возможных спутников"},
	{"414", "Больше вариантов", "В золотых комнатах появляются 2 предмета на выбор#Взять можно только один"},
	{"415", "Корона света", "+2 Сердца Души#Если нет неполных красных сердец:#↑ +100% урона#↑ +5.25 дальности#↑ +0.5 высоты слезы#↓ -0.3 скорости слезы#При получении урона бонус сбрасывается и обновляется при переходе в другую комнату"},
	{"416", "Глубокие карманы", "Можно переносить с собой 2 карты/руны/пилюли"},
	{"417", "Суккуб", "Летает по комнате, имеет ауру, которая наносит врагам урон#↑ +50% к урону, когда вы внутри ауры"},
	{"418", "Фруктовый пирог", "Каждая слеза имеет случайный эффект"},
	{"419", "Телепорт 2.0", "Телепортирует в случайную комнату, в которой вы еще не были#Последовательность: {{Room}}>{{BossRoom}}>{{SuperSecretRoom}}>{{Shop}}>{{TreasureRoom}}>{{SacrificeRoom}}> {{DiceRoom}}>{{Library}}>{{CursedRoom}}>{{MiniBoss}}>{{ChallengeRoom}}>{{IsaacsRoom}}> {{ArcadeRoom}}>{{ChestRoom}}>{{SecretRoom}}>{{DevilRoom}}{{AngelRoom}}> Комната Я - ОШИБКА"},
	{"420", "Чёрный порошок", "Вы оставляете за собой на полу черный след#Образовавшийся из него круг создаст пентаграмму, которая наносит врагам 10 урона за тик"},
	{"421", "Почечный боб", "Накладывает очарование на ближайших врагов при активации"},
	{"422", "Светящиеся песочные часы", "Перенесет вас в предыдущую комнату#Все вокруг восстанавливает свое первоначальное состояние, какое они имели, когда вы были в предыдущей комнате"},
	{"423", "Круг защиты", "Большой круг Света, наносящий урон#Шанс отразить вражеский снаряд"},
	{"424", "Пакет на голову", "Все подбираемые предметы с шансом 33% могут быть заменены на мешочки#Создает мешочек"},
	{"425", "Ночник", "Фонарик, который пускает конус света в сторону стрельбы персонажа. Свет замедляет врагов и их снаряды"},
	{"426", "Одержимый фанат", "Повторяет ваши движения с задержкой в 3 секунды#Наносит 30 контактного урона в секунду"},
	{"427", "Шахтёр", "Создает бочку с динамитом#Бочку можно двигать по комнате#Если использовать повторно в той же комнате, взорвет старую бочку и создаст новую"},
	{"428", "Пижама", "+4 Сердца Души#Восстанавливает здоровье"},
	{"429", "Голова Хранителя", "Есть шанс в 5% появления монетки после попадания по врагу"},
	{"430", "Папа-мух", "Повторяет ваши движения с задержкой в 3 секунды#Стреляет в ближайших врагов нанося урон эквивалентный урону персонажа"},
	{"431", "Многомерный малыш", "Повторяет ваши движения с задержкой в 3 секунды#Слезы, пройденные через него, дублируются и приобретают больше скорости"},
	{"432", "Блестящие бомбы", "+5 Бомб#Бомбы с некоторой вероятностью оставляют случайный подбираемый предмет после взрыва"},
	{"433", "Моя тень", "При получении вами урона накладывает эффект страха на всех врагов и оставляет черную союзную личинку, атакующая врагов#Остается с вами, пока не умрет"},
	{"434", "Банка с мухами", "За каждое убийство в банке будет появляться одна союзная муха#Всего можно накопить 20 мух#Использование Банки с мухами выпустит всех мух"},
	{"435", "Малыш Локи", "Спутник, стреляет в 4 стороны#Наносит 3.5 урона за выстрел"},
	{"436", "Молоко!", "При получении вами урона разбивается, после этого вы получите + к скорострельности в пределах комнаты#Обновляется каждую комнату"},
	{"437", "D7", "Восстанавливает ранее убитых врагов в комнате#Позволяет повторно получить награду за зачистку комнаты#!!! Если использовать в битве с Алчностью, то комната может превратиться в Магазин"},
	{"438", "Соска-пустышка", "+1 Сердце Души#↑ +0.7 скорострельность#Персонаж становится маленьким, его хитбокс уменьшается"},
	{"439", "Мамина коробка", "Создает случайный брелок на полу#↑ Если вы держите предмет, дает +1 к удаче и удваивает эффект брелоков"},
	{"440", "Почечный камень", "В случайный момент персонаж перестанет стрелять, в это время можно зарядить burst-атаку#Персонаж выплюнет почечный камень, наносящий большой урон, а затем выпустит шквал слез с очень высокой скоростью#↓ -0.2 скорость#↓ -17 дальность стрельбы#↑ +2.0 высота слезы"},
	{"441", "Мега заряд", "При использовании атакует мощным кровавым потоком, как у Мега-Сатаны# Атака длится 15 секунд# Можно перемещаться между комнатами, продолжая стрелять"},
	{"442", "Корона тёмного принца", "!!! Если есть ровно 1 красное сердце:#↑ +1.5 дальность стрельбы#↑ +0.7 скорострельность#↑ +0.2 скорость слезы#↑ +1 высоты слезы#Не работает с персонажами без красных сердец"},
	{"443", "Яблоко!", "Случайный шанс выстрелить лезвием, наносящим 400% урона#↑ +0.3 скорострельность"},
	{"444", "Графитовый карандаш", "Каждый 15 выстрел вы будете выпускать большую россыпь слез#Каждая такая слеза нанесет двойной урон"},
	{"445", "Собачий зуб", "↑ +0.3 к урону#↑ +0.1 к скорости#Вы услышите собачий вой, если рядом будет {{SecretRoom}}{{SuperSecretRoom}}Секретная комната#Вы услышите собачий лай, если в комнате спрятан люк в ретро-сокровищницу"},
	{"446", "Мёртвый зуб", "Во время стрельбы появляется зеленая аура, отравляющая врагов"},
	{"447", "Тормозной боб", "Во время стрельбы можно с некоторым шансом создать облако, наносящее 5 урона в секунду# Его можно подвинуть, стреляя в него"},
	{"448", "Осколок стекла", "При получении вами урона есть шанс получить ↑ +5 к дальности атаки и возможность оставлять за собой кровавый след, или создать красное сердце#Действует в пределах комнаты"},
	{"449", "Металлическая пластина", "+1 Сердце Души#Вражеский снаряд с шансом 25% может отскочить обратно с эффектом оглушения"},
	{"450", "Глаз Алчности", "Слезы могут превратить врага в золото"},
	{"451", "Сукно Таро", "Дает случайную карту/руну#Удваивает эффект всех карт/рун"},
	{"452", "Варикозные вены", "При получении урона, вы выпустите 10 слез вокруг себя#Слезы имеют +25 урона"},
	{"453", "Перелом", "Вы стреляете костями#Кости делятся на мелкие осколки при столкновении#↑ +1.5 дальность стрельбы#↑ +1.0 высота слезы"},
	{"454", "Полидактилия", "Можно носить две карты / пилюли / руны#Дает случайную карту / пилюлю / руну"},
	{"455", "Папина потерянная монета", "↑ +1.5 дальность стрельбы#↑ +1 высота слезы#Дает Счастливую монетку"},
	{"456", "Полуночный перекус", "↑ +1 к здоровью"},
	{"457", "Яйцеголовый", "+1 Сердце Души#20% шанс блокировать урон от снаряда"},
	{"458", "Пупок", "Дает случайный брелок#+ дополнительный слот под брелок"},
	{"459", "Синусит", "Шанс выстрелить соплей# Сопля липнет к врагу и наносит ему урон, пока он не умрет"},
	{"460", "Глаукома", "Шанс оглушить врагов"},
	{"461", "Паразитоид", "Шанс выстрелить замедляющим паучьим яйцом# При попадании паучьим яйцом появится союзная муха/паук"},
	{"462", "Глаз Белиала", "↑ +1.5 дальность стрельбы#↑ +1.0 высота стрельбы#Слезы пронзают врагов насквозь#После первого попадания слеза удваивает свой урон и становится самонаводящейся"},
	{"463", "Серная кислота", "↑ +0.3 к урону#Кислотная слеза может разрушить камень или открыть секретную комнату"},
	{"464", "Символ баланса", "+2 Сердца Души#С монстров-чемпионов выпадают более хорошие предметы"},
	{"465", "Аналоговый стик", "↑ +0.3 скорострельность#Позволяет стрелять по диагонали, или в любую сторону, если вы стреляете аналоговым стиком"},
	{"466", "Инфекция", "Первый убитый враг в комнате взрывается облаком газа и отравляет всех ближайших врагов# Отравленные враги также взрываются"},
	{"467", "Палец!", "Наносит 10% урона от вашего персонажа врагам, в чью сторону палец смотрит"},
	{"468", "Тень", "Повторяет ваши движения с задержкой в 3 секунды#Наносит 30 контактного урона"},
	{"469", "Депрессия", "Оставляет след из слез#След наносит 6 урона в секунду#При контакте с врагом с некоторым шансом выпустит Луч Света"},
	{"470", "Молчун", "Летает по комнате#Наносит контактный урон#Останавливается во время стрельбы#Во время остановки он может блокировать вражеские выстрелы"},
	{"471", "Маленький Монстро", "Заряжает свою атаку#Атакует так же, как и босс Монстро#Каждая слеза наносит по 3.5 урона"},
	{"472", "Малыш король", "Все спутники следуют за ним#Останавливается во время стрельбы#Телепортируется обратно к вам, когда вы перестаете стрелять"},
	{"473", "Большой Чабби", "Очень медленно летит в направлении стрельбы#Наносит 40.5 контактного урона в секунду"},
	{"474", "Разбитая стеклянная пушка", "Блокирует снаряды"},
	{"475", "План C", "!!! ОДНОРАЗОВЫЙ !!!#Наносит 9,999,999 урона всем врагам в комнате, через 3 секунды убивает вас"},
	{"476", "D1", "Дублирует 1 случайный предмет в комнате"},
	{"477", "Пустота", "!!! При использовании поглощает все артефакты в комнате#Активный артефакт добавит свой эффект к эффекту Void'а#↑ Пассивный артефакт дает случайный бонус к характеристикам"},
	{"478", "Пауза", "При активации все враги замирают до тех пор, пока вы не выстрелите#Замороженные враги наносят урон при касании"},
	{"479", "Плавильня", "Поглощает переносимый вами брелок и дает вам его эффект навсегда#Увеличенный шанс на выпадение брелока"},
	{"480", "Компост", "Превращает каждый подбираемый в комнате предмет в союзного паука/муху#Удваивает количество имеющихся мух/пауков"},
	{"481", "Анализатор", "При использовании, дает небольшой ↑/↓ к случайным характеристикам#Случайный эффект слез в пределах комнаты#Спрайты в текущей комнате ломаются"},
	{"482", "Переключатель", "При использовании меняет вашего персонажа на случайного#Удаляет последний подобранный вами артефакт"},
	{"483", "Мама Мега!", "!!! ОДНОРАЗОВЫЙ !!!#Действует на весь этаж#Взрывает все объекты#Наносит 200 урона всем врагам#Открывает секретные комнаты / комнату Босс-Раша / вход в Синюю Утробу"},
	{"484", "Подождите, что?", "При использовании отталкивает врагов и создает взрывную волну#Может открывать двери и разрушать камни"},
	{"485", "Погнутый пенни", "50% шанс дублировать все предметы в комнате (в т.ч. артефакты)#50% шанс уничтожить все предметы в комнате и создать 1 Монету"},
	{"486", "Тупая бритва", "Наносит урон, но без потери здоровья#Активирует предметы, которые работают после получения урона"},
	{"487", "Картофелечистка", "При активации удаляет 1 контейнер красного сердца, взамен дает ↑ +0.2 к урону и \"Кубик Мяса\""},
	{"488", "Метроном", "При использовании дает эффект случайного артефакта в пределах комнаты"},
	{"489", "Бесконечность D", "Эффект случайного кубика#Вы сможете увидеть, эффект какого кубика будет следующим"},
	{"490", "Душа Эдема", "!!! ОДНОРАЗОВЫЙ !!!#Создает 2 артефакта из пула комнаты, в которой вы находитесь"},
	{"491", "Кислотный малыш", "Дает случайную пилюлю каждые три комнаты#Каждое использование пилюли отравляет врагов в комнате"},
	{"492", "Эй, слушай!", "↑ +1 к удаче#Показывает секретные комнаты, меченые камни или потайные люки под камнями"},
	{"493", "Адреналин", "За каждое пустое сердце дает ↑ +0.2 к урону"},
	{"494", "Лестница Иакова", "Электрические слезы#При столкновении испускают искры в случайном направлении#Искры наносят половину урона персонажа"},
	{"495", "Призрачный перец", "Шанс выстрелить пламенем вместо слезы#Пламя сохраняется до тех пор, пока не будет повреждено 5 раз"},
	{"496", "Эвтаназия", "Шанс выстрелить Шприцем#Шприц моментально убивает рядовых врагов, взрываясь на несколько маленьких шприцов"},
	{"497", "Камуфляжные трусы", "Сбивает с толку всех врагов и камуфлирует персонажа при заходе в комнату до тех пор, пока вы не начнете стрелять"},
	{"498", "Двойственность", "Если после Босса должна появиться комната Дьявола{{DevilRoom}}/Ангела{{AngelRoom}}, то появятся обе#Зайти можно только в одну на выбор"},
	{"499", "Причастие", "100% шанс появления комнаты Ангела{{AngelRoom}}"},
	{"500", "Мешок мешков", "Со случайным шансом дает мешочки с предметами"}, --update later
	{"501", "Пищевод Алчности", "За каждые 25 монет дает ↑ +1 к здоровью#Позволяет Хранителю иметь больше здоровья"},
	{"502", "Большой прыщ", "Шанс выстрелить замедляющей слезой, наносящей больше урона и оставляющей слизь на полу"},
	{"503", "Маленький рог", "Шанс выстрелить сквозной слезой, моментально убивающей врагов#Не действует на Боссов и Мини-Боссов"},
	{"504", "Коричневый самородок", "При использовании призывает союзную муху-турель, атакующую врагов#Каждый выстрел наносит по 2 урона"},
	{"505", "Поке Гоу", "Шанс появления союзного существа при заходе в новую комнату"},
	{"506", "Предатель", "При попадании по врагу со спины, наносится двойной урон и накладывается кровотечение, наносящее урон в 10% от макс. здоровья врага каждые 5 секунд"},
	{"507", "Острая соломинка", "Наносит ваш урон + 10% от макс. здоровья врага#Действует на всех врагов в комнате#Шанс получить пол-красного сердца или пол-Сердца Души"},
	{"508", "Мамина бритва", "Орбитальный спутник, при контакте накладывает кровотечение, наносящее урон в 10% от макс. здоровья врага каждые 5 секунд#Не блокирует выстрелы"},
	{"509", "Кровавый глаз", "Орбитальный спутник, каждые 2 секунды стреляет в направлении своего взгляда#Наносит 30 контактного урона#Слёзы наносят 3.5 урона"},
	{"510", "Бредящий", "Призывает союзника - безумную версию босса#Босс выбирается случайным образом#Действует в пределах комнаты"},
	{"511", "Сердитая муха", "Летает вокруг случайного врага, пока тот не умрет#Наносит 30 контактного урона"},
	{"512", "Чёрная дыра", "Кидает на землю черную дыру, засасывающую в себя все, в т.ч. врагов#Наносит 0.4 урона за тик#Разрушает близлежащие камни#Длится 6 секунд"},
	{"513", "Бозо", "↑ +0.1 к урону#+1 Сердце Души#Шанс очаровать/испугать врага#Случайный шанс создать радужную кучку при получении урона"},
	{"514", "Сломанный модем", "Вызывает 'лаги' у врагов и их снарядов случайным образом#С шансом 25% подбираемые предметы могут залагать и удвоиться"},
	{"515", "Загадочный подарок", "!!! ОДНОРАЗОВЫЙ !!!#Создает артефакт из пула комнаты, в которой вы находитесь#Шанс получить Кусок Угля или Какашку"},
	{"516", "Ороситель", "Разбрызгиватель, стреляющий слезами по кругу#Может копировать эффекты ваших слез"},
	{"517", "Быстрые бомбы", "+7 Бомб#Убирает задержку между использованиями бомб, таким образом вы можете очень быстро использовать их, быстро нажимая клавишу бомбы"},
	{"518", "Друг в коробке", "Случайный ребенок из кооп-режима#Имеет случайный эффект слез#Случайным образом меняется каждый этаж"},
	{"519", "Малютка Сумасшествие", "Безумная версия спутника#Каждые 10 секунд меняется случайным образом"},
	{"520", "Соединительные кабели", "+1 заряд за каждые 15 убийств"},
	{"521", "Купон", "Делает один случайный предмет в магазине{{Shop}} или в комнате Дьявола{{DevilRoom}} бесплатным"},
	{"522", "Телепатия", "Замораживает ближайшие вражеские снаряды на 3 секунды#Затем они улетают обратно#Перезаряжается за 3 секунды"},
	{"523", "Коробка для перевозки", "При использовании подбирает до 6 предметов#Повторное использование создает эти предметы на полу#Можно перемещать предметы между комнатами"},
	{"524", "Технология Ноль", "Слезы соединены между собой электрическим разрядом"},
	{"525", "Проказа", "При получении урона может появиться орбитальный спутник#Макс. 3 спутника одновременно#Спутники будут уничтожены, если получат слишком много урона"},
	{"526", "7 печатей", "Появляется случайный спутник-всадник, который меняется каждые 10 секунд"},
	{"527", "Мистер Ми!", "!!! Спутник, который выполняет ваши приказы:#Открывает двери и сундуки, Подбирает предметы, Ворует артефакты из магазина / у дьявола, атакует врагов, взрывается, активирует нажимные плиты"},
	{"528", "Ангельская призма", "Слеза, пролетевшая через орбитальную призму, разделится на 4 такие же слезы"},
	{"529", "Хлоп!", "Слезы теперь имеют физику, как бильярдные шары"},
	{"530", "Список смерти", "Дает полезную награду, если вы убиваете врагов в том порядке, в каком они будут помечены"},
	{"531", "Гемолакрия", "Слезы летят по дуге#При столкновении разлетаются на осколки#↑ +31% к урону#↓ скорострельность"},
	{"532", "Лакрифагия", "Слеза в полете замедляется#После остановки разрывается на маленькие слезы#Можно\"накормить\" слезу, стреляя в нее, тогда она станет больше"},
	{"533", "Трисвятое", "Слезы становятся пронзающими лучами света#(принцип похож на Brimstone)"},
	{"534", "Школьный портфель", "Позволяет носить 2 активных предмета#Переключение на CTRL (держите CTRL играя за \"Забытого\")"},
	{"535", "Одеяло", "+1 Сердце Души#Дает одноразовый щит в комнате с Боссом"},
	{"536", "Жертвенный алтарь", "!!! ОДНОРАЗОВЫЙ !!!#Приносит 2 случайных спутников игрока в жертву, взамен дает дьявольский артефакт за каждого#Превращает союзных пауков/мух в монеты"},
	{"537", "Маленький Спевер", "+1 пилюля#Атакует, выплевывая на пол слизь#Когда вы съедаете любую пилюлю, тип его атаки меняется"},
	{"538", "Шарики", "Дает 3 случайных брелока#При получении урона есть шанс поглотить брелок и получить его эффект навсегда"},
	{"539", "Загадочное яйцо", "При получении им урона появляется зачарованный враг#Чем больше комнат пройдено без получения урона, тем сильнее будет зачарованное существо"},
	{"540", "Плоский камень", "Слезы отскакивают от пола#Удар об пол сопровождается уроном по площади"},
	{"541", "Костный мозг", "+1 Костяное Сердце#Создает 3 Красных Сердца на полу"},
	{"542", "Скользящее ребро", "Орбитальный спутник#Отражает снаряды"},
	{"543", "Священная земля", "При получении урона создает на полу Белую Кучку#Белая кучка имеет ауру, которая ↑ увеличивает вашу скорострельность и имеет шанс заблокировать вражеский урон#При уничтожении кучки аура также исчезает"},
	{"544", "Заострённое ребро", "Гвоздь, парящий перед персонажем#Наносит контактный урон"},
	{"545", "Книга мёртвых", "При использовании призывает орбитальную кость или зачарованного монстра за каждого убитого врага в комнате#Использовать до выхода из зачищенной комнаты"},
	{"546", "Отцовское кольцо", "Создает кольцо-ауру, замораживающую врагов"},
	{"547", "Бумаги о разводе", "+1 Костяное Сердце#↑ +0.7 скорострельность#Дает брелок \"Загадочная бумажка\""},
	{"548", "Челюстная кость", "Спутник-бумеранг#Наносит 7 контактного урона#Может подбирать предметы"},
	{"549", "Хрупкие кости", "Заменяет все ваши красные сердца 6 Костяными Сердцами#При потере Костяного Сердца выстреливает кости в разные стороны и дает перманентные ↑ +0.5 к скорострельности"},
	{"550", "Первая часть Маминой лопаты", "Мамина Нога постоянно атакует вас#Использование останавливает Мамину Ногу в пределах комнаты#!!! Если вы поменяете ее на другой предмет и выйдете из комнаты, она исчезнет#Требуется для открытия Забытого#Прохождение комнаты Boss-Rush оставит Вторую часть лопаты"},
	{"551", "Вторая часть Маминой лопаты", "Вторая часть лопаты#!!! Используйте лопату на кучке грязи на уровне \"Темная Комната\""},
	{"552", "Мамина лопата", "При использовании создает на полу люк на следующий уровень#!!! Используйте лопату в куче грязи на уровне \"Темная Комната\"#!!! Открывает кое-что крутое"},
}

---------- Trinkets ----------
EID.descriptions[languageCode].trinkets={
	{"1", "Проглоченный пенни", "При получении вами урона, на пол падает монетка"},
	{"2", "Окаменевшая какашка", "Больше предметов из какашек"},
	{"3", "Батарейка ААА", "Уменьшает количество необходимых для предмета зарядов на 1"},
	{"4", "Сломанный пульт", "Телепортирует в случайную комнату, когда вы используете активный предмет"},
	{"5", "Пурпурное сердце", "х2 шанс на появление врагов-чемпионов"},
	{"6", "Сломанный магнит", "Притягивает монеты"},
	{"7", "Бусинка от четок", "+50% к шансу появления {{AngelRoom}} Комнаты Ангела#Выше шанс найти {{Collectible33}}Библию в {{Shop}}Магазине и {{Library}}Библиотеке"},
	{"8", "Картридж", "5% шанс активировать эффекта артефакта Геймкида при получении урона#(короткая неуязвимость + контактный урон)"},
	{"9", "Пульсирующий червь", "Пульсирующие слезы#Влияет только на хитбокс"},
	{"10", "Извивающийся червь", "Слезы летят волнами#↑ +0.3 к скорострельности"},
	{"11", "Кольцевой червь", "Слезы летят по спирали"},
	{"12", "Сплющенный червь", "Слезы на 50% шире#Увеличенное отталкивание"},
	{"13", "Кредит в магазине", "!!! ОДНОРАЗОВЫЙ !!!#Позволяет взять один любой предмет из магазина бесплатно"},
	{"14", "Мозоль", "Шипы и лужи больше не наносят вам урон"},
	{"15", "Счастливый камень", "На месте уничтоженного камня появляется монета"},
	{"16", "Ноготь Мамы", "Мамина Нога атакует врагов раз в минуту# Может атаковать и вас, если нет врагов"},
	{"17", "Чёрная помада", "+1% к шансу появления черных сердец"}, -- base chance is 0.5%
	{"18", "Библейский трактат", "+3% к шансу появления вечных сердец"}, -- base chance is 1.667%
	{"19", "Скрепка", "Золотые сундуки открываются без ключей"},
	{"20", "Обезьянья Лапка", "Дает Черное Сердце, если осталось 1/2 сердец#!!! Исчезает после 3 использований"},
	{"21", "Загадочная бумажка", "Имитирует \"Фотокарточку\", \"Негатив\", \"Потерянную страницу\" и \"Плакат о пропавшем без вести\""},
	{"22", "Хвост демона", "!!! Меняет сердца в комнатах на черные, или на другие предметы#Уменьшает выпадение сердец"},
	{"23", "Плакат о пропавшем без вести", "После смерти в {{SacrificeRoom}} Комнате Жертвоприношений вы появитесь в виде \"Потерянного\"#Если он уже открыт, то персонаж может возродиться за него за пределами Комнаты Жертвоприношений"},
	{"24", "Пенни из задницы", "Каждая монета заставляет вас пукать"},
	{"25", "Загадочная шоколадка", "Пукает или оставляет кучку каждые пол-минуты"},
	{"26", "Крюкообразный червяк", "Слезы летят по Г-образной траектории#↑ +10 дальность стрельбы"},
	{"27", "Прямой червь", "↑ +0.5 скорость слезы"},
	{"28", "Сломанный анх", "22% шанс возродиться за ??? (\"Синего Ребенка\")"},
	{"29", "Рыбья голова", "При получении урона призывает 1 синюю муху"},
	{"30", "Розовый глаз", "Случайный шанс отравить врагов#100% шанс при удаче +18"},
	{"31", "Кнопка", "Случайный шанс выстрелить пронзающей насквозь слезой"},
	{"32", "Вольная шляпка", "25% шанс получения эффекта случайного гриба или Компаса каждую комнату"},
	{"33", "Пуповина", "Если осталось 1/2 сердец, вы получите Стивена Младшего"},
	{"34", "Сердце ребенка", "10% шанс при зачистке комнаты получить случайное сердце#Шанс на бонусное сердце из судуков, помеченных камней и разрушенных автоматов"},
	{"35", "Изогнутый рог", "↑ +2 к урону"},
	{"36", "Ржавый ключ", "10% шанс при зачистке комнаты получить ключ#Шанс на бонусный ключ из судуков, помеченных камней и разрушенных автоматов"},
	{"37", "Козлиное копыто", "↑ +0.15 к скорости"},
	{"38", "Мамина жемчужина", "+10% к шансу появления Синих, Чёрных и Костяных сердец"}, -- base chance is 10%
	{"39", "Рак", "↑ +1.0 к скорострельности"},
	{"40", "Красная заплатка", "20% шанс получить +1.8 к урону на данную комнату, если вы получили урон#100% шанс при удаче 8"},
	{"41", "Спичка", "10% шанс при зачистке комнаты получить бомбу#Шанс на бонусную бомбу из судуков, помеченных камней и разрушенных автоматов#!!! Удаляет {{Trinket53}}Клеща"},
	{"42", "Счастливый палец", "↑ +1 к удаче#+8% к шансу получить награду при зачистке комнаты#Дополнительные предметы из сундуков, помеченных камней и разрушенных автоматов"},
	{"43", "Проклятый череп", "Когда останется 1/2 сердец, телепортирует в предыдущую комнату"},
	{"44", "Безопасная крышка", "10% шанс при зачистке комнаты получить пилюлю#Шанс на бонусную пилюлю из судуков, помеченных камней и разрушенных автоматов"},
	{"45", "Туз пик", "10% шанс при зачистке комнаты получить карту#Шанс на бонусную карту из судуков, помеченных камней и разрушенных автоматов"},
	{"46", "Вилка Исаака", "10% шанс восстановить 1/2 красного сердца после зачистки комнаты"},
	{"47", "ID в игре не задействован", "<Зачем ты заглянул сюда?>"},
	{"48", "Потерянная страница", "При получении урона есть шанс нанести урон всем врагам в комнате"},
	{"49", "Кровавый пенни", " 50% шанс получить половину Красного Сердца, когда вы подбираете монету"},
	{"50", "Сгоревший пенни", "50% шанс получить бомбу, когда вы подбираете монету"},
	{"51", "Сплющенный пенни", "50% шанс получить ключ, когда вы подбираете монету"},
	{"52", "Поддельный пенни", "Когда вы подбираете монету, есть 50% шанс получить дополнительную"},
	{"53", "Клещ", "-15% здоровья Босса#Лечит на 1 сердце, когда вы заходите в {{BossRoom}}Комнату Боссом#!!! После взятия не может быть сброшен#Может быть удалён только {{Trinket41}}Спичкой или проглотив"},
	{"54", "Голова Исаака", "Спутник с пронзающими насквозь слезами#Наносит 3.5 урона"},
	{"55", "Вера Мэгги", "В начале каждого этажа дает 1 вечное сердце"},
	{"56", "Язык Иуды", "Скидка в комнате Дьявола"},
	{"57", "Душа ???", "Летает по комнате#Стреляет в том же направлении, что и вы#Наносит 3.5 урона"},
	{"58", "Локон Самсона", "1/15 шанс получить +0.5 к урону за убийство#Шанс 100% при удаче 10#Эффект остается в пределах коматы"},
	{"59", "Глаз Каина", "Шанс 25% на эффект Компаса в начале каждого этажа#Шанс 100% при удаче 3"},
	{"60", "Лапка птички Евы", "5% шанс появления {{Collectible117}}Мертвой Птички при убийстве врага#Шанс 100% при удаче 8"},
	{"61", "Левая рука", "Превращает все сундуки в Красные"},
	{"62", "Сияющий камень", "Помеченные камни и камни с потайными люками подсвечиваются каждые 10 секунд"},
	{"63", "Безопасные ножницы", "Обезвреживает тролль-бомбы и делает их обычными подбираемыми бомбами"},
	{"64", "Радужный червь", "Эффект случайного брелока червя#Эффект меняется каждые 3 секунды"},
	{"65", "Ленточный червь", "Дальность Стрельбы x2"},
	{"66", "Ленивый червь", "↓ -0.4 скорость слезы#↑ +4 дальность стрельбы#↑ +2 высота слезы"},
	{"67", "Сломанный Кубик", "50% шанс срабатывания эффекта случайного кубика при получении урона"},
	{"68", "Супер магнит", "Притягивает предметы и врагов"},
	{"69", "Выцветшая фотокарточка", "Случайным образом камуфлирует игрока#Сбивает с толку врагов"},
	{"70", "Вошь", "Шанс появления союзного паука во время зачистки комнаты"},
	{"71", "Мочевой пузырь Боба", "Бомбы оставляют ядовитую лужу"},
	{"72", "Часовая батарейка", "6.66% шанса при зачистке комнаты получить батарейку#+10% шанс, что случайный предмет заменится на батарейку#5% шанс добавить 1 заряд активируемому артефакту при зачистке комнаты"},
	{"73", "Взрывающаяся крышка", "10% шанс, что взорвавшаяся бомба оставит еще одну бомбу, которую можно подобрать"},
	{"74", "Кладоискатель", "0.5% шанс найти потайной люк при ломании камней"},
	{"75", "Ошибка", "Эффект случайного брелока каждую комнату"},
	{"76", "Фишка для покера", "50/50 шанс найти в сундуках дополнительные предметы или враждебную муху"},
	{"77", "Блистер", "Увеличивает отталкивание"},
	{"78", "Секундная стрелка", "Накладываемые на врагов эффекты длятся в два раза дольше"},
	{"79", "Неизведанная бесконечность", "Малый шанс получить копию карты/руны после ее использования"},
	{"80", "Черное перо", "↑ +0.2 к урону за каждый имеющийся дьявольский артефакт"},
	{"81", "Слепая ярость", "Неуязвимость после получения урона длится дольше"},
	{"82", "Золотая подкова", "+15% шанс на двойную Золотую комнату#(два предмета на выбор, взять можно только один)"},
	{"83", "Ключ от магазина", "Открывает все {{Shop}} магазины"},
	{"84", "Ребро Жадности", "Жадность / Супер Жадность больше не появятся в магазинах / тайных комнатах#Увеличивает выпадение монет"},
	{"85", "Карма", "Использование Автомата Пожертвований может вылечить вас или создать Попрошайку"},
	{"86", "Малютка личинка", "Из сломанной кучки появляется союзная муха"},
	{"87", "Мамин медальон", "Лечит на половину Красного Сердца при использовании ключа#Все половинки сердец заменяются на полные"},
	{"88", "Нет!", "Активируемые артефакты не появятся, если такая возможность присутствует"},
	{"89", "Детский поводок", "Спутники ближе друг к другу"},
	{"90", "Коричневая крышка", "Какашка взрывается после уничтожения"},
	{"91", "Меконий", "Повышает шанс появления Черной Кучки"},
	{"92", "Треснувшая корона", "↑ Улучшает ваши характеристики примерно на 33% в зависимости от ваших артефактов#↑ +0.2 скорострельность# -1 к задержке между выстрелами"},
	{"93", "Использованный подгузник", "Вражеские мухи могут стать нейтральными"},
	{"94", "Рыбий хвост", "Дублирует всех синих пауков / мух, которых вы создаете"},
	{"95", "Чёрный зуб", "Случайный шанс выстрелить отравляющим черным зубом"},
	{"96", "Червь Уроборос", "Слезы летят по огромной дугообразной траектории#↑ +4 дальность стрельбы"},
	{"97", "Миндалина", "Очень малый шанс появления спутника при получении урона#Может сработать дважды, после чего исчезнет"},
	{"98", "Козявка", "Шанс выстрелить липкой соплей"},
	{"99", "Супер мяч", "Шанс выстрелить отскакивающей слезой"},
	{"100", "Вибрирующая лампочка", "!!! Когда ваш активный предмет заряжен:#↑ +0.25 к скорости#↑ +0.75 дальность стрельбы#↑ +0.2 скорострельность#↑ +0.10 скорость слезы#↑ +0.5 к урону#↑ +1 к удаче"},
	{"101", "Тусклая лампочка", "!!! Когда ваш активный предмет разряжен:#↑ +0.5 к скорости#↑ +1.5 дальность стрельбы#↑ +0.4 скорострельность#↑ +0.3 скорость слезы#↑ +1.5 к урону#↑ +2 к удаче"},
	{"102", "Разорванная карта", "+1 дополнительная секретная комната на новом этаже, если брелок при вас"},
	{"103", "Равенство!", "!!! Если у вас одинаковое кол-во монет, бомб и ключей:#делает подбираемые предметы двойными"},
	{"104", "Кость желаний", "Шанс появления пьедестала с артефактом при получении урона#После использования исчезает"},
	{"105", "Пакет с обедом", "Шанс появления артефакта с дополнительным здоровьем при получении урона#После использования исчезает"},
	{"106", "Потерянная пробка", "Увеличивает радиус поражения луж и следов, оставляемых вами"},
	{"107", "Сердце ворона", "Урон будет игнорировать Сердца Души / Черные Сердца, отнимая в первую очередь Красные"},
	{"108", "Грецкий орех", "После 1-9 взрывов, которые задели персонажа, брелок сломается и создат монетку, сердце, ключ и ещё один брелок#После использования исчезает#Защита от взрывов никак не влияет"},
	{"109", "Скотч", "Все ваши спутники, в т.ч. орбитальные, замирают"},
	{"110", "Серебряный доллар", "В Утробе будут появляться {{Shop}} Магазины"},
	{"111", "Кровавая корона", "В Утробе будут появляться {{TreasureRoom}} Комнаты сокровищ"},
	{"112", "Заплати чтобы выиграть", "Автомат пополнения всегда будет в {{TreasureRoom}} Комнате сокровищ"},
	{"113", "Саранча Войны", "В начале каждой комнаты появляется взрывоопасная союзная муха#Муха наносит двойной урон персонажа + урон от взрыва"},
	{"114", "Саранча Чумы", "В начале каждой комнаты появляется ядовитая союзная муха#Муха наносит двойной урон персонажа"},
	{"115", "Саранча Голода", "В начале каждой комнаты появляется замедляющая союзная муха#Муха наносит двойной урон персонажа"},
	{"116", "Саранча Смерти", "В начале каждой комнаты появляется союзная муха#Муха наносит 4x урон персонажа"},
	{"117", "Саранча Завоевателя", "В начале каждой комнаты появляется 1-4 союзных мух#Каждая муха наносит двойной урон персонажа"},
	{"118", "Крыло летучей мыши", "Шанс появления крыльев при получении урона#Действует в пределах комнаты"},
	{"119", "Стволовая клетка", "В начале нового этажа лечит на половину Красного Сердца"},
	{"120", "Заколка", "Полностью перезаряжает ваш активный предмет, когда вы заходите в Комнату Босса"},
	{"121", "Деревянный крест", "Дает одноразовый щит в начале нового этажа"},
	{"122", "Масло", "При использовании активируемого предмета он окажется на полу на пьедестале"},
	{"123", "Филигранное перо", "Боссы-Ангелы будут оставлять другие артефакты вместо частей ключа"},
	{"124", "Дверной ограничитель", "Дверь, через которую вы прошли, остается открытой"},
	{"125", "Удлинитель", "Электрическая цепь связывает ваших спутников между собой#Цепь наносит 6 урона"},
	{"126", "Гнилой пенни", "Когда вы подбираете монету, появляется союзная муха"},
	{"127", "Малыш-сгибатель", "Самонаводящиеся слезы у ваших спутников"},
	{"128", "Кость пальца", "Шанс получить Костяное Сердце при получении урона"}
}

---------- Cards ----------
EID.descriptions[languageCode].cards={
	{"1", "0 - Дурак", "Телепортирует в начало уровня"},
	{"2", "I - Маг", "Самонаводящиеся слезы в пределах комнаты"},
	{"3", "II - Верховная жрица", "Мамина Нога атакует случайного врага"},
	{"4", "III - Императрица", "↑ +2.35 к урону и ↑ +0.3 к скорости в пределах комнаты"},
	{"5", "IV - Император", "Телепортирует в комнату с Боссом ({{BossRoom}})"},
	{"6", "V - Иерофант", "Создает 2 Сердца Души"},
	{"7", "VI - Влюблённые", "Создает 2 Красных Сердца"},
	{"8", "VII - Колесница", "Неуязвимость + контактный урон на 6 секунд"},
	{"9", "VIII - Правосудие", "Создает 1 бомбу, 1 ключ, 1 монету, 1 сердце"},
	{"10", "IX - Отшельник", "Телепортирует в магазин {{Shop}}, если он есть на уровне"},
	{"11", "X - Колесо фортуны", "Создает игровой автомат"},
	{"12", "XI - Сила", "↑ +1 к здоровью#↑ +0.3 к урону#↑ +50% множитель урона#↑ +5.25 дальность стрельбы#↑ +0.5 высоты слезы#↑ +0.3 к скорости#В пределах комнаты"},
	{"13", "XII - Повешенный", "Полет в пределах комнаты"},
	{"14", "XIII - Смерть", "Наносит 40 урона всем врагам в комнате"},
	{"15", "XIV - Умеренность", "Создает автомат для сдачи крови"},
	{"16", "XV - Дьявол", "↑ +2 к урону в пределах комнаты"},
	{"17", "XVI - Башня", "Создает 6 тролль-бомбы"},
	{"18", "XVII - Звёзды", "Телепортирует в {{TreasureRoom}} Комнату Сокровищ, если она есть на уровне"},
	{"19", "XVIII - Луна", "Телепортирует в {{SecretRoom}} Секретную Комнату"},
	{"20", "XIX - Солнце", "Наносит 100 урона всем врагам в комнате#Восстанавливает здоровье#Показывает всю карту уровня"},
	{"21", "XX - Суд", "Создает попрошайку"},
	{"22", "XXI - Мир", "Показывает всю карту уровня"},
	{"23", "Двойка Треф", "Удваивает количество ваших бомб"},
	{"24", "Двойка Бубен", "Удваивает количество ваших монет"},
	{"25", "Двойка Пик", "Удваивает количество ваших ключей"},
	{"26", "Двойка Червей", "Удваивает количество ваших красных сердцец#Лечит, но не создает новые сердца"},
	{"27", "Туз Треф", "Превращает все предметы на полу в бомбы"},
	{"28", "Туз Бубен", "Превращает все предметы на полу в монеты"},
	{"29", "Туз Пик", "Превращает все предметы на полу в ключи"},
	{"30", "Туз Червей", "Превращает все предметы на полу в сердца"},
	{"31", "Джокер", "Телепортирует в комнату Дьявола{{DevilRoom}}/Ангела{{AngelRoom}}"},
	{"32", "Хагалаз", "Уничтожает все камни в комнате"},
	{"33", "Йера", "Дублирует все предметы в комнате"},
	{"34", "Эваз", "Создает на полу люк на следующий уровень"},
	{"35", "Дагаз", "+1 Сердце Души#Снимает текущий эффект проклятия"},
	{"36", "Ансуз", "Открывает абсолютно всю карту уровня"},
	{"37", "Пертро", "Меняет артефакты на пьедесталах в комнате"},
	{"38", "Беркано", "Призывает 3 союзных мух и 3 союзных пауков"},
	{"39", "Альгиз", "Неуязвимость на 30 секунд"},
	{"40", "Пустая руна", "Эффект случайной руны"},
	{"41", "Черная руна", "Наносит урон всем врагам в комнате#Поглощает все артефакты в комнате#Взамен дает + к случайным характеистикам персонажа"},
	{"42", "Карта хаоса", "Выбрасывается и мгновенно убивает любого врага (даже Босса)"},
	{"43", "Кредитная карта", "Делает бесплатными все предметы в комнате#Работает как в магазине {{Shop}}, так и в комнате Дьявола {{DevilRoom}}"},
	{"44", "Карта правил", "Дает \"полезный\" совет"},
	{"45", "Карта против человечества", "Вся комната заполняется какашками"},
	{"46", "Карта Короля-самоубийцы", "Убивает вас и создает 10 предметов/артефактов в комнате"},
	{"47", "Свободный Выход", "Открывает все двери в комнате"},
	{"48", "? Карта", "Активирует ваш активный предмет без использования заряда"},
	{"49", "Осколок кости", "Меняет артефакты и предметы в комнате"},
	{"50", "Экстренный контакт", "Две Мамины Руки прижимают к земле случайных врагов"},
	{"51", "Святая карта", "Дает эффект Святой Мантии (блокирует урон и исчезает)#25% шанс создать ещё одну святую карту"},
	{"52", "Огромный рост", "↑ +7 к урону#↑ +30 дальность#Камни разрушаются при хождении по ним#Вы становитесь больше#Эффект остается в пределах коматы"},
	{"53", "Древний зов", "Создает на полу 3 случайные карты"},
	{"54", "Прогулка по эпохе", "Замедляет всех врагов#↑ +0.5 к скорости #↓ Снижает скорость стрельбы до 0.6#Эффект остается в пределах комнаты"}
}

---------- Pills ----------
EID.descriptions[languageCode].unidentifiedPill = "Неизвестная пилюля"

EID.descriptions[languageCode].pills={
	{"0", "Вонючий газ", " Создает облако ядовитого газа"},
	{"1", "Плохой приход", " Наносит урон в 1 сердце"},
	{"2", "Стальные яйца", " +2 Сердца Душ"},
	{"3", "Бомбы = Ключи", " Меняет количество имеющихся бомб и ключей местами"},
	{"4", "Взрывная диарея", " Создает 5 тролль-бомб"},
	{"5", "Полное здоровье", " Восстанавливает здоровье"},
	{"6", "- Здоровье", " ↓ -1 контейнер сердца"},
	{"7", "+ Здоровье", " ↑ +1 контейнер сердца"},
	{"8", "Я нашел пилюли", " Без эффекта"},
	{"9", "Зрелость", " 3 такие пилюли превратят вас во Взрослого (+1 к здоровью)"},
	{"10", "Милая мушка", " Дает 1 орбитальную муху"},
	{"11", "- Дальность", " ↓ -2 дальность стрельбы"},
	{"12", "+ Дальность", " ↑ +2.5 дальность стрельбы"},
	{"13", "- Скорость", " ↓ -0.12 скорость"},
	{"14", "+ Скорость", " ↑ +0.15 скорость"},
	{"15", "- Скорострельность", " ↓ -0.28 скорострельность"},
	{"16", "+ Скорострельность", " ↑ +0.35 скорострельность"},
	{"17", "- Удача", " ↓ -1 удача"},
	{"18", "+ Удача", " ↑ +1 удача"},
	{"19", "Телепилюли", " Телепортирует в случайную комнату#Имеет маленький шанс телепортировать тебя в комнату Я-ОШИБКА"},
	{"20", "Энергия на 48 часов", " Перезаряжает ваш активный предмет#Создает 1-2 батарейки"},
	{"21", "Кровавая рвота", " Опустошает все красные сердца, кроме одного#Создает 1-4 красных сердца на полу"},
	{"22", "Паралич", " Вас парализует на несколько секунд"},
	{"23", "Я могу видеть вечно", " Открывает все секретные комнаты на этаже"},
	{"24", "Феромоны", " Очаровавывает всех врагов в комнате"},
	{"25", "Амнезия", "Скрывает карту этажа (Проклятие Потерянного)"},
	{"26", "Лимонная вечеринка", "Создает под вами большую лужу на полу, которая наносит врагам урон"},
	{"27", "А ты волшебник?", "Стрельба по-диагонали#Эффект длится 30 секунд"},
	{"28", "Обезболивающее", "Любой урон в комнате отнимает половину сердца"},
	{"29", "Зависимый", "Любой урон в комнате отнимает целое сердце"},
	{"30", "Расслабься", "Под вами в течение 2 секунд появляются кучки"},
	{"31", "???", "Эффект Проклятия Путаницы (Maze) на весь этаж"},
	{"32", "Что-то делает тебя крупнее", "Вы становитесь больше#Не влияет на ваш хитбокс"},
	{"33", "Что-то делает тебя меньше", "Вы становитесь меньше#Ваш хитбокс становится меньше"},
	{"34", "Зараженный!", "Призывает 1 союзного паука на каждую кучку в комнате"},
	{"35", "Зараженный?", "Призывает 1 союзного паука на каждого врага в комнате"},
	{"36", "Пилюля силы!", "Короткая неуязвимость"},
	{"37", "Ретро зрение", "Делает экран пиксельным на 30 секунд"},
	{"38", "Друзья до конца!", "Призывает 3 союзных мух"},
	{"39", "Вялый", "Создает под вами скользкую лужу"},
	{"40", "Что-то не так...", "Создает под вами лужу из замедляющей слизи"},
	{"41", "Я сонный", "Замедляет всех врагов в комнате"},
	{"42", "Я возбужден!!!", "Ускоряет всех врагов в комнате"},
	{"43", "Глотай!", " Поглощает переносимые брелоки и дает их эффект навсегда"},
	{"44", "Хорф!", "Делает один выстрел рвотным корнем"},
	{"45", "Похоже, я иду на рассвет!", " Короткая неуязвимость"},
	{"46", "Вурп!", "Дает последнюю использованную пилюлю"}
}

---------- Sacrifice Room ----------
EID.descriptions[languageCode].sacrificeHeader = "[Комната жертвоприношений - следующая награда]"

EID.descriptions[languageCode].sacrifice={
	{"1", "", "50% шанс на 1 Монету#100% шанс на 1 Бомбу, если вы в Подвале 1 и убили Босса за 1 минуту"},
	{"2", "", "50% шанс на 1 Монету#100% шанс на 1 Бомбу, если вы в Подвале 1 и убили Босса за 1 минуту"},
	{"3", "", "67% вероятность повысить шанс появления {{AngelRoom}}Комнаты Ангела"},
	{"4", "", "50% шанс на 1 случайный сундук"},
	{"5", "", "33% шанс на 3 монеты#67% вероятность повысить шанс появления {{AngelRoom}} Комнаты Ангела"},
	{"6", "", "33% шанс телепортироваться в комнату {{AngelRoom}} Ангела или {{DevilRoom}} Дьявола#67% шанс на случайный сундук"},
	{"7", "", "33% шанс на 1 случайный предмет из {{AngelRoom}} Комнаты Ангела#67% шанс на 1 синее сердце"},
	{"8", "", "100% шанс появления 7 тролль-бомб"},
	{"9", "", "100% шанс появления ангела \"Уриил\""},
	{"10", "", "50% шанс на 7 синих сердец#50% шанс на 30 монет"},
	{"11", "", "100% шанс появления ангела \"Гавриил\""},
	{"12", "", "50% шанс телепортироваться на этаж \"Темная комната\""},
}

---------- Dice Room ----------
EID.descriptions[languageCode].diceHeader = "[Комната игральной кости]"

EID.descriptions[languageCode].dice={
	{"1", "", "Меняет все пассивные и активный артефакты персонажа на случайные из пула той комнаты, в которой они были получены"},
	{"2", "", "Меняет все подбираемые предметы в данной комнате"},
	{"3", "", "Меняет все подбираемые предметы на данном этаже#Не влияет на комнаты {{DevilRoom}} Дьявола/{{AngelRoom}} Ангела"},
	{"4", "", "Меняет все артефакты, находящиеся на данном этаже#Не влияет на комнаты {{DevilRoom}} Дьявола/{{AngelRoom}} Ангела, {{Shop}} Магазин и {{Library}} Библиотеку"},
	{"5", "", "Меняет и заново генерирует весь этаж"},
	{"6", "", "Меняет артефакты персонажа на случайные, а также предметы и артефакты на данном этаже"},
}

---------- Transformations ----------
EID.descriptions[languageCode].transformations={
	"",						-- 0 = none
	"Гаппи",				-- 1
	"Весельчак",			-- 2
	"Вельзевул",			-- 3
	"Соединенный",			-- 4
	"Передозировка",		-- 5
	"Да, Мама?!",			-- 6
	"Вот Дерьмо!",			-- 7
	"Боб",					-- 8
	"Левиафан",				-- 9
	"Серафим",				-- 10
	"Супер Бездельник",		-- 11
	"Книжный Червь",		-- 12
	"Малыш-Паук",			-- 13
	"Взрослый",				-- 14
	"Топтун",				-- 15
}


---------- MISC ----------

EID.descriptions[languageCode].VoidText = "Если поглощён, даёт:"
EID.descriptions[languageCode].VoidNames = {"Скорость", "Скорострельность", "Урон", "Дальность", "Скорость снаряда", "Удача"}

EID.descriptions[languageCode].CollectionPageInfo = "Этот предмет нужно подобрать для коллекции!"

EID.descriptions[languageCode].MCM = {
	DemoObjectName = "Демо имя объекта",
	DemoObjectTransformation = "Демо траснформация",
	DemoObjectText = "Это текст на русском#Очень крутое и длинное описание для симуляции конца линий, образованных шириной текстового окна EID!#{{Collectible4}} Это тоже крутая линия#{{Heart}} Эта линия тебя любит ;)#{{AngelDevilChance}} Эта линия может быть твоим ангелом или дьяволом#\1 {{Damage}} +1 к характеристике",
}
