---------------------------------------
-----  Basic Spanish descriptions  ----
---------------------------------------

-- FORMAT: Item ID | Name | Description

-- Special character markup:
-- ↑ = Up Arrow  |  ↓ = Down Arrow  |  ! = Warning  |  # = Starts a new line
-- More can be found here: https://github.com/wofsauge/External-Item-Descriptions/wiki/Markup

local languageCode = "spa"

-- init spa table
EID.descriptions[languageCode] = {}
EID.descriptions[languageCode].custom = {} -- table for custom entity descriptions
EID.descriptions[languageCode].languageName = "Spanish"

-- Fonts to be used with this language pack
EID.descriptions[languageCode].fonts = EID.descriptions["en_us"].fonts

---------- Collectibles ----------
EID.descriptions[languageCode].collectibles={
	{"1", "Cebolla triste", "↑ {{Tears}} Lágrimas +0.7"},
	{"2", "El Ojo Interior", "Disparo triple#↓ {{Tears}} Menos lágrimas"},
	{"3", "Doblador de cucharas", "Lágrimas teledirigidas"},
	{"4", "Cabeza de Cricket", "↑ {{Damage}} Daño x1.5 + 0.5#↑ Más empuje"},
	{"5", "Mi reflejo", "Otorga un efecto boomerang a las lágrimas#↑ {{Range}} Alcance +1.5#↑ {{Shotspeed}} Vel. de tiro +0.6#↑ {{Tearsize}} Tamaño de lágrimas +1"},
	{"6", "Número 1", "↑{{Tears}} Lágrimas +1.5#↓ {{Range}} Alcance -15,78#↑ {{Tearsize}} Tamaño de lágrimas +0.45"},
	{"7", "Sangre del mártir", "↑ {{Damage}} Daño +1.0#"},
	{"8", "Hermano Bobby", "Familiar de lágrimas normales#Lágrimas de 3,5 de daño"},
	{"9", "Escatol", "Todas las moscas enemigas son aliadas"},
	{"10", "Halo de moscas", "+2 moscas orbitales#Bloquea proyectiles enemigos"},
	{"11", "¡+1!", "↑ +1 de vida#Reaparece con la vida al completo"},
	{"12", "Hongo mágico", "↑ +1 de vida#↑ {{Speed}} Velocidad +0.3#↑ {{Range}} Alcance +5.25#↑ {{Damage}} Daño x1.5 + 0.3#↑ {{Tearsize}} Tamaño de lágrimas +0.5#¡Vida al completo!"},
	{"13", "El virus", "Toque venenoso#↓ {{Speed}} Velocidad -0.1#{{BlackHeart}} Los enemigos pueden soltar corazones negros al morir si están envenenados"},
	{"14", "Furia por esteroides", "↑ {{Speed}} Velocidad +0.6#↑ {{Range}} Alcance +5.25#↑{{Tearsize}} Tamaño de lágrimas +0.5"},
	{"15", "<3", "↑ +1 de vida#Vida al completo"},
	{"16", "Hígado crudo", "↑ +2 de vida#Vida al completo"},
	{"17", "Llave esquelética", "+99 llaves"},
	{"18", "Un dólar", "+99 monedas"},
	{"19", "¡Buum!", "+10 bombas"},
	{"20", "Transcendencia", "¡Vuela!"},
	{"21", "La Brújula", "Muestra todos los iconos del mapa#No muestra el plano del mapa"},
	{"22", "Almuerzo", "↑ +1 de vida"},
	{"23", "Cena", "↑ +1 de vida"},
	{"24", "Postre", "↑ +1 de vida"},
	{"25", "Desayuno", "↑ +1 de vida"},
	{"26", "Carne podrida", "↑ +1 de vida"},
	{"27", "Cuchara de madera", "↑ {{Speed}} Velocidad +0.3"},
	{"28", "El cinturón", "↑ {{Speed}} Velocidad +0.3"},
	{"29", "Ropa interior de Mamá", "↑ {{Range}} Alcance +5.25#↑ {{Tearsize}} Tamaño de lágrimas +0.5"},
	{"30", "Tacones de Mamá", "↑ {{Range}} Alcance +5.25#↑ {{Tearsize}} +0.5"},
	{"31", "Pintalabios de Mamá", "↑ {{Range}} Alcance +5.25#↑ {{Tearsize}} Tamaño de lágrimas +0.5"},
	{"32", "Percha de Alambre", "↑ {{Tears}} Lágrimas +0.7"},
	{"33", "La Biblia", "Vuela en la habitación actual#Mata el Pie de Mamá y el Corazón de Mamá al instante#!!! Te mata al usarlo contra Satán"},
	{"34", "Libro de Belial", "↑ {{Damage}} Daño +2#↑ {{DevilChance}} +12.5% de probabilidad de Pacto con el Diablo"},
	{"35", "El Necronomicón", "Inflige 40 de daño a toda la habitación"},
	{"36", "La Popó", "Genera una caca en el suelo#Se puede poner al lado de una fosa y destruirla con una bomba para hacer un puente"},
	{"37", "Sr. Buum", "Genera una gran bomba bajo el jugador que inflige 110 de daño"},
	{"38", "Cabeza de Tammy", "Dispara un círculo de 10 lágrimas alrededor de Isaac"},
	{"39", "Sostén de Mamá", "Congela a todos los enemigos de la habitación durante 4 segundos"},
	{"40", "¡Kamikaze!", "Provoca una explosión en la ubicación del jugador"},
	{"41", "Toallita de Mamá", "Asusta a todos los enemigos de la habitación actual durante 5 segundos"},
	{"42", "Cabeza podrida de Bob", "Bomba venenosa lanzable"},
	{"43", "", "<No existe el objeto>"},
	{"44", "¡Teletransporte!", "Teletransporta a Isaac a una habitación aleatoria (excepto a la habitación I AM ERROR)"},
	{"45", "Delicioso Corazón", "Cura 1 corazón rojo"},
	{"46", "Pie de la suerte", "↑ {{Luck}} Suerte +1.0#Más probabilidad de ganar al apostar#Aumenta las posibilidades de que caiga un recolectable al limpiar una habitación#Cierta posibilidad de cambiar las píldoras malas por buenas"},
	{"47", "Control Remoto de Doctor", "¡Epic Fetus (Feto épico) a la carta!#Ataques aéreos dirigidos"},
	{"48", "Flecha de Cupido", "Lágrimas penetrantes"},
	{"49", "Kamehame... ¡¿Eeeeeeh?!", "Rayo de Brimstone (Fuego infernal) con gran daño"},
	{"50", "Steven", "↑ {{Damage}} Daño +1"},
	{"51", "Pentáculo", "↑ {{Damage}} +1,0 de daño#↑ {{DevilChance}} Probabilidad de Pacto con el Diablo +10%"},
	{"52", "Dr. Fetus", "¡Lágrimas bomba!"},
	{"53", "Magneto", "Acerca los recolectables al jugador"},
	{"54", "Mapa del tesoro", "Muestra el plano del mapa"},
	{"55", "Ojo de Mamá", "Posibilidad de disparar una lágrima hacia atrás#{{Luck}} 100 % de probabilidad si tienes 2 de suerte"},
	{"56", "Accidente de Limón", "Crea una piscina de limonada#Inflige 66 de daño por contacto cada segundo"},
	{"57", "Admiración lejana", "Mosca orbital de medio alcance#Inflige 75 de daño por contacto cada segundo"},
	{"58", "Libro de las Sombras", "Invencibilidad durante 10 segundos"},
	{"59", "", "<No existe el objeto>"},
	{"60", "La escalera", "Camina sobre fosas de 1 cuadrado de distancia"},
	{"61", "", "<No existe el objeto>"},
	{"62", "Encanto del Vampiro", "Cura medio corazón cada 13 enemigos asesinados"},
	{"63", "La batería", "El objeto activable se puede cargar el doble"},
	{"64", "Rebajas de Steam", "-50 % en la compra de objetos#Tener dos hace que todo sea gratis"},
	{"65", "Recetario de Anarquista", "Genera 6 bombas troll cerca del centro de la habitación"},
	{"66", "El reloj de arena", "Ralentiza a los enemigos durante 8 segundos"},
	{"67", "Hermana Maggy", "Familiar de lágrimas normales#Inflige 3,5 de daño"},
	{"68", "Tecnología", "Las lágrimas son láseres"},
	{"69", "Batido de chocolate", "Carga las lágrimas#↑ Hasta un 400 % más de daño#↓ Menos lágrimas"},
	{"70", "Hormonas de crecimiento", "↑ {{Damage}} Daño +1.0#↑ {{Speed}} Velocidad +0.4"}, --Hasta acá lo dejaré por hoy
	{"71", "Honguito", "↑ {{Speed}} Velocidad +0.3#↓ {{Range}} Alcance -4.25#↑ {{Tearsize}} Tamaño de lágrimas +1.5# ↑ Te haces más pequeño"},
	{"72", "Rosario", "{{SoulHeart}}+3 corazones de alma#La Biblia es más común"},
	{"73", "Cubo de carne", "NVL1: Orbital#NVL2: Orbital que dispara#NVL3: Meat boy NVL 1#NVL4: Meat boy NVL 2"},
	{"74", "Un cuarto", "+25 monedas"},
	{"75", "PHD", "Mejores píldoras# +1 píldora#Cura 2 corazones#Más dinero de las máquinas de donación de sangre"},
	{"76", "Visión de rayos X", "Muestra las entradas de salas secretas"},
	{"77", "Mi pequeño unicornio", "Invencibilidad + 40 de daño por contacto"},
	{"78", "Libro de Revelaciones", "+{{SoulHeart}} 1 corazón de alma# Más probabilidad de que aparezcan jinetes#↑ {{DevilChance}} +17,5 % probabilidad de Pacto con el Diablo"},
	{"79", "La marca", "↑ {{Speed}} Velocidad +0.2#↑ {{Damage}} Daño +1.0#{{SoulHeart}}+1 corazón de alma"},
	{"80", "El pacto", "↑ {{Damage}} Daño +0.5#↑ {{Tears}} Lágrimas +0.7#{{SoulHeart}} +2 corazones de alma"},
	{"81", "Gato muerto", "↑ +9 vidas#Revive con 1 corazón"},
	{"82", "Señor del Abismo", "Vuela#↑ {{Speed}} Velocidad +0.3"},
	{"83", "El clavo", "{{SoulHeart}} +1 corazón de alma#↓ {{Speed}} Velocidad -0.18#↑ {{Damage}} Daño +0.7#Inflige daño por contacto#Rompe rocas"},
	{"84", "¡Necesitamos Ir Más Profundo!", "Genera una trampilla para saltar el nivel#10 % de probabilidad de que se abra una trampilla a una planta secreta"},
	{"85", "Mazo de cartas", "{{Card}} Genera 1 carta"},
	{"86", "Diente de Monstro", "Invoca a Monstro y este aplasta a un enemigo"},
	{"87", "Cuernos de Loki", "Posibilidad de disparar en 4 direcciones"},
	{"88", "Pequeño Chubby", "Familiar que carga hacia delante#Inflige 52,5 de daño por contacto cada segundo, 3,5 por tick"},
	{"89", "Picadura de araña", "Ralentiza a los enemigos"},
	{"90", "La Roca pequeña", "↓ {{Speed}} Velocidad -0.2#↑ {{Damage}} Daño +1↑ {{Tears}} Lágrimas +0.2#"},
	{"91", "Sombrero de espeleólogo", "Muestra lo que hay detrás de las puertas#Salas secretas, ultrasecretas y salas de minijefes"},
	{"92", "Super Vendaje", "↑ +1 de vida#{{SoulHeart}}+2 corazones de alma"},
	{"93", "El Gamekid", "Invencibilidad +daño por contacto#Comerse un enemigo recupera vida"},
	{"94", "Bolsa de centavos", "Suelta una moneda aleatoria cada 2 habitaciones"},
	{"95", "Robo-Baby", "Lágrimas láser#Inflige 3,5 de daño"},
	{"96", "Pequeño C.H.A.D.", "Suelta medio corazón cada 3 habitaciones"},
	{"97", "El Libro del Pecado", "Genera un recolectable aleatorio"},
	{"98", "La Reliquia", "{{SoulHeart}} Suelta 1 corazón de alma cada 4 habitaciones"},
	{"99", "Pequeño Gish", "Lágrimas ralentizantes#Inflige 3,5 de daño"},
	{"100", "Pequeño Steven", "Lágrimas teledirigidas#Inflige 3,5 de daño"},
	{"101", "El Halo", "↑ + 1 de vida#↑ {{Speed}} Velocidad +0.3#↑ {{Damage}} Daño +0.#↑ {{Tears}} Lágrimas +0.2#↑ {{Range}} Alcance +0.25#↑ {{Tearsize}} Tamaño de lágrimas +0.5"},
	{"102", "Botella de Píldoras de Mamá", "Genera 1 píldora"},
	{"103", "El Resfriado Común", "Lágrimas venenosas (aleatorio)"},
	{"104", "El parásito", "Las lágrimas se rompen al chocar#Las lágrimas partidas infligen la mitad de daño"},
	{"105", "El D6", "Cambia los pedestales de la habitación actual"},
	{"106", "Sr. Mega", "↑ x2,25 el daño de bomba #+5 bombas"},
	{"107", "Las Tijeras Dentadas", "Vuela#Tu cuerpo ataca a los enemigos e inflige 82,5 de daño por segundo"},
	{"108", "La Hostia", "Todo el daño recibido se reduce a medio corazón"},
	{"109", "Dinero = Poder", "↑ {{Damage}} +0,04 de daño por cada moneda que tengas"},
	{"110", "Lentillas de Mamá", "Probabilidad de disparar lágrimas congelantes#↑ {{Range}} Alcance +0.25#↑ {{Tearsize}} Tamaño de lágrimas +0.5"},
	{"111", "El frijol", "Pedo venenoso"},
	{"112", "Ángel Guardián", "Orbital#Acelera todos los orbitales#Bloquea proyectiles#Inflige 105 de daño por contacto cada segundo"},
	{"113", "Bebé Demonio", "Torreta que dispara automáticamente#Inflige 3 de daño"},
	{"114", "Cuchillo de Mamá", "{{Chargeable}} Cargable#Cuchillo controlable#{{Damage}} El daño varía dependiendo de la distancia a la que se lance#{{Damage}} Daño al contacto (sin lanzarlo) x2#{{Damage}} Daño x6 al recorrer su máxima distancia"},
	{"115", "Tabla Ouija", "Lágrimas espectrales"},
	{"116", "9 voltios", "-1 carga para los objetos activables#Carga al completo el objeto actual"},
	{"117", "Ave Muerta", "Cuando te golpean genera un pájaro#El pájaro inflige 4 de daño por contacto cada segundo"},
	{"118", "Azufre", "{{Chargeable}} Cargable#Dispara un chorro de sangre que inflige daño constante"},
	{"119", "Bolsa de Sangre", "↑ {{Heart}} +1 de vida#↑ {{Speed}} +0,3 de velocidad# {{Heart}} Cura 5 corazones"},
	{"120", "Hongo Raro", "↑ {{Speed}} Velocidad +0.3#↑ {{Tears}} Lágrimas +1.7#↓ {{Damage}} Daño x0.90 - 0.4"},
	{"121", "Hongo Raro", "↑ +1 contenedor de corazon vacío#↓ {{Speed}} Velocidad -0.1#↑ {{Range}} Alcance +0.25#↑ {{Damage}} Daño +0.3#↑ {{Tearsize}} Tamaño de lágrimas +0.5"},
	{"122", "Ramera de Babilonia", "!!! Al tener medio corazón:#↑ {{Speed}} Velocidad +0.3#↑ {{Damage}} Daño +1.5#Se activa automáticamente con personajes que no poseen salud roja"},
	{"123", "Manual de monstruos", "Familiar aleatorio en la habitación actual"},
	{"124", "Pergaminos del Mar Muerto", "Efecto de objeto activo aleatorio"},
	{"125", "Bobby-Bomba", "Bombas teledirigidas#+5 Bombas"},
	{"126", "Hoja de Afeitar", "↑ +1,2 de daño en la habitación actual#↓ Te inflige 1 corazón de daño"},
	{"127", "Olvídame Ya", "{{Warning}} UN SOLO USO {{Warning}} #Reinicia toda la planta"},
	{"128", "Siempre solo", "Mosca orbital de larga distancia #Inflige 30 de daño por contacto cada segundo"},
	{"129", "Cubo de manteca", "↑ +2 de contenedores de vida vacíos#↓ -0,2 de velocidad#Cura medio corazón"},
	{"130", "Un poni ", "Permite volar mientras lo tengas#Establece tu velocidad en 1,5 en caso de que tengas menos que eso#Embiste en una dirección"},
	{"131", "Bolsa de Bombas", "Deja caer 1 bomba cada pocas habitaciones"},
	{"132", "Un Trozo de Carbón", "Más daño basado en la distancia que recorra la lágrima"},
	{"133", "Pata de Guppy", "!!! Convierte:#1 corazón rojo en 3 corazones de alma"},
	{"134", "Cola de Guppy", "Aparecen más cofres dorados#Menos llaves"},
	{"135", "Bolsa I.V.", "Banco de sangre portátil#Medio corazón = 1-3 monedas"},
	{"136", "Mejor Amigo", "Muñeco explosivo#Atrae a los enemigos"},
	{"137", "Detonador remoto", "Detona bombas al gusto#+5 bombas"},
	{"138", "Estigma", "↑ {{Heart}} +1 de vida#↑ {{Damage}} Daño +0.3"},
	{"139", "Bolso de Mamá", "Puedes tener 2 trinkets"},
	{"140", "Maldición de Bob", "Bombas venenosas#+5 bombas"},
	{"141", "Chico del desfile", "Genera 7 monedas aleatorias"},
	{"142", "Escapulario", "Si te dañan menos de medio corazón, ganas 1 corazón de alma#(Uno por habitación)"},
	{"143", "Bola Rápida", "↑ {{Speed}} Velocidad +0.3#↑ {{Shotspeed}} Vel. de tiro +0.2"},
	{"144", "Amigo Pordiosero", "Convierte monedas en recolectables"},
	{"145", "Cabeza de Guppy", "Genera de 2 a 4 moscas azules"},
	{"146", "Carta de Plegaria", "+1 corazón eterno"},
	{"147", "Pico de Notch", "Rompe las rocas de la habitación actual al tocarlas"},
	{"148", "Infestación", "Genera moscas cuando te golpean"},
	{"149", "Ipecac", "Lágrimas explosivas#{{Poison}} Lágrimas venenosas#↓ {{Tears}} Lágrimas -66% aproximadamente#↑ {{Damage}} Daño +40"},
	{"150", "Amor Rudo", "Posibilidad de disparar dientes#{{Damage}} El diente inflinge tu daño x3.2"},
	{"151", "Miasis", "1/6 de probabilidad de generar una mosca al golpear un enemigo"},
	{"152", "Tecnología 2", "¡Láser permanente!#↓ {{Damage}} Daño -35%"},
	{"153", "Araña mutante", "¡Disparo cuádruple!#↓ {{Tears}} Menos lágrimas"},
	{"154", "Exfoliación química", "↑ +2 de daño para el ojo izquierdo"},
	{"155", "El fisgón", "Flota por la habitación#Inflige 8 de daño por contacto cada segundo"},
	{"156", "Hábito", "{{Battery}} Recibes una carga de tu objeto activo al recibir daño"},
	{"157", "Lujuria de Sangre", "↑ {{Damage}} Más daño cuando te golpean#Se aplica hasta 6 veces en cada planta#Dura toda la planta"},
	{"158", "Bola de cristal", "Muestra el mapa completo#Puede generar: #{{Card}} una carta aleatoria# {{SoulHeart}} Un corazón de alma"},
	{"159", "Espíritu de la noche", "Vuela#Lágrimas espectrales"},
	{"160", "Desgarra el Cielo", "¡5 rayos de luz desde el cielo!#Inflige tu daño +20"},
	{"161", "Anj", "{{Player4}} Reapareces como ??? al morir"},
	{"162", "Cruz celta", "Probabilidad de ser invencible cuando te golpean"},
	{"163", "Bebé fantasma", "Familiar de lágrimas espectrales#Inflige 3,5 de daño"},
	{"164", "La Vela", "Genera un fuego azul#Inflige daño por contacto#Bloquea lágrimas enemigas#Desaparece tras 2 segundos"},
	{"165", "Gato de nueve colas", "↑ {{Damage}} Daño +1#↑ {{Shotspeed}} Vel. de tiro +0.23"},
	{"166", "D20", "Cambia los recolectables"},
	{"167", "Bebé arlequín", "Dispara dos lágrimas en forma de V#Inflige 4 de daño"},
	{"168", "Fetus épico", "Ataque aéreo controlable en lugar de lágrimas#Inflige 20 veces tu daño"},
	{"169", "Polifemo", "¡Mega lágrimas!#↑ {{Damage}} Daño +4 x2#↓ {{Tears}} Menos lágrimas"},
	{"170", "Papá Patas-largas", "Cae sobre los enemigos#Inflige 40 de daño cada segundo"},
	{"171", "Trasero Aracnido", "{{Slow}} Ralentiza a los enemigos cada 4 segundos#10 de daño a todos los enemigos"},
	{"172", "Daga de Sacrificio", "Cuchillo orbital#Bloquea los disparos enemigos#Inflige 225 de daño cada segundo"},
	{"173", "Mitra", "{{SoulHeart}} Mayor probabilidad de encontrar corazones de alma"},
	{"174", "Bebé arcoiris", "Dispara lágrimas aleatorias#Inflige de 3 a 5 de daño"},
	{"175", "Llave de Papá", "Abre todas las puertas de la habitación actual, incluyendo las salas secretas#Puede abrir la puerta de Mega Satán"},
	{"176", "Células madre", "↑ {{Heart}} +1 de vida#↑ {{Shotspeed}} Vel. de tiro +0.16"},
	{"177", "Tragamonedas portátil", "Cambia una moneda por un recolectable aleatorio"},
	{"178", "Agua bendita", "Deja un rastro de creep cuando te golpean#Inflige 24 daño cada segundo"},
	{"179", "Destino", "Vuela#+1 corazón eterno"},
	{"180", "El frijol negro", "Te tiras un pedo cuando te tocan"},
	{"181", "Poni blanco", "Permite volar mientras lo tengas#{{Speed}} Establece tu velocidad en 1.5 si tienes menos de eso#Aparecen rayos de luz al embestir"},
	{"182", "Sagrado corazón", "Lágrimas teledirigidas#↑ {{Heart}} +1 de vida#↑ {{Range}} Alcance +4.125#↓ {{Tears}} Lágrimas -0.4#↓ {{Shotspeed}} Vel. de tiro -25%#↑ {{Damage}} Daño +1 x 230%"},
	{"183", "Mondadientes", "↑ {{Tears}} Lágrimas +0.7 de lágrimas#↑ {{Shotspeed}} Vel. de tiro +0.16"},
	{"184", "Santo Grial", "↑ +1 de vida#Permite volar"},
	{"185", "Paloma muerta", "Vuela#Lágrimas espectrales"},
	{"186", "Derecho de sangre", "Inflige 40 de daño a cada enemigo#Te daña al usarlo"},
	{"187", "Bola de pelo de Guppy", "Bola de pelo creciente#Se mueve a tu alrededor#Crece al matar enemigos#Hace más daño cuanto más grande sea"},
	{"188", "Abel", "Copia tus movimientos#Dispara hacia el jugador#Inflige 3,5 de daño"},
	{"189", "Súper Fan de SMB", "↑ +1 de vida#↑{{Speed}} Velocidad +0.2#↑ {{Range}} Alcance +0.5#↑ {{Tears}} Lágrimas +0.2#↑ {{Damage}} Daño +0.3#↑ {{Tearsize}} Tamaño de lágrimas +1.0#Vida al completo"},
	{"190", "Piro", "{{Bomb}} +99 Bombas"},
	{"191", "Billete de 3 dólares", "Efecto de lágrima aleatorio"},
	{"192", "Telepatía para Tontos", "Lágrimas teledirigidas en la habitación actual"},
	{"193", "¡CARNE!", "↑ {{Heart}} +1 de vida#↑ {{Damage}} Daño +0.3"},
	{"194", "Bola 8 mágica", "↑ {{Shotspeed}} Vel. de tiro +0.16#{{Card}} +1 carta"},
	{"195", "Monedero de Mamá", "Genera 4 píldoras"},
	{"196", "Squeezy", "+2 corazones de alma#↑ {{Tears}} Lágrimas +0.4"},
	{"197", "Jugo de Jesús", "↑ {{Range}} Alcance +0.25#↑ {{Damage}} Daño +0.5#↑ {{Tearsize}} Tamaño de lágrimas +0.5"},
	{"198", "Caja", "Genera 1 recolectable de cada tipo"},
	{"199", "Llave de Mamá", "+2 llaves#Los cofres generan más recolectables"},
	{"200", "Sombra de ojos de Mamá", "Posibilidad de disparar lágrimas encantadas"},
	{"201", "Barra de hierro", "↑ {{Damage}} Daño +0.3#{{Confusion}} Posibilidad de aturdir a los enemigos"},
	{"202", "Toque de Midas", "Convierte a los enemigos en oro al tocarlos#Inflige daño de contacto basado en tu dinero#Los enemigos dorados dejan caer monedas"},
	{"203", "Paquete modesto", "Duplica todos los recolectables"},
	{"204", "Riñonera", "50 % de probabilidad de generar un recolectable aleatorio cuando te golpean"},
	{"205", "Enchufe Afilado", "-2 corazones = Carga el objeto al completo cuando pulsas espacio#!!! Solo funciona si el objeto no está cargado"},
	{"206", "Guillotina", "↑ {{Tears}} Más lágrimas#↑ {{Damage}} Daño +1#Tu cabeza es un orbital#Disparas desde la cabeza#La cabeza inflige daño por contacto"},
	{"207", "Bola de vendas", "NVL1: Orbital#NVL2: Orbital que dispara#NVL3: Bandage girl#NVL4: Bandage girl NVL2"},
	{"208", "Cinturón de campeón", "↑ {{Damage}} Daño +1#!!! Aparecen más campeones"},
	{"209", "Bombas de Trasero", "↑ +5 Bombas#Las explosiones aturden y dañan a todos los enemigos de la habitación"},
	{"210", "Hoja roída", "Invencible al quedarse quieto por 1 segundo"},
	{"211", "Bebé-araña", "Genera una o dos arañas cuando te golpean"},
	{"212", "Collar de Guppy", "↑ 50% de probabilidad de revivir"},
	{"213", "Lentilla perdida", "Lágrimas con escudo que bloquean los disparos enemigos#↓ {{Shotspeed}} Vel. de tiro -0.16"},
	{"214", "Anémico", "↑ {{Range}} Alcance +5 #Deja creep en el suelo cuando te golpean"},
	{"215", "Cabeza de cabra", "↑ {{DevilChance}}/{{AngelChance}} 100 % de probabilidad de pacto con el Diablo o el Ángel{"},
	{"216", "Manto Ceremonial", "↑ {{BlackHeart}} +3 Corazones negros#↑ {{Damage}} Daño +1"},
	{"217", "Peluca de Mamá", "Probabilidad aleatoria de generar una araña azul al disparar#{{Heart}} Cura 1 corazón al tomarlo"},
	{"218", "Placenta", "Regenera la vida poco a poco#↑ +1 de vida"},
	{"219", "Vendaje Viejo", "↑ +1 contenedor de corazón vacío#Probabilidad aleatoria de dejar caer corazones cuando te golpean"},
	{"220", "Bombas Tristes", "¡Explosión de lágrimas!#+5 Bombas"},
	{"221", "Pegamento Elástico", "Las lágrimas rebotan"},
	{"222", "Anti-Gravedad", "↑ {{Tears}} Lágrimas +2#Lágrimas antigravedad"},
	{"223", "Piromaníaco", "{{Heart}} Las explosiones curan 1 corazón rojo#↑ {{Bomb}} +5 Bombas"},
	{"224", "Cuerpo de Cricket", "↑ +1 de lágrimas#↓ -10 de Alcance#Las lágrimas se dividen en 4 al impactar#Las lágrimas partidas infligen la mitad de daño"},
	{"225", "Máscara BDSM", "Posibilidad de dejar caer corazones de alma o negros cuando te golpean#Posibilidad de dejar caer medio corazón rojo al matar a un enemigo"},
	{"226", "Loto Negra", "↑ {{Heart}} +1 de vida#↑ {{SoulHeart}} +1 corazón de alma#↑ {{BlackHeart}} +1 corazón negro"},
	{"227", "El Cochinito", "+3 monedas#Genera una o dos monedas cuando te golpean"},
	{"228", "Perfume de Mamá", "Las lágrimas asustan a los enemigos#↑ {{Tears}} Lágrimas +1"},
	{"229", "Pulmón de Monstro", "Las lágrimas pueden cargarse y lanzarse como si fuera una escopeta"},
	{"230", "Abaddón", "#↑ {{Speed}} Velocidad +0.2#↑ {{Damage}} Daño +1.5#Las lágrimas asustan a los enemigos#↓ Elimina todos los corazones rojos#↑ {{BlackHeart}} +6 corazones negros"},
	{"231", "Bola de alquitrán", "Deja creep que ralentiza#Las lágrimas ralentizan"},
	{"232", "Cronómetro", "{{Slow}} Ralentiza automáticamente (se activa por primera vez cuando te golpean)#↑ {{Speed}} Velocidad +0.3"},
	{"233", "Mini-Planeta", "Las lágrimas orbitan a tu alrededor#↑ {{Tearsize}} Tamaño de lágrima +7.0#Lágrimas espectrales"},
	{"234", "Infestación 2", "Al matar a un enemigo genera arañas "},
	{"235", "", "<El objeto no existe>"},
	{"236", "E. Coli", "Al tocar a los enemigos los convierte en caca"},
	{"237", "Toque de la Muerte", "¡Dispara guadañas!#↑ {{Damage}} Daño +1.5#↓ {{Tears}} Lágrimas -0.3#Lágrimas penetrantes"},
	{"238", "Trozo de Llave 1", "!!! ¡Pieza de llave para la puerta de Mega Satán!#Aparecen más salas del Ángel{{AngelRoom}}"},
	{"239", "Trozo de Llave 2", "!!! ¡Pieza de llave para la puerta de Mega Satán!#Aparecen más salas del Ángel{{AngelRoom}}"},
	{"240", "Tratamiento experimental", "Todas las estadísticas ↑/↓ un número aleatorio"},
	{"241", "Contrato de Abajo", "Duplica los recolectables generen las salas#{{GreedMode}} / {{GreedierMode}} No funciona en el modo Codicia"},
	{"242", "Infamia", "50 % de posibilidad de bloquear lágrimas"},
	{"243", "Escudo de Trinidad", "Escudo que bloquea lágrimas"},
	{"244", "Tech.5", "Dispara lágrimas láseres aleatorias"},
	{"245", "20/20", "Duplica los disparos"},
	{"246", "Mapa azul", "Muestra las habitaciones secretas"},
	{"247", "Amigos X siempre", "Tus familiares infligen más daño"},
	{"248", "Mente de Colmena", "Las moscas y arañas azules duplican su daño"},
	{"249", "Hay opciones", "Aparecen 2 objetos de jefe en lugar de 1#!!! Solo puede cogerse uno"},
	{"250", "Bombas 2x1", "Duplica todas las bombas que cojas"},
	{"251", "Mazo inicial", "{{Card}} Puedes llevar 2 cartas#Convierte todas las píldoras en cartas"},
	{"252", "Pequeña bolsa", "{{Pill}} Puedes llevar 2 píldoras#Convierte todas las cartas en píldoras"},
	{"253", "Costra mágica", "↑ +1 de suerte#↑ +1 de vida"},
	{"254", "Coágulo", "↑ {{Damage}} Daño +1#↑ {{Range}} Alcance +5#!!! Solo se aplica al ojo izquierdo"},
	{"255", "Tornillo", "↑ {{Tears}} Lágrimas +0.5#↑ {{Shotspeed}} Vel. de tiro +0.2"},
	{"256", "Bombas Ardientes", "{{Burning}} Las bombas queman#+5 Bombas"},
	{"257", "Mente en llamas", "{{Burning}} Las lágrimas están en llamas#Posibilidad de que las lágrimas exploten"},
	{"258", "Missing No.", "Cambia todos tus objetos cada vez que cambias de planta"},
	{"259", "Materia oscura", "↑ {{Damage}} Daño +1#{{Fear}} Las lágrimas asustan a los enemigos"},
	{"260", "Vela negra", "{{CurseCursed}} Inmune a las maldiciones#↑ {{BlackHeart}} +1 corazón negro#{{DevilChance}}/{{AngelChance}} Más probabilidad de que aparezcan las salas del Diablo o del Ángel"},
	{"261", "Proptosis", "↑{{Damage}} Daño +100%#↓ El daño infligido disminuye en función de la distancia recorrida por la lágrima"},
	{"262", "Hoja 2 faltante", "{{BlackHeart}} +1 corazón negro#Al tener menos de 1 corazón y medio, dañas a todos los enemigos de la habitación"},
	{"263", "", "<El objeto no existe>"},
	{"264", "Mosca Inteligente", "Orbital que puede cargar contra los enemigos#Inflige 22,5 de daño cada segundo#Inflige 1,5 de daño por tick"},
	{"265", "Bebé Seco", "Al ser golpeado por lágrimas enemigas, hay un 10% de posibilidad de dañar a todos los enemigos de la habitación"},
	{"266", "Nido jugoso", "Deja creep ralentizante#Posibilidad de generar 1 o 2 arañas aliadas al limpiar la habitación"},
	{"267", "Robo-Baby 2.0", "Dispara láseres#Inflige 3,5 de daño por disparo#Se mueve hacia donde disparas"},
	{"268", "Bebé Podrido", "Genera moscas azules al disparar"},
	{"269", "Bebé sin Cabeza", "Deja creep que inflige 6 de daño cada segundo"},
	{"270", "Sanguijuela", "Cura medio corazón al matar enemigos#3,2 de daño cada segundo"},
	{"271", "Bolsa misteriosa", "Genera recolectables aleatorios cada pocas habitaciones"},
	{"272", "Mosca Hermosa", "Mosca explosiva aliada#La explosión inflige 60 de daño"},
	{"273", "Cerebro de Bob", "Familiar bomba lanzable#La explosión inflige 60 de daño"},
	{"274", "Gran Amigo", "Al ser golpeado, ganas un orbital de Alcance medio#Inflige 75 de daño cada segundo"},
	{"275", "Mini-Azufre", "{{Collectible118}} Familiar que dispara un rayo que inflige 2.5 de daño cada segundo hasta un máximo de 20"},
	{"276", "Corazón de Isaac", "Gana un cuerpo invulnerable#!!! Cuando al familiar corazón le golpean te hace daño"},
	{"277", "Minitormento", "Familiar fantasma aliado#Inflige 4 de daño cada segundo"},
	{"278", "Pordiosero Oscuro", "!!! {{Heart}} Convierte 1.5 corazones rojos en: #{{SoulHeart}} 1 corazón de alma"},
	{"279", "Gran Fan", "Orbital grande#Inflige 30 de daño cada segundo"},
	{"280", "Sissy Patitas-Largas", "Invoca arañas azules en habitaciones hostiles"},
	{"281", "Saco de boxeo", "Los enemigos le atacarán a él en lugar de a ti"},
	{"282", "Cómo saltar", "Permite saltar"},
	{"283", "D100", "Cambia todos los recolectabes, pedestales y los objetos que tengas"},
	{"284", "D4", "Cambia los objetos que tengas"},
	{"285", "D10", "Cambia todos los enemigos de la habitación"},
	{"286", "Carta en Blanco", "Copia el efecto de la carta que tengas"},
	{"287", "Libro de Secretos", "Muestra partes del mapa"},
	{"288", "Caja de arañas", "Invoca de 1 a 4 arañas azules"},
	{"289", "Vela roja", "Lanza fuego rojo#La llama persiste hasta infligir daño 5 veces"},
	{"290", "El Jarro", "Almacena hasta 4 corazones rojos para usarlos más tarde"},
	{"291", "¡Flush!", "!!! Mata a enemigos y jefes caca de manera instantánea#Convierte a los enemigos en caca"},
	{"292", "Biblia satánica", "+1 {{BlackHeart}} corazón negro"},
	{"293", "Cabeza de Krampus", "{{Collectible118}} Dispara un rayo de Azufre en 4 direcciones"},
	{"294", "Frijol Mantequilla", "Repele a los enemigos y proyectiles cercanos#10 % de probabilidad de convertirse en \"Wait What?\" (Espera, ¿qué?) al intercambiarlo por otro objeto activable y volverlo a coger"},
	{"295", "Dedos mágicos", "Daña toda la habitación con el doble de tu daño#Precio: 1 moneda"},
	{"296", "Conversor", "!!! Convierte:#2 corazones de alma/negros en un corazón rojo"},
	{"297", "Caja de Pandora", "!!! ÚNICO USO !#!!! Genera cosas en función del piso en el que se active:#B1: 2 corazones de alma; B2: 2 llaves y bombas#C1: 1 objeto de jefe; C2: B1+C1#D1: {{SoulHeart}} 4 corazones de alma; D2: 20 monedas#W1: 2 objetos {{BossRoom}}; W2: {{Collectible33}} Biblia#Sheol: 1 objeto {{DevilRoom}} + 1 {{BlackHeart}}; Catedral: 1 objeto {{AngelRoom}} + 1 {{SoulHeart}}#Cofre: {{Coin}} 1 moneda"},
	{"298", "Paso de Unicornio", "Invencibilidad y +0,28 velocidad que dura hasta 6 segundos"},
	{"299", "Tauro", "¡Te hace más rápido en las habitaciones hostiles!#Invencibilidad al alcanzar la velocidad suficiente"},
	{"300", "Aries", "↑ {{Speed}} Velocidad +0.25#Tocar a los enemigos les daña"},
	{"301", "Cáncer", "{{SoulHeart}} +3 corazones de alma#Reduce a la mitad el daño que recibas en la habitación tras ser golpeado una vez"},
	{"302", "Leo", "¡Rompe las rocas al caminar!"},
	{"303", "Virgo", "Posibilidad de ser invencible cuando te tocan#Convierte píldoras negativas en positivas"},
	{"304", "Libra", "+6 monedas / llaves / bombas#¡Equilibra tus estadísticas!#!!! Cada estadística afectará también a otras estadísticas"},
	{"305", "Escorpio", "{{Poison}} Lágrimas venenosas"},
	{"306", "Sagitario", "↑ {{Speed}} Velocidad +0.2#Lágrimas penetrantes"},
	{"307", "Capricornio", "↑ +1 {{Heart}} de Vida / {{Key}} Llave / {{Bomb}} Bomba / {{Coin}} Moneda#↑ {{Speed}} +0.1#↑ {{Range}} Alcance +1.5#↑ {{Damage}} Daño +0.5 "},
	{"308", "Aquario", "Deja un rastro de creep#El creep inflige 6 de daño cada segundo"},
	{"309", "Piscis", "↑ {{Tears}} Lágrimas +0.5#Lágrimas con empuje"},
	{"310", "Rímel de Eva", "↓ {{Tears}} Menos lágrimas#↓ {{Shotspeed}} Vel. de tiro -0.5#↑ {{Damage}} Daño x2"},
	{"311", "Sombra de Judas", "Al morir, revive como un Judas oscuro, al momento de revivir: #↑ {{Damage}} Daño x2"},
	{"312", "Moño de Maggy", "↑ {{Heart}} +1 de vida#Todos los corazones rojos curarán 2 contenedores"},
	{"313", "Manto sagrado", "Ignora el primer golpe de cada habitación"},
	{"314", "Curvas Gruesas", "↑ {{Heart}} +1 de vida#↓ {{Speed}} Velocidad -0.4#Rompes rocas al caminar"},
	{"315", "Atractor extraño", "Lágrimas magnéticas"},
	{"316", "Ojo maldito", "Ola de lágrimas cargadas#Cuando cargas y te golpean te teletransporta a una habitación aleatoria"},
	{"317", "Líquido misterioso", "Las lágrimas dejan creep#El creep inflige 30 de daño cada segundo"},
	{"318", "Géminis", "Familiar unido a ti#Inflige 8 de daño por contacto cada segundo"},
	{"319", "El otro ojo de Caín", "Rebota por la habitación#Dispara en la misma dirección que Isaac#Inflige el mismo daño que tú"},
	{"320", "Único amigo de ???", "Mosca controlable#Inflige 5 de daño por contacto cada segundo"},
	{"321", "Cadenas de Sansón", "Bola de acero encadenada a Isaac#Puede dañar enemigos o destruir rocas#Inflige 10,7 de daño por contacto"},
	{"322", "Bebé Mongo", "Copia el efecto de uno de tus familiares#Inflige el doble de su daño"},
	{"323", "Lágrimas de Isaac", "Dispara 8 lágrimas en todas las direcciones#Carga al disparar"},
	{"324", "Undefined", "Te teletransporta a:#Habitación {{SecretRoom}}{{SuperSecretRoom}}Secreta / Error / sala del tesoro{{TreasureRoom}}"},
	{"325", "Tijeras", "Te corta la cabeza#La cabeza no se mueve#Controla tu cuerpo por separado"},
	{"326", "Respiración de vida", "Mantén hasta que la barra del objeto se vacíe para ser invencible#!!! ¡No mantengas demasiado tiempo!"},
	{"327", "La Polaroid", "Invencible cuando te golpean y estás a medio corazón"},
	{"328", "El Negativo", "Efecto de Necronomicón cuando te golpean y estás a medio corazón"},
	{"329", "La técnica de Ludovico", "Lágrima controlable"},
	{"330", "Leche de Soya", "↑{{Tears}} Lágrimas x5.5 #↓ {{Damage}} Daño -80%"},
	{"331", "Divinidad", "Lágrimas teledirigidas#↑ {{Range}} Alcance +1.2#↓ {{Tears}} Lágrimas -0.3#↓{{Shotspeed}} Vel. de tiro -30%#↑ {{Damage}} Daño +0.5#↑ {{Tearsize}} Tamaño de lágrimas +0.8#Las lágrimas adquieren un aura que hace tu daño al 30%"},
	{"332", "Harapos de Lázaro", "{{Player11}} Al morir, revive como Lázaro"},
	{"333", "La Mente", "Visión de mapa al completo"},
	{"334", "El Cuerpo", "↑ + {{Heart}} 3 de vida"},
	{"335", "El Alma", "+ {{SoulHeart}} 2 corazones de alma#Genera un aura que repele los proyectiles"},
	{"336", "Cebolla Muerta", "Lágrimas espectrales y penetrantes#↑ {{Range}} Alcance +0.25#↓ {{Shotspeed}} Vel. de tiro -0.4"},
	{"337", "Reloj roto", "Ralentiza o acelera cada cuatro habitaciones"},
	{"338", "El Búmeran", "Aturde a los enemigos#Puede coger objetos"},
	{"339", "El Gancho", "↑ {{Range}} Alcance +5.25#↑ {{Shotspeed}} Vel. de tiro +0.16#↑ {{BlackHeart}} +1 corazón negro#↑ {{Tearsize}} Tamaño de lágrimas +0.5"},
	{"340", "Píldora de Cafeína", "↑ {{Speed}} Velocidad +0.3#↑ Hace más pequeño al jugador#{{Pill}} Se generará una píldora al tomarlo"},
	{"341", "Foto destruida", "↑ {{Tears}} Lágrimas +0.7#↑ {{Shotspeed}} Vel. de tiro +16%"},
	{"342", "Hongo Azul", "↑ {{Heart}} +1 de vida#↑ {{Tears}} Lágrimas +0.7#↓ {{Shotspeed}} Vel. de tiro -16%"},
	{"343", "Llave de casa", "↑ {{Luck}} Suerte +1#↑ {{SoulHeart}} +1 corazón de alma#{{Key}} Genera 2 llaves"},
	{"344", "Caja de Fósforos", "+1 corazón negro#Genera de 2 a 3 bombas"},
	{"345", "Synthol", "↑ {{Range}} Alcance +5.25#↑ {{Damage}} Daño +1.0#↑ {{Tearsize}} Tamaño de lágrimas +0.5"},
	{"346", "Un Bocadillo", "↑ +1 de vida"},
	{"347", "Diplopia", "!!! UN SOLO USO #Duplica los pedestales y consumibles de la habitación actual"},
	{"348", "Placebo", "Copia el efecto de la píldora que tienes"},
	{"349", "Moneda de Madera", "50 % de probabilidad de generar una moneda aleatoria"},
	{"350", "Shock tóxico", "{{Poison}} Al entrar en cada habitación los enemigos se envenenan"},
	{"351", "Mega Frijol", "Congela a los enemigos#Inflige 5 de daño y envenena a los enemigos cercanos#Genera una onda de piedra#!!! Puede usarse para abrir habitaciones secretas"},
	{"352", "Cañón de cristal", "↓ Reduce tu vida a medio corazón#Dispara una gran lágrima espectral y penetrante ((+1 daño) X 10)"},
	{"353", "Bomber Boy", "+5 bombas#Las bombas explotan en forma de cruz"},
	{"354", "Crack Jacks", "↑ {{Heart}} +1 de vida#{{Trinket}} Genera un trinket aleatorio"},
	{"355", "Perlas de Mamá", "↑ {{Range}} Alcance +1.25#↑ {{Luck}} Suerte +1#↑ {{Tearsize}} Tamaño de lágrimas +0.5"},
	{"356", "Batería de coche", "Hace que tu objeto activable se active dos veces"},
	{"357", "Cajón de Amigos", "Duplica los familiares en la habitación actual"},
	{"358", "El genio", "Dispara 2 lágrimas de manera diagonal, similar a Are U a Wizard? (¿Eres un mago?)#Lágrimas espectrales"},
	{"359", "Clavos de 8 Pulgadas", "↑ {{Damage}} Daño +1.5#Aumenta el empuje"},
	{"360", "Íncubo", "Familiar que dispara las mismas lágrimas que Isaac"},
	{"361", "Premio del destino", "Dispara lágrimas y copia el daño de la lágrima"},
	{"362", "Mini-Cofre", "Deja caer un recolectable cada pocas habitaciones"},
	{"363", "Protector fiel", "Familiar orbital#Inflige 105 de daño por contacto cada segundo#Bloquea y atrae proyectiles#Bloquear una lágrima puede dejar caer un corazón eterno"},
	{"364", "Solo Amigos", "Familiar orbital#Inflige 45 de daño por contacto cada segundo"},
	{"365", "Mosca perdida", "Mosca que se mueve por las paredes de la habitación#Inflige 105 de daño por contacto cada segundo"},
	{"366", "Bombas de dispersión", "+5 bombas#Hace que las bombas exploten en 2-4 bombas pequeñas"},
	{"367", "Bombas Pegajosas", "+5 bombas#Cuando la bomba mata un enemigo, genera una araña azul#Hace que las bombas se peguen a los enemigos"},
	{"368", "Epífora", "↑ {{Tears}} Disparar en una única dirección aumenta la cadencia de disparo hasta un 200 %"},
	{"369", "Continuo", "↑ {{Range}} Alcance +2.25#↑ {{Tearsize}} Tamaño de lágrimas +1.5#Las lágrimas atraviesan las paredes y aparecen por la pared contraria"},
	{"370", "Sr. Muñeca", "↑ {{Range}} Alcance +5.25#↑ {{Tears}} Lágrimas +0.7#↑ {{Tearsize}} Tamaño de lágrimas +0.5#Genera 3 corazones aleatorios al tomarlo"},
	{"371", "Maldición de la torre", "Genera 6 bombas troll cada vez que te golpean#Varían en función de tus objetos bomba"},
	{"372", "Bebé recargado", "Posibilidad de dejar caer una batería o de congelar a los enemigos#Puede agregar una carga a tu objeto activable"},
	{"373", "Ojo Muerto", "↑ {{Damage}} +12,5 % de daño por cada lágrima que golpee a un enemigo (máximo +100 %)#Fallar reinicia el daño"},
	{"374", "Luz sagrada", "Posibilidad de disparar una lágrima sagrada, que hará que caigan rayos de luz desde el cielo#El rayo inflige cuatro veces tu daño"},
	{"375", "Sombrero Host", "20 % de posibilidad de evitar lágrimas#Inmune a explosiones y al pie de Mamá y de Satán"},
	{"376", "Reponer", "Las tiendas reponen los objetos que compres instantáneamente#Genera 3 pick ups"},
	{"377", "Nido repleto", "Las arañas enemigas ya no dañarán a Isaac"},
	{"378", "Número 2", "Disparar durante 3 segundos generará una bomba caca"},
	{"379", "Pupila Doble", "Las lágrimas tienen una hitbox mayor#Lágrimas espectrales"},
	{"380", "Pay To Play", "{{Coin}} +5 monedas#Abres puertas con monedas en lugar de llaves"},
	{"381", "Bendición del Edén", "↑ +0,7 de lágrimas#Objeto aleatorio al inicio de la siguiente partida"},
	{"382", "Bola amiga", "Se lanza a los enemigos para capturarlos# Cuando vuelvas a usarlo lo revivirá como aliado"},
	{"383", "Detonador de lágrimas", "Detona las lágrimas que lances para que se separen en otras 6 lágrimas en círculo"},
	{"384", "Mini-Gurdy", "Rebota por la habitación infligiendo daño por contacto a los enemigos"},
	{"385", "Bumbo", "Recoge monedas cercanas#Cada 6 monedas sube de nivel, menos para el nivel 4 que son 12#Nivel 2: suelta recolectables aleatorios#Nivel 3: lanza lágrimas en la misma dirección que Isaac#Nivel 4: ya no dispara, persigue a los enemigos. Puede soltar bombas#Después de nivel 4: recoge monedas y suelta recolectables aleatorios"},
	{"386", "D12", "Convierte los objetos similares a rocas en otro tipo de objeto aleatorio (caca, TNT, caca roja, piedras, etc.)"},
	{"387", "Incensario", "Crea una gran aura de luz que ralentiza a los enemigos y proyectiles que entren en ella"},
	{"388", "Pordiosero de Llaves", "Recoge llaves y genera cofres aleatorios a cambio"},
	{"389", "Bolsa de Runas", "{{Rune}} Genera una runa aleatoria cada 7-8 habitaciones#También puede generar piedras de alma"},
	{"390", "Serafín", "Dispara lágrimas similares a Sacred Heart (Corazón sagrado)#Infligen 10 de daño"},
	{"391", "Traición", "Cada vez que golpean a Isaac, los enemigos de la habitación reciben un efecto encantador"},
	{"392", "Zodíaco", "Efecto aleatorio de objeto del zodíaco que cambia cada planta"},
	{"393", "Beso de Serpiente", "{{Poison}} Posibilidad de envenenar a los enemigos#{{Poison}} Envenena al tocar#{{BlackHeart}} Posibilidad de que los enemigos envenenados dejen caer un corazón negro al caer"},
	{"394", "En la Mira", "Dispara lágrimas automáticamente dirigidas por la mira roja en el suelo↑ {{Range}} Alcance +3.15#↑ {{Tears}} Lágrimas +0.7#↑ {{Tearsize}} Tamaño de lágrimas +0.3#"},
	{"395", "Tech X", "{{Chargeable}} Cargable#Disparas anillos láser con gran daño que viajan a través de la habitación"},
	{"396", "Bisturí Ventricular", "Crea dos portales para viajar entre ellos#Puede usarse en diferentes habitaciones"},
	{"397", "Rayo tractor", "Las lágrimas viajan en línea recta siguiendo un rayo de luz #↑ {{Range}} Alcance +5.25#↑ {{Tears}} Lágrimas +0.5#↑ {{Shotspeed}} Vel. de tiro +0.16#↑ {{Tearsize}} Tamaño de lágrimas +0.5"},
	{"398", "Carne de Dioses", "Las lágrimas pueden reducir el tamaño de los enemigos#Puedes pisarlos para matarlos"},
	{"399", "Fauces del Vacío", "{{Chargeable}} Cargable#↑ {{Damage}} Daño +1.0#Tras disparar lágrimas durante 3 segundos, crea un anillo negro que daña a los enemigos que están dentro de él#{{BlackHeart}} Los enemigos asesinados con el anillo negro pueden generar corazones negros"},
	{"400", "Lanza del destino", "Genera una lanza delante de ti#Inflige el doble de tu daño#Puede asustar a los enemigos al contacto"},
	{"401", "Explosivo", "Posibilidad de disparar bombas pegajosas"},
	{"402", "Caos", "Puede aparecer cualquier objeto del juego en los pedestales#Al tomarlo, deja caer entre 1-6 recolectables"},
	{"403", "SpiderMod", "Te permite ver el daño de la lágrima y la barra de vida de los enemigos#Al tocar a un enemigo lo congela#Dejará caer baterías"},
	{"404", "Bebé Tira-Pedos", "Bloquea los proyectiles#Si le golpean se tirará un pedo, lo que envenenará, empujará o encantará a los enemigos cercanos"},
	{"405", "Error_crítico", "Familiar que aplica un efecto aleatorio a los enemigos que le toquen#Inflige 120 de daño cada segundo"},
	{"406", "D8", "Cambia tus estadísticas#Solo afecta al daño, las lágrimas, el Alcance y la velocidad"},
	{"407", "Pureza", "↑ Potencia una estadística dependiendo del color del aura que te rodea#Al recibir daño cambia el color de aura##{{ColorRed}}Rojo{{CR}} = {{Damage}} Daño +4.0##{{ColorBlue}}Azul{{CR}} = {{Tears}} Lágrimas +4#{{ColorYellow}}Amarillo{{CR}} = {{Speed}} Velocidad +0.5#{{ColorOrange}}Naranja{{CR}} = {{Range}} Alcance +7.5, {{Tearsize}} Tamaño de lágrimas +1"},
	{"408", "Athame", "Al recibir daño, aparece un anillo negro alrededor de Isaac que inflige daño por contacto#Los enemigos asesinados con él pueden dejar caer un corazón negro"},
	{"409", "Recipiente vacío", "↑ {{BlackHeart}} +2 corazones negros#Cuando no tengas corazones rojos, te permite volar y generar un escudo"},
	{"410", "Mal de ojo", "A veces aparece un ojo que disparará lágrimas en la misma dirección que Isaac"},
	{"411", "Sangre lujuriosa", "↑ {{Damage}} Daño +0.5 cada vez que matas a un enemigo#Máximo de +5 de daño al matar 10 veces#El daño dura en la habitación actual"},
	{"412", "Impura Concepción", "Al recibir daño 15 veces, ganas un familiar demoníaco permanente#Hasta 4 familiares"},
	{"413", "Inmaculada concepción", "Al recoger 15 corazones, ganas un familiar angelical permanente#Hasta 5 familiares"},
	{"414", "Más opciones", "Se generan dos objetos en la sala del tesoro#Solo puedes escoger uno"},
	{"415", "Corona de la luz", "↑ {{SoulHeart}} +2 corazones de alma##Si posees todos tus corazones, recibirás: #↑ {{Range}} Alcance +5.25#↓ {{Shotspeed}} Vel. de tiro -0.3#↑ {{Damage}} Daño x2#Se pierde el efecto en la habitación si te dañan"},
	{"416", "Bolsillos profundos", "Te permite llevar dos cartas,píldoras o runas"},
	{"417", "Súcubo", "Familiar que rebota con un aura que inflige un 129 % de tu daño a los enemigos que estén dentro de ella#↑ Al quedarse sobre el aura, {{Damage}} Daño x150%"},
	{"418", "Pastel de frutas", "Otorga un efecto de lágrima diferente por cada lágrima que disparas"},
	{"419", "Teletransporte 2.0", "Te teletransporta a una habitación sin explorar#Jerarquía: {{Room}}>{{BossRoom}}>{{SuperSecretRoom}}>{{Shop}}>{{TreasureRoom}}>{{SacrificeRoom}}> {{DiceRoom}}>{{Library}}>{{CursedRoom}}>{{MiniBoss}}>{{ChallengeRoom}}>{{IsaacsRoom}}> {{ArcadeRoom}}>{{ChestRoom}}>{{SecretRoom}}>{{DevilRoom}}{{AngelRoom}}>{{ErrorRoom}}"},
	{"420", "Polvo Oscuro", "Caminar en círculo forma un símbolo de pentagrama en el suelo, que inflige 10 de daño por tick"},
	{"421", "Frijol Rojo", "Encanta a los enemigos cercanos y les inflige 5 de daño"},
	{"422", "Reloj de Arena brillante", "Viaja en el tiempo y te deja en habitaciones anteriores, con las mismas estadísticas que tenías entonces"},
	{"423", "Círculo de protección", "Se crea un gran halo a tu alrededor, inflige daño por contacto#Posibilidad de evitar proyectiles enemigos"},
	{"424", "Cara de Bolsa", "33 % de posibilidad de que los recolectables se sustituyan por un saco#Genera un saco"},
	{"425", "Luz nocturna", "Un cono de luz frente a Isaac que ralentiza a los enemigos y a sus lágrimas"},
	{"426", "Fan obsesionado", "Sigue tus movimientos exactos con 3 segundos de retraso#Inflige 30 de daño por contacto cada segundo"},
	{"427", "Minero artesano", "Coloca un barril de TNT#Si no se ha usado el barril y colocas otro en la misma habitación, el primero explotará"},
	{"428", "Pijama", "+4 corazones de alma#Cura los corazones rojos al completo"},
	{"429", "Cabeza de Keeper", "5 % de posibilidad de que las lágrimas dejen caer monedas tras golpear a un enemigo"},
	{"430", "Mosca Papá", "Sigue tus movimientos con 3 segundos de retraso#Dispara a los enemigos cercanos e inflige tu daño"},
	{"431", "Bebé multidimensional", "Sigue tus movimientos con 3 segundos de retraso#Las lágrimas que lo traspasen se dividen y ganan una mejora de velocidad"},
	{"432", "Bombas Brillantes", "#+5 bombas#Las bombas pueden generar recolectables aleatorios al explotar (llaves, monedas, bombas)"},
	{"433", "Mi sombra", "Cada vez que te golpean, asustará a los enemigos de la habitación y generará un familiar negro#El familiar inflige 5 de daño cada segundo"},
	{"434", "Jarra de Moscas", "Cada vez que mates a un enemigo se añadirá una mosca azul al tarro#Máximo: 20 moscas#Usar el Tarro de moscas las liberará"},
	{"435", "Mini-Loki", "Dispara 4 lágrimas en forma de cruz#Inflige 3,5 de daño"},
	{"436", "¡Leche!", "Tras ser golpeado, aumenta las lágrimas para el resto de la habitación"},
	{"437", "D7", "Vuelve a generar enemigos y te permite conseguir recompensas al acabar la habitación#!!! Al usarlo en una lucha contra Greed, puede convertir la habitación en una tienda"},
	{"438", "Chupón", "↑ {{SoulHeart}} +1 corazón de alma#↑ {{Tears}} Lágrimas +0.7#↑ Hace que Isaac sea muy pequeño, reduce el tamaño de la hitbox"},
	{"439", "Caja de Mamá", "Deja caer un trinket aleatorio#↑ +1 de suerte#Al tenerlo duplica el efecto de los trinkets"},
	{"440", "Piedra de Riñón", "Al disparar, puede lanzar un grupo de lágrimas y una roca#↓ -0,2 de velocidad#↓ -17 de Alcance#↑ +2,0 de tamaño de lágrima"},
	{"441", "Mega Ráfaga", "Dispara un gran láser de Mega Satán durante 15 segundos#El láser se mantiene entre habitaciones o plantas"},
	{"442", "Corona del Príncipe Oscuro", "!!! Al tener un corazón rojo lleno:#↑ {{Range}} Alcance +1.5#↑ {{Tears}} Lágrimas +0.7#↑ {{Shotspeed}} Vel. de tiro +0.2#(No funciona con the Lost (El Perdido))"},
	{"443", "¡Manzana!", "Dispara cuchillas que infligen un 400 % de daño de manera aleatoria#↑ {{Tears}} +0,3 de lágrimas"},
	{"444", "Lápiz", "Cada 15 lágrimas disparas un grupo de lágrimas#Cada lágrima inflige el doble de daño"},
	{"445", "Diente de Perro", "↑ {{Speed}} Velocidad +0.1#↑ {{Damage}} Daño +0.3#Un lobo aúlla si entras en una habitación al lado de la sala secreta#Un ladrido si hay una trampilla "},
	{"446", "Diente Muerto", "Al disparar, recibes un aura verde que envenena a los enemigos que entran#El veneno inflige tu daño"},
	{"447", "Frijol Persistente", "Al disparar sin parar, genera una nube de caca cada 7,5 segundos#La nube inflige 3,5 de daño 5 veces por segundo#La nube dura 15 segundos#Si le disparas puedes moverla"},
	{"448", "Pedazo de vidrio", "Cuando te golpean, posibilidad de: #↑ {{Range}} Alcance +5 y dejar un rastro de creep sangriento#Generar un corazón rojo"},
	{"449", "Placa Metálica", "↑ {{SoulHeart}} +1 corazón de alma# 25 % de posibilidad de reflejar los proyectiles enemigos en lágrimas que aturden"},
	{"450", "Ojo de Codicia", "Cada 20 lágrimas, disparas una lágrima moneda que convierte a los enemigos en oro#Cuesta una moneda#Matar a esos enemigos hará que caiga una moneda"},
	{"451", "Tela de Tarot", "Genera una carta o runa aleatoria#Duplica el uso de cualquier carta del tarot"},
	{"452", "Venas Varicosas", "Cuando te golpean se dispara un círculo de 10 lágrimas#Las lágrimas infligen 125 % de daño"},
	{"453", "Fractura Compuesta", "Lágrimas de hueso#Al golpear a un enemigo, las lágrimas se separan en 1-3 trozos de hueso#↑ +1,5 de Alcance#+1,0 de tamaño de lágrima"},
	{"454", "Polidactilia", "Puedes llevar dos {{Card}} cartas, {{Rune}} runas o {{Pill}} píldoras#Genera una carta, píldora o runa aleatoria al tomarlo"},
	{"455", "Moneda perdida de papá", "↑ {{Range}} Alcance +1.5#Deja caer un penique de la suerte"},
	{"456", "Bocadillo nocturno", "↑ +1 de vida"},
	{"457", "Cabeza de Cono", "↑ {{SoulHeart}} +1 corazón de alma#20 % de posibilidad de ignorar daño"},
	{"458", "Ombligo", "{{Trinket}} Genera un trinket aleatorio al tomarlo#{{Trinket}} Más espacio para un trinket adicional"},
	{"459", "Infección sinusal", "{{Poison}} Lágrimas venenosas que se pegan al enemigo hasta que muere#Inflige tu daño cada tick"},
	{"460", "Glaucoma", "{{Confusion}} Posibilidad de disparar lágrimas que aturden"},
	{"461", "Parasitoide", "Posibilidad de disparar sacos de huevos#{{Slow}} Genera un creep ralentizante al impactar#Genera una mosca o araña azul"},
	{"462", "Ojo de Belial", "↑ {{Range}} Alcance +1.5#↑ {{Tearsize}} Tamaño de lágrimas +1.0#Otorga lágrimas penetrantes#Tras golpear al primer enemigo, las lágrimas infligen el doble de daño y se vuelven teledirigidas"},
	{"463", "Ácido sulfúrico", "↑ {{Damage}} Daño +0.3#Probabilidad de disparar lágrimas que destruyan rocas y abren puertas"},
	{"464", "Glifo del equilibrio", "↑ {{SoulHeart}} +2 corazones de alma#Los enemigos campeones generan más recolectables"},
	{"465", "Mando Analógico", "↑ {{Tears}} Lágrimas +0.3#Permite disparar lágrimas en diagonal al disparar en dos direcciones"},
	{"466", "Contagio", "{{Poison}} El primer enemigo asesinado explota y envenena a los enemigos cercanos"},
	{"467", "¡Dedo!", "{{Damage}} Inflige un 10% de tu daño de forma constante en la dirección en la que señala el dedo"},
	{"468", "Sombra", "Sigue tu movimiento con un retraso de un segundo#Inflige 30 de daño por contacto"},
	{"469", "Depresión", "Deja un rastro de lágrimas que inflige 6 de daño cada segundo#Los enemigos que toquen la nube pueden hacer caer un rayo de luz sagrada"},
	{"470", "Shhh", "Rebota por la habitación#Inflige daño por contacto#Se para cuando disparas#Cuando está parado puede bloquear proyectiles"},
	{"471", "Mini-Monstro", "Carga los disparos como Monstro#Cada lágrima inflige 3,5 de daño"},
	{"472", "Rey bebé", "Le siguen otros familiares#No se mueve mientras disparas#Se teletransporta a ti cuando dejas de disparar"},
	{"473", "Gran Chubby", "Carga hacia delante lentamente#Inflige 40,5 de daño por contacto"},
	{"474", "Amígdala", "Bloquea los proyectiles enemigos"},
	{"475", "Plan C", "!!! UN SOLO USO #Inflige 9.999.999 de daño a todos los enemigos y te mata 3 segundos después"},
	{"476", "D1", "Duplica un recolectable aleatorio en la habitación actual"},
	{"477", "Vacío", "!!! Al usarlo, consume cualquier objeto de pedestal en la habitación#Objeto activo: Se añade el efecto al de Vacío(Apilando los efectos)#↑ Objeto pasivo: Pequeña mejora aleatoria"},
	{"478", "Pausa", "Congela a los enemigos hasta que vuelvas a disparar#Tocar a un enemigo congelado te hará daño"},
	{"479", "Fundidora", "{{Trinket}} Consume el trinket y ganas el efecto de manera permanente#{{Trinket}} Aparecen más trinkets"},
	{"480", "Abono", "Convierte los recolectables en moscas o arañas azules"},
	{"481", "Dataminer", "Al usarlo, ↑/↓ una pequeña cantidad de una estadística aleatoria#Efecto aleatorio de lágrima para la habitación actual"},
	{"482", "Control Remoto", "Te convierte en otro personaje aleatorio#Elimina el último objeto que hayas tomado"},
	{"483", "¡Mamá Mega!", "!!! UN SOLO USO#Afecta a toda la planta#Explota todos los objetos#Inflige 200 de daño a todos los enemigos#Abre la Boss rush/puerta de Hush/sala secreta"},
	{"484", "Espera... ¿qué?", "Al usarlo, empuja a los enemigos y genera una ola de rocas#Puede abrir habitaciones o romper piedras"},
	{"485", "Moneda Doblada", "50% de probabilidad de duplicar todos los objetos, consumibles y cofres de la habitación#50% de probabilidad de eliminar objetos/recolectables de la habitación y soltar una moneda"},
	{"486", "Hoja sin Filo", "Hace que el jugador sufra daño sin perder ningún corazón#Puede activar efectos de otros objetos que tengas"},
	{"487", "Pelador de Papas", "{{Heart}} Elimina un contenedor, a cambio, otorga:#↑ {{Damage}} Daño +0.2 de daño#{{Collectible73}} Un Cubo de carne"},
	{"488", "Metrónomo", "Otorga un efecto de objeto aleatorio en la habitación"},
	{"489", "D infinito", "Efecto de dado aleatorio en cada uso"},
	{"490", "Alma de Edén", "!!! UN SOLO USO#Genera 2 objetos aleatorios de la habitación actual"},
	{"491", "Bebé ácido", "Genera una píldora aleatoria cada tres habitaciones#Usar una píldora daña a los enemigos"},
	{"492", "YO LISTEN!", "↑ {{Luck}} +1 de suerte#Resalta la localización de salas secretas, rocas marcadas y trampillas"},
	{"493", "Adrenalina", "Por cada contenedor de corazón vacío:#↑ {{Damage}} +0,2 de daño"},
	{"494", "Escalera de Jacob", "Lágrimas eléctricas que al impactar generan rayos#Los rayos infligen la mitad de tu daño"},
	{"495", "Pimiento fantasma", "Probabilidad de disparar fuego en lugar de lágrimas#El fuego se mantiene hasta infligir daño 5 veces"},
	{"496", "Eutanasia", "Puede disparar jeringuillas que matan a los enemigos normales de un golpe#A los jefes les inflige el triple de tu daño"},
	{"497", "Interior Camuflado", "Al entrar a una habitación te camuflas hasta que disparas"},
	{"498", "Dualidad", "{{DevilChance}}/{{AngelChance}} Genera la sala del Diablo{{DevilRoom}} y del Ángel{{AngelRoom}}#Cuando entras en una la otra desaparece"},
	{"499", "Eucaristía", "↑ {{AngelChance}} 100 % de probabilidad de encontrar la sala del Ángel"},
	{"500", "Bolsa de Bolsas", "Genera un saco cada 5-6 habitaciones"},
	{"501", "Esófago de Codicia", "Cada 25 monedas te da 1 contenedor de corazón#{{Player14}} Keeper ganará más monedas-corazones"},
	{"502", "Grano grande", "Posibilidad de disparar una lágrima que suelte creep y duplique el daño"},
	{"503", "Cuernito", "Posibilidad de disparar una lágrima que mata al instante a enemigos normales#Inflige 3,5 de daño por contacto"},
	{"504", "Nugget café", "Genera una mosca torreta que dispara a los enemigos#Cada disparo inflige 2 de daño"},
	{"505", "Poke Go", "De manera aleatoria, genera un enemigo encantado al entrar en una habitación hostil"},
	{"506", "Apuñala espaldas", "Las lágrimas causan sangrado que inflige el 10 % de la vida total de los enemigos cada 5 segundos"},
	{"507", "Pajilla afilada", "Inflige tu daño + 10 % de la vida máxima del enemigo#Afecta a todos los enemigos de la habitación#Probabilidad de generar medio corazón al infligir daño"},
	{"508", "Afeitadora de Mamá", "{{BleedingOut}} Orbital que causa sangrado, inflige el 10% de la vida total de los enemigos cada 5 segundos#{{Damage}} Inflige 300% de tu daño por contacto cada segundo"},
	{"509", "Ojo Dispara-lágrimas", "Dispara una lágrima en una dirección aleatoria cada 2 segundos#Inflige 3.5 de daño#Inflige 30 de daño por contacto cada segundo"},
	{"510", "Delirious", "Genera una versión aliada de Delirium en la habitación actual"},
	{"511", "Mosca Enojada", "Orbita alrededor de un enemigo aleatorio hasta que este muere#Inflige 30 de daño por contacto cada segundo"},
	{"512", "Agujero negro", "Agujero negro lanzable, que lo absorbe todo#Inflige 0,4 de daño por tick#Destruye rocas cercanas#Dura seis segundos"},
	{"513", "Bozo", "↑ {{Damage}} Daño +0.1#↑ {{SoulHeart}} +1 corazón de alma#Posibilidad de encantar/asustar a un enemigo#Posibilidad de generar una caca arcoíris al ser golpeado"},
	{"514", "Modem Roto", "Los enemigos se quedan paralizados de manera aleatoria por unos instantes#25 % de probabilidad de generar el doble de recolectables al limpiar la habitación"},
	{"515", "Regalo misterioso", "!!! UN SOLO USO#Genera un objeto aleatorio de la habitación actual#Probabilidad de generar:#{{Collectible132}} Un trozo de carbón#{{Collectible36}} La Caca"},
	{"516", "Aspersor", "Genera una torreta que gira y dispara tus lágrimas en todas las direcciones"},
	{"517", "Bombas Rápidas", "{{Bomb}} +7 Bombas#Te permite colocar bombas muy rápido"},
	{"518", "Compañero Encajonado", "Familiar que cambia de aspecto#Efecto de lágrima aleatorio cada planta"},
	{"519", "Mini-Delirio", "Familiar que se transforma en otro familiar aleatorio cada 10 segundos"},
	{"520", "Cables de Salto", "{{Battery}} +1 carga para tu objeto activable por cada 15 enemigos asesinados"},
	{"521", "Cupón", "Al usarlo, un objeto aleatorio de la {{Shop}} tiendao sala del {{DevilRoom}} Diablose vuelve gratis"},
	{"522", "Telequinesia", "Detiene los proyectiles enemigos que estén cerca durante 3 segundos#Los lanza lejos de ti#Se recarga pasados 3 segundos"},
	{"523", "Caja de mudanza", "Guarda todos los recolectables de la habitación#Al volver a usarlo suelta los recolectables#Permite mover objetos entre habitaciones"},
	{"524", "Tecnología Cero", "Las lágrimas están conectadas con rayos de electricidad#Los rayos infligen tu daño"},
	{"525", "Lepra", "Recibir daño genera un orbital#Máx. 3 orbitales a la vez#Si reciben demasiado daño, los orbitales pueden destruirse"},
	{"526", "Los 7 Sellos", "Familiar con la forma y ataque de los jinetes#El jinete cambia pasados 10 segundos"},
	{"527", "¡Sr. YO!", "!!! Familiar que hace tareas por ti:#Abrir puertas y cofres, traerte objetos, robar de la tienda o del pacto, luchar contra enemigos, explotar y activar placas de presión"},
	{"528", "Prisma angelical", "Prisma orbital#Las lágrimas que pasen por el prisma se separan en cuatro nuevas lágrimas"},
	{"529", "¡Pop!", "Las lágrimas son ojos que pueden rebotar entre ellos"},
	{"530", "Lista de la muerte", "Otorga una recompensa al matar enemigos en el orden que se indica"},
	{"531", "Hemolacria", "Las lágrimas salen en forma de arco#Al impactar, explotan en lágrimas más pequeñas#↓ Menos lágrimas#↑ +31 % de daño"},
	{"532", "Lacrofagia", "Las lágrimas se ralentizan mientras viajan#Al parar, explotan en 8 pequeñas lágrimas#Las lágrimas pueden acumularse disparando unas sobre otras"},
	{"533", "Trisagio", "Dispara rayos de luz blanca#(Brimstone sagrado)"},
	{"534", "Mochila", "Te permite tener 2 objetos activables#Cámbialos pulsando la tecla de soltar objetos (mantén si eres \"The Forgotten\")"},
	{"535", "Manto", "{{SoulHeart}} +1 corazón de alma#{{Heart}} Cura un corazón rojo#{{HolyMantle}} Otorga un escudo al entrar a la sala del jefe"},
	{"536", "Altar de sacrificio", "!!! UN SOLO USO#Sacrifica 1-2 familiares para generar un objeto del Diablo{{DevilRoom}}#Convierte tus moscas o arañas azules en monedas"},
	{"537", "Arcadio", "+1 píldora#Familiar que deja un rastro de creep#El tipo de creep cambia cada vez que uses una píldora"},
	{"538", "Canicas", "Deja caer 3 trinkets aleatorios#Que te golpeen puede añadir el efecto del trinket permanentemente"},
	{"539", "Huevo misterioso", "Genera un enemigo encantado cuando te golpean#Genera aliados más fuertes cuantas más habitaciones limpies sin que te golpeen"},
	{"540", "Piedra plana", "Las lágrimas rebotan en el suelo#Al salpicar, las lágrimas hacen daño"},
	{"541", "Médula", "↑ {{Heart}} +1 corazón de hueso#{{BoneHeart}} Genera 3 corazones rojos"},
	{"542", "Costilla deslizante", "Orbital#Refleja los projectiles"},
	{"543", "Suelo Santificado", "Genera una caca blanca con un aura cuando te golpean#El aura otorga lo siguiente: #↑ {{Tears}} Lágrimas +100%#Las lágrimas pueden bloquear disparos enemigos"},
	{"544", "Costilla con Punta", "Clavo que levita frente a Isaac#Inflige 6 veces tu daño"},
	{"545", "Libro de los Muertos", "Genera huesos que orbitan a tu alrededor o Bonies aliados#El efecto dura en esta habitación"},
	{"546", "Anillo de papá", "Otorga un aura que congela a los enemigos"},
	{"547", "Papeles del divorcio", "↑ {{BoneHeart}} +1 un corazón de hueso#↑ {{Tears}} Lágrimas +0.7#Genera el trinket Papel misterioso"},
	{"548", "Hueso de Mandíbula", "Familiar tipo boomerang#Inflige 7 de daño por contacto#Puede recoger objetos"},
	{"549", "Huesos frágiles", "Remplaza todos los contenedores de corazón por 6 corazones de hueso#Perder un corazón de hueso dispara lágrimas en todas las direcciones#↑ {{Tears}} Lágrimas +0.5"},
	{"550", "Pala rota", "Los pies de mamá te atacarán constantemente#Al usarlo los pies dejarán de caer en esta habitación#!¡Intenta ganar la Bossrush con esto!"},
	{"551", "Pala rota", "Segunda parte de la pala rota#Úsala en el montón de tierra en la \"Dark Room\"(La sala oscura)"},
	{"552", "Pala de Mamá", "Genera una trampilla hacia la siguiente planta#Úsala en el montón de tierra en la \"Dark Room\"(La sala oscura)"},
}

---------- Trinkets ----------
EID.descriptions[languageCode].trinkets={
	{"1", "Moneda tragada", "Generas 1 moneda cuando te golpean"},
	{"2", "Caca petrificada", "Las cacas dejan caer más recolectables"},
	{"3", "Pila AAA", "Se necesita 1 carga menos en los objetos activables"},
	{"4", "Control remoto roto", "Te teletransporta de manera aleatoria al usar un objeto"},
	{"5", "Corazón morado", "Más campeones enemigos#Más salas de desafío de jefe ({{BossRushRoom}})"},
	{"6", "Imán roto", "Imán de monedas"},
	{"7", "Cuenta del rosario", "{{AngelChance}} Aumenta la probabilidad de encontrar la sala del Ángel"},
	{"8", "Cartucho", "{{Collectible93}} Probabilidad de activar el efecto de The Gamekid al recibir daño"},
	{"9", "Gusano palpitante", "Las lágrimas aumentan y disminuyen su tamaño#Afecta a la hitbox de la lágrima"},
	{"10", "Gusano ondulante", "Las lágrimas se mueven en ondas#↑ {{Tears}} Lágrimas +0.3"},
	{"11", "Gusano anillo", "Las lágrimas se mueven en espiral"},
	{"12", "Gusano plano", "Lágrimas más grandes"},
	{"13", "Tarjeta de crédito", "{{Shop}} Puedes llevarte un objeto de la tienda gratis"},
	{"14", "Callo", "Recibes inmunidad ante los pinchos y el creep"},
	{"15", "Roca de la suerte", "{{Coin}} Destruir rocas genera monedas"},
	{"16", "Uña del pie de Mamá", "El pie de mamá cae sobre los enemigos cada 60 segundos"},
	{"17", "Pintalabios negro", "{{BlackHeart}} Más posibilidad de encontrar corazones negros"},
	{"18", "Tratado bíblico", "{{EternalHeart}} Más posibilidad de encontrar corazones eternos"},
	{"19", "Sujetapapeles", "Abre cofres sin usar llaves"},
	{"20", "Pata de mono", "Al estar a medio corazón, deja caer un corazón negro#!!! 3 usos"},
	{"21", "Papel misterioso", "Imita \"Polaroid\", \"The Negative\", \"Missing Poster\" y \"Missing Page\""},
	{"22", "Cola de demonio", "{{BlackHeart}} Convierte los corazones rojos en corazones negros#Se generan menos corazones"},
	{"23", "Cartel de desaparición", "{{SacrificeRoom}} Morir en una sala de sacrificio con la baratija te hará resucitar como {{Player10}} EL Perdido#Si lo tienes desbloqueado, revives como él incluso fuera de las salas de sacrificio"},
	{"24", "Moneda de culo", "Te tiras pedos al tomar monedas#Los pedos empujan"},
	{"25", "Dulce misterioso", "Te tiras un pedo o generas una caca cada 30 segundos"},
	{"26", "Gusano de gancho", "Las lágrimas se mueven en ángulos rectos"},
	{"27", "Gusano látigo", "↑ {{Shotspeed}} Vel. de tiro +0.5"},
	{"28", "Anj roto", "{{Player4}} 22% de probabilidad de revivir como \"???\""},
	{"29", "Cabeza de pez", "Genera una mosca azul cuando te golpean"},
	{"30", "Ojo rosado", "{{Poison}} 10% de posibilidad de disparar lágrimas envenenadas"},
	{"31", "Chincheta", "10% de posibilidad de disparar lágrimas penetrantes de manera aleatoria"},
	{"32", "Monguis", "Efecto aleatorio de champiñón en la habitación#Puede revelar las habitaciones especiales en el minimapa"},
	{"33", "Cordón umbilical", "{{Collectible 100}} Al estar a medio corazón, aparece un pequeño Steven"},
	{"34", "Corazón de niño", "{{Heart}} Genera más corazones rojos"},
	{"35", "Cuerno curvo", "↑ {{Damage}} Daño +2"},
	{"36", "Llave oxidada", "Aparecen más cofres dorados y llaves"},
	{"37", "Pezuña de cabra", "↑ {{Speed}} Velocidad +0.15"},
	{"38", "Perla de mamá", "{{SoulHeart}} Recibes más corazones de alma"},
	{"39", "Cáncer", "{{Tears}} ↑ Más lágrimas"},
	{"40", "Parche rojo", "↑ Probabilidad de hacer +1,8 de daño cuando te golpean"},
	{"41", "Cerilla", "Aparecen más bombas#!!! Elimina \"The Tick\" (la garrapata)"},
	{"42", "Pulgar de la suerte", "↑ {{Luck}} Suerte +1"},
	{"43", "Cráneo maldito", "Si te dañan estando a medio corazón, serás teletransportado a la sala anterior"},
	{"44", "Tapa de seguridad", "{{Pill}} Aparecen más píldoras"},
	{"45", "As de espadas", "{{Card}} Aparecen más cartas"},
	{"46", "Tenedor de Isaac", "Posibilidad de curarse medio corazón al limpiar la habitación"},
	{"47", "", "<unused>"},
	{"48", "Una página perdida", "Cuando te golpean, posibilidad de dañar a toda la habitación"},
	{"49", "Moneda sangrienta", "{{HalfHeart}} 50 % de posibilidad de generar medio corazón al coger monedas"},
	{"50", "Moneda quemada", "{{Bomb}} 50 % de posibilidad de generar bombas al coger monedas"},
	{"51", "Moneda plana", "{{Coin}} 50 % de posibilidad de generar llaves al coger monedas"},
	{"52", "Moneda falsificada", "50 % de probabilidad de conseguir más monedas al coger monedas"},
	{"53", "La garrapata", "{{BossRoom}} 15% menos de vida del jefe#{{BossRoom}} Cura 1 corazón rojo al entrar a la sala del jefe "},
	{"54", "Cabeza de Isaac", "Familiar con lágrimas penetrantes#Inflige 3,5 de daño"},
	{"55", "La fe de Maggy", "Recibe un corazón eterno al empezar una nueva planta"},
	{"56", "Lengua de Judas", "Reduce los precios del Pacto del Diablo de dos corazones a uno"},
	{"57", "Alma de ???", "Familiar que rebota por la habitación#Dispara en la misma dirección que el jugador#Inflige 3,5 de daño"},
	{"58", "Mechón de Sansón", "↑ {{Damage}} 1/15 de probabilidad de recibir daño +0.5 al matar un enemigo#El efecto sólo persiste en la sala"},
	{"59", "Ojo de Caín", "{{Collectible21}} 25% de posibilidad de revelar los iconos del mapa al empezar una nueva planta"},
	{"60", "Pata de pájaro de Eve", "Posibilidad de generar un pájaro muerto al matar un enemigo"},
	{"61", "La mano izquierda", "Convierte todos los cofres en cofres rojos"},
	{"62", "Rocas brillantes", "Las rocas especiales brillan cada 10 segundos"},
	{"63", "Tijeras de seguridad", "Convierte las bombas troll en bombas"},
	{"64", "Gusano arcoíris", "Efecto de gusano aleatorio cada 3 segundos"},
	{"65", "Cinta de gusano", "↑ Duplica el Alcance#-50 % de tamaño de lágrima"},
	{"66", "Gusano vago", "↓ {{Shotspeed}} Vel. de disparo -0.4#↑ {{Range}} Alcance +4"},
	{"67", "Dado roto", "Efecto de dado aleatorio cuando te golpean"},
	{"68", "Superimán", "Imán para recolectables y enemigos"},
	{"69", "Polaroid desvanecida", "Te camufla de manera aleatoria#Desorienta a los enemigos"},
	{"70", "Piojo", "Posibilidad de generar una araña azul"},
	{"71", "La vejiga de Bob", "Las bombas sueltan creep"},
	{"72", "Pila de botón", "Genera más baterías#5 % de posibilidad de que añada una carga al objeto activo cuando limpias una habitación"},
	{"73", "Tapón de explosivos", "Explotar bombas puede generar más bombas"},
	{"74", "Detector de clavos", "Más posibilidad de que aparezcan trampillas al romper rocas"},
	{"75", "Error", "Efecto de trinket aleatorio para cada habitación"},
	{"76", "Ficha de póker", "50 % de probabilidad de conseguir más recolectables o 50 % de no conseguir nada o un enemigo"},
	{"77", "Ampolla", "Aumenta el empuje"},
	{"78", "Segunda mano", "Dobla la duración de los efectos en enemigos"},
	{"79", "Sin nombre y sin fin", "25% de probabilidad de que, al usar una píldora o una carta, aparezca una copia de la misma"},
	{"80", "Pluma negra", "↑ {{Damage}} Daño +0.2 por cada objeto \"malvado\" que tengas"},
	{"81", "Furia ciega", "La invencibilidad dura más"},
	{"82", "Herradura dorada", "{{TreasureRoom}} +15 % de posibilidad de obtener dos salas del tesoro en la siguiente planta"},
	{"83", "Llave de la tienda", "{{Shop}} Abre las tiendas gratis"},
	{"84", "Costilla de la codicia", "Greed/Super Greed ya no aparece en la tienda#{{Coin}} Aparecen más monedas"},
	{"85", "Karma", "Usar una máquina de donación puede curarte o generar un mendigo"},
	{"86", "Pequeña larva", "Romper una caca genera una mosca azul"},
	{"87", "Medallón de Mamá", "Cura medio corazón al usar llaves#Los medios corazones aparecen como corazones enteros"},
	{"88", "¡NO!", "Poca probabilidad de que aparezcan objetos activables en la sala del tesoro"},
	{"89", "Correa de niños", "Los familiares están más cerca del jugador y entre ellos"},
	{"90", "Tapón de caca", "La caca explota cuando la destruyes"},
	{"91", "Meconio", "Aumenta la probabilidad de que aparezcan cacas negras#Al romper una caca negra puede generar un corazón negro"},
	{"92", "Corona rota", "↑ Las estadísticas basadas en objetos de Isaac son un 33% más efectivas#↑ {{Tears}} Lágrimas +0.2"},
	{"93", "Pañal usado", "Posibilidad de que las moscas enemigas sean aliadas"},
	{"94", "Cola de pez", "Duplica todas las moscas y arañas azules"},
	{"95", "Diente negro", "Posibilidad de disparar un diente negro aleatoriamente"},
	{"96", "Gusano Ouroboros", "Las lágrimas se mueven rápido en espiral#Lágrimas espectrales#↑ +4 de Alcance"},
	{"97", "Amígdala", "Posibilidad de recibir un familiar cuando te golpean de 12 a 20 veces#Hasta 2 familiares"},
	{"98", "Nariz de duende", "Probabilidad de disparar lágrimas venenosas que se pegan a los enemigos"},
	{"99", "Superbola", "Probabilidad de disparar lágrimas que rebotan"},
	{"100", "Bombilla encendida", "!!! Al tener un objeto activable cargado al completo:#↑ {{Speed}} Velocidad +0.25#↑ {{Range}} Alcance +0.75 de Alcance#↑ {{Tears}} Lágrimas +0.2#↑ {{Shotspeed}} Vel. de Disparo +0.1#↑ {{Damage}} Daño +0.5#↑ {{Luck}} Suerte +1"},
	{"101", "Bombilla apagada", "!!! Al tener un objeto activable descargado :#↑ {{Speed}} Velocidad +0.5#↑ {{Range}} Alcance +1.5#↑ {{Tears}} Lágrimas +0.4#↑ {{Speed}} Velocidad +0.3#↑ {{Damage}} Daño +1.5#↑ {{Luck}} Suerte +2"},
	{"102", "Carta fragmentada", "{{SecretRoom}} +1 sala secreta adicional por planta"},
	{"103", "¡Igualdad!", "!!! Cuando tienes el mismo número de monedas, llaves y bombas:#Convierte los medios recolectables en dobles"},
	{"104", "Hueso de los deseos", "Posibilidad de generar un objeto al ser golpeado#Se acaba destruyendo"},
	{"105", "Bolsa del almuerzo", "Posibilidad de generar un objeto de vida {{Collectible22}} al ser golpeado#Se acaba destruyendo"},
	{"106", "Corcho perdido", "Aumenta el radio de cualquier creep que produzcas"},
	{"107", "Corazón de cuervo", "Al recibir daño, los corazones rojos son dañados antes que los de alma o negros"},
	{"108", "Nuez", "Probabilidad de soltar un recolectable o trinket aleatorio al ser golpeado por una explosión#Se acaba destruyendo"},
	{"109", "Cinta adhesiva", "Hace que los orbitales dejen de moverse"},
	{"110", "Moneda de plata", "{{Shop}} Ahora aparecen tiendas en el Útero de Mamá"},
	{"111", "Corona sangrienta", "{{TreasureRoom}} Ahora aparecen salas del tesoro en el Capítulo 4 (Útero/Matriz/Matriz Desgarrada)"},
	{"112", "Paga para ganar", "{{TreasureRoom}} Las máquinas de restock aparecen en la sala del tesoro "},
	{"113", "Langosta de guerra", "Genera una mosca explosiva al entrar en una habitación#La mosca inflige el doble de tu daño + explosión"},
	{"114", "Langosta de la peste", "Genera una mosca venenosa al entrar en una habitación#La mosca inflige el doble de tu daño"},
	{"115", "Langosta del hambre", "Genera una mosca que ralentiza al entrar en una habitación#La mosca inflige el doble de tu daño"},
	{"116", "Langosta de la muerte", "Al entrar a una habitación con enemigos, genera una mosca que inflige cuatro veces tu daño"},
	{"117", "Langosta de la conquista", "Al entrar a una habitación con enemigos, genera 2-5 moscas que infligen el doble de tu daño"},
	{"118", "Ala de murciélago", "Posibilidad de volar al ser golpeado#Dura esa habitación"},
	{"119", "Célula madre", "{{HalfHeart}} Cura medio corazón al cambiar de planta"},
	{"120", "Horquilla", "Recarga el objeto activable al completo al entrar en la sala del jefe"},
	{"121", "Cruz de madera", "{{Collectible 313}} Te protege del primer daño recibido en cada planta"},
	{"122", "¡Mantequilla!", "Al usar el coleccionable activable, el jugador lo soltará al suelo"},
	{"123", "Pluma de filigrana", "Hace que los ángeles generen objetos normales en lugar de piezas de llave"},
	{"124", "Tope para puerta", "La última puerta usada se mantendrá abierta"},
	{"125", "Cable de extensión", "Genera un láser entre los familiares"},
	{"126", "Moneda podrida", "Genera una mosca azul al coger monedas"},
	{"127", "Bebé doblado", "Las lágrimas de los familiares son teledirigidas"},
	{"128", "Dedo de hueso", "{{EmptyBoneHeart}} Posibilidad de ganar un corazón de hueso cuando te golpean"},
}

---------- Cards ----------
EID.descriptions[languageCode].cards={
	{"1", "0 - El Bufón", "Te teletransporta de nuevo al inicio"},
	{"2", "I - El Mago", "Lágrimas teledirigidas en la habitación actual"},
	{"3", "II - La Suma Sacerdotisa", "El Pie de Mamá pisa a un enemigo"},
	{"4", "III - La Emperatriz", "Durante la habitación, recibes: #↑ {{Damage}} Daño +2.35 de daño#↑ {{Speed}} Velocidad +0.3"},
	{"5", "IV - El Emperador", "{{BossRoom}} Teletransporta a la sala del jefe "},
	{"6", "V - El Sumo Sacerdote", "{{SoulHeart}} Suelta 2 corazones de alma"},
	{"7", "VI - Los Enamorados", "{{Heart}} Suelta 2 corazones rojos"},
	{"8", "VII - El Carruaje", "Invencibilidad + daño por contacto durante 6 segundos"},
	{"9", "VIII - Justicia", "Genera: #{{Bomb}} 1 bomba#{{Key}} 1 llave#{{Coin}} 1 moneda#{{Heart}} 1 corazón"},
	{"10", "IX - El Ermitaño", "{{Shop}} Te teletransporta a la tienda"},
	{"11", "X - La Rueda de la Fortuna", "Genera una {{Slotmachine}} tragaperras o una {{FortuneTeller}} máquina de la fortuna"},
	{"12", "XI - Fuerza", "Durante la habitación actual, recibes: #↑ {{Heart}} +1 de vida#↑ {{Speed}} Velocidad +0.3#↑{{Range}} Alcance +5.25#↑ {{Damage}} Daño +50% y +0.3"},
	{"13", "XII - El Colgado", "{{Collectible20}} Permite volar en la habitación actual"},
	{"14", "XIII - Muerte", "{{Collectible35}} Inflige 40 de daño a todos los enemigos de la habitación"},
	{"15", "XIV - Templanza", "{{BloodDonationMachine}} Genera una máquina de donación de sangre"},
	{"16", "XV - El Diablo", "↑ {{Damage}} Daño +2 durante la habitación actual"},
	{"17", "XVI - La Torre", "Invoca bombas troll"},
	{"18", "XVII - Las Estrellas", "{{TreasureRoom}} Te teletransporta a la sala del tesoro"},
	{"19", "XVIII - La Luna", "{{SecretRoom}} Teletransporta a la sala secreta "},
	{"20", "XIX - El Sol", "Inflige 100 de daño a todos los enemigos #Vida al completo#Muestra el mapa completo"},
	{"21", "XX - Juicio", "{{Beggar}} Genera un mendigo"},
	{"22", "XXI - El Mundo", "{{Collectible54}} Muestra el mapa completo y {{Collectible21}} los tipos de habitación"},
	{"23", "2 de tréboles", "{{Bomb}} Duplica las bombas"},
	{"24", "2 de diamantes", "{{Coin}} Duplica el dinero"},
	{"25", "2 de picas", "{{Key}} Duplica las llaves"},
	{"26", "2 de corazones", "{{Heart}} Duplica los corazones rojos #Solo tiene efecto curativo"},
	{"27", "As de tréboles", "{{Bomb}} Convierte todos los recolectables en bombas"},
	{"28", "As de diamantes", "{{Coin}} Convierte todos los recolectables en monedas"},
	{"29", "As de picas", "{{Key}} Convierte todos los recolectables en llaves"},
	{"30", "As de corazones", "{{Heart}} Convierte todos los recolectables en corazones"},
	{"31", "Joker", "{{DevilRoom}} / {{AngelRoom}} Te teletransporta a la sala del Diablo o el Ángel"},
	{"32", "Hagalaz", "Destruye todas las rocas de la habitación"},
	{"33", "Jera", "Duplica los recolectables de la habitación"},
	{"34", "Ehwaz", "{{Crawlspace}} Genera una trampilla"},
	{"35", "Dagaz", "{{SoulHeart}} +1 corazón de alma#{{CurseCursed}} Elimina efectos de maldición"},
	{"36", "Ansuz", "{{Collectible333}} Visión completa del mapa en esta planta"},
	{"37", "Perthro", "{{Collectible105}} Cambia los items de pedestal de la sala"},
	{"38", "Berkano", "Genera 3 arañas azules y 3 moscas azules"},
	{"39", "Algiz", "{{Collectible58}} Invencibilidad durante 30 segundos"},
	{"40", "Runa en blanco", "Efecto de runa aleatorio#25% de probabilidad de que vuelva a aparecer"},
	{"41", "Runa negra", "Inflige 40 de daño a todos los enemigos#{{Collectible477}} Destruye todos los objetos de pedestal de la sala, recibes una estadística aleatoria por cada objeto coleccionable de la habitación#"},
	{"42", "Carta del caos", "Carta lanzable que mata al instante"},
	{"43", "Tarjeta de crédito", "Borra el precio de todos los objetos de la tienda actual o el Pacto con el Diablo, haciendo que todo sea gratis"},
	{"44", "Carta de reglas", "Al usarlo muestra consejos \"útiles\" "},
	{"45", "Una Carta Contra la Humanidad", "Llena toda la habitación de caca"},
	{"46", "Rey suicida", "Te mata instantáneamente y genera 10 recolectables/coleccionables en el suelo"},
	{"47", "Carta Sal Libre de Prisión", "Abre todas las puertas de la habitación actual"},
	{"48", "¿? Carta", "Activa el objeto activable sin gastar cargas"},
	{"49", "Fragmento de Dado", "Cambia todos los pedestales y recolectables de la habitación actual"},
	{"50", "Contacto de emergencia", "Dos manos de Mamá caen y cogen a un enemigo"},
	{"51", "Carta sagrada", "Otorga el efecto de {{Collectible313}} Manto Sagrado en una habitación#25 % de probabilidad de generar otra carta sagrada"},
	{"52", "Gran Crecimiento", "Durante la habitación actual, recibes: #↑ {{Damage}} Daño +7#↑ {{Range}} Alcance +30#↑ +Tamaño#Capacidad de romper rocas"},
	{"53", "Recuerdo Antiguo", "Al usarla genera 3 cartas aleatorias"},
	{"54", "Caminando una Era", "Durante la habitación actual, recibes: #↑ {{Speed}} Velocidad +0.5#{{Shotspeed}} Vel. de tiro 0.40#Los enemigos se ralentizan"},
}

---------- Pills ----------
EID.descriptions[languageCode].unidentifiedPill = "Píldora sin identificar"

EID.descriptions[languageCode].pills={
	{"0", "Vaya pedo", "Genera una nube de gas"},
	{"1", "Mal viaje", "Inflige 1 corazón de daño"},
	{"2", "Bolas de acero", "{{SoulHeart}} +2 corazones de alma"},
	{"3", "Las bombas son llaves", "Cambia el número de bombas por el de llaves"},
	{"4", "Diarrea explosiva", "Invoca 5 bombas troll"},
	{"5", "Salud completa", "{{Heart}} Vida al completo"},
	{"6", "Menos vida", "↓ {{Heart}} -1 corazón"},
	{"7", "Más vida", "↑ 1 {{EmptyHeart}} +1 contendor de corazón vacío"},
	{"8", "Sin efecto", "Sin efecto"},
	{"9", "Pubertad", "Al comer 3 te transformas en Adulto "},
	{"10", "Mosca bonita", "Añade 1 mosca orbital"},
	{"11", "Menos Alcance", "↓ {{Range}} Alcance -2"},
	{"12", "Más Alcance", "↑ {{Range}} Alcance +2.5"},
	{"13", "Menos velocidad", "↓ {{Speed}} Velocidad -0.12"},
	{"14", "Más velocidad", "↑ {{Speed}} Valocidad +0.15"},
	{"15", "Menos lágrimas", "↓ {{Tears}} Lágrimas -0.28"},
	{"16", "Más lágrimas", "↑ {{Tears}} Lágrimas +0.35"},
	{"17", "Menos suerte", "↓ {{Luck}} Suerte -2"} ,
	{"18", "Más suerte", "↑ {{Luck}} Suerte +1"},
	{"19", "¡Teletransporta!", "Teletransporta a una habitación aleatoria"},
	{"20", "¡48 horas de energía!", "{{Battery}} Recarga tu objeto activable#{{Battery}} Genera 1 o 2 baterías"},
	{"21", "Hematémesis", "{{Heart}} Drena todos los corazones menos el último#{{Heart}} Genera de 1 a 4 corazones rojos"},
	{"22", "Parálisis", "No puedes moverte durante unos segundos"},
	{"23", "¡Puedo ver para siempre!", "{{SecretRoom}} Abre las habitaciones secretas de la planta actual"},
	{"24", "Feromonas", "{{Charm}} Encanta a todos los enemigos de la habitación"},
	{"25", "Amnesia", "{{CurseLost}} Oculta el mapa"},
	{"26", "Fiesta de limonada", "Genera charcos que dañan a los enemigos"},
	{"27", "¿Eres un mago?", "Durante 60 segundos disparas en diagonal"},
	{"28", "¡Percs!", "Solo te hacen la mitad del daño en la habitación actual"},
	{"29", "¡Adicto!", "Recibe un corazón de daño en la habitación actual"},
	{"30", "Relaxante", "Genera una caca al andar durante 2 segundos"},
	{"31", "¿¿??", "{{CurseMaze}} Maldición del Laberinto durante todo el piso"},
	{"32", "Una te hace grande", "Creces#No afecta a la hitbox"},
	{"33", "Una te hace pequeño", "Te haces pequeño#La hitbox se hace más pequeña"},
	{"34", "¡Infestado!", "Genera 1 mosca azul por cada caca de la habitación"},
	{"35", "¿Infestado?", "Genera 1 araña azul por cada enemigo de la habitación#Genera entre 1 y 3 arañas cuando no hay enemigos"},
	{"36", "Píldora de visión", "Efecto de invencibilidad corto"},
	{"37", "¡Visión retro!", "Pixela la pantalla durante 30 segundos"},
	{"38", "¡Amigos hasta el fin!", "Invoca 3 moscas aliadas"},
	{"39", "X-Lax", "Genera una piscina de creep resbaladizo"},
	{"40", "Hay algo mal", "Genera una piscina de creep ralentizante"},
	{"41", "Tengo mucho sueño...", "Ralentiza a todos los enemigos de la habitación"},
	{"42", "¡¡TENGO MUCHA ENERGÍA!!", "Acelera a todos los enemigos de la habitación"},
	{"43", "¡Glup!", "{{Trinket}} Consume el trinket actual y ganas su efecto de manera permanente"},
	{"44", "¡Horf!", "{{Collectible149}} Dispara una lágrima de Ipecac"},
	{"45", "¡Es como si caminara sobre el sol!", "Efecto de invencibilidad corto"},
	{"46", "¡Vurp!", "Genera la última píldora usada"},
}

---------- Sacrifice Room ----------
EID.descriptions[languageCode].sacrificeHeader = "[Siguiente pago de la sala del Sacrificio]"

EID.descriptions[languageCode].sacrifice={
	{"1", "", "{{Coin}} 50% de probabilidad de 1 moneda#{{Bomb}} 100% de probabilidad de 1 bomba al matar al Jefe de B1 en menos de 1 minuto"},
	{"2", "", "{{Coin}} 50% de probabilidad de 1 moneda#{{Bomb}} 100 % de probabilidad de 1 bomba al matar al Jefe de B1 en menos de 1 minuto"},
	{"3", "", "{{AngelRoom}} 67% más de probabilidad de que aparezca la sala del Ángel en lugar de la del Diablo"},
	{"4", "", "50 % de probabilidad de 1 cofre aleatorio"},
	{"5", "", "33 % de probabilidad de 3 monedas#67 % más de probabilidad de que aparezca la sala del Ángel{{AngelRoom}} en lugar de la del Diablo"},
	{"6", "", "33 % de probabilidad de teletransportar a la sala del Ángel{{AngelRoom}}/Diablo{{DevilRoom}}#67 % de probabilidad de un cofre aleatorio"},
	{"7", "", "{{AngelRoom}} 33% de probabilidad de 1 objeto aleatorio de la sala del Ángel#{{SoulHeart}} 67% de probabilidad de 1 corazón de alma"},
	{"8", "", "100 % de probabilidad de generar 7 bombas troll"},
	{"9", "", "100 % de probabilidad de generar al ángel \"Uriel\""},
	{"10", "", "{{SoulHeart}} 50% de probabilidad de 7 corazones de alma#{{Coin}} 50% de probabilidad de 30 monedas"},
	{"11", "", "100 % de probabilidad de generar al ángel \"Gabriel\""},
	{"12", "", "50 % de probabilidad de teletransportar al Cuarto Oscuro"},
}

---------- Dice Room ----------
EID.descriptions[languageCode].diceHeader = "[Efecto del dado]"

EID.descriptions[languageCode].dice={
	{"1", "", "Cambia tus objetos#(no afecta a los recolectables)"},
	{"2", "", "Cambia los recolectables de la habitación"},
	{"3", "", "Cambia todos los recolectables de la planta"},
	{"4", "", "Cambia los objetos de los pedestales de la planta#No afecta los Pactos del Diablo"},
	{"5", "", "Cambia y reinicia la planta actual"},
	{"6", "", "Cambia todos tus objetos y recolectables, además de los objetos de toda la planta"}
}

---------- Transformations ----------
EID.descriptions[languageCode].transformations={
	"",							-- 0 = none
	"Guppy",					-- 1
	"Fungi",					-- 2
	"Señor de las moscas",		-- 3
	"Siameses",					-- 4
	"Adicto",					-- 5
	"¿Sí, madre?",				-- 6
	"Me cago en...",			-- 7
	"Bob",						-- 8
	"Leviatán",					-- 9
	"Serafín",					-- 10
	"Super-pordiosero",			-- 11
	"Ratón de biblioteca",		-- 12
	"Bebé araña",				-- 13
	"Adulto",					-- 14
	"Gigante"					-- 15
}

---------- Misc. text ----------
EID.descriptions[languageCode].VoidText = "Si lo absorbes, ganarás:"
EID.descriptions[languageCode].VoidNames = {"de Velocidad {{Speed}}", "de Lágrimas {{Tears}}", "de Daño {{Damage}}", "de Alcance {{Range}}", "de Vel. de tiro {{Shotspeed}}", "de Suerte {{Luck}}"}

EID.descriptions[languageCode].MCM = {
	DemoObjectName = "Nombre de objeto demostrativo",
	DemoObjectTransformation = "Transformación demostrativa",
	DemoObjectText = "Este texto está en español#¡Una larga y genial descripción para demostrar los saltos de línea causados por la anchura de texto de EID!#\1 Esta linea también es genial#Esta linea te ama {{Heart}}#{{AngelDevilChance}} Esta línea puede ser tu ángel o tu demonio#\1 {{Damage}} Aumento de stat +1",
} 

EID.descriptions[languageCode].CollectionPageInfo = "¡Debes tomar este objeto para completar la pagina de colección!"

EID.descriptions[languageCode].HoldMapTitle = "Recordatorio"
-- the Hold Map description will predict the abilities of items with a header like "Item Name Result"
EID.descriptions[languageCode].HoldMapHeader = " Resultado"

-- currently used for D1
EID.descriptions[languageCode].PickupNames = {
	["5.0"] = "None",
	
	["5.10"] = "{{Heart}} Corazón",
	["5.10.1"] = "{{Heart}} Corazón", ["5.10.2"] = "{{HalfHeart}} Medio corazón", ["5.10.3"] = "{{SoulHeart}} Corazón de alma", ["5.10.4"] = "{{EternalHeart}} Corazón eterno", ["5.10.5"] = "{{Heart}} Corazón doble", ["5.10.6"] = "{{BlackHeart}} Corazón negro", ["5.10.7"] = "{{GoldHeart}} Corazón dorado", ["5.10.8"] = "{{HalfSoulHeart}} Medio corazón de alma", ["5.10.9"] = "{{Heart}} Corazón aterrado", ["5.10.10"] = "{{BlendedHeart}} Corazón dividido", ["5.10.11"] = "{{EmptyBoneHeart}} Corazón de hueso", ["5.10.12"] = "{{RottenHeart}} Corazón podrido",
	
	["5.20"] = "{{Coin}} Coin",
	["5.20.1"] = "{{Crafting8}} Centavo", ["5.20.2"] = "{{Crafting9}} Níquel", ["5.20.3"] = "{{Crafting10}} 10 centavos", ["5.20.4"] = "{{Crafting8}} Doble centavo", ["5.20.5"] = "{{Crafting11}} Centavo de la suerte", ["5.20.6"] = "{{Crafting9}} Níquel pegajoso", ["5.20.7"] = "{{Crafting26}} Centavo dorado",
	
	["5.30"] = "{{Key}} Key",
	["5.30.1"] = "{{Crafting12}} Llave", ["5.30.2"] = "{{Crafting13}} Llave dorada", ["5.30.3"] = "{{Crafting12}} Llavero", ["5.30.4"] = "{{Crafting14}} Llave cargada",
	
	["5.40"] = "{{Bomb}} Bomb",
	["5.40.1"] = "{{Crafting15}} Bomba", ["5.40.2"] = "{{Crafting15}} Bomba doble", ["5.40.3"] = "{{Crafting15}} Bomba troll", ["5.40.4"] = "{{Crafting16}} Bomba dorada", ["5.40.5"] = "{{Crafting15}} Bomba megatroll", ["5.40.7"] = "{{Crafting17}} Giga bomba",
	
	["5.90"] = "{{Battery}} Battery",
	["5.90.0"] = "{{Crafting19}} Batería", --AB+ didn't have subtypes for batteries
	["5.90.1"] = "{{Crafting19}} Batería", ["5.90.2"] = "{{Crafting18}} Micro batería", ["5.90.3"] = "{{Crafting20}} Mega batería", ["5.90.4"] = "{{Crafting28}} Batería dorada",
	
	["5.50"] = "{{Chest}} Cofre", ["5.51"] = "{{BombChest}} Cofre de piedra", ["5.52"] = "{{SpikedChest}} Cofre con pinchos", ["5.53"] = "{{EternalChest}} Cofre eterno", ["5.54"] = "{{MimicChest}} Cofre mímico", ["5.55"] = "{{OldChest}} Cofre viejo", ["5.56"] = "{{WoodenChest}} Cofre de madera", ["5.57"] = "{{MegaChest}} Mega cofre", ["5.58"] = "{{HauntedChest}} Cofre embrujado", ["5.60"] = "{{GoldenChest}} Cofre dorado", ["5.360"] = "{{RedChest}} Cofre rojo",  
	
	["5.69"] = "{{GrabBag}} Saco", ["5.69.1"] = "{{GrabBag}} Saco", ["5.69.2"] = "{{BlackSack}} Saco negro",
	
	["5.70"] = "{{Pill}} Píldora",
	["5.300"] = "{{Card}} Carta",
	["5.301"] = "{{Rune}} Runa", -- not a real id
	["5.350"] = "{{Trinket}} Trinket",

}

EID.descriptions[languageCode].MCM = {
	DemoObjectName = "Nombre de objeto demostrativo",
	DemoObjectTransformation = "Transformación demostrativa",
	DemoObjectText = "Este texto está en español#¡Una larga y genial descripción para demostrar los saltos de línea causados por la anchura de texto de EID!#\1 Esta linea también es genial#Esta linea te ama {{Heart}}",
} 