---------------------------------------
-----  Basic Japanese descriptions ----
---------------------------------------

-- FORMAT: Item ID | Name | Description

-- Special character markup:
-- ↑ = Up Arrow  |  ↓ = Down Arrow  |  ! = Warning  |  # = Starts a new line
-- More can be found here: https://github.com/wofsauge/External-Item-Descriptions/wiki/Markup

local languageCode = "ja_jp"

-- init ja_jp table
EID.descriptions[languageCode] = {}
EID.descriptions[languageCode].custom = {} -- table for custom entity descriptions
EID.descriptions[languageCode].languageName = "Japanese"

-- Fonts to be used with this language pack
EID.descriptions[languageCode].fonts = {{name="default"}, {name="inverted"}, {name="borderless"}}

---------- Collectibles ----------
EID.descriptions[languageCode].collectibles={
    {"1", "The Sad Onion", "↑ 連射速度 +0.7"},
    {"2", "The Inner Eye", "トリプルショットの涙#↓ 連射速度"},
    {"3", "Spoon Bender", "涙にホーミング効果を付与"},
    {"4", "Cricket's Head", "↑ 攻撃力 +0.5#↑ 攻撃力 +50%"},
    {"5", "My Reflection", "涙にブーメラン軌道を付与#↑ 射程　　 +1.5#↑ 弾速　　 +0.6#↑ 涙の高さ +1"},
    {"6", "Number One", "↑ 連射速度 +1.5#↓ 射程　　 -17.62#↑ 涙の高さ +0.76"},
    {"7", "Blood of the Martyr", "↑ 攻撃力 +1#{{Collectible34}} ベリアルの本 または#{{Card16}} 悪魔のカード 使用時、 攻撃力が追加で50%アップ"},
    {"8", "Brother Bobby", "3.5 ダメージのノーマルな 涙で攻撃する使い魔"},
    {"9", "Skatole", "ハエタイプの敵が中立化し、 無害になる"},
    {"10", "Halo of Flies", "二匹の黒いハエが アイザックを周回し、 敵の弾をブロックする"},
    {"11", "1up!", "↑ 追加ライフ +1#死ぬと、一つ前の部屋に 体力全回復の状態で復活"},
    {"12", "Magic Mushroom", "体力全回復#↑ 最大体力 +1#↑ 攻撃力　 +0.3#↑ 攻撃力　 +50%#↑ 射程　　 +5.25#↑ 移動速度 +0.3#↑ 涙の高さ +0.5#アイザックのサイズ拡大"},
    {"13", "The Virus", "接触した敵に毒を与える#毒を受けた敵が死んだ時、 20%の確率で黒ハートを 落とす#↓ 移動速度 -0.1"},
    {"14", "Roid Rage", "↑ 移動速度 +0.6#↑ 射程　　 +5.25#↑ 涙の高さ +0.5"},
    {"15", "<3", "↑ 最大体力 +1#体力全回復"},
    {"16", "Raw Liver", "↑ 最大体力 +2#体力全回復"},
    {"17", "Skeleton Key", "鍵 +99"},
    {"18", "A Dollar", "コイン +99"},
    {"19", "Boom!", "爆弾 +10"},
    {"20", "Transcendence", "飛行能力を付与"},
    {"21", "The Compass", "部屋のアイコンが マッピングされる"},
    {"22", "Lunch", "↑ 最大体力 +1"},
    {"23", "Dinner", "↑ 最大体力 +1"},
    {"24", "Dessert", "↑ 最大体力 +1"},
    {"25", "Breakfast", "↑ 最大体力 +1"},
    {"26", "Rotten Meat", "↑ 最大体力 +1"},
    {"27", "Wooden Spoon", "↑ 移動速度 +0.3"},
    {"28", "The Belt", "↑ 移動速度 +0.3"},
    {"29", "Mom's Underwear", "↑ 射程　　 +5.25#↑ 涙の高さ +0.5"},
    {"30", "Mom's Heels", "↑ 射程　　 +5.25#↑ 涙の高さ +0.5"},
    {"31", "Mom's Lipstick", "↑ 射程　　 +5.25#↑ 涙の高さ +0.5"},
    {"32", "Wire Coat Hanger", "↑ 連射速度 +0.7"},
    {"33", "The Bible", "その部屋に居る間、 飛行能力を付与#ママを即死させる#!!! サタン戦で使用すると アイザックが即死する"},
    {"34", "The Book of Belial", "↑ 攻撃力 +2#↑ 悪魔部屋／天使部屋の 出現率 +12.5%#{{Collectible7}} 殉教者の血を所有時、 攻撃力が追加で50%増"},
    {"35", "The Necronomicon", "部屋の全ての敵に 40ダメージを与える"},
    {"36", "The Poop", "うんちを出し、敵を ノックバックさせる#一マスの穴の手前に 出して爆破すると、 橋の代わりになる"},
    {"37", "Mr. Boom", "大型の爆弾を設置する#爆発は110ダメージを与える"},
    {"38", "Tammy's Head", "円形に10発の涙を同時発射"},
    {"39", "Mom's Bra", "部屋の全ての敵を4秒間 石化させる"},
    {"40", "Kamikaze!", "自爆攻撃#爆発は40ダメージを与える"},
    {"41", "Mom's Pad", "部屋の全ての敵を5秒間 恐怖状態にする"},
    {"42", "Bob's Rotten Head", "手投げ式の毒爆弾"},
    {"43", "", "<item does not exist>"},
    {"44", "Teleport!", "ランダムな部屋に テレポートする#{{Blank}} (I AM ERRORを除く)"},
    {"45", "Yum Heart", "赤ハートを1個回復"},
    {"46", "Lucky Foot", "↑ 運 +1#ギャンブルの勝率アップ#部屋クリア時の報酬 スポーン確率アップ"},
    {"47", "Doctor's Remote", "指定地点にミサイルを 落とす#ミサイルは攻撃力ｘ20の ダメージを与える"},
    {"48", "Cupid's Arrow", "涙に貫通効果を付与"},
    {"49", "Shoop da Whoop!", "ブリムストーンの レーザービームを発射"},
    {"50", "Steven", "↑ 攻撃力 +1"},
    {"51", "Pentagram", "↑ 攻撃力 +1#↑ 悪魔部屋／天使部屋の 出現率 +10%"},
    {"52", "Dr. Fetus", "涙が爆弾に置き換わる#爆弾は攻撃力ｘ5+30の ダメージを与える#↓ 連射間隔 ｘ2.5"},
    {"53", "Magneto", "ピックアップが障害物を 飛び越えてアイザックに 引き寄せられるようになる"},
    {"54", "Treasure Map", "フロアの構造が マッピングされる"},
    {"55", "Mom's Eye", "一定確率で涙が後ろにも 発射されるようになる#確率：運0=50%、2=100%"},
    {"56", "Lemon Mishap", "レモン汁が床に広がり、 触れた敵に毎秒24の ダメージを与える"},
    {"57", "Distant Admiration", "赤いハエがアイザックを 周回し、接触した敵に 毎秒75ダメージを与える"},
    {"58", "Book of Shadows", "ダメージを無効化する シールドを10秒間付与"},
    {"59", "", "<item does not exist>"},
    {"60", "The Ladder", "一マス分の穴にハシゴが かかり、横断可能になる"},
    {"61", "", "<item does not exist>"},
    {"62", "Charm of the Vampire", "敵を13体倒すたび、 半赤ハート回復する"},
    {"63", "The Battery", "アクティブアイテムの チャージの最大容量が 2回分になる"},
    {"64", "Steam Sale", "お店の商品が半額になる#このアイテムを2個取得 すると商品が無料になる"},
    {"65", "Anarchist Cookbook", "トロル爆弾を6個スポーン"},
    {"66", "The Hourglass", "部屋の全ての敵を8秒間 スロー状態にする"},
    {"67", "Sister Maggy", "3.5 ダメージのノーマルな 涙で攻撃する使い魔"},
    {"68", "Technology", "涙が貫通・無限射程の レーザーに置き換わる"},
    {"69", "Chocolate Milk", "涙がチャージ式になり、 チャージ量に応じて 10～400%のダメージを 与える#↓ 連射速度"},
    {"70", "Growth Hormones", "↑ 攻撃力　 +1#↑ 移動速度 +0.4"},
    {"71", "Mini Mush", "↑ 移動速度 +0.3#↓ 射程　　 -4.25#↑ 涙の高さ +1.5#↑ アイザックのサイズ縮小"},
    {"72", "Rosary", "青ハート +3#{{Collectible33}} 聖書が全てのアイテム プールに追加される"},
    {"73", "Cube of Meat", "肉塊がアイザックを周回し、 敵に接触ダメージを与え、 弾をブロックする#複数個取得で進化：#{{Blank}} 2：涙で攻撃#{{Blank}} 3：ミートボーイになり、 　 敵を追いかけ攻撃#{{Blank}} 4：ミートボーイ LV2#5個目からはループ"},
    {"74", "A Quarter", "コイン +25"},
    {"75", "PHD", "全てのピルが識別される#悪性のピルを良性に変換#取得時、ランダムなピルを 1個スポーンする#赤ハートを2個回復#売血時のコイン +0～2"},
    {"76", "X-Ray Vision", "隠し部屋が自動的に開く"},
    {"77", "My Little Unicorn", "6秒間無敵状態になり、 接触した敵に毎秒40の ダメージを与え、移動 速度が0.28アップする"},
    {"78", "Book of Revelations", "青ハートを1個付与する#使用すると、現フロアの ボスがハービンガーに 時々置き換えられる#↑ 保持中、悪魔部屋／天使 部屋の出現率 +17.5%"},
    {"79", "The Mark", "↑ 攻撃力　 +1#↑ 移動速度 +0.2#青ハート +1"},
    {"80", "The Pact", "↑ 攻撃力　 +0.5#↑ 連射速度 +0.7#青ハート +2"},
    {"81", "Dead Cat", "↑ 追加ライフ +9#↓ 最大体力を1に設定する#死ぬと、最大体力が1の 状態で、一つ前の部屋に 復活する"},
    {"82", "Lord of the Pit", "飛行能力を付与#↑ 移動速度 +0.3"},
    {"83", "The Nail", "青ハートを1個付与する#↑ 攻撃力　 +0.7#↓ 移動速度 -0.18#毎秒40の接触ダメージ 効果を得る#障害物を破壊できる"},
    {"84", "We Need To Go Deeper!", "次のフロアにつながる トラップドアを生成#10%の確率でクロール スペースにつながる"},
    {"85", "Deck of Cards", "ランダムなカードを 1枚スポーンする"},
    {"86", "Monstro's Tooth", "モンストロを召喚し、 踏み潰し攻撃で敵に 120ダメージを与える"},
    {"87", "Loki's Horns", "一定確率で涙が四方向に 発射されるようになる#確率：運0=25%、7=100%"},
    {"88", "Little Chubby", "涙の発射方向に連動して 突進する使い魔#毎秒52.5の接触ダメージ"},
    {"89", "Spider Bite", "一定確率で涙にスロー 効果を付与する#確率：運0=25%、15=100%"},
    {"90", "The Small Rock", "↑ 攻撃力　 +1#↑ 連射速度 +0.2#↓ 移動速度 -0.2"},
    {"91", "Spelunker Hat", "隣接する部屋の種類が マップに表示される#隠し部屋の位置も表示"},
    {"92", "Super Bandage", "↑ 最大体力 +1#青ハート +2#体力を1回復"},
    {"93", "The Gamekid", "6秒間パックマン化し、 以下の効果を得る：#無敵状態#全ての敵に恐怖を与える#40の接触ダメージ#敵を2体倒すたび 半赤ハート回復#涙攻撃不可"},
    {"94", "Sack of Pennies", "2部屋クリアするたび コインを1枚スポーン する使い魔"},
    {"95", "Robo-Baby", "3.5 ダメージのレーザーで 攻撃する使い魔"},
    {"96", "Little C.H.A.D.", "3部屋クリアするたび 半赤ハートをスポーン する使い魔"},
    {"97", "The Book of Sin", "ランダムなピックアップを 1個スポーンする"},
    {"98", "The Relic", "5～6部屋クリアするたび 1個の青ハートをスポーン する使い魔"},
    {"99", "Little Gish", "3.5 ダメージのスロー効果 付き涙で攻撃する使い魔"},
    {"100", "Little Steven", "3.5 ダメージのホーミング 効果付き涙で攻撃する 使い魔"},
    {"101", "The Halo", "↑ 最大体力 +1#↑ 攻撃力　 +0.3#↑ 連射速度 +0.2#↑ 射程　　 +0.25#↑ 移動速度 +0.3#↑ 涙の高さ +0.5"},
    {"102", "Mom's Bottle of Pills", "ランダムなピルを1個 スポーンする"},
    {"103", "The Common Cold", "一定確率で毒の涙を放つ#確率：運0=25%、12=100%"},
    {"104", "The Parasite", "衝突した涙が二つに分裂する#分裂した涙はダメージ量が 半減する"},
    {"105", "The D6", "部屋の全てのアイテムを リロールする"},
    {"106", "Mr. Mega", "↑ 爆弾ダメージｘ2.25#↑ 爆発範囲#爆弾 +5"},
    {"107", "The Pinking Shears", "頭と体を分離し、浮遊状態 になった頭部を操作する#体が敵を自動的に追いかけ、 毎秒82.5の接触ダメージを 与える"},
    {"108", "The Wafer", "受けるダメージを 半ハートに軽減する"},
    {"109", "Money = Power", "↑ 攻撃力 +0.04ｘ所持金"},
    {"110", "Mom's Contacts", "20%の確率で涙に 石化効果を付与する#↑ 射程　　 +0.25#↑ 涙の高さ +0.5"},
    {"111", "The Bean", "おならをし、近くの敵に 5ダメージと毒を与える"},
    {"112", "Guardian Angel", "天使がアイザックを周回し、 敵に接触ダメージを与え、 弾をブロックする#毎秒105の接触ダメージ#周回タイプの使い魔の 回転速度が上がる"},
    {"113", "Demon Baby", "3 ダメージの涙で近くの 敵を自動攻撃する使い魔"},
    {"114", "Mom's Knife", "涙がナイフに置き換わる#保持中のナイフは2倍の ダメージを与える#チャージ攻撃でナイフを 発射でき、折り返し地点 では6倍のダメージを与える"},
    {"115", "Ouija Board", "涙に透過効果を付与"},
    {"116", "9 Volt", "アクティブアイテムを フルチャージ#アクティブアイテムの 必要チャージ量が1減る#必要チャージ量が1の アイテムは、15秒の 時間式になる#時間式のアイテムは、 その時間が半減する"},
    {"117", "Dead Bird", "ダメージを受けると鳥が 現れ、その部屋に居る間、 敵を追いかけて攻撃する#毎秒5の接触ダメージ"},
    {"118", "Brimstone", "涙がチャージ式のレーザー ビームに置き換わる"},
    {"119", "Blood Bag", "↑ 最大体力 +1#↑ 移動速度 +0.3#体力を4回復"},
    {"120", "Odd Mushroom (Thin)", "↑ 連射速度 +1.7#↑ 移動速度 +0.3#↓ 攻撃力　 ｘ0.9-0.4"},
    {"121", "Odd Mushroom (Large)", "↑ 最大体力 +1#↑ 攻撃力　 +0.3#↑ 射程　　 +0.25#↑ 涙の高さ +0.5#↓ 移動速度 -0.1"},
    {"122", "Whore of Babylon", "残り体力が半赤ハート 以下の時：#↑ 攻撃力　 +1.5#↑ 移動速度 +0.3"},
    {"123", "Monster Manual", "ランダムな使い魔を 1匹付与する#その部屋でのみ有効"},
    {"124", "Dead Sea Scrolls", "ランダムなアクティブ アイテムの効果を発動"},
    {"125", "Bobby-Bomb", "爆弾がホーミング化#爆弾 +5"},
    {"126", "Razor Blade", "ハート1個のダメージを 受け、その部屋に居る間、 攻撃力を1.2増やす#赤ハートを優先して消費"},
    {"127", "Forget Me Now", "{{Warning}} 使い切りアイテム {{Warning}}#現在のフロアを再生成する"},
    {"128", "Forever Alone", "青いハエがアイザックを 周回し、接触した敵に 毎秒30ダメージを与える"},
    {"129", "Bucket of Lard", "↑ 最大体力 +2#↓ 移動速度 -0.2#体力0.5回復"},
    {"130", "A Pony", "保持中、飛行能力を付与#1.5以下の移動速度を 1.5に修正する#使用すると進行方向に 突進し、接触した敵に 40のダメージを与える#突進中は無敵"},
    {"131", "Bomb Bag", "2～3部屋クリアするたび 爆弾を1個スポーンする 使い魔"},
    {"132", "A Lump of Coal", "飛距離に応じて涙の ダメージが増加する"},
    {"133", "Guppy's Paw", "最大体力1個を 青ハート3個に変換"},
    {"134", "Guppy's Tail", "部屋のクリア報酬が 33%の確率で宝箱に、 33%の確率で無報酬に、 それぞれ置き換わる"},
    {"135", "IV Bag", "いつでも売血#1ダメージ = 1～3コイン#キーパー使用時は0～1枚"},
    {"136", "Best Friend", "敵を引きつけるデコイの 爆弾を設置する"},
    {"137", "Remote Detonator", "設置した爆弾を任意の タイミングで爆破する#初回取得時、爆弾 +5"},
    {"138", "Stigmata", "↑ 最大体力 +1#↑ 攻撃力　 +0.3"},
    {"139", "Mom's Purse", "トリンケットを2個まで 保持可能になる"},
    {"140", "Bob's Curse", "爆弾に毒効果を付与する#爆弾 +5"},
    {"141", "Pageant Boy", "ランダムなコインを 7枚スポーンする"},
    {"142", "Scapular", "残り体力が半ハートに なった時、青ハートを 1個付与する#効果は1部屋で1回のみ 有効だが、部屋に入り 直すと再度有効化する"},
    {"143", "Speed Ball", "↑ 移動速度 +0.3#↑ 弾速　　 +0.2"},
    {"144", "Bum Friend", "コインを拾いランダムな ピックアップに変換する 乞食が現れる"},
    {"145", "Guppy's Head", "青ハエを2～4匹スポーン"},
    {"146", "Prayer Card", "白ハートを1個付与"},
    {"147", "Notched Axe", "その部屋に居る間、斧で 障害物や壁を破壊できる"},
    {"148", "Infestation", "ダメージを受けるたび、 青ハエが1～3匹スポーン"},
    {"149", "Ipecac", "涙が毒爆弾に置き換わる#↑ 攻撃力 +40#↓ 連射速度"},
    {"150", "Tough Love", "一定確率で涙が歯に置き 換わり、攻撃力ｘ3.2の ダメージを与える#確率：運0=15%、9=100%"},
    {"151", "The Mulligan", "涙が敵に当たった時、 1/6の確率で青ハエが スポーンする"},
    {"152", "Technology 2", "右目の涙が連続照射の 貫通レーザーに置き換わる#↓ 攻撃力 -35%#レーザーは攻撃力ｘ0.2の ダメージを与える"},
    {"153", "Mutant Spider", "クアッドショットの涙#↓ 連射速度"},
    {"154", "Chemical Peel", "↑ 左目の攻撃力 +2"},
    {"155", "The Peeper", "目玉が部屋を飛び回り、 接触した敵に毎秒17の ダメージを与え、弾を ブロックする"},
    {"156", "Habit", "ダメージを受けるたび アクティブアイテムが 1チャージされる"},
    {"157", "Bloody Lust", "↑ ダメージを受けるたび 攻撃力がアップ (最大6回、+6.5)#効果は次のフロアまで有効"},
    {"158", "Crystal Ball", "フルマッピング効果#青ハートまたはカード・ ルーンのいずれか1個を スポーンする"},
    {"159", "Spirit of the Night", "飛行能力を付与#涙に透過効果を付与"},
    {"160", "Crack the Sky", "5本の光線が降り注ぎ、 触れた敵に攻撃力+20の ダメージを与える"},
    {"161", "Ankh", "{{Player4}} 死ぬと、一つ前の部屋に ？？？として復活する"},
    {"162", "Celtic Cross", "ダメージを受けた時、一定 確率でシールドを展開する#シールドは7秒間持続し、 全てのダメージを無効化#確率：運0=20%、27=100%"},
    {"163", "Ghost Baby", "3.5 ダメージの透過効果 付き涙で攻撃する使い魔"},
    {"164", "The Candle", "ロウソクから青い炎を放つ#炎が敵にダメージを与え、 弾をブロックする#炎は2秒で燃え尽きる"},
    {"165", "Cat-o-nine-tails", "↑ 攻撃力 +1#↑ 弾速　 +0.23"},
    {"166", "D20", "部屋の全ての宝箱と ピックアップをリロール"},
    {"167", "Harlequin Baby", "4 ダメージの涙をＶ字形に 発射して攻撃する使い魔"},
    {"168", "Epic Fetus", "涙が誘導ミサイルに置き 換わり、攻撃力ｘ20の ダメージを与える"},
    {"169", "Polyphemus", "↑ (攻撃力 +4)ｘ2#↓ (連射間隔ｘ2.1) +3#敵を倒した涙は減衰して 貫通する"},
    {"170", "Daddy Longlegs", "5秒に1回、巨大な足が敵を 踏み潰し、40のダメージを 与える"},
    {"171", "Spider Butt", "部屋の全ての敵に 10ダメージを与え、  4秒間スロー状態にする"},
    {"172", "Sacrificial Dagger", "短剣がアイザックを周回し、 敵に接触ダメージを与え、 弾をブロックする#毎秒225の接触ダメージ"},
    {"173", "Mitre", "赤ハートが50%の確率で 青ハートに置き換わって スポーンする"},
    {"174", "Rainbow Baby", "3～5ダメージのランダムな 特殊効果付き涙で攻撃する 使い魔"},
    {"175", "Dad's Key", "全てのドアと隠し部屋の 入り口を開放する#条件を満たしていない {{ChallengeRoom}}{{BossRushRoom}}チャレンジルーム・ メガサタンのドアも開放"},
    {"176", "Stem Cells", "↑ 最大体力 +1#↑ 弾速　　 +0.16"},
    {"177", "Portable Slot", "コインを1枚消費して スロットを回す"},
    {"178", "Holy Water", "アイザックに追従し、 ダメージを受けると 砕け、床に聖水をまく#聖水は9秒間持続し、 触れた敵に毎秒24の ダメージを与える"},
    {"179", "Fate", "飛行能力を付与#白ハート +1"},
    {"180", "The Black Bean", "ダメージを受けると おならをし、近くの敵に 5ダメージと毒を与える"},
    {"181", "White Pony", "保持中、飛行能力を付与#1.5以下の移動速度を 1.5に修正する#使用すると進行方向に 突進し、接触した敵に 40のダメージを与える#突進中は無敵#突進時に光線が降り注ぎ、 触れた敵に攻撃力+20の ダメージを与える"},
    {"182", "Sacred Heart", "体力全回復#↑ 最大体力 +1#↑ 攻撃力　 +230%#↑ 攻撃力　 +1#↓ 連射速度 -0.4#↓ 弾速　　 -0.25#↑ 射程　　 +0.38#↑ 涙の高さ +0.75#涙にホーミング効果を付与"},
    {"183", "Tooth Picks", "↑ 連射速度 +0.7#↑ 弾速　　 +0.16"},
    {"184", "Holy Grail", "飛行能力を付与#↑ 最大体力 +1"},
    {"185", "Dead Dove", "飛行能力を付与#涙に透過効果を付与"},
    {"186", "Blood Rights", "ハート 1個のダメージを 受け、部屋の全ての敵に 40のダメージを与える#赤ハートを優先して消費"},
    {"187", "Guppy's Hairball", "毛玉がアイザックを追従し、 敵に接触ダメージを与え、 弾をブロックする#毛玉で敵を倒すと、毛玉の サイズとダメージ量が増え、 最大5倍になる"},
    {"188", "Abel", "アイザックと鏡映しに 移動・攻撃する使い魔#3.5 ダメージのノーマルな 涙で攻撃する"},
    {"189", "SMB Super Fan", "体力全回復#↑ 最大体力 +1#↑ 攻撃力　 +0.3#↑ 連射速度 +0.2#↑ 射程　　 +0.5#↑ 移動速度 +0.2#↑ 涙の高さ +1"},
    {"190", "Pyro", "爆弾 +99"},
    {"191", "3 Dollar Bill", "2～3秒ごとにランダムな 特殊効果を涙に付与"},
    {"192", "Telepathy For Dummies", "その部屋に居る間、涙に ホーミング効果を付与"},
    {"193", "MEAT!", "↑ 最大体力 +1#↑ 攻撃力　 +0.3"},
    {"194", "Magic 8 Ball", "↑ 弾速 +0.16#取得時、ランダムな カードを1枚スポーン"},
    {"195", "Mom's Coin Purse", "ランダムなピルを 4個スポーン"},
    {"196", "Squeezy", "↑ 連射速度 +0.4#取得時、青ハートを 2個スポーン"},
    {"197", "Jesus Juice", "↑ 攻撃力　 +0.5#↑ 射程　　 +0.25#↑ 涙の高さ +0.5"},
    {"198", "Box", "取得時、ピックアップを 各種1個ずつスポーン"},
    {"199", "Mom's Key", "鍵 +2#宝箱から得られる ピックアップ量2倍"},
    {"200", "Mom's Eyeshadow", "一定確率で涙に チャーム効果を付与#確率：運0=10%、27=100%"},
    {"201", "Iron Bar", "↑ 攻撃力 +0.3#一定確率で涙に 混乱効果を付与する#確率：運0=10%、27=100%"},
    {"202", "Midas' Touch", "接触した敵に所持金と 等しいダメージを与え、 黄金化し、動きを止める#黄金化状態の敵を倒すと 1～4枚のコインを落とす#うんちをスポーンする時、 黄金うんちになる可能性が アップする"},
    {"203", "Humbleing Bundle", "コイン・鍵・爆弾・ハートを ダブルバージョンに変換する"},
    {"204", "Fanny Pack", "ダメージを受けた時、 50%の確率でコイン・ 鍵・爆弾・ハートの いずれかをスポーン"},
    {"205", "Sharp Plug", "アクティブアイテムの チャージ量が空の時に 使用ボタンを押すと、 ハート2個のダメージが 発生し、アイテムが フルチャージされる"},
    {"206", "Guillotine", "↑ 攻撃力　 +1#↑ 連射間隔 -1#アイザックの頭部が切り 離され、胴体を周回する#頭部はダメージを受けず、 弾をブロックできる#頭部は接触した敵に毎秒 105ダメージを与える"},
    {"207", "Ball of Bandages", "包帯玉がアイザックを 周回し、接触した敵に ダメージを与え、弾を ブロックする#複数個取得で進化#2：チャーム効果付き涙で 　 攻撃する#3：バンデージガールに　　 　 なり、敵を追いかけ　　 　 攻撃する#4：バンデージガール LV2#5個目からはループ"},
    {"208", "Champion Belt", "↑ 攻撃力 +1#!!! チャンピオンタイプの 敵の出現率が15%増加"},
    {"209", "Butt Bombs", "↑ 爆弾 +5#爆弾がうんち爆弾に置き 換わり、爆発時、全ての 敵に混乱と10ダメージを 与える"},
    {"210", "Gnawed Leaf", "1秒間静止すると無敵の 石像に変化できる"},
    {"211", "Spiderbaby", "ダメージを受けるたび 1～2匹の青クモがスポーン"},
    {"212", "Guppy's Collar", "死ぬと、50%の確率で、 半ハートの状態で1つ 前の部屋に復活する"},
    {"213", "Lost Contact", "涙がシールドに包まれ、 敵の弾をブロックする#↓ 弾速 -0.15"},
    {"214", "Anemic", "↑ 射程 +5#ダメージを受けると、 その部屋に居る間、 敵にダメージを与える 血液が床に流れ続ける"},
    {"215", "Goat Head", "悪魔部屋／天使部屋の 出現率が100%アップ#悪魔部屋／天使部屋の ドアが部屋を離れても 開いたままになる"},
    {"216", "Ceremonial Robes", "↑ 攻撃力　 +1#黒ハート +3"},
    {"217", "Mom's Wig", "攻撃中、一定確率で 青クモがスポーン#体力を1回復"},
    {"218", "Placenta", "↑ 最大体力 +1#1分間に1回、半赤ハート 回復するチャンスを得る"},
    {"219", "Old Bandage", "↑ 最大体力 +1#ダメージを受けた時、 一定確率で赤ハートが スポーンする#確率：運0=??%、29=50%"},
    {"220", "Sad Bombs", "爆発した爆弾が、円形に 10発の涙を拡散する#爆弾 +5"},
    {"221", "Rubber Cement", "涙が衝突時に跳ね返る ようになる"},
    {"222", "Anti-Gravity", "攻撃ボタンが押されて いる間、発射した涙が その場で静止を続ける#時間の経過または攻撃の 停止で、元の方向に涙が 発射される#↑ 連射間隔 -2"},
    {"223", "Pyromaniac", "爆風を浴びると 体力が1回復する#爆弾 +5"},
    {"224", "Cricket's Body", "↑ 連射間隔 -1#↓ 射程　　 -10#↓ 涙サイズ +20%#衝突した涙が四つに分裂する#分裂した涙はダメージ量が 半減する"},
    {"225", "Gimpy", "ダメージを受けた時、 一定確率で青ハートが スポーンする#確率：運0=??%、22=50%#死んだ敵が一定確率で 半赤ハートを落とす"},
    {"226", "Black Lotus", "↑ 最大体力 +1#青ハート +1#黒ハート +1"},
    {"227", "Piggy Bank", "コイン +3#ダメージを受けるたび コインを1～2枚スポーン#キーパープレイ時は 0～1枚のスポーン"},
    {"228", "Mom's Perfume", "一定確率で涙に 恐怖効果を付与#確率：運0=12%、85=100%#↑ 連射間隔 -1"},
    {"229", "Monstro's Lung", "涙をチャージ式に置き換え、 一度に14発の涙を同時発射 できるようになる#↓ 連射間隔 ｘ4.3"},
    {"230", "Abaddon", "↑ 攻撃力　 +1.5#↑ 移動速度 +0.2#最大体力を0にし、6個の 黒ハートを付与する#一定確率で涙に 恐怖効果を付与"},
    {"231", "Ball of Tar", "一定確率で涙に スロー効果を付与#確率：運0=10%、18=100%#歩いた床にタールの跡が 残り、触れた敵をスロー 状態にする"},
    {"232", "Stop Watch", "ダメージを受けた時、 部屋の全ての敵を スロー状態にする#↑ 移動速度 +0.3"},
    {"233", "Tiny Planet", "涙がアイザックを周回して 飛ぶようになる#↑ 射程#↑ 涙の高さ +7#涙に透過効果を付与"},
    {"234", "Infestation 2", "倒された敵が青クモを スポーンする"},
    {"235", "", "<item does not exist>"},
    {"236", "E. Coli", "アイザックと接触した 敵がうんちに変わる"},
    {"237", "Death's Touch", "涙が鎌に置き換わる#↑ 攻撃力　 +1.5#↓ 連射速度 -0.3#涙に貫通効果を付与"},
    {"238", "Key Piece 1", "!!! メガサタンのドアを開く 鍵のかけら#↑ 天使部屋の出現率 +25%#{{EternalHeart}} 白ハートの出現率 +2%"},
    {"239", "Key Piece 2", "!!! メガサタンのドアを開く 鍵のかけら#↑ 天使部屋の出現率 +25%#{{EternalHeart}} 白ハートの出現率 +2%"},
    {"240", "Experimental Treatment", "↑ ステータスをランダムに 4つアップ#↓ ステータスをランダムに 2つダウン"},
    {"241", "Contract from Below", "部屋のクリア報酬が2倍に なるが、1/3の確率でゼロ 報酬になる#グリードモードでは 効果なし"},
    {"242", "Infamy", "50%の確率で敵の弾を ブロックする"},
    {"243", "Trinity Shield", "アイザックの正面に 敵の弾をブロックする 盾が現れる"},
    {"244", "Tech.5", "涙攻撃中、ランダムな 確率で追加のレーザー 攻撃が発生する"},
    {"245", "20/20", "ダブルショットの涙"},
    {"246", "Blue Map", "隠し部屋の位置が マッピングされる"},
    {"247", "BFFS!", "使い魔の与えるダメージが 2倍になり、サイズも拡大#ピックアップを生成する タイプの使い魔は、その 頻度が増加する"},
    {"248", "Hive Mind", "青ハエ／クモの与える ダメージが2倍になる"},
    {"249", "There's Options", "ボスアイテムを2つの 候補から選択できる"},
    {"250", "Bogo Bombs", "全ての爆弾がダブル バージョンに置き換わる"},
    {"251", "Starter Deck", "カードを2枚まで 保持可能になる#全てのピルをカードに 置き変える#取得時、ランダムな カードを1枚スポーン"},
    {"252", "Little Baggy", "ピルを2個まで 保持可能になる#全てのカードをピルに 置き変える#取得時、ランダムな ピルを1個スポーン"},
    {"253", "Magic Scab", "↑ 運　　　 +1#↑ 最大体力 +1"},
    {"254", "Blood Clot", "左目のみに適用：#↑ 攻撃力 +1#↑ 射程　 +5"},
    {"255", "Screw", "↑ 連射速度 +0.5#↑ 弾速　　 +0.2"},
    {"256", "Hot Bombs", "爆弾が炎をまとい、敵に 接触ダメージを与える#爆発地点に炎が残り、 敵にダメージを与える#爆弾 +5"},
    {"257", "Fire Mind", "涙に火傷効果を付与する#一定確率で敵と衝突した 涙が爆発し、炎を残す#確率：運0=??%、13=100%#!!! 自爆の危険あり"},
    {"258", "Missing No.", "取得時と毎フロア開始時、 全てのステータスと アイテムをリロールする"},
    {"259", "Dark Matter", "↑ 攻撃力 +1#一定確率で涙に 恐怖効果を付与#確率：運0=33%、20=100%"},
    {"260", "Black Candle", "フロアの呪いを無効化#黒ハート +1#悪魔部屋／天使部屋の 出現率 +15%"},
    {"261", "Proptosis", "↑ 攻撃力 +100%#↓ 涙のサイズとダメージが 飛距離と共に減少する"},
    {"262", "Missing Page 2", "黒ハート +1#ダメージを受け、残りの 体力がハート1個以下に なった時、ネクロノミコン 効果が発動する (全ての敵に40ダメージ)"},
    {"263", "", "<item does not exist>"},
    {"264", "Smart Fly", "黄色いハエがアイザックを 周回し、敵に接触ダメージ を与え、弾をブロックする#ダメージを受けると アイザックから離れ、 敵を追いかけ攻撃する"},
    {"265", "Dry Baby", "アイザックを追従し、 敵の弾をブロックする 使い魔#弾ブロック時、10%の 確率でネクロノミコン 効果を発動する"},
    {"266", "Juicy Sack", "触れた敵をスロー状態に する液体を流しながら アイザックを追従する 使い魔#部屋をクリアするたび 1～2匹の青クモをスポーン"},
    {"267", "Robo-Baby 2.0", "攻撃方向に連動して移動し、 正面の敵を自動でレーザー 攻撃する使い魔#レーザーは3.5ダメージを 与える"},
    {"268", "Rotten Baby", "青ハエをスポーンして 攻撃する使い魔"},
    {"269", "Headless Baby", "床に血を流しながら アイザックを追従する 使い魔#血は触れた敵に毎秒 6ダメージを与える"},
    {"270", "Leech", "敵を追いかけ攻撃し、 毎秒3.2ダメージを 与える使い魔#この使い魔が敵を倒した時、 半赤ハート回復する"},
    {"271", "Mystery Sack", "5～6部屋クリアするたび ランダムなピックアップを 1個スポーンする使い魔"},
    {"272", "BBF", "部屋を飛び回り、敵との 接触時に爆発する使い魔#接触で10、爆発で60の ダメージを与える"},
    {"273", "Bob's Brain", "涙の発射方向に連動して 飛び出し、敵との衝突で 爆発する使い魔#爆発は60のダメージと 毒を与える"},
    {"274", "Best Bud", "ダメージを受けると白い ハエが現れ、その部屋に 居る間、アイザックを 周回する#毎秒75の接触ダメージ"},
    {"275", "Lil Brimstone", "ブリムストーンで攻撃する 使い魔　　#ビームは完全にヒットした 場合、合計31のダメージを 与える"},
    {"276", "Isaac's Heart", "アイザックに追従する 心臓が現れ、ダメージ 判定が心臓側に移行する"},
    {"277", "Lil Haunt", "敵を追いかけて攻撃し、 毎秒4ダメージを与え、 恐怖状態にする使い魔"},
    {"278", "Dark Bum", "赤ハートを拾い集める 乞食の使い魔#1.5個拾うたび、黒ハート・ 青ハート・青クモ・敵クモ のいずれかを スポーン"},
    {"279", "Big Fan", "巨大なハエがアイザックを 周回し、敵に接触ダメージ を与え、弾をブロックする#毎秒10の接触ダメージ"},
    {"280", "Sissy Longlegs", "バトル中、最大5匹まで 青クモをスポーンする 使い魔"},
    {"281", "Punching Bag", "アイザックの代わりに 敵の標的になる使い魔"},
    {"282", "How to Jump", "移動しながら使用すると その方向にジャンプする"},
    {"283", "D100", "部屋の全てのアイテム、 ピックアップ、宝箱、 取得済みのパッシブ アイテムをリロールする"},
    {"284", "D4", "全ての取得済みパッシブ アイテムをリロールする"},
    {"285", "D10", "部屋の全ての敵をリロール"},
    {"286", "Blank Card", "保持中のカード・ルーンの 効果をコピーして発動する"},
    {"287", "Book of Secrets", "{{Collectible54}} 宝の地図#{{Collectible21}} コンパス#{{Collectible246}} ブルーマップ いずれかの効果を 現フロアに付与する"},
    {"288", "Box of Spiders", "1～4匹の青クモをスポーン"},
    {"289", "Red Candle", "ロウソクから赤い炎を放つ#炎が敵にダメージを与え、 弾をブロックする#接触とブロックで炎は 縮み、4回ヒットで消滅"},
    {"290", "The Jar", "体力が満タンの状態で 赤ハートを拾うと、最大 4個までストックできる#使用すると、中身を全て その場に落とす"},
    {"291", "Flush!", "全ての雑魚敵がうんちに変化#うんちタイプのボスが即死"},
    {"292", "Satanic Bible", "黒ハートを1個付与"},
    {"293", "Head of Krampus", "ブリムストーンビームを 十字方向に放つ"},
    {"294", "Butter Bean", "おならで近くの敵と弾を ノックバックさせる#他のアクティブアイテム との交換・再取得を繰り 返した時、10%の確率で {{Collectible484}}WaitWhat?に変化する"},
    {"295", "Magic Fingers", "1コイン消費し、部屋の 全ての敵に攻撃力ｘ2の ダメージを与える"},
    --NOTE FOR LOCALIZERS: There is code to highlight the text of your current floor
    --For it to work, only use line breaks or semicolons to separate floor details, and use the same order as English
    {"296", "Converter", "青／黒ハートを2個消費し、 最大体力を1個増やす"},
    {"297", "Pandora's Box", "{{Warning}} 使い切りアイテム#使用フロアで効果が変化：#B1:青ハート 2個#B2:爆弾と鍵 各2個#C1:ボスアイテム 1個#C2:B1+C1#D1:青ハート 4個#D2:コイン 20枚#W1:ボスアイテム 2個#W2:{{Collectible33}} 聖書#???/Void:なし#Sheol:悪魔部屋アイテム1個 　　　黒ハート 1個#Cat:天使部屋アイテム 1個 　　白ハート 1個#DarkRoom:{{Collectible523}}お引越し用の箱 　　　　　 をアンロック#Chest:コイン 1枚"},
    {"298", "Unicorn Stump", "6秒間、無敵状態になり 移動速度が0.28アップ するが、涙攻撃能力を 一時的に失う"},
    {"299", "Taurus", "バトル中、移動速度が 徐々に増加する#速度が上限に達した時、 5秒間の無敵状態と 接触ダメージ効果を得る#↓ 移動速度 -0.3"},
    {"300", "Aries", "↑ 移動速度 +0.25#素早く敵に衝突すると 18のダメージを与える"},
    {"301", "Cancer", "青ハート +3#同じ部屋で受ける2回目 以降のダメージが、 半ハートに軽減される"},
    {"302", "Leo", "障害物破壊能力を付与#アイザックのサイズ拡大"},
    {"303", "Virgo", "ダメージを受けた時、一定 確率でシールドを展開する#シールドは10秒間持続し、 全てのダメージを無効化#悪性のピルを良性に変換"},
    {"304", "Libra", "コイン・鍵・爆弾 +6#取得時およびステータス 変動時に、各ステータス が平均化される"},
    {"305", "Scorpio", "涙に毒効果を付与"},
    {"306", "Sagittarius", "↑ 移動速度 +0.2#涙に貫通効果を付与"},
    {"307", "Capricorn", "↑ 最大体力 +1#↑ 攻撃力　 +0.5#↑ 移動速度 +0.1#↑ 射程　　 +1.5#↑ 連射間隔 -1#コイン・鍵・爆弾 +1"},
    {"308", "Aquarius", "アイザックの体から青い 液体が流れ続け、触れた 敵に毎秒6のダメージを 与える"},
    {"309", "Pisces", "↑ 連射間隔 -1#↑ 涙サイズ +25%#ノックバック強化"},
    {"310", "Eve's Mascara", "↑ 攻撃力　 +100%#↓ 連射速度 -50%#↓ 弾速　　 -0.5"},
    {"311", "Judas' Shadow", "{{Player12}} 死ぬと、一つ前の部屋に ダークユダとして復活#復活後、実績上はユダ として扱われる"},
    {"312", "Maggy's Bow", "↑ 最大体力 +1#体力を1回復#赤ハート取得時の回復量が 2倍になる"},
    {"313", "Holy Mantle", "部屋ごとに1回、最初に 受けたダメージを無効化 するシールドを付与する"},
    {"314", "Thunder Thighs", "↑ 最大体力 +1#↓ 移動速度 -0.4#障害物破壊能力を付与"},
    {"315", "Strange Attractor", "涙が磁気を帯び、敵や ピックアップを引き寄せる"},
    {"316", "Cursed Eye", "涙がチャージ式になり、  チャージ量に応じた数の 涙が連続発射される#!!! チャージ中にダメージを 受けると、ランダムな 部屋にテレポートする#{{Collectible260}} ブラックキャンドルを 所持している場合、 テレポートしない"},
    {"317", "Mysterious Liquid", "涙の衝突地点に緑色の 液体が残り、触れた敵に 毎秒30ダメージを与える"},
    {"318", "Gemini", "アイザックと肉の鎖で つながれた使い魔が 敵を追いかけ攻撃し、 毎秒8ダメージを与える"},
    {"319", "Cain's Other Eye", "目玉が部屋を飛び回り、 アイザックと同じ涙を 発射する"},
    {"320", "???'s Only Friend", "攻撃方向に連動して移動し、 毎秒37.5の接触ダメージを 与える使い魔"},
    {"321", "Samson's Chains", "アイザックに鉄球付きの 鎖がつながり、鉄球が 敵に接触ダメージを与え、 弾をブロックする#毎秒10の接触ダメージ#鉄球は障害物を破壊する"},
    {"322", "Mongo Baby", "他の使い魔の涙をコピー して攻撃する使い魔#コピー対象が居ない場合、 3.5 ダメージのノーマルな 涙で攻撃する"},
    {"323", "Isaac's Tears", "8方向に涙を同時発射する#涙を発射するとチャージが 回復する"},
    {"324", "Undefined", "トレジャールーム・隠し 部屋・I AM ERROR部屋の いずれかにテレポート"},
    {"325", "Scissors", "体から分離した頭がその 場に固定され、涙を放つ#操作する体側からも涙を 発射可能"},
    {"326", "Breath of Life", "使用ボタンを押し続けると チャージ量が徐々に減り、 空になった瞬間無敵状態に なる#チャージ量が空になった後 更にボタンを1秒以上押し 続けるとダメージを受ける"},
    {"327", "The Polaroid", "ダメージを受け、残りの 体力が半赤ハート以下に なった時、シールドを展開#シールドは5秒間持続し、 全てのダメージを無効化"},
    {"328", "The Negative", "ダメージを受け、残りの 体力が半赤ハート以下に なった時、ネクロノミコン 効果を発動する （全ての敵に40ダメージ）"},
    {"329", "The Ludovico Technique", "涙を発射する代わりに 浮遊する一つの涙を操作する"},
    {"330", "Soy Milk", "↑ 連射速度大幅アップ (連射間隔 /4) -2#↓ 攻撃力 -80%"},
    {"331", "Godhead", "↑ 攻撃力　 +0.5#↑ 射程　　 +1.2#↓ 連射速度 -0.3#↓ 弾速　　 -0.3#↑ 涙の高さ +0.8#涙がオーラを放ち、触れた 敵にダメージを与える#涙にホーミング効果を付与"},
    {"332", "Lazarus' Rags", "死ぬと、その部屋で ラザラスとして復活する"},
    {"333", "The Mind", "フルマッピング効果"},
    {"334", "The Body", "↑ 最大体力 +3"},
    {"335", "The Soul", "青ハート +2#敵や弾を跳ね返す オーラが付与される"},
    {"336", "Dead Onion", "涙に貫通と透過効果を付与#↑ 射程　　 +0.25#↓ 弾速　　 -0.4#↓ 涙の高さ -0.5#↑ 涙サイズ +50%"},
    {"337", "Broken Watch", "4部屋ごとに全ての敵を スロー状態にするが、 まれにスピードアップ 効果が発生する"},
    {"338", "The Boomerang", "ブーメランを投げる#攻撃力ｘ2のダメージを 与え、2秒間石化させる#ピックアップを回収可能"},
    {"339", "Safety Pin", "↑ 射程　　 +5.25#↑ 弾速　　 +0.16#↑ 涙の高さ +0.5#黒ハート +1"},
    {"340", "Caffeine Pill", "↑ 移動速度 +0.3#↑ アイザックのサイズ縮小#取得時、ランダムな ピルを1個スポーン"},
    {"341", "Torn Photo", "↑ 連射速度 +0.7#↑ 弾速　　 +0.16"},
    {"342", "Blue Cap", "↑ 最大体力 +1#↑ 連射速度 +0.7#↓ 弾速　　 -16%"},
    {"343", "Latch Key", "↑ 運 +1#青ハート +1#取得時、鍵を2個スポーン"},
    {"344", "Match Book", "黒ハート +1#取得時、爆弾を3個スポーン"},
    {"345", "Synthoil", "↑ 攻撃力　 +1#↑ 射程　　 +5.25#↑ 涙の高さ +0.5"},
    {"346", "A Snack", "↑ 最大体力 +1"},
    {"347", "Diplopia", "!!! 使い切りアイテム !!!#部屋の全てのアイテムと ピックアップを複製する"},
    {"348", "Placebo", "保持中のピルの効果を コピーして発動する"},
    {"349", "Wooden Nickel", "50%の確率でランダムな コインを1枚スポーン"},
    {"350", "Toxic Shock", "バトル開始時、部屋の 全ての敵を毒状態にする#死んだ敵が緑色の液体を 残し、触れた敵に毎秒30 ダメージを与える"},
    {"351", "Mega Bean", "部屋の全ての敵を数秒間 石化させる#近くの敵に5ダメージと 毒を与える#地割れを起こし、触れた 敵に10ダメージを与え、 障害物を破壊する"},
    {"352", "Glass Cannon", "残り体力を半ハートまで 減らし、敵と障害物を 貫通する大粒の涙を放つ#攻撃力ｘ10+10のダメージ"},
    {"353", "Bomber Boy", "爆弾 +5#爆弾の爆発範囲が 十字型に広がる"},
    {"354", "Crack Jacks", "↑ 最大体力 +1#取得時、ランダムな トリンケットを1個 スポーンする"},
    {"355", "Mom's Pearls", "↑ 射程　　 +1.25#↑ 運　　　 +1#↑ 涙の高さ +0.5"},
    {"356", "Car Battery", "アクティブアイテムの 効果が2倍になる"},
    {"357", "Box of Friends", "使い魔のコピーを追加#使い魔が居ない場合、 {{Collectible113}}デーモンベイビーが 追加される#使用した部屋でのみ有効"},
    {"358", "The Wiz", "両目から同時に、斜め 外側に向かって涙が 発射されるようになる#涙に透過効果を付与"},
    {"359", "8 Inch Nails", "↑ 攻撃力 +1.5#ノックバック強化"},
    {"360", "Incubus", "アイザックの涙をコピー して攻撃する使い魔"},
    {"361", "Fate's Reward", "アイザックの涙をコピー して攻撃する使い魔#連射速度は通常の 使い魔の半分"},
    {"362", "Lil Chest", "部屋をクリアした時、 25%の確率でピックアップ、 10%の確率でトリンケットを スポーンする使い魔"},
    {"363", "Sworn Protector", "天使がアイザックを周回し、 敵に接触ダメージを与え、 弾をブロックする#毎秒105の接触ダメージ#一部屋で弾を10発ブロック すると、白ハートを落とす"},
    {"364", "Friend Zone", "白いハエがアイザックを 周回し、接触した敵に 毎秒45ダメージを与える"},
    {"365", "Lost Fly", "壁や障害物に沿って 移動する使い魔#毎秒105の接触ダメージ"},
    {"366", "Scatter Bombs", "爆弾 +5#爆弾から2～4個の小さな 爆弾が分裂する"},
    {"367", "Sticky Bombs", "爆弾 +5#爆弾で敵を倒すと 青クモがスポーン#爆弾が敵にくっ付く"},
    {"368", "Epiphora", "同一方向に攻撃し続けると 連射速度が上昇していき、 最大200%アップする#攻撃の停止・方向変更で 連射速度がリセットされる"},
    {"369", "Continuum", "↑ 射程　　 +2.25#↑ 涙の高さ +1.5#涙に透過効果を付与#涙が画面の端と端で ループするようになる"},
    {"370", "Mr. Dolly", "↑ 連射速度 +0.7#↑ 射程　　 +5.25#↑ 涙の高さ +0.5#取得時、ランダムな ハートを3個スポーン"},
    {"371", "Curse of the Tower", "ダメージを受けるたび 6個のトロル爆弾がスポーン#この効果で生成された トロル爆弾は爆弾強化 アイテムの特殊効果を 引き継ぐ"},
    {"372", "Charged Baby", "バトル中、30秒おきに、#{{Blank}} \7 電池のスポーン#{{Blank}} \7 チャージの追加#{{Blank}} \7 敵を1.5秒間石化#{{Blank}} のいずれかを行う使い魔#電池とチャージ効果は 一部屋2回まで有効"},
    {"373", "Dead Eye", "↑ 涙が敵に当たるたび 攻撃力 +25%（最大100%）#涙が外れると一定確率で 攻撃力がリセットされる"},
    {"374", "Holy Light", "一定確率で聖なる涙が 発射され、衝突すると 近くの敵に光線が降り注ぐ#光線は攻撃力ｘ4の ダメージを与える#確率：運0=9%、9=50%"},
    {"375", "Host Hat", "爆発耐性を付与#敵の弾を25%の確率で ブロックし、跳ね返す"},
    {"376", "Restock", "お店で商品を購入すると 新しい商品が補充される#取得時、ランダムな ピックアップを3個 スポーンする"},
    {"377", "Bursting Sack", "クモタイプの敵が中立に なり、接触でダメージを 受けなくなる"},
    {"378", "No. 2", "攻撃ボタンを3秒間押し 続けると、うんち爆弾が スポーンする"},
    {"379", "Pupula Duplex", "↑ 涙サイズ +100%#涙に透過効果を付与"},
    {"380", "Pay To Play", "コイン +5#鍵で開くタイプのドアが コインで開くドアに置き 換わる"},
    {"381", "Eden's Blessing", "↑ 連射速度 +0.7#次のゲームの開始時に ランダムなアイテムが 付与される"},
    {"382", "Friendly Ball", "モンスターを捕獲できる ボール#再使用すると捕獲された 敵がチャーム状態で現れる"},
    {"383", "Tear Detonator", "使用すると、発射済みの 全ての涙が6つに分裂する"},
    {"384", "Lil Gurdy", "攻撃に連動してチャージを 溜め、解放されると高速で 体当たりを始める使い魔#スピードに応じて、毎秒 5～90の接触ダメージを与える"},
    {"385", "Bumbo", "コインを拾い集める使い魔#6枚／12枚／24枚以上 集めるたびに進化する：#{{Blank}} LV2：部屋クリア時、時々 　　 アイテムを落とす LV3：コインを落とす涙で 　　 攻撃する LV4：敵を追いかけて攻撃 　　 時々爆弾を投げる 　　 コインをランダムな 　　 アイテムに変換する"},
    {"386", "D12", "障害物をリロールする"},
    {"387", "Censer", "敵と弾をスロー状態にする オーラを放つ使い魔"},
    {"388", "Key Bum", "鍵を拾ってランダムな 宝箱に変換する使い魔"},
    {"389", "Rune Bag", "5～6部屋クリアするたび ランダムなルーンを1個 スポーンする使い魔"},
    {"390", "Seraphim", "10ダメージのホーミング効果 付き涙で攻撃する使い魔"},
    {"391", "Betrayal", "ダメージを受けるたび 部屋の全ての敵を チャーム状態にする"},
    {"392", "Zodiac", "毎フロア、ランダムな 星座アイテムの効果を 一つ付与する"},
    {"393", "Serpent's Kiss", "一定確率で涙に毒効果が 付与される#接触した敵に毒を与える#毒を受けた敵が死んだ時、 20%の確率で黒ハートを 落とす"},
    {"394", "Marked", "照準方向へ涙が自動で 流れ続けるようになる#照準は攻撃ボタンで操作#↑ 連射速度 +0.7#↑ 射程　　 +3.15#↑ 涙の高さ +0.3"},
    {"395", "Tech X", "涙がチャージ式のレーザー リングに置き換わる#チャージ量に応じて リングのサイズが拡大"},
    {"396", "Ventricle Razor", "青色／オレンジ色の ポータルを足元に生成し、 双方をテレポートできる"},
    {"397", "Tractor Beam", "アイザックの頭から放射 されるビームに沿って 涙が直進するようになる#↑ 連射速度 +0.5#↑ 射程　　 +5.25#↑ 弾速　　 +0.16#↑ 涙の高さ +0.5"},
    {"398", "God's Flesh", "一定確率で涙に収縮化 効果が付与される#収縮した敵は踏み潰して 倒せる"},
    {"399", "Maw of the Void", "↑ 攻撃力 +1#攻撃ボタンを押し続けて 2.35秒経過すると、頭に 十字架が浮かぶ 攻撃ボタンを解放すると ブリムストーンリングを 放出し、敵にダメージを 与える#この効果で敵を倒すと、 5%の確率で黒ハートを スポーンする"},
    {"400", "Spear of Destiny", "アイザックの正面に 槍が現れる#槍は敵に攻撃力ｘ2の ダメージを与え、時々 恐怖状態にする"},
    {"401", "Explosivo", "一定確率で涙が敵に くっ付き、数秒後に 爆発する#くっ付いた涙は敵に ダメージを与えない"},
    {"402", "Chaos", "アイテムがランダムな アイテムプールから スポーンするようになる#取得時、ランダムな ピックアップを1～6個 スポーンする"},
    {"403", "Spider Mod", "ダメージ量の数値と敵の 体力バーを表示する#機械のクモが部屋を歩き 回り、接触した敵に状態 異常を与える#部屋クリア時、青クモや 電池を時々スポーンする"},
    {"404", "Farting Baby", "敵の弾をブロックする 使い魔　　#ブロックすると10%の 確率でおならを出し、 毒・ノックバック・ チャームのいずれかの 効果を敵に与える"},
    {"405", "GB Bug", "部屋を飛び回る使い魔#接触した敵に毎秒120の ダメージとランダムな 状態異常を与える#バトル中、ルート上の ピックアップ等を稀に リロールする"},
    {"406", "D8", "攻撃力・連射速度・射程・ 移動速度のステータスを リロールする"},
    {"407", "Purity", "ステータスを強化する オーラを付与#オーラの色と強化対象： {{ColorRed}}赤{{CR}}：攻撃力　 +4 {{ColorBlue}}青{{CR}}：連射速度 +2 {{ColorYellow}}黄{{CR}}：移動速度 +0.5 {{ColorOrange}}橙{{CR}}：射程　　 +7.5#ダメージを受けると オーラは消えるが、 部屋を移動すると ランダムな色で復活する"},
    {"408", "Athame", "ダメージを受けると ブリムストーンリングを 放出し、敵にダメージを 与える#この効果で敵を倒すと、 15%の確率で黒ハートを スポーンする"},
    {"409", "Empty Vessel", "黒ハート +2#赤ハートが無い時：#飛行能力を付与#バトル中、40秒おきに シールドを展開し、 ダメージを無効化する"},
    {"410", "Evil Eye", "攻撃中、低確率で目玉が 発射される#目玉はゆっくりと飛び、 アイザックと同じ涙を 発射する"},
    {"411", "Lusty Blood", "↑ 敵を倒すたび　　　　　　 攻撃力 +0.5（最大 +5）#その部屋でのみ有効"},
    {"412", "Cambion Conception", "一定回数のダメージを 受けると、悪魔タイプの 使い魔が永続付与される#最大4体まで付与され、 1／2体目は15回、 3／4体目は30回の ダメージを要する"},
    {"413", "Immaculate Conception", "ハートを15個拾うと、天使 タイプの使い魔が永続付与 され、同時に、青ハートが 1個スポーンする#使い魔は最大5体まで付与#使い魔が上限に達しても、 青ハートはスポーンする"},
    {"414", "More Options", "トレジャールームの アイテムを2つの候補 から選択できる"},
    {"415", "Crown Of Light", "青ハート +2#空の赤ハートが無い時：#↑ 攻撃力 +100%#↑ 射程　 +5.25#↓ 弾速　 -0.3 王冠が青く輝き、涙が ダイヤに置き換わる#ダメージを受けると、 その部屋では効果が 無効になる"},
    {"416", "Deep Pockets", "カード・ルーン・ピルを 2つまで保持可能になる"},
    {"417", "Succubus", "オーラを放ちながら 部屋を飛び回る使い魔#オーラ内では攻撃力が 50%アップする#オーラは範囲内の敵に 攻撃力ｘ1.29ダメージ を毎秒与える"},
    {"418", "Fruit Cake", "涙にランダムな 特殊効果を付与"},
    {"419", "Teleport 2.0", "未探索のランダムな 部屋にテレポートする#優先順位: {{Room}}>{{BossRoom}}>{{SuperSecretRoom}}>{{Shop}}>{{TreasureRoom}}>{{SacrificeRoom}}> {{DiceRoom}}>{{Library}}>{{CursedRoom}}>{{MiniBoss}}>{{ChallengeRoom}}{{BossRushRoom}}>{{IsaacsRoom}}{{BarrenRoom}}> {{ArcadeRoom}}>{{ChestRoom}}>{{SecretRoom}}>{{DevilRoom}}{{AngelRoom}}>{{ErrorRoom}}"},
    {"420", "Black Powder", "円を描くように歩くと 床に五芒星のシンボルが 浮かび上がり、範囲内の 敵に毎秒25のダメージを 与える"},
    {"421", "Kidney Bean", "おならで近くの敵に 5ダメージを与え、 チャーム状態にする"},
    {"422", "Glowing Hour Glass", "時間を巻き戻し、一つ 前の部屋に、一つ前の 部屋の状態で戻る"},
    {"423", "Circle of Protection", "光輪がアイザックを囲み、 範囲内の敵に攻撃力と 等しいダメージを毎秒 与える#光輪は敵の弾を30%の 確率で跳ね返す#跳ね返された涙は アイザックの攻撃力と ホーミング効果を持つ"},
    {"424", "Sack Head", "ピックアップが一定確率で サックに置き換わる#コイン：10%#その他：20%#取得時にサックを1袋 スポーンする"},
    {"425", "Night Light", "アイザックの正面が ライトで照らされ、 範囲内の敵と弾を スロー状態にする#フロアに闇の呪いが かかっている場合、 それを取り除く"},
    {"426", "Obsessed Fan", "3秒遅れでアイザックを 追従する使い魔#接触した敵に毎秒30の ダメージを与える"},
    {"427", "Mine Crafter", "移動可能なTNTを設置する"},
    {"428", "PJs", "青ハート +4#体力全回復"},
    {"429", "Head of the Keeper", "涙が敵に当たると、5%の 確率でコインがスポーン"},
    {"430", "Papa Fly", "1秒遅れでアイザックを 追従する使い魔#アイザックと同じ攻撃力の 涙を発射する"},
    {"431", "Multidimensional Baby", "2秒遅れでアイザックを 追従する使い魔#アイザックと使い魔の 涙がこれを通過すると、 弾速・高さがアップし、 ダブルショット化する"},
    {"432", "Glitter Bombs", "爆弾 +5#爆発した爆弾が、25%の 確率でピックアップや トリンケットをスポーン#爆発した爆弾が、15%の 確率で敵にチャームを 付与する"},
    {"433", "My Shadow", "ダメージを受けるたび 全ての敵を恐怖状態にし、 友好的なチャージャーを スポーンする#チャージャーは毎秒10の 接触ダメージを与える"},
    {"434", "Jar of Flies", "敵を倒すと、青ハエが ビンに追加される#最大20匹まで追加できる#アイテムを使用すると 青ハエを放出する"},
    {"435", "Lil Loki", "3.5 ダメージの涙を十字 方向に発射する使い魔"},
    {"436", "Milk!", "ダメージを受けると 連射速度がアップする#その部屋でのみ有効"},
    {"437", "D7", "その部屋で倒した敵を リスポーンする#クリア報酬のスポーン、 アクティブアイテムの チャージも再度有効化 される#!!! グリードが現れたお店・ 隠し部屋で使用すると、 通常のお店・隠し部屋 として復活する"},
    {"438", "Binky", "青ハート +1#↑ 連射速度 +0.75#↑ アイザックのサイズ縮小"},
    {"439", "Mom's Box", "保持中、トリンケットの 効果が2倍＆運 +1#使用すると、ランダムな トリンケットをスポーン"},
    {"440", "Kidney Stone", "涙が時々詰まり、その 状態でチャージすると 顔がうっ血していく#フルチャージ状態で解放 すると結石が射出され、 連射速度が一時的に大幅 アップする#↓ 移動速度 -0.2#↓ 射程　　 -17#↑ 涙の高さ +2"},
    {"441", "Mega Blast", "メガサタンビームを 15秒間発射する#ビームは部屋やフロアを またいで持続する"},
    {"442", "Dark Prince's Crown", "残りの赤ハートが ちょうど1個の時：#↑ 連射速度 +0.75#↑ 射程　　 +1.5#↑ 弾速　　 +0.2#有効時、王冠が赤く輝く"}, -- Dark Princes Crown (apostrophe added to the name in Repentance)
    {"443", "Apple!", "↑ 連射速度 +0.3#一定確率で涙がカミソリに 置き換わり、攻撃力ｘ4の ダメージを与える#確率：運0=6%、14=100%"},
    {"444", "Lead Pencil", "15回に1回、涙の弾幕が 発射されるようになる#弾幕の涙は2倍の ダメージを与える"},
    {"445", "Dog Tooth", "↑ 攻撃力　 +0.3#↑ 移動速度 +0.1#隠し部屋に隣接した 部屋に入ると、犬の 遠吠えが聞こえる#クロールスペースを 含む部屋に入ると、 犬の鳴き声が聞こえる"},
    {"446", "Dead Tooth", "攻撃中、アイザックが 毒のオーラを放ち、 触れた敵に毒を与える"},
    {"447", "Linger Bean", "7.5秒間攻撃を続けると、 おならの雲が発生し、 触れた敵に攻撃力ｘ5の ダメージを毎秒与える#雲は15秒間持続する#雲を涙で撃つと動かせる"},
    {"448", "Shard of Glass", "ダメージを受けた時、 25%の確率で赤ハートを 1個スポーンし、 10%の確率で{{Collectible214}}貧血を 一時付与する"},
    {"449", "Metal Plate", "青ハート +1#敵の弾を25%の確率で 跳ね返す#跳ね返された涙は アイザックの涙を コピーし、混乱と ホーミング効果を持つ"},
    {"450", "Eye of Greed", "20回に1回、涙と一緒に 金の涙が発射され、 コインを1枚消費する#金の涙は敵を黄金化し、 追加のダメージを与える#黄金化状態の敵を倒すと 1～4枚のコインが落ちる#コイン未所持の状態でも 金の涙は発射される"},
    {"451", "Tarot Cloth", "カード・ルーンに 追加の効果を付与する#取得時、ランダムな カード・ルーンを1個 スポーンする"},
    {"452", "Varicose Veins", "ダメージを受けると、 円形に10発の涙が発射 され、{{Collectible214}}貧血の効果が 一時的に付与される#10発の涙は25の追加 ダメージを持つ"},
    {"453", "Compound Fracture", "↑ 射程　　 +1.5#↑ 涙の高さ +1#涙が骨に置き換わり、 衝突すると破片が散る#破片はダメージが半減する"},
    {"454", "Polydactyly", "カード・ルーン・ピルを 2つまで保持可能になる#取得時、ランダムな カード・ルーン・ピルを 1つスポーンする"},
    {"455", "Dad's Lost Coin", "↑ 射程　　 +1.5#↑ 涙の高さ +1#取得時、ラッキーペニーを 1枚スポーン"},
    {"456", "Moldy Bread", "↑ 最大体力 +1"},
    {"457", "Cone Head", "青ハート +1#20%の確率でダメージを 無効化する"},
    {"458", "Belly Button", "トリンケットを2個まで 保持可能になる#取得時、ランダムな トリンケットを1個 スポーンする"},
    {"459", "Sinus Infection", "攻撃中、20%の確率で 鼻くそが発射され、 敵に60秒間くっ付く#鼻くそは攻撃力と等しい ダメージを毎秒与える"},
    {"460", "Glaucoma", "一定確率で涙に 混乱効果を付与#ゲーム画面が暗くなる"},
    {"461", "Parasitoid", "一定確率で涙が卵に置き  換わり、敵に当たると、  1～2匹の青クモ／ハエが  スポーンする#卵の衝突地点に白い液体が 広がり、触れた敵をスロー 状態にする#確率：運0=15%、20=50%"},
    {"462", "Eye of Belial", "↑ 射程　　 +1.5#↑ 涙の高さ +1#涙に貫通効果を付与#敵を貫通した後の涙は ダメージが2倍になり、 サイズが1.3倍広がり、 ホーミング効果が付与 される"},
    {"463", "Sulfuric Acid", "↑ 攻撃力 +0.3#一定確率で酸の涙を 発射し、障害物や壁、 ドアを破壊する"},
    {"464", "Glyph of Balance", "青ハート +2#チャンピオンタイプの 敵を倒した時の報酬が、 現在不足している物を 優先してスポーンする ように変更される"},
    {"465", "Analog Stick", "↑ 連射速度 +0.3#涙を斜めに発射できる"},
    {"466", "Contagion", "部屋で最初に倒された 敵が毒ガスを放出し、 近くの敵に毒を与える#この毒効果で倒された 敵も毒ガスを放出し、 効果が連鎖する"},
    {"467", "Finger!", "アイザックの攻撃方向に 指が現れ、直線上の敵に 攻撃力x0.1のダメージを 毎秒10回与える"},
    {"468", "Shade", "1秒遅れでアイザックを 追従する使い魔#接触した敵に毎秒30の ダメージを与える#合計600ダメージを 与えると消滅し、 アイザックに同等の 接触ダメージ効果を 付与する"},
    {"469", "Depression", "敵にダメージを与える 液体を床に流しながら アイザックを追従する 使い魔#液体は毎秒6ダメージを 与える　#雲に敵が触れた時、低い 確率で{{Collectible374}}聖なる光による 光線攻撃が発生する"},
    {"470", "Hushy", "部屋を飛び回る使い魔#接触した敵に毎秒30の ダメージを与える#攻撃ボタン押下中は 移動を停止する"},
    {"471", "Lil Monstro", "チャージ式の弾幕涙で 攻撃する使い魔#涙は一発3.5ダメージ"},
    {"472", "King Baby", "使い魔の先頭に固定 され、他の使い魔を 従える使い魔#攻撃ボタン押下中、 他の使い魔と共に その場で停止し、 離すと戻ってくる"},
    {"473", "Big Chubby", "涙の発射方向に連動して ゆっくり突進する使い魔#毎秒40.5の接触ダメージ#突進中、敵の弾をブロック"},
    {"474", "Tonsil", "敵の弾をブロックする"},
    {"475", "Plan C", "!!! 使い切りアイテム !!!#全ての敵に9,999,999の ダメージを与え、3秒後に アイザックを殺す"},
    {"476", "D1", "ピックアップをランダムに 1個複製する"},
    {"477", "Void", "!!! 部屋の全てのアイテムを 破壊して吸収する#アクティブアイテムを 吸収すると、ボイド 使用時にその効果を 同時発動する#パッシブアイテムを吸収 すると、ステータスが ランダムに2つアップ"},
    {"478", "Pause", "攻撃ボタンが押される まで、全ての敵を停止する#ボスは30秒経過すると 行動を再開する"},
    {"479", "Smelter", "保持中のトリンケットを 吸収し、効果を永続化する#保持中、トリンケットの 出現率がアップ"},
    {"480", "Compost", "部屋内のピックアップを 青ハエ／クモに変換する#保有する青ハエ／クモの 量を倍にする#保有する青ハエ／クモが 無い場合、どちらかを 1匹スポーン"},
    {"481", "Dataminer", "ランダムなステータスを 一つ増やし、一つ減らす#その部屋に居る間、涙に ランダムな効果を付与#画面と音楽を歪める"},
    {"482", "Clicker", "ランダムなプレイヤー キャラクターに変化し、 最後に取得した アイテムを削除する"},
    {"483", "Mama Mega!", "!!! 使い切りアイテム !!!#部屋の全ての障害物を 破壊し、全ての敵に 200ダメージを与える#効果はフロア全体で発動#ボスラッシュ・ハッシュ・ 隠し部屋の入り口も破壊#!!! 金爆弾を所持している時、 ママメガ！の代わりに それを消費して効果を 発動できる"},
    {"484", "Wait What?", "敵と弾をノックバックし、 周囲に地割れを起こす#地割れは障害物やドア、 隠し部屋の壁を破壊する"},
    {"485", "Crooked Penny", "部屋の全てのアイテム・ ピックアップ・宝箱を、 50/50の確率で2倍か、 消滅かさせる#消滅した場合コインを 1枚スポーンする"},
    {"486", "Dull Razor", "体力を奪うことなく アイザックを傷つけ、 ダメージをトリガーに するアイテムの効果を 有効化する"},
    {"487", "Potato Peeler", "使用するたび：#↓ 最大体力 -1#↑ 攻撃力 +0.2#{{Collectible73}} 肉の塊を付与#{{Collectible214}} 貧血の効果がその部屋 でのみ有効化する （射程アップ＆流血）"},
    {"488", "Metronome", "ランダムなアイテム効果を その部屋に居る間付与"},
    {"489", "D Infinity", "使用するたびランダムな ダイス系アイテムに変化 する　　"},
    {"490", "Eden's Soul", "!!! 使い切りアイテム !!!#現在の部屋のアイテム プールから、2つの ランダムなアイテムを スポーンする#初期チャージ量が空の ため、要チャージ"},
    {"491", "Acid Baby", "3部屋クリアごとに ランダムなピルを1個 スポーンする使い魔#ピル使用時、部屋の 全ての敵に毒を与える"},
    {"492", "YO LISTEN!", "↑ 運 +1#隠し部屋の入り口、ｘ岩、 クロールスペースの位置 を教えてくれる使い魔"},
    {"493", "Adrenaline", "↑ 空の赤ハート1個につき 攻撃力 +0.2"},
    {"494", "Jacob's Ladder", "涙が衝突した時、火花 放電が1～2回発生する#火花は攻撃力ｘ0.5の ダメージを与える"},
    {"495", "Ghost Pepper", "攻撃中、一定確率で 赤い炎を放つ#炎は接触した敵に ダメージを与え、 弾をブロックする#接触／ブロックを 4回行うと消滅する"},
    {"496", "Euthanasia", "一定確率で涙が注射針に 置き換わる#注射針は敵を即死させ、 円形に10発の涙を拡散する#ボスには攻撃力ｘ3の ダメージを与える#確率：運0=3%、15=100%"},
    {"497", "Camo Undies", "部屋に入った時、攻撃 ボタンを押すまでの間 アイザックを透明化し、 全ての敵を混乱させる"},
    {"498", "Duality", "悪魔部屋か天使部屋が 出現する時、もう一方の 部屋も同時に出現する#一方の部屋に入ると、もう 一方の部屋は消滅する"},
    {"499", "Eucharist", "天使部屋の出現率を 100%にする#天使部屋のドアが 部屋を離れても 開いたままになる"},
    {"500", "Sack of Sacks", "5～6部屋クリアするたび サックをスポーンする 使い魔"},
    {"501", "Greed's Gullet", "所持コイン25枚ごとに 最大体力を1増やす#99枚で最大+4#キーパーにも適用可能"},
    {"502", "Large Zit", "攻撃中、一定確率で 皮脂の弾が発射される#皮脂は2倍のダメージを 与え、敵をスロー状態に する白い液体を床に残す"},
    {"503", "Little Horn", "一定確率で涙に貫通効果が 付与され、触れた敵を即死 させる#確率：運0=5%、15=20%#アイザックに、毎秒7の 接触ダメージ効果を付与"},
    {"504", "Brown Nugget", "2ダメージの涙で近くの 敵を自動攻撃するハエを スポーン"},
    {"505", "Poke Go", "敵が居る部屋に入ると、 20%の確率でチャーム 状態の敵がスポーンする"},
    {"506", "Backstabber", "涙が敵の背面に当たると ダメージが2倍になり、 出血状態が付与される#出血中の敵は5秒ごとに 最大体力の10%に相当 するダメージを受ける"},
    {"507", "Sharp Straw", "部屋の全ての敵に ダメージを与える#ダメージ量は攻撃力+ 敵の最大体力の10%分#この効果でダメージを 与えた時、15%の確率で 半赤ハートをスポーン#赤ハートの体力が無い 場合、半青ハートを スポーンする"},
    {"508", "Mom's Razor", "アイザックを周回する カミソリの使い魔#カミソリは接触した敵に 攻撃力ｘ3のダメージを 毎秒与え、出血状態にする#出血中の敵は5秒ごとに 最大体力の10%に相当 するダメージを受ける#ボスには無効#弾のブロックはしない"},
    {"509", "Bloodshot Eye", "アイザックを周回する 目玉の使い魔#接触した敵に毎秒30の ダメージを与える#2秒に1回、3.5ダメージの 涙を発射する"},
    {"510", "Delirious", "友好的なデリリアムを 召喚する#その部屋でのみ有効"},
    {"511", "Angry Fly", "ランダムな敵の周囲を 飛び回る使い魔#接触した敵に毎秒30の ダメージを与える#周回対象の敵が死ぬと、 別の敵を周回し始める#対象の敵が居ない時、 アイザックを周回する"},
    {"512", "Black Hole", "ブラックホールを生成し、 敵と弾、ピックアップを 6秒間吸引する#吸い込まれた敵に 毎秒6ダメージを与える#近くの障害物を破壊する"},
    {"513", "Bozo", "↑ 攻撃力 +0.1#青ハート +1#敵をランダムに恐怖か チャーム状態にする#ダメージを受けた時、 一定確率で虹色うんちを スポーンする"},
    {"514", "Broken Modem", "敵と弾がランダムな 間隔で遅延を起こす#25%の確率で部屋の クリア報酬が2倍になる"},
    {"515", "Mystery Gift", "!!! 使い切りアイテム !!!#現在の部屋のアイテム プールから、ランダムな アイテムを1つスポーン#低確率で{{Collectible132}}炭の塊か {{Collectible36}}うんちがスポーンする"},
    {"516", "Sprinkler", "八方向に涙を発射する 回転式スプリンクラー#スプリンクラーは アイザックの涙を コピーして発射する"},
    {"517", "Fast Bombs", "爆弾 +7#爆弾を高速で連続設置 可能になる"},
    {"518", "Buddy in a Box", "ランダムな特殊効果・ 攻撃力・連射速度の 涙で攻撃する使い魔#毎フロア、ランダムな 形態へ変化する"},
    {"519", "Lil Delirium", "10秒ごとにランダムな 使い魔に変身する使い魔"},
    {"520", "Jumper Cables", "敵を15体倒すたびに アクティブアイテムを 1チャージする"},
    {"521", "Coupon", "お店の商品・悪魔部屋の アイテムをランダムに 一つ無料にする#保持中、お店の商品が ランダムに一つ半額化"},
    {"522", "Telekinesis", "使用後3秒間、敵の弾が アイザックの周囲で一時 停止し、固定される#3秒経過すると弾が跳ね 返され、3.5ダメージを 与える"},
    {"523", "Moving Box", "部屋の全てのアイテムと ピックアップを保存して 運べる#保存した状態で再使用 すると、中身をその場で 展開する"},
    {"524", "Technology Zero", "涙同士が電気ビームで つながり、触れた敵に ダメージを与える#電気ビームは攻撃力と 等しいダメージを与える"},
    {"525", "Leprosy", "ダメージを受けると 肉片がスポーンし、 アイザックを周回する#肉片は敵に接触ダメージを 与え、弾をブロックする#肉片は一定量の接触・ ブロックで破壊される#最大3つまでスポーン"},
    {"526", "7 Seals", "10秒ごとにランダムな ハービンガーに変化する 使い魔#敵に接触ダメージを与え、 イナゴをスポーンする"},
    {"527", "Mr. ME!", "!!! 照準を合わせた対象に 応じて効果が変化する#アイテムなど：拾って アイザックの元へ運ぶ#お店・悪魔部屋：50%の 確率でアイテムを盗む#宝箱・ドア：鍵や爆弾を 消費せずに開く#敵：追いかけ攻撃する#破壊可能なもの：爆破"},
    {"528", "Angelic Prism", "プリズムがアイザックを 周回し、涙がそれを通過 すると、四色の涙に分裂 して発射される#使い魔の涙にも有効"},
    {"529", "Pop!", "涙を目玉に置き変える#目玉はビリヤード玉の ように互いを弾き合う"},
    {"530", "Death's List", "敵を指定の順番で倒すと、 ランダムな報酬を得る#順番は{{BossRoom}}で示される#報酬のリスト：#青ハート・ピル・ 鍵・爆弾・ニッケル いずれかをスポーン#移動速度・連射速度・ 攻撃力・射程・弾速・ 運いずれかがアップ"},
    {"531", "Haemolacria", "涙が弧を描いて飛び、 衝突すると破裂して 小さな涙が拡散する#↓ 連射速度#↑ 攻撃力　 +31%"},
    {"532", "Lachryphagy", "涙が徐々に減速しながら 飛ぶようになり、停止か 衝突すると破裂して涙を 拡散する#涙が他の涙を吸収し、 サイズとダメージを 増加させるようになる#涙が5つ吸収されると、 即座に破裂する"},
    {"533", "Trisagion", "涙が貫通効果を持つ 短い光線に置き換わる#光線は攻撃力ｘ0.33の ダメージを複数回与える"},
    {"534", "Schoolbag", "アクティブアイテムを 2つ保持可能になる#ドロップボタンで切替え"},
    {"535", "Blanket", "青ハート +1#体力を1回復#ボス部屋に入った時、 一度だけダメージを 無効化するシールドを付与"},
    {"536", "Sacrificial Altar", "!!! 使い切りアイテム !!!#使い魔をランダムに最大 2体生贄に捧げ、等しい 数の悪魔部屋アイテムを スポーンする#所有する青ハエ／クモが コインに変換される"},
    {"537", "Lil Spewer", "アイザックの攻撃に連動 してチャージを溜め、 解放時に有害な液体を 床に吐き出す使い魔#ピルを使用するたびに 液体の効果がランダムに 変化する#取得時、ランダムな ピルを1個スポーン"},
    {"538", "Marbles", "取得時、ランダムな トリンケットを3つ スポーンする#ダメージを受けた時、 5%の確率で保持中の トリンケットが吸収 され、効果が永続化する"},
    {"539", "Mystery Egg", "ダメージを受けると チャーム状態の敵が スポーンする#ノーダメージクリアした 部屋の数が多いほど、 強い敵がスポーンする"},
    {"540", "Flat Stone", "涙が床を跳ねながら 飛ぶようになる#涙が跳ねると飛沫が飛び、 攻撃力ｘ0.25のダメージを 与える"},
    {"541", "Marrow", "骨ハート +1#取得時、赤ハートを3個 スポーンする"},
    {"542", "Slipped Rib", "骨がアイザックを周回し、 敵の弾を跳ね返す"},
    {"543", "Hallowed Ground", "ダメージを受けると 白いうんちがスポーン#うんちオーラの範囲内 では連射速度が増加し、 一定確率でダメージが 無効化される"},
    {"544", "Pointy Rib", "アイザックの正面に 骨が現れ、接触した 敵にダメージを与える#骨は攻撃力と等しい ダメージを毎秒6回 与える　　　"},
    {"545", "Book of the Dead", "その部屋で倒された敵 1体につき、友好的な 骨タイプの敵、または アイザックを周回する 骨を1つスポーンする"},
    {"546", "Dad's Ring", "アイザックを小さな 光輪が囲み、触れた 敵を石化させる"},
    {"547", "Divorce Papers", "↑ 連射速度 +0.7#骨ハート +1#取得時、{{Trinket21}} 謎の紙を スポーンする"},
    {"548", "Jaw Bone", "涙の発射方向に連動して 飛んでいく骨の使い魔#接触した敵に7ダメージを 与え、弾をブロックする#ピックアップを回収可能"},
    {"549", "Brittle Bones", "最大体力を0にし、6個の 骨ハートに置き換える#骨ハートを失うと：#8方向に骨が飛び散る#↑ 連射速度 +0.5（永続）"},
    {"550", "Broken Shovel", "保持中、数秒おきに アイザックを狙った 踏み潰し攻撃が発生する#使用すると、その部屋に 居る間、踏み潰し攻撃が 停止する#!!! (ボスラッシュに挑戦！)"},
    {"551", "Broken Shovel", "壊れたシャベルの先端部#組み合わせると ママのシャベルに"},
    {"552", "Mom's Shovel", "次のフロアにつながる トラップドアを生成#10%の確率でクロール スペースにつながる#!!! ある場所で使うと…？"},
}

---------- Trinkets ----------
EID.descriptions[languageCode].trinkets={
    {"1", "Swallowed Penny", "ダメージを受けた時 コインを1枚スポーン"},
    {"2", "Petrified Poop", "うんち破壊時、50%の 確率でピックアップが スポーン"},
    {"3", "AAA Battery", "アクティブアイテムの 必要チャージ量が1減る"},
    {"4", "Broken Remote", "アクティブアイテムを 使用した時、ランダム な部屋にテレポート"},
    {"5", "Purple Heart", "チャンピオンタイプの敵・ ボスの出現率2倍"},
    {"6", "Broken Magnet", "コインがアイザックに 引き寄せられる"},
    {"7", "Rosary Bead", "↑ 天使部屋の出現率 +25%#図書館とお店で{{Collectible33}}聖書の 出現率アップ"},
    {"8", "Cartridge", "ダメージを受けた時、一定 確率でゲームキッド効果が 発動（無敵・接触ダメージ）#確率：運0=5%、38=100%"},
    {"9", "Pulse Worm", "涙が拡縮しながら飛ぶ"},
    {"10", "Wiggle Worm", "涙が波打つように飛ぶ#↑ 連射速度 +0.3"},
    {"11", "Ring Worm", "涙が渦巻き状に飛ぶ"},
    {"12", "Flat Worm", "涙の横幅が50%広がる#ノックバック強化"},
    {"13", "Store Credit", "お店のアイテムが一つ無料 になり、取得すると消滅"},
    {"14", "Callus", "トゲや液体などの、足元 からのダメージを無効化"},
    {"15", "Lucky Rock", "岩や障害物を壊すと コインが1枚スポーン"},
    {"16", "Mom's Toenail", "60秒おきにランダムな 位置にママの踏み潰し 攻撃が発生する"},
    {"17", "Black Lipstick", "青ハートが黒ハートとして スポーンする確率 +10%"}, -- base chance is +5%
    {"18", "Bible Tract", "白ハートの出現率 +3%"}, -- base chance is 1.667%
    {"19", "Paper Clip", "鍵を消費せずに鍵付きの 宝箱を解錠できる"},
    {"20", "Monkey Paw", "ダメージを受け、残りの 体力が半ハートになった 時、黒ハートを1個落とす#3個まで有効"},
    {"21", "Mysterious Paper", "{{Collectible327}} ポラロイド#{{Collectible328}} ネガティブ#{{Trinket23}} 尋ね人ポスター#{{Trinket48}} 失くしたページ いずれかの効果が ランダムに発動する"},
    {"22", "Daemon's Tail", "スポーンするハートの 80%が鍵に置き換わる#ハートは、可能な限り 黒ハートに置き換わる"},
    {"23", "Missing Poster", "保持中に生贄部屋で死ぬと ザ・ロストをアンロック#アンロック済みの場合： 死ぬと、その部屋で ザ・ロストとして復活"},
    {"24", "Butt Penny", "コインを拾うとおならが 出て、敵をノックバック させる　　　#うんちからコインが スポーンする確率 +20%"},
    {"25", "Mysterious Candy", "30秒おきにうんちか おならを出す"},
    {"26", "Hook Worm", "涙が矩形波のように飛ぶ#↑ 射程 +10"},
    {"27", "Whip Worm", "↑ 弾速 +0.5"},
    {"28", "Broken Ankh", "死ぬと、22.22%の確率で 一つ前の部屋に？？？と して復活する"},
    {"29", "Fish Head", "ダメージを受けるたび 青ハエがスポーンする"},
    {"30", "Pinky Eye", "一定確率で毒の涙を放つ#確率：運0=10%、18=100%"},
    {"31", "Push Pin", "一定確率で涙に貫通・ 透過効果を付与#確率：運0=10%、18=100%"},
    {"32", "Liberty Cap", "部屋に入るたび、25%の 確率でいずれかの効果を 付与する：#{{Collectible71}} ミニ マッシュ#{{Collectible120}} 変なキノコ#{{Collectible121}} 変なキノコ#{{Collectible21}} コンパス"},
    {"33", "Umbilical Cord", "残りの体力が半赤ハートに なった時、その部屋に居る 間{{Collectible100}}リトルスティーブンを 付与する"},
    {"34", "Child's Heart", "部屋クリア時の報酬が 10%の確率でランダムな ハートに置き換わる#宝箱・ｘ岩・破壊された 機械から追加のハートが スポーンすることがある"},
    {"35", "Curved Horn", "↑ 攻撃力 +2"},
    {"36", "Rusted Key", "部屋クリア時の報酬が 10%の確率で鍵に置き 換わる　　　#宝箱・ｘ岩・破壊された 機械から、追加の鍵が スポーンすることがある"},
    {"37", "Goat Hoof", "↑ 移動速度 +0.15"},
    {"38", "Mom's Pearl", "青／黒／骨ハートの 出現率 +10%"}, -- base chance is 10%
    {"39", "Cancer", "↑ 連射間隔 -2"},
    {"40", "Red Patch", "ダメージを受けた時、 一定確率で攻撃力 +1.8#確率：運0=20%、8=100%#効果はスタック可能で、 その部屋でのみ有効"},
    {"41", "Match Stick", "部屋クリア時の報酬が 10%の確率で爆弾に置き 換わる#宝箱・ｘ岩・破壊された 機械から、追加の爆弾が スポーンすることがある#!!! {{Trinket53}}ダニを除去できる"},
    {"42", "Lucky Toe", "↑ 運 +1#部屋クリア時の報酬 出現率が8%アップ#宝箱・ｘ岩・破壊された 機械から、追加のピック アップがスポーンする ことがある"},
    {"43", "Cursed Skull", "ダメージを受け、残りの 体力が半ハートになると ランダムな部屋にテレポート"},
    {"44", "Safety Cap", "部屋クリア時の報酬が 10%の確率でピルに置き 換わる#宝箱・ｘ岩・破壊された 機械から、追加のピルが スポーンすることがある"},
    {"45", "Ace of Spades", "部屋クリア時の報酬が 10%の確率でカードに置き 換わる#宝箱・ｘ岩・破壊された 機械から、追加のカードが スポーンすることがある"},
    {"46", "Isaac's Fork", "部屋クリア時、10%の 確率で半赤ハート回復#確率は運18で最大100%に"},
    {"47", "", "<Item does not exist>"},
    {"48", "A Missing Page", "ダメージを受けた時、 ネクロノミコン効果が  一定確率で発動する （全ての敵に40ダメージ）"},
    {"49", "Bloody Penny", "コイン取得時、50%の確率で 半赤ハートをスポーン"},
    {"50", "Burnt Penny", "コイン取得時、50%の 確率で爆弾をスポーン"},
    {"51", "Flat Penny", "コイン取得時、50%の 確率で鍵をスポーン"},
    {"52", "Counterfeit Penny", "コイン取得時、50%の 確率で所持金が1増える"},
    {"53", "Tick", "ボスのHPが15%減少#ボス部屋に入った時、 赤ハート1個回復#!!! 取得すると取り外せない#{{Trinket41}}マッチ棒で除去可能"},
    {"54", "Isaac's Head", "貫通効果付き涙で攻撃する 使い魔を付与"},
    {"55", "Maggy's Faith", "フロア開始時、白ハートを 1個付与する"},
    {"56", "Judas' Tongue", "ハート2個の悪魔取引を ハート1個に割り引く"},
    {"57", "???'s Soul", "部屋を飛び回り、透過と ホーミング効果付き涙で 攻撃する使い魔を付与"},
    {"58", "Samson's Lock", "敵を倒した時、一定確率で 攻撃力 +0.5（最大 +5）#確率：運0=6.66%、10=100%#その部屋でのみ有効"},
    {"59", "Cain's Eye", "フロア開始時、一定確率で {{Collectible21}}コンパスの効果を付与#確率：運0=25%、3=100%"},
    {"60", "Eve's Bird Foot", "敵を倒した時、一定確率で {{Collectible117}}鳥の死体が現れる#確率：運0=5%、8=100%"},
    {"61", "The Left Hand", "全ての宝箱を赤宝箱に変換"},
    {"62", "Shiny Rock", "ｘ岩とクロールスペース 付きの岩が10秒おきに点滅"},
    {"63", "Safety Scissors", "トロル爆弾が通常の爆弾 ピックアップに変化する"},
    {"64", "Rainbow Worm", "ランダムなワーム系の トリンケットの効果が 3秒おきに付与される"},
    {"65", "Tape Worm", "↑ 射程　　 x2#涙の高さ -50%"},
    {"66", "Lazy Worm", "↓ 弾速　　 -0.4#↑ 射程　　 +4#↑ 涙の高さ +2"},
    {"67", "Cracked Dice", "ダメージを受けた時、 D6／D8／D12／D20 いずれかの効果が 50%の確率で発動"},
    {"68", "Super Magnet", "ピックアップと敵が アイザックに引き寄せ られるようになる"},
    {"69", "Faded Polaroid", "アイザックが時々透明に なり、敵を混乱させる"},
    {"70", "Louse", "バトル中、ランダムに 青クモがスポーンする"},
    {"71", "Bob's Bladder", "爆弾が置かれた場所に 緑色の液体が残り、 触れた敵にダメージを 与える"},
    {"72", "Watch Battery", "部屋クリア時の報酬に 電池が出現する確率が 6.67%アップ#ランダムピックアップが 電池になる確率が2%アップ#部屋をクリアした時、 5%の確率でアクティブ アイテムが1チャージ される　　　"},
    {"73", "Blasting Cap", "爆発した爆弾が10%の 確率で爆弾をスポーン"},
    {"74", "Stud Finder", "岩を壊した時、0.5%の 確率でクロールスペースが 生成される"},
    {"75", "Error", "部屋ごとにランダムな トリンケットの効果を 付与する"},
    {"76", "Poker Chip", "宝箱を開くと50%の確率で 追加の報酬がスポーンし、 50%の確率で中身がハエに 置き換わる"},
    {"77", "Blister", "ノックバック強化"},
    {"78", "Second Hand", "敵に与える状態異常の 有効時間が2倍になる"},
    {"79", "Endless Nameless", "カード・ルーン・ピル 使用時、25%の確率で コピーをスポーンする"},
    {"80", "Black Feather", "↑ 所持する悪魔タイプの アイテム・トリンケット 1個につき攻撃力 +0.2"},
    {"81", "Blind Rage", "ダメージを受けた瞬間の 無敵時間を2倍にする"},
    {"82", "Golden Horse Shoe", "15%の確率でトレジャー ルームのアイテムが2つ になり、どちらかを選択 できる"},
    {"83", "Store Key", "鍵を使わずにお店へ 入ることができる"},
    {"84", "Rib of Greed", "お店・隠し部屋で グリードが現れなくなる#部屋のクリア報酬に コインの出現率が増え、 ハートの出現率が減る"},
    {"85", "Karma", "寄付マシーンへの寄付時に 運が上がりやすくなる#寄付マシーンに寄付すると 一定確率で以下の効果が 発生する：#体力を1回復#乞食がスポーン#キャッシュバック"},
    {"86", "Lil Larva", "うんちを壊すと青ハエが スポーンする"},
    {"87", "Mom's Locket", "鍵を使った時、半赤ハート 回復する#半赤ハートを赤ハートに 変換する"},
    {"88", "NO!", "保持中、アクティブ アイテムがスポーン しなくなる"},
    {"89", "Child Leash", "使い魔がアイザックに近付く"},
    {"90", "Brown Cap", "うんちを壊すと爆発する"},
    {"91", "Meconium", "33%の確率で、うんちが 黒うんちに置き換わる#黒うんちから5%の確率で 黒ハートがスポーンする"},
    {"92", "Cracked Crown", "↑ アイテムやトリンケット からのステータス上昇値を 33%アップさせる#↑ 連射間隔 -20%"},
    {"93", "Used Diaper", "特定の部屋で{{Collectible9}}スカトール 効果が付与され、ハエ系の 敵が中立化する"},
    {"94", "Fish Tail", "青ハエ／クモをスポーン するタイプのアイテム・ トリンケットの効果を 2倍にする"},
    {"95", "Black Tooth", "3%の確率で黒い歯が発射 され、2倍のダメージと 毒を与える#確率は運32で最大100%に"},
    {"96", "Ouroboros Worm", "涙が渦を描くように飛ぶ#涙に透過効果を付与#↑ 射程　　 +4#↑ 涙の高さ +2"},
    {"97", "Tonsil", "12～20回ダメージを 受けると、敵の弾を ブロックする使い魔が スポーンする#最大2体までスポーン"},
    {"98", "Nose Goblin", "10%の確率でホーミング 効果付きの鼻くそが飛び、 敵に 60秒間くっ付く#鼻くそは攻撃力と 等しいダメージを 毎秒与える"},
    {"99", "Super Ball", "10%の確率で衝突した 涙が跳ね返る"},
    {"100", "Vibrant Bulb", "!!! アクティブアイテムが フルチャージの時：#↑ 攻撃力　 +0.5#↑ 移動速度 +0.25#↑ 射程　　 +0.75#↑ 連射速度 +0.2#↑ 弾速　　 +0.1#↑ 運　　　 +1"},
    {"101", "Dim Bulb", "!!! アクティブアイテムの チャージが空の時：#↑ 攻撃力　 +1.5#↑ 移動速度 +0.5#↑ 射程　　 +1.5#↑ 連射速度 +0.4#↑ 弾速　　 +0.3#↑ 運　　　 +2"},
    {"102", "Fragmented Card", "保持して次のフロアへ 移動すると、追加の 隠し部屋が生成される"},
    {"103", "Equality!", "コイン・爆弾・鍵の 所持数が等しい時、 各ピックアップが ダブルバージョンに 変換される"},
    {"104", "Wish Bone", "ダメージを受けた時 2%の確率でその部屋の アイテムプールから ランダムなアイテムを スポーンする#効果発動後に消滅する"},
    {"105", "Bag Lunch", "ダメージを受けた時 2%の確率で{{Collectible22}}昼ごはんが スポーンする#効果発動後に消滅する"},
    {"106", "Lost Cork", "アイテムや使い魔から 生成される液体の効果 範囲が広がる"},
    {"107", "Crow Heart", "ダメージを受ける時、 赤ハートが優先して 消費される　　"},
    {"108", "Walnut", "1～9回の爆発を受けると 消滅し、コイン・鍵・ ハート・トリンケットを スポーンする#爆発ダメージが無効化 されている状態でも 回数にカウントされる"},
    {"109", "Duct Tape", "このトリンケットを 取得した時の位置に 使い魔が固定される"},
    {"110", "Silver Dollar", "保持して子宮／ユテロ／ 傷だらけの子宮フロアに 移動すると、お店が生成 される　　"},
    {"111", "Bloody Crown", "保持して子宮／ユテロ／ 傷だらけの子宮フロアに 移動すると、トレジャー ルームが生成される"},
    {"112", "Pay To Win", "トレジャールームに リロールマシーンが 常時出現する"},
    {"113", "Locust of War", "敵の居る部屋に入ると、 イナゴがスポーンする#イナゴは攻撃力x2の ダメージを与えた後 爆発する"},
    {"114", "Locust of Pestilence", "敵の居る部屋に入ると、 イナゴがスポーンする#イナゴは攻撃力x2の ダメージと毒を与える"},
    {"115", "Locust of Famine", "敵の居る部屋に入ると、 イナゴがスポーンする#イナゴは攻撃力x2の ダメージを与え、 スロー状態にする"},
    {"116", "Locust of Death", "敵の居る部屋に入ると、 イナゴがスポーンする#イナゴは攻撃力x4の ダメージを与える"},
    {"117", "Locust of Conquest", "敵の居る部屋に入ると、 1～4匹のイナゴが スポーンする#イナゴは攻撃力x2の ダメージを与える"},
    {"118", "Bat Wing", "敵を倒すと、5%の確率で 飛行能力が付与される#その部屋でのみ有効"},
    {"119", "Stem Cell", "フロア移動時に半赤ハート 回復する"},
    {"120", "Hairpin", "ボス部屋に初めて入った時 アクティブアイテムをフル チャージする"},
    {"121", "Wooden Cross", "各フロアで一度だけ ダメージを無効にする"},
    {"122", "Butter!", "アクティブアイテムを 使うと、足元にそれが ドロップされる#ダメージを受けた時、 2%の確率で取得済み パッシブアイテムが 足元にドロップされる"},
    {"123", "Filigree Feather", "天使を倒した時、カギの かけらの代わりに、 天使部屋のアイテムを スポーンする"},
    {"124", "Door Stop", "入って来たドアが 開いたままになる"},
    {"125", "Extension Cord", "アイザックと使い魔の間に 電気ビームが発生し、敵に 6ダメージを与える"},
    {"126", "Rotten Penny", "コインを拾うと青ハエが スポーンする"},
    {"127", "Baby-Bender", "使い魔の涙にホーミング 効果が付与される"},
    {"128", "Finger Bone", "ダメージを受けた時、2%の 確率で骨ハートを付与"},
}

---------- Cards ----------
EID.descriptions[languageCode].cards={
    {"1", "0 - The Fool", "フロア開始時の部屋に テレポートする"},
    {"2", "I - The Magician", "その部屋に居る間、涙に ホーミング効果を付与"},
    {"3", "II - The High Priestess", "ママの踏み潰し攻撃で 敵に300ダメージ"},
    {"4", "III - The Empress", "その部屋に居る間：#↑ 攻撃力　 +2.35#↑ 移動速度 +0.3"},
    {"5", "IV - The Emperor", "ボス部屋にテレポート"},
    {"6", "V - The Hierophant", "青ハートを2個スポーン"},
    {"7", "VI - The Lovers", "赤ハートを2個スポーン"},
    {"8", "VII - The Chariot", "無敵状態と接触ダメージ 効果を6秒間付与"},
    {"9", "VIII - Justice", "ハート・コイン・爆弾・ 鍵を各1個スポーン"},
    {"10", "IX - The Hermit", "お店にテレポート"},
    {"11", "X - Wheel of Fortune", "スロットマシーンか 占いマシーンをスポーン"},
    {"12", "XI - Strength", "その部屋に居る間：#↑ 最大体力 +1#↑ 攻撃力　 +0.3#↑ 攻撃力　 +50%#↑ 射程　　 +5.25#↑ 涙の高さ +0.5#↑ 移動速度 +0.3"},
    {"13", "XII - The Hanged Man", "その部屋に居る間、 飛行能力を付与"},
    {"14", "XIII - Death", "全ての敵に40ダメージ"},
    {"15", "XIV - Temperance", "献血機をスポーン#グリードモードでは 悪魔乞食をスポーン"},
    {"16", "XV - The Devil", "その部屋に居る間：#↑ 攻撃力 +2"},
    {"17", "XVI - The Tower", "トロル爆弾を6個スポーン"},
    {"18", "XVII - The Stars", "トレジャールームに テレポート"},
    {"19", "XVIII - The Moon", "隠し部屋にテレポート"},
    {"20", "XIX - The Sun", "全ての敵に100ダメージ#体力全回復#フルマッピング効果"},
    {"21", "XX - Judgement", "乞食か悪魔乞食をスポーン"},
    {"22", "XXI - The World", "フルマッピング効果"},
    {"23", "2 of Clubs", "爆弾の所持数を2倍にする#未所持の場合+2個"},
    {"24", "2 of Diamonds", "所持金を2倍にする#未所持の場合+2枚"},
    {"25", "2 of Spades", "鍵の所持数を2倍にする#未所持の場合+2個"},
    {"26", "2 of Hearts", "残り体力を2倍にする#体力が0の場合1回復"},
    {"27", "Ace of Clubs", "全てのピックアップ・ 宝箱を爆弾に変換する"},
    {"28", "Ace of Diamonds", "全てのピックアップ・ 宝箱をコインに変換する"},
    {"29", "Ace of Spades", "全てのピックアップ・ 宝箱を鍵に変換する"},
    {"30", "Ace of Hearts", "全てのピックアップ・ 宝箱をハートに変換する"},
    {"31", "Joker", "悪魔部屋か天使部屋に テレポート"},
    {"32", "Hagalaz", "全ての障害物を破壊する"},
    {"33", "Jera", "部屋の全ての宝箱と ピックアップを複製する"},
    {"34", "Ehwaz", "次のフロアにつながる トラップドアを生成#8%の確率でクロール スペースにつながる"},
    {"35", "Dagaz", "青ハート +1#フロアの呪いを解く"},
    {"36", "Ansuz", "フルマッピング効果 （裏隠し部屋を含む）"},
    {"37", "Perthro", "部屋の全てのアイテムを リロールする"},
    {"38", "Berkano", "青ハエ／クモを3匹ずつ スポーンする"},
    {"39", "Algiz", "ダメージを無効化する シールドを30秒間展開"},
    {"40", "Blank Rune", "ランダムなルーンの 効果を発動する#25%の確率でブランク ルーンをスポーンする"},
    {"41", "Black Rune", "全ての敵に40ダメージ#全てのアイテムを破壊し、 ランダムなステータスを アップさせる#全てのピックアップを 青ハエ／クモに変換する"},
    {"42", "Chaos Card", "移動方向にカードを投げ、 触れた敵を即死させる#デリリウムは即死無効"},
    {"43", "Credit Card", "お店の商品／悪魔部屋の アイテムを全て無料にする"},
    {"44", "Rules Card", "やくだつじょうほうを表示"},
    {"45", "A Card Against Humanity", "部屋をうんちで埋め尽くす"},
    {"46", "Suicide King", "アイザックを殺し、その 部屋に10個のアイテム・ ピックアップ・宝箱を スポーンする"},
    {"47", "Get Out Of Jail Free Card", "部屋の全てのドアと、 隠し部屋の入り口を開く"},
    {"48", "? Card", "現在保持中のアクティブ アイテムの効果をコピー する"},
    {"49", "Dice Shard", "全てのピックアップと アイテムをリロールする"},
    {"50", "Emergency Contact", "ママの手が敵をつかんで 動きを止め、40ダメージ を与える"},
    {"51", "Holy Card", "その部屋で次に受ける ダメージを一度だけ 無効化する#25%の確率で別の聖なる カードをスポーンする"},
    {"52", "Huge Growth", "その部屋に居る間：#↑ 攻撃力 +7#↑ 射程　 +30#障害物破壊能力を付与#アイザックのサイズ拡大"},
    {"53", "Ancient Recall", "ランダムなカードを 3枚スポーン"},
    {"54", "Era Walk", "その部屋に居る間：#全ての敵をスロー状態に#↑ 移動速度 +0.5#↓ 弾速　　 -1"},
}

---------- Pills ----------
EID.descriptions[languageCode].unidentifiedPill = "未識別のピル"

EID.descriptions[languageCode].pills={
    {"0", "Bad Gas", "おならを放ちダメージと 毒を与える"},
    {"1", "Bad Trip", "ハート1個の ダメージを受ける#ハートが1個以下の場合、 体力全快ピルに変化"},
    {"2", "Balls of Steel", "青ハート +2"},
    {"3", "Bombs are Key", "爆弾と鍵の所持数を 入れ替える"},
    {"4", "Explosive Diarrhea", "アイザックの尻から 点火済みの爆弾が 5連続スポーンする"},
    {"5", "Full Health", "体力全回復"},
    {"6", "Health Down", "↓ 最大体力 -1#最大体力が1以下の 場合、HPアップに変化"},
    {"7", "Health Up", "↑ 最大体力 +1"},
    {"8", "I Found Pills", "効果なし"},
    {"9", "Puberty", "3回使用すると大人になる （最大体力 +1）"},
    {"10", "Pretty Fly", "アイザックを周回する ハエを付与する#最大3匹まで付与"},
    {"11", "Range Down", "↓ 射程 -2"},
    {"12", "Range Up", "↑ 射程 +2.5"},
    {"13", "Speed Down", "↓ 移動速度 -0.12"},
    {"14", "Speed Up", "↑ 移動速度 +0.15"},
    {"15", "Tears Down", "↓ 連射速度 -0.28"},
    {"16", "Tears Up", "↑ 連射速度 +0.35"},
    {"17", "Luck Down", "↓ 運 -1"},
    {"18", "Luck Up", "↑ 運 +1"},
    {"19", "Telepills", "ランダムな部屋に テレポートする#低確率でI AM ERRORへ"},
    {"20", "48 Hour Energy!", "アクティブアイテムを フルチャージする#1～2個の電池をスポーン"},
    {"21", "Hematemesis", "赤ハートを1個残しで 空にして、1～4個の 赤ハートをスポーン"},
    {"22", "Paralysis", "2秒間のマヒ"},
    {"23", "I can see forever!", "現フロアの隠し部屋の 入り口を全て開放する"},
    {"24", "Pheromones", "全ての敵をチャーム 状態にする"},
    {"25", "Amnesia", "マップを？に置き換える (迷われし者の呪い)"},
    {"26", "Lemon Party", "レモン汁が床に広がり、 触れた敵にダメージを 与える"},
    {"27", "R U A Wizard?", "30秒間、涙が斜め外側に 飛ぶ"},
    {"28", "Percs!", "その部屋に居る間、 受けるダメージを 半ハートに軽減する"},
    {"29", "Addicted!", "その部屋に居る間、 受けるダメージが ハート1個分に増加"},
    {"30", "Re-Lax", "2秒間うんちを出し続ける"},
    {"31", "???", "現フロアに迷路の呪いを かける"},
    {"32", "One makes you larger", "アイザックのサイズ拡大#当たり判定は不変"},
    {"33", "One makes you small", "アイザックのサイズ縮小#当たり判定も縮小"},
    {"34", "Infested!", "部屋の全てのうんちを 壊し、同数の青クモを スポーンする"},
    {"35", "Infested?", "部屋に居る敵と同数の 青クモをスポーンする#敵が居ない場合1～3匹の 青クモをスポーンする"},
    {"36", "Power Pill!", "6秒間パックマン化し、 以下の効果を得る：#無敵状態#全ての敵に恐怖状態付与#40の接触ダメージ#敵を2体倒すたび1/2ハート回復#涙攻撃不可"},
    {"37", "Retro Vision", "ゲーム画面が30秒間 ピクセル加工される"},
    {"38", "Friends Till The End!", "青ハエを3匹スポーン"},
    {"39", "X-Lax", "茶色の液体が床に広がり、 アイザックをスリップ させる"},
    {"40", "Something's wrong...", "黒い液体が床に広がり、 触れた敵をスロー状態に する"},
    {"41", "I'm Drowsy...", "部屋の全ての敵を スロー状態にする"},
    {"42", "I'm Excited!!!", "部屋の全ての敵を 加速状態にする"},
    {"43", "Gulp!", "保持中のトリンケットを 吸収し、効果を永続化する"},
    {"44", "Horf!", "{{Collectible149}}吐き気薬の涙を一発放つ"},
    {"45", "Feels like I'm walking on sunshine!", "6秒間無敵状態になり 移動速度が0.28増加 するが、攻撃能力を 一時的に失う"},
    {"46", "Vurp!", "最後に使用したピルを スポーンする"},
}

---------- Sacrifice Room ----------
EID.descriptions[languageCode].sacrificeHeader = "[次の生贄部屋の報酬]"

EID.descriptions[languageCode].sacrifice={
    {"1", "", "50%の確率でコインを1枚 スポーンする#1分以内にボスを倒し、 爆弾を未所持の場合、 爆弾を1個スポーンする ※一階層目でのみ有効"},
    {"2", "", "50%の確率でコインを1枚 スポーンする#1分以内にボスを倒し、 爆弾を未所持の場合、 爆弾を1個スポーンする ※一階層目でのみ有効"},
    {"3", "", "67%の確率で天使部屋の 出現率がアップする"},
    {"4", "", "50%の確率でランダムな 宝箱を1個スポーンする"},
    {"5", "", "33%の確率でコインを3枚 スポーンする#67%の確率で天使部屋の 出現率がアップする"},
    {"6", "", "33%の確率で天使部屋に テレポートする#そのフロアですでに悪魔 部屋が出現している場合 悪魔部屋にテレポート#67%の確率でランダムな 宝箱を1個スポーンする"},
    {"7", "", "33%の確率でランダムな 天使部屋アイテムを1個 スポーンする#67%の確率で青ハートを 1個スポーン"},
    {"8", "", "トロル爆弾を7個スポーン"},
    {"9", "", "ウリエルがスポーン"},
    {"10", "", "50%の確率で青ハートを7個 スポーンする#50%の確率でコインを30枚 スポーンする"},
    {"11", "", "ガブリエルがスポーン"},
    {"12", "", "50%の確率で真っ暗な部屋に テレポートする"},
}

---------- Dice Room ----------
EID.descriptions[languageCode].diceHeader = "[ダイス部屋の効果]"

EID.descriptions[languageCode].dice={
    {"1", "", "取得済みの全ての パッシブアイテムと アクティブアイテムを リロールする"},
    {"2", "", "部屋の全てのピック アップをリロールする"},
    {"3", "", "フロアの全てのピック アップとトリンケットを リロールする#悪魔部屋／天使部屋には 効果なし"},
    {"4", "", "フロアの全てのアイテムを リロールする#悪魔部屋／天使部屋には 効果なし"},
    {"5", "", "現在のフロアを再生成し、 リスタートする"},
    {"6", "", "取得済みの全ての パッシブアイテムと アクティブアイテムを リロールする#フロアの全てのピック アップとトリンケットと アイテムをリロールする"},
}

---------- Transformations ----------
EID.descriptions[languageCode].transformations={
    "",   				 -- 0 = none
    "Guppy",   		 -- 1
    "Fun Guy",   		 -- 2
    "Beelzebub",   	 -- 3
    "Conjoined",   	 -- 4
    "Spun",   			 -- 5
    "Yes Mother?",   	 -- 6
    "Oh Crap",   		 -- 7
    "Bob",   			 -- 8
    "Leviathan",   	 -- 9
    "Seraphim",   		 -- 10
    "Super Bum",   	 -- 11
    "Bookworm",   		 -- 12
    "Spider Baby",   	 -- 13
    "Adult",   		 -- 14
    "Stompy"   		 -- 15
}


---------- MISC ----------

EID.descriptions[languageCode].VoidText = "吸収した時："
-- {1} will become the number text (like "{1} Tears up" -> "+0.5 Tears up")
EID.descriptions[languageCode].VoidNames = {"{1} 移動速度アップ", "{1} 連射速度アップ", "{1} 攻撃力アップ", "{1} 射程アップ", "{1} 弾速アップ", "{1} 運アップ"}

EID.descriptions[languageCode].CollectionPageInfo = "コレクションページに登録されていない、今まで未取得のアイテム"

EID.descriptions[languageCode].MCM = {
    DemoObjectName = "Demo Object Name",
    DemoObjectTransformation = "Demo Transformation",
    DemoObjectText = "日本語の表示サンプル#↑ 行間 +0.5#↓ 文字のサイズ +0.25#説明文は、単語間の半角 スペースで自動的に改行 されます#!!! 日本語はスペースを使用 しないので、改行位置に 半角スペースを決め打ち しています 表示幅をデフォルトから 変更すると表示が崩れる 可能性があります#デフォルトの表示幅:130 全角13文字が一行の限界",
}

EID.descriptions[languageCode].HoldMapTitle = "アイテムリマインダー"
-- the Hold Map description will predict the abilities of items with a header like "Item Name Result"
EID.descriptions[languageCode].HoldMapHeader = " 結果"

-- https://wofsauge.github.io/IsaacDocs/rep/enums/RoomType.html
-- Includes Repentance room types for localization convenience
EID.descriptions[languageCode].RoomTypeNames = { "通常の部屋", "お店", "I AM ERROR", "トレジャールーム", "ボス部屋", "中ボス部屋", "隠し部屋", "裏隠し部屋", "アーケード部屋", "呪い部屋", "チャレンジルーム", "図書館", "生贄部屋", "悪魔部屋", "天使部屋", "地下室", "ボスラッシュ部屋", "寝室", "汚れた寝室", "宝物庫", "ダイス部屋", "ブラックマーケット", "出口", "プラネタリウム", "テレポーター部屋", "テレポーター出口", "代替ルート入口", "青い部屋", "離れ隠し部屋",
-- Not technically room types but still potentially useful to have localized
[666] = "天使／悪魔部屋", [1024] = "赤い部屋", [1025] = "特殊な赤い部屋" }

-- currently used for D1
EID.descriptions[languageCode].PickupNames = {
	["5.0"] = "None",
	
	["5.10"] = "{{Heart}} ハート",
	["5.10.1"] = "{{Heart}} ハート", ["5.10.2"] = "{{HalfHeart}} 半ハート", ["5.10.3"] = "{{SoulHeart}} 青ハート", ["5.10.4"] = "{{EternalHeart}} 白ハート", ["5.10.5"] = "{{Heart}} ハートｘ2", ["5.10.6"] = "{{BlackHeart}} 黒ハート", ["5.10.7"] = "{{GoldHeart}} 金ハート", ["5.10.8"] = "{{HalfSoulHeart}} 半青ハート", ["5.10.9"] = "{{Heart}} 脅えるハート", ["5.10.10"] = "{{BlendedHeart}} 混合ハート", ["5.10.11"] = "{{EmptyBoneHeart}} 骨ハート", ["5.10.12"] = "{{RottenHeart}} 腐ったハート",
	
	["5.20"] = "{{Coin}} コイン",
	["5.20.1"] = "{{Crafting8}} ペニー", ["5.20.2"] = "{{Crafting9}} ニッケル", ["5.20.3"] = "{{Crafting10}} ダイム", ["5.20.4"] = "{{Crafting8}} ダブルペニー", ["5.20.5"] = "{{Crafting11}} ラッキーペニー", ["5.20.6"] = "{{Crafting9}} 粘着ニッケル", ["5.20.7"] = "{{Crafting26}} ゴールデンペニー",
	
	["5.30"] = "{{Key}} 鍵",
	["5.30.1"] = "{{Crafting12}} 鍵", ["5.30.2"] = "{{Crafting13}} 金の鍵", ["5.30.3"] = "{{Crafting12}} 鍵ｘ2", ["5.30.4"] = "{{Crafting14}} 帯電した鍵",
	
	["5.40"] = "{{Bomb}} 爆弾",
	["5.40.1"] = "{{Crafting15}} 爆弾", ["5.40.2"] = "{{Crafting15}} 爆弾ｘ2", ["5.40.3"] = "{{Crafting15}} トロル爆弾", ["5.40.4"] = "{{Crafting16}} 金爆弾", ["5.40.5"] = "{{Crafting15}} メガトロル爆弾", ["5.40.7"] = "{{Crafting17}} 巨大爆弾",
	
	["5.90"] = "{{Battery}} 電池",
	["5.90.0"] = "{{Crafting19}} 電池", --AB+ didn't have subtypes for batteries
	["5.90.1"] = "{{Crafting19}} 電池", ["5.90.2"] = "{{Crafting18}} ミニ電池", ["5.90.3"] = "{{Crafting20}} メガ電池", ["5.90.4"] = "{{Crafting28}} 金電池",
	
	["5.50"] = "{{Chest}} 宝箱", ["5.51"] = "{{BombChest}} 石宝箱", ["5.52"] = "{{SpikedChest}} トゲ付き宝箱", ["5.53"] = "{{EternalChest}} 白宝箱", ["5.54"] = "{{MimicChest}} 罠宝箱", ["5.55"] = "{{OldChest}} 古びた宝箱", ["5.56"] = "{{WoodenChest}} 木の宝箱", ["5.57"] = "{{MegaChest}} 巨大宝箱", ["5.58"] = "{{HauntedChest}} 呪いの宝箱", ["5.60"] = "{{GoldenChest}} 金宝箱", ["5.360"] = "{{RedChest}} 赤宝箱",  
	
	["5.69"] = "{{GrabBag}} サック", ["5.69.1"] = "{{GrabBag}} サック", ["5.69.2"] = "{{BlackSack}} 黒サック",
	
	["5.70"] = "{{Pill}} ピル",
	["5.300"] = "{{Card}} カード",
	["5.301"] = "{{Rune}} ルーン", -- not a real id
	["5.350"] = "{{Trinket}} トリンケット",

}
