--==========================================================================================================================
-- LOADING INFO
--==========================================================================================================================
-- LoadingInfo
-------------------------------------	
INSERT INTO LoadingInfo	
		(LeaderType,					ForegroundImage,					BackgroundImage,				PlayDawnOfManAudio)
VALUES	('LEADER_ANT_WUDI',				'LEADER_ANT_WUDI_NEUTRAL',			'LEADER_CLEOPATRA_BACKGROUND',	0);	
--==========================================================================================================================
-- DIPLOMACY INFO
--==========================================================================================================================
-- DiplomacyInfo
-------------------------------------	
-- INSERT INTO DiplomacyInfo	
-- 			(Type,						BackgroundImage)
-- VALUES	('LEADER_ANT_WUDI',			'FALLBACK_NEUTRAL_ANT_WUDI.dds');
--==========================================================================================================================
-- COLOURS
--==========================================================================================================================
-- PlayerColors
-------------------------------------	
INSERT INTO PlayerColors	
		(Type,							Usage,				PrimaryColor, 							SecondaryColor,							TextColor)
VALUES	('LEADER_ANT_WUDI',				'Unique',			'COLOR_PLAYER_ANT_WUDI_PRIMARY',		'COLOR_PLAYER_ANT_WUDI_SECONDARY', 		'COLOR_PLAYER_WHITE_TEXT');	

INSERT INTO Colors 
		(Type, 										Red, 	Green, 	Blue, 	Alpha)
VALUES	('COLOR_PLAYER_ANT_WUDI_PRIMARY', 			0.047,	0.072,	0.168,	1),
		('COLOR_PLAYER_ANT_WUDI_SECONDARY', 		0.754,	0.570,	0.176,	1);
--==========================================================================================================================
-- LEADERS
--==========================================================================================================================
-- Types
-------------------------------------	
INSERT INTO Types	
		(Type,							Kind)
VALUES	('LEADER_ANT_WUDI',				'KIND_LEADER');	
-------------------------------------
-- Leaders
-------------------------------------	
INSERT INTO Leaders	
		(LeaderType,					Name,												InheritFrom,		SceneLayers)
VALUES	('LEADER_ANT_WUDI',				'LOC_LEADER_ANT_WUDI_NAME',							'LEADER_DEFAULT',	4);	
-------------------------------------
-- LeaderQuotes
-------------------------------------	
INSERT INTO LeaderQuotes	
		(LeaderType,					Quote)
VALUES	('LEADER_ANT_WUDI',				'LOC_PEDIA_LEADERS_PAGE_ANT_WUDI_QUOTE');	
-------------------------------------
-- LeaderTraits
-------------------------------------	
INSERT INTO LeaderTraits	
		(LeaderType,					TraitType)
VALUES	('LEADER_ANT_WUDI',				'TRAIT_LEADER_ANT_ZHANG_QIAN_PATRON'),
		('LEADER_ANT_WUDI',				'TRAIT_LEADER_UNIT_ANT_IMPERIAL_ENVOY');	
-- -------------------------------------
-- HistoricalAgendas
-- -------------------------------------	
INSERT INTO HistoricalAgendas	
		(LeaderType,					AgendaType)
VALUES	('LEADER_ANT_WUDI',				'AGENDA_ANT_FOUR_COMMANDARIES');	
-- -------------------------------------
-- FavoredReligions
-- -------------------------------------	
INSERT OR REPLACE INTO FavoredReligions
       (LeaderType,						ReligionType)
VALUES   ('LEADER_ANT_WUDI',		    'RELIGION_CONFUCIANISM');

CREATE TRIGGER AntWudi_HR
AFTER INSERT ON Religions WHEN 'RELIGION_ZOROASTRIANISM' = NEW.ReligionType
BEGIN
   INSERT OR REPLACE INTO FavoredReligions
		    (LeaderType,				ReligionType)
   VALUES   ('LEADER_ANT_WUDI',			'RELIGION_CONFUCIANISM');
END;
--==========================================================================================================================
-- TRAITS
--==========================================================================================================================
-- Types
-------------------------------------	
INSERT INTO Types	
		(Type,													Kind)
VALUES	('TRAIT_LEADER_ANT_ZHANG_QIAN_PATRON',					'KIND_TRAIT'),
		('TRAIT_LEADER_UNIT_ANT_IMPERIAL_ENVOY',				'KIND_TRAIT');	
-------------------------------------			
-- Traits			
-------------------------------------				
INSERT INTO Traits				
		(TraitType,												Name,												Description)
VALUES	('TRAIT_LEADER_ANT_ZHANG_QIAN_PATRON',					'LOC_TRAIT_LEADER_ANT_ZHANG_QIAN_PATRON_NAME',		'LOC_TRAIT_LEADER_ANT_ZHANG_QIAN_PATRON_DESCRIPTION'),
		('TRAIT_LEADER_UNIT_ANT_IMPERIAL_ENVOY',				'LOC_UNIT_ANT_IMPERIAL_ENVOY_NAME',					'LOC_UNIT_ANT_IMPERIAL_ENVOY_DESCRIPTION');
-------------------------------------
-- TraitModifiers
-------------------------------------
INSERT INTO TraitModifiers			
		(TraitType,														ModifierId)
VALUES	('TRAIT_LEADER_ANT_ZHANG_QIAN_PATRON', 							'TRAIT_ANT_ZQP_INFLUENCE_FROM_CAPITALS'),
		('TRAIT_LEADER_ANT_ZHANG_QIAN_PATRON', 							'TRAIT_ANT_ZQP_ENVOYS_FROM_CONQUEST');
--==========================================================================================================================
-- AGENDAS
--==========================================================================================================================
-- Agendas			
-------------------------------------				
INSERT INTO Agendas				
		(AgendaType,									Name,											Description)
VALUES	('AGENDA_ANT_FOUR_COMMANDARIES',				'LOC_AGENDA_ANT_FOUR_COMMANDARIES_NAME',		'LOC_AGENDA_ANT_FOUR_COMMANDARIES_DESCRIPTION');	
-------------------------------------
-- Types
-------------------------------------	
INSERT INTO Types	
		(Type,											Kind)
VALUES	('TRAIT_AGENDA_ANT_FOUR_COMMANDARIES',			'KIND_TRAIT');
-------------------------------------			
-- AgendaTraits			
-------------------------------------				
INSERT INTO AgendaTraits				
		(AgendaType,									TraitType)
VALUES	('AGENDA_ANT_FOUR_COMMANDARIES',				'TRAIT_AGENDA_ANT_FOUR_COMMANDARIES');
-------------------------------------			
-- ExclusiveAgendas	- AGENDA_STANDING_ARMY
-------------------------------------
INSERT INTO ExclusiveAgendas				
		(AgendaOne,										AgendaTwo)
VALUES	('AGENDA_ANT_FOUR_COMMANDARIES',				'AGENDA_CITY_STATE_PROTECTOR'),
		('AGENDA_ANT_FOUR_COMMANDARIES',				'AGENDA_CITY_STATE_ALLY'),
		('AGENDA_ANT_FOUR_COMMANDARIES',				'AGENDA_PARANOID'),
		('AGENDA_ANT_FOUR_COMMANDARIES',				'AGENDA_DARWINIST'),
		('AGENDA_ANT_FOUR_COMMANDARIES',				'AGENDA_STANDING_ARMY');					
-------------------------------------			
-- Traits			
-------------------------------------				
INSERT INTO Traits				
		(TraitType,										Name,											Description)
VALUES	('TRAIT_AGENDA_ANT_FOUR_COMMANDARIES',			'LOC_AGENDA_ANT_FOUR_COMMANDARIES_NAME',	'LOC_AGENDA_ANT_FOUR_COMMANDARIES_DESCRIPTION');
-------------------------------------
-- TraitModifiers
-------------------------------------
INSERT INTO TraitModifiers			
		(TraitType,														ModifierId)
VALUES	('TRAIT_AGENDA_ANT_FOUR_COMMANDARIES', 							'AGENDA_ANT_FOUR_COMMANDARIES_LARGE_ARMY'),
		('TRAIT_AGENDA_ANT_FOUR_COMMANDARIES', 							'AGENDA_ANT_FOUR_COMMANDARIES_SMALL_ARMY');
--==========================================================================================================================
-- MODIFIERS 
--==========================================================================================================================
-- Modifiers
-------------------------------------
INSERT INTO Modifiers			
		(ModifierId,													ModifierType,												SubjectRequirementSetId)
VALUES	('TRAIT_ANT_ZQP_INFLUENCE_FROM_CAPITALS',						'MODIFIER_PLAYER_CITIES_ATTACH_MODIFIER',					null),
		('TRAIT_ANT_ZQP_INFLUENCE_FROM_CAPITALS_MODIFIER',				'MODIFIER_PLAYER_ADJUST_INFLUENCE_POINTS_PER_TURN',			'ANT_CITY_IS_ORIGINAL_CAPITAL'),
		('TRAIT_ANT_ZQP_ENVOYS_FROM_CONQUEST',							'MODIFIER_PLAYER_CAPTURED_CITY_ATTACH_MODIFIER',			null),
		('TRAIT_ANT_ZQP_ENVOYS_FROM_CONQUEST_MODIFIER',					'MODIFIER_PLAYER_GRANT_INFLUENCE_TOKEN',					'ANT_CITY_IS_ORIGINAL_CAPITAL'),
		('AGENDA_ANT_FOUR_COMMANDARIES_LARGE_ARMY',						'MODIFIER_PLAYER_DIPLOMACY_SIMPLE_MODIFIER',				'ANT_FOUR_COMMANDARIES_LARGE_ARMY'),
		('AGENDA_ANT_FOUR_COMMANDARIES_SMALL_ARMY',						'MODIFIER_PLAYER_DIPLOMACY_SIMPLE_MODIFIER',				'ANT_FOUR_COMMANDARIES_SMALL_ARMY');
-------------------------------------
-- ModifierArguments
-------------------------------------
INSERT INTO ModifierArguments
		(ModifierId,													Name,							Value)
VALUES	('TRAIT_ANT_ZQP_INFLUENCE_FROM_CAPITALS',						'ModifierId',					'TRAIT_ANT_ZQP_INFLUENCE_FROM_CAPITALS_MODIFIER'),
		('TRAIT_ANT_ZQP_INFLUENCE_FROM_CAPITALS_MODIFIER',				'Amount',						1),
		('TRAIT_ANT_ZQP_ENVOYS_FROM_CONQUEST',							'ModifierId',					'TRAIT_ANT_ZQP_ENVOYS_FROM_CONQUEST_MODIFIER'),
		('TRAIT_ANT_ZQP_ENVOYS_FROM_CONQUEST_MODIFIER',					'Amount',						2),
		('AGENDA_ANT_FOUR_COMMANDARIES_LARGE_ARMY',						'InitialValue',					5),
		('AGENDA_ANT_FOUR_COMMANDARIES_LARGE_ARMY',						'StatementKey',					'LOC_DIPLO_KUDO_LEADER_ANT_WUDI_REASON_ANY'),
		('AGENDA_ANT_FOUR_COMMANDARIES_LARGE_ARMY',						'SimpleModifierDescription',	'LOC_DIPLO_MODIFIER_ANT_FOUR_COMMANDARIES_LARGE_ARMY'),

		('AGENDA_ANT_FOUR_COMMANDARIES_SMALL_ARMY',						'InitialValue',					-13),
		('AGENDA_ANT_FOUR_COMMANDARIES_SMALL_ARMY',						'StatementKey',					'LOC_DIPLO_WARNING_LEADER_ANT_WUDI_REASON_ANY'),
		('AGENDA_ANT_FOUR_COMMANDARIES_SMALL_ARMY',						'SimpleModifierDescription',	'LOC_DIPLO_MODIFIER_ANT_FOUR_COMMANDARIES_SMALL_ARMY');
-------------------------------------
-- Types
-------------------------------------
-------------------------------------
-- DynamicModifiers
-------------------------------------
-------------------------------------
-- ModifierStrings
-------------------------------------
INSERT INTO ModifierStrings
		(ModifierId,													Context,						Text)
VALUES	('AGENDA_ANT_FOUR_COMMANDARIES_LARGE_ARMY',						'Sample',						'LOC_TOOLTIP_SAMPLE_DIPLOMACY_ALL'),
		('AGENDA_ANT_FOUR_COMMANDARIES_SMALL_ARMY',						'Sample',						'LOC_TOOLTIP_SAMPLE_DIPLOMACY_ALL');
--==========================================================================================================================
-- REQUIREMENTS
--==========================================================================================================================
-- RequirementSets
-------------------------------------
INSERT INTO RequirementSets
		(RequirementSetId,												RequirementSetType)
VALUES	('ANT_CITY_IS_ORIGINAL_CAPITAL',								'REQUIREMENTSET_TEST_ALL'),
		('ANT_FOUR_COMMANDARIES_LARGE_ARMY',							'REQUIREMENTSET_TEST_ALL'),
		('ANT_FOUR_COMMANDARIES_SMALL_ARMY',							'REQUIREMENTSET_TEST_ALL');
-------------------------------------
-- RequirementSetRequirements
-------------------------------------
INSERT INTO RequirementSetRequirements
		(RequirementSetId,												RequirementId)
VALUES	('ANT_CITY_IS_ORIGINAL_CAPITAL',								'REQUIRES_ANT_CITY_IS_ORIGINAL_CAPITAL'),
		('ANT_FOUR_COMMANDARIES_LARGE_ARMY',							'REQUIRES_HAS_HIGH_STANDING_ARMY'),
		('ANT_FOUR_COMMANDARIES_LARGE_ARMY',							'REQUIRES_ANT_PLAYER_NOT_CONQUERING_ALLY_MINORS'),
		('ANT_FOUR_COMMANDARIES_LARGE_ARMY',							'REQUIRES_MAJOR_CIV_OPPONENT'),
		('ANT_FOUR_COMMANDARIES_LARGE_ARMY',							'REQUIRES_MET_10_TURNS_AGO'),

		('ANT_FOUR_COMMANDARIES_SMALL_ARMY',							'REQUIRES_HAS_LOW_STANDING_ARMY'),
		('ANT_FOUR_COMMANDARIES_SMALL_ARMY',							'REQUIRES_MAJOR_CIV_OPPONENT'),
		('ANT_FOUR_COMMANDARIES_SMALL_ARMY',							'REQUIRES_MET_10_TURNS_AGO');
-------------------------------------
-- Requirements
-------------------------------------
INSERT INTO Requirements
		(RequirementId, 												RequirementType,										Inverse)
VALUES	('REQUIRES_ANT_CITY_IS_ORIGINAL_CAPITAL',						'REQUIREMENT_CITY_IS_ORIGINAL_CAPITAL',					0),
		('REQUIRES_ANT_PLAYER_NOT_CONQUERING_ALLY_MINORS',				'REQUIREMENT_PLAYER_CONQUERING_ALLYING_MINORS',			1);
-------------------------------------
-- RequirementArguments
-------------------------------------
--==========================================================================================================================
-- AI
--==========================================================================================================================
-- AiListTypes
-------------------------------------	
INSERT INTO AiListTypes	
		(ListType)
VALUES	('Ant_Wudi_Wonders'),
		('Ant_Wudi_Civics'),
		('Ant_Wudi_Techs'),
		('Ant_Wudi_PreferWar');
-------------------------------------
-- AiLists 
-------------------------------------	
INSERT INTO AiLists	
		(ListType,								AgendaType,									System)
VALUES	('Ant_Wudi_Wonders',					'TRAIT_AGENDA_ANT_FOUR_COMMANDARIES',		'Buildings'),
		('Ant_Wudi_Civics',						'TRAIT_AGENDA_ANT_FOUR_COMMANDARIES',		'Civics'),
		('Ant_Wudi_Techs',						'TRAIT_AGENDA_ANT_FOUR_COMMANDARIES',		'Technologies'),
		('Ant_Wudi_PreferWar',					'TRAIT_AGENDA_ANT_FOUR_COMMANDARIES',		'Strategies'),
		('CityStateAllyInfluencePreference',	'TRAIT_AGENDA_ANT_FOUR_COMMANDARIES',		'PseudoYields'),
		('ExpansionistCitySettlement',			'TRAIT_AGENDA_ANT_FOUR_COMMANDARIES',		'SettlementPreferences');
-------------------------------------		
-- AiFavoredItems
-------------------------------------
INSERT INTO AiFavoredItems	
		(ListType,						Item)
VALUES	('Ant_Wudi_Wonders',			'BUILDING_ALHAMBRA'),
		('Ant_Wudi_Wonders',			'BUILDING_POTALA_PALACE'),
		('Ant_Wudi_Wonders',			'BUILDING_TERRACOTTA_ARMY'),
		('Ant_Wudi_Wonders',			'BUILDING_FORBIDDEN_CITY'),

		('Ant_Wudi_Civics',				'CIVIC_POLITICAL_PHILOSOPHY'),
		('Ant_Wudi_Civics',				'CIVIC_MILITARY_TRADITION'),
		('Ant_Wudi_Civics',				'CIVIC_MILITARY_TRAINING'),
		('Ant_Wudi_Civics',				'CIVIC_MERCENARIES'),
		('Ant_Wudi_Civics',				'CIVIC_DIPLOMATIC_SERVICE'),

		('Ant_Wudi_Techs',				'TECH_MASONRY'),
		('Ant_Wudi_Techs',				'TECH_CASTLES'),
		('Ant_Wudi_Techs',				'TECH_FLIGHT');
-------------------------------------		
-- AiFavoredItems: Favoured Victory Strategy
-------------------------------------
INSERT INTO AiFavoredItems	
		(ListType,						Item,									Value)
VALUES	('Ant_Wudi_PreferWar',			'VICTORY_STRATEGY_MILITARY_VICTORY',	-1);			
--==========================================================================================================================
-- CivilizationLeaders
--==========================================================================================================================
INSERT INTO CivilizationLeaders
		(LeaderType, 				CivilizationType,			CapitalName)
VALUES  ('LEADER_ANT_WUDI',			'CIVILIZATION_CHINA',		'LOC_CITY_NAME_XIAN');
--==========================================================================================================================
--==========================================================================================================================