/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.util;

import java.beans.ConstructorProperties;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ItemInfo {
    private Item item;
    private int meta;

    public ItemInfo(ItemStack stack) {
        this.item = stack == null ? null : stack.func_77973_b();
        this.meta = stack == null ? -1 : stack.func_77960_j();
    }

    public ItemInfo(Block block, int blockMeta) {
        this.item = Item.func_150898_a((Block)block);
        this.meta = block == Blocks.field_150350_a ? -1 : blockMeta;
    }

    public ItemInfo(String string) {
        String[] split = string.split(":");
        if (split.length == 1) {
            this.item = Item.func_111206_d((String)("minecraft:" + split[0]));
        } else if (split.length == 2) {
            try {
                this.meta = split[1].equals("*") ? -1 : Integer.parseInt(split[1]);
                this.item = Item.func_111206_d((String)("minecraft:" + split[0]));
            }
            catch (NumberFormatException e) {
                this.meta = -1;
                this.item = Item.func_111206_d((String)(split[0] + ":" + split[1]));
            }
        } else if (split.length == 3) {
            try {
                this.meta = split[2].equals("*") ? -1 : Integer.parseInt(split[2]);
                this.item = Item.func_111206_d((String)(split[0] + ":" + split[1]));
            }
            catch (NumberFormatException e) {
                this.meta = -1;
            }
        } else {
            this.meta = -1;
        }
    }

    public ItemInfo(IBlockState state) {
        this.item = state == null ? null : Item.func_150898_a((Block)state.func_177230_c());
        this.meta = state == null ? -1 : state.func_177230_c().func_176201_c(state);
    }

    public static ItemInfo getItemInfoFromStack(ItemStack stack) {
        return new ItemInfo(stack);
    }

    public static ItemInfo readFromNBT(NBTTagCompound tag) {
        Item item_ = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(tag.func_74779_i("item")));
        int meta_ = tag.func_74762_e("meta");
        return new ItemInfo(item_, meta_);
    }

    public String toString() {
        return Item.field_150901_e.func_177774_c((Object)this.item) + (this.meta == -1 ? "" : ":" + this.meta);
    }

    public ItemStack getItemStack() {
        return this.item == null ? null : new ItemStack(this.item, 1, this.meta == -1 ? 0 : this.meta);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("item", Item.field_150901_e.func_177774_c((Object)this.item) == null ? "" : ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.item)).toString());
        tag.func_74768_a("meta", this.meta);
        return tag;
    }

    public boolean isValid() {
        return this.meta <= Short.MAX_VALUE && this.item != null;
    }

    public int hashCode() {
        return this.item == null ? 41 : this.item.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof ItemInfo) {
            ItemInfo info = (ItemInfo)other;
            if (this.item == null || info.item == null) {
                return false;
            }
            if (this.meta == -1 || info.meta == -1) {
                return this.item.equals(info.item);
            }
            return this.meta == info.meta && this.item.equals(info.item);
        }
        return false;
    }

    @ConstructorProperties(value={"item", "meta"})
    public ItemInfo(Item item, int meta) {
        this.item = item;
        this.meta = meta;
    }

    public Item getItem() {
        return this.item;
    }

    public int getMeta() {
        return this.meta;
    }

    public void setMeta(int meta) {
        this.meta = meta;
    }
}

