/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.tiles;

import exnihilocreatio.rotationalPower.IRotationalPowerConsumer;
import exnihilocreatio.rotationalPower.IRotationalPowerMember;
import exnihilocreatio.tiles.BaseTileEntity;
import exnihilocreatio.tiles.ItemHandlerGrinder;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileGrinder
extends BaseTileEntity
implements ITickable,
IRotationalPowerConsumer {
    public EnumFacing facing = EnumFacing.NORTH;
    public int tickCounter = 0;
    public float rotationValue = 0.0f;
    public float perTickRotation = 0.0f;
    public float storedRotationalPower = 0.0f;
    public ItemHandlerGrinder itemHandlerGrinder = new ItemHandlerGrinder();

    public TileGrinder() {
        this.itemHandlerGrinder.setTe(this);
    }

    public void func_73660_a() {
        ++this.tickCounter;
        if (this.tickCounter % 10 == 0) {
            this.perTickRotation = this.calcEffectivePerTickRotation(this.facing);
        }
        if (this.field_145850_b.field_72995_K) {
            this.rotationValue += this.perTickRotation;
        }
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.itemHandlerGrinder);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound itemHandlerTag = this.itemHandlerGrinder.serializeNBT();
        tag.func_74782_a("itemHandlerIn", (NBTBase)itemHandlerTag);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        if (tag.func_74764_b("itemHandler")) {
            this.itemHandlerGrinder.deserializeNBT((NBTTagCompound)tag.func_74781_a("itemHandlerIn"));
        }
        super.func_145839_a(tag);
    }

    @Override
    public float getMachineRotationPerTick() {
        return this.perTickRotation;
    }

    @Override
    public void setEffectivePerTickRotation(float rotation) {
        this.perTickRotation = rotation;
    }

    private float calcEffectivePerTickRotation(EnumFacing direction) {
        if (this.facing == direction) {
            BlockPos posProvider = this.field_174879_c.func_177972_a(this.facing.func_176734_d());
            TileEntity te = this.field_145850_b.func_175625_s(posProvider);
            if (te != null && te instanceof IRotationalPowerMember) {
                return ((IRotationalPowerMember)te).getEffectivePerTickRotation(this.facing) + this.getOwnRotation();
            }
            return this.getOwnRotation();
        }
        return 0.0f;
    }
}

