/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.json.CustomItemInfoJson;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryList;
import exnihilocreatio.registries.types.FluidBlockTransformer;
import exnihilocreatio.util.ItemInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class FluidBlockTransformerRegistry
extends BaseRegistryList<FluidBlockTransformer> {
    public FluidBlockTransformerRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemInfo.class, (Object)new CustomItemInfoJson()).create(), ExNihiloRegistryManager.FLUID_BLOCK_DEFAULT_REGISTRY_PROVIDERS);
    }

    public void register(Fluid fluid, ItemInfo inputBlock, ItemInfo outputBlock) {
        ((List)this.registry).add(new FluidBlockTransformer(fluid.getName(), inputBlock, outputBlock));
    }

    public void register(String fluid, ItemInfo inputBlock, ItemInfo outputBlock) {
        ((List)this.registry).add(new FluidBlockTransformer(fluid, inputBlock, outputBlock));
    }

    public boolean canBlockBeTransformedWithThisFluid(Fluid fluid, ItemStack stack) {
        ItemInfo info = ItemInfo.getItemInfoFromStack(stack);
        for (FluidBlockTransformer transformer : (List)this.registry) {
            if (!fluid.getName().equals(transformer.getFluidName()) || !info.equals(transformer.getInput())) continue;
            return true;
        }
        return false;
    }

    public ItemInfo getBlockForTransformation(Fluid fluid, ItemStack stack) {
        ItemInfo info = ItemInfo.getItemInfoFromStack(stack);
        for (FluidBlockTransformer transformer : (List)this.registry) {
            if (!fluid.getName().equals(transformer.getFluidName()) || !info.equals(transformer.getInput())) continue;
            return transformer.getOutput();
        }
        return null;
    }

    @Override
    protected void registerEntriesFromJSON(FileReader fr) {
        List gsonInput = (List)this.gson.fromJson((Reader)fr, new TypeToken<List<FluidBlockTransformer>>(){}.getType());
        ((List)this.registry).addAll(gsonInput);
    }
}

