/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.blocks;

import exnihilocreatio.ModBlocks;
import exnihilocreatio.compatibility.ITOPInfoProvider;
import exnihilocreatio.config.ModConfig;
import exnihilocreatio.items.tools.ICrook;
import exnihilocreatio.tiles.TileInfestedLeaves;
import exnihilocreatio.util.Data;
import exnihilocreatio.util.IHasModel;
import exnihilocreatio.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockInfestedLeaves
extends BlockLeaves
implements ITileEntityProvider,
ITOPInfoProvider,
IHasModel {
    private int[] surroundings;

    public BlockInfestedLeaves() {
        this.func_149663_c("block_infested_leaves");
        this.setRegistryName("block_infested_leaves");
        Data.BLOCKS.add((Block)this);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
        this.field_185686_c = true;
    }

    public static void infestLeafBlock(World world, BlockPos pos) {
        IBlockState block = world.func_180495_p(pos);
        if (block.func_177230_c().isLeaves(block, (IBlockAccess)world, pos) && !block.func_177230_c().equals(ModBlocks.infestedLeaves)) {
            world.func_175656_a(pos, ModBlocks.infestedLeaves.func_176223_P());
            TileInfestedLeaves tile = (TileInfestedLeaves)world.func_175625_s(pos);
            if (tile != null) {
                tile.setLeafBlock(block);
            }
        }
    }

    @Nonnull
    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a});
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(meta == 0 || meta == 1)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(meta == 0 || meta == 2));
    }

    public int func_176201_c(IBlockState state) {
        boolean checkDecay = (Boolean)state.func_177229_b((IProperty)field_176236_b);
        boolean decayable = (Boolean)state.func_177229_b((IProperty)field_176237_a);
        if (checkDecay && decayable) {
            return 0;
        }
        if (checkDecay) {
            return 1;
        }
        if (decayable) {
            return 2;
        }
        return 3;
    }

    @Nonnull
    public List<ItemStack> getDrops(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public void func_180650_b(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            int l2;
            int posX = pos.func_177958_n();
            int posY = pos.func_177956_o();
            int posZ = pos.func_177952_p();
            if (this.surroundings == null) {
                this.surroundings = new int[32768];
            }
            if (worldIn.func_175707_a(new BlockPos(posX - 5, posY - 5, posZ - 5), new BlockPos(posX + 5, posY + 5, posZ + 5))) {
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int i2 = -4; i2 <= 4; ++i2) {
                    for (int j2 = -4; j2 <= 4; ++j2) {
                        for (int k2 = -4; k2 <= 4; ++k2) {
                            IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(posX + i2, posY + j2, posZ + k2));
                            Block block = iblockstate.func_177230_c();
                            if (!block.canSustainLeaves(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(posX + i2, posY + j2, posZ + k2))) {
                                if (block.isLeaves(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(posX + i2, posY + j2, posZ + k2))) {
                                    this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = -2;
                                    continue;
                                }
                                this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = -1;
                                continue;
                            }
                            this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = 0;
                        }
                    }
                }
                for (int i3 = 1; i3 <= 4; ++i3) {
                    for (int j3 = -4; j3 <= 4; ++j3) {
                        for (int k3 = -4; k3 <= 4; ++k3) {
                            for (int l3 = -4; l3 <= 4; ++l3) {
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16] != i3 - 1) continue;
                                if (this.surroundings[(j3 + 16 - 1) * 1024 + (k3 + 16) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16 - 1) * 1024 + (k3 + 16) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16 + 1) * 1024 + (k3 + 16) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16 + 1) * 1024 + (k3 + 16) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16 - 1) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16 - 1) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16 + 1) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16 + 1) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + (l3 + 16 - 1)] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + (l3 + 16 - 1)] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 + 1] != -2) continue;
                                this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 + 1] = i3;
                            }
                        }
                    }
                }
            }
            if ((l2 = this.surroundings[16912]) < 0) {
                this.func_176235_d(worldIn, pos);
            }
        }
    }

    public void func_176235_d(World worldIn, @Nonnull BlockPos pos) {
        TileEntity te;
        if (worldIn.field_73012_v.nextInt(3) == 0 && (te = worldIn.func_175625_s(pos)) != null && te instanceof TileInfestedLeaves) {
            TileInfestedLeaves infestedLeaves = (TileInfestedLeaves)te;
            if ((double)worldIn.field_73012_v.nextFloat() < (double)infestedLeaves.getProgress() * ModConfig.crooking.stringChance / 4.0) {
                BlockInfestedLeaves.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(Items.field_151007_F));
            }
        }
        super.func_176235_d(worldIn, pos);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile;
        if (!world.field_72995_K && !player.func_184812_l_() && (tile = world.func_175625_s(pos)) != null) {
            if (tile instanceof TileInfestedLeaves) {
                TileInfestedLeaves leaves = (TileInfestedLeaves)tile;
                if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ICrook) {
                    if ((double)world.field_73012_v.nextFloat() < (double)leaves.getProgress() * ModConfig.crooking.stringChance) {
                        Util.dropItemInWorld(leaves, player, new ItemStack(Items.field_151007_F, 1, 0), 0.02f);
                    }
                    if ((double)world.field_73012_v.nextFloat() < (double)leaves.getProgress() * ModConfig.crooking.stringChance / 4.0) {
                        Util.dropItemInWorld(leaves, player, new ItemStack(Items.field_151007_F, 1, 0), 0.02f);
                    }
                }
            }
            world.func_175713_t(pos);
        }
    }

    public List<ItemStack> onSheared(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this));
        return ret;
    }

    @Nonnull
    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.OAK;
    }

    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileInfestedLeaves();
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileInfestedLeaves tile = (TileInfestedLeaves)world.func_175625_s(data.getPos());
        if (tile != null) {
            if (tile.getProgress() >= 1.0f) {
                probeInfo.text("Progress: Done");
            } else {
                probeInfo.progress((int)(tile.getProgress() * 100.0f), 100);
            }
        }
    }
}

