/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.barrel.modes.transform;

import exnihilocreatio.barrel.IBarrelMode;
import exnihilocreatio.networking.PacketHandler;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.types.FluidTransformer;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.tiles.TileBarrel;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class BarrelModeFluidTransform
implements IBarrelMode {
    private FluidStack inputStack;
    private FluidStack outputStack;
    private float progress = 0.0f;
    private FluidTransformer transformer;

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        if (this.inputStack != null) {
            NBTTagCompound inputTag = this.inputStack.writeToNBT(new NBTTagCompound());
            tag.func_74782_a("inputTag", (NBTBase)inputTag);
        }
        if (this.outputStack != null) {
            NBTTagCompound outputTag = this.outputStack.writeToNBT(new NBTTagCompound());
            tag.func_74782_a("outputTag", (NBTBase)outputTag);
        }
        tag.func_74776_a("progress", this.progress);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("inputTag")) {
            NBTTagCompound inputTag = (NBTTagCompound)tag.func_74781_a("inputTag");
            this.inputStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)inputTag);
        }
        if (tag.func_74764_b("outputTag")) {
            NBTTagCompound outputTag = (NBTTagCompound)tag.func_74781_a("outputTag");
            this.outputStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)outputTag);
        }
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74760_g("progress");
        }
    }

    @Override
    public boolean isTriggerItemStack(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isTriggerFluidStack(FluidStack stack) {
        return false;
    }

    @Override
    public String getName() {
        return "fluidTransform";
    }

    @Override
    public boolean onBlockActivated(World world, TileBarrel barrel, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForRender(TileBarrel barrel) {
        if ((double)this.progress < 0.5) {
            return Util.getTextureFromFluidStack(this.inputStack);
        }
        return Util.getTextureFromFluidStack(this.outputStack);
    }

    @Override
    public Color getColorForRender() {
        return Color.average(Util.blackColor, Util.whiteColor, 2.0f * Math.abs(this.progress - 0.5f));
    }

    @Override
    public float getFilledLevelForRender(TileBarrel barrel) {
        return 0.9375f;
    }

    @Override
    public void update(TileBarrel barrel) {
        if (this.transformer == null) {
            this.transformer = ExNihiloRegistryManager.FLUID_TRANSFORM_REGISTRY.getFluidTransformer(this.inputStack.getFluid().getName(), this.outputStack.getFluid().getName());
        }
        if (this.transformer == null) {
            return;
        }
        if (this.progress < 1.0f) {
            int numberOfBlocks = Util.getNumSurroundingBlocksAtLeastOneOf(this.transformer.getTransformingBlocks(), barrel.func_174877_v().func_177982_a(0, -1, 0), barrel.func_145831_w()) + Util.getNumSurroundingBlocksAtLeastOneOf(this.transformer.getTransformingBlocks(), barrel.func_174877_v(), barrel.func_145831_w());
            if (numberOfBlocks > 0) {
                this.progress = (float)((double)this.progress + (double)numberOfBlocks * 1.0 / (double)this.transformer.getDuration());
                if (barrel.func_145831_w().field_73012_v.nextDouble() < 0.005) {
                    boolean spawned = false;
                    ArrayList<BlockInfo> blockList = new ArrayList<BlockInfo>(Arrays.asList(this.transformer.getTransformingBlocks()));
                    for (int xShift = -1; xShift <= 1; ++xShift) {
                        for (int zShift = -1; zShift <= 1; ++zShift) {
                            BlockInfo[] toSpawn;
                            if (spawned) continue;
                            BlockPos testPos = barrel.func_174877_v().func_177982_a(xShift, -1, zShift);
                            if (!blockList.contains(new BlockInfo(barrel.func_145831_w().func_180495_p(testPos))) || !barrel.func_145831_w().func_175623_d(testPos.func_177982_a(0, 1, 0)) || (toSpawn = this.transformer.getBlocksToSpawn()) == null || toSpawn.length <= 0) continue;
                            barrel.func_145831_w().func_175656_a(testPos.func_177982_a(0, 1, 0), toSpawn[barrel.func_145831_w().field_73012_v.nextInt(toSpawn.length)].getBlockState());
                            spawned = true;
                        }
                    }
                }
            }
            PacketHandler.sendNBTUpdate(barrel);
        }
        if (this.progress >= 1.0f) {
            barrel.setMode("fluid");
            FluidTank tank = barrel.getMode().getFluidHandler(barrel);
            Fluid fluid = FluidRegistry.getFluid((String)this.transformer.getOutputFluid());
            tank.setFluid(new FluidStack(fluid, 1000));
            PacketHandler.sendNBTUpdate(barrel);
        }
    }

    @Override
    public boolean addItem(ItemStack stack, TileBarrel barrel) {
        return false;
    }

    @Override
    public ItemStackHandler getHandler(TileBarrel barrel) {
        return null;
    }

    @Override
    public FluidTank getFluidHandler(TileBarrel barrel) {
        return null;
    }

    @Override
    public boolean canFillWithFluid(TileBarrel barrel) {
        return false;
    }

    @Override
    public List<String> getWailaTooltip(TileBarrel barrel, List<String> currenttip) {
        currenttip.add("Transforming: " + Math.round(this.progress * 100.0f) + "%");
        return currenttip;
    }

    public void setInputStack(FluidStack inputStack) {
        this.inputStack = inputStack;
    }

    public void setOutputStack(FluidStack outputStack) {
        this.outputStack = outputStack;
    }

    public FluidStack getInputStack() {
        return this.inputStack;
    }

    public FluidStack getOutputStack() {
        return this.outputStack;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setTransformer(FluidTransformer transformer) {
        this.transformer = transformer;
    }

    public FluidTransformer getTransformer() {
        return this.transformer;
    }
}

