/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.util;

import exnihilocreatio.texturing.Color;
import exnihilocreatio.util.BlockInfo;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Util {
    public static Color whiteColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public static Color blackColor = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public static Color greenColor = new Color(0.0f, 1.0f, 0.0f, 1.0f);

    public static void dropItemInWorld(TileEntity source, EntityPlayer player, ItemStack stack, double speedFactor) {
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        int hitOrientation = player == null ? 0 : MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        double stackCoordX = 0.0;
        double stackCoordY = 0.0;
        double stackCoordZ = 0.0;
        switch (hitOrientation) {
            case 0: {
                stackCoordX = (double)source.func_174877_v().func_177958_n() + 0.5;
                stackCoordY = (double)source.func_174877_v().func_177956_o() + 0.5 + 1.0;
                stackCoordZ = (double)source.func_174877_v().func_177952_p() - 0.25;
                break;
            }
            case 1: {
                stackCoordX = (double)source.func_174877_v().func_177958_n() + 1.25;
                stackCoordY = (double)source.func_174877_v().func_177956_o() + 0.5 + 1.0;
                stackCoordZ = (double)source.func_174877_v().func_177952_p() + 0.5;
                break;
            }
            case 2: {
                stackCoordX = (double)source.func_174877_v().func_177958_n() + 0.5;
                stackCoordY = (double)source.func_174877_v().func_177956_o() + 0.5 + 1.0;
                stackCoordZ = (double)source.func_174877_v().func_177952_p() + 1.25;
                break;
            }
            case 3: {
                stackCoordX = (double)source.func_174877_v().func_177958_n() - 0.25;
                stackCoordY = (double)source.func_174877_v().func_177956_o() + 0.5 + 1.0;
                stackCoordZ = (double)source.func_174877_v().func_177952_p() + 0.5;
                break;
            }
        }
        EntityItem droppedEntity = new EntityItem(source.func_145831_w(), stackCoordX, stackCoordY, stackCoordZ, stack);
        if (player != null) {
            Vec3d motion = new Vec3d(player.field_70165_t - stackCoordX, player.field_70163_u - stackCoordY, player.field_70161_v - stackCoordZ);
            motion.func_72432_b();
            droppedEntity.field_70159_w = motion.field_72450_a;
            droppedEntity.field_70181_x = motion.field_72448_b;
            droppedEntity.field_70179_y = motion.field_72449_c;
            double offset = 0.25;
            droppedEntity.func_70091_d(MoverType.SELF, motion.field_72450_a * offset, motion.field_72448_b * offset, motion.field_72449_c * offset);
        }
        droppedEntity.field_70159_w *= speedFactor;
        droppedEntity.field_70181_x *= speedFactor;
        droppedEntity.field_70179_y *= speedFactor;
        source.func_145831_w().func_72838_d((Entity)droppedEntity);
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getTextureFromBlockState(IBlockState state) {
        if (state == null) {
            return Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getTextureFromFluidStack(FluidStack stack) {
        Fluid fluid;
        if (stack != null && stack.getFluid() != null && (fluid = stack.getFluid()).getStill(stack) != null) {
            return Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getStill().toString());
        }
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    public static boolean isSurroundingBlocksAtLeastOneOf(BlockInfo[] blocks, BlockPos pos, World world, int radius) {
        ArrayList<BlockInfo> blockList = new ArrayList<BlockInfo>(Arrays.asList(blocks));
        for (int xShift = -1 * radius; xShift <= radius; ++xShift) {
            for (int zShift = -1 * radius; zShift <= radius; ++zShift) {
                BlockPos checkPos = pos.func_177982_a(xShift, 0, zShift);
                BlockInfo checkBlock = new BlockInfo(world.func_180495_p(checkPos));
                if (!blockList.contains(checkBlock)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getNumSurroundingBlocksAtLeastOneOf(BlockInfo[] blocks, BlockPos pos, World world) {
        int ret = 0;
        ArrayList<BlockInfo> blockList = new ArrayList<BlockInfo>(Arrays.asList(blocks));
        for (int xShift = -2; xShift <= 2; ++xShift) {
            for (int zShift = -2; zShift <= 2; ++zShift) {
                BlockPos checkPos = pos.func_177982_a(xShift, 0, zShift);
                BlockInfo checkBlock = new BlockInfo(world.func_180495_p(checkPos));
                if (!blockList.contains(checkBlock)) continue;
                ++ret;
            }
        }
        return ret;
    }

    public static int getLightValue(FluidStack fluid) {
        if (fluid != null && fluid.getFluid() != null) {
            return fluid.getFluid().getLuminosity(fluid);
        }
        return 0;
    }

    public static float weightedAverage(float a, float b, float percent) {
        return a * percent + b * (1.0f - percent);
    }

    public static ItemStack getBucketStack(Fluid fluid) {
        return UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)fluid);
    }
}

