/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.json.CustomBlockInfoJson;
import exnihilocreatio.json.CustomItemInfoJson;
import exnihilocreatio.registries.manager.IDefaultRecipeProvider;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import exnihilocreatio.registries.types.Meltable;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.ItemInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class CrucibleRegistry
extends BaseRegistryMap<ItemInfo, Meltable> {
    public CrucibleRegistry(List<? extends IDefaultRecipeProvider> defaultRecipeProviders) {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemInfo.class, (Object)new CustomItemInfoJson()).registerTypeAdapter(BlockInfo.class, (Object)new CustomBlockInfoJson()).create(), defaultRecipeProviders);
    }

    public void register(ItemInfo item, Fluid fluid, int amount) {
        this.register(item, new Meltable(fluid.getName(), amount));
    }

    public void register(ItemStack stack, Fluid fluid, int amount) {
        this.register(new ItemInfo(stack), new Meltable(fluid.getName(), amount));
    }

    @Override
    public void register(ItemInfo item, Meltable meltable) {
        ((Map)this.registry).put(item, meltable);
    }

    public boolean canBeMelted(ItemStack stack) {
        return this.canBeMelted(new ItemInfo(stack));
    }

    public boolean canBeMelted(ItemInfo info) {
        return ((Map)this.registry).containsKey(info) && FluidRegistry.isFluidRegistered((String)((Meltable)((Map)this.registry).get(info)).getFluid());
    }

    public Meltable getMeltable(ItemStack stack) {
        ItemInfo info = new ItemInfo(stack);
        return (Meltable)((Map)this.registry).get(info);
    }

    public Meltable getMeltable(ItemInfo info) {
        return (Meltable)((Map)this.registry).get(info);
    }

    @Override
    protected void registerEntriesFromJSON(FileReader fr) {
        Map gsonInput = (Map)this.gson.fromJson((Reader)fr, new TypeToken<Map<String, Meltable>>(){}.getType());
        for (Map.Entry entry : gsonInput.entrySet()) {
            this.register(new ItemInfo((String)entry.getKey()), (Meltable)entry.getValue());
        }
    }
}

