/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.jei.sieve;

import com.google.common.collect.HashMultiset;
import exnihilocreatio.compatibility.jei.sieve.SieveRecipe;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.types.Siftable;
import exnihilocreatio.util.ItemInfo;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SieveRecipeCategory
implements IRecipeCategory<SieveRecipe> {
    public static final String UID = "exnihilocreatio:sieve";
    private static final ResourceLocation texture = new ResourceLocation("exnihilocreatio", "textures/gui/jei_sieve.png");
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;
    private boolean hasHighlight;
    private int highlightX;
    private int highlightY;

    public SieveRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(texture, 0, 0, 166, 128);
        this.slotHighlight = helper.createDrawable(texture, 166, 0, 18, 18);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return "Sieve";
    }

    public String getModName() {
        return "exnihilocreatio";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        if (this.hasHighlight) {
            this.slotHighlight.draw(minecraft, this.highlightX, this.highlightY);
        }
    }

    private void setRecipe(@Nonnull IRecipeLayout recipeLayout, final @Nonnull SieveRecipe recipeWrapper) {
        recipeLayout.getItemStacks().init(0, true, 61, 9);
        recipeLayout.getItemStacks().set(0, (ItemStack)recipeWrapper.getInputs().get(0));
        recipeLayout.getItemStacks().init(1, true, 87, 9);
        recipeLayout.getItemStacks().set(1, (ItemStack)recipeWrapper.getInputs().get(1));
        IFocus focus = recipeLayout.getFocus();
        if (focus != null) {
            this.hasHighlight = focus.getMode() == IFocus.Mode.OUTPUT;
            int slotIndex = 2;
            for (int i = 0; i < recipeWrapper.getOutputs().size(); ++i) {
                int slotX = 2 + i % 9 * 18;
                int slotY = 36 + i / 9 * 18;
                ItemStack outputStack = (ItemStack)recipeWrapper.getOutputs().get(i);
                recipeLayout.getItemStacks().init(slotIndex + i, false, slotX, slotY);
                recipeLayout.getItemStacks().set(slotIndex + i, outputStack);
                ItemStack focusStack = (ItemStack)focus.getValue();
                if (focus.getMode() != IFocus.Mode.OUTPUT || focusStack.func_190926_b() || focusStack.func_77973_b() != outputStack.func_77973_b() || focusStack.func_77952_i() != outputStack.func_77952_i()) continue;
                this.highlightX = slotX;
                this.highlightY = slotY;
            }
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new ITooltipCallback<ItemStack>(){

            @SideOnly(value=Side.CLIENT)
            public void onTooltip(int slotIndex, boolean input, @Nonnull ItemStack ingredient, @Nonnull List<String> tooltip) {
                if (!input) {
                    ItemStack mesh = (ItemStack)recipeWrapper.getInputs().get(0);
                    HashMultiset condensedTooltips = HashMultiset.create();
                    for (Siftable siftable : ExNihiloRegistryManager.SIEVE_REGISTRY.getDrops((ItemStack)recipeWrapper.getInputs().get(1))) {
                        ItemInfo info;
                        if (siftable.getMeshLevel() != mesh.func_77952_i() || (info = siftable.getDrop()).getItem() != ingredient.func_77973_b() || info.getMeta() != ingredient.func_77952_i()) continue;
                        int iChance = (int)(siftable.getChance() * 100.0f);
                        String s = iChance > 0 ? String.format("%3d%%", (int)(siftable.getChance() * 100.0f)) : String.format("%1.1f%%", Float.valueOf(siftable.getChance() * 100.0f));
                        condensedTooltips.add((Object)s);
                    }
                    tooltip.add(I18n.func_135052_a((String)"jei.sieve.dropChance", (Object[])new Object[0]));
                    for (String line : condensedTooltips.elementSet()) {
                        tooltip.add(" * " + condensedTooltips.count((Object)line) + "x " + line);
                    }
                }
            }
        });
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull SieveRecipe recipeWrapper, @Nonnull IIngredients ingredients) {
        this.setRecipe(recipeLayout, recipeWrapper);
    }

    public IDrawable getIcon() {
        return null;
    }
}

