/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.jei.barrel.fluidblocktransform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import exnihilocreatio.registries.types.FluidBlockTransformer;
import exnihilocreatio.util.Util;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidBlockTransformRecipe
implements IRecipeWrapper {
    private FluidStack inputFluid;
    private ItemStack inputBucket;
    private ItemStack inputStack;
    private ItemStack outputStack;

    public FluidBlockTransformRecipe(FluidBlockTransformer recipe) {
        this.inputFluid = new FluidStack(FluidRegistry.getFluid((String)recipe.getFluidName()), 1000);
        this.inputBucket = Util.getBucketStack(this.inputFluid.getFluid());
        this.inputStack = recipe.getInput().getItemStack();
        this.outputStack = recipe.getOutput().getItemStack();
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.getInputs());
        ingredients.setInputs(FluidStack.class, this.getFluidInputs());
        ingredients.setOutput(ItemStack.class, (Object)this.outputStack);
    }

    public List<ItemStack> getInputs() {
        return ImmutableList.of((Object)this.inputBucket, (Object)this.inputStack);
    }

    public List<ItemStack> getOutputs() {
        return ImmutableList.of((Object)this.outputStack);
    }

    public List<FluidStack> getFluidInputs() {
        return ImmutableList.of((Object)this.inputFluid);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Lists.newArrayList();
    }

    public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

