/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import exnihilocreatio.ExNihiloCreatio;
import exnihilocreatio.ModBlocks;
import exnihilocreatio.ModItems;
import exnihilocreatio.blocks.BlockSieve;
import exnihilocreatio.compatibility.jei.barrel.compost.CompostRecipe;
import exnihilocreatio.compatibility.jei.barrel.compost.CompostRecipeCategory;
import exnihilocreatio.compatibility.jei.barrel.fluidblocktransform.FluidBlockTransformRecipe;
import exnihilocreatio.compatibility.jei.barrel.fluidblocktransform.FluidBlockTransformRecipeCategory;
import exnihilocreatio.compatibility.jei.barrel.fluidontop.FluidOnTopRecipe;
import exnihilocreatio.compatibility.jei.barrel.fluidontop.FluidOnTopRecipeCategory;
import exnihilocreatio.compatibility.jei.barrel.fluidtransform.FluidTransformRecipe;
import exnihilocreatio.compatibility.jei.barrel.fluidtransform.FluidTransformRecipeCategory;
import exnihilocreatio.compatibility.jei.hammer.HammerRecipe;
import exnihilocreatio.compatibility.jei.hammer.HammerRecipeCategory;
import exnihilocreatio.compatibility.jei.sieve.SieveRecipe;
import exnihilocreatio.compatibility.jei.sieve.SieveRecipeCategory;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.types.Compostable;
import exnihilocreatio.registries.types.FluidBlockTransformer;
import exnihilocreatio.registries.types.FluidFluidBlock;
import exnihilocreatio.registries.types.FluidTransformer;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.ItemInfo;
import exnihilocreatio.util.LogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@JEIPlugin
public class CompatJEI
implements IModPlugin {
    public void registerItemSubtypes(@Nonnull ISubtypeRegistry subtypeRegistry) {
    }

    public void registerIngredients(@Nonnull IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new SieveRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new HammerRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidOnTopRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidTransformRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidBlockTransformRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CompostRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    @SideOnly(value=Side.CLIENT)
    public void register(@Nonnull IModRegistry registry) {
        Object recipe;
        LogUtil.info("ModConfig Loaded: " + ExNihiloCreatio.configsLoaded);
        if (ExNihiloCreatio.configsLoaded) {
            ExNihiloCreatio.loadConfigs();
        }
        ArrayList sieveRecipes = Lists.newArrayList();
        for (Object info : ((Map)ExNihiloRegistryManager.SIEVE_REGISTRY.getRegistry()).keySet()) {
            for (BlockSieve.MeshType type : BlockSieve.MeshType.values()) {
                if (type.getID() == 0 || ((BlockInfo)info).getBlockState() == null || ((SieveRecipe)(recipe = new SieveRecipe(((BlockInfo)info).getBlockState(), type))).getInputs().size() != 2 || ((SieveRecipe)recipe).getOutputs().size() <= 0) continue;
                sieveRecipes.add(recipe);
            }
        }
        registry.addRecipes((Collection)sieveRecipes, "exnihilocreatio:sieve");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.sieve), new String[]{"exnihilocreatio:sieve"});
        ArrayList hammerRecipes = Lists.newArrayList();
        for (Object info : ((Map)ExNihiloRegistryManager.HAMMER_REGISTRY.getRegistry()).keySet()) {
            IBlockState block;
            HammerRecipe recipe2;
            if (((BlockInfo)info).getBlock() == null || (recipe2 = new HammerRecipe(block = ((BlockInfo)info).getBlockState())).getInputs().size() != 1 || recipe2.getOutputs().size() <= 0) continue;
            hammerRecipes.add(recipe2);
        }
        registry.addRecipes((Collection)hammerRecipes, "exnihilocreatio:hammer");
        registry.addRecipeCatalyst((Object)new ItemStack((Item)ModItems.hammerWood), new String[]{"exnihilocreatio:hammer"});
        registry.addRecipeCatalyst((Object)new ItemStack((Item)ModItems.hammerGold), new String[]{"exnihilocreatio:hammer"});
        registry.addRecipeCatalyst((Object)new ItemStack((Item)ModItems.hammerStone), new String[]{"exnihilocreatio:hammer"});
        registry.addRecipeCatalyst((Object)new ItemStack((Item)ModItems.hammerIron), new String[]{"exnihilocreatio:hammer"});
        registry.addRecipeCatalyst((Object)new ItemStack((Item)ModItems.hammerDiamond), new String[]{"exnihilocreatio:hammer"});
        ArrayList fluidTransformRecipes = Lists.newArrayList();
        for (FluidTransformer transformer : ExNihiloRegistryManager.FLUID_TRANSFORM_REGISTRY.getFluidTransformers()) {
            FluidTransformRecipe recipe3;
            if (!FluidRegistry.isFluidRegistered((String)transformer.getInputFluid()) || !FluidRegistry.isFluidRegistered((String)transformer.getOutputFluid()) || (recipe3 = new FluidTransformRecipe(transformer)).getInputs().size() < 2 || recipe3.getOutputs().size() != 1) continue;
            fluidTransformRecipes.add(new FluidTransformRecipe(transformer));
        }
        registry.addRecipes((Collection)fluidTransformRecipes, "exnihilocreatio:fluid_transform");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelWood), new String[]{"exnihilocreatio:fluid_transform"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelStone), new String[]{"exnihilocreatio:fluid_transform"});
        ArrayList fluidOnTopRecipes = Lists.newArrayList();
        for (FluidFluidBlock transformer : (List)ExNihiloRegistryManager.FLUID_ON_TOP_REGISTRY.getRegistry()) {
            FluidOnTopRecipe recipe4;
            if (!FluidRegistry.isFluidRegistered((String)transformer.getFluidInBarrel()) || !FluidRegistry.isFluidRegistered((String)transformer.getFluidOnTop()) || transformer.getResult().getItem() == null || (recipe4 = new FluidOnTopRecipe(transformer)).getInputs().size() != 2 || recipe4.getOutputs().size() != 1) continue;
            fluidOnTopRecipes.add(new FluidOnTopRecipe(transformer));
        }
        registry.addRecipes((Collection)fluidOnTopRecipes, "exnihilocreatio:fluid_on_top");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelWood), new String[]{"exnihilocreatio:fluid_on_top"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelStone), new String[]{"exnihilocreatio:fluid_on_top"});
        ArrayList fluidBlockTransformRecipes = Lists.newArrayList();
        for (FluidBlockTransformer transformer : (List)ExNihiloRegistryManager.FLUID_BLOCK_TRANSFORMER_REGISTRY.getRegistry()) {
            if (!FluidRegistry.isFluidRegistered((String)transformer.getFluidName()) || transformer.getInput().getItem() == null || transformer.getOutput().getItem() == null || ((FluidBlockTransformRecipe)(recipe = new FluidBlockTransformRecipe(transformer))).getInputs().size() != 2 || ((FluidBlockTransformRecipe)recipe).getOutputs().size() != 1) continue;
            fluidBlockTransformRecipes.add(new FluidBlockTransformRecipe(transformer));
        }
        registry.addRecipes((Collection)fluidBlockTransformRecipes, "exnihilocreatio:fluid_block_transform");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelWood), new String[]{"exnihilocreatio:fluid_block_transform"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelStone), new String[]{"exnihilocreatio:fluid_block_transform"});
        ArrayList compostRecipes = Lists.newArrayList();
        Map compostRegistry = (Map)ExNihiloRegistryManager.COMPOST_REGISTRY.getRegistry();
        HashMap<ItemInfo, List> compostEntries = new HashMap<ItemInfo, List>();
        for (Map.Entry compostEntry : compostRegistry.entrySet()) {
            ItemInfo compostBlock = ((Compostable)compostEntry.getValue()).getCompostBlock();
            List compostables = compostEntries.computeIfAbsent(compostBlock, k -> Lists.newArrayList());
            Item compostItem = ((ItemInfo)compostEntry.getKey()).getItem();
            int compostCount = (int)Math.ceil(1.0f / ((Compostable)compostEntry.getValue()).getValue());
            int compostMeta = ((ItemInfo)compostEntry.getKey()).getMeta();
            if (compostMeta == -1) {
                NonNullList subItems = NonNullList.func_191196_a();
                for (ItemStack subItem : subItems) {
                    subItem.func_190920_e(compostCount);
                    compostables.add(subItem);
                }
                continue;
            }
            compostables.add(new ItemStack(compostItem, compostCount, compostMeta));
        }
        for (Map.Entry compostEntry : compostEntries.entrySet()) {
            ArrayList splitList = Lists.newArrayList((Iterable)ImmutableList.of((Object)Lists.newArrayList()));
            for (ItemStack stack : (List)compostEntry.getValue()) {
                if (((List)splitList.get(0)).size() >= 45) {
                    splitList.add(0, Lists.newArrayList());
                }
                ((List)splitList.get(0)).add(stack);
            }
            for (List compostInputs : Lists.reverse((List)splitList)) {
                compostRecipes.add(new CompostRecipe(((ItemInfo)compostEntry.getKey()).getItemStack(), compostInputs));
            }
        }
        registry.addRecipes((Collection)compostRecipes, "exnihilocreatio:compost");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelWood), new String[]{"exnihilocreatio:compost"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelStone), new String[]{"exnihilocreatio:compost"});
        LogUtil.info("JEI: Hammer Recipes Loaded:             " + hammerRecipes.size());
        LogUtil.info("JEI: Sieve Recipes Loaded:              " + sieveRecipes.size());
        LogUtil.info("JEI: Fluid Transform Recipes Loaded:    " + fluidTransformRecipes.size());
        LogUtil.info("JEI: Fluid On Top Recipes Loaded:       " + fluidOnTopRecipes.size());
        LogUtil.info("JEI: Compost Recipes Loaded:            " + compostRecipes.size());
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
    }
}

