/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.barrel.modes.fluid;

import exnihilocreatio.barrel.BarrelFluidHandler;
import exnihilocreatio.barrel.modes.mobspawn.BarrelModeMobSpawn;
import exnihilocreatio.items.ItemDoll;
import exnihilocreatio.networking.MessageBarrelModeUpdate;
import exnihilocreatio.networking.PacketHandler;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.tiles.TileBarrel;
import exnihilocreatio.util.ItemInfo;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class BarrelItemHandlerFluid
extends ItemStackHandler {
    private TileBarrel barrel;

    public BarrelItemHandlerFluid(TileBarrel barrel) {
        super(1);
        this.barrel = barrel;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemInfo info;
        BarrelFluidHandler tank = this.barrel.getTank();
        if (tank.getFluid() == null) {
            return stack;
        }
        if (ExNihiloRegistryManager.FLUID_BLOCK_TRANSFORMER_REGISTRY.canBlockBeTransformedWithThisFluid(tank.getFluid().getFluid(), stack) && tank.getFluidAmount() == tank.getCapacity() && (info = ExNihiloRegistryManager.FLUID_BLOCK_TRANSFORMER_REGISTRY.getBlockForTransformation(tank.getFluid().getFluid(), stack)) != null) {
            if (!simulate) {
                tank.drain(tank.getCapacity(), true);
                this.barrel.setMode("block");
                PacketHandler.sendToAllAround(new MessageBarrelModeUpdate("block", this.barrel.func_174877_v()), this.barrel);
                this.barrel.getMode().addItem(info.getItemStack(), this.barrel);
            }
            if (stack.func_77973_b().hasContainerItem(stack)) {
                // empty if block
            }
            ItemStack ret = stack.func_77946_l();
            ret.func_190918_g(1);
            return ret.func_190926_b() ? ItemStack.field_190927_a : ret;
        }
        if (!stack.func_190926_b() && tank.getFluidAmount() == tank.getCapacity() && stack.func_77973_b() instanceof ItemDoll && ((ItemDoll)stack.func_77973_b()).getSpawnFluid(stack) == tank.getFluid().getFluid()) {
            if (!simulate) {
                this.barrel.getTank().drain(1000, true);
                this.barrel.setMode("mobspawn");
                ((BarrelModeMobSpawn)this.barrel.getMode()).setDollStack(stack);
                PacketHandler.sendNBTUpdate(this.barrel);
            }
            ItemStack ret = stack.func_77946_l();
            ret.func_190918_g(1);
            return ret;
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public void setBarrel(TileBarrel barrel) {
        this.barrel = barrel;
    }
}

