/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.tiles;

import exnihilocreatio.registries.registries.CrucibleRegistry;
import exnihilocreatio.registries.types.Meltable;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.texturing.SpriteColor;
import exnihilocreatio.tiles.BaseTileEntity;
import exnihilocreatio.tiles.CrucibleItemHandler;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.ItemInfo;
import exnihilocreatio.util.Util;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TileCrucibleBase
extends BaseTileEntity
implements ITickable {
    public static final int MAX_ITEMS = 4;
    protected FluidTank tank = new FluidTank(4000);
    protected int solidAmount;
    protected ItemInfo currentItem;
    protected int ticksSinceLast = 0;
    protected CrucibleItemHandler itemHandler;
    protected CrucibleRegistry crucibleRegistry;

    public TileCrucibleBase(CrucibleRegistry crucibleRegistry) {
        this.tank.setCanFill(false);
        this.itemHandler = new CrucibleItemHandler(this, crucibleRegistry);
        this.crucibleRegistry = crucibleRegistry;
    }

    public abstract void func_73660_a();

    public abstract int getHeatRate();

    @SideOnly(value=Side.CLIENT)
    public SpriteColor[] getSpriteAndColor() {
        int noItems;
        SpriteColor[] spriteColors = new SpriteColor[2];
        int n = noItems = this.itemHandler.getStackInSlot(0).func_190926_b() ? 0 : this.itemHandler.getStackInSlot(0).func_190916_E();
        if (noItems == 0 && this.currentItem == null && this.tank.getFluidAmount() == 0) {
            return spriteColors;
        }
        FluidStack fluid = this.tank.getFluid();
        if (fluid != null && fluid.amount > 0) {
            Color color = new Color(fluid.getFluid().getColor(), false);
            spriteColors[1] = new SpriteColor(Util.getTextureFromFluidStack(fluid), color);
        }
        IBlockState block = null;
        Color color = Util.whiteColor;
        if (this.currentItem != null) {
            Meltable meltable = this.crucibleRegistry.getMeltable(this.currentItem);
            BlockInfo override = meltable.getTextureOverride();
            if (override == null) {
                if (Block.func_149634_a((Item)this.currentItem.getItem()) != Blocks.field_150350_a) {
                    block = Block.func_149634_a((Item)this.currentItem.getItem()).func_176203_a(this.currentItem.getMeta());
                }
            } else {
                block = override.getBlockState();
            }
            if (block != null) {
                color = new Color(Minecraft.func_71410_x().func_184125_al().func_186724_a(block, (IBlockAccess)this.field_145850_b, this.field_174879_c, 0), true);
            }
        }
        spriteColors[0] = new SpriteColor(Util.getTextureFromBlockState(block), color);
        return spriteColors;
    }

    @SideOnly(value=Side.CLIENT)
    public float getFilledAmount() {
        Meltable meltable;
        int itemCount;
        int n = itemCount = this.itemHandler.getStackInSlot(0).func_190926_b() ? 0 : this.itemHandler.getStackInSlot(0).func_190916_E();
        if (itemCount == 0 && this.currentItem == null && this.tank.getFluidAmount() == 0) {
            return 0.0f;
        }
        float fluidProportion = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
        if (itemCount == 0 && this.currentItem == null) {
            return fluidProportion;
        }
        float solidProportion = (float)itemCount / 4.0f;
        if (this.currentItem != null && (meltable = this.crucibleRegistry.getMeltable(this.currentItem)) != null) {
            solidProportion = (float)((double)solidProportion + (double)this.solidAmount / (double)(4 * meltable.getAmount()));
        }
        return solidProportion > fluidProportion ? solidProportion : fluidProportion;
    }

    @SideOnly(value=Side.CLIENT)
    public float getFluidProportion() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    @SideOnly(value=Side.CLIENT)
    public float getSolidProportion() {
        Meltable meltable;
        int itemCount = this.itemHandler.getStackInSlot(0).func_190926_b() ? 0 : this.itemHandler.getStackInSlot(0).func_190916_E();
        float solidProportion = (float)itemCount / 4.0f;
        if (this.currentItem != null && (meltable = this.crucibleRegistry.getMeltable(this.currentItem)) != null) {
            solidProportion = (float)((double)solidProportion + (double)this.solidAmount / (double)(4 * meltable.getAmount()));
        }
        return solidProportion;
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ, IFluidHandler handler) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return false;
        }
        Boolean result = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)handler);
        if (result.booleanValue()) {
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            this.markDirtyClient();
            return true;
        }
        ItemStack addStack = stack.func_77946_l();
        addStack.func_190920_e(1);
        ItemStack insertStack = this.itemHandler.insertItem(0, addStack, true);
        if (!ItemStack.func_77989_b((ItemStack)addStack, (ItemStack)insertStack)) {
            this.itemHandler.insertItem(0, addStack, false);
            if (this.currentItem == null) {
                this.currentItem = new ItemInfo(stack);
            }
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            this.markDirtyClient();
            return true;
        }
        return true;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.itemHandler);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        if (this.currentItem != null) {
            NBTTagCompound currentItemTag = this.currentItem.writeToNBT(new NBTTagCompound());
            tag.func_74782_a("currentItem", (NBTBase)currentItemTag);
        }
        tag.func_74768_a("solidAmount", this.solidAmount);
        NBTTagCompound itemHandlerTag = this.itemHandler.serializeNBT();
        tag.func_74782_a("itemHandler", (NBTBase)itemHandlerTag);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        tag.func_74782_a("tank", (NBTBase)tankTag);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.currentItem = tag.func_74764_b("currentItem") ? ItemInfo.readFromNBT(tag.func_74775_l("currentItem")) : null;
        this.solidAmount = tag.func_74762_e("solidAmount");
        if (tag.func_74764_b("itemHandler")) {
            this.itemHandler.deserializeNBT((NBTTagCompound)tag.func_74781_a("itemHandler"));
        }
        if (tag.func_74764_b("tank")) {
            this.tank.readFromNBT((NBTTagCompound)tag.func_74781_a("tank"));
        }
        super.func_145839_a(tag);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public int getSolidAmount() {
        return this.solidAmount;
    }

    public ItemInfo getCurrentItem() {
        return this.currentItem;
    }

    public CrucibleItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public CrucibleRegistry getCrucibleRegistry() {
        return this.crucibleRegistry;
    }
}

