/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries.prefab;

import com.google.gson.Gson;
import exnihilocreatio.config.ModConfig;
import exnihilocreatio.registries.manager.IDefaultRecipeProvider;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.IOUtils;

public abstract class BaseRegistry<RegType> {
    protected boolean hasAlreadyBeenLoaded = false;
    protected RegType registry;
    protected List<? extends IDefaultRecipeProvider> defaultRecipeProviders;
    protected Gson gson;

    public BaseRegistry(Gson gson, RegType registry, List<? extends IDefaultRecipeProvider> defaultRecipeProviders) {
        this.gson = gson;
        this.registry = registry;
        this.defaultRecipeProviders = defaultRecipeProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveJson(File file) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            this.gson.toJson(this.registry, (Appendable)fw);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fw);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)fw);
        }
        IOUtils.closeQuietly((Writer)fw);
    }

    public void loadJson(File file) {
        if (this.hasAlreadyBeenLoaded) {
            this.clearRegistry();
        }
        if (file.exists() && ModConfig.misc.enableJSONLoading) {
            try {
                FileReader fr = new FileReader(file);
                this.registerEntriesFromJSON(fr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.registerDefaults();
            if (ModConfig.misc.enableJSONLoading) {
                this.saveJson(file);
            }
        }
        this.hasAlreadyBeenLoaded = true;
    }

    protected abstract void registerEntriesFromJSON(FileReader var1);

    public void registerDefaults() {
        if (this.defaultRecipeProviders != null) {
            for (IDefaultRecipeProvider iDefaultRecipeProvider : this.defaultRecipeProviders) {
                if (iDefaultRecipeProvider == null) continue;
                iDefaultRecipeProvider.registerRecipeDefaults(this);
            }
        }
    }

    protected abstract void clearRegistry();

    public RegType getRegistry() {
        return this.registry;
    }
}

