/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.json.CustomBlockInfoJson;
import exnihilocreatio.json.CustomItemInfoJson;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import exnihilocreatio.registries.types.Siftable;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.ItemInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;

public class SieveRegistry
extends BaseRegistryMap<BlockInfo, ArrayList<Siftable>> {
    public SieveRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(BlockInfo.class, (Object)new CustomBlockInfoJson()).registerTypeAdapter(ItemInfo.class, (Object)new CustomItemInfoJson()).create(), ExNihiloRegistryManager.SIEVE_DEFAULT_REGISTRY_PROVIDERS);
    }

    public void register(BlockInfo block, ItemInfo drop, float chance, int meshLevel) {
        this.register(block, new Siftable(drop, chance, meshLevel));
    }

    public void register(IBlockState state, ItemInfo drop, float chance, int meshLevel) {
        this.register(new BlockInfo(state), new Siftable(drop, chance, meshLevel));
    }

    public void register(IBlockState state, ItemStack drop, float chance, int meshLevel) {
        this.register(new BlockInfo(state), new Siftable(new ItemInfo(drop), chance, meshLevel));
    }

    @Override
    public void register(BlockInfo block, Siftable drop) {
        if (block == null) {
            return;
        }
        ArrayList<Siftable> drops = (ArrayList<Siftable>)((Map)this.registry).get(block);
        if (drops == null) {
            drops = new ArrayList<Siftable>();
        }
        drops.add(drop);
        ((Map)this.registry).put(block, drops);
    }

    public List<Siftable> getDrops(BlockInfo block) {
        if (!((Map)this.registry).containsKey(block)) {
            return null;
        }
        return (List)((Map)this.registry).get(block);
    }

    public List<Siftable> getDrops(ItemStack block) {
        return this.getDrops(new BlockInfo(block));
    }

    public List<ItemStack> getRewardDrops(Random random, IBlockState block, int meshLevel, int fortuneLevel) {
        if (block == null) {
            return null;
        }
        List<Siftable> siftables = this.getDrops(new BlockInfo(block));
        if (siftables == null) {
            return null;
        }
        ArrayList drops = Lists.newArrayList();
        for (Siftable siftable : siftables) {
            if (meshLevel != siftable.getMeshLevel()) continue;
            int triesWithFortune = Math.max(random.nextInt(fortuneLevel + 2), 1);
            for (int i = 0; i < triesWithFortune; ++i) {
                if (!(random.nextDouble() < (double)siftable.getChance())) continue;
                drops.add(siftable.getDrop().getItemStack());
            }
        }
        return drops;
    }

    public boolean canBeSifted(ItemStack stack) {
        return stack != null && ((Map)this.registry).containsKey(new BlockInfo(stack));
    }

    @Override
    public void registerEntriesFromJSON(FileReader fr) {
        HashMap gsonInput = (HashMap)this.gson.fromJson((Reader)fr, new TypeToken<HashMap<String, ArrayList<Siftable>>>(){}.getType());
        for (Map.Entry input : gsonInput.entrySet()) {
            BlockInfo block = new BlockInfo((String)input.getKey());
            if (block.getBlock() == null) continue;
            for (Siftable siftable : (ArrayList)input.getValue()) {
                if (!siftable.getDrop().isValid()) continue;
                this.register(block, siftable);
            }
        }
    }
}

