/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.json.CustomItemStackJson;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import exnihilocreatio.registries.types.HammerReward;
import exnihilocreatio.util.BlockInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;

public class HammerRegistry
extends BaseRegistryMap<BlockInfo, List<HammerReward>> {
    public HammerRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemStack.class, (Object)new CustomItemStackJson()).create(), ExNihiloRegistryManager.HAMMER_DEFAULT_REGISTRY_PROVIDERS);
    }

    @Override
    public void registerEntriesFromJSON(FileReader fr) {
        HashMap gsonInput = (HashMap)this.gson.fromJson((Reader)fr, new TypeToken<HashMap<String, ArrayList<HammerReward>>>(){}.getType());
        for (Map.Entry s : gsonInput.entrySet()) {
            BlockInfo stack = new BlockInfo((String)s.getKey());
            ((Map)this.registry).put(stack, s.getValue());
        }
    }

    public void register(IBlockState state, ItemStack reward, int miningLevel, float chance, float fortuneChance) {
        this.register(state, reward, miningLevel, chance, fortuneChance, false);
    }

    public void register(IBlockState state, ItemStack reward, int miningLevel, float chance, float fortuneChance, boolean wildcard) {
        ArrayList<HammerReward> rewards;
        BlockInfo key = new BlockInfo(state);
        if (wildcard) {
            key.setMeta(-1);
        }
        if ((rewards = (ArrayList<HammerReward>)((Map)this.registry).get(key)) == null) {
            rewards = new ArrayList<HammerReward>();
        }
        rewards.add(new HammerReward(reward, miningLevel, chance, fortuneChance));
        ((Map)this.registry).put(key, rewards);
    }

    public List<ItemStack> getRewardDrops(Random random, IBlockState block, int miningLevel, int fortuneLevel) {
        ArrayList<ItemStack> rewards = new ArrayList<ItemStack>();
        for (HammerReward reward : this.getRewards(block)) {
            if (miningLevel < reward.getMiningLevel() || !(random.nextFloat() <= reward.getChance() + reward.getFortuneChance() * (float)fortuneLevel)) continue;
            rewards.add(reward.getStack().func_77946_l());
        }
        return rewards;
    }

    public List<HammerReward> getRewards(IBlockState block) {
        return ((Map)this.registry).getOrDefault(new BlockInfo(block), Collections.EMPTY_LIST);
    }

    public boolean registered(Block block) {
        return ((Map)this.registry).containsKey(new BlockInfo(block.func_176223_P()));
    }

    @Deprecated
    public List<HammerReward> getRewards(IBlockState state, int miningLevel) {
        List mapList = ((Map)this.registry).getOrDefault(new BlockInfo(state), Collections.EMPTY_LIST);
        ArrayList<HammerReward> ret = new ArrayList<HammerReward>();
        for (HammerReward reward : mapList) {
            if (reward.getMiningLevel() > miningLevel) continue;
            ret.add(reward);
        }
        return ret;
    }
}

