/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.json.CustomBlockInfoJson;
import exnihilocreatio.json.CustomItemStackJson;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import exnihilocreatio.registries.types.CrookReward;
import exnihilocreatio.util.BlockInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;

public class CrookRegistry
extends BaseRegistryMap<BlockInfo, List<CrookReward>> {
    public CrookRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemStack.class, (Object)new CustomItemStackJson()).registerTypeAdapter(BlockInfo.class, (Object)new CustomBlockInfoJson()).create(), ExNihiloRegistryManager.CROOK_DEFAULT_REGISTRY_PROVIDERS);
    }

    @Override
    public void register(BlockInfo key, List<CrookReward> value) {
        ArrayList<CrookReward> list = (ArrayList<CrookReward>)((Map)this.registry).get(key);
        if (list == null) {
            list = new ArrayList<CrookReward>();
        }
        list.addAll(value);
    }

    public void register(BlockInfo info, ItemStack reward, float chance, float fortuneChance) {
        ArrayList<CrookReward> list = (ArrayList<CrookReward>)((Map)this.registry).get(info);
        if (list == null) {
            list = new ArrayList<CrookReward>();
        }
        list.add(new CrookReward(reward, chance, fortuneChance));
        ((Map)this.registry).put(info, list);
    }

    public boolean isRegistered(Block block) {
        return ((Map)this.registry).containsKey(new BlockInfo(block.func_176223_P()));
    }

    public List<CrookReward> getRewards(IBlockState state) {
        BlockInfo info = new BlockInfo(state);
        if (!((Map)this.registry).containsKey(info)) {
            return null;
        }
        return (List)((Map)this.registry).get(info);
    }

    @Override
    public void registerEntriesFromJSON(FileReader fr) {
        HashMap gsonInput = (HashMap)this.gson.fromJson((Reader)fr, new TypeToken<HashMap<String, ArrayList<CrookReward>>>(){}.getType());
        for (Map.Entry s : gsonInput.entrySet()) {
            BlockInfo blockInfo = new BlockInfo((String)s.getKey());
            ((Map)this.registry).put(blockInfo, s.getValue());
        }
    }
}

