/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.json.CustomItemInfoJson;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import exnihilocreatio.registries.types.Compostable;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.util.ItemInfo;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CompostRegistry
extends BaseRegistryMap<ItemInfo, Compostable> {
    public CompostRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemInfo.class, (Object)new CustomItemInfoJson()).create(), ExNihiloRegistryManager.COMPOST_DEFAULT_REGISTRY_PROVIDERS);
    }

    public void register(Item item, int meta, float value, IBlockState state, Color color) {
        this.register(new ItemInfo(item, meta), new Compostable(value, color, new ItemInfo(state)));
    }

    public void register(Block block, int meta, float value, IBlockState state, Color color) {
        this.register(Item.func_150898_a((Block)block), meta, value, state, color);
    }

    public Compostable getItem(Item item, int meta) {
        return this.getItem(new ItemInfo(item, meta));
    }

    public Compostable getItem(ItemStack stack) {
        return this.getItem(new ItemInfo(stack));
    }

    public Compostable getItem(ItemInfo info) {
        return (Compostable)((Map)this.registry).get(info);
    }

    public boolean containsItem(Item item, int meta) {
        return this.containsItem(new ItemInfo(item, meta));
    }

    public boolean containsItem(ItemStack stack) {
        return this.containsItem(new ItemInfo(stack));
    }

    public boolean containsItem(ItemInfo info) {
        return ((Map)this.registry).containsKey(info);
    }

    @SideOnly(value=Side.CLIENT)
    public void recommendAllFood(File file) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            return;
        }
        IBlockState dirt = Blocks.field_150346_d.func_176223_P();
        Color brown = new Color("7F3F0F");
        HashMap recommended = Maps.newHashMap();
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof ItemFood)) continue;
            ItemFood food = (ItemFood)item;
            NonNullList stacks = NonNullList.func_191196_a();
            food.func_150895_a(CreativeTabs.field_78039_h, stacks);
            for (ItemStack foodStack : stacks) {
                ItemInfo foodItemInfo = new ItemInfo(foodStack);
                if (this.containsItem(foodItemInfo)) continue;
                int hungerRestored = food.func_150905_g(foodStack);
                recommended.put(foodItemInfo.toString(), new Compostable((float)hungerRestored * 0.025f, brown, new ItemInfo(dirt)));
            }
        }
        String json = this.gson.toJson((Object)recommended, new TypeToken<Map<String, Compostable>>(){}.getType());
        try {
            Files.write(file.toPath(), json.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void registerEntriesFromJSON(FileReader fr) {
        Map gsonInput = (Map)this.gson.fromJson((Reader)fr, new TypeToken<Map<String, Compostable>>(){}.getType());
        for (Map.Entry entry : gsonInput.entrySet()) {
            ((Map)this.registry).put(new ItemInfo((String)entry.getKey()), entry.getValue());
        }
    }
}

