/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.jei.hammer;

import com.google.common.collect.Lists;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.types.HammerReward;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class HammerRecipe
implements IRecipeWrapper {
    private List<ItemStack> inputs;
    private List<ItemStack> outputs;

    public HammerRecipe(IBlockState block) {
        if (block != null && block.func_177230_c() != Blocks.field_150350_a) {
            List<HammerReward> rewards = ExNihiloRegistryManager.HAMMER_REGISTRY.getRewards(block);
            ArrayList allOutputs = Lists.newArrayList((Iterable)Lists.transform(rewards, reward -> reward == null || reward.getStack().func_190926_b() ? ItemStack.field_190927_a : reward.getStack().func_77946_l()));
            allOutputs.removeIf(stack -> stack == null || stack.func_77973_b() == Items.field_190931_a);
            this.inputs = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(block.func_177230_c(), 1, block.func_177230_c().func_176201_c(block))});
            this.outputs = Lists.newArrayList();
            for (ItemStack stack2 : allOutputs) {
                boolean alreadyExists = false;
                for (ItemStack outputStack : this.outputs) {
                    if (!stack2.func_77973_b().equals(outputStack.func_77973_b()) || stack2.func_77960_j() != outputStack.func_77960_j()) continue;
                    outputStack.func_190917_f(stack2.func_190916_E());
                    alreadyExists = true;
                    break;
                }
                if (alreadyExists) continue;
                this.outputs.add(stack2);
            }
        }
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.inputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }

    public List<ItemStack> getInputs() {
        return this.inputs;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Lists.newArrayList();
    }

    public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

