/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.jei.barrel.compost;

import exnihilocreatio.compatibility.jei.barrel.compost.CompostRecipe;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.types.Compostable;
import exnihilocreatio.util.ItemInfo;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CompostRecipeCategory
implements IRecipeCategory<CompostRecipe> {
    public static final String UID = "exnihilocreatio:compost";
    private static final ResourceLocation texture = new ResourceLocation("exnihilocreatio", "textures/gui/jei_compost.png");
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;
    private boolean hasHighlight;
    private int highlightX;
    private int highlightY;

    public CompostRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(texture, 0, 0, 166, 128);
        this.slotHighlight = helper.createDrawable(texture, 166, 0, 18, 18);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return "Compost";
    }

    public String getModName() {
        return "exnihilocreatio";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        if (this.hasHighlight) {
            this.slotHighlight.draw(minecraft, this.highlightX, this.highlightY);
        }
    }

    private void setRecipe(IRecipeLayout layout, CompostRecipe recipe) {
        layout.getItemStacks().init(0, false, 74, 9);
        layout.getItemStacks().set(0, recipe.getOutputs().get(0));
        IFocus focus = layout.getFocus();
        if (focus != null) {
            boolean mightHaveHighlight = focus.getMode() == IFocus.Mode.INPUT;
            this.hasHighlight = false;
            ItemStack focusStack = (ItemStack)focus.getValue();
            int slotIndex = 1;
            for (int i = 0; i < recipe.getInputs().size(); ++i) {
                int slotX = 2 + i % 9 * 18;
                int slotY = 36 + i / 9 * 18;
                ItemStack inputStack = recipe.getInputs().get(i);
                layout.getItemStacks().init(slotIndex + i, true, slotX, slotY);
                layout.getItemStacks().set(slotIndex + i, inputStack);
                if (!mightHaveHighlight || !ItemStack.func_179545_c((ItemStack)focusStack, (ItemStack)inputStack)) continue;
                this.highlightX = slotX;
                this.highlightY = slotY;
                this.hasHighlight = true;
                mightHaveHighlight = false;
            }
        }
        layout.getItemStacks().addTooltipCallback((ITooltipCallback)new CompostTooltipCallback());
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull CompostRecipe recipeWrapper, @Nonnull IIngredients ingredients) {
        this.setRecipe(recipeLayout, recipeWrapper);
    }

    public IDrawable getIcon() {
        return null;
    }

    private static class CompostTooltipCallback
    implements ITooltipCallback<ItemStack> {
        private CompostTooltipCallback() {
        }

        public void onTooltip(int slotIndex, boolean input, @Nonnull ItemStack ingredient, @Nonnull List<String> tooltip) {
            if (input) {
                Compostable entry = ExNihiloRegistryManager.COMPOST_REGISTRY.getItem(new ItemInfo(ingredient));
                tooltip.add(String.format("Value: %.1f%%", Float.valueOf(100.0f * entry.getValue())));
            }
        }
    }
}

