/*
 * Decompiled with CFR 0.152.
 */
package idv.jlchntoz.tweaker;

import idv.jlchntoz.tweaker.ForgeTweaker;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.IClassTransformer;

public class ClassTransformer
implements IClassTransformer {
    private ZipFile zipFile = null;

    public ClassTransformer() {
        ForgeTweaker.logger.info("ClassTransformer Begin");
        try {
            URLClassLoader ucl = (URLClassLoader)ClassTransformer.class.getClassLoader();
            URL[] urls = ucl.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                ZipFile tempZipFile = ClassTransformer.getZipFile(url);
                if (tempZipFile == null) continue;
                this.zipFile = tempZipFile;
                ForgeTweaker.logger.info("URL: " + url);
                ForgeTweaker.logger.info("File: " + this.zipFile);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.zipFile == null) {
            ForgeTweaker.logger.info("Can not find needed JAR in the classpath.");
        }
    }

    private static ZipFile getZipFile(URL url) {
        try {
            URI uri = url.toURI();
            File file = new File(uri);
            ZipFile zipFile0 = new ZipFile(file);
            if (zipFile0.getEntry("idv/jlchntoz/tweaker/ClassTransformer.class") != null) {
                ForgeTweaker.logger.info("JAR Found!");
                return zipFile0;
            }
            zipFile0.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        byte[] diBytes = this.getClass(name);
        if (diBytes != null) {
            ForgeTweaker.logger.info("Class '" + name + "' transformed.");
            return diBytes;
        }
        return bytes;
    }

    private byte[] getClass(String name) {
        if (this.zipFile == null) {
            return null;
        }
        String fullName = name + ".class";
        ZipEntry ze = this.zipFile.getEntry(fullName);
        if (ze == null) {
            return null;
        }
        try {
            InputStream in = this.zipFile.getInputStream(ze);
            byte[] bytes = ClassTransformer.readAll(in);
            if ((long)bytes.length == ze.getSize()) {
                return bytes;
            }
            ForgeTweaker.logger.info("Failed: " + fullName + " " + bytes.length + " / " + ze.getSize());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] readAll(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) >= 0) {
            baos.write(buffer, 0, len);
        }
        is.close();
        byte[] bytes = baos.toByteArray();
        return bytes;
    }
}

