/*
 * Decompiled with CFR 0.152.
 */
package idv.jlchntoz;

import idv.jlchntoz.CustomSkinLoaderGUI;
import idv.jlchntoz.MainLogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomSkinLoader {
    public static final String VERSION = "12.6";
    public static final String DefaultSkinURL = "http://skins.minecraft.net/MinecraftSkins/*.png";
    public static final String DefaultCloakURL = "http://skins.minecraft.net/MinecraftCloaks/*.png";
    private static final Pattern newResPattern = Pattern.compile("^http://textures.minecraft.net/texture/(.*?)?(Skin|Cloak)=(.*?)$");
    private static final Pattern newURLPattern = Pattern.compile("^http://skins.minecraft.net/Minecraft(Skin|Cloak)s/(.*?).png$");
    private static final Pattern oldURLPattern = Pattern.compile("^http://s3.amazonaws.com/Minecraft(Skin|Cloak)s/(.*?).png$");
    private static final Pattern optifineCapeURLPattern = Pattern.compile("^http://s.optifine.net/capes/(.*?).png$");
    public static final File DATA_DIR = new File(atv.w().x, "CustomSkinLoader");
    public static final File CACHE_DIR = new File(DATA_DIR, "caches");
    public static final File LOG_FILE = new File(DATA_DIR, "CustomSkinLoader.log");
    public static final MainLogger logger = CustomSkinLoader.getLogger(LOG_FILE);
    private static String[] cloakURLs = null;
    private static String[] skinURLs = null;
    private HttpURLConnection C = null;

    public InputStream getPlayerSkinStream(String path) {
        if (!DATA_DIR.exists()) {
            DATA_DIR.mkdir();
        }
        if (!CACHE_DIR.exists()) {
            CACHE_DIR.mkdir();
        }
        logger.info("Get a request: " + path);
        Matcher m = newURLPattern.matcher(path);
        if (!m.matches()) {
            m = oldURLPattern.matcher(path);
        }
        if (m.matches()) {
            if (m.group(1).contains("Skin")) {
                return this.getPlayerSkinStream(false, m.group(2));
            }
            if (m.group(1).contains("Cloak")) {
                return this.getPlayerSkinStream(true, m.group(2));
            }
        } else {
            m = newResPattern.matcher(path);
            if (m.matches()) {
                if (m.group(2).contains("Skin")) {
                    return this.getPlayerSkinStream(false, m.group(3));
                }
                if (m.group(2).contains("Cloak")) {
                    return this.getPlayerSkinStream(true, m.group(3));
                }
            } else {
                m = optifineCapeURLPattern.matcher(path);
                if (m.matches()) {
                    return null;
                }
            }
        }
        return this.getStream(path, false);
    }

    public InputStream getPlayerSkinStream(Boolean isCloak, String playerName) {
        if (skinURLs == null || cloakURLs == null || skinURLs.length <= 0 || cloakURLs.length <= 0) {
            CustomSkinLoader.refreshSkinURL();
        }
        InputStream S = null;
        for (String l : isCloak != false ? cloakURLs : skinURLs) {
            if (l == null || l.equalsIgnoreCase("")) continue;
            String loc = CustomSkinLoader.str_replace("*", playerName, l);
            logger.log(Level.INFO, "Try to load " + (isCloak != false ? "cloak" : "skin") + " in " + loc);
            S = this.getStream(loc, true);
            if (S == null) {
                logger.log(Level.INFO, "No " + (isCloak != false ? "cloak" : "skin") + " found in " + loc);
                continue;
            }
            logger.info("Succeessfully load " + (isCloak != false ? "cloak" : "skin") + " in " + loc);
            return S;
        }
        logger.log(Level.INFO, "Try to load skin in default URL instead.");
        return this.getStream(CustomSkinLoader.str_replace("*", playerName, isCloak != false ? DefaultCloakURL : DefaultSkinURL), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getStream(String URL2, Boolean CheckPNG) {
        boolean success = false;
        File cacheFile = new File(CACHE_DIR, this.MD5(URL2));
        boolean alreadyCached = false;
        if (cacheFile.exists() && cacheFile.length() > 1L) {
            alreadyCached = true;
            logger.info("Cache File Found");
        }
        try {
            URL U = new URL(URL2);
            this.C = (HttpURLConnection)U.openConnection();
            this.C.setReadTimeout(15000);
            this.C.setDoInput(true);
            this.C.setDoOutput(false);
            this.C.connect();
            logger.info("RC: " + this.C.getResponseCode());
            int respcode = this.C.getResponseCode() / 100;
            if (respcode != 4 && respcode != 5) {
                if (alreadyCached && this.C.getLastModified() == cacheFile.lastModified()) {
                    logger.info("Not Modified!");
                    InputStream inputStream = this.getStreamFromCache(cacheFile);
                    return inputStream;
                }
                if (this.C.getContentLength() <= 0) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                BufferedInputStream IS = new BufferedInputStream(this.C.getInputStream());
                if (!CheckPNG.booleanValue()) {
                    success = true;
                    this.saveToCache(IS, cacheFile);
                    BufferedInputStream bufferedInputStream = IS;
                    return bufferedInputStream;
                }
                ((InputStream)IS).mark(this.C.getContentLength() + 10);
                byte[] ib = new byte[4];
                ((InputStream)IS).read(ib);
                if (ib[1] == 80 && ib[2] == 78 && ib[3] == 71) {
                    ((InputStream)IS).reset();
                    success = true;
                    this.saveToCache(IS, cacheFile);
                    BufferedInputStream bufferedInputStream = IS;
                    return bufferedInputStream;
                }
            }
        }
        catch (Exception ex) {
            success = false;
            logger.log(Level.WARNING, ex.getMessage());
            if (alreadyCached) {
                InputStream inputStream = this.getStreamFromCache(cacheFile);
                return inputStream;
            }
        }
        finally {
            if (!success) {
                this.disconnect();
            }
        }
        return null;
    }

    private InputStream getStreamFromCache(File cacheFile) {
        try {
            logger.info("Try load local cache in " + cacheFile.getAbsolutePath());
            FileInputStream in = new FileInputStream(cacheFile);
            BufferedInputStream bis = new BufferedInputStream(in);
            if (bis.available() <= 0) {
                logger.info("Cannot load local cache in " + cacheFile.getAbsolutePath());
                return null;
            }
            logger.info("Successfully load cache in " + cacheFile.getAbsolutePath());
            return bis;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToCache(InputStream is, File to) {
        logger.info("Try save local cache to " + to.getAbsolutePath());
        FileOutputStream fs = null;
        int times = 0;
        try {
            if (to.exists()) {
                to.delete();
            }
            fs = new FileOutputStream(to);
            int byteRead = 0;
            byte[] buffer = new byte[1024];
            while ((byteRead = is.read(buffer)) != -1) {
                fs.write(buffer, 0, byteRead);
                if ((times += byteRead) < this.C.getContentLength()) continue;
            }
            if (to.length() > 1L) {
                logger.info("Successfully save cache to " + to.getAbsolutePath());
            } else {
                to.delete();
                logger.info("Cannot save local cache to " + to.getAbsolutePath());
            }
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
                is.reset();
                logger.info("Cache size : " + is.available());
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
            }
            if (to.exists()) {
                to.setLastModified(this.C.getLastModified());
            }
        }
    }

    public void disconnect() {
        if (this.C != null) {
            this.C.disconnect();
        }
    }

    private static void refreshSkinURL() {
        try {
            skinURLs = CustomSkinLoader.readAllLines(DATA_DIR, "skinurls.txt");
            cloakURLs = CustomSkinLoader.readAllLines(DATA_DIR, "capeurls.txt");
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage());
        }
        finally {
            if (skinURLs.length == 0 && cloakURLs.length == 0) {
                logger.info("No skinURLs and cloak URLS found, try to show GUI.");
                CustomSkinLoader.showGUI();
            } else {
                logger.log(Level.INFO, "Skin URLs Refreshed. Skin count = " + skinURLs.length + ",  Cloak count = " + cloakURLs.length);
            }
        }
    }

    private static String[] readAllLines(File dir, String path) {
        try {
            File F = new File(dir, path);
            logger.log(Level.INFO, "Config file: " + F.getAbsolutePath());
            if (!F.exists()) {
                logger.log(Level.INFO, "Config file not found.");
                return new String[0];
            }
            if (F.length() <= 0L) {
                logger.log(Level.INFO, "Config file is blank, skipped.");
                return new String[0];
            }
            byte[] b = new byte[(int)F.length()];
            BufferedInputStream S = new BufferedInputStream(new FileInputStream(F));
            S.read(b);
            S.close();
            logger.log(Level.INFO, "Config file loaded.");
            String[] re = CustomSkinLoader.str_replace("\r", "\n", CustomSkinLoader.str_replace("\r\n", "\n", new String(b))).split("\n");
            block2: for (int i = 0; i < re.length; ++i) {
                if (re[i].startsWith("#")) {
                    re[i] = null;
                    continue;
                }
                for (int g = 0; g < re.length; ++g) {
                    if (i == g || !re[i].equalsIgnoreCase(re[g])) continue;
                    re[i] = null;
                    continue block2;
                }
            }
            return re;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage());
            return new String[0];
        }
    }

    private static String str_replace(String search, String replace, String subject) {
        int pos;
        StringBuffer result = new StringBuffer(subject);
        while ((pos = result.indexOf(search)) != -1) {
            result.replace(pos, pos + search.length(), replace);
        }
        return result.toString();
    }

    public static void showGUI() {
        try {
            Class<?> clazz = Class.forName("idv.jlchntoz.CustomSkinLoaderGUI");
            String[] arg = new String[]{"f", VERSION, "in"};
            CustomSkinLoaderGUI.main(arg);
            return;
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
            File a = new File(DATA_DIR, "CustomSkinLoaderGUI.jar");
            if (!a.exists() || a.length() < 1L) {
                a.delete();
                logger.info("No GUI file found, try to download one to " + a.getAbsolutePath());
                CustomSkinLoader.downloadFile("https://raw.githubusercontent.com/JLChnToZ/MCCustomSkinLoader/GUI/CustomSkinLoaderGUI.jar", a);
            }
            try {
                String toRun = "java -jar \"" + a.getAbsolutePath() + "\" f " + VERSION;
                logger.info("Run: " + toRun);
                Runtime.getRuntime().exec(toRun);
            }
            catch (Exception e2) {
                logger.warning(e2.getMessage());
            }
            return;
        }
    }

    public static boolean downloadFile(String remote, File local) {
        try {
            File LCK = new File(local.getParentFile(), "download.lck");
            if (LCK.exists() && LCK.lastModified() >= System.currentTimeMillis() - 10000L) {
                logger.info("'download.lck' found! Download will not start.");
                return false;
            }
            LCK.createNewFile();
            logger.info("Downloading " + remote + " to " + local.getAbsolutePath());
            URL url = new URL(remote);
            URLConnection conn = url.openConnection();
            InputStream inStream = conn.getInputStream();
            FileOutputStream fs = new FileOutputStream(local);
            int byteRead = 0;
            byte[] buffer = new byte[1024];
            while ((byteRead = inStream.read(buffer)) != -1) {
                fs.write(buffer, 0, byteRead);
            }
            fs.close();
            LCK.delete();
            logger.info("Download successfully!");
            return local.exists();
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
            return false;
        }
    }

    public String MD5(String str) {
        byte[] buf = str.getBytes();
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(buf);
            byte[] tmp = md5.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : tmp) {
                sb.append(Integer.toHexString(b & 0xFF));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            logger.warning(e.getMessage());
            return "Fail";
        }
    }

    private static MainLogger getLogger(File logFile) {
        MainLogger mainLogger = new MainLogger(logFile);
        mainLogger.info("CustomSkinLoader 12.6");
        return mainLogger;
    }
}

