/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import customskinloader.CustomSkinLoader;
import customskinloader.fake.FakeClientPlayer;
import customskinloader.fake.FakeSkinBuffer;
import customskinloader.utils.HttpTextureUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.util.ResourceLocation;

public class FakeSkinManager {
    private static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    private final TextureManager textureManager;

    public FakeSkinManager(TextureManager textureManagerInstance, File skinCacheDirectory, MinecraftSessionService sessionService) {
        this.textureManager = textureManagerInstance;
        HttpTextureUtil.defaultCacheDir = skinCacheDirectory;
    }

    public ResourceLocation loadSkin(MinecraftProfileTexture profileTexture, MinecraftProfileTexture.Type textureType) {
        return this.loadSkin(profileTexture, textureType, null);
    }

    public ResourceLocation loadSkin(MinecraftProfileTexture profileTexture, MinecraftProfileTexture.Type textureType, SkinManager.SkinAvailableCallback skinAvailableCallback) {
        HttpTextureUtil.HttpTextureInfo info = HttpTextureUtil.toHttpTextureInfo(profileTexture.getUrl());
        ResourceLocation resourcelocation = new ResourceLocation("skins/" + info.hash);
        ITextureObject itextureobject = this.textureManager.func_110581_b(resourcelocation);
        if (itextureobject != null) {
            FakeSkinManager.makeCallback(skinAvailableCallback, textureType, resourcelocation, profileTexture);
        } else {
            ThreadDownloadImageData threaddownloadimagedata = new ThreadDownloadImageData(info.cacheFile, info.url, DefaultPlayerSkin.func_177335_a(), (IImageBuffer)new BaseBuffer(skinAvailableCallback, textureType, resourcelocation, profileTexture));
            if (skinAvailableCallback instanceof FakeClientPlayer.LegacyBuffer) {
                FakeClientPlayer.textureCache.put(resourcelocation, (ITextureObject)threaddownloadimagedata);
            }
            this.textureManager.func_110579_a(resourcelocation, (ITextureObject)threaddownloadimagedata);
        }
        return resourcelocation;
    }

    public void loadProfileTextures(final GameProfile profile, final SkinManager.SkinAvailableCallback skinAvailableCallback, boolean requireSecure) {
        THREAD_POOL.submit(new Runnable(){

            @Override
            public void run() {
                final HashMap map = Maps.newHashMap();
                map.putAll(CustomSkinLoader.loadProfile(profile));
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        for (MinecraftProfileTexture.Type type : MinecraftProfileTexture.Type.values()) {
                            if (!map.containsKey(type)) continue;
                            FakeSkinManager.this.loadSkin((MinecraftProfileTexture)map.get(type), type, skinAvailableCallback);
                        }
                    }
                });
            }
        });
    }

    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> loadSkinFromCache(GameProfile profile) {
        return CustomSkinLoader.loadProfileFromCache(profile);
    }

    private static void makeCallback(SkinManager.SkinAvailableCallback callback, MinecraftProfileTexture.Type type, ResourceLocation location, MinecraftProfileTexture texture) {
        if (callback != null) {
            callback.func_180521_a(type, location, texture);
        }
    }

    private class BaseBuffer
    implements IImageBuffer {
        private IImageBuffer buffer;
        private SkinManager.SkinAvailableCallback callback;
        private MinecraftProfileTexture.Type type;
        private ResourceLocation location;
        private MinecraftProfileTexture texture;

        public BaseBuffer(SkinManager.SkinAvailableCallback callback, MinecraftProfileTexture.Type type, ResourceLocation location, MinecraftProfileTexture texture) {
            this.buffer = type == MinecraftProfileTexture.Type.SKIN ? new FakeSkinBuffer() : null;
            this.callback = callback;
            this.type = type;
            this.location = location;
            this.texture = texture;
        }

        public NativeImage func_195786_a(NativeImage image) {
            return this.buffer instanceof FakeSkinBuffer ? ((FakeSkinBuffer)this.buffer).func_195786_a(image) : image;
        }

        public BufferedImage func_78432_a(BufferedImage image) {
            return this.buffer == null ? image : this.buffer.func_78432_a(image);
        }

        public void func_152634_a() {
            if (this.buffer != null) {
                this.buffer.func_152634_a();
                if ("auto".equals(this.texture.getMetadata("model")) && this.buffer instanceof FakeSkinBuffer) {
                    HashMap metadata = Maps.newHashMap();
                    metadata.put("model", ((FakeSkinBuffer)this.buffer).judgeType());
                    this.texture = new MinecraftProfileTexture(this.texture.getUrl(), (Map)metadata);
                }
            }
            FakeSkinManager.makeCallback(this.callback, this.type, this.location, this.texture);
        }
    }
}

