/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.utils;

import customskinloader.utils.HttpUtil0;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MinecraftUtil {
    public static File minecraftDataFolder = null;
    private static ArrayList<String> minecraftVersion = new ArrayList();
    private static String minecraftMainVersion = null;
    private static final Pattern MINECRAFT_VERSION_PATTERN = Pattern.compile(".*?(\\d+\\.\\d+[\\.]?\\d*).*?");
    private static final Pattern MINECRAFT_CORE_FILE_PATTERN = Pattern.compile("^(.*?)/versions/([^\\/\\\\]*?)/([^\\/\\\\]*?).jar$");
    private static final Pattern LIBRARY_FILE_PATTERN = Pattern.compile("^(.*?)/libraries/(.*?)/([^\\/\\\\]*?).jar$");

    public static File getMinecraftDataDir0() {
        return bao.B().w;
    }

    public static File getMinecraftDataDir() {
        if (minecraftDataFolder != null) {
            return minecraftDataFolder;
        }
        MinecraftUtil.testProbe();
        if (minecraftDataFolder != null) {
            return minecraftDataFolder;
        }
        return new File("");
    }

    public static ArrayList<String> getMinecraftVersions() {
        if (minecraftVersion != null && !minecraftVersion.isEmpty()) {
            return minecraftVersion;
        }
        MinecraftUtil.testProbe();
        return minecraftVersion;
    }

    public static String getMinecraftVersionText() {
        StringBuilder sb = new StringBuilder();
        for (String version : MinecraftUtil.getMinecraftVersions()) {
            sb.append(version).append(" ");
        }
        return StringUtils.trim((String)sb.toString());
    }

    public static String getMinecraftMainVersion() {
        if (minecraftMainVersion != null) {
            return minecraftMainVersion;
        }
        for (String version : MinecraftUtil.getMinecraftVersions()) {
            Matcher m = null;
            try {
                m = MINECRAFT_VERSION_PATTERN.matcher(version);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (m == null || !m.matches()) continue;
            minecraftMainVersion = m.group(m.groupCount());
            break;
        }
        return minecraftMainVersion;
    }

    public static String getServerAddress() {
        bjn data = bao.B().E();
        if (data == null) {
            return null;
        }
        return data.b;
    }

    public static String getStandardServerAddress() {
        return HttpUtil0.parseAddress(MinecraftUtil.getServerAddress());
    }

    public static boolean isLanServer() {
        return HttpUtil0.isLanServer(MinecraftUtil.getStandardServerAddress());
    }

    public static String getCurrentUsername() {
        return bao.B().M().e().getName();
    }

    private static void testProbe() {
        URL[] urls;
        minecraftVersion.clear();
        URLClassLoader ucl = (URLClassLoader)new MinecraftUtil().getClass().getClassLoader();
        for (URL url : urls = ucl.getURLs()) {
            Matcher m = null;
            try {
                m = MINECRAFT_CORE_FILE_PATTERN.matcher(URLDecoder.decode(url.getPath(), "UTF-8"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (m == null || !m.matches()) continue;
            if (minecraftDataFolder == null) {
                minecraftDataFolder = new File(m.group(1));
            }
            minecraftVersion.add(m.group(2));
        }
    }

    public static boolean isCoreFile(URL url) {
        Matcher m = null;
        try {
            m = MINECRAFT_CORE_FILE_PATTERN.matcher(URLDecoder.decode(url.getPath(), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return m != null && m.matches();
    }

    public static boolean isLibraryFile(URL url) {
        Matcher m = null;
        try {
            m = LIBRARY_FILE_PATTERN.matcher(URLDecoder.decode(url.getPath(), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return m != null && m.matches();
    }
}

