/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.renderer;

import customskinloader.CustomSkinLoader;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class SkinBuffer
implements blx {
    private int[] imageData;
    private int ratio = 1;
    private static final int A = 0xFFFFFF;
    private static final int WHITE = SkinBuffer.getARGB(255, 255, 255, 255);
    private static final int BLACK = SkinBuffer.getARGB(255, 0, 0, 0);
    private static final int B = -16777216;

    public BufferedImage a(BufferedImage image) {
        if (image == null) {
            return null;
        }
        this.ratio = image.getWidth() / 64;
        BufferedImage bufferedimage = new BufferedImage(64 * this.ratio, 32 * this.ratio, 2);
        Graphics graphics = bufferedimage.getGraphics();
        graphics.setColor(new Color(0, 0, 0, 0));
        graphics.fillRect(0, 0, 64, 32);
        if (image.getHeight() == 64 * this.ratio) {
            graphics.drawImage(image, 0 * this.ratio, 0 * this.ratio, 64 * this.ratio, 32 * this.ratio, 0 * this.ratio, 0 * this.ratio, 64 * this.ratio, 32 * this.ratio, null);
            graphics.drawImage(image, 0 * this.ratio, 16 * this.ratio, 64 * this.ratio, 32 * this.ratio, 0 * this.ratio, 32 * this.ratio, 64 * this.ratio, 48 * this.ratio, null);
        } else {
            graphics.drawImage(image, 0, 0, null);
        }
        graphics.dispose();
        this.imageData = ((DataBufferInt)bufferedimage.getRaster().getDataBuffer()).getData();
        this.setAreaDueToConfig(0 * this.ratio, 0 * this.ratio, 32 * this.ratio, 16 * this.ratio);
        this.setAreaTransparent(32 * this.ratio, 0 * this.ratio, 64 * this.ratio, 16 * this.ratio);
        this.setAreaDueToConfig(0 * this.ratio, 16 * this.ratio, 16 * this.ratio, 32 * this.ratio);
        this.setAreaDueToConfig(16 * this.ratio, 16 * this.ratio, 40 * this.ratio, 32 * this.ratio);
        this.setAreaDueToConfig(40 * this.ratio, 16 * this.ratio, 56 * this.ratio, 32 * this.ratio);
        return bufferedimage;
    }

    private boolean isFilled(int x0, int y0, int x1, int y1) {
        int data = this.imageData[this.getPosition(x0, y0)];
        if (data != WHITE && data != BLACK) {
            return false;
        }
        for (int x = x0; x < x1; ++x) {
            for (int y = y0; y < y1; ++y) {
                if (this.imageData[this.getPosition(x, y)] == data) continue;
                return false;
            }
        }
        return true;
    }

    private void setAreaTransparent(int x0, int y0, int x1, int y1) {
        if (!this.isFilled(x0, y0, x1, y1)) {
            return;
        }
        for (int x = x0; x < x1; ++x) {
            for (int y = y0; y < y1; ++y) {
                int n = this.getPosition(x, y);
                this.imageData[n] = this.imageData[n] & 0xFFFFFF;
            }
        }
    }

    private void setAreaOpaque(int x0, int y0, int x1, int y1) {
        for (int x = x0; x < x1; ++x) {
            for (int y = y0; y < y1; ++y) {
                int n = this.getPosition(x, y);
                this.imageData[n] = this.imageData[n] | 0xFF000000;
            }
        }
    }

    private void setAreaDueToConfig(int x0, int y0, int x1, int y1) {
        if (CustomSkinLoader.config.enableTransparentSkin) {
            this.setAreaTransparent(x0, y0, x1, y1);
        } else {
            this.setAreaOpaque(x0, y0, x1, y1);
        }
    }

    public void a() {
    }

    private static int getARGB(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    private int getPosition(int x, int y) {
        return x + y * 64 * this.ratio;
    }
}

