/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import customskinloader.CustomSkinLoader;
import customskinloader.fake.FakeClientPlayer;
import customskinloader.fake.FakeSkinBuffer;
import customskinloader.utils.HttpTextureUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FakeSkinManager {
    private static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    private final ddd textureManager;

    public FakeSkinManager(ddd textureManagerInstance, File skinCacheDirectory, MinecraftSessionService sessionService) {
        this.textureManager = textureManagerInstance;
        HttpTextureUtil.defaultCacheDir = skinCacheDirectory;
    }

    public pc loadSkin(MinecraftProfileTexture profileTexture, MinecraftProfileTexture.Type textureType) {
        return this.loadSkin(profileTexture, textureType, null);
    }

    public pc loadSkin(MinecraftProfileTexture profileTexture, MinecraftProfileTexture.Type textureType, ddx.a skinAvailableCallback) {
        HttpTextureUtil.HttpTextureInfo info = HttpTextureUtil.toHttpTextureInfo(profileTexture.getUrl());
        pc resourcelocation = new pc("skins/" + info.hash);
        dde itextureobject = this.textureManager.b(resourcelocation);
        if (itextureobject != null) {
            FakeSkinManager.makeCallback(skinAvailableCallback, textureType, resourcelocation, profileTexture);
        } else {
            dcs threaddownloadimagedata = new dcs(info.cacheFile, info.url, dds.a(), (ctq)new BaseBuffer(skinAvailableCallback, textureType, resourcelocation, profileTexture));
            if (skinAvailableCallback instanceof FakeClientPlayer.LegacyBuffer) {
                FakeClientPlayer.textureCache.put(resourcelocation, (dde)threaddownloadimagedata);
            }
            this.textureManager.a(resourcelocation, (dde)threaddownloadimagedata);
        }
        return resourcelocation;
    }

    public void loadProfileTextures(final GameProfile profile, final ddx.a skinAvailableCallback, boolean requireSecure) {
        THREAD_POOL.submit(new Runnable(){

            @Override
            public void run() {
                final HashMap map = Maps.newHashMap();
                map.putAll(CustomSkinLoader.loadProfile(profile));
                cfi.s().a(new Runnable(){

                    @Override
                    public void run() {
                        for (MinecraftProfileTexture.Type type : MinecraftProfileTexture.Type.values()) {
                            if (!map.containsKey(type)) continue;
                            FakeSkinManager.this.loadSkin((MinecraftProfileTexture)map.get(type), type, skinAvailableCallback);
                        }
                    }
                });
            }
        });
    }

    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> loadSkinFromCache(GameProfile profile) {
        return CustomSkinLoader.loadProfileFromCache(profile);
    }

    private static void makeCallback(ddx.a callback, MinecraftProfileTexture.Type type, pc location, MinecraftProfileTexture texture) {
        if (callback != null) {
            callback.onSkinTextureAvailable(type, location, texture);
        }
    }

    private class BaseBuffer
    implements ctq {
        private ctq buffer;
        private ddx.a callback;
        private MinecraftProfileTexture.Type type;
        private pc location;
        private MinecraftProfileTexture texture;

        public BaseBuffer(ddx.a callback, MinecraftProfileTexture.Type type, pc location, MinecraftProfileTexture texture) {
            this.buffer = type == MinecraftProfileTexture.Type.SKIN ? new FakeSkinBuffer() : null;
            this.callback = callback;
            this.type = type;
            this.location = location;
            this.texture = texture;
        }

        public dcw a(dcw image) {
            return this.buffer instanceof FakeSkinBuffer ? ((FakeSkinBuffer)this.buffer).a(image) : image;
        }

        public BufferedImage func_78432_a(BufferedImage image) {
            return this.buffer == null ? image : this.buffer.func_78432_a(image);
        }

        public void a() {
            if (this.buffer != null) {
                this.buffer.a();
                if ("auto".equals(this.texture.getMetadata("model")) && this.buffer instanceof FakeSkinBuffer) {
                    HashMap metadata = Maps.newHashMap();
                    metadata.put("model", ((FakeSkinBuffer)this.buffer).judgeType());
                    this.texture = new MinecraftProfileTexture(this.texture.getUrl(), (Map)metadata);
                }
            }
            FakeSkinManager.makeCallback(this.callback, this.type, this.location, this.texture);
        }
    }
}

