/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.profile;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import customskinloader.profile.UserProfile;
import java.util.HashMap;
import java.util.Map;

public class ModelManager0 {
    private static HashMap<String, Model> models = new HashMap();
    private static MinecraftProfileTexture.Type typeElytra = null;

    public static Model getEnumModel(String model) {
        return models.get(model);
    }

    public static boolean isSkin(Model model) {
        return model == Model.SKIN_DEFAULT || model == Model.SKIN_SLIM;
    }

    public static boolean isElytraSupported() {
        return false;
    }

    public static UserProfile toUserProfile(Map profile) {
        UserProfile userProfile = new UserProfile();
        if (profile == null) {
            return userProfile;
        }
        MinecraftProfileTexture skin = (MinecraftProfileTexture)profile.get(MinecraftProfileTexture.Type.SKIN);
        userProfile.skinUrl = skin == null ? null : skin.getUrl();
        userProfile.model = "default";
        MinecraftProfileTexture cape = (MinecraftProfileTexture)profile.get(MinecraftProfileTexture.Type.CAPE);
        userProfile.capeUrl = cape == null ? null : cape.getUrl();
        return userProfile;
    }

    public static Map fromUserProfile(UserProfile profile) {
        HashMap map = Maps.newHashMap();
        if (profile == null) {
            return map;
        }
        if (profile.skinUrl != null) {
            map.put(MinecraftProfileTexture.Type.SKIN, ModelManager0.getProfileTexture(profile.skinUrl, null));
        }
        if (profile.capeUrl != null) {
            map.put(MinecraftProfileTexture.Type.CAPE, ModelManager0.getProfileTexture(profile.capeUrl, null));
        }
        return map;
    }

    public static MinecraftProfileTexture getProfileTexture(String url, Map metadata) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("url", url);
        Gson gson = new Gson();
        String json = gson.toJson(hashMap);
        MinecraftProfileTexture pt = (MinecraftProfileTexture)gson.fromJson(json, MinecraftProfileTexture.class);
        return pt;
    }

    static {
        models.put("default", Model.SKIN_DEFAULT);
        models.put("cape", Model.CAPE);
    }

    public static enum Model {
        SKIN_DEFAULT,
        SKIN_SLIM,
        CAPE,
        ELYTRA;

    }
}

