/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.loader;

import com.mojang.authlib.GameProfile;
import customskinloader.CustomSkinLoader;
import customskinloader.config.SkinSiteProfile;
import customskinloader.loader.ProfileLoader;
import customskinloader.profile.ModelManager0;
import customskinloader.profile.UserProfile;
import customskinloader.utils.HttpRequestUtil;
import customskinloader.utils.HttpTextureUtil;
import customskinloader.utils.HttpUtil0;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class LegacyLoader
implements ProfileLoader.IProfileLoader {
    public static final String USERNAME_PLACEHOLDER = "{USERNAME}";

    @Override
    public UserProfile loadProfile(SkinSiteProfile ssp, GameProfile gameProfile) throws Exception {
        HttpRequestUtil.HttpResponce responce;
        String username = gameProfile.getName();
        UserProfile profile = new UserProfile();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{ssp.skin})) {
            String skin = ssp.skin.replace(USERNAME_PLACEHOLDER, username);
            if (HttpUtil0.isLocal(ssp.skin)) {
                File skinFile = new File(CustomSkinLoader.DATA_DIR, skin);
                if (skinFile.exists() && skinFile.isFile()) {
                    profile.skinUrl = HttpTextureUtil.getLocalLegacyFakeUrl(skin, HttpTextureUtil.getHash(skin, skinFile.length(), skinFile.lastModified()));
                }
            } else {
                responce = HttpRequestUtil.makeHttpRequest(new HttpRequestUtil.HttpRequest(skin).setUserAgent(ssp.userAgent).setCheckPNG(ssp.checkPNG != null && ssp.checkPNG != false).setLoadContent(false).setCacheTime(90));
                if (responce.success) {
                    profile.skinUrl = HttpTextureUtil.getLegacyFakeUrl(skin);
                }
            }
            String string = profile.model = profile.hasSkinUrl() ? ssp.model : null;
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{ssp.cape})) {
            String cape = ssp.cape.replace(USERNAME_PLACEHOLDER, username);
            if (HttpUtil0.isLocal(ssp.cape)) {
                File capeFile = new File(CustomSkinLoader.DATA_DIR, cape);
                if (capeFile.exists() && capeFile.isFile()) {
                    profile.capeUrl = HttpTextureUtil.getLocalLegacyFakeUrl(cape, HttpTextureUtil.getHash(cape, capeFile.length(), capeFile.lastModified()));
                }
            } else {
                responce = HttpRequestUtil.makeHttpRequest(new HttpRequestUtil.HttpRequest(cape).setUserAgent(ssp.userAgent).setCheckPNG(ssp.checkPNG != null && ssp.checkPNG != false).setLoadContent(false).setCacheTime(90));
                if (responce.success) {
                    profile.capeUrl = HttpTextureUtil.getLegacyFakeUrl(cape);
                }
            }
        }
        if (ModelManager0.isElytraSupported() && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{ssp.elytra})) {
            String elytra = ssp.elytra.replace(USERNAME_PLACEHOLDER, username);
            if (HttpUtil0.isLocal(ssp.elytra)) {
                File elytraFile = new File(CustomSkinLoader.DATA_DIR, elytra);
                if (elytraFile.exists() && elytraFile.isFile()) {
                    profile.elytraUrl = HttpTextureUtil.getLocalLegacyFakeUrl(elytra, HttpTextureUtil.getHash(elytra, elytraFile.length(), elytraFile.lastModified()));
                }
            } else {
                responce = HttpRequestUtil.makeHttpRequest(new HttpRequestUtil.HttpRequest(elytra).setUserAgent(ssp.userAgent).setCheckPNG(ssp.checkPNG != null && ssp.checkPNG != false).setLoadContent(false).setCacheTime(90));
                if (responce.success) {
                    profile.elytraUrl = HttpTextureUtil.getLegacyFakeUrl(elytra);
                }
            }
        }
        if (profile.isEmpty()) {
            CustomSkinLoader.logger.info("Both skin and cape not found.");
            return null;
        }
        return profile;
    }

    @Override
    public boolean compare(SkinSiteProfile ssp0, SkinSiteProfile ssp1) {
        return !StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{ssp0.skin}) || ssp0.skin.equalsIgnoreCase(ssp1.skin) || !StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{ssp0.cape}) || ssp0.cape.equalsIgnoreCase(ssp1.cape);
    }

    @Override
    public String getName() {
        return "Legacy";
    }

    @Override
    public void initLocalFolder(SkinSiteProfile ssp) {
        if (HttpUtil0.isLocal(ssp.skin)) {
            this.initFolder(ssp.skin);
        }
        if (HttpUtil0.isLocal(ssp.cape)) {
            this.initFolder(ssp.cape);
        }
        if (HttpUtil0.isLocal(ssp.elytra)) {
            this.initFolder(ssp.elytra);
        }
    }

    private void initFolder(String target) {
        String file = target.replace(USERNAME_PLACEHOLDER, "init");
        File folder = new File(CustomSkinLoader.DATA_DIR, file).getParentFile();
        if (folder != null && !folder.exists()) {
            folder.mkdirs();
        }
    }
}

