/*
 * Decompiled with CFR 0.152.
 */
package customskinloader;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import customskinloader.Logger;
import customskinloader.config.Config;
import customskinloader.config.SkinSiteProfile;
import customskinloader.loader.ProfileLoader;
import customskinloader.profile.DynamicSkullManager;
import customskinloader.profile.ModelManager0;
import customskinloader.profile.ProfileCache;
import customskinloader.profile.UserProfile;
import customskinloader.utils.MinecraftUtil;
import java.io.File;
import java.util.Map;

public class CustomSkinLoader {
    public static final String CustomSkinLoader_VERSION = "14.10";
    public static final String CustomSkinLoader_FULL_VERSION = "14.10-SNAPSHOT-43";
    public static final File DATA_DIR = new File(MinecraftUtil.getMinecraftDataDir(), "CustomSkinLoader");
    public static final File LOG_FILE = new File(DATA_DIR, "CustomSkinLoader.log");
    public static final File CONFIG_FILE = new File(DATA_DIR, "CustomSkinLoader.json");
    public static final SkinSiteProfile[] DEFAULT_LOAD_LIST = new SkinSiteProfile[]{SkinSiteProfile.createMojangAPI("Mojang"), SkinSiteProfile.createCustomSkinAPI("LittleSkin", "https://littleskin.cn/"), SkinSiteProfile.createCustomSkinAPI("BlessingSkin", "http://skin.prinzeugen.net/"), SkinSiteProfile.createElyByAPI("ElyBy"), SkinSiteProfile.createUniSkinAPI("SkinMe", "http://www.skinme.cc/uniskin/"), SkinSiteProfile.createLegacy("LocalSkin", "LocalSkin/skins/{USERNAME}.png", "LocalSkin/capes/{USERNAME}.png", "LocalSkin/elytras/{USERNAME}.png")};
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Logger logger = CustomSkinLoader.initLogger();
    public static final Config config = Config.loadConfig0();
    private static final ProfileCache profileCache = new ProfileCache();
    private static final DynamicSkullManager dynamicSkullManager = new DynamicSkullManager();

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> loadProfile(GameProfile gameProfile) {
        UserProfile profile;
        String username = gameProfile.getName();
        String credential = MinecraftUtil.getCredential(gameProfile);
        if (username == null) {
            logger.warning("Could not load profile: username is null.");
            return Maps.newHashMap();
        }
        String tempName = Thread.currentThread().getName();
        Thread.currentThread().setName(username);
        if (profileCache.isReady(credential)) {
            logger.info("Cached profile will be used.");
            profile = profileCache.getProfile(credential);
            if (profile == null) {
                logger.warning("(!Cached Profile is empty!) Expiry:" + profileCache.getExpiry(credential));
                if (profileCache.isExpired(credential)) {
                    profile = CustomSkinLoader.loadProfile0(gameProfile);
                }
            } else {
                logger.info(profile.toString(profileCache.getExpiry(credential)));
            }
        } else {
            profileCache.setLoading(credential, true);
            profile = CustomSkinLoader.loadProfile0(gameProfile);
        }
        Thread.currentThread().setName(tempName);
        return ModelManager0.fromUserProfile(profile);
    }

    public static UserProfile loadProfile0(GameProfile gameProfile) {
        String username = gameProfile.getName();
        String credential = MinecraftUtil.getCredential(gameProfile);
        profileCache.setLoading(credential, true);
        logger.info("Loading " + username + "'s profile.");
        if (CustomSkinLoader.config.loadlist == null || CustomSkinLoader.config.loadlist.isEmpty()) {
            logger.info("LoadList is Empty.");
            return null;
        }
        UserProfile profile0 = new UserProfile();
        for (int i = 0; i < CustomSkinLoader.config.loadlist.size(); ++i) {
            UserProfile profile;
            block10: {
                SkinSiteProfile ssp = CustomSkinLoader.config.loadlist.get(i);
                logger.info(i + 1 + "/" + CustomSkinLoader.config.loadlist.size() + " Try to load profile from '" + ssp.name + "'.");
                ProfileLoader.IProfileLoader loader = ProfileLoader.LOADERS.get(ssp.type.toLowerCase());
                if (loader == null) {
                    logger.info("Type '" + ssp.type + "' is not defined.");
                    continue;
                }
                profile = null;
                try {
                    profile = loader.loadProfile(ssp, gameProfile);
                }
                catch (Exception e) {
                    logger.warning("Exception occurs while loading.");
                    logger.warning(e);
                    if (e.getCause() == null) break block10;
                    logger.warning("Caused By:");
                    logger.warning(e.getCause());
                }
            }
            if (profile == null) continue;
            if (!CustomSkinLoader.config.forceLoadAllTextures) {
                profile0 = profile;
                break;
            }
            profile0.mix(profile);
            if (profile0.isFull()) break;
        }
        if (!profile0.isEmpty()) {
            logger.info(username + "'s profile loaded.");
            profileCache.updateCache(credential, profile0);
            profileCache.setLoading(credential, false);
            logger.info(profile0.toString(profileCache.getExpiry(credential)));
            return profile0;
        }
        logger.info(username + "'s profile not found in load list.");
        if (CustomSkinLoader.config.enableLocalProfileCache) {
            UserProfile profile = profileCache.getLocalProfile(credential);
            if (profile == null) {
                logger.info(username + "'s LocalProfile not found.");
            } else {
                profileCache.updateCache(credential, profile, false);
                profileCache.setLoading(credential, false);
                logger.info(username + "'s LocalProfile will be used.");
                logger.info(profile.toString(profileCache.getExpiry(credential)));
                return profile;
            }
        }
        profileCache.setLoading(credential, false);
        return null;
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> loadProfileFromCache(final GameProfile gameProfile) {
        String username = gameProfile.getName();
        String credential = MinecraftUtil.getCredential(gameProfile);
        if (username == null || credential == null) {
            return dynamicSkullManager.getTexture(gameProfile);
        }
        if (CustomSkinLoader.config.enableUpdateSkull ? profileCache.isReady(credential) : profileCache.isExist(credential)) {
            UserProfile profile = profileCache.getProfile(credential);
            return ModelManager0.fromUserProfile(profile);
        }
        Thread loadThread = new Thread(){

            @Override
            public void run() {
                CustomSkinLoader.loadProfile0(gameProfile);
            }
        };
        loadThread.setName(username + "'s skull");
        loadThread.start();
        return Maps.newHashMap();
    }

    private static Logger initLogger() {
        Logger logger = new Logger(LOG_FILE);
        logger.info("CustomSkinLoader 14.10-SNAPSHOT-43");
        logger.info("DataDir: " + DATA_DIR.getAbsolutePath());
        logger.info("Minecraft: " + MinecraftUtil.getMinecraftMainVersion() + "(" + MinecraftUtil.getMinecraftVersionText() + ")");
        return logger;
    }
}

