/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.forge;

import customskinloader.Logger;
import customskinloader.forge.transformer.PlayerTabTransformer;
import customskinloader.forge.transformer.SkinManagerTransformer;
import customskinloader.forge.transformer.SpectatorMenuTransformer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class TransformerManager
implements IClassTransformer {
    public static Logger logger = new Logger("CustomSkinLoader/ForgePlugin.log");
    private static final IMethodTransformer[] TRANFORMERS = new IMethodTransformer[]{new SkinManagerTransformer.InitTransformer(), new SkinManagerTransformer.LoadSkinTransformer(), new SkinManagerTransformer.LoadProfileTexturesTransformer(), new SkinManagerTransformer.LoadSkinFromCacheTransformer(), new PlayerTabTransformer.ScoreObjectiveTransformer(), new SpectatorMenuTransformer.PlayerMenuObjectTransformer()};
    private Map<String, Map<String, IMethodTransformer>> map = new HashMap<String, Map<String, IMethodTransformer>>();

    public TransformerManager() {
        for (IMethodTransformer t : TRANFORMERS) {
            logger.info("[CSL DEBUG] REGISTERING TRANSFORMER %s", t.getClass().getName());
            if (!t.getClass().isAnnotationPresent(TransformTarget.class)) {
                logger.info("[CSL DEBUG] ERROR occurs while parsing Annotation.");
                continue;
            }
            this.addMethodTransformer(t.getClass().getAnnotation(TransformTarget.class), t);
        }
    }

    private void addMethodTransformer(TransformTarget target, IMethodTransformer transformer) {
        if (!this.map.containsKey(target.className())) {
            this.map.put(target.className(), new HashMap());
        }
        for (String methodName : target.methodNames()) {
            this.map.get(target.className()).put(methodName + target.desc(), transformer);
            logger.info("[CSL DEBUG] REGISTERING METHOD %s(%s)", target.className(), methodName + target.desc());
        }
    }

    public byte[] transform(String obfClassName, String className, byte[] bytes) {
        if (!this.map.containsKey(className)) {
            return bytes;
        }
        logger.info("[CSL DEBUG] CLASS %s will be transformed", className);
        Map<String, IMethodTransformer> transMap = this.map.get(className);
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        ArrayList ml = new ArrayList(cn.methods);
        for (MethodNode mn : ml) {
            String methodName = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(obfClassName, mn.name, mn.desc);
            String methodDesc = FMLDeobfuscatingRemapper.INSTANCE.mapMethodDesc(mn.desc);
            if (!transMap.containsKey(methodName + methodDesc)) continue;
            try {
                logger.info("[CSL DEBUG] Transforming method %s in class %s(%s)", methodName + methodDesc, obfClassName, className);
                transMap.get(methodName + methodDesc).transform(cn, mn);
                logger.info("[CSL DEBUG] Successfully transformed method %s in class %s(%s)", methodName + methodDesc, obfClassName, className);
            }
            catch (Exception e) {
                logger.warning("[CSL DEBUG] An error happened when transforming method %s in class %s(%s). The whole class was not modified.", methodName + methodDesc, obfClassName, className);
                e.printStackTrace();
                return bytes;
            }
        }
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public static interface IMethodTransformer {
        public void transform(ClassNode var1, MethodNode var2);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface TransformTarget {
        public String className();

        public String[] methodNames();

        public String desc();
    }
}

