/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import customskinloader.utils.HttpUtil0;
import customskinloader.utils.JavaUtil;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MinecraftUtil {
    private static ArrayList<String> minecraftVersion = new ArrayList();
    private static String minecraftMainVersion = null;
    private static final Pattern MINECRAFT_VERSION_PATTERN = Pattern.compile(".*?(\\d+\\.\\d+[\\.]?\\d*).*?");
    private static final Pattern MINECRAFT_CORE_FILE_PATTERN = Pattern.compile("^(.*?)/versions/([^\\/\\\\]*?)/([^\\/\\\\]*?).jar$");
    private static final Pattern LIBRARY_FILE_PATTERN = Pattern.compile("^(.*?)/libraries/(.*?)/([^\\/\\\\]*?).jar$");

    public static File getMinecraftDataDir() {
        return cfi.s().w;
    }

    public static MinecraftSessionService getSessionService() {
        return cfi.s().P();
    }

    public static ddd getTextureManager() {
        return cfi.s().E();
    }

    public static ArrayList<String> getMinecraftVersions() {
        if (minecraftVersion != null && !minecraftVersion.isEmpty()) {
            return minecraftVersion;
        }
        MinecraftUtil.testProbe();
        return minecraftVersion;
    }

    public static String getMinecraftVersionText() {
        StringBuilder sb = new StringBuilder();
        for (String version : MinecraftUtil.getMinecraftVersions()) {
            sb.append(version).append(" ");
        }
        return StringUtils.trim((String)sb.toString());
    }

    public static String getMinecraftMainVersion() {
        if (minecraftMainVersion != null) {
            return minecraftMainVersion;
        }
        for (String version : MinecraftUtil.getMinecraftVersions()) {
            Matcher m = null;
            try {
                m = MINECRAFT_VERSION_PATTERN.matcher(version);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (m == null || !m.matches()) continue;
            minecraftMainVersion = m.group(m.groupCount());
            break;
        }
        return minecraftMainVersion;
    }

    public static String getServerAddress() {
        cqy data = cfi.s().v();
        if (data == null) {
            return null;
        }
        return data.b;
    }

    public static String getStandardServerAddress() {
        return HttpUtil0.parseAddress(MinecraftUtil.getServerAddress());
    }

    public static boolean isLanServer() {
        return HttpUtil0.isLanServer(MinecraftUtil.getStandardServerAddress());
    }

    public static String getCurrentUsername() {
        return cfi.s().B().e().getName();
    }

    private static void testProbe() {
        URL[] urls;
        minecraftVersion.clear();
        for (URL url : urls = JavaUtil.getClasspath()) {
            Matcher m = null;
            try {
                m = MINECRAFT_CORE_FILE_PATTERN.matcher(URLDecoder.decode(url.getPath(), "UTF-8"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (m == null || !m.matches()) continue;
            minecraftVersion.add(m.group(2));
        }
    }

    public static boolean isCoreFile(URL url) {
        Matcher m;
        try {
            m = MINECRAFT_CORE_FILE_PATTERN.matcher(URLDecoder.decode(url.getPath(), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return m.matches();
    }

    public static boolean isLibraryFile(URL url) {
        Matcher m;
        try {
            m = LIBRARY_FILE_PATTERN.matcher(URLDecoder.decode(url.getPath(), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return m.matches();
    }

    public static String getCredential(GameProfile profile) {
        return profile == null || profile.hashCode() == 0 ? null : (profile.getId() == null ? profile.getName() : String.format("%s-%s", profile.getName(), profile.getId()));
    }
}

