/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake;

import customskinloader.CustomSkinLoader;
import customskinloader.fake.texture.FakeBufferedImage;
import customskinloader.fake.texture.FakeImage;
import customskinloader.fake.texture.FakeNativeImage;
import java.awt.image.BufferedImage;

public class FakeSkinBuffer
implements ctq {
    private int ratio = 1;
    private FakeImage image = null;
    private static final int A = 0xFFFFFF;
    private static final int WHITE = FakeSkinBuffer.getARGB(255, 255, 255, 255);
    private static final int BLACK = FakeSkinBuffer.getARGB(255, 0, 0, 0);
    private static final int B = -16777216;

    public dcw a(dcw image) {
        if (image == null) {
            return null;
        }
        FakeImage img = this.parseUserSkin(new FakeNativeImage(image));
        if (img instanceof FakeNativeImage) {
            return ((FakeNativeImage)img).getImage();
        }
        CustomSkinLoader.logger.warning("Failed to parseUserSkin(func_195786_a).");
        return null;
    }

    public BufferedImage func_78432_a(BufferedImage image) {
        if (image == null) {
            return null;
        }
        FakeImage img = this.parseUserSkin(new FakeBufferedImage(image));
        if (img instanceof FakeBufferedImage) {
            return ((FakeBufferedImage)img).getImage();
        }
        CustomSkinLoader.logger.warning("Failed to parseUserSkin.");
        return null;
    }

    public FakeImage parseUserSkin(FakeImage image) {
        if (image == null) {
            return null;
        }
        this.ratio = image.getWidth() / 64;
        if (image.getHeight() != image.getWidth()) {
            FakeImage img = image.createImage(64 * this.ratio, 64 * this.ratio);
            img.copyImageData(image);
            image.close();
            image = img;
            image.fillArea(0 * this.ratio, 32 * this.ratio, 64 * this.ratio, 32 * this.ratio);
            image.copyArea(4 * this.ratio, 16 * this.ratio, 16 * this.ratio, 32 * this.ratio, 4 * this.ratio, 4 * this.ratio, true, false);
            image.copyArea(8 * this.ratio, 16 * this.ratio, 16 * this.ratio, 32 * this.ratio, 4 * this.ratio, 4 * this.ratio, true, false);
            image.copyArea(0 * this.ratio, 20 * this.ratio, 24 * this.ratio, 32 * this.ratio, 4 * this.ratio, 12 * this.ratio, true, false);
            image.copyArea(4 * this.ratio, 20 * this.ratio, 16 * this.ratio, 32 * this.ratio, 4 * this.ratio, 12 * this.ratio, true, false);
            image.copyArea(8 * this.ratio, 20 * this.ratio, 8 * this.ratio, 32 * this.ratio, 4 * this.ratio, 12 * this.ratio, true, false);
            image.copyArea(12 * this.ratio, 20 * this.ratio, 16 * this.ratio, 32 * this.ratio, 4 * this.ratio, 12 * this.ratio, true, false);
            image.copyArea(44 * this.ratio, 16 * this.ratio, -8 * this.ratio, 32 * this.ratio, 4 * this.ratio, 4 * this.ratio, true, false);
            image.copyArea(48 * this.ratio, 16 * this.ratio, -8 * this.ratio, 32 * this.ratio, 4 * this.ratio, 4 * this.ratio, true, false);
            image.copyArea(40 * this.ratio, 20 * this.ratio, 0 * this.ratio, 32 * this.ratio, 4 * this.ratio, 12 * this.ratio, true, false);
            image.copyArea(44 * this.ratio, 20 * this.ratio, -8 * this.ratio, 32 * this.ratio, 4 * this.ratio, 12 * this.ratio, true, false);
            image.copyArea(48 * this.ratio, 20 * this.ratio, -16 * this.ratio, 32 * this.ratio, 4 * this.ratio, 12 * this.ratio, true, false);
            image.copyArea(52 * this.ratio, 20 * this.ratio, -8 * this.ratio, 32 * this.ratio, 4 * this.ratio, 12 * this.ratio, true, false);
        }
        this.image = image;
        this.setAreaDueToConfig(0 * this.ratio, 0 * this.ratio, 32 * this.ratio, 16 * this.ratio);
        this.setAreaTransparent(32 * this.ratio, 0 * this.ratio, 64 * this.ratio, 16 * this.ratio);
        this.setAreaDueToConfig(16 * this.ratio, 16 * this.ratio, 40 * this.ratio, 32 * this.ratio);
        this.setAreaTransparent(16 * this.ratio, 32 * this.ratio, 40 * this.ratio, 48 * this.ratio);
        this.setAreaDueToConfig(40 * this.ratio, 16 * this.ratio, 56 * this.ratio, 32 * this.ratio);
        this.setAreaTransparent(40 * this.ratio, 32 * this.ratio, 56 * this.ratio, 48 * this.ratio);
        this.setAreaDueToConfig(0 * this.ratio, 16 * this.ratio, 16 * this.ratio, 32 * this.ratio);
        this.setAreaTransparent(0 * this.ratio, 32 * this.ratio, 16 * this.ratio, 48 * this.ratio);
        this.setAreaDueToConfig(32 * this.ratio, 48 * this.ratio, 48 * this.ratio, 64 * this.ratio);
        this.setAreaTransparent(48 * this.ratio, 48 * this.ratio, 64 * this.ratio, 64 * this.ratio);
        this.setAreaDueToConfig(16 * this.ratio, 48 * this.ratio, 32 * this.ratio, 64 * this.ratio);
        this.setAreaTransparent(0 * this.ratio, 48 * this.ratio, 16 * this.ratio, 64 * this.ratio);
        return image;
    }

    public String judgeType() {
        if (this.image == null) {
            return null;
        }
        if ((this.image.getRGBA(55, 20) & 0xFF000000) >>> 24 == 0) {
            return "slim";
        }
        return "default";
    }

    private boolean isFilled(int x0, int y0, int x1, int y1) {
        int data = this.image.getRGBA(x0, y0);
        if (data != WHITE && data != BLACK) {
            return false;
        }
        for (int x = x0; x < x1; ++x) {
            for (int y = y0; y < y1; ++y) {
                if (this.image.getRGBA(x, y) == data) continue;
                return false;
            }
        }
        return true;
    }

    private void setAreaTransparent(int x0, int y0, int x1, int y1) {
        if (!this.isFilled(x0, y0, x1, y1)) {
            return;
        }
        for (int x = x0; x < x1; ++x) {
            for (int y = y0; y < y1; ++y) {
                this.image.setRGBA(x, y, this.image.getRGBA(x, y) & 0xFFFFFF);
            }
        }
    }

    private void setAreaOpaque(int x0, int y0, int x1, int y1) {
        for (int x = x0; x < x1; ++x) {
            for (int y = y0; y < y1; ++y) {
                this.image.setRGBA(x, y, this.image.getRGBA(x, y) | 0xFF000000);
            }
        }
    }

    private void setAreaDueToConfig(int x0, int y0, int x1, int y1) {
        if (CustomSkinLoader.config.enableTransparentSkin) {
            this.setAreaTransparent(x0, y0, x1, y1);
        } else {
            this.setAreaOpaque(x0, y0, x1, y1);
        }
    }

    public void a() {
    }

    private static int getARGB(int a2, int r, int g, int b) {
        return a2 << 24 | r << 16 | g << 8 | b;
    }
}

