/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.config;

import customskinloader.CustomSkinLoader;
import customskinloader.config.SkinSiteProfile;
import customskinloader.loader.ProfileLoader;
import customskinloader.utils.HttpRequestUtil;
import customskinloader.utils.HttpTextureUtil;
import customskinloader.utils.HttpUtil0;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class Config {
    public String version = "14.9";
    public List<SkinSiteProfile> loadlist;
    public boolean enableDynamicSkull = true;
    public boolean enableTransparentSkin = true;
    public boolean ignoreHttpsCertificate = false;
    public boolean forceLoadAllTextures = false;
    public int cacheExpiry = 30;
    public boolean enableUpdateSkull = false;
    public boolean enableLocalProfileCache = false;
    public boolean enableCacheAutoClean = false;

    public Config(SkinSiteProfile[] loadlist) {
        this.loadlist = Arrays.asList(loadlist);
    }

    public static Config loadConfig0() {
        Config config = Config.loadConfig();
        if (config.loadlist == null) {
            config.loadlist = new ArrayList<SkinSiteProfile>();
        } else {
            for (int i = 0; i < config.loadlist.size(); ++i) {
                if (config.loadlist.get(i) != null) continue;
                config.loadlist.remove(i--);
            }
        }
        config.loadExtraList();
        config.initLocalFolder();
        if (config.ignoreHttpsCertificate) {
            HttpUtil0.ignoreHttpsCertificate();
        }
        if (config.enableCacheAutoClean && !config.enableLocalProfileCache) {
            try {
                FileUtils.deleteDirectory((File)HttpRequestUtil.CACHE_DIR);
                FileUtils.deleteDirectory((File)HttpTextureUtil.getCacheDir());
                CustomSkinLoader.logger.info("Successfully cleaned cache.");
            }
            catch (Exception e) {
                CustomSkinLoader.logger.warning("Exception occurs while cleaning cache: " + e.toString());
            }
        }
        CustomSkinLoader.logger.info("EnableDynamicSkull:" + config.enableDynamicSkull + ", EnableTranSkin:" + config.enableTransparentSkin + ", IgnoreHttpsCertificate:" + config.ignoreHttpsCertificate + ", CacheExpiry:" + config.cacheExpiry + ", EnableUpdateSkull:" + config.enableUpdateSkull + ", EnableLocalProfileCache:" + config.enableLocalProfileCache + ", EnableCacheAutoClean:" + config.enableCacheAutoClean + ", LoadList:" + (config.loadlist == null ? 0 : config.loadlist.size()));
        float floatVersion = 0.0f;
        float configVersion = 0.0f;
        try {
            floatVersion = Float.parseFloat("14.9");
            configVersion = Float.parseFloat(config.version);
            if (configVersion == 15.1f) {
                configVersion = 14.6f;
            }
        }
        catch (Exception e) {
            CustomSkinLoader.logger.warning("Exception occurs while parsing version: " + e.toString());
        }
        if (config.version == null || configVersion == 0.0f || floatVersion > configVersion) {
            CustomSkinLoader.logger.info("Config File is out of date: " + config.version);
            config.version = "14.9";
            Config.writeConfig(config, true);
        }
        return config;
    }

    private static Config loadConfig() {
        CustomSkinLoader.logger.info("Config File: " + CustomSkinLoader.CONFIG_FILE.getAbsolutePath());
        if (!CustomSkinLoader.CONFIG_FILE.exists()) {
            CustomSkinLoader.logger.info("Config file not found, use default instead.");
            return Config.initConfig();
        }
        try {
            CustomSkinLoader.logger.info("Try to load config.");
            String json = FileUtils.readFileToString((File)CustomSkinLoader.CONFIG_FILE, (String)"UTF-8");
            Config config = (Config)CustomSkinLoader.GSON.fromJson(json, Config.class);
            CustomSkinLoader.logger.info("Successfully load config.");
            return config;
        }
        catch (Exception e) {
            CustomSkinLoader.logger.info("Failed to load config, use default instead.(" + e.toString() + ")");
            File brokenFile = new File(CustomSkinLoader.DATA_DIR, "BROKEN-CustomSkinLoader.json");
            if (brokenFile.exists()) {
                brokenFile.delete();
            }
            CustomSkinLoader.CONFIG_FILE.renameTo(brokenFile);
            return Config.initConfig();
        }
    }

    private void loadExtraList() {
        File listAddition = new File(CustomSkinLoader.DATA_DIR, "ExtraList");
        if (!listAddition.isDirectory()) {
            listAddition.mkdirs();
            return;
        }
        ArrayList<SkinSiteProfile> adds = new ArrayList<SkinSiteProfile>();
        File[] files = listAddition.listFiles();
        for (File file : files != null ? files : new File[]{}) {
            if (!file.getName().toLowerCase().endsWith(".json") && !file.getName().toLowerCase().endsWith(".txt")) continue;
            try {
                CustomSkinLoader.logger.info("Try to load Extra List.(" + file.getName() + ")");
                String json = FileUtils.readFileToString((File)file, (String)"UTF-8");
                SkinSiteProfile ssp = (SkinSiteProfile)CustomSkinLoader.GSON.fromJson(json, SkinSiteProfile.class);
                CustomSkinLoader.logger.info("Successfully load Extra List.");
                file.delete();
                ProfileLoader.IProfileLoader loader = ProfileLoader.LOADERS.get(ssp.type.toLowerCase());
                if (loader == null) {
                    CustomSkinLoader.logger.info("Extra List will be ignore: Type '" + ssp.type + "' is not defined.");
                    continue;
                }
                boolean duplicate = false;
                for (SkinSiteProfile ssp0 : this.loadlist) {
                    if (!ssp0.type.equalsIgnoreCase(ssp.type) || !loader.compare(ssp0, ssp)) continue;
                    duplicate = true;
                    break;
                }
                if (!duplicate) {
                    adds.add(ssp);
                    CustomSkinLoader.logger.info("Successfully apply Extra List.(" + ssp.name + ")");
                    continue;
                }
                CustomSkinLoader.logger.info("Extra List will be ignore: Duplicate.(" + ssp.name + ")");
            }
            catch (Exception e) {
                CustomSkinLoader.logger.info("Failed to load Extra List.(" + e.toString() + ")");
            }
        }
        if (adds.size() != 0) {
            adds.addAll(this.loadlist);
            this.loadlist = adds;
            Config.writeConfig(this, true);
        }
    }

    private void initLocalFolder() {
        for (SkinSiteProfile ssp : this.loadlist) {
            ProfileLoader.IProfileLoader loader = ProfileLoader.LOADERS.get(ssp.type.toLowerCase());
            if (loader == null) continue;
            loader.initLocalFolder(ssp);
        }
    }

    private static Config initConfig() {
        Config config = new Config(CustomSkinLoader.DEFAULT_LOAD_LIST);
        Config.writeConfig(config, false);
        return config;
    }

    private static void writeConfig(Config config, boolean update) {
        String json = CustomSkinLoader.GSON.toJson((Object)config);
        if (CustomSkinLoader.CONFIG_FILE.exists()) {
            CustomSkinLoader.CONFIG_FILE.delete();
        }
        try {
            CustomSkinLoader.CONFIG_FILE.createNewFile();
            FileUtils.write((File)CustomSkinLoader.CONFIG_FILE, (CharSequence)json, (String)"UTF-8");
            CustomSkinLoader.logger.info("Successfully " + (update ? "update" : "create") + " config.");
        }
        catch (Exception e) {
            CustomSkinLoader.logger.info("Failed to " + (update ? "update" : "create") + " config.(" + e.toString() + ")");
        }
    }
}

