/*
 * Decompiled with CFR 0.152.
 */
package customskinloader;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private BufferedWriter writer = null;

    public Logger() {
    }

    public Logger(String logFile) {
        this(new File(logFile));
    }

    public Logger(File logFile) {
        try {
            if (!logFile.getParentFile().exists()) {
                logFile.getParentFile().mkdirs();
            }
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(logFile), "UTF-8"));
            System.out.println("Log Path: " + logFile.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void log(Level level, String msg) {
        if (!level.display() && this.writer == null) {
            return;
        }
        String sb = String.format("[%s %s] %s", Thread.currentThread().getName(), level.getName(), msg);
        if (level.display()) {
            System.out.println(sb);
        }
        if (this.writer == null) {
            return;
        }
        try {
            String sb2 = String.format("[%s] %s\r\n", DATE_FORMAT.format(new Date()), sb);
            this.writer.write(sb2);
            this.writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void debug(String msg) {
        this.log(Level.DEBUG, msg);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public void info(String format, Object ... objs) {
        this.info(String.format(format, objs));
    }

    public void warning(String msg) {
        this.log(Level.WARNING, msg);
    }

    public void warning(String format, Object ... objs) {
        this.warning(String.format(format, objs));
    }

    public void warning(Throwable e) {
        StackTraceElement[] stes;
        this.log(Level.WARNING, "Exception: " + e.toString());
        for (StackTraceElement ste : stes = e.getStackTrace()) {
            this.log(Level.WARNING, ste.toString());
        }
    }

    public static enum Level {
        DEBUG("DEBUG", false),
        INFO("INFO", true),
        WARNING("WARNING", true);

        String name;
        boolean display;

        private Level(String name, boolean display) {
            this.name = name;
            this.display = display;
        }

        public String getName() {
            return this.name;
        }

        public boolean display() {
            return this.display;
        }
    }
}

