/*
 * Decompiled with CFR 0.152.
 */
package idv.jlchntoz;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;

public class MainLogger {
    private static final int LOWEST_DISPLAY_LEVEL = Level.INFO.intValue();
    SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private BufferedWriter writer;

    public MainLogger(File logFile) {
        try {
            if (!logFile.getParentFile().exists()) {
                logFile.getParentFile().mkdirs();
            }
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(logFile), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void log(Level level, String msg) {
        if (level.intValue() >= LOWEST_DISPLAY_LEVEL) {
            System.out.println(msg);
        }
        try {
            this.writer.write("[");
            this.writer.write(this.DATE_FORMAT.format(new Date()));
            this.writer.write(" ");
            this.writer.write(Thread.currentThread().getName());
            this.writer.write(" ");
            this.writer.write(level.getName());
            this.writer.write("] ");
            this.writer.write(msg);
            this.writer.write("\r\n");
            this.writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public void warning(String msg) {
        this.log(Level.WARNING, msg);
    }

    public void warning(Exception e) {
        StackTraceElement[] stes;
        this.log(Level.WARNING, "Exception occurs while running: " + e.getMessage());
        for (StackTraceElement ste : stes = e.getStackTrace()) {
            this.log(Level.WARNING, ste.toString());
        }
        this.log(Level.WARNING, "");
    }
}

